;	--------------------------------------
;	Makro fr Hallengenerator-Modul
;	muss mit dem Hallengenerator-Modul zusammen ausgeliefert werden
;	erfordert  hg_fundament_defaults.lsp im Config-Verzeichnis
(defun load-modules ()
   (load "mod-endinit-stz-fund")
)

(defun init-connection ()
  (print "********************************************************************")
  (print "in init-connection - fundSimple1 - Sttze auf Fundament");

;	(connect.ShowAttributes CastaData)
	
  ;(print Aufl_ID)
  ;(setq dOK (koecher.get Aufl_ID delta_V))		(print dOK)	; vertikale Verschiebung
  ;(setq dLR (koecher.get Aufl_ID delta_LR))		(print dLR)	; horizontale Verschiebung
 
 	(secure_defaults)
 	(loadConfig "hg_fundament_defaults.lsp")	; Default Werte einladen

  
	(init-stzfund)
	(init-traegerende)
   
	(setq fussPl	(Blech.create))
	(Connect.storeAnschlObjs CastaData fussPl)
	
	(createFussplatte fussPl)

	(setq AnkerLchb (Lochbild.create))
	(Connect.storeAnschlObjs CastaData AnkerLchb)
	(setAnkerlochbild  AnkerLchb fussPl)
  ;(printv)
  
  
  ; CALLBACKS
  (Blech.set fussPl (formFkt "cb_fussPl"))
)


; ========================================================================================
; CALLBACK-FUNKTIONEN
; ========================================================================================

; ----------------------------------------------------------------------------------------
; Callback fr Fussplatte am HT
; ----------------------------------------------------------------------------------------
(defun cb_fussPl (zp)
	(print "in Callback-Funktion cb_fussPl")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dpAlt (Blech.get fussPl dp))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq dpNeu (Blech.get fussPl dp))
	    
	    (print dpAlt) (print dpNeu)
	    
	    (if (/= dpAlt dpNeu) (progn
		    (setq dpDiff (- dpNeu dpAlt))
		    (setq alteKlemml (Lochbild.get AnkerLchb Klemml))
		    (setq dxsKopf_alt	(Lochbild.get AnkerLchb dxSKopf))
		       
		    (Lochbild.set AnkerLchb 	(Klemml (+ alteKlemml dpDiff))
		    													;(dxSKopf (+ dxsKopf_alt dpDiff))
		    )  
		       
	    ))
	))
)


; ----------------------------------------------------------------------------------------
; ERZEUGT DIE FUSSPLATTE
; ----------------------------------------------------------------------------------------
(defun createFussplatte (fussPl)
	
	(setq	h_stz (Traeger.get Tr_ID h)
		b_stz	(Traeger.get Tr_ID b)
	)
	
	; berstand der Fussplatte an jeder Seite
	(setq ueb 50)
	
	(if (= (Connect.get CastaData LinkesEnde) 1)
		(setq TrgEnde (Traeger.get Tr_ID links))
	)
	(if (= (Connect.get CastaData RechtesEnde) 1)
		(setq TrgEnde (Traeger.get Tr_ID rechts))
	)
	
	; Hhe, Breite, Dicke der Fussplatte
	(setq hp_fpl (+ h_stz (* 2.0 ueb)))
	(setq bp_fpl (+ b_stz (* 2.0 ueb)))
	(setq dp_fpl dp_Fussplatte)			; Wert aus Modul gesetzt
	(setq dok_fpl (- ueb))
	
	(Blech.set fussPl 
			(hp 	hp_fpl)
			(bp 	bp_fpl)
			(dp 	dp_fpl)										
	)
	;(Blech.set fussPl (hp 400) (bp 400) (dp 20))
	(print _fussplattelinks_)
	
	(setq SchubProfil (Traeger.create))
	(Traeger.set SchubProfil	(Profil "I200")
		     			(Laenge	  350)
		     			(syslng	  350)
	)
	(Connect.storeAnschlObjs CastaData SchubProfil)
	
	(if (= (Connect.get CastaData LinkesEnde) 1)
		(Traeger.addabtl Tr_ID fussPl 0.0 0.0 _fussplattelinks_ SchubProfil)
	)
	(if (= (Connect.get CastaData RechtesEnde) 1)
		(Traeger.addabtl Tr_ID fussPl 0.0 0.0 _fussplatterechts_ SchubProfil)
	)

	; Schweinahtdicken eintragen
	(setq Abtl_Fp (Traeger.get Tr_ID AbTeil fussPl))
	(Anbauteil.set Abtl_Fp	(SWN_flansch 	swn_Dicke_Fl)
				(SWN_steg  	swn_Dicke_St)
	)

	
	(TrEnde.ptrim TrgEnde dp_fpl)
				
)

(defun setAnkerlochbild  (AnkerLchb BlechID)
	(print "setze Daten fr  das Ankerlochbild")
	
	(print AnkerLchb)

	(Lochbild.set AnkerLchb
		(S_Bez   SBez_Anker)			; aus Modul gesetzt
		(Guete   "4.6")
		(e       "200 0 0 0 0 0")
		(w       "200  0")
		(Laenge  350)
	)
	
	(setq	h_at 	(Traeger.get Tr_ID h)
		b_at	(Traeger.get Tr_ID b)
		s_at	(Traeger.get Tr_ID s)
		r_at	(Traeger.get Tr_ID r)
	)
	
	(setq dschr (Lochbild.get AnkerLchb sdurchm))
	(setq e_min (* 2.0 dschr))
	
	(setq e0 (+ h_at (* 2.0 e_min)))
	
	(setq helpVar (+ (* 2.0 r_at) (* 0.5 (- b_at s_at))))
	(setq w0 helpVar)

	(setq w0	 w_AnkerSchr)			; aus Modul gesetzt

	
	(Lochbild.set AnkerLchb	(Lb_Art   16)
    				(anz_s 		4)
    				(Montage 	_AnkerSchraube_)
    				(e0		e0)
    				(w0		w0)
  )


	(if (= (Connect.get CastaData linkesEnde) 1)
		(Traeger.addabtl Tr_ID AnkerLchb 0.0 0.0 _kpllochbildlinks_)
	)
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(Traeger.addabtl Tr_ID AnkerLchb 0.0 0.0 _kpllochbildrechts_)
	)

  (setq Abtl_AnkLchb (traeger.get Tr_ID ABTeil AnkerLchb))
  (Anbauteil.set Abtl_AnkLchb (Master 1))

	; Blechkorrektur
	(Blech.set BlechID (hp (+ h_at (* 4.0 e_min))))
    
)

(defun secure_defaults ()
	(setq dp_Fussplatte 25)
	(setq w_AnkerSchr 80)
	(setq SBez_Anker "M24")
)
