; $	HT	QT(I)		AF(F)		P(EZ)
; $ 	AT	QT(IU)		AF(K)		P(E)
; $	AE	V(-)		H(90)		R(0)

;	--------------------------------------
;	Makro fr Hallengenerator-Modul
;	muss mit dem Hallengenerator-Modul zusammen ausgeliefert werden
;	erfordert  hg_rahmenecke_defaults.lsp im Config-Verzeichnis

; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
; 
;
; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

; ----------------------------------------------------------------------------------------
; Module laden
; ---------------------------------------------------------------------------------------- 
(defun load-modules ()
   (load "mod-endinit-uz-stzflansch")
   (load "mod-multiconnect-stz-flansch")
   (load "mod-lochbild")
   (load "mod_lchb_verschiebungen")
   (load "mod-voute")
)

; ----------------------------------------------------------------------------------------
; Anschluss initialisieren (Einstieg)
; ----------------------------------------------------------------------------------------
(defun init-connection ()

	(setq rwinkel (Traeger.get Tr_ID r_winkel))

	(setq _Voute_Aus_Profil 0)
    	(setq _Vouten_Default_Laenge 1000)
		
	(if (= rwinkel 0.0)
		(progn
			(secureDefaults)
		    	(loadConfig "hg_rahmenecke_defaults.lsp")	; Letzte Werte einladen
		
			(calcAnschluss)
		)
		(progn
			(alertBox "Vouten knnen von diesem Makro nur am Unterflansch montiert werden!" "ERR_HaunchAtBottomFlangeOnly")
		)
	)
	
)
; ----------------------------------------------------------------------------------------
;	Diese Werte werden eiegntlich in der Config-Datei gesetzt, aber falls diese
;	nich vorhanden ist, sollen diese Werte als Default verwendet werden.
(defun	secureDefaults ()
	(setq Voutenlaenge 2000)
	(setq dp_Kopfplatte 20)
	(setq bp_Kopfplatte 80)
	(setq SBez_Kpl "M16")
	(setq SBez_Kpl "10.9")
	(setq w_Kpl_Schrb 60)
	(setq e0_Kpl_Schrb 30)
	(setq e1_Kpl_Schrb 50)
	(setq swn_Dicke_Fl 4)
	(setq swn_Dicke_St 4)
	(setq stz_Stf_Anz 1)
	(setq dp_stzkopf_bl 12)
)
; ----------------------------------------------------------------------------------------
; Anschlussberechnung
; ----------------------------------------------------------------------------------------
(defun calcAnschluss ()
	;(Connect.showAttributes CastaData)  
	
	; Lochbild Kontrolle (0 = AUS; 1 = EIN)
	(setq LB_DEBUG 0)
	
  (print "in init-connection uz_an_Stz-Flansch");
  (init-traegerenden)				  
  
  ; Objekte erzeugen
  (setq blKpl (blech.create))
  (setq lchbKpl (lochbild.create))
  (setq uzVoute	(Voute.create))
	(Connect.storeAnschlObjs CastaData blKpl lchbKpl uzVoute)
  		
  ; Kopfplattendicke berechnen
  (setKplDicke blKpl)
  (setKopfplDaten)
  
  ; Voutendaten berechnen
  (calcAndSetVoutenDaten_mitKpl uzVoute blKpl)
  (setVoutenDaten)
  
  ; Kopfplattendaten berechnen
  (calcAndSetBlechdaten blKpl uzVoute)
  
  ; Lochbilddaten fr die Stirnplatte des AT berechnen
  (calcAndSetLochbildDaten lchbKpl blKpl uzVoute)
  (setKopfplDaten)
  
  ; Anbauteil Kopfplatte AT hinzufgen
  (addAbtl_Kpl_AT)
  
  ; Anbauteil Lochbild AT hinzufgen
  (addAbtl_Lchb_AT)
  
  ; Lochbild erzeugen
(debug on)
  (createFlanschLochb 			lchbKpl)
(debug off)
  (calcHVerschLochbild 			lchbKpl)	; 20052009	AF
  (setzeFlanschLochbSeitenRichtung	lchbKpl)	; 20052009	AF

  ; Schweinahtdicken eintragen
  (setq Abtl_Kpl (Traeger.get Tr_ID AbTeil blKpl))
  (Anbauteil.set Abtl_Kpl	(SWN_flansch 	swn_Dicke_Fl)
				(SWN_steg  	swn_Dicke_St)
  )

  
  ; Anbauteil Voute dem AT hinzufgen
  (addAbtl_Voute_AT)
  (voute_und_kpl_Anpassen)
  ; Lochbilddaten abhngig von Voute und Profilhhe setzen
  (setLochbDaten)
  
  
  (setq dp	(Blech.get blKpl dp)
	hVoute	(Voute.get uzVoute hsteg1)
	lVoute	(Voute.get uzVoute laenge)
	t_HTrg 	(Traeger.get HTrg     t)
  )


  ; TEST FR MEHRFACHANSCHLUSS (FLANSCHSEITE)
  ; ******************************************
  (setq anzAnschl (Connect.get CastaData anz_weitere_anschl))
  (print anzAnschl)
  
  (if (/= anzAnschl 0)
  	(progn
  		(alertBox "An dem Knoten ist bereits ein Anschluss vorhanden.\nberprfen Sie bitte ggf., ob es zu berschneidungen kommt."  "WRN_CheckForCollisions")
  	)
  )
	 ; ******************************************
	 
 	; Sttzensteifen erzeugen
  (if (= stz_Stf_Anz 2)  (createStuetzenSteifen dp_stzkopf_bl hVoute 2))

  (if (= stz_Stf_Anz 1) (progn
  	(createStuetzenSteifen dp_stzkopf_bl hVoute 1)
  	(createStuetzenKpl dp_stzkopf_bl)
  ))
  
  ; Riegelsteifen erzeugen
  (createTraegerSteife lVoute)
  
  ;CALLBACK VOUTE
	(Voute.set uzVoute (formFkt "cb_uzVoute"))
	(Blech.set blKpl (formFkt "cb_KplBlech"))
 
  (LchbShowAbschlussKontrolle lchbKpl)
 
)


; ---------------------------------------------------------------------- */
; CALLBACKFUNKTIONEN
; ---------------------------------------------------------------------- */
(defun cb_uzVoute (zp)
	(print "------------------------------------------------------------")
	(print "CALLBACK")
	(print "------------------------------------------------------------")
	(print "in Callback-Funktion cb_uzVoute")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq lVouteAlt (Voute.get uzVoute laenge))
	    (setq hVouteAlt	(Voute.get uzVoute hsteg1))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq lVouteNeu (Voute.get uzVoute laenge))
	    (setq hVouteNeu	(Voute.get uzVoute hsteg1))
	    
	    (print lVouteAlt) (print lVouteNeu)
	    (print hVouteAlt) (print hVouteNeu)
	    
	    ; Lngennderung der Voute
	    (if (/= lVouteAlt lVouteNeu) (progn
			(setq lDiff (- lVouteNeu lVouteAlt))
				
			(if (objExist blTrgSteife) (progn
				(setq AbtlSteife_at (Traeger.get Tr_ID ABTeil blTrgSteife))

				(setq alteXPosSteife_at (Anbauteil.get AbtlSteife_at xPos))
			   
				(if (= (Connect.get CastaData LinkesEnde) 1)
				(setq neueXPosSteife_at (+ alteXPosSteife_at lDiff))
				)
				(if (= (Connect.get CastaData RechtesEnde) 1)
				(setq neueXPosSteife_at (- alteXPosSteife_at lDiff))
				)
				(Anbauteil.set  AbtlSteife_at (xpos neueXPosSteife_at))
			))
	    ))
	    
	    ; Hhennderung der Voute
	    (if (/= hVouteAlt hVouteNeu) (progn
	        ; Steife muss vorhanden sein - wenn gelscht, dann nicht ausfhren
		(if (objExist blSteifeUnten) (progn
		    (setq hDiff (- hVouteNeu hVouteAlt))
		    (print hDiff)
		    (setq AbtlSteife_ht (Traeger.get Htrg ABTeil blSteifeUnten))
		    
		    (if AbtlSteife_ht (progn
			    (setq alteXPosSteife_ht (Anbauteil.get AbtlSteife_ht xPos))
			    (print alteXPosSteife_ht)
			    (if (= (Connect.get CastaData vatr-lhtr)  1)
				(setq neueXPosSteife_ht (+ alteXPosSteife_ht hDiff))
			    )
			    (if (= (Connect.get CastaData vatr-lhtr) -1)
				(setq neueXPosSteife_ht (- alteXPosSteife_ht hDiff))
			    )
			
			    (print neueXPosSteife_ht)
			    (Anbauteil.set  AbtlSteife_ht (xpos neueXPosSteife_ht))
		    ))
		    (Traeger.updvollstf Htrg)
		))
	    ))
	))
)


(defun cb_KplBlech (zp)
	(print "in Callback-Funktion cb_KplBlech")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dpAlt (Blech.get blKpl dp))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq dpNeu (Blech.get blKpl dp))
	    
	    (print dpAlt) (print dpNeu)
	    
	    (if (/= dpAlt dpNeu) (progn
			(setq dpDiff (- dpNeu dpAlt))
			(setq alteKlemml (Lochbild.get lchbKpl Klemml))
			(setq altesDxS		(Lochbild.get lchbKpl dxsKopf))
	       
			(Lochbild.set lchbKpl 	(Klemml (+ alteKlemml dpDiff))
	       				(DxSKopf (+ altesDxS dpDiff))
			)
	       
			(if (objExist blTrgSteife) (progn
				(setq AbtlSteife_at (Traeger.get Tr_ID ABTeil blTrgSteife))
					   
				(setq alteXPosSteife_at (Anbauteil.get AbtlSteife_at xPos))
				   
				(if (= (Connect.get CastaData LinkesEnde) 1)
					  (setq neueXPosSteife_at (+ alteXPosSteife_at dpDiff))
				)
				(if (= (Connect.get CastaData RechtesEnde) 1)
				  (setq neueXPosSteife_at (- alteXPosSteife_at dpDiff))
				)
				
					(Anbauteil.set  AbtlSteife_at (xpos neueXPosSteife_at))
			))
	    ))
	))
)



; ---------------------------------------------------------------------- */
; Hilfsfunktionen
; ---------------------------------------------------------------------- */

; ======================================================================
(defun createStuetzenSteifen (dp_blech hVoute AnzahlStf)
	(print "ERZEUGE STTZENSTEIFEN")
	(print "------------------------------------------------------------")
	(setq blSteifeOben (blech.create))
	(setq blSteifeUnten (blech.create))
	
	(setq hProf    (Traeger.get  Tr_Id h)
	      tProf    (Traeger.get  Tr_Id t)
	      dV       (Traeger.get  Tr_Id delta_V)
	      dVStz		 (Traeger.get  Htrg  delta_v) 	
	      hStz     (Traeger.get  HTrg  h)
	      VWnkl    		(Connect.get CastaData trg_vwinkel)
	      afl_winkel	(Connect.get CastaData afl_vwinkel)
	      xPos_ht			(Connect.get CastaData xPos_ht)
	)
	
	; setzen der Steifendicken
	(setq tProf_rund (runde tProf auf 5))
	(Blech.set blSteifeOben  (dp dp_blech))
	(Blech.set blSteifeUnten (dp dp_blech))
	
	(setq sinAW (sin (/ (* PI afl_winkel) 180.0)))		(print sinAW)
	(setq cosAW (cos (/ (* PI afl_winkel) 180.0)))
	(setq tanAW (tan (/ (* PI afl_winkel) 180.0)))
	(if (< tanAW 0.0)
		(setq tanAW (- tanAW))
	)
	
	(if (= (Connect.get CastaData linkesEnde) 1)
		(setq TrgEnde (Traeger.get Tr_ID links))
	)
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(setq TrgEnde (Traeger.get Tr_ID rechts))
	)
	
	(setq vschl (TrEnde.get TrgEnde vscherl))
	(setq vscherl_halb (* 0.5 vschl))
	
	
	; Anteil AT-Neigung (nur fr untere Steife)
	(setq hStz_halb (* 0.5 hStz))
	(setq helpVar (/ hStz_halb tanAW))
	(print helpVar)
	(setq xPos_neig 0)
	(if (= (Connect.get CastaData vatr-lhtr) -1)
		(progn
			(if (< afl_winkel 90.0)
				(setq xPos_neig (- vscherl_halb helpVar))
				(setq xPos_neig (+ vscherl_halb helpVar))
			)
		)
	)
	(if (= (Connect.get CastaData vatr-lhtr)  1)
		(progn
			(if (< afl_winkel 90.0)
				(setq xPos_neig (+ vscherl_halb helpVar))
				(setq xPos_neig (- vscherl_halb helpVar))
			)
		)
	)
	(print xPos_neig)
	
	; Obere Steife um halbe Dicke nach unten schieben
	(setq dp_steife_oben (Blech.get blSteifeOben dp))
	(print dp_steife_oben)
	(setq xPos_dp (/ (* 0.5 dp_steife_oben) sinAW))
	
	; xPos setzen
	(if (= (Connect.get CastaData vatr-lhtr) -1)
		(progn
			(setq xPosOben (+ xPos_ht vscherl_halb (- xPos_dp)))
			(setq xPosUnten (- xPos_ht xPos_neig hVoute))
		)
	)
	(if (= (Connect.get CastaData vatr-lhtr) 1)
		(progn
			(setq xPosOben (- xPos_ht vscherl_halb (- xPos_dp)))
			(setq xPosUnten (+ xPos_ht xPos_neig hVoute))
		)
	)

	; Winkel der oberen Steife ermitteln
	(setq stf_winkel (- 90.0 afl_winkel))
	(print stf_winkel)
	(if (= (Connect.get CastaData amHtOberflansch) 1)
		(setq stf_winkel (- stf_winkel))
	)
	(print stf_winkel)
	
	; BIS HIER NUR BERECHNUNGEN, WENN TRGER AUF SYSTEMLINIE
	;
	; --> AB HIER VERSCHIEBUNGEN EINBAUEN
	
	; Anteil Verschiebung delta_v des AT
	(setq xPos_dv_at (/ dv sinAW))
	
	(if (= (Connect.get CastaData vatr-lhtr) -1)
		(progn
			(setq xPosOben (- xPosOben xPos_dv_at))
			(setq xPosUnten (- xPosUnten xPos_dv_at))
		)
	)
	(if (= (Connect.get CastaData vatr-lhtr) 1)
		(progn
			(setq xPosOben (+ xPosOben xPos_dv_at))
			(setq xPosUnten (+ xPosUnten xPos_dv_at))
		)
	)
	
	; Anteil Verschiebung delta_v des HT
	(setq dv_HT (/ dVStz tanAW))
	(print dv_HT)
  (if (= (Connect.get CastaData amHTUnterflansch) 1)
  	(setq dv_HT (- dv_HT))
  )
	
	(if (= (Connect.get CastaData vatr-lhtr) -1)
		(progn
			(if (< afl_winkel 90.0)
				(progn
					(setq xPosOben (- xPosOben dv_HT))
					(setq xPosUnten (- xPosUnten dv_HT))
				)
				(progn
					(setq xPosOben (+ xPosOben dv_HT))
					(setq xPosUnten (+ xPosUnten dv_HT))
				)
			)
		)
	)
	(if (= (Connect.get CastaData vatr-lhtr) 1)
		(progn
			(if (< afl_winkel 90.0)
				(progn
					(setq xPosOben (- xPosOben dv_HT))
					(setq xPosUnten (- xPosUnten dv_HT))
				)
				(progn
					(setq xPosOben (+ xPosOben dv_HT))
					(setq xPosUnten (+ xPosUnten dv_HT))
				)
			)
		)
	)
	
	; ANBAU
	
	; Optional nur ein Stefie anbringen, weil obe als Deckel eine Kopflplatte eingesetzt
	; wird.
	(if (= AnzahlStf 2) (progn
		; Auf Steifen am HT prfen
		(checkForSteifeAtPosition xPosOben 100 Htrg)
		(if (= ABTL_VORH 0)
			(checkForKplAtPosition xPosOben 100 Htrg)
		)
		(if (= ABTL_VORH 0)
			(progn
				(traeger.addabtl Htrg blSteifeOben 0.0 0.0 _vollsteife_beids_)  ;1539
				(setq AbtlSteife (traeger.get Htrg ABTeil blSteifeOben))
				(Anbauteil.set  AbtlSteife (xpos xPosOben) (winkel stf_winkel))
				(Connect.storeAnschlObjs CastaData blSteifeOben)
			)
		)
	))
	
	; Auf Steifen am HT prfen
	(checkForSteifeAtPosition xPosUnten 100 Htrg)
	(if (= ABTL_VORH 0)
		(checkForKplAtPosition xPosUnten 100 Htrg)
	)
	(if (= ABTL_VORH 0)
		(progn
			(traeger.addabtl Htrg blSteifeUnten 0.0 0.0 _vollsteife_beids_)  ;1539
			(setq AbtlSteife (traeger.get Htrg ABTeil blSteifeUnten))
			(Anbauteil.set  AbtlSteife (xpos xPosUnten))
			(Connect.storeAnschlObjs CastaData blSteifeUnten)
		)
	)

	; Das kann so nicht bleiben, weil andere Steifen nicht gendert
	; werden sollen!
	(Traeger.updvollstf Htrg)
	(print "ENDE STTZENSTEIFEN")
)




(defun createTraegerSteife (lVoute / hTrg)

	(print "in createTraegerSteife")
	(setq blTrgSteife (blech.create))
	(Connect.storeAnschlObjs CastaData blTrgSteife)
	(Blech.set blTrgSteife (dp 10))
	
  	(if (= (connect.get CastaData LinkesEnde) 1) (progn
  	    (setq TrLinks   (traeger.get tr_id links))
  	    (setq delta_L (TrEnde.get TrLinks delta_l)
  	    	  EWnkl   (TrEnde.get TrLinks V_Winkel)
  	    	  VWnkl   (- EWnkl 90.0)
  	    	  hTrg    (Traeger.get Tr_ID h)				; Achtung - hTrg ist eigentlich der HT
  	    )								; als lokale Variable derklariert AF - Mai 2009
  	    (setq dV (* 0.5 hTrg (tan (/ (* PI VWnkl) 180.0))))
  	    (print dV)
	    (setq xPosTraeger (+ lVoute delta_L dV))
  	))
  	(if (= (connect.get CastaData RechtesEnde) 1) 
  	(progn
  		(setq TrRechts  (traeger.get tr_id rechts))
  	  (setq delta_L (TrEnde.get TrRechts delta_l)
  	  	EWnkl   (TrEnde.get TrRechts V_Winkel)
  	    	 VWnkl   (- 90.0 EWnkl )
  	    	 hTrg    (Traeger.get Tr_ID h)
  	  )
  	  (print EWnkl)
  	  (print VWnkl)
  	  (setq dV (* 0.5 hTrg (tan (/ (* PI VWnkl) 180.0))))
  	  (print dV)
  	  (setq TrgLaenge (Traeger.get Tr_ID SysLng))
			(setq xPosTraeger (- TrgLaenge lVoute delta_L dV))
  	)
  )


	(traeger.addabtl Tr_ID blTrgSteife 0.0 0.0 _vollsteife_beids_);1539
	(setq AbtlSteife (traeger.get Tr_ID ABTeil blTrgSteife))
	(Anbauteil.set  AbtlSteife (xpos xPosTraeger) (Winkel 0.0))

	; Auch nur Behelfslsung (siehe oben)
	(Traeger.updvollstf Tr_ID)

)


(defun setVoutenDaten ()
   (Voute.set uzVoute (Laenge VoutenLaenge))
)
(defun setKopfplDaten ()
    (Blech.set	blKpl 
    	(dp dp_Kopfplatte)
    	(bp bp_Kopfplatte)
    )
)
(defun setLochbDaten ()
 
   (setq hScher (Traeger.get Tr_ID h))
   (setq hVoute (Voute.get uzVoute hSteg1))
   
   (if (= (connect.get CastaData LinkesEnde) 1) (progn
      (setq  trgEnde (Traeger.get Tr_ID links))
      (setq  hScher  (TrEnde.get trgEnde vscherl))
   ))
   (if (= (connect.get CastaData RechtesEnde) 1) (progn
      (setq  trgEnde (Traeger.get Tr_ID rechts))
      (setq  hScher  (TrEnde.get trgEnde vscherl))
   ))
   (setq e_Abstand (- (+ hScher  hVoute) (* 2 (+ e0_Kpl_Schrb e1_Kpl_Schrb))))

	(Lochbild.set  lchbKpl 
    	(S_Bez	SBez_Kpl)
    	(Guete	SGuete_Kpl)
    	(w0	w_Kpl_Schrb)
    	(e0	e0_Kpl_Schrb)
    	(e1	e1_Kpl_Schrb)
    	(e2	e_Abstand)		;; berechnet aus Profilhhe und Voutenhhe
    	(e3	e1_Kpl_Schrb)
    )
)

(defun voute_und_kpl_Anpassen ()
   (setq vProfil (Traeger.get Tr_ID Profil))
   (Voute.set  uzVoute (Profil vProfil))
   
   (setq hScher (Traeger.get Tr_ID h))
   (setq hVoute (Voute.get uzVoute hSteg1))
   (setq dOK    (Blech.get blKpl dOK))
   (setq dUK    dOK)
   
   (if (= (connect.get CastaData LinkesEnde) 1) (progn
      (setq  trgEnde (Traeger.get Tr_ID links))
      (setq  hScher  (TrEnde.get trgEnde vscherl))
   ))
   (if (= (connect.get CastaData RechtesEnde) 1) (progn
      (setq  trgEnde (Traeger.get Tr_ID rechts))
      (setq  hScher  (TrEnde.get trgEnde vscherl))
   ))
   
   
   
   (Blech.set blKpl (hp (+ hVoute hScher 40)))

)

(defun	createStuetzenKpl (dp)

	; Kopfplatte am Haupttrger
	(setq blkplHTOben (blech.create))
	(Connect.storeAnschlObjs CastaData blkplHTOben)

	; rechtes Ende am Haupttrger
	(if (= (connect.get CastaData anHtRechtesEnde) 1) 
	  	(progn
	  	  (print "Kopfplatte rechts am Haupttrger")
		    (calcAndSetBlechdatenKplHT blkplHTOben HTrRechts dp 0)
		    (traeger.addabtl Htrg blkplHTOben 0.0 0.0 _kopfplatterechts_)
	  	)
	)
	; linkes Ende am Haupttrger
	(if (= (connect.get CastaData anHtLinkesEnde) 1) 
	  	(progn
	  	  (print "Kopfplatte links am Haupttrger")
		    (calcAndSetBlechdatenKplHT blkplHTOben HTrLinks dp 0)
		    (traeger.addabtl Htrg blkplHTOben 0.0 0.0 _kopfplattelinks_)
	  	)
	)


)


; ********************************************************************************
; Erzeugt u. berechnet die Blechdaten fr die Kopfplatte
; ********************************************************************************
(defun calcAndSetBlechdatenKplHT (blKopfplatte TrgEnde dp kplVerl)

   (print "---------------- calcAndSetBlechdatenKplHT -------------------------------")

   (setq hProf (Traeger.get HTrg h))		; Hhe des Haupttrgerprofils

   (setq hp  hProf)				; erstmal so voreinstellen
   (setq bp  (Traeger.get Htrg b))		; Breite
   
   
   (setq schwKante 0)				
   
   (if (= (connect.get CastaData amHtUnterFlansch) 1) 
   (progn
   	(setq dOK schwKante)
   ))
   (if (= (connect.get CastaData amHtOberFlansch) 1)
   (progn
   	(setq vers (+ kplverl schwKante)) 
   	(setq dOK (- vers))
   ))
   
   
   (setq EWinkel (TrEnde.get TrgEnde V_Winkel))
   (print EWinkel)
        							
   								
   (setq hp (+ hp  kplverl))	
   (setq sinW (sin (* PI (/ EWinkel 180.0))))
	
   (if (/= sinW 0) (setq hp (/ hp sinW)))
        
   
   (Blech.set blKopfplatte (dp dp) (hp hp) (bp bp) (dOK dOK))

   (setq htDeltaV (Traeger.get hTrg delta_V))


    (setq delta_L dp)
    (if (> vwnkl_aflch 180) (setq delta_L (- delta_L)))
    	
    (print dp)							(print delta_L)
    
		(TrEnde.ptrim TrgEnde dp)
    (print "---------------- ENDE -------------------------------")
)
