(defun load-modules ()
   (load "mod-endinit-vertikalStoss")
)


(defun init-connection ()

  (print "in init-connection - uz_uz_kpl_stoss *neu*");
  (init-traegerenden)				; hier werden die Traegerenden gestutzt
						; eventuell spter alte Werte merken,
						; falls Ende schon bearbeitet wurde.

; ---------- Kopfplatten und Lochbild hinzufgen
    (setq kplLochbild (Lochbild.create))
    (setq kplHtrg     (Blech.create))
    (setq kplTrg      (Blech.create))
    
    (Connect.storeAnschlObjs CastaData kplLochbild kplHtrg kplTrg)
    
    (calcAndSetLochbildDaten_1 kplLochbild kplHtrg kplTrg)
    
    (if (= (connect.get CastaData linkesEnde) 1)
        (createBuendigeKpl Tr_ID kplTrg kplLochbild 20 10 1)
    )
    (if (= (connect.get CastaData rechtesEnde) 1)
        (createBuendigeKpl Tr_ID kplTrg kplLochbild 20 10 -1)
    )

    (if (= (connect.get CastaData anHtLinkesEnde) 1) 
        (createBuendigeKpl HTrg kplHTrg kplLochbild 20 10  1)
    )
    (if (= (connect.get CastaData anHtRechtesEnde) 1) 
        (createBuendigeKpl HTrg kplHTrg kplLochbild 20 10 -1)
    )

  
)
; ---------------------------------------------------------------------- 
(defun createBuendigeKpl (Trg blKopfpl lchbKpl dp ueb li_re)
    (if (= li_re  1) (setq TrgEnde (Traeger.get Trg links)))
    (if (= li_re -1) (setq TrgEnde (Traeger.get Trg rechts)))
    
    (setq ueb 0)	;; nur zum Testen - Kopfplattenposition zum Traeger
    
    (setq EWnkl  (TrEnde.get TrgEnde V_Winkel)
          alfa   (- EWnkl 90.0)
          hProf  (Traeger.get Trg h)
          cosW   (cos (* PI (/ alfa 180.0)))
          hNetto hProf
    )
    (if (/= cosW 0) (setq hNetto (/ hProf cosW)))

    (setq  hp     (+ hNetto ueb ueb))

    
    (Blech.set blKopfpl
         (dp    dp)
         (bp    100)
         (hp    hp)
         (dOK   (- ueb))
    )
    
    (if (= li_re  1) (traeger.addabtl Trg blKopfpl 0.0 0.0 _kopfplattelinks_))
    (if (= li_re -1) (traeger.addabtl Trg blKopfpl 0.0 0.0 _kopfplatterechts_))

    (if (= li_re  1) (traeger.addabtl Trg lchbKpl 0.0 0.0 _kpllochbildlinks_))
    (if (= li_re -1) (traeger.addabtl Trg lchbKpl 0.0 0.0 _kpllochbildrechts_))
   
    (TrEnde.pTrim TrgEnde dp)

)
; ---------------------------------------------------------------------- 
(defun calcAndSetLochbildDaten_1 (Lchb_ID BlechHT BlechAT)
	(Lochbild.set Lchb_ID 
		(S_Bez   "M20")
		(Guete   "4.6")
;		(e       "-1 1 60 0 0 0")
		(e       "60 60 0 0 0 0")
		(w       "80  0")

	)
	
	(setq dp_blechHT (Blech.get BlechHT dp))
	(setq dp_blechAT (Blech.get BlechAT dp))
	
	(Lochbild.set Lchb_ID (klemml (+ dp_blechHT dp_blechaT)))
)
; ---------------------------------------------------------------------- 
