; $	HT	QT(IU)	AF(K)		P(E)
; $	AT	QT(IU)	AF(K)		P(E)
; $	AE	V(-)		H(-)		R(-)

(defun load-modules ()
   (load "mod-endinit-vertikalStoss")
)


(defun init-connection ()

  (print "in init-connection - uz_uz_kpl_stoss bndige Kopfplatte");

;  (connect.ShowAttributes CastaData)

  (init-traegerenden)				; hier werden die Traegerenden gestutzt
						; eventuell spter alte Werte merken,
						; falls Ende schon bearbeitet wurde.



; ---------- Kopfplatten und Lochbild hinzufgen
    
  (setq kplHtrg     (Blech.create))
  (Connect.storeAnschlObjs CastaData kplHtrg)
    
  (berechneTraegerUnterschiede)
    
  (createKpl kplHtrg)
    
	
  ; CALLBACKS
  (Blech.set kplHtrg (formFkt "cb_kplHtrg"))

)


; ========================================================================================
; CALLBACK-FUNKTIONEN
; ========================================================================================

; ----------------------------------------------------------------------------------------
; Callback fr Kopfplatte am HT
; ----------------------------------------------------------------------------------------
(defun cb_kplHtrg (zp)
	(print "in Callback-Funktion cb_kplHtrg")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dpAlt (Blech.get kplHtrg dp))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq dpNeu (Blech.get kplHtrg dp))
	    
	    (print dpAlt) (print dpNeu)
	    
	    (if (/= dpAlt dpNeu) (progn
	    	(setq dpDiff (- dpNeu dpAlt))
	      (print dpDiff)
				
	    	(if (= (Connect.get CastaData anHtLinkesEnde) 1)
	    		(setq HT_Ende (Traeger.get Htrg links))
	    	)
	    	(if (= (Connect.get CastaData anHtRechtesEnde) 1)
	    		(setq HT_Ende (Traeger.get Htrg rechts))
	    	)       
	    	
	    	(TrEnde.ptrim HT_Ende (- (* 0.5 dpDiff)))
	       
	       
	      (if (= (Connect.get CastaData LinkesEnde) 1)
	    		(setq AT_Ende (Traeger.get Tr_ID links))
	    	)
	    	(if (= (Connect.get CastaData RechtesEnde) 1)
	    		(setq AT_Ende (Traeger.get Tr_ID rechts))
	    	)       
	    	
	    	(TrEnde.ptrim AT_Ende (* 0.5 dpDiff))
	      
	    ))
	))
)

; ----------------------------------------------------------------------------------------
; ERZEUGT DIE KOPFPLATTE
; ----------------------------------------------------------------------------------------
(defun createKpl (BLECHID)
	(print "------------------------------------------------------------")
	(print "ERZEUGE KOPFPLATTE")
	
	(setq schweisskante 5)
	
	; magebenden Trger ermitteln (hier der grere)
	(setq h_at 				(Traeger.get Tr_ID h)
				b_at				(Traeger.get Tr_ID b)
				delta_v_at	(Traeger.get Tr_ID delta_v)
				qsform_at		(Traeger.get Tr_ID qsform)
	)
	(setq h_ht				(Traeger.get Htrg h)
				b_ht				(Traeger.get Htrg b)
				delta_v_ht	(Traeger.get Htrg delta_v)
	)
	
	(if (= (Connect.get CastaData linkesEnde) 1)
		(setq TrgEnde_at (Traeger.get Tr_ID links))
	)
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(setq TrgEnde_at (Traeger.get Tr_ID rechts))
	)
	(if (= (Connect.get CastaData anHtlinkesEnde) 1)
		(setq TrgEnde_ht (Traeger.get Htrg links))
	)
	(if (= (Connect.get CastaData anHtrechtesEnde) 1)
		(setq TrgEnde_ht (Traeger.get Htrg rechts))
	)
	
	(setq at_scherl 	(TrEnde.get TrgEnde_at vscherl))
	(setq ht_scherl		(TrEnde.get TrgEnde_ht vscherl))
	
	(if (< at_scherl ht_scherl)
		(progn
			(setq h_prof_mass ht_scherl)
			(setq h_prof at_scherl)
		)
		(progn
			(setq h_prof_mass at_scherl)
			(setq h_prof ht_scherl)
		)
	)
	
	
	
	; Blechhhe
	(setq hp_blech (- maxDiff (* 2.0 schweisskante)))
	
	; Blechbreite
	(if (< b_at b_ht)
		(setq b_prof_mass b_at)
		(setq b_prof_mass b_ht)
	)
	(setq bp_blech b_prof_mass)
	
	; Blechdicke
	(setq dp_blech 15)
	
	; Abstand der Flanschkanten (Lngenunterschied der halben Profilhhen)
	
	
	
	
	; dok
	(setq dok_blech 0)
	
	(print oKante_ht)
	(print oKante_at)
	
	(if (> oKante_ht oKante_at)
		(setq dok_blech (- schweisskante diff_oben))
		(setq dok_blech schweisskante)
	)
	
	
	(print dok_blech)
	
	(Blech.set BLECHID 	(hp 	hp_blech)
											(bp	 	bp_blech)
											(dp 	dp_blech)
											(dok	dok_blech)
	)
	
	(if (= qsform_at "U")
		(progn
			(Blech.set BLECHID 	(delta_lr 	(* 0.5 bp_blech)))
		)
	)
	
	(if (= (Connect.get CastaData anHtLinkesEnde) 1)
		(progn
			(Traeger.addabtl Htrg BLECHID 0.0 0.0 _kopfplattelinks_)
		)
	)
	(if (= (Connect.get CastaData anHtRechtesEnde) 1)
		(progn
			(Traeger.addabtl Htrg BLECHID 0.0 0.0 _kopfplatterechts_)
		)
	)
	
	; Trimme Trgerenden
	(if (= (Connect.get CastaData anHtLinkesEnde) 1)
		(progn
			(setq HtrgEnde (Traeger.get Htrg links))
		)
	)
	(if (= (Connect.get CastaData anHtRechtesEnde) 1)
		(progn
			(setq HtrgEnde (Traeger.get Htrg rechts))
		)
	)
	
	(TrEnde.ptrim HtrgEnde (* 0.5 dp_blech))
	
	(if (= (Connect.get CastaData linkesEnde) 1)
		(progn
			(setq TrgEnde (Traeger.get Tr_ID links))
		)
	)
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(progn
			(setq TrgEnde (Traeger.get Tr_ID rechts))
		)
	)
	(TrEnde.ptrim TrgEnde (* 0.5 dp_blech))
	(print "------------------------------------------------------------")
)


; ----------------------------------------------------------------------------------------
; Berechnet folgende Werte bei unterschiedlichen Trgern
;
; Die Werte beziehen sich auf die Achse der Kontaktflche, also entlang der Schnittflche
;
;	diff_oben:		Abstand der oberen Flanschkanten zueinander
;	diff_unten:		Abstand der unteren Flanschkanten zueinander
;	maxDiff:			Maximale Ausdehnung von obersten zur untersten Flanschkante
; max_oKante:		Maximalwert fr den obersten Flansch
; max_uKante:		Maximalwert fr den untersten Flansch
;	oKante_ht
; oKante_at
; uKante_ht
; uKante_at
;
; ----------------------------------------------------------------------------------------
(defun berechneTraegerUnterschiede ()
	(print ">-----------------------------------------------------------")
	(print "BERECHNE TRGERUNTERSCHIEDE")
	
	(setq h_kpl_ht 	(Blech.get kplHtrg hp)
				dp_kpl_ht	(Blech.get kplHtrg dp)
	)
	(setq h_kpl_at 	(Blech.get kplHtrg hp)
				dp_kpl_at	(Blech.get kplHtrg dp)
	)
	
	(setq h_ht 				(Traeger.get Htrg h)
				delta_v_ht	(Traeger.get Htrg delta_v)
				rwinkel_ht	(Traeger.get Htrg r_winkel)
	)
	
	(setq h_at				(Traeger.get Tr_ID h)
				delta_v_at	(Traeger.get Tr_ID delta_v)
				rwinkel_at	(Traeger.get Tr_ID r_winkel)
	)
	
	(setq rwinkel_ht_rot (+ rwinkel_ht 180.0))
	
	(if (= rwinkel_at rwinkel_ht_rot)
		(setq delta_v_at (- delta_v_at))
	)
	
	(if (= (Connect.get CastaData linkesEnde) 1)	(setq TrgEnde_AT (Traeger.get Tr_ID links)))
	(if (= (Connect.get CastaData rechtesEnde) 1)	(setq TrgEnde_AT (Traeger.get Tr_ID rechts)))
	(if (= (Connect.get CastaData anHtLinkesEnde) 1)	(setq TrgEnde_HT (Traeger.get Htrg links)))
	(if (= (Connect.get CastaData anHtRechtesEnde) 1)	(setq TrgEnde_HT (Traeger.get Htrg rechts)))
	
	(setq vscherl_at 	(TrEnde.get TrgEnde_AT vscherl)		
				vwinkel_at	(TrEnde.get TrgEnde_AT v_winkel)
	)
	(setq vscherl_ht 	(TrEnde.get TrgEnde_HT vscherl)
				vwinkel_ht	(TrEnde.get TrgEnde_HT v_winkel)
	)
	
	(print vscherl_at)
	(print vscherl_ht)
	
	(print vwinkel_at)
	(print vwinkel_ht)
	
	(setq winkel_ht (- 90.0 vwinkel_ht))
	(setq winkel_at (- vwinkel_at 90.0))
	
	(print winkel_at)
	(print winkel_ht)
	
	(if (< winkel_ht 0.0)
		(setq winkel_ht (- winkel_ht))
	)
	(if (< winkel_at 0.0)
		(setq winkel_at (- winkel_at))
	)
	(print winkel_at)
	(print winkel_ht)
	
	(setq tanVW_at	(tan (/ (* PI winkel_at) 180.0)))
	(setq tanVW_ht	(tan (/ (* PI winkel_ht) 180.0)))
	(setq cosVW_at	(cos (/ (* PI winkel_at) 180.0)))
	(setq cosVW_ht	(cos (/ (* PI winkel_ht) 180.0)))
	(print tanVW_ht)
	(print tanVW_at)
	(print cosVW_ht)
	(print cosVW_at)
	
	; Anteil der Kopfplattendicke
	(setq anteil_kpl_ht (* dp_kpl_ht tanVW_ht))
	(setq anteil_kpl_at (* dp_kpl_at tanVW_at))
	
	(print anteil_kpl_ht)
	(print anteil_kpl_at)
		
	(if (< vscherl_at vscherl_ht)
		(progn
			(setq h_prof_mass vscherl_ht)			
			(setq h_prof vscherl_at)
			(setq isHtrg 1)
			(Blech.set kplHtrg (hp h_kpl_ht))
		)
		(progn
			(setq h_prof_mass vscherl_at)
			(setq h_prof vscherl_ht)
			(setq isHtrg 0)
			(Blech.set kplHtrg (hp h_kpl_at))
		)
	)
	
	
	(setq vscherl_at_halb (* 0.5 vscherl_at))
	(setq vscherl_ht_halb (* 0.5 vscherl_ht))
	
	(setq delta_v_ht_scher (/ delta_v_ht cosVW_ht))
	(setq delta_v_at_scher (/ delta_v_at cosVW_at))
	
	(print delta_v_ht_scher)
	(print delta_v_at_scher)
	
	; Oberkante der Trger
	(setq oKante_ht (- delta_v_ht_scher vscherl_ht_halb))				(print oKante_ht)
	(setq uKante_ht (+ oKante_ht vscherl_ht))										(print uKante_ht)
	(setq oKante_at	(- delta_v_at_scher vscherl_at_halb))				(print oKante_at)
	(setq uKante_at (+ oKante_at vscherl_at))										(print uKante_at)
		
	(print "-----------------------------------")
	
	; Anteil der Kopfplatte hinzurechnen
	(setq oKante_ht (+ oKante_ht anteil_kpl_ht))								(print oKante_ht)
	(setq uKante_ht (+ uKante_ht anteil_kpl_ht))								(print uKante_ht)
	(setq oKante_at	(+ oKante_at anteil_kpl_at))								(print oKante_at)
	(setq uKante_at (+ uKante_at anteil_kpl_at))								(print uKante_at)
	
	; Differenz oben
	(if (< oKante_ht oKante_at)
		(setq diff_oben (- oKante_at oKante_ht))
		(setq diff_oben (- oKante_ht oKante_at))
	)
	(print diff_oben)
	
  ; Differenz unten
	(if (< uKante_ht uKante_at)
		(setq diff_unten (- uKante_at uKante_ht))
		(setq diff_unten (- uKante_ht uKante_at))
	)
	(print diff_unten)
	
	; Maximal- / Minimalwerte ermitteln (okante / ukante)
	(if (<= oKante_ht oKante_at)
		(progn
			(setq max_oKante oKante_ht)
			(setq min_oKante oKante_at)
		)
		(progn
			(setq max_oKante oKante_at)
			(setq min_oKante oKante_ht)
		)
	)
	(if (>= uKante_ht uKante_at)
		(progn
			(setq max_uKante uKante_ht)
			(setq min_uKante uKante_at)
		)
		(progn
			(setq max_uKante uKante_at)
			(setq min_uKante uKante_ht)
		)
	)
	(print max_oKante)
	(print max_uKante)
	(print min_oKante)
	(print min_uKante)
		
	(setq maxDiff (- max_oKante max_uKante))
	(setq minDiff (- min_oKante min_uKante))
	(print maxDiff)
	(print minDiff)
	
	(if (< maxDiff 0.0)
		(setq maxDiff (- maxDiff))
	)
	(if (< minDiff 0.0)
		(setq minDiff (- minDiff))
	)
	(print maxDiff)
	(print minDiff)
	(print "<-----------------------------------------------------------")
)
