; $	HT	QT(IUK)	AF(K)		P(E)
; $	AT	QT(IUK)	AF(K)		P(E)
; $	AE	V(90)		H(90)		R(-)

; Montagesto ber Laschen an Trgersteg
; **************************************
(defun init-connection ()
	
	
	(setq flanschlasche_uf		(blech.create))
	(Connect.storeAnschlObjs CastaData 	flanschlasche_uf)
	
	(createFlanschLaschenAussen)
	(setTrgEndeToDefault)
)



; ----------------------------------------------------------------------------------------
; ERZEUGT DIE USSEREN FLANSCHLASCHEN
; ----------------------------------------------------------------------------------------
(defun createFlanschLaschenAussen ()
	
	(setq b_ht	(Traeger.get Htrg b)
				h_ht	(Traeger.get Htrg h)
				t_ht	(Traeger.get Htrg t)
	)
	
	(setq b_at 			(Traeger.get Tr_ID b)
				h_at			(Traeger.get Tr_ID h)
				qsform_at	(Traeger.get Tr_ID qsform)
	)
	
	(setq xPos_at (Connect.get CastaData xPos_at))
	
	; massgeb. Breite ermitteln
	(if (<= b_ht b_at)
		(setq mass_b b_ht)
		(setq mass_b b_at)
	)
	
	; massgeb. Hhe ermitteln
	(if (<= h_ht h_at)
		(setq mass_h h_ht)
		(setq mass_h h_at)
	)
		
	
	; Flanschlaschenbreite
	(setq bp_f_lasche mass_b)
	
	; Flanschlaschenhhe
	(setq hp_f_lasche mass_h)
		
	
	(Blech.set flanschlasche_uf 	(dp 	t_ht) 
																(hp 	hp_f_lasche) 
																(bp 	bp_f_lasche) 
	)
	
	(Traeger.addabtl Tr_ID flanschlasche_uf xPos_at 0.0 _lasche_uf_)
	
	(if (= qsform_at "U")
		(progn
			(Blech.set flanschlasche_uf (delta_lr (* 0.5 bp_f_lasche)))
		)
	)
	
)






(defun setTrgToDefault ()
	(if (= (Connect.get CastaData linkesEnde) 1)
		(setq AtEnde (Traeger.get Tr_ID links))
	)
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(setq AtEnde (Traeger.get Tr_ID rechts))
	)
	
	(if (= (Connect.get CastaData anHtlinkesEnde) 1)
		(setq HtEnde (Traeger.get Htrg links))
	)
	(if (= (Connect.get CastaData anHtrechtesEnde) 1)
		(setq HtEnde (Traeger.get Htrg rechts))
	)
	
	(TrEnde.set AtEnde (delta_l 0))
	(TrEnde.set HtEnde (delta_l 0))
 
)
