; $ 	HT	QT(KR)		AF(K)		P(E)
; $ 	AT	QT(KR)		AF(K)		P(E)
; $ 	AE	V(-)			H(90)		R(-)

(defun load-modules ()
   (load "mod-endinit-vertikalStoss")
	 (load "mod-lochbild")
)


(defun init-connection ()
  (initAnschluss)
)

(defun initAnschluss ()
	(print "in init-connection - uz_uz_kpl_stoss bndige Kopfplatte");

	;(connect.ShowAttributes CastaData)
	(setq LB_DEBUG 0)
	
	
  (init-traegerenden)				

; ---------- Kopfplatten und Lochbild hinzufgen
  (setq kplLochbild (Lochbild.create))
  (setq kplHtrg     (Blech.create))
  (setq kplTrg      (Blech.create))
    
  (Connect.storeAnschlObjs CastaData kplLochbild kplHtrg kplTrg)
    
  (setDpKopfplatten kplHtrg kplTrg)
  (setq dp (Blech.get kplHtrg dp))
    
	(calcSchraube dp) ;=> S_Bez
	(Lochbild.set kplLochbild (S_Bez S_Bez))
	
	(calcMinRandLochAbst kplLochbild) ; aus "mod-lochbild"
	
  (setq uebOben  (* 2.0 e_min_rund))	;; Kopfplattenposition zum Traeger
  (setq uebUnten (* 2.0 e_min_rund))	;; Kopfplattenposition zum Traeger
  
	(setq qsform_ht (Traeger.get Htrg qsform))
	
	; Profilspeziefisches
	; ----------------------------------------------
	(if (= qsform_ht "R")
		(progn
			(setq uebOben  e_min_rund)	;; Kopfplattenposition zum Traeger
			(setq uebUnten e_min_rund)	;; Kopfplattenposition zum Traeger
		)
	)
	
	
	(print h1)
	    
	; Berechne Verstze zwischen den Trgern
	; ---------------------------------------------	
  (berechneTraegerUnterschiede)
    
    (if (= (connect.get CastaData linkesEnde) 1)
        (createUeberstehendeKpl Tr_ID kplTrg kplLochbild dp 1)
    )
    (if (= (connect.get CastaData rechtesEnde) 1)
        (createUeberstehendeKpl Tr_ID kplTrg kplLochbild dp -1)
    )

    (if (= (connect.get CastaData anHtLinkesEnde) 1) 
        (createUeberstehendeKpl HTrg kplHTrg kplLochbild dp  1)
    )
    (if (= (connect.get CastaData anHtRechtesEnde) 1) 
        (createUeberstehendeKpl HTrg kplHTrg kplLochbild dp -1)
    )

		
		(calcAndSetLochbildDaten_1 kplLochbild kplHtrg kplTrg)
    
    (kopfplCorrection uebOben uebUnten)

    
    (setq Abtl_KplLchb (traeger.get Htrg ABTeil kplLochbild))
    (Anbauteil.set Abtl_KplLchb (Master 1))
    (setq Abtl_KplLchb_at (traeger.get Tr_ID ABTeil kplLochbild))
    (Anbauteil.set Abtl_KplLchb_at (Master 0))
    		
    (anbauteilKorrektur Abtl_KplLchb_at kplTrg antw)

  
	; **************************************************************************************
	; Lochbild Test
	; **************************************************************************************
	(if (= LB_DEBUG 1) (progn
		(print "LB_DEBUG")
		(setq dummy (Lochbild.create))
		(Lochbild.copy dummy kplLochbild)
			
		(if (= (Connect.get CastaData linkesEnde) 1)
			(Traeger.addAbtl Tr_ID dummy 0.0 0.0 _kpllochbildlinks_)
		)
		(if (= (Connect.get CastaData rechtesEnde) 1)
			(Traeger.addAbtl Tr_ID dummy 0.0 0.0 _kpllochbildrechts_)
		)
		
		
		(setq AT_ABTeil_dummy (Traeger.get Tr_ID AbTeil dummy))
		(Anbauteil.set AT_ABTeil_dummy 	(Master    1)
																		(delta_v   delta_v_abtl)
		)
		
		(Connect.storeAnschlObjs CastaData dummy)
	))
	; **************************************************************************************
  
  ; CALLBACKS
    (Blech.set kplHtrg 	(formFkt "cb_kplHtrg"))
    (Blech.set kplTrg 	(formFkt "cb_kplTrg"))
)


; ========================================================================================
; CALLBACK-FUNKTIONEN
; ========================================================================================

; ----------------------------------------------------------------------------------------
; Callback fr Kopfplatte am HT
; ----------------------------------------------------------------------------------------
(defun cb_kplHtrg (zp)
	(print "in Callback-Funktion cb_KplBlech")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dpAlt (Blech.get kplHtrg dp))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq dpNeu (Blech.get kplHtrg dp))
	    
	    (print dpAlt) (print dpNeu)
	    
	    (if (/= dpAlt dpNeu) (progn
	       (setq dpDiff (- dpNeu dpAlt))
	       (setq alteKlemml (Lochbild.get kplLochbild Klemml))
	       
	       (Lochbild.set kplLochbild 	(Klemml (+ alteKlemml dpDiff)))
	    ))
	))
)


; ----------------------------------------------------------------------------------------
; Callback fr Kopfplatte am AT
; ----------------------------------------------------------------------------------------
(defun cb_kplTrg (zp)
	(print "in Callback-Funktion cb_KplBlech")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dpAlt (Blech.get kplTrg dp))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq dpNeu (Blech.get kplTrg dp))
	    
	    (print dpAlt) (print dpNeu)
	    
	    (if (/= dpAlt dpNeu) (progn
	       (setq dpDiff (- dpNeu dpAlt))
	       (setq alteKlemml (Lochbild.get kplLochbild Klemml))
	       
	       (Lochbild.set kplLochbild 	(Klemml (+ alteKlemml dpDiff))
	       														;(DxSKopf (+ altesDxS dpDiff))
	       )
	    ))
	))
)


(defun anbauteilKorrektur (ABTL BLECHID antw_ht)
	
	(if (= (Connect.get CastaData linkesEnde) 1)
		(setq AtEnde (Traeger.get Tr_ID links))
		(setq AtEnde (Traeger.get Tr_ID rechts))
	)
	
	(setq dp_blech (Blech.get BLECHID dp))
	
	(setq vwnkl_at (TrEnde.get AtEnde v_winkel))
	(print vwnkl_at)
	
	(if (> vwnkl_at 90.0)
		(setq wnkl_at (- vwnkl_at 90.0))
		(setq wnkl_at (- 90.0 vwnkl_at))
	)
	(print wnkl_at)
	
	(setq tanW_at (tan (/ (* PI wnkl_at) 180.0)))
	(print tanW_at)
	
	(setq antW_At (* dp_blech tanW_at))
	(print antW_At)
	(print diff_oben)
	(print oKante_at)
	(print oKante_ht)
	(if (> oKante_at oKante_ht)
		(setq delta_v_abtl (- (+ (- diff_oben) antW_At) antw_ht) )
		(setq delta_v_abtl (- (+ diff_oben antW_At) antw_ht))
	)
	(print delta_v_abtl)
	
	(Anbauteil.set ABTL (delta_v  delta_v_abtl))
)

; ---------------------------------------------------------------------- 
(defun createUeberstehendeKpl (Trg blKopfpl lchbKpl dp li_re)
		(print ">---------------------------------------------------------")
		(print "ERZEUGE BERSTEHENDE KOPFPLATTE")
    (if (= li_re  1) (setq TrgEnde (Traeger.get Trg links)))
    (if (= li_re -1) (setq TrgEnde (Traeger.get Trg rechts)))
    
    ;(setq uebOben  10)	;; Kopfplattenposition zum Traeger
    ;(setq uebUnten 80)	;; Kopfplattenposition zum Traeger
    
    (setq b_ht 	(Traeger.get Htrg b))
    
    (setq b_at	(Traeger.get Tr_ID b))
    
    (setq EWnkl  (TrEnde.get TrgEnde V_Winkel)
          alfa   (- EWnkl 90.0)
          hProf  (Traeger.get Trg h)
          cosW   (cos (* PI (/ alfa 180.0)))
          hNetto hProf
    )
    (if (/= cosW 0) (setq hNetto (/ hProf cosW)))

    (setq  hp     (+ hNetto uebOben uebUnten))

		; Durchmesser ds der Schrauben
    (setq d_schraube (Lochbild.get lchbKpl sdurchm))
    
    ; Kopfplattenbreite
    (if (>= b_ht b_at)
    	(setq mass_b b_ht)
    	(setq mass_b b_at)
    )
    
    (setq mass_b_rund (runde mass_b auf 5))
    
    (setq breite_kpl (+ mass_b_rund uebOben uebUnten))
    ;(setq breite_kpl (* 8 d_schraube))
    
    (Blech.set blKopfpl	(dp    dp)
         		(bp    breite_kpl)
         		(hp    hp)
         		(dOK   (- uebOben))
    )
    
    (if (= li_re  1) (traeger.addabtl Trg blKopfpl 0.0 0.0 _kopfplattelinks_))
    (if (= li_re -1) (traeger.addabtl Trg blKopfpl 0.0 0.0 _kopfplatterechts_))

    (if (= li_re  1) (traeger.addabtl Trg lchbKpl 0.0 0.0 _kpllochbildlinks_))
    (if (= li_re -1) (traeger.addabtl Trg lchbKpl 0.0 0.0 _kpllochbildrechts_))
   		
		
   	;(TrEnde.set TrgEnde (delta_l 0)) 
    (TrEnde.pTrim TrgEnde dp)
		(print "<---------------------------------------------------------")
)
; ---------------------------------------------------------------------- 
(defun calcAndSetLochbildDaten_1 (Lchb_ID BlechHT BlechAT)
	(print "--------------------------------------------------------------------------------")
	(print "BERECHNE LOCHBILDDATEN")
	(Lochbild.set Lchb_ID 
		(S_Bez   "M20")
		(Guete   "4.6")
		(e       "-1 1 0 0 0 0")
		(w       "80  0")
	)
	
	(setq delta_v_at 	(Traeger.get Tr_ID delta_v)
				r_winkel_at	(Traeger.get Tr_ID r_winkel)
				h_at				(Traeger.get Tr_ID h)
	)
	
	(setq delta_v_ht 	(Traeger.get Htrg delta_v)
				r_winkel_ht	(Traeger.get Htrg r_winkel)
				h_ht				(Traeger.get Htrg h)
	)
	
	(setq dp_blechHT (Blech.get BlechHT dp))
	(setq dp_blechAT (Blech.get BlechAT dp))
	
	; magebenden Trger ermitteln (hier der grere)
	(if (= (Connect.get CastaData linkesEnde) 1)	(setq TrgEnde_AT (Traeger.get Tr_ID links)))
	(if (= (Connect.get CastaData rechtesEnde) 1)	(setq TrgEnde_AT (Traeger.get Tr_ID rechts)))
	(if (= (Connect.get CastaData anHtLinkesEnde) 1)	(setq TrgEnde_HT (Traeger.get Htrg links)))
	(if (= (Connect.get CastaData anHtRechtesEnde) 1)	(setq TrgEnde_HT (Traeger.get Htrg rechts)))
	
	(setq vscherl_at (TrEnde.get TrgEnde_AT vscherl))
	(setq vscherl_ht (TrEnde.get TrgEnde_HT vscherl))
	
	(setq vwnkl_ht	 (TrEnde.get TrgEnde_HT v_winkel))
	(print vwnkl_ht)
	(if (> vwnkl_ht 90.0)
		(setq wnkl_ht (- vwnkl_ht 90.0))
		(setq wnkl_ht (- 90.0 vwnkl_ht))
	)
	(print wnkl_ht)
	
	(setq tanW_ht (tan (/ (* PI wnkl_ht) 180.0)))
	(print tanW_ht)
	
	; Anteil Neigung 
	(setq antW (* dp_blechHT tanW_ht))
	(print antW)
	
	(setq vscherl_at_halb (* 0.5 vscherl_at))
	(setq vscherl_ht_halb (* 0.5 vscherl_ht))
	
	(if (> vscherl_at vscherl_ht)
		(progn
			(setq h_prof_mass vscherl_at)
			(setq h_prof vscherl_ht)
		)
		(progn
			(setq h_prof_mass vscherl_ht)
			(setq h_prof vscherl_at)
		)
	)
	
	; halbe Scherlnge der Trgerenden
	;(setq h_prof_mass_halb (* 0.5 h_prof_mass))
	;(setq h_prof_halb (* 0.5 h_prof))
	;(print h_prof_mass_halb)
	;(print h_prof_halb)
	
	
	
	(setq massAbstand (* 0.25 minDiff))
	
	(setq viertel (* 0.25 h_prof_mass))
	(print viertel)
	(setq viertel massAbstand)
	(print viertel)
	(print diff_oben)
	(print uebOben)
	(if (< oKante_ht oKante_at)
		(setq e0 (- (- (* 0.5 uebOben) antW)))
		(setq e0 (- (- (+ (* 0.5 uebOben) diff_oben) antW)))
	)
	;(setq e0 diff)
	(setq e0rund (runde e0 auf 5))
	(print e0)
	;(if (< oKante_ht oKante_at)
	;	(setq e1 (+ diff_oben viertel (- e0) antW))
	;	(setq e1 (+ viertel (- e0) antW))
	;)
	;(print e1)
	
	(setq w0 (+ mass_b_rund ueboben))
	
	
	; e1
	; ----------------------------------------------
	(setq e1	(+ h_prof_mass ueboben))
	(setq e1_rund (runde e1 auf 5))
	
	(setq qsform_ht (Traeger.get Htrg qsform))
	
	; Profilspeziefisches
	; ----------------------------------------------
	(if (= qsform_ht "R")
		(progn
			(setq e0 1.0)
			(setq e1 h_prof_mass)
			(setq w0 h_prof_mass)
		)
	)
	
	; Werte runden
	; ----------------------------------------------
	(setq w0_rund (runde w0 auf 5))
	(setq e1_rund (runde e1 auf 5))
	
	
	(Lochbild.set Lchb_ID (e0 		e0) 
												(e1 		e1_rund)
												(w0			w0_rund) 
												(klemml (+ dp_blechHT dp_blechaT))
	)
	(print "--------------------------------------------------------------------------------")
	
)

; ---------------------------------------------------------------------- 
(defun kopfplCorrection (ueb_oben ueb_unten)
	(print ">-----------------------------------------------------------")
	(print "KORREGIERE KOPFPLATTEN")
	; hier wird die Gre des kleineren Blechs an das grere Blech angepasst 
	
	
	
	; Korrektur der Kopfplattenhhe, so dass zu beiden Flanschseiten der Traeger
	; mindestens der gewollte berstand entsteht.
	(setq hp_blech_korregiert (+ maxDiff ueb_oben ueb_unten))
	(print hp_blech_korregiert)
	;(setq hp_blech_korregiert (runde hp_blech_korregiert auf 5))
	;(print hp_blech_korregiert)
	(Blech.set kplHtrg 	(hp hp_blech_korregiert))
	(Blech.set kplTrg 	(hp hp_blech_korregiert))
	
	
	; Magebenden Trger ermitteln, bei dem dok angesetzt wird.
	(if (<= oKante_ht oKante_at)
		(progn
			(print "AT mu verschoben werden.")
			(setq dok_blech (Blech.get kplTrg dok))
			(if (= rwinkel_at rwinkel_ht_rot)
				(Blech.set kplTrg (dok (- dok_blech diff_unten)))
				(Blech.set kplTrg (dok (- dok_blech diff_oben)))
			)	
		)
		(progn
			(print "HT mu verschoben werden.")
			(setq dok_blech (Blech.get kplHtrg dok))
			(print dok_blech)
			(Blech.set kplHtrg (dok (- dok_blech diff_oben)))
		)
	)
	
)


; ----------------------------------------------------------------------------------------
; SETZT DIE DICKE DER KOPFPLATTEN
; ----------------------------------------------------------------------------------------
(defun setDpKopfplatten (kpl_ht kpl_at)
	
	(setq t_at (Traeger.get Tr_ID t))
	
	(setq t_ht (Traeger.get Htrg t))
	
	(setq t_at_rund (runde t_at auf 5))
	(setq t_ht_rund (runde t_ht auf 5))
	
	(if (>= t_ht t_at)
		(setq dp_kpl t_ht_rund)
		(setq dp_kpl t_at_rund)
	)
	
	(if (< dp_kpl 10.0)
		(setq dp_kpl 10.0)
	)
	
	(Blech.set kpl_ht (dp dp_kpl))
	(Blech.set kpl_at (dp dp_kpl))
	
)


; ----------------------------------------------------------------------------------------
; Berechnet folgende Werte bei unterschiedlichen Trgern
;
; Die Werte beziehen sich auf die Achse der Kontaktflche, also entlang der Schnittflche
;
;	diff_oben:		Abstand der oberen Flanschkanten zueinander
;	diff_unten:		Abstand der unteren Flanschkanten zueinander
;	maxDiff:			Maximale Ausdehnung von obersten zur untersten Flanschkante
; max_oKante:		Maximalwert fr den obersten Flansch
; max_uKante:		Maximalwert fr den untersten Flansch
;	oKante_ht
; oKante_at
; uKante_ht
; uKante_at
;
; ----------------------------------------------------------------------------------------
(defun berechneTraegerUnterschiede ()
	(print ">-----------------------------------------------------------")
	(print "BERECHNE TRGERUNTERSCHIEDE")
	
	(setq h_kpl_ht 	(Blech.get kplHtrg hp)
				dp_kpl_ht	(Blech.get kplHtrg dp)
	)
	(setq h_kpl_at 	(Blech.get kplTrg hp)
				dp_kpl_at	(Blech.get kplTrg dp)
	)
	
	(setq h_ht 				(Traeger.get Htrg h)
				delta_v_ht	(Traeger.get Htrg delta_v)
				rwinkel_ht	(Traeger.get Htrg r_winkel)
	)
	
	(setq h_at				(Traeger.get Tr_ID h)
				delta_v_at	(Traeger.get Tr_ID delta_v)
				rwinkel_at	(Traeger.get Tr_ID r_winkel)
	)
	
	(setq rwinkel_ht_rot (+ rwinkel_ht 180.0))
	
	(if (= rwinkel_at rwinkel_ht_rot)
		(setq delta_v_at (- delta_v_at))
	)
	
	(if (= (Connect.get CastaData linkesEnde) 1)	(setq TrgEnde_AT (Traeger.get Tr_ID links)))
	(if (= (Connect.get CastaData rechtesEnde) 1)	(setq TrgEnde_AT (Traeger.get Tr_ID rechts)))
	(if (= (Connect.get CastaData anHtLinkesEnde) 1)	(setq TrgEnde_HT (Traeger.get Htrg links)))
	(if (= (Connect.get CastaData anHtRechtesEnde) 1)	(setq TrgEnde_HT (Traeger.get Htrg rechts)))
	
	(setq vscherl_at 	(TrEnde.get TrgEnde_AT vscherl)		
				vwinkel_at	(TrEnde.get TrgEnde_AT v_winkel)
	)
	(setq vscherl_ht 	(TrEnde.get TrgEnde_HT vscherl)
				vwinkel_ht	(TrEnde.get TrgEnde_HT v_winkel)
	)
	
	(print vscherl_at)
	(print vscherl_ht)
	
	(print vwinkel_at)
	(print vwinkel_ht)
	
	(setq winkel_ht (- 90.0 vwinkel_ht))
	(setq winkel_at (- vwinkel_at 90.0))
	
	(print winkel_at)
	(print winkel_ht)
	
	(if (< winkel_ht 0.0)
		(setq winkel_ht (- winkel_ht))
	)
	(if (< winkel_at 0.0)
		(setq winkel_at (- winkel_at))
	)
	(print winkel_at)
	(print winkel_ht)
	
	(setq tanVW_at	(tan (/ (* PI winkel_at) 180.0)))
	(setq tanVW_ht	(tan (/ (* PI winkel_ht) 180.0)))
	(setq cosVW_at	(cos (/ (* PI winkel_at) 180.0)))
	(setq cosVW_ht	(cos (/ (* PI winkel_ht) 180.0)))
	(print tanVW_ht)
	(print tanVW_at)
	(print cosVW_ht)
	(print cosVW_at)
	
	; Anteil der Kopfplattendicke
	(setq anteil_kpl_ht (* dp_kpl_ht tanVW_ht))
	(setq anteil_kpl_at (* dp_kpl_at tanVW_at))
	
	(print anteil_kpl_ht)
	(print anteil_kpl_at)
		
	(if (< vscherl_at vscherl_ht)
		(progn
			(setq h_prof_mass vscherl_ht)			
			(setq h_prof vscherl_at)
			(setq isHtrg 1)
			(Blech.set kplTrg (hp h_kpl_ht))
		)
		(progn
			(setq h_prof_mass vscherl_at)
			(setq h_prof vscherl_ht)
			(setq isHtrg 0)
			(Blech.set kplHtrg (hp h_kpl_at))
		)
	)
	
	
	(setq vscherl_at_halb (* 0.5 vscherl_at))
	(setq vscherl_ht_halb (* 0.5 vscherl_ht))
	
	(setq delta_v_ht_scher (/ delta_v_ht cosVW_ht))
	(setq delta_v_at_scher (/ delta_v_at cosVW_at))
	
	(print delta_v_ht_scher)
	(print delta_v_at_scher)
	
	; Oberkante der Trger
	(setq oKante_ht (- delta_v_ht_scher vscherl_ht_halb))				(print oKante_ht)
	(setq uKante_ht (+ oKante_ht vscherl_ht))										(print uKante_ht)
	(setq oKante_at	(- delta_v_at_scher vscherl_at_halb))				(print oKante_at)
	(setq uKante_at (+ oKante_at vscherl_at))										(print uKante_at)
		
	(print "-----------------------------------")
	
	; Anteil der Kopfplatte hinzurechnen
	(setq oKante_ht (+ oKante_ht anteil_kpl_ht))								(print oKante_ht)
	(setq uKante_ht (+ uKante_ht anteil_kpl_ht))								(print uKante_ht)
	(setq oKante_at	(+ oKante_at anteil_kpl_at))								(print oKante_at)
	(setq uKante_at (+ uKante_at anteil_kpl_at))								(print uKante_at)
	
	; Differenz oben
	(if (< oKante_ht oKante_at)
		(setq diff_oben (- oKante_at oKante_ht))
		(setq diff_oben (- oKante_ht oKante_at))
	)
	(print diff_oben)
	
  ; Differenz unten
	(if (< uKante_ht uKante_at)
		(setq diff_unten (- uKante_at uKante_ht))
		(setq diff_unten (- uKante_ht uKante_at))
	)
	(print diff_unten)
	
	; Maximal- / Minimalwerte ermitteln (okante / ukante)
	(if (<= oKante_ht oKante_at)
		(progn
			(setq max_oKante oKante_ht)
			(setq min_oKante oKante_at)
		)
		(progn
			(setq max_oKante oKante_at)
			(setq min_oKante oKante_ht)
		)
	)
	(if (>= uKante_ht uKante_at)
		(progn
			(setq max_uKante uKante_ht)
			(setq min_uKante uKante_at)
		)
		(progn
			(setq max_uKante uKante_at)
			(setq min_uKante uKante_ht)
		)
	)
	(print max_oKante)
	(print max_uKante)
	(print min_oKante)
	(print min_uKante)
		
	(setq maxDiff (- max_oKante max_uKante))
	(setq minDiff (- min_oKante min_uKante))
	(print maxDiff)
	(print minDiff)
	
	(if (< maxDiff 0.0)
		(setq maxDiff (- maxDiff))
	)
	(if (< minDiff 0.0)
		(setq minDiff (- minDiff))
	)
	(print maxDiff)
	(print minDiff)
	(print "<-----------------------------------------------------------")
)