; $	HT	QT(I)		AF(K)		P(E)
; $	AT	QT(I)		AF(K)		P(E)
; $	AE	V(-)		H(90)		R(-)

(defun load-modules ()
   (load "mod-endinit-vertikalStoss")
	 (load "mod-lochbild")
)


(defun init-connection ()
	(setq rwinkel_at (Traeger.get Tr_ID r_winkel))
  (setq rwinkel_ht (Traeger.get Htrg r_winkel))
  
  ; berprfen, ob Trger rotiert sind
  (if (/= rwinkel_at 0.0)
  	(progn
  		(if (/= rwinkel_ht 0.0)
  			(alertBox "Bitte setzen Sie den Rotationswinkel beider Trger auf 0."  "Set_RotAngle_BothBeams_To_Zero")
  			(alertBox "Bitte setzen Sie den Rotationswinkel des Anschlusstrgers auf 0."  "Set_RotAngle_AT_To_Zero")
  		)
  	)
  	(progn
  		(if (/= rwinkel_ht 0.0)
  			(alertBox "Bitte setzen Sie den Rotationswinkel des Haupttrgers auf 0."    "Set_RotAngle_AT_To_Zero")
  			(initAnschluss)
  		)
  	)
  )
)


(defun initAnschluss ()
	  ;(connect.ShowAttributes CastaData)

  (init-traegerenden)				

	(print "ERZEUGE KOPFPLATTENSTOSS MIT VOUTE")
(if (= 1 1)
	(progn
; ---------- Kopfplatten und Lochbild hinzufgen
    (setq kplLochbild (Lochbild.create))
    (setq kplHtrg     (Blech.create))
    (setq kplTrg      (Blech.create))
    (setq vouteHtrg		(Voute.create))
    (setq vouteTrg		(Voute.create))
    
    (Connect.storeAnschlObjs CastaData kplLochbild kplHtrg kplTrg vouteHtrg vouteTrg)
    
    (setDpKopfplatten kplHtrg kplTrg)
    (setq dp (Blech.get kplHtrg dp))
    
    (setq ueboben 10)
    
    (berechneTraegerUnterschiede)
    
		(calcSchraube dp) ; => S_Bez
		(Lochbild.set kplLochbild (S_Bez S_Bez))
		
		
    (calcAndSetLochbildDaten_1 kplLochbild kplHtrg kplTrg)
    
    (if (= (connect.get CastaData linkesEnde) 1)
    	(progn
    		(createVoute vouteTrg Tr_ID)
        (createBuendigeKpl Tr_ID kplTrg kplLochbild dp ueboben 1 vouteTrg)
      )
    )
    (if (= (connect.get CastaData rechtesEnde) 1)
    	(progn
    		(createVoute vouteTrg Tr_ID)
        (createBuendigeKpl Tr_ID kplTrg kplLochbild dp ueboben -1 vouteTrg)
      )
    )

    (if (= (connect.get CastaData anHtLinkesEnde) 1) 
    	(progn
    		(createVoute vouteHtrg Htrg)
        (createBuendigeKpl HTrg kplHTrg kplLochbild dp ueboben  1 vouteHtrg)
      )
    )
    (if (= (connect.get CastaData anHtRechtesEnde) 1) 
    	(progn
    		(createVoute vouteHtrg Htrg)
        (createBuendigeKpl HTrg kplHTrg kplLochbild dp ueboben -1 vouteHtrg)
      )
    )

		(setW0Lochbild kplLochbild kplHtrg)
    
    (setq Abtl_KplLchb_ht (traeger.get Htrg ABTeil kplLochbild))
    (Anbauteil.set Abtl_KplLchb_ht (Master 1))
    (setq Abtl_KplLchb_at (traeger.get Tr_ID ABTeil kplLochbild))
    (Anbauteil.set Abtl_KplLchb_at (Master 0))

    (setq uebunten (+ ueboben mass_hsteg t_Voute)) ;TODO unterscheiden!!!!!!!!!!!!
        
    (kopfplCorrection ueboben uebunten)
  	
    (anbauteilKorrektur Abtl_KplLchb_at)
    (seitliche_Verschiebung)			; neu - April 2010


  (if (= 1 2) (progn
      (Lochbild.set kplLochbild (e "0 50 150 0 0 0"))
      (Lochbild.set kplLochbild (w "10 100"))
      (Lochbild.set kplLochbild (LB_Art 2))
      (Anbauteil.set Abtl_KplLchb_ht 		(Master 0))
      (Anbauteil.set Abtl_KplLchb_at 		(Master 1))
      (setq dlr_AT (Anbauteil.get Abtl_KplLchb_at delta_lr))
      (setq dlr_HT (Anbauteil.get Abtl_KplLchb_ht delta_lr))
      (print dlr_HT)
      (print dlr_AT)
;      (Anbauteil.set Abtl_KplLchb_at (delta_lr 0))
      (setq seitricht_AT (Anbauteil.get Abtl_KplLchb_at SeitRicht))
      (setq seitricht_HT (Anbauteil.get Abtl_KplLchb_ht    SeitRicht))
      (print seitricht_HT)
      (print seitricht_AT)
;      (Anbauteil.set Abtl_KplLchb_at (SeitRicht 0))
  ))
  	
  	
  	; CALLBACKS
    (Blech.set kplHtrg 		(formFkt "cb_kplHtrg"))
    (Blech.set kplTrg 		(formFkt "cb_kplTrg"))
    ;(Voute.set vouteHtrg	(formFkt "cb_vouteHtrg"))
  
))
)


; ========================================================================================
; CALLBACK-FUNKTIONEN
; ========================================================================================

; ----------------------------------------------------------------------------------------
; Callback fr Kopfplatte am HT
; ----------------------------------------------------------------------------------------
(defun cb_kplHtrg (zp)
	(print "in Callback-Funktion cb_KplBlech")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dpAlt (Blech.get kplHtrg dp))
	    ;(setq hpAlt (Blech.get kplHtrg hp))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq dpNeu (Blech.get kplHtrg dp))
	    
	    (print dpAlt) (print dpNeu)
	    
	    (if (/= dpAlt dpNeu) (progn
	       (setq dpDiff (- dpNeu dpAlt))
	       (setq alteKlemml (Lochbild.get kplLochbild Klemml))
	       
	       (Lochbild.set kplLochbild 	(Klemml (+ alteKlemml dpDiff)))
	    ))
	    
	    
	    
	    ;(setq hpNeu (Blech.get kplHtrg hp))
	    
	    ;(print hpAlt) (print hpNeu)
	    
	    ;(if (/= hpAlt hpNeu) (progn
	    ;   (setq hpDiff (- hpNeu hpAlt))
	    ;   (setq h_voute_alt (Voute.get vouteHtrg hsteg1))
	       
	    ;   (setq h_voute_neu (+ h_voute_alt hpDiff))
	       
	    ;   (print h_voute_alt)
	    ;   (print h_voute_neu)
	       
	    ;   (Voute.set vouteHtrg (hsteg1 h_voute_neu))
	    ;))
	))
)


; ----------------------------------------------------------------------------------------
; Callback fr Kopfplatte am AT
; ----------------------------------------------------------------------------------------
(defun cb_kplTrg (zp)
	(print "in Callback-Funktion cb_KplBlech")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dpAlt (Blech.get kplTrg dp))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq dpNeu (Blech.get kplTrg dp))
	    
	    (print dpAlt) (print dpNeu)
	    
	    (if (/= dpAlt dpNeu) (progn
	       (setq dpDiff (- dpNeu dpAlt))
	       (setq alteKlemml (Lochbild.get kplLochbild Klemml))
	       
	       (Lochbild.set kplLochbild 	(Klemml (+ alteKlemml dpDiff))
	       														;(DxSKopf (+ altesDxS dpDiff))
	       )
	    ))
	))
)


; ----------------------------------------------------------------------------------------
; Callback fr Voute am HT
; ----------------------------------------------------------------------------------------
(defun cb_vouteHtrg (zp)
	(print "in Callback-Funktion cb_vouteHtrg")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq hAlt (Voute.get vouteHtrg hsteg1))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq hNeu (Voute.get vouteHtrg hsteg1))
	    
	    (print hAlt) (print hNeu)
	    
	    (if (/= hAlt hNeu) (progn
	       (setq hDiff (- hNeu hAlt))
	       (setq hp_kpl_alt (Blech.get kplHtrg hp))
	       (setq hp_kpl_neu (+ hp_kpl_alt hDiff))
	       
	       (print hp_kpl_alt)
	       (print hp_kpl_neu)
	       (Blech.set kplHtrg 	(hp hp_kpl_neu))
	    ))
	))
)








(defun anbauteilKorrektur (ABTL)
	
	(if (> oKante_at oKante_ht)
		(setq delta_v_abtl (- diff_oben))
		(setq delta_v_abtl (+ diff_oben))
	)
	
	(Anbauteil.set ABTL (delta_v  delta_v_abtl))
)

; ---------------------------------------------------------------------- 
(defun createBuendigeKpl (Trg blKopfpl lchbKpl dp ueb li_re VouteID)
    (if (= li_re  1) (setq TrgEnde (Traeger.get Trg links)))
    (if (= li_re -1) (setq TrgEnde (Traeger.get Trg rechts)))
    
    ;(setq ueb 5)	;; nur zum Testen - Kopfplattenposition zum Traeger
    
    (setq EWnkl  (TrEnde.get TrgEnde V_Winkel)
          alfa   (- EWnkl 90.0)
          hProf  (Traeger.get Trg h)
          cosW   (cos (* PI (/ alfa 180.0)))
          hNetto hProf
    )
    (setq h_Voute (Voute.get VouteID hsteg1)
    			t_Voute	(Voute.get VouteID t_flansch)
    )
    
    (if (/= cosW 0) (setq hNetto (/ hProf cosW)))

    (setq  hp     (+ hNetto ueb ueb))
		(setq hp (+ hp h_Voute t_Voute))
		; Durchmesser ds der Schrauben
    (setq d_schraube (Lochbild.get lchbKpl sdurchm))
    ; Hhe
		; --------------------------------------------
		
		
		; Kopfplattenbreite
		; --------------------------------------------
    (setq b_ht (Traeger.get Htrg b))
		(setq b_at (Traeger.get Tr_ID b))
		
		(if (>= b_ht b_at)
			(setq b_massg b_ht)
			(setq b_massg b_at)
		)
		
		(setq kpl_bp_min (* 8 d_schraube))
		
		(if (< b_massg kpl_bp_min)
			(setq breite_kpl kpl_bp_min)
			(setq breite_kpl b_massg)
		)
		
		;(setq breite_kpl (* 8 d_schraube))
			
    
    (Blech.set blKopfpl	(dp    dp)
         								(bp    breite_kpl)
         								(hp    hp)
         								(dOK   (- ueb))
         ;(dOK   (- 40))
    )
    
    (if (= li_re  1) (traeger.addabtl Trg blKopfpl 0.0 0.0 _kopfplattelinks_))
    (if (= li_re -1) (traeger.addabtl Trg blKopfpl 0.0 0.0 _kopfplatterechts_))

    (if (= li_re  1) (traeger.addabtl Trg lchbKpl 0.0 0.0 _kpllochbildlinks_))
    (if (= li_re -1) (traeger.addabtl Trg lchbKpl 0.0 0.0 _kpllochbildrechts_))
   
   	;(TrEnde.set TrgEnde (delta_l 0)) 
    (TrEnde.pTrim TrgEnde dp)

)

; ----------------------------------------------------------------------------------------
; Erzeugt die Vouten
; ----------------------------------------------------------------------------------------
(defun createVoute (VouteID TrgID)
	(print ">-----------------------------------------------------------")
	(print "ERZEUGE VOUTE")
	
	; magebenden (schmaleren) Trger ermitteln
	(setq b_ht 	(Traeger.get Htrg b)
				s_ht 	(Traeger.get Htrg s)
				t_ht	(Traeger.get Htrg t)
				h_ht	(Traeger.get Htrg h)
	)
	(setq b_at	(Traeger.get Tr_ID b)
				s_at	(Traeger.get Tr_ID s)
				t_at	(Traeger.get Tr_ID t)
				h_at	(Traeger.get Tr_ID h)
	)
	
	(if (<= b_ht b_at)
		(progn
			(setq b_voute b_ht)
			(setq s_voute s_ht)
			(setq t_voute t_ht)
		)
		(progn
			(setq b_voute b_at)
			(setq s_voute s_at)
			(setq t_voute t_at)
		)
	)
	
	(print b_voute)
	(print s_voute)
	(print t_voute)
	
	(if (>= h_ht h_at)
		(setq mass_hsteg (- h_ht (* t_ht 2.0)))
		(setq mass_hsteg (- h_at (* t_at 2.0)))
	)
	
	(if (= TrgID Htrg)
		(progn
			(print "HT")
			(if (>= uKante_ht uKante_at)
				(progn
					
					(setq h_voute_steg mass_hsteg );OK
				)
				(progn
					
					(setq h_voute_steg (+ mass_hsteg diff_unten))
				)
				
			)
			(print h_voute_steg)			
		)
	)
	(if (= TrgID Tr_ID)
		(progn
			(print "AT")
			(print uKante_ht)
			(print uKante_at)
			(if (>= uKante_ht uKante_at)
				(progn
					(setq h_voute_steg (+ mass_hsteg diff_unten)) ;OK
				)
				(progn
					(setq h_voute_steg mass_hsteg)
				)
			)
			(print h_voute_steg)			
		)
	)
	
	(setq l_voute (* 2.5 h_voute_steg))
	
	(Voute.set VouteID 	(laenge	 		l_voute) 
											(hsteg1	 		h_voute_steg) 
											(d_OK 			0) 
											(t_flansch  t_voute) 
											(b_flansch  b_voute) 
											(t_steg 		s_voute)
	)
		
	(if (= TrgID Tr_ID)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(traeger.addabtl Tr_ID VouteID 0.0 0.0 _voutelinks_)
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(traeger.addabtl Tr_ID VouteID 0.0 0.0 _vouterechts_)
			)
		)
	)
	(if (= TrgID Htrg)
		(progn
			(if (= (Connect.get CastaData anHtLinkesEnde) 1)
				(traeger.addabtl Htrg VouteID 0.0 0.0 _voutelinks_)
			)
			(if (= (Connect.get CastaData anHtRechtesEnde) 1)
				(traeger.addabtl Htrg VouteID 0.0 0.0 _vouterechts_)
			)
		)
	)
	(print "<-----------------------------------------------------------")
)


; ---------------------------------------------------------------------- 
(defun calcAndSetLochbildDaten_1 (Lchb_ID BlechHT BlechAT)
	(print "--------------------------------------------------------------------------------")
	(print "BERECHNE LOCHBILDDATEN")
	(Lochbild.set Lchb_ID 
		(Guete   "4.6")
		(e       "-1 1 0 0 0 0")
		(w       "80  0")
	)
	
	(setq delta_v_at 	(Traeger.get Tr_ID delta_v)
				r_winkel_at	(Traeger.get Tr_ID r_winkel)
				h_at				(Traeger.get Tr_ID h)
	)
	
	(setq delta_v_ht 	(Traeger.get Htrg delta_v)
				r_winkel_ht	(Traeger.get Htrg r_winkel)
				h_ht				(Traeger.get Htrg h)
	)
	
	; magebenden Trger ermitteln (hier der kleinere)
	(if (= (Connect.get CastaData linkesEnde) 1)	(setq TrgEnde_AT (Traeger.get Tr_ID links)))
	(if (= (Connect.get CastaData rechtesEnde) 1)	(setq TrgEnde_AT (Traeger.get Tr_ID rechts)))
	(if (= (Connect.get CastaData anHtLinkesEnde) 1)	(setq TrgEnde_HT (Traeger.get Htrg links)))
	(if (= (Connect.get CastaData anHtRechtesEnde) 1)	(setq TrgEnde_HT (Traeger.get Htrg rechts)))
	
	(setq vscherl_at (TrEnde.get TrgEnde_AT vscherl))
	(setq vscherl_ht (TrEnde.get TrgEnde_HT vscherl))
	
	(setq vscherl_at_halb (* 0.5 vscherl_at))
	(setq vscherl_ht_halb (* 0.5 vscherl_ht))
	
	(if (< vscherl_at vscherl_ht)
		(progn
			(setq h_prof_mass vscherl_at)
			(setq h_prof vscherl_ht)
		)
		(progn
			(setq h_prof_mass vscherl_ht)
			(setq h_prof vscherl_at)
		)
	)
					
	
	
	
	
	;(setq ueb 5)	;; nur zum Testen - Kopfplattenposition zum Traeger
	
	(setq massAbstand (* 0.25 minDiff))
	
	(setq viertel (* 0.25 h_prof_mass))
	(print viertel)
	(setq viertel massAbstand)
	(print viertel)
	
	(if (< oKante_ht oKante_at)
		(setq e0 (+ diff_oben viertel))
		(setq e0 viertel)
	)
	
	;(setq e0 diff)
	(setq e0rund (runde e0 auf 5))
	(print e0)
	(setq e1 (* 2 viertel))
	(print e1)
	
	(if (< uKante_ht uKante_at)
		(setq e2 (+ viertel diff_unten (* 0.75 h_prof))) ; Erstmal fest, evtl. spter in Abhngigkeit von Voutenhhe berechnen
		(setq e2 (+ viertel diff_unten (* 0.75 h_prof)))
	)
	(setq dp_blechHT (Blech.get BlechHT dp))
	(setq dp_blechAT (Blech.get BlechAT dp))
	(Lochbild.set Lchb_ID (e0 		e0) 
												(e1 		e1)
												(e2		  e2) 
												(klemml (+ dp_blechHT dp_blechaT))
	)
	(print "--------------------------------------------------------------------------------")
)


; ----------------------------------------------------------------------------------------
; Berechnet folgende Werte bei unterschiedlichen Trgern
;
; Die Werte beziehen sich auf die Achse der Kontaktflche, also entlang der Schnittflche
;
;	diff_oben:		Abstand der oberen Flanschkanten zueinander
;	diff_unten:		Abstand der unteren Flanschkanten zueinander
;	maxDiff:			Maximale Ausdehnung von obersten zur untersten Flanschkante
; max_oKante:		Maximalwert fr den obersten Flansch
; max_uKante:		Maximalwert fr den untersten Flansch
;
; ----------------------------------------------------------------------------------------
(defun berechneTraegerUnterschiede ()
	(print ">-----------------------------------------------------------")
	(print "BERECHNE TRGERUNTERSCHIEDE")
	
	(setq h_kpl_ht 	(Blech.get kplHtrg hp)
				dp_kpl_ht	(Blech.get kplHtrg dp)
	)
	(setq h_kpl_at 	(Blech.get kplTrg hp)
				dp_kpl_at	(Blech.get kplTrg dp)
	)
	
	(setq h_ht 				(Traeger.get Htrg h)
				delta_v_ht	(Traeger.get Htrg delta_v)
	)
	
	(setq h_at				(Traeger.get Tr_ID h)
				delta_v_at	(Traeger.get Tr_ID delta_v)
	)
	
	(if (= (Connect.get CastaData linkesEnde) 1)	(setq TrgEnde_AT (Traeger.get Tr_ID links)))
	(if (= (Connect.get CastaData rechtesEnde) 1)	(setq TrgEnde_AT (Traeger.get Tr_ID rechts)))
	(if (= (Connect.get CastaData anHtLinkesEnde) 1)	(setq TrgEnde_HT (Traeger.get Htrg links)))
	(if (= (Connect.get CastaData anHtRechtesEnde) 1)	(setq TrgEnde_HT (Traeger.get Htrg rechts)))
	
	(setq vscherl_at 	(TrEnde.get TrgEnde_AT vscherl)		
				vwinkel_at	(TrEnde.get TrgEnde_AT v_winkel)
	)
	(setq vscherl_ht 	(TrEnde.get TrgEnde_HT vscherl)
				vwinkel_ht	(TrEnde.get TrgEnde_HT v_winkel)
	)
	
	(print vscherl_at)
	(print vscherl_ht)
	
	(print vwinkel_at)
	(print vwinkel_ht)
	
	(setq winkel_ht (- 90.0 vwinkel_ht))
	(setq winkel_at (- vwinkel_at 90.0))
	
	(print winkel_at)
	(print winkel_ht)
	
	(if (< winkel_ht 0.0)
		(setq winkel_ht (- winkel_ht))
	)
	(if (< winkel_at 0.0)
		(setq winkel_at (- winkel_at))
	)
	(print winkel_at)
	(print winkel_ht)
	
	(setq tanVW_at	(tan (/ (* PI winkel_at) 180.0)))
	(setq tanVW_ht	(tan (/ (* PI winkel_ht) 180.0)))
	(setq cosVW_at	(cos (/ (* PI winkel_at) 180.0)))
	(setq cosVW_ht	(cos (/ (* PI winkel_ht) 180.0)))
	(print tanVW_ht)
	(print tanVW_at)
	(print cosVW_ht)
	(print cosVW_at)
	
	; Anteil der Kopfplattendicke
	(setq anteil_kpl_ht (* dp_kpl_ht tanVW_ht))
	(setq anteil_kpl_at (* dp_kpl_at tanVW_at))
	
	(print anteil_kpl_ht)
	(print anteil_kpl_at)
		
	(if (< vscherl_at vscherl_ht)
		(progn
			(setq h_prof_mass vscherl_ht)			
			(setq h_prof vscherl_at)
			(setq isHtrg 1)
			(Blech.set kplTrg (hp h_kpl_ht))
		)
		(progn
			(setq h_prof_mass vscherl_at)
			(setq h_prof vscherl_ht)
			(setq isHtrg 0)
			(Blech.set kplHtrg (hp h_kpl_at))
		)
	)
	
	
	(setq vscherl_at_halb (* 0.5 vscherl_at))
	(setq vscherl_ht_halb (* 0.5 vscherl_ht))
	
	(setq delta_v_ht_scher (/ delta_v_ht cosVW_ht))
	(setq delta_v_at_scher (/ delta_v_at cosVW_at))
	
	(print delta_v_ht_scher)
	(print delta_v_at_scher)
	
	; Oberkante der Trger
	(setq oKante_ht (- delta_v_ht_scher vscherl_ht_halb))				(print oKante_ht)
	(setq uKante_ht (+ oKante_ht vscherl_ht))										(print uKante_ht)
	(setq oKante_at	(- delta_v_at_scher vscherl_at_halb))				(print oKante_at)
	(setq uKante_at (+ oKante_at vscherl_at))										(print uKante_at)
		
	(print "-----------------------------------")
	
	; Anteil der Kopfplatte hinzurechnen
	(setq oKante_ht (+ oKante_ht anteil_kpl_ht))								(print oKante_ht)
	(setq uKante_ht (+ uKante_ht anteil_kpl_ht))								(print uKante_ht)
	(setq oKante_at	(+ oKante_at anteil_kpl_at))								(print oKante_at)
	(setq uKante_at (+ uKante_at anteil_kpl_at))								(print uKante_at)
	
	; Differenz oben
	(if (< oKante_ht oKante_at)
		(setq diff_oben (- oKante_at oKante_ht))
		(setq diff_oben (- oKante_ht oKante_at))
	)
	(print diff_oben)
	
  ; Differenz unten
	(if (< uKante_ht uKante_at)
		(setq diff_unten (- uKante_at uKante_ht))
		(setq diff_unten (- uKante_ht uKante_at))
	)
	(print diff_unten)
	
	; Maximal- / Minimalwerte ermitteln (okante / ukante)
	(if (<= oKante_ht oKante_at)
		(progn
			(setq max_oKante oKante_ht)
			(setq min_oKante oKante_at)
		)
		(progn
			(setq max_oKante oKante_at)
			(setq min_oKante oKante_ht)
		)
	)
	(if (>= uKante_ht uKante_at)
		(progn
			(setq max_uKante uKante_ht)
			(setq min_uKante uKante_at)
		)
		(progn
			(setq max_uKante uKante_at)
			(setq min_uKante uKante_ht)
		)
	)
	(print max_oKante)
	(print max_uKante)
	(print min_oKante)
	(print min_uKante)
		
	(setq maxDiff (- max_oKante max_uKante))
	(setq minDiff (- min_oKante min_uKante))
	(print maxDiff)
	(print minDiff)
	
	(if (< maxDiff 0.0)
		(setq maxDiff (- maxDiff))
	)
	(if (< minDiff 0.0)
		(setq minDiff (- minDiff))
	)
	(print maxDiff)
	(print minDiff)
	(print "<-----------------------------------------------------------")
)



; ---------------------------------------------------------------------- 
(defun kopfplCorrection (ueb_oben ueb_unten)
	(print ">-----------------------------------------------------------")
	(print "KORREGIERE KOPFPLATTEN")
	
		
	; Korrektur der Kopfplattenhhe, so dass zu beiden Flanschseiten der Traeger
	; mindestens der gewollte berstand entsteht.
	(setq hp_blech_korregiert (+ maxDiff ueb_oben ueb_unten))
	(print hp_blech_korregiert)
	(setq hp_blech_korregiert (runde hp_blech_korregiert auf 5))
	(print hp_blech_korregiert)
	(Blech.set kplHtrg 	(hp hp_blech_korregiert))
	(Blech.set kplTrg 	(hp hp_blech_korregiert))
	
	
	; Magebenden Trger ermitteln, bei dem dok angesetzt wird.
	(if (<= oKante_ht oKante_at)
		(progn
			(print "AT mu verschoben werden.")
			(setq dok_blech (Blech.get kplTrg dok))
			(Blech.set kplTrg (dok (- dok_blech diff_oben)))
		)
		(progn
			(print "HT mu verschoben werden.")
			(setq dok_blech (Blech.get kplHtrg dok))
			(print dok_blech)
			(Blech.set kplHtrg (dok (- dok_blech diff_oben)))
		)
	)
	
)


; ----------------------------------------------------------------------------------------
; SETZT DIE DICKE DER KOPFPLATTEN
; ----------------------------------------------------------------------------------------
(defun setDpKopfplatten (kpl_ht kpl_at)
	
	(setq t_at (Traeger.get Tr_ID t))
	
	(setq t_ht (Traeger.get Htrg t))
	
	(setq t_at_rund (runde t_at auf 5))
	(setq t_ht_rund (runde t_ht auf 5))
	
	(if (>= t_ht t_at)
		(setq dp_kpl t_ht_rund)
		(setq dp_kpl t_at_rund)
	)
	
	(Blech.set kpl_ht (dp dp_kpl))
	(Blech.set kpl_at (dp dp_kpl))
	;(Blech.set kpl_ht (dp 20))
	;(Blech.set kpl_at (dp 20))
	 
)


; ----------------------------------------------------------------------------------------
; SETZT DDEN w0 ABSTAND dES LOCHBILDES
; ----------------------------------------------------------------------------------------
(defun setW0Lochbild (LB_ID BLECH_ID)
	(setq kpl_bp (Blech.get BLECH_ID bp))
	
	
	(setq w0 (* 0.5 kpl_bp))
	(setq w0_rund (runde w0 auf 5.0))
	
	(Lochbild.set LB_ID (w0 w0_rund))
)
; ------------------------
(defun seitliche_Verschiebung ()

(if (= 1 1) (progn 
 (setq rWinkel (Connect.get CastaData r-atrgewnkl_kopf))
 (print rWinkel)
 
 (setq abtl_KplLchb_AT (Traeger.get Tr_ID ABTeil kplLochbild))
 (Anbauteil.Set abtl_KplLchb_AT (kplrwnkl (- rWinkel)))
 (print abtl_KplLchb_AT)
 
 
 (setq h_AT 	  (Traeger.get Tr_ID  h)
       dv_AT      (Traeger.get Tr_ID  delta_V)
       dlr_AT     (Traeger.get Tr_ID  delta_LR)
       h_HT 	  (Traeger.get HTrg   h)
       dv_HT      (Traeger.get HTrg   delta_V)
       dlr_HT     (Traeger.get HTrg   delta_LR)
       h_AT_Halbe (* 0.5 h_AT)
       cosWnkl    (cos (/ (* rWinkel PI) 180.0))
       sinWnkl    (sin (/ (* rWinkel PI) 180.0))
 )

 (print sinWnkl)
 (print cosWnkl)

 (setq 	dl_LR            		(*  (- h_AT_Halbe dv_AT) sinWnkl)
 	dl_DV (- (- h_AT_Halbe dv_AT) 	(*  (- h_AT_Halbe dv_AT) cosWnkl))
 )
 
 (setq  vorh_Dlr (Anbauteil.Get abtl_KplLchb_AT delta_lr)
 	vorh_DV  (Anbauteil.Get abtl_KplLchb_AT delta_V)
 )
 (print vorh_Dlr)
 (setq vorh_Dlr (+ vorh_Dlr (* 1.0 dlr_HT)))

 (setq vorh_DV (- (* 0.5 h_AT) (* 0.5 h_HT) dv_AT (- dv_HT)))


 (print vorh_Dlr)
 (print vorh_DV)

; nderung April 2010
; in der alten Version wurde der Anteil des AT nicht bercksichtigt.
; hier jetzt eingebaut
 (setq dlr_Diff (- (+ dlr_HT dlr_AT)))
  (if (= (Connect.get CastaData rechtesEnde) 1) 
    (if (= (Connect.get CastaData anHtLinkesEnde) 1) 
      (setq 
  	  dlr_Diff        (- (- dlr_HT dlr_AT))
       )
    )
  )
  (if (= (Connect.get CastaData linkesEnde) 1) 
    (if (= (Connect.get CastaData anHtRechtesEnde) 1) 
      (setq 
  	  dlr_Diff        (- (- dlr_HT dlr_AT))
       )
    )
  )
    (print "*clear*")
    (print "----------------------------------------------------------------------- nderung")	

    (print dlr_HT)
    (print dlr_AT)
    (print dlr_Diff)

    (setq dlr_HT_Anteil_H (* dlr_Diff sinWnkl))
    (setq dlr_HT_Anteil_V (* dlr_Diff cosWnkl))
    
    (print dlr_HT_Anteil_H)
    (print dlr_HT_Anteil_V)


  (setq	dlr_AT     (Traeger.get Tr_ID  delta_LR)
  	dlr_HT     (Traeger.get HTrg   delta_LR)
  )


  (if (= (Connect.get CastaData rechtesEnde) 1) 
    (if (= (Connect.get CastaData anHtLinkesEnde) 1) 
      (setq 
  	  dlr_HT_Anteil_H (- dlr_HT_Anteil_H)
  	  dlr_HT_Anteil_V (- dlr_HT_Anteil_V)
       )
    )
  )
  (if (= (Connect.get CastaData linkesEnde) 1) 
    (if (= (Connect.get CastaData anHtRechtesEnde) 1) 
      (setq 
  	  dlr_HT_Anteil_H (- dlr_HT_Anteil_H)
  	  dlr_HT_Anteil_V (- dlr_HT_Anteil_V)
       )
    )
  )
    (print sinWnkl)
    (print vorh_DV)
    (print dl_LR)
    (print vorh_Dlr)
    (print dlr_HT_Anteil_V)


    (print "----------------------------------------------------------------------- Ende nderung")	

  (Anbauteil.Set abtl_KplLchb_AT 
 		(delta_V  (+ dl_DV  (* vorh_DV cosWnkl) dlr_HT_Anteil_H))
 		(delta_LR (- (* vorh_DV sinWnkl) dl_LR  dlr_HT_Anteil_V))
  )

  (if (= (connect.get CastaData linkesEnde) 1) (progn
      (if (= (connect.get CastaData anHtLinkesEnde) 1) (progn
          (Anbauteil.set abtl_KplLchb_AT (SeitRicht -1))
      ))
  ))
  (if (= (connect.get CastaData rechtesEnde) 1) (progn
      (if (= (connect.get CastaData anHtRechtesEnde) 1)  (progn
          (Anbauteil.set abtl_KplLchb_AT (SeitRicht -1))
      ))
  ))

 

))

 
)
