; $	HT	QT(R)	AF(K)		P(E)
; $	AT	QT(R)	AF(K)		P(E)
; $	AE	V(90)		H(90)		R(-)

(defun load-modules ()
   (load "mod-lochbild")
)

(defun init-connection ()
	
  (initAnschluss)
  		
)

(defun initAnschluss ()
	(print "in init-connection - uz_uz_kpl_stoss kreisfrmige Kopf-/Fussplatte");

  ;(connect.ShowAttributes CastaData)

  		

; ---------- Kopfplatten und Lochbild hinzufgen
    (setq kplLochbild (Lochbild.create))
    (setq kplHtrg     (Blech.create))
    (setq kplTrg      (Blech.create))
    
    (Connect.storeAnschlObjs CastaData kplLochbild kplHtrg kplTrg)
    
    (setDpKopfplatten kplHtrg kplTrg)
    (setq dp (Blech.get kplHtrg dp))
    
	(Lochbild.set kplLochbild (S_Bez "M16"))
		
    (if (= 1 1) (progn
					
		(if (= (connect.get CastaData linkesEnde) 1)
			(createRingFlanschKpl Tr_ID kplTrg kplLochbild dp 1)
		)
		(if (= (connect.get CastaData rechtesEnde) 1)
			(createRingFlanschKpl Tr_ID kplTrg kplLochbild dp -1)
		)

		(if (= (connect.get CastaData anHtLinkesEnde) 1) 
			(createRingFlanschKpl HTrg kplHTrg kplLochbild dp  1)
		)
		(if (= (connect.get CastaData anHtRechtesEnde) 1) 
			(createRingFlanschKpl HTrg kplHTrg kplLochbild dp -1)
		)

		(calcAndSetLochbildDaten_1 kplLochbild kplHtrg kplTrg)
		
		(setq Abtl_KplLchb_ht (traeger.get Htrg ABTeil kplLochbild))
		(Anbauteil.set Abtl_KplLchb_ht (Master 1))
		(setq Abtl_KplLchb_at (traeger.get Tr_ID ABTeil kplLochbild))
		(Anbauteil.set Abtl_KplLchb_at (Master 0))
		
	;    (berechneRotation)
	;    (seitliche_Verschiebung)			; neu - April 2010
	  (setq rWinkel (Connect.get CastaData r-atrgewnkl_kopf))
	   (setq mitRota 0)
	   (if (< rWinkel -90.0) (setq mitRota 1))
	   (if (> rWinkel  90.0) (setq mitRota 1))
	;   (if (= mitRota 1)
	;      (berechneRotation)
		  ; else
	;      (seitliche_Verschiebung)
	;   )

		(seitliche_Verschiebung)

		 (setq Radius (Blech.get kplTrg aRadius))
		 (Lochbild.set kplLochbild (LB_Art 4))

		 (Lochbild.set kplLochbild (Anz_S 3))
		 (if (> Radius  60)  (Lochbild.set kplLochbild (Anz_S 4)))
		 (if (> Radius 120)  (Lochbild.set kplLochbild (Anz_S 5)))
		 (if (> Radius 180)  (Lochbild.set kplLochbild (Anz_S 6)))
		 (if (> Radius 240)  (Lochbild.set kplLochbild (Anz_S 7)))
		 
		 (addRadialFahnenblech)

		
		(if (= 1 2) (progn
		  (Lochbild.set kplLochbild (e "0 50 150 0 0 0"))
		  (Lochbild.set kplLochbild (w "10 100"))
		  (Lochbild.set kplLochbild (LB_Art 2))
		  (Anbauteil.set Abtl_KplLchb_ht 		(Master 0))
		  (Anbauteil.set Abtl_KplLchb_at 		(Master 1))
		  (setq dlr_AT (Anbauteil.get Abtl_KplLchb_at delta_lr))
		  (setq dlr_HT (Anbauteil.get Abtl_KplLchb_ht delta_lr))
		  (print dlr_HT)
		  (print dlr_AT)
	;      (Anbauteil.set Abtl_KplLchb_at (delta_lr 0))
		  (setq seitricht_AT (Anbauteil.get Abtl_KplLchb_at SeitRicht))
		  (setq seitricht_HT (Anbauteil.get Abtl_KplLchb_ht    SeitRicht))
		  (print seitricht_HT)
		  (print seitricht_AT)
	;      (Anbauteil.set Abtl_KplLchb_at (SeitRicht 0))
		))
	  
			
			; CALLBACKS
		(Blech.set kplHtrg 	(formFkt "cb_kplHtrg"))
		(Blech.set kplTrg 	(formFkt "cb_kplTrg"))
  )) ; if 1 == 1
)


; ========================================================================================
; CALLBACK-FUNKTIONEN
; ========================================================================================

; ----------------------------------------------------------------------------------------
; Callback fr Kopfplatte am HT
; ----------------------------------------------------------------------------------------
(defun cb_kplHtrg (zp)
	(print "in Callback-Funktion cb_KplBlech")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dpAlt (Blech.get kplHtrg dp))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq dpNeu (Blech.get kplHtrg dp))
	    
	    (print dpAlt) (print dpNeu)
	    
	    (if (/= dpAlt dpNeu) (progn
	       (setq dpDiff (- dpNeu dpAlt))
	       (setq alteKlemml (Lochbild.get kplLochbild Klemml))
	       
	       (Lochbild.set kplLochbild 	(Klemml (+ alteKlemml dpDiff)))
	    ))
	))
)


; ----------------------------------------------------------------------------------------
; Callback fr Kopfplatte am AT
; ----------------------------------------------------------------------------------------
(defun cb_kplTrg (zp)
	(print "in Callback-Funktion cb_KplBlech")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dpAlt (Blech.get kplTrg dp))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq dpNeu (Blech.get kplTrg dp))
	    
	    (print dpAlt) (print dpNeu)
	    
	    (if (/= dpAlt dpNeu) (progn
	       (setq dpDiff (- dpNeu dpAlt))
	       (setq alteKlemml (Lochbild.get kplLochbild Klemml))
	       
	       (Lochbild.set kplLochbild 	(Klemml (+ alteKlemml dpDiff))
	       														;(DxSKopf (+ altesDxS dpDiff))
	       )
	    ))
	))
)



; ----------------------------------------------------------------------------------------
; Erzeugt die Kopfplatten
; ---------------------------------------------------------------------------------------- 
(defun createRingFlanschKpl (Trg blKopfpl lchbKpl dp li_re)
		(print ">---------------------------------------------------------")
		(print "ERZEUGE BERSTEHENDE KOPFPLATTE")
    (if (= li_re  1) (setq TrgEnde (Traeger.get Trg links)))
    (if (= li_re -1) (setq TrgEnde (Traeger.get Trg rechts)))
    
    ; damit es auch wirklich senkrecht gestaltet wird.
    (TrEnde.set TrgEnde (delta_L 0.0) (V_Winkel 90.0))
    
  	(setq dp (* 1.0 dp))
  	
    ;(setq uebOben  10)	;; Kopfplattenposition zum Traeger
    ;(setq uebUnten 80)	;; Kopfplattenposition zum Traeger
    
    (setq b_ht		(Traeger.get Htrg b)
    	  s_ht		(Traeger.get Htrg s)
    	  qsform_ht	(Traeger.get Htrg qsform)
		  h_HT		(Traeger.get Htrg h)
    )
    
    (setq b_at		(Traeger.get Tr_ID b)
    	  s_at		(Traeger.get Tr_ID s)
		  h_AT		(Traeger.get Tr_ID h)
    )
    
    (setq hProf		(Traeger.get Trg h)
          hNetto	hProf
    )
    
	(setq hNetto h_HT)
	(if (> h_AT hNetto) (setq hNetto h_AT))

	(setq hMin h_HT)
	(if (< h_AT hMin) (setq hMin h_AT))

		; Durchmesser ds der Schrauben
    (setq d_schraube (Lochbild.get lchbKpl sdurchm))

	(setq blRadius (+ (* 0.5 hNetto) (* 3 d_schraube)))
	(setq uebOben (- blRadius (* 0.5 hProf)))
	
	(setq Radius_Innen 0)
	(if (> hMin 80) (setq Radius_Innen (- (* 0.5 hMin) 20)))
    
    (Blech.set blKopfpl	
				(dp    dp)
				(aRadius blRadius)
				(iRadius Radius_Innen)
         		(dOK   (- uebOben))
    )
	
    
   
    (if (= li_re  1) (traeger.addabtl Trg blKopfpl 0.0 0.0 _kopfplattelinks_))
    (if (= li_re -1) (traeger.addabtl Trg blKopfpl 0.0 0.0 _kopfplatterechts_))

    (if (= li_re  1) (traeger.addabtl Trg lchbKpl 0.0 0.0 _kpllochbildlinks_))
    (if (= li_re -1) (traeger.addabtl Trg lchbKpl 0.0 0.0 _kpllochbildrechts_))
   
   	
   	
    (print dp)
    (TrEnde.set TrgEnde (delta_l 0)) 
    (TrEnde.pTrim TrgEnde dp)
    (print "<---------------------------------------------------------")
)
; ---------------------------------------------------------------------- 
(defun calcAndSetLochbildDaten_1 (Lchb_ID BlechHT BlechAT)
	(print "--------------------------------------------------------------------------------")
	(print "BERECHNE LOCHBILDDATEN")
	(setq dp_blechHT (Blech.get BlechHT dp))
	(setq dp_blechAT (Blech.get BlechAT dp))
	
	(setq d_schraube (Lochbild.get Lchb_ID sdurchm))
	(setq Radius (Blech.get BlechHT aRadius))
	(setq w0 (- (* 2 Radius) (* 3 d_schraube)))
	
	(Lochbild.set Lchb_ID (Guete   "4.6"))

	(Lochbild.set Lchb_ID	
					(LB_Art		4)		; rundes Lochbild, nur w0 zhlt
					(w0 		w0) 
					(klemml (+ dp_blechHT dp_blechaT))
	)
)
; ---------------------------------------------------------------------- 

; ----------------------------------------------------------------------------------------
; SETZT DIE DICKE DER KOPFPLATTEN
; ----------------------------------------------------------------------------------------
(defun setDpKopfplatten (kpl_ht kpl_at)
	
	(setq t_at (Traeger.get Tr_ID t))
	
	(setq t_ht (Traeger.get Htrg t))
	
	(setq t_at_rund (runde t_at auf 5))
	(setq t_ht_rund (runde t_ht auf 5))
	
	(if (>= t_ht t_at)
		(setq dp_kpl t_ht_rund)
		(setq dp_kpl t_at_rund)
	)
	
	(Blech.set kpl_ht (dp dp_kpl))
	(Blech.set kpl_at (dp dp_kpl))
	;(Blech.set kpl_ht (dp 20))
	;(Blech.set kpl_at (dp 20))
	(Blech.set kpl_ht (BlechTyp 1))		; Typ 1 ist runde Platte, Typ 2 ist Ring
	(Blech.set kpl_at (BlechTyp 1))		; man knnte auch vom Rohrduchmesser abhngig Ring whlen
	
	 
)


; -----------------------------------------------------------------------
(defun berechneRotation ()

 (print "*clear*")
 (print "Berechne Rotation")
 (setq rWinkel (Connect.get CastaData r-atrgewnkl_kopf))
 (print rWinkel)

 
 (setq abtl_KplLchb_AT (Traeger.get Tr_ID ABTeil kplLochbild))
 (Anbauteil.Set abtl_KplLchb_AT (kplrwnkl (- rWinkel)))
 (print abtl_KplLchb_AT)

 (setq SeitenRichtung (Anbauteil.Get abtl_KplLchb_AT SeitRicht))
 (print SeitenRichtung)
 (Anbauteil.Set abtl_KplLchb_AT (SeitRicht -1))


  ;; seitliche Verschiebung des Lochbilds eingebaut AF
  (setq	delta_lr_at	(Traeger.get Tr_ID delta_lr)
		delta_lr_ht	(Traeger.get Htrg delta_lr)
   )
  ; Anschlusstrger seitliche Lochildverschiebung	
  (Anbauteil.set Abtl_KplLchb_at (delta_LR (* 1.0 (- delta_lr_at delta_lr_ht))))

 
; (Lochbild.set kplLochbild (e0 0) (e1 100) (e2 20) (e3 0) (w0 30))
 
 (setq h_AT 	  (Traeger.get Tr_ID h)
       dv_AT      (Traeger.get Tr_ID delta_V)
       dlr_HT     (Traeger.get HTrg  delta_LR)
       h_HT 	  (Traeger.get HTrg h)
       dv_HT      (Traeger.get HTrg delta_V)
       h_AT_Halbe (* 0.5 h_AT)
       cosWnkl    (cos (/ (* rWinkel PI) 180.0))
       sinWnkl    (sin (/ (* rWinkel PI) 180.0))
 )

 (print sinWnkl)
 (print cosWnkl)

 (setq 	dl_LR               (*  (- h_AT_Halbe dv_AT) sinWnkl)
 	dl_DV (- (- h_AT_Halbe dv_AT) (*  (- h_AT_Halbe dv_AT) cosWnkl))
 )
 
 (setq  vorh_Dlr (Anbauteil.Get abtl_KplLchb_AT delta_lr)
 	vorh_DV  (Anbauteil.Get abtl_KplLchb_AT delta_V)
 )
 (setq vorh_Dlr (+ vorh_Dlr (* 1.0 dlr_HT)))
 

 (setq vorh_DV (- (* 0.5 h_AT) (* 0.5 h_HT) dv_AT (- dv_HT)))

 (print vorh_Dlr)
 (print vorh_DV)



 (setq dlr_HT_Anteil_H (* dlr_HT sinWnkl))
 (setq dlr_HT_Anteil_V (* dlr_HT cosWnkl))

  (print dlr_HT_Anteil_H)
  (print dlr_HT_Anteil_V)


)
; ----------------------------------
(defun seitliche_Verschiebung ()

(print "*clear*")

(if (= 1 1) (progn 
 (setq rWinkel (Connect.get CastaData r-atrgewnkl_kopf))
 (setq Fall 1)
 (if (> rWinkel  90.0) (setq Fall 2))
 (if (< rWinkel -90.0) (setq Fall 2))
 (print rWinkel)
 
 (setq abtl_KplLchb_AT (Traeger.get Tr_ID ABTeil kplLochbild))
 (Anbauteil.Set abtl_KplLchb_AT (kplrwnkl (- rWinkel)))
 (print abtl_KplLchb_AT)
 
 
 (setq h_AT 	  (Traeger.get Tr_ID  h)
       dv_AT      (Traeger.get Tr_ID  delta_V)
       dlr_AT     (Traeger.get Tr_ID  delta_LR)
       h_HT 	  (Traeger.get HTrg   h)
       dv_HT      (Traeger.get HTrg   delta_V)
       dlr_HT     (Traeger.get HTrg   delta_LR)
       h_AT_Halbe (* 0.5 h_AT)
       cosWnkl    (cos (/ (* rWinkel PI) 180.0))
       sinWnkl    (sin (/ (* rWinkel PI) 180.0))
 )

 (print sinWnkl)
 (print cosWnkl)

 (setq 	dl_LR            		(*  (- h_AT_Halbe dv_AT) sinWnkl)
 	dl_DV (- (- h_AT_Halbe dv_AT) 	(*  (- h_AT_Halbe dv_AT) cosWnkl))
 )
 
 (setq  vorh_Dlr (Anbauteil.Get abtl_KplLchb_AT delta_lr)
 	vorh_DV  (Anbauteil.Get abtl_KplLchb_AT delta_V)
 )
 (print vorh_Dlr)
 (setq vorh_Dlr (+ vorh_Dlr (* 1.0 dlr_HT)))

 (setq vorh_DV (- (* 0.5 h_AT) (* 0.5 h_HT) dv_AT (- dv_HT)))


 (print vorh_Dlr)
 (print vorh_DV)

; nderung April 2010
; in der alten Version wurde der Anteil des AT nicht bercksichtigt.
; hier jetzt eingebaut
 (setq dlr_Diff (- (+ dlr_HT dlr_AT)))
 (if (= Fall 1) (progn
  (if (= (Connect.get CastaData rechtesEnde) 1) 
    (if (= (Connect.get CastaData anHtLinkesEnde) 1) 
      (setq 
  	  dlr_Diff        (- (- dlr_HT dlr_AT))
       )
    )
  )
  (if (= (Connect.get CastaData linkesEnde) 1) 
    (if (= (Connect.get CastaData anHtRechtesEnde) 1) 
      (setq 
  	  dlr_Diff        (- (- dlr_HT dlr_AT))
       )
    )
  )
 ))
 (if (= Fall 2) (progn
  (if (= (Connect.get CastaData linkesEnde) 1) 
    (if (= (Connect.get CastaData anHtLinkesEnde) 1) 
      (setq 
  	  dlr_Diff        (- (- dlr_HT dlr_AT))
       )
    )
  )
  (if (= (Connect.get CastaData rechtesEnde) 1) 
    (if (= (Connect.get CastaData anHtRechtesEnde) 1) 
      (setq 
  	  dlr_Diff        (- (- dlr_HT dlr_AT))
       )
    )
  )
 ))
  
    (print "*clear*")
    (print "----------------------------------------------------------------------- nderung")	

    (print dlr_HT)
    (print dlr_AT)
    (print dlr_Diff)

    (setq dlr_HT_Anteil_H (* dlr_Diff sinWnkl))
    (setq dlr_HT_Anteil_V (* dlr_Diff cosWnkl))
    
    (print dlr_HT_Anteil_H)
    (print dlr_HT_Anteil_V)


  (setq	dlr_AT     (Traeger.get Tr_ID  delta_LR)
  	dlr_HT     (Traeger.get HTrg   delta_LR)
  )


  (if (= (Connect.get CastaData rechtesEnde) 1) 
    (if (= (Connect.get CastaData anHtLinkesEnde) 1) 
      (setq 
  	  dlr_HT_Anteil_H (- dlr_HT_Anteil_H)
  	  dlr_HT_Anteil_V (- dlr_HT_Anteil_V)
       )
    )
  )
  (if (= (Connect.get CastaData linkesEnde) 1) 
    (if (= (Connect.get CastaData anHtRechtesEnde) 1) 
      (setq 
  	  dlr_HT_Anteil_H (- dlr_HT_Anteil_H)
  	  dlr_HT_Anteil_V (- dlr_HT_Anteil_V)
       )
    )
  )
    (print sinWnkl)
    (print vorh_DV)
    (print dl_LR)
    (print vorh_Dlr)
    (print dlr_HT_Anteil_V)


    (print "----------------------------------------------------------------------- Ende nderung")	

    (if (= (connect.get CastaData linkesEnde) 1) (progn
	      (if (= (connect.get CastaData anHtLinkesEnde) 1) (progn
	          (Anbauteil.set abtl_KplLchb_AT (SeitRicht -1))
	      ))
    ))
    (if (= (connect.get CastaData rechtesEnde) 1) (progn
	      (if (= (connect.get CastaData anHtRechtesEnde) 1)  (progn
	          (Anbauteil.set abtl_KplLchb_AT (SeitRicht -1))
	      ))
    ))

 

))

 
)


(defun addRadialFahnenblech ()

	(setq Schrb_Anz (Lochbild.get kplLochbild Anz_S))

	(setq blRadFahne (Blech.create))
	
	(setq h_HT (Traeger.get HTrg h))
	(setq h_AT (Traeger.get Tr_ID h))
	
	(setq hDiff (- h_HT h_AT))
	(setq XPos 0.0 dOK_Fakt 0 dle_Offset 0.0)

	(Connect.showAttributes CastaData)

    (setq Radius_Bl  (Blech.get KplTrg aRadius))

	(if (> hDiff 50) (progn
		(setq SmallTrg Tr_ID)
		(if (= (Connect.get CastaData LinkesEnde) 1) (progn
			(setq XPos 0  dOK_Fakt 1)
			(setq TrgEnde (Traeger.get Tr_ID links))
			(setq dle_Offset (TrEnde.get TrgEnde delta_L))
		))
		(if (= (Connect.get CastaData RechtesEnde) 1) (progn
			(setq XPos (Traeger.get Tr_ID SysLng) dOK_Fakt -1)
			(setq TrgEnde (Traeger.get Tr_ID rechts))
			(setq dle_Offset (TrEnde.get TrgEnde delta_L))
		))
		(setq bp_RadFaBl (- Radius_Bl (* 0.5 h_AT)))
	))
	(if (< hDiff -50) (progn
		(setq hDiff (- hDiff))
		(setq SmallTrg HTrg)
		(if (= (Connect.get CastaData anHtLinkesEnde) 1) (progn
			(setq XPos 0  dOK_Fakt 1)
			(setq TrgEnde (Traeger.get HTrg links))
			(setq dle_Offset (TrEnde.get TrgEnde delta_L))
		))
		(if (= (Connect.get CastaData anHtRechtesEnde) 1) (progn
			(setq XPos (Traeger.get HTrg SysLng) dOK_Fakt -1)
			(setq TrgEnde (Traeger.get HTrg rechts))
			(setq dle_Offset (TrEnde.get TrgEnde delta_L))
		))
		(setq bp_RadFaBl (- Radius_Bl (* 0.5 h_HT)))
	))

	(if (> hDiff 50.0) (progn
		(setq bp_RadFaBl (runde bp_RadFaBl ab 5))
		
		(print bp_RadFaBl)
		(print Radius_Bl)
		(print h_HT)
		
		(Blech.set blRadFahne 
			(hp (* 2 bp_RadFaBl))
			(bp bp_RadFaBl)
			(dp	12)
		)
		
		
		(setq StartWinkel (* 0.5 (/ 360.0 Schrb_Anz)))
		(traeger.addabtl SmallTrg blRadFahne XPos 0.0  _radial_fahnenblech_)
		
		(setq abtl_RadBl (Traeger.get SmallTrg ABTeil blRadFahne blech))
		(Anbauteil.set abtl_RadBl (Anz Schrb_Anz) (Winkel StartWinkel))

		(setq hp_Bl (Blech.get blRadFahne hp))
		; (Anbauteil.set abtl_RadBl (delta_V (* 0.5 hp_Bl)))
		(if (= dOK_Fakt -1) (progn
			(Blech.set blRadFahne (dOK (- (* -0.5 hp_Bl) dle_Offset)))
			(Blech.set blRadFahne (x3 (* 0.5 bp_RadFaBl)) (y3 (* 1.4 bp_RadFaBl)))
		))
		(if (= dOK_Fakt  1) (progn
			(Blech.set blRadFahne (dOK (+ (*  0.5 hp_Bl) dle_Offset)))
			(Blech.set blRadFahne (x2 (* 0.5 bp_RadFaBl)) (y2 (* 1.4 bp_RadFaBl)))
		))
			

		
		(Connect.storeAnschlObjs CastaData blRadFahne)
	))

)
