; $	HT	QT(K)	AF(K)		P(E)
; $	AT	QT(K)	AF(K)		P(E)
; $	AE	V(90)		H(90)		R(-)

(defun load-modules ()
   (load "mod-lochbild")
)

(defun init-connection ()
	
  (initAnschluss)
  		
)

(defun initAnschluss ()
	(print "in init-connection - uz_uz_kpl_stoss bndige Kopfplatte");

  ;(connect.ShowAttributes CastaData)

  		

; ---------- Kopfplatten und Lochbild hinzufgen
    (setq kplLochbild	(Lochbild.create))
    (setq kplLochbild2	(Lochbild.create))
    (setq kplHtrg		(Blech.create))
    (setq kplTrg		(Blech.create))
	
    (Connect.storeAnschlObjs CastaData kplLochbild kplLochbild2 kplHtrg kplTrg)
    
    (setDpKopfplatten kplHtrg kplTrg)
    (setq dp (Blech.get kplHtrg dp))
    
    (calcSchraube dp) ; -> S_Bez
		(Lochbild.set kplLochbild  (S_Bez S_Bez))
		(Lochbild.set kplLochbild2 (S_Bez S_Bez))
		
		(calcMinRandLochAbst kplLochbild) ; -> e_min, e1_min, e_min_rund, e1_min_rund, h_min
    
    (setq uebOben  (* 2.0 e_min_rund))	;; Kopfplattenposition zum Traeger
    (setq uebUnten (* 2.0 e_min_rund))	;; Kopfplattenposition zum Traeger
    
			
    
    (berechneTraegerUnterschiede)
    (if (= 1 1)
			(progn
				
    (if (= (connect.get CastaData linkesEnde) 1)
        (createUeberstehendeKpl Tr_ID kplTrg kplLochbild kplLochbild2 dp 1)
    )
    (if (= (connect.get CastaData rechtesEnde) 1)
        (createUeberstehendeKpl Tr_ID kplTrg kplLochbild kplLochbild2 dp -1)
    )

    (if (= (connect.get CastaData anHtLinkesEnde) 1) 
        (createUeberstehendeKpl HTrg kplHTrg kplLochbild kplLochbild2 dp  1)
    )
    (if (= (connect.get CastaData anHtRechtesEnde) 1) 
        (createUeberstehendeKpl HTrg kplHTrg kplLochbild kplLochbild2 dp -1)
    )

		(calcAndSetLochbildDaten_1 kplLochbild kplLochbild2 kplHtrg kplTrg)
    
    
    (kopfplCorrection uebOben uebUnten)

    
    (setq Abtl_KplLchb_ht (traeger.get Htrg ABTeil kplLochbild))
    (Anbauteil.set Abtl_KplLchb_ht (Master 1))
    (setq Abtl_KplLchb_at (traeger.get Tr_ID ABTeil kplLochbild))
    (Anbauteil.set Abtl_KplLchb_at (Master 0))

    (setq Abtl_KplLchb2_ht (traeger.get Htrg ABTeil kplLochbild2))
    (Anbauteil.set Abtl_KplLchb2_ht (Master 1))
    (setq Abtl_KplLchb2_at (traeger.get Tr_ID ABTeil kplLochbild2))
    (Anbauteil.set Abtl_KplLchb2_at (Master 0))

    
    (anbauteilKorrektur Abtl_KplLchb_at kplTrg antw)

;    (berechneRotation)
;    (seitliche_Verschiebung)			; neu - April 2010
  (setq rWinkel (Connect.get CastaData r-atrgewnkl_kopf))
   (setq mitRota 0)
   (if (< rWinkel -90.0) (setq mitRota 1))
   (if (> rWinkel  90.0) (setq mitRota 1))
;   (if (= mitRota 1)
;      (berechneRotation)
      ; else
;      (seitliche_Verschiebung)
;   )

    (seitliche_Verschiebung)
	
	; Steifen erzeugen
	(createStiffeners)


    (if (= 1 2) (progn
      (Lochbild.set kplLochbild (e "0 50 150 0 0 0"))
      (Lochbild.set kplLochbild (w "10 100"))
      (Lochbild.set kplLochbild (LB_Art 2))
      (Anbauteil.set Abtl_KplLchb_ht 		(Master 0))
      (Anbauteil.set Abtl_KplLchb_at 		(Master 1))
      (setq dlr_AT (Anbauteil.get Abtl_KplLchb_at delta_lr))
      (setq dlr_HT (Anbauteil.get Abtl_KplLchb_ht delta_lr))
      (print dlr_HT)
      (print dlr_AT)
;      (Anbauteil.set Abtl_KplLchb_at (delta_lr 0))
      (setq seitricht_AT (Anbauteil.get Abtl_KplLchb_at SeitRicht))
      (setq seitricht_HT (Anbauteil.get Abtl_KplLchb_ht    SeitRicht))
      (print seitricht_HT)
      (print seitricht_AT)
;      (Anbauteil.set Abtl_KplLchb_at (SeitRicht 0))
    ))
  
		
		; CALLBACKS
    (Blech.set kplHtrg 	(formFkt "cb_kplHtrg"))
    (Blech.set kplTrg 	(formFkt "cb_kplTrg"))
  ))
)


; ========================================================================================
; CALLBACK-FUNKTIONEN
; ========================================================================================

; ----------------------------------------------------------------------------------------
; Callback fr Kopfplatte am HT
; ----------------------------------------------------------------------------------------
(defun cb_kplHtrg (zp)
	(print "in Callback-Funktion cb_KplBlech")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dpAlt (Blech.get kplHtrg dp))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq dpNeu (Blech.get kplHtrg dp))
	    
	    (print dpAlt) (print dpNeu)
	    
	    (if (/= dpAlt dpNeu) (progn
	       (setq dpDiff (- dpNeu dpAlt))
		   
			(if (objExist kplLochbild) (progn
				(setq alteKlemml (Lochbild.get kplLochbild Klemml))
				(Lochbild.set kplLochbild 	(Klemml (+ alteKlemml dpDiff)))
			))
			(if (objExist kplLochbild2) (progn
				(setq alteKlemml (Lochbild.get kplLochbild2 Klemml))
				(Lochbild.set kplLochbild2 	(Klemml (+ alteKlemml dpDiff)))
			))
			(if (objExist Stf_1_HT) (moveStf Stf_1_HT dpDiff))
			(if (objExist Stf_2_HT) (moveStf Stf_2_HT dpDiff))
			(if (objExist Stf_3_HT) (moveStf Stf_3_HT dpDiff))
			(if (objExist Stf_4_HT) (moveStf Stf_4_HT dpDiff))
			(if (objExist Stf_5_HT) (moveStf Stf_5_HT dpDiff))
			(if (objExist Stf_6_HT) (moveStf Stf_6_HT dpDiff))
			(if (objExist Stf_7_HT) (moveStf Stf_7_HT dpDiff))
			(if (objExist Stf_8_HT) (moveStf Stf_8_HT dpDiff))
	    ))
	))
)


; ----------------------------------------------------------------------------------------
; Callback fr Kopfplatte am AT
; ----------------------------------------------------------------------------------------
(defun cb_kplTrg (zp)
	(print "in Callback-Funktion cb_KplBlech")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dpAlt (Blech.get kplTrg dp))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq dpNeu (Blech.get kplTrg dp))
	    
	    (print dpAlt) (print dpNeu)
	    
	    (if (/= dpAlt dpNeu) (progn
			(setq dpDiff (- dpNeu dpAlt))
	       
		    (if (objExist kplLochbild) (progn
				(setq alteKlemml (Lochbild.get kplLochbild Klemml))
				(Lochbild.set kplLochbild 	(Klemml (+ alteKlemml dpDiff)))
			))
		    (if (objExist kplLochbild2) (progn
				(setq alteKlemml (Lochbild.get kplLochbild2 Klemml))
				(Lochbild.set kplLochbild2 	(Klemml (+ alteKlemml dpDiff)))
			))
			(if (objExist Stf_1) (moveStf Stf_1 dpDiff))
			(if (objExist Stf_2) (moveStf Stf_2 dpDiff))
			(if (objExist Stf_3) (moveStf Stf_3 dpDiff))
			(if (objExist Stf_4) (moveStf Stf_4 dpDiff))
			(if (objExist Stf_5) (moveStf Stf_5 dpDiff))
			(if (objExist Stf_6) (moveStf Stf_6 dpDiff))
			(if (objExist Stf_7) (moveStf Stf_7 dpDiff))
			(if (objExist Stf_8) (moveStf Stf_8 dpDiff))
	    ))
	))
)


; ----------------------------------------------------------------------------------------
; Anbauteil am AT wird korregiert bzw. positioniert
; ----------------------------------------------------------------------------------------
(defun anbauteilKorrektur (ABTL BLECHID antw_ht)
	
	(if (= (Connect.get CastaData linkesEnde) 1)
		(setq AtEnde (Traeger.get Tr_ID links))
		(setq AtEnde (Traeger.get Tr_ID rechts))
	)
	
		
	(setq dp_blech (Blech.get BLECHID dp))
	
	(setq vwnkl_at (TrEnde.get AtEnde v_winkel))
	(print vwnkl_at)
	
	(if (> vwnkl_at 90.0)
		(setq wnkl_at (- vwnkl_at 90.0))
		(setq wnkl_at (- 90.0 vwnkl_at))
	)
	(print wnkl_at)
	
	(setq tanW_at (tan (/ (* PI wnkl_at) 180.0)))
	(print tanW_at)
	
	(setq antW_At (* dp_blech tanW_at))
	(print antW_At)
	(print diff_oben)
	(print oKante_at)
	(print oKante_ht)
	
	(if (> oKante_at oKante_ht)
		(setq delta_v_abtl (- (+ (- diff_oben) antW_At) antw_ht) )
		(setq delta_v_abtl (- (+ diff_oben antW_At) antw_ht))
	)
	(print delta_v_abtl)
	
		
	(if (= (Connect.get CastaData vatr-vhtr) 1)
		(Anbauteil.set ABTL (delta_v  delta_v_abtl))
	)
	(if (= (Connect.get CastaData vatr-vhtr) -1)
		(progn
			(Anbauteil.set ABTL (delta_v  (- delta_v_abtl))
				; (switch_on _unterflansch_)
			)
		)
	)
	
)

; ----------------------------------------------------------------------------------------
; Erzeugt die Kopfplatten
; ---------------------------------------------------------------------------------------- 
(defun createUeberstehendeKpl (Trg blKopfpl lchbKpl lchbKpl2 dp li_re)
		(print ">---------------------------------------------------------")
		(print "ERZEUGE BERSTEHENDE KOPFPLATTE")
    (if (= li_re  1) (setq TrgEnde (Traeger.get Trg links)))
    (if (= li_re -1) (setq TrgEnde (Traeger.get Trg rechts)))
    
    ; damit es auch wirklich senkrecht gestaltet wird.
    (TrEnde.set TrgEnde (delta_L 0.0) (V_Winkel 90.0))
    
  	(setq dp (* 1.0 dp))
  	
    ;(setq uebOben  10)	;; Kopfplattenposition zum Traeger
    ;(setq uebUnten 80)	;; Kopfplattenposition zum Traeger
    
    (setq b_ht		(Traeger.get Htrg b)
    	  s_ht		(Traeger.get Htrg s)
    	  qsform_ht	(Traeger.get Htrg qsform)
    )
    
    (setq b_at		(Traeger.get Tr_ID b)
    	  s_at		(Traeger.get Tr_ID s)
    )
    
    (setq hProf		(Traeger.get Trg h)
          hNetto	hProf
    )
    

    (setq  hp     (+ hNetto uebOben uebUnten))

		; Durchmesser ds der Schrauben
    (setq d_schraube (Lochbild.get lchbKpl sdurchm))
    
    ; Kopfplattenbreite    	
    (if (>= s_ht s_at)
    	(setq mass_s s_ht)
    	(setq mass_s s_at)
    )	
    (if (>= b_ht b_at)
    	(setq mass_b b_ht)
    	(setq mass_b b_at)
    )
    
    (setq min_bp_kpl_aus_minw0 (+ (* 4.0 e_min) mass_s))
    (setq min_bp_kpl_aus_minw0_rund (runde min_bp_kpl_aus_minw0 auf 5.0))
    (print min_bp_kpl_aus_minw0_rund)
    
    (setq mass_b_rund (runde mass_b auf 5))
    (print mass_b_rund)
    
    (if (>= min_bp_kpl_aus_minw0_rund mass_b_rund)
    	(setq breite_kpl min_bp_kpl_aus_minw0_rund)
    	(setq breite_kpl mass_b_rund)
    )
    
    (setq breite_kpl (+ mass_b_rund uebOben uebUnten))

    
    (Blech.set blKopfpl	(dp    dp)
         		(bp    breite_kpl)
         		(hp    hp)
         		(dOK   (- uebOben))
    )
    
    (if (= qsform_ht "U")
    	(progn
    		(setq delta_lr_blech (* 0.5 b_ht))
    		(Blech.set blKopfpl (delta_lr delta_lr_blech))
    	)
    )
    
    (if (= li_re  1) (traeger.addabtl Trg blKopfpl 0.0 0.0 _kopfplattelinks_))
    (if (= li_re -1) (traeger.addabtl Trg blKopfpl 0.0 0.0 _kopfplatterechts_))

    (if (= li_re  1) (traeger.addabtl Trg lchbKpl 0.0 0.0 _kpllochbildlinks_))
    (if (= li_re -1) (traeger.addabtl Trg lchbKpl 0.0 0.0 _kpllochbildrechts_))
   
    (if (= li_re  1) (traeger.addabtl Trg lchbKpl2 0.0 0.0 _kpllochbildlinks_))
    (if (= li_re -1) (traeger.addabtl Trg lchbKpl2 0.0 0.0 _kpllochbildrechts_))
   	
   	
    (print dp)
    (TrEnde.set TrgEnde (delta_l 0)) 
    (TrEnde.pTrim TrgEnde dp)
    (print "<---------------------------------------------------------")
)
; ---------------------------------------------------------------------- 
(defun calcAndSetLochbildDaten_1 (Lchb_ID Lchb_ID2 BlechHT BlechAT)
	(print "--------------------------------------------------------------------------------")
	(print "BERECHNE LOCHBILDDATEN")
	(Lochbild.set Lchb_ID  (Guete   "4.6"))
	(Lochbild.set Lchb_ID2 (Guete   "4.6"))
	
	(setq delta_v_at 	(Traeger.get Tr_ID delta_v)
				r_winkel_at	(Traeger.get Tr_ID r_winkel)
				h_at				(Traeger.get Tr_ID h)
	)
	
	(setq delta_v_ht 	(Traeger.get Htrg delta_v)
				r_winkel_ht	(Traeger.get Htrg r_winkel)
				h_ht				(Traeger.get Htrg h)
	)
	
	(setq dp_blechHT (Blech.get BlechHT dp))
	(setq dp_blechAT (Blech.get BlechAT dp))
	
	; magebenden Trger ermitteln (hier der kleinere)
	(if (= (Connect.get CastaData linkesEnde) 1)	(setq TrgEnde_AT (Traeger.get Tr_ID links)))
	(if (= (Connect.get CastaData rechtesEnde) 1)	(setq TrgEnde_AT (Traeger.get Tr_ID rechts)))
	(if (= (Connect.get CastaData anHtLinkesEnde) 1)	(setq TrgEnde_HT (Traeger.get Htrg links)))
	(if (= (Connect.get CastaData anHtRechtesEnde) 1)	(setq TrgEnde_HT (Traeger.get Htrg rechts)))
	
	(setq vscherl_at (TrEnde.get TrgEnde_AT vscherl))
	(setq vscherl_ht (TrEnde.get TrgEnde_HT vscherl))
	
	(setq vwnkl_ht				(TrEnde.get TrgEnde_HT v_winkel))
	(print vwnkl_ht)
	(if (> vwnkl_ht 90.0)
		(setq wnkl_ht (- vwnkl_ht 90.0))
		(setq wnkl_ht (- 90.0 vwnkl_ht))
	)
	(print wnkl_ht)
	
	(setq tanW_ht (tan (/ (* PI wnkl_ht) 180.0)))
	(print tanW_ht)
	
	; Anteil Neigung 
	(setq antW (* dp_blechHT tanW_ht))
	(print antW)
	
	(setq vscherl_at_halb (* 0.5 vscherl_at))
	(setq vscherl_ht_halb (* 0.5 vscherl_ht))
	
	(if (< vscherl_at vscherl_ht)
		(progn
			(setq h_prof_mass vscherl_at)
			(setq h_prof vscherl_ht)
		)
		(progn
			(setq h_prof_mass vscherl_ht)
			(setq h_prof vscherl_at)
		)
	)
	
	; halbe Scherlnge der Trgerenden
	;(setq h_prof_mass_halb (* 0.5 h_prof_mass))
	;(setq h_prof_halb (* 0.5 h_prof))
	;(print h_prof_mass_halb)
	;(print h_prof_halb)
	
	
	
	(setq massAbstand (* 0.25 minDiff))
	
	(setq viertel (* 0.25 h_prof_mass))
	(print viertel)
	(setq viertel massAbstand)
	(print viertel)
	(print diff_oben)
	(print uebOben)
	(if (< oKante_ht oKante_at)
		(setq e0 (- (- (* 0.5 uebOben) antW)))
		(setq e0 (- (- (+ (* 0.5 uebOben) diff_oben) antW)))
	)
	;(setq e0 diff)
	(setq e0rund (runde e0 auf 5))
	(print e0)
	
	
	(if (= (Connect.get CastaData satr-shtr)  1)
		(progn
			(if (= (Connect.get CastaData vatr-vhtr)  1)
				(progn
					(if (> oKante_ht oKante_at)
						(setq e1 (+ viertel (- e0) antW))
						(setq e1 (+ viertel diff_oben (- e0) antW))
					)
				)
			)
			(if (= (Connect.get CastaData vatr-vhtr) -1)
				(progn
					(if (> oKante_ht oKante_at)
						(setq e1 (+ viertel (- e0) antW))
						(setq e1 (+ viertel diff_oben (- e0) antW))
					)
				)
			)
		)
	)
	(if (= (Connect.get CastaData satr-shtr) -1)
		(progn
			(if (= (Connect.get CastaData vatr-vhtr)  1)
				(progn
					(if (> oKante_ht oKante_at)
						(setq e1 (+ viertel (- e0) antW))
						(setq e1 (+ viertel diff_oben (- e0) antW))
					)
				)
			)
			(if (= (Connect.get CastaData vatr-vhtr) -1)
				(progn
					(if (> oKante_ht oKante_at)
						(setq e1 (+ viertel (- e0) antW))
						(setq e1 (+ viertel diff_oben (- e0) antW))
					)
				)
			)
		)
	)
	
	
	(print e1)
	
	(setq e2 (* 2.0 viertel))
	(print e2)
	
	(if (= (Connect.get CastaData satr-shtr)  1)
		(progn
			(if (= (Connect.get CastaData vatr-vhtr)  1)
				(progn
					(if (> oKante_ht oKante_at)
						(setq e3 (+ viertel (* 0.5 uebUnten) diff_unten)) 
						(setq e3 (+ viertel (* 0.5 uebUnten) diff_unten)) 
					)
				)
			)
			(if (= (Connect.get CastaData vatr-vhtr) -1)
				(progn
					(if (> oKante_ht oKante_at)
						(setq e3 (+ viertel (* 0.5 uebUnten) diff_unten)) 
						(setq e3 (+ viertel (* 0.5 uebUnten) diff_unten)) 
					)
				)
			)
		)
	)
	(if (= (Connect.get CastaData satr-shtr) -1)
		(progn
			(if (= (Connect.get CastaData vatr-vhtr)  1)
				(progn
					(if (> oKante_ht oKante_at)
						(setq e3 (+ viertel (* 0.5 uebUnten) diff_unten)) 
						(setq e3 (+ viertel (* 0.5 uebUnten) diff_unten)) 
					)
				)
			)
			(if (= (Connect.get CastaData vatr-vhtr) -1)
				(progn
					(if (> oKante_ht oKante_at)
						(setq e3 (+ viertel (* 0.5 uebUnten) diff_unten)) 
						(setq e3 (+ viertel (* 0.5 uebUnten) diff_unten)) 
					)
				)
			)
		)
	)
	
	
	
	(print e3)
	
	; w0
	(setq b_halb (* 0.5 breite_kpl))
	(setq w0 b_halb)
	(setq w0_rund (runde w0 auf 5))
	
	(setq w0 breite_kpl)
	(setq w0_rund (- w0 uebOben))

	
	(setq h_HT (Traeger.get HTrg h))
	(if   (> h_HT 150) (progn
		(setq w1 w0_rund)
		(setq w0 (/ w0_rund 3))

		(setq e0_2 (+ e0 e1))
		(setq e1_2  e1)
		(setq w0_2  w1)

		(setq e1 (+ e1 e2 e3))

		
		(setq e2 0) (setq e3 0)
		
		
		(Lochbild.set Lchb_ID	(e0 		e0) 
					(e1 		e1)
					(e2		  e2)
					(e3			e3)
					(w0			w0) 
					(w1			w1) 
					(klemml (+ dp_blechHT dp_blechaT))
		)
		(Lochbild.set Lchb_ID2	
					(e0 		e0_2) 
					(e1 		e1_2)
					(w0			w0_2) 
					(w1			0) 
					(klemml (+ dp_blechHT dp_blechaT))
		)
	))
	(if   (<= h_HT 150) (progn
		(setq w0 w0_rund)
		(setq e1 (+ e1 e2 e3))
		(Lochbild.set Lchb_ID	(e0 		e0) 
					(e1 		e1)
					(e2		0)
					(e3		0)
					(w0			w0) 
					(klemml (+ dp_blechHT dp_blechaT))
		)
	))
	
	
	(print "--------------------------------------------------------------------------------")
	
)
; ---------------------------------------------------------------------- 
(defun kopfplCorrection (ueb_oben ueb_unten)
	(print ">-----------------------------------------------------------")
	(print "KORREGIERE KOPFPLATTEN")
	; hier wird die Gre des kleineren Blechs an das grere Blech angepasst 
	; Korrektur der Kopfplattenhhe, so dass zu beiden Flanschseiten der Traeger
	; mindestens der gewollte berstand entsteht.
	(setq hp_blech_korregiert (+ maxDiff ueb_oben ueb_unten))
	(print hp_blech_korregiert)
	
	(Blech.set kplHtrg 	(hp hp_blech_korregiert))
	(Blech.set kplTrg 	(hp hp_blech_korregiert))
	
	
	; Magebenden Trger ermitteln, bei dem dok angesetzt wird.
	(if (<= oKante_ht oKante_at)
		(progn
			(print "AT mu verschoben werden.")
			(setq dok_blech (Blech.get kplTrg dok))
			(if (= (Connect.get CastaData vatr-vhtr) -1)	(Blech.set kplTrg (dok (- dok_blech diff_unten))))
			(if (= (Connect.get CastaData vatr-vhtr)  1)	(Blech.set kplTrg (dok (- dok_blech diff_oben))))
			
		)
		(progn
			(print "HT mu verschoben werden.")
			(setq dok_blech (Blech.get kplHtrg dok))
			(print dok_blech)
			(Blech.set kplHtrg (dok (- dok_blech diff_oben)))
		)
	)
	
	
	
)


; ----------------------------------------------------------------------------------------
; SETZT DIE DICKE DER KOPFPLATTEN
; ----------------------------------------------------------------------------------------
(defun setDpKopfplatten (kpl_ht kpl_at)
	
	(setq t_at (Traeger.get Tr_ID t))
	
	(setq t_ht (Traeger.get Htrg t))
	
	(setq t_at_rund (runde t_at auf 5))
	(setq t_ht_rund (runde t_ht auf 5))
	
	(if (>= t_ht t_at)
		(setq dp_kpl t_ht_rund)
		(setq dp_kpl t_at_rund)
	)
	
	(Blech.set kpl_ht (dp dp_kpl))
	(Blech.set kpl_at (dp dp_kpl))
	;(Blech.set kpl_ht (dp 20))
	;(Blech.set kpl_at (dp 20))
	 
)


; ----------------------------------------------------------------------------------------
; Berechnet folgende Werte bei unterschiedlichen Trgern
;
; Die Werte beziehen sich auf die Achse der Kontaktflche, also entlang der Schnittflche
;
;	diff_oben:		Abstand der oberen Flanschkanten zueinander
;	diff_unten:		Abstand der unteren Flanschkanten zueinander
;	maxDiff:			Maximale Ausdehnung von obersten zur untersten Flanschkante
; max_oKante:		Maximalwert fr den obersten Flansch
; max_uKante:		Maximalwert fr den untersten Flansch
;	oKante_ht
; oKante_at
; uKante_ht
; uKante_at
;
; ----------------------------------------------------------------------------------------
(defun berechneTraegerUnterschiede ()
	(print ">-----------------------------------------------------------")
	(print "BERECHNE TRGERUNTERSCHIEDE")
	
	(setq h_kpl_ht 	(Blech.get kplHtrg hp)
				dp_kpl_ht	(Blech.get kplHtrg dp)
	)
	(setq h_kpl_at 	(Blech.get kplTrg hp)
				dp_kpl_at	(Blech.get kplTrg dp)
	)
	
	(setq h_ht 				(Traeger.get Htrg h)
				delta_v_ht	(Traeger.get Htrg delta_v)
				rwinkel_ht	(Traeger.get Htrg r_winkel)
	)
	
	(setq h_at				(Traeger.get Tr_ID h)
				delta_v_at	(Traeger.get Tr_ID delta_v)
				rwinkel_at	(Traeger.get Tr_ID r_winkel)
	)
	
	;(setq rwinkel_ht_rot (+ rwinkel_ht 180.0))
	
	;(if (= rwinkel_at rwinkel_ht_rot)
	;	(setq delta_v_at (- delta_v_at))
	;)
	
	(if (= (Connect.get CastaData linkesEnde) 1)	(setq TrgEnde_AT (Traeger.get Tr_ID links)))
	(if (= (Connect.get CastaData rechtesEnde) 1)	(setq TrgEnde_AT (Traeger.get Tr_ID rechts)))
	(if (= (Connect.get CastaData anHtLinkesEnde) 1)	(setq TrgEnde_HT (Traeger.get Htrg links)))
	(if (= (Connect.get CastaData anHtRechtesEnde) 1)	(setq TrgEnde_HT (Traeger.get Htrg rechts)))
	
	(setq vscherl_at 	(TrEnde.get TrgEnde_AT vscherl)		
				vwinkel_at	(TrEnde.get TrgEnde_AT v_winkel)
	)
	(setq vscherl_ht 	(TrEnde.get TrgEnde_HT vscherl)
				vwinkel_ht	(TrEnde.get TrgEnde_HT v_winkel)
	)
	
	(print vscherl_at)
	(print vscherl_ht)
	
	(print vwinkel_at)
	(print vwinkel_ht)
	
	(setq winkel_ht (- 90.0 vwinkel_ht))
	(setq winkel_at (- vwinkel_at 90.0))
	
	(print winkel_at)
	(print winkel_ht)
	
	(if (< winkel_ht 0.0)
		(setq winkel_ht (- winkel_ht))
	)
	(if (< winkel_at 0.0)
		(setq winkel_at (- winkel_at))
	)
	(print winkel_at)
	(print winkel_ht)
	
	(setq tanVW_at	(tan (/ (* PI winkel_at) 180.0)))
	(setq tanVW_ht	(tan (/ (* PI winkel_ht) 180.0)))
	(setq cosVW_at	(cos (/ (* PI winkel_at) 180.0)))
	(setq cosVW_ht	(cos (/ (* PI winkel_ht) 180.0)))
	(print tanVW_ht)
	(print tanVW_at)
	(print cosVW_ht)
	(print cosVW_at)
	
	; Anteil der Kopfplattendicke
	(setq anteil_kpl_ht (* dp_kpl_ht tanVW_ht))
	(setq anteil_kpl_at (* dp_kpl_at tanVW_at))
	
	(print anteil_kpl_ht)
	(print anteil_kpl_at)
		
	(if (< vscherl_at vscherl_ht)
		(progn
			(setq h_prof_mass vscherl_ht)			
			(setq h_prof vscherl_at)
			(setq isHtrg 1)
			(Blech.set kplTrg (hp h_kpl_ht))
		)
		(progn
			(setq h_prof_mass vscherl_at)
			(setq h_prof vscherl_ht)
			(setq isHtrg 0)
			(Blech.set kplHtrg (hp h_kpl_at))
		)
	)
	
	
	(setq vscherl_at_halb (* 0.5 vscherl_at))
	(setq vscherl_ht_halb (* 0.5 vscherl_ht))
	
	(setq delta_v_ht_scher (/ delta_v_ht cosVW_ht))
	(setq delta_v_at_scher (/ delta_v_at cosVW_at))
	
	(print delta_v_ht_scher)
	(print delta_v_at_scher)
	
	; Oberkante der Trger
	(setq oKante_ht (- delta_v_ht_scher vscherl_ht_halb))				(print oKante_ht)
	(setq uKante_ht (+ oKante_ht vscherl_ht))										(print uKante_ht)
	(setq oKante_at	(- delta_v_at_scher vscherl_at_halb))				(print oKante_at)
	(setq uKante_at (+ oKante_at vscherl_at))										(print uKante_at)
		
	(print "-----------------------------------")
	
	; Anteil der Kopfplatte hinzurechnen
	(setq oKante_ht (+ oKante_ht anteil_kpl_ht))								(print oKante_ht)
	(setq uKante_ht (+ uKante_ht anteil_kpl_ht))								(print uKante_ht)
	(setq oKante_at	(+ oKante_at anteil_kpl_at))								(print oKante_at)
	(setq uKante_at (+ uKante_at anteil_kpl_at))								(print uKante_at)
	
	(print "-----------------------------------")
	
	(setq oKante_ht_abs oKante_ht)
	(setq oKante_at_abs oKante_at)
	(setq uKante_ht_abs uKante_ht)
	(setq uKante_at_abs uKante_at)
	
	(if (= 1 1) (progn
	; Absolutwerte
	(if (< oKante_ht_abs 0.0)
		(setq oKante_ht_abs (- oKante_ht_abs))
	)
	(if (< oKante_at_abs 0.0)
		(setq oKante_at_abs (- oKante_at_abs))
	)
	(if (< uKante_ht_abs 0.0)
		(setq uKante_ht_abs (- uKante_ht_abs))
	)
	(if (< uKante_at_abs 0.0)
		(setq uKante_at_abs (- uKante_at_abs))
	)
	
	(print oKante_ht_abs)
	(print oKante_at_abs)
	(print uKante_ht_abs)
	(print uKante_at_abs)
))
	(setq diff_Oben 0.0) ;	Initialisieren, falls kein Fall unten zutreffen sollte (AF 2008)
	(setq e1 0 e2 0 e3 0)
	
	(if (= (Connect.get CastaData vatr-vhtr) 1)
		(progn
			; Differenz oben
			(if (< oKante_ht_abs oKante_at_abs)
				(setq diff_oben (- oKante_at_abs oKante_ht_abs))
				(setq diff_oben (- oKante_ht_abs oKante_at_abs))
			)
			(print diff_oben)
			
		  ; Differenz unten
			(if (< uKante_ht_abs uKante_at_abs)
				(setq diff_unten (- uKante_at_abs uKante_ht_abs))
				(setq diff_unten (- uKante_ht_abs uKante_at_abs))
			)
			(print diff_unten)
		)
	)
	(if (= (Connect.get CastaData vatr-vhtr) -1)
		(progn
			; Differenz oben
			(if (< oKante_ht_abs uKante_at_abs)
				(setq diff_oben (- uKante_at_abs oKante_ht_abs))
				(setq diff_oben (- oKante_ht_abs uKante_at_abs))
			)
			(print diff_oben)
			
		  ; Differenz unten
			(if (< uKante_ht_abs oKante_at_abs)
				(setq diff_unten (- oKante_at_abs uKante_ht_abs))
				(setq diff_unten (- uKante_ht_abs oKante_at_abs))
			)
			(print diff_unten)
		)
	)
	
	
	
	; Maximal- / Minimalwerte ermitteln (okante / ukante)
	(if (<= oKante_ht oKante_at)
		(progn
			(setq max_oKante oKante_ht)
			(setq min_oKante oKante_at)
		)
		(progn
			(setq max_oKante oKante_at)
			(setq min_oKante oKante_ht)
		)
	)
	(if (>= uKante_ht uKante_at)
		(progn
			(setq max_uKante uKante_ht)
			(setq min_uKante uKante_at)
		)
		(progn
			(setq max_uKante uKante_at)
			(setq min_uKante uKante_ht)
		)
	)
	(print max_oKante)
	(print max_uKante)
	(print min_oKante)
	(print min_uKante)
		
	(setq maxDiff (- max_oKante max_uKante))
	(setq minDiff (- min_oKante min_uKante))
	(print maxDiff)
	(print minDiff)
	
	(if (< maxDiff 0.0)
		(setq maxDiff (- maxDiff))
	)
	(if (< minDiff 0.0)
		(setq minDiff (- minDiff))
	)
	(print maxDiff)
	(print minDiff)
	(print "<-----------------------------------------------------------")
)
; -----------------------------------------------------------------------
(defun berechneRotation ()

 (print "*clear*")
 (print "Berechne Rotation")
 (setq rWinkel (Connect.get CastaData r-atrgewnkl_kopf))
 (print rWinkel)

 
 (setq abtl_KplLchb_AT (Traeger.get Tr_ID ABTeil kplLochbild))
 (Anbauteil.Set abtl_KplLchb_AT (kplrwnkl (- rWinkel)))
 (print abtl_KplLchb_AT)

 (setq SeitenRichtung (Anbauteil.Get abtl_KplLchb_AT SeitRicht))
 (print SeitenRichtung)
 (Anbauteil.Set abtl_KplLchb_AT (SeitRicht -1))


  ;; seitliche Verschiebung des Lochbilds eingebaut AF
  (setq	delta_lr_at	(Traeger.get Tr_ID delta_lr)
		delta_lr_ht	(Traeger.get Htrg delta_lr)
   )
  ; Anschlusstrger seitliche Lochildverschiebung	
  (Anbauteil.set Abtl_KplLchb_at (delta_LR (* 1.0 (- delta_lr_at delta_lr_ht))))

 
; (Lochbild.set kplLochbild (e0 0) (e1 100) (e2 20) (e3 0) (w0 30))
 
 (setq h_AT 	  (Traeger.get Tr_ID h)
       dv_AT      (Traeger.get Tr_ID delta_V)
       dlr_HT     (Traeger.get HTrg  delta_LR)
       h_HT 	  (Traeger.get HTrg h)
       dv_HT      (Traeger.get HTrg delta_V)
       h_AT_Halbe (* 0.5 h_AT)
       cosWnkl    (cos (/ (* rWinkel PI) 180.0))
       sinWnkl    (sin (/ (* rWinkel PI) 180.0))
 )

 (print sinWnkl)
 (print cosWnkl)

 (setq 	dl_LR               (*  (- h_AT_Halbe dv_AT) sinWnkl)
 	dl_DV (- (- h_AT_Halbe dv_AT) (*  (- h_AT_Halbe dv_AT) cosWnkl))
 )
 
 (setq  vorh_Dlr (Anbauteil.Get abtl_KplLchb_AT delta_lr)
 	vorh_DV  (Anbauteil.Get abtl_KplLchb_AT delta_V)
 )
 (setq vorh_Dlr (+ vorh_Dlr (* 1.0 dlr_HT)))
 

 (setq vorh_DV (- (* 0.5 h_AT) (* 0.5 h_HT) dv_AT (- dv_HT)))

 (print vorh_Dlr)
 (print vorh_DV)



 (setq dlr_HT_Anteil_H (* dlr_HT sinWnkl))
 (setq dlr_HT_Anteil_V (* dlr_HT cosWnkl))

  (print dlr_HT_Anteil_H)
  (print dlr_HT_Anteil_V)


  (if (= (Connect.get CastaData rechtesEnde) 1) (setq 
  	dlr_HT_Anteil_H (- dlr_HT_Anteil_H)
  	dlr_HT_Anteil_V (- dlr_HT_Anteil_V)
  ))
 	(Anbauteil.Set abtl_KplLchb_AT 
 				(delta_V  (+ dl_DV  (* vorh_DV cosWnkl) dlr_HT_Anteil_H))
 				(delta_LR (- (* vorh_DV sinWnkl) dl_LR  (- vorh_Dlr) dlr_HT_Anteil_V))
 	)


 
(if (= 1 2) (progn
  (if (= (Connect.get CastaData linkesEnde) 1) (progn
 	(Anbauteil.Set abtl_KplLchb_AT 
 				(delta_V  (+ dl_DV  (* vorh_DV cosWnkl) dlr_HT_Anteil_H))
 				(delta_LR (- (* vorh_DV sinWnkl) dl_LR  (- vorh_Dlr) dlr_HT_Anteil_V))
 	)
  ))
  (if (= (Connect.get CastaData rechtesEnde) 1)	(progn
        (setq dlr_HT_Anteil_H (- dlr_HT_Anteil_H))
        (setq dlr_HT_Anteil_V (- dlr_HT_Anteil_V))
 	(Anbauteil.Set abtl_KplLchb_AT 
 				(delta_V     (+ dl_DV  (* vorh_DV cosWnkl) dlr_HT_Anteil_H))
 				(delta_LR (- (* vorh_DV sinWnkl) dl_LR  (- vorh_Dlr) dlr_HT_Anteil_V))
 	)
  ))
))
 
; (setq abtl_KplLchb_HT (Traeger.get HTrg ABTeil kplLochbild))
; (setq dv_HT (Anbauteil.Get abtl_KplLchb_HT delta_V))
; (print dv_HT)
(if (= 1 2) (progn
  (if (= (connect.get CastaData linkesEnde) 1) (progn
      (if (= (connect.get CastaData anHtRechtesEnde) 1) (progn
          (Anbauteil.set abtl_KplLchb_AT (SeitRicht 0))
      ))
  ))
  (if (= (connect.get CastaData rechtesEnde) 1) (progn
      (if (= (connect.get CastaData anHtLinkesEnde) 1)  (progn
          (print  "ndere SeitRicht")
          (Anbauteil.set abtl_KplLchb_AT (SeitRicht -1))
      ))
  ))
))

 
)
; ----------------------------------
(defun seitliche_Verschiebung ()

	(print "*clear*")

	(if (= 1 1) (progn 
	 (setq rWinkel (Connect.get CastaData r-atrgewnkl_kopf))
	 (setq Fall 1)
	 (if (> rWinkel  90.0) (setq Fall 2))
	 (if (< rWinkel -90.0) (setq Fall 2))
	 (print rWinkel)
	 
	 (setq abtl_KplLchb_AT (Traeger.get Tr_ID ABTeil kplLochbild))
	 (Anbauteil.Set abtl_KplLchb_AT (kplrwnkl (- rWinkel)))
	 (print abtl_KplLchb_AT)
	 
	 
	 (setq h_AT 	  (Traeger.get Tr_ID  h)
		   dv_AT      (Traeger.get Tr_ID  delta_V)
		   dlr_AT     (Traeger.get Tr_ID  delta_LR)
		   h_HT 	  (Traeger.get HTrg   h)
		   dv_HT      (Traeger.get HTrg   delta_V)
		   dlr_HT     (Traeger.get HTrg   delta_LR)
		   h_AT_Halbe (* 0.5 h_AT)
		   cosWnkl    (cos (/ (* rWinkel PI) 180.0))
		   sinWnkl    (sin (/ (* rWinkel PI) 180.0))
	 )

	 (print sinWnkl)
	 (print cosWnkl)

	 (setq 	dl_LR            		(*  (- h_AT_Halbe dv_AT) sinWnkl)
		dl_DV (- (- h_AT_Halbe dv_AT) 	(*  (- h_AT_Halbe dv_AT) cosWnkl))
	 )
	 
	 (setq  vorh_Dlr (Anbauteil.Get abtl_KplLchb_AT delta_lr)
		vorh_DV  (Anbauteil.Get abtl_KplLchb_AT delta_V)
	 )
	 (print vorh_Dlr)
	 (setq vorh_Dlr (+ vorh_Dlr (* 1.0 dlr_HT)))

	 (setq vorh_DV (- (* 0.5 h_AT) (* 0.5 h_HT) dv_AT (- dv_HT)))


	 (print vorh_Dlr)
	 (print vorh_DV)

	; nderung April 2010
	; in der alten Version wurde der Anteil des AT nicht bercksichtigt.
	; hier jetzt eingebaut
	 (setq dlr_Diff (- (+ dlr_HT dlr_AT)))
	 (if (= Fall 1) (progn
	  (if (= (Connect.get CastaData rechtesEnde) 1) 
		(if (= (Connect.get CastaData anHtLinkesEnde) 1) 
		  (setq 
		  dlr_Diff        (- (- dlr_HT dlr_AT))
		   )
		)
	  )
	  (if (= (Connect.get CastaData linkesEnde) 1) 
		(if (= (Connect.get CastaData anHtRechtesEnde) 1) 
		  (setq 
		  dlr_Diff        (- (- dlr_HT dlr_AT))
		   )
		)
	  )
	 ))
	 (if (= Fall 2) (progn
	  (if (= (Connect.get CastaData linkesEnde) 1) 
		(if (= (Connect.get CastaData anHtLinkesEnde) 1) 
		  (setq 
		  dlr_Diff        (- (- dlr_HT dlr_AT))
		   )
		)
	  )
	  (if (= (Connect.get CastaData rechtesEnde) 1) 
		(if (= (Connect.get CastaData anHtRechtesEnde) 1) 
		  (setq 
		  dlr_Diff        (- (- dlr_HT dlr_AT))
		   )
		)
	  )
	 ))
	  
		(print "*clear*")
		(print "----------------------------------------------------------------------- nderung")	

		(print dlr_HT)
		(print dlr_AT)
		(print dlr_Diff)

		(setq dlr_HT_Anteil_H (* dlr_Diff sinWnkl))
		(setq dlr_HT_Anteil_V (* dlr_Diff cosWnkl))
		
		(print dlr_HT_Anteil_H)
		(print dlr_HT_Anteil_V)


	  (setq	dlr_AT     (Traeger.get Tr_ID  delta_LR)
		dlr_HT     (Traeger.get HTrg   delta_LR)
	  )


	  (if (= (Connect.get CastaData rechtesEnde) 1) 
		(if (= (Connect.get CastaData anHtLinkesEnde) 1) 
		  (setq 
		  dlr_HT_Anteil_H (- dlr_HT_Anteil_H)
		  dlr_HT_Anteil_V (- dlr_HT_Anteil_V)
		   )
		)
	  )
	  (if (= (Connect.get CastaData linkesEnde) 1) 
		(if (= (Connect.get CastaData anHtRechtesEnde) 1) 
		  (setq 
		  dlr_HT_Anteil_H (- dlr_HT_Anteil_H)
		  dlr_HT_Anteil_V (- dlr_HT_Anteil_V)
		   )
		)
	  )
		(print sinWnkl)
		(print vorh_DV)
		(print dl_LR)
		(print vorh_Dlr)
		(print dlr_HT_Anteil_V)


		(print "----------------------------------------------------------------------- Ende nderung")	

	  (Anbauteil.Set abtl_KplLchb_AT 
			(delta_V  (+ dl_DV  (* vorh_DV cosWnkl) dlr_HT_Anteil_H))
			(delta_LR (- (* vorh_DV sinWnkl) dl_LR  dlr_HT_Anteil_V))
	  )


		(if (= (connect.get CastaData linkesEnde) 1) (progn
			  (if (= (connect.get CastaData anHtLinkesEnde) 1) (progn
				  (Anbauteil.set abtl_KplLchb_AT (SeitRicht -1))
			  ))
		))
		(if (= (connect.get CastaData rechtesEnde) 1) (progn
			  (if (= (connect.get CastaData anHtRechtesEnde) 1)  (progn
				  (Anbauteil.set abtl_KplLchb_AT (SeitRicht -1))
			  ))
		))

	 

	))
 
)

(defun createStiffeners ()

	(setq Stf_1			(Blech.create))
	(setq Stf_2			(Blech.create))
	(setq Stf_3			(Blech.create))
	(setq Stf_4			(Blech.create))
	(setq Stf_5			(Blech.create))
	(setq Stf_6			(Blech.create))
	(setq Stf_7			(Blech.create))
	(setq Stf_8			(Blech.create))
    (Connect.storeAnschlObjs CastaData Stf_1 Stf_2 Stf_3 Stf_4 Stf_5 Stf_6 Stf_7 Stf_8)

	(setq Stf_1_HT		(Blech.create))
	(setq Stf_2_HT		(Blech.create))
	(setq Stf_3_HT		(Blech.create))
	(setq Stf_4_HT		(Blech.create))
	(setq Stf_5_HT		(Blech.create))
	(setq Stf_6_HT		(Blech.create))
	(setq Stf_7_HT		(Blech.create))
	(setq Stf_8_HT		(Blech.create))
    (Connect.storeAnschlObjs CastaData Stf_1_HT Stf_2_HT Stf_3_HT Stf_4_HT Stf_5_HT Stf_6_HT Stf_7_HT Stf_8_HT)

	
	(setq dOK_AT 0)
	(setq delta_L_AT 0)
	(setq delta_L_HT 0)
	(if (= (Connect.get CastaData linkesEnde) 1) (progn
		(setq TE_AT (Traeger.get Tr_ID links))
		(setq delta_L_AT (TrEnde.get TE_AT delta_L))
		(setq xPos_AT 0.0)
		(setq rWinkel_AT 180.0)
	))
	(if (= (Connect.get CastaData rechtesEnde) 1) (progn
		(setq TE_AT (Traeger.get Tr_ID rechts))
		(setq delta_L_AT (TrEnde.get TE_AT delta_L))
		(setq xPos_AT (Traeger.get Tr_ID sysLng))
		(setq rWinkel_AT 0.0)
	))

	(if (= (Connect.get CastaData anHtLinkesEnde) 1) (progn
		(setq TE_AT (Traeger.get HTrg links))
		(setq delta_L_HT (TrEnde.get TE_AT delta_L))
		(setq xPos_HT 0.0)
		(setq rWinkel_HT 180.0)
	))
	(if (= (Connect.get CastaData anHtRechtesEnde) 1) (progn
		(setq TE_AT (Traeger.get HTrg rechts))
		(setq delta_L_HT (TrEnde.get TE_AT delta_L))
		(setq xPos_HT (Traeger.get HTrg sysLng))
		(setq rWinkel_HT 0.0)
	))
	
	(setStfValues_andAdd Tr_ID xPos_AT rWinkel_AT delta_L_AT)
	(setStfValues_andAdd HTrg  xPos_HT rWinkel_HT delta_L_HT)
	
)
(defun setStfValues  (Stf_ID hp bp dp  dOK x1 y1)

	(Blech.set Stf_ID 
		(hp hp)
		(bp bp)
		(dp dp)
		(dOK dOK)
		(x1 x1)
		(y1 y1)
	)

)

(defun setStfValues_andAdd (Trg xPos fWinkl dl_TrgEnde)

	(setq hp_Stf 150)
	(setq bp_Stf  uebOben)
	(setq dp_Stf  10)
	(setq dOK_AT (+ dl_TrgEnde (* 0.5 hp_Stf)))

	(setq h_Trg 50 b_Trg 50)	; initialisieren
	(if (= Trg Tr_ID) (progn
		(setq St1 Stf_1 St2 Stf_2 St3 Stf_3 St4 Stf_4 
			  St5 Stf_5 St6 Stf_6 St7 Stf_7 St8 Stf_8 
		)
	))
	(if (= Trg HTrg) (progn
		(setq St1 Stf_1_HT St2 Stf_2_HT St3 Stf_3_HT St4 Stf_4_HT 
			  St5 Stf_5_HT St6 Stf_6_HT St7 Stf_7_HT St8 Stf_8_HT 
		)
	))
	(setq h_Trg 	(Traeger.get Trg h)
	      b_Trg 	(Traeger.get Trg b)
	)

	(setStfValues St1  hp_Stf bp_Stf dp_Stf dOK_AT 40 40)
	(setStfValues St2  hp_Stf bp_Stf dp_Stf dOK_AT 40 40)
	(setStfValues St3  hp_Stf bp_Stf dp_Stf dOK_AT 40 40)
	(setStfValues St4  hp_Stf bp_Stf dp_Stf dOK_AT 40 40)
	(setStfValues St5  hp_Stf bp_Stf dp_Stf dOK_AT 40 40)
	(setStfValues St6  hp_Stf bp_Stf dp_Stf dOK_AT 40 40)
	(setStfValues St7  hp_Stf bp_Stf dp_Stf dOK_AT 40 40)
	(setStfValues St8  hp_Stf bp_Stf dp_Stf dOK_AT 40 40)
	
	(setq bl_SeitV_Fl (* 0.5 (- b_Trg dp_Stf)))
	(setq bl_SeitV_St (* 0.5 (- h_Trg dp_Stf)))
	
	(blech.set St1 (xAsym  bl_SeitV_Fl))
	(traeger.addabtl Trg St1 xPos fWinkl _fahnenblech_of_)
	(blech.set St2 (xAsym  (- bl_SeitV_Fl)))
	(traeger.addabtl Trg St2 xPos fWinkl _fahnenblech_of_)

	(blech.set St3 (xAsym  bl_SeitV_Fl))
	(traeger.addabtl Trg St3 xPos fWinkl _fahnenblech_uf_)
	(blech.set St4 (xAsym  (- bl_SeitV_Fl)))
	(traeger.addabtl Trg St4 xPos fWinkl _fahnenblech_uf_)

	
	(blech.set St5 (xAsym  bl_SeitV_St))
	(traeger.addabtl Trg St5 xPos fWinkl _fahnenblech_steg_li_)
	(blech.set St6 (xAsym  (- bl_SeitV_St)))
	(traeger.addabtl Trg St6 xPos fWinkl _fahnenblech_steg_li_)

	(blech.set St7 (xAsym  bl_SeitV_St))
	(traeger.addabtl Trg St7 xPos fWinkl _fahnenblech_steg_re_)
	(blech.set St8 (xAsym  (- bl_SeitV_St)))
	(traeger.addabtl Trg St8 xPos fWinkl _fahnenblech_steg_re_)
)
(defun moveStf (Stf dpDiff)
	(if (objExist Stf) (progn
	   (setq dok_Alt (Blech.get Stf dOK))
	   (Blech.set Stf (dOK (+ dok_Alt dpDiff)))
	))

)
