; $ Virtual-Steel Version 3.0
; $ Modul Rundstbe als WIndverbandsanschluss
; $ erweitert auf K-Verbandsknoten
; ----------------------------------------------------------------------------------------
; erstellt den Windverband fr Rohrprofile
; ----------------------------------------------------------------------------------------
(defun init-windverband ()
    (print "********************************************************************")
    (print  "in init-connection - stz_Windverb_1");
  
    ; Einstellungen ............................
    (setq Windverbandsstab_Umsetzen 0)
    (setq K_VerbandsKnBlech         0)
    (setq LB_DEBUG 0)
	
    (setq KONTAKTLAENGE 0)
    (setq ANTEIL_STUETZE 0)
    
    (setq MIN_ABST_AUGENLCHB_BLECHENDE 60) ; Variante 2
   
    (if (objExist knotenBlech)  (progn
        (setq K_VerbandsKnBlech         1)
        ; (print "Knotenblech ist schon angelegt!")
  	(setq knblLochbild	(Lochbild.create))
  	(setq augenBlech	(Blech.create))
  	(Connect.storeAnschlObjs CastaData knblLochbild augenBlech) 
      )
      (progn
        ; (print "Knotenblech ist noch nicht angelegt!\nDies erfolgt nun ...")
  	(setq knotenBlech	(Blech.create))
  	(setq knblLochbild	(Lochbild.create))
  	(setq augenBlech	(Blech.create))
  	(Connect.storeAnschlObjs CastaData knotenBlech knblLochbild augenBlech) 
      )
    )
    
    (calcAndSetKnotenBlechDicke knotenBlech)  ; -> dp_kb
    (calcAndSetAugenBlechDicke augenBlech)	; -> dp_al

	
    (if (< dp_al dp_kb)
		(setq min_blech dp_al)
		(setq min_blech dp_kb)
    )
	
    (calcSchraube min_blech) ; -> S_Bez
    (Lochbild.set knblLochbild (S_Bez S_Bez))
	
    (calcMinRandLochAbst knblLochbild) ; -> e_min, e1_min, e_min_rund, e1_min_rund
	
    ; STD = 0  :	schrges Blech mit zwei Schrauben
    ;     = 1  :	Rechteck-Blech abgechrgt mit einer Schraube
    (if (= STD 0) (progn
		(createKnotenBlech knotenBlech l_schr rand_abst)	
	)
	(progn
		(calcAndSetE0_Var2 knblLochbild parallel_abstand_stz)
		(manualKnotenBlechCreation knblLochbild)
    ))

    (kuerzeProfil knblLochbild parallel_abstand_stz)
  
    (if (= Windverbandsstab_Umsetzen 1) (progn
	(if (= (Connect.get CastaData linkesEnde) 1) (progn
	    (if (= (Connect.get CastaData anschl_anderesende) 0) (positioniereVerband))
	))
        (if (= (Connect.get CastaData rechtesEnde) 1) (progn
	    (if (= (Connect.get CastaData anschl_anderesende) 0) (positioniereVerband))
        ))
    ))


    ; Augenlasche erzeugen
    (createAugenBlech augenBlech)
  
  
    (if (= STD 0)
	(createLochbild knblLochbild knotenBlech augenBlech rand_abst parallel_abstand_stz)
	(createLochbild_Var2 knblLochbild knotenBlech augenBlech parallel_abstand_stz)
    )

    (createAtLochbild knblLochbild)
    
	(if (= (Connect.get CastaData AmHtSteg) 1) (progn
		(createLochbild_LR_Steg)
	))
    (calcKnbl_LR)
	
	(if (= (Connect.get CastaData AmHtFlansch) 1) (progn
		(createLochbild_LR_Flansch)
	))

    
    ; Testen der eingestellten Daten
    (setq AbtlKnbl (Traeger.get HTrg ABTeil knotenBlech))

    (if (= K_VerbandsKnBlech 1) (progn
    	(Anbauteil.set AbtlKnbl (winkel 	 90.0)
    				(delta_v	  0.0)
    	)
    ))

    (if (= 1 2) (progn
	(Lochbild.set knblLochbild (w "0 40") (delta_W 20))
    ))
    (if (= 1 2) (progn
       (setq ABtl_Lochb_HT (Traeger.get HTrg  ABTeil knblLochbild))
       (setq ABtl_Lochb_AT (Traeger.get TR_ID ABTeil knblLochbild))
       (Anbauteil.set ABtl_Lochb_HT (master 1))
       (Anbauteil.set ABtl_Lochb_AT (master 0))
       ; (Anbauteil.set ABtl_Lochb_AT (SeitRicht -1))
       ; (Anbauteil.set ABtl_Lochb_AT (delta_LR -20))
	   ; (Lochbild.set knblLochbild (e "0 25 75 0 0 0"))
    ))

    
)


; ====================================================================== 
(defun kuerzeProfil (Lchb_ID p_abst_stz)
	(print "--------------------------------------------------------------------------------")
	(print "KUERZE PROFIL")
  ; Winkelprofil krzen ...
  ; korrekten Wert noch aus Sttzenprofil und Winkel berechnen
  (setq kuerzLng     0
        h_Ht     	(Traeger.get HTrg h)
        b_Ht     	(Traeger.get HTrg b)
        s_Ht     	(Traeger.get HTrg s)
        t_Ht     	(Traeger.get HTrg t)
        deltaV   	(Traeger.get HTrg delta_V)
        deltaLR  	(Traeger.get HTrg delta_LR)
	qsform_HT	(Traeger.get HTrg qsform)
  )
  (setq b_Trg		(Traeger.get Tr_ID b)			; ist die Frage, wie der Stab liegt
        h_Trg    	(Traeger.get Tr_ID h)			; ob Breite oder Hhe entscheidend sind.
        rwnkl		(Traeger.get Tr_ID r_winkel)
        deltaV_at	(Traeger.get Tr_ID delta_v)
        deltaLR_at	(Traeger.get Tr_ID delta_lr)
  )
  
  
  (if (= (connect.get CastaData amHtOberFlansch) 1) (progn
      (setq kuerzLng (- (* 0.5 h_Ht) deltaV))
  ))
  (if (= (connect.get CastaData amHtUnterFlansch) 1) (progn
      (setq kuerzLng (+ (* 0.5 h_Ht) deltaV))
  ))



  (if (= (connect.get CastaData amHtStegLinks) 1) (progn
      (setq kuerzLng (- (* 0.5 s_Ht) deltaLR))
      (if (= qsform_HT "K") (setq kuerzLng (- (* 0.5 b_Ht) deltaLR)))
      (if (= qsform_HT "R") (setq kuerzLng (- (* 0.5 b_Ht) deltaLR)))
  ))
  (if (= (connect.get CastaData amHtStegRechts) 1) (progn
      (setq kuerzLng (+ (* 0.5 s_Ht) deltaLR))
      (if (= qsform_HT "K") (setq kuerzLng (+ (* 0.5 b_Ht) deltaLR)))
      (if (= qsform_HT "R") (setq kuerzLng (+ (* 0.5 b_Ht) deltaLR)))
  ))

  ;; Mrz 2010 - Windverbandsstab im Bereich der Flansche.
  (setq blch_dlr (Blech.get Knotenblech delta_lr))
  (if (< blch_dlr 0) (setq blch_dlr (- blch_dlr)))	; sozusagen absolut setzen
  
  (if (> blch_dlr (- (* 0.5 h_Ht) t_Ht)) (progn
     ; (print "Mrzerweiterung - Windverbandsablngung")
     (setq qsform_ht (Traeger.get HTrg qsform))

     (if (= (connect.get CastaData amHtStegLinks) 1) (progn
         (setq kuerzLng (- (* 0.5 b_Ht) deltaLR))
         (if (= qsform_ht "U") (setq kuerzLng deltaLR))
     ))
     (if (= (connect.get CastaData amHtStegRechts) 1) (progn
         (setq kuerzLng (+ (* 0.5 b_Ht) deltaLR))
         (if (= qsform_ht "U") (setq kuerzLng (+ b_Ht deltaLR)))
     ))
  ))
  ;; Mrz 2010 - Ende Erweiterung


	(print kuerzLng)
	
  (setq AFl_Winkel (connect.get CastaData at_laengswinkel))
  
  (print AFl_Winkel)
  (setq AFl_Winkel (- AFl_Winkel 90.0))
	(print AFl_Winkel)
  
  (setq sinAWnkl (sin (/ (* PI AFl_Winkel) 180.0))
  			cosAWnkl (cos (/ (* PI AFl_Winkel) 180.0))
  			tanAWnkl (tan (/ (* PI AFl_Winkel) 180.0))
  )
  (print tanAWnkl)
  
  
  ; Anteil, wenn Verbandstab entlang der HT-Lngsachse verschoben wird
	; (abhngig von der Rotation des Winkels)
	; --------------------------------------------------------
	
	(setq A_Winkel (connect.get CastaData at_laengswinkel))
	
	(setq tanAW (tan (/ (* PI A_Winkel) 180.0))
				sinAW	(sin (/ (* PI A_Winkel) 180.0))
	)
	
	
	(print deltaLR_at)
	(print deltaV_at)
	
	(setq delta 0)
	; 1. ANSCHLUSS
	; --------------------------------------------------------------------------------------
	
	; FLANSCH
	(if (= (Connect.get CastaData amHtFlansch) 1)
		(progn
			(if (= (Connect.get CastaData vatr-shtr)  1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta deltaLR_at))
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta (- deltaLR_at)))
				)
			)
			(if (= (Connect.get CastaData vatr-shtr) -1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta deltaLR_at))
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta (- deltaLR_at)))
				)
			)
		)
	)
	
	; STEG
	(if (= (Connect.get CastaData amHtSteg) 1)
		(progn
			(if (= (Connect.get CastaData vatr-vhtr)  1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta deltaLR_at))
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta (- deltaLR_at)))
				)
			)
			(if (= (Connect.get CastaData vatr-vhtr) -1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta deltaLR_at))
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta (- deltaLR_at)))
				)
			)
		)
	)
	(print delta)
	; --------------------------------------------------------------------------------------
	
	
	
	; 2. ANSCHLUSS
	; --------------------------------------------------------------------------------------
	
	(if (> (Connect.get CastaData anschl_anderesEnde) 0)
		(progn
			(setq h_trg_halb (* 0.5 h_trg)) ; TODO: je nach Rotation h oder b verwenden
			
			(if (= 1 2)
				(progn
			(if (= (Connect.get CastaData amHtFlansch) 1)
				(progn
					(if (= (Connect.get CastaData vatr-shtr)  1)
						(progn
							(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta (- delta h_trg_halb)))
							(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta (+ delta h_trg_halb)))
						)
					)
					(if (= (Connect.get CastaData vatr-shtr) -1)
						(progn
							(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta (- delta h_trg_halb)))
							(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta (+ delta h_trg_halb)))
						)
					)
				)
			)
		))
			
			
			
		)
	)

	; --------------------------------------------------------------------------------------
	(print delta)
	
	(setq anteil_delta (/ delta tanAW))
  (print anteil_delta)
  
  (setq abstand_Stz p_abst_stz)
		  
	(if (= cosAWnkl 0.0) (setq cosAWnkl 1.0))
		  
	(setq anteil_Stz (/ kuerzLng cosAWnkl))
	(setq ANTEIL_STUETZE anteil_Stz)
  
  (if (= STD 0)
  	(progn
		  
		  (setq anteil_Verb (* b_Trg tanAWnkl))
		  
		  ; Soll-Kontaktlnge zwichen Augenlasche und Knotenblech
			(print AFl_Winkel)
			(setq tan_afl	(tan (/ (* PI AFl_Winkel) 180.0)))
			(print tan_afl)
			(if (< tan_afl 0) (setq tan_afl (- tan_afl)))
			(print tan_afl)
			(setq diff_1 (* rand_abst tan_afl))
			(print diff_1)
			(setq diff_2 (- p_abst_stz diff_1))
			(print diff_2)
			(setq kontakt_laenge (- l_schr diff_2))
			(setq KONTAKTLAENGE kontakt_laenge)
			(print kontakt_laenge)
			(print l_schr)
		  (setq anteil_augenlasche (+ diff_1 diff_2 (* kontakt_laenge 1.25)))
		  
		  (print abstand_Stz)
		  (print anteil_Stz)
		  (print anteil_Verb)
		  (print anteil_augenlasche)
		  (print anteil_delta)
		  
		  (if (< AFl_Winkel 0) 
		  	(setq deltaLNeu (+ anteil_Stz (- anteil_Verb) anteil_augenlasche anteil_delta))
		  	(setq deltaLNeu (+ anteil_Stz anteil_Verb anteil_augenlasche anteil_delta))
		  )
		)
		(progn
			(setq lb_e0 (Lochbild.get Lchb_ID e0))
			(setq anteil_rand_abst (/ lb_rand_abst sinAW))
			
			(setq deltaLNeu (+ anteil_Stz lb_e0 h_Trg anteil_rand_abst anteil_delta))
		)
	)
  
  
  
  (print deltaLNeu)
  ;(print kuerzLng)
  ;(print b_Trg)
  ;(print abstand_Stz)
  ;(print anteil_Stz)
  ;(print anteil_Verb)
  ;(print deltaLNeu)
  
  
  
	;Krzen
  (if (= (connect.get CastaData LinkesEnde) 1) (progn
      (setq TrE_Links (Traeger.get Tr_ID links))
      (TrEnde.set TrE_Links (delta_L 0))
      (TrEnde.pTrim TrE_Links deltaLNeu)
  ))
  (if (= (connect.get CastaData RechtesEnde) 1) (progn
      (setq TrE_Rechts (Traeger.get Tr_ID rechts))
      (TrEnde.set TrE_Rechts (delta_L 0))			; erst einmal zurcksetzen
      (TrEnde.pTrim TrE_Rechts deltaLNeu)			; dann krzen
  ))

	(print "--------------------------------------------------------------------------------")

)

; ****************************************************************************************
; Verschiebt den Trger passend zum Knotenblech
; ****************************************************************************************
(defun positioniereVerband ()
	(print "--------------------------------------------------------------------------------")		
	(print "POSITIONIERE VERBAND")
	
  (setq RWinkel (Traeger.get Tr_ID R_Winkel)
        dp      (Blech.get   knotenBlech  dp)
        dp_al		(Blech.get	 augenBlech		dp)
  )
  (print RWinkel)
  (print dp)
  (print dp_al)
	(setq dp (* 0.5 (+ dp dp_al)))
	
  ;Positionieren
  (setq delta_V 0)
  
	(if (= (Connect.get CastaData amHtSteg) 1) (progn
	    (if (= (Connect.get CastaData satr-lhtr) -1) (setq delta_V 		(- delta_v_at dp)	))
	    (if (= (Connect.get CastaData satr-lhtr)  1) (setq delta_V 		(+ delta_v_at dp)	))
	    (if (= (Connect.get CastaData vatr-vhtr) -1) (progn
		(if (= (Connect.get CastaData satr-lhtr) -1) (setq delta_V 		(+ delta_v_at dp)	))
		(if (= (Connect.get CastaData satr-lhtr)  1) (setq delta_V 		(- delta_v_at dp)	))
	    ))
	))
	
	(if (= (Connect.get CastaData amHtFlansch) 1)
		(progn
			(if (= (Connect.get CastaData satr-lhtr) -1) (setq delta_V 	(+ delta_v_at dp)))
			(if (= (Connect.get CastaData satr-lhtr)  1) (setq delta_V 	(- delta_v_at dp)))
			
			(if (= (Connect.get CastaData vatr-shtr) -1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr) -1) (setq delta_V 	(- delta_v_at dp)))
					(if (= (Connect.get CastaData satr-lhtr)  1) (setq delta_V 	(+ delta_v_at dp)))
				)
			)
		)
	)
	
	(print delta_V)
	
	(Traeger.set Tr_ID (delta_V delta_V))
	
	(print "--------------------------------------------------------------------------------")		
)

; ----------------------------------------------------------------------
; ---------------------------------------------------------------------- 
(defun createKnotenBlech (Blech_ID l_schr rand_abst)
	(print "------------------------------------------------------------")
	(print "ERZEUGE KNOTENBLECH")
	
	
  
  ; Default-Werte des Blechs
  (Blech.set Blech_ID (hp 200)
      								(bp 120)
  )
	
	; allg. Daten
	(setq	b_Trg   	(Traeger.get Tr_ID b)
		h_Trg	  	(Traeger.get Tr_ID h)
		RWinkel 	(Traeger.get Tr_ID R_Winkel)
		delta_v_at 	(Traeger.get Tr_ID delta_v)
		delta_lr_at	(Traeger.get Tr_ID delta_lr)
	)
	
	(setq	delta_v_ht 	(Traeger.get Htrg delta_v)
		delta_lr_ht	(Traeger.get Htrg delta_lr)
	)
	
	
	(setq anschl_winkel (Connect.get CastaData at_laengswinkel))
	
	(print anschl_winkel)
	
	(if (< anschl_winkel 0.0)
		(if (< anschl_winkel (- 180.0))
			(setq anschl_winkel (+ anschl_winkel 360.0))
			(setq anschl_winkel (+ anschl_winkel 90.0))
		)
	)
	(print anschl_winkel)
	; wenn schrg, wird afl_winkel negativ ausgegeben ?????
	;(setq anschl_winkel (- anschl_winkel))
	
	(setq sinAW (sin (/ (* PI anschl_winkel) 180.0)))
	(print sinAW)
	
	
	(print RWinkel)
	(setq dp_knbl (Blech.get Blech_ID dp))
	
	  
  ; lokale Verschiebung des Windverbandes bestimmen
  (setq wv_versatz 0)
  
  (if (= Windverbandsstab_Umsetzen 1) (progn
	; +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	; 1. Anschluss (es liegt noch kein Anschluss am Windverbandstab vor)
	; +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	(calcFirstConnection)
		
	; +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	; 2. Anschluss
	; +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	; Wenn der Traeger bereits angeschlossen ist, mu das zweite Blech versetzt werden 
	(if (> (Connect.get CastaData anschl_anderesEnde) 0) (progn
		(calcSecondConnection)
	))
  ))
  ; nderung Mrz 2010 - keine Verschiebung des Windverbandsstabs vorsehen
  (if (= Windverbandsstab_Umsetzen 0) (progn
	(calcFirstConnection)
	(calcSecondConnection)
  ))
  
    (if (= K-Verband 0) (progn		
	  (if (= (connect.get CastaData amHtOberFlansch) 1) (progn
	      (traeger.addabtl Htrg Blech_ID 0.0 0.0 _knotenblech_of_)  ;
	  ))
	  (if (= (connect.get CastaData amHtUnterFlansch) 1) (progn
	      (traeger.addabtl Htrg Blech_ID 0.0 0.0 _knotenblech_uf_)  ;
	  ))
	  (if (= (connect.get CastaData amHtStegLinks) 1) (progn
	      (traeger.addabtl Htrg Blech_ID 0.0 0.0 _knotenblech_steg_li_)  ;    
	  ))
	  (if (= (connect.get CastaData amHtStegRechts) 1) (progn
	      (traeger.addabtl Htrg Blech_ID 0.0 0.0 _knotenblech_steg_re_)  ;    
	  ))
    ))  
  
  
    (setq xPosStz      (Connect.get CastaData xPos_HT))
    ;(setq WnklAnschlFl (Connect.get CastaData afl_vwinkel))
  
    ; Verschiebung des HT delta_v / delta_lr
    (calcXPosDelta_HT)
	
    ; Verschiebung des AT delta_v / delta_lr
    (calcXPosDelta_AT)
	
    ; xPos setzen

;    (Connect.showAttributes CastaData)
    (setq xPosOrg (Connect.get CastaData xPos_HT))
    (print xPosOrg)
    (print xPosStz)
    (setq xPosStz xPosOrg)

    (setq AbtlKnBlech (traeger.get Htrg ABTeil Blech_ID))
    (Anbauteil.set  AbtlKnBlech (xpos xPosStz))

    ; d_schr berechnen	
    (setq d_schr (+ h_Trg rand_abst))
	
    (setq min_d_schr (+ e_min_rund rand_abst))
	
    (if (< d_schr min_d_schr)
		(setq d_schr min_d_schr)
    )
	
	(print d_Schr)
	(print l_schr)
	(print anschl_winkel)
    ; Objekt.Methode         Variable 	d_Schr 	l_Schrb  	SchrAchsWnkl
    (Blech.knotenblechschraeg Blech_ID 	d_schr 	l_schr  	anschl_winkel)
    (print knotenblech_soll_versatz)
    
    ; wenn es sich nicht um einen K-Verband handelt, dann das Knotenblech
    ; versetzen
    (if (= K_VerbandsKnBlech 0) 
        (Blech.set Blech_ID (delta_lr knotenblech_soll_versatz))
    )
  												
 
    (print "ENDE KNOTENBLECH")
    (print "------------------------------------------------------------")
)

; ----------------------------------------------------------------------------------------
; Erzeugt das Lochbild
; ----------------------------------------------------------------------------------------
(defun createLochbild (Lchb_ID BlechID BlechAuge rand_abst p_abstand_stz)
	(print "------------------------------------------------------------")
	(print "ERZEUGE LOCHBILD")

	
	(Lochbild.set Lchb_ID 	
		(Guete		"4.6")
		(w		"0 0")
		(e		"0 0 0 0 0 0")
		(Anz_S		3)
		(dok 		0)
	)
	
	
	; allg. Daten
	(setq	dp_Blech 	(Blech.get BlechID dp)
		d_sch 		(Blech.get BlechID knbl_dschr)
		l_sch		(Blech.get BlechID knbl_lschr)
	)
	
	(setq dp_Auge		(Blech.get BlechAuge dp))
	
	(setq	t_Trg 		(Traeger.get Tr_ID t)
		s_Trg		(Traeger.get Tr_ID s)
		b_Trg		(Traeger.get Tr_ID b)
		r_winkel	(Traeger.get Tr_ID r_winkel)
		delta_lr_at	(Traeger.get Tr_ID delta_lr)
	)
	(setq	delta_v_ht	(Traeger.get Htrg delta_v)
		delta_lr_ht	(Traeger.get Htrg delta_lr)
	)
	
	(setq xPos_ht (Connect.get CastaData xPos_ht))
	
	; Klemmlnge
	(setq klemml (+ dp_Auge dp_Blech))
	
	(setq dxS 0)
	; dxSKopf Anschluss am Steg
	(if (= (Connect.get CastaData amHtSteg) 1)
		(progn
			(if (= (Connect.get CastaData satr-vhtr)  1) (setq dxS    (* 0.5 dp_blech)))
			(if (= (Connect.get CastaData satr-vhtr) -1) (setq dxS (+ (* 0.5 dp_blech) dp_Auge)))
			(if (= (Connect.get CastaData vatr-vhtr)  1) (setq dxS (+ (* 0.5 dp_blech) dp_Auge)))
			(if (= (Connect.get CastaData vatr-vhtr) -1) (setq dxS    (* 0.5 dp_blech)))
			(if (= (Connect.get CastaData satr-lhtr) -1) (setq dxS (+ (* 0.5 dp_blech) dp_Auge)))
			(if (= (Connect.get CastaData satr-lhtr)  1) (setq dxS    (* 0.5 dp_blech)))				
		)
	)


	
	; dxSKopf Anschluss am Flansch
	(if (= (Connect.get CastaData amHtFlansch) 1) (progn
	    (if (= (Connect.get CastaData satr-lhtr)  1) (setq dxS (+ (* 0.5 dp_blech) dp_Auge)))
	    (if (= (Connect.get CastaData satr-lhtr) -1) (setq dxS    (* 0.5 dp_blech)))
	))
	
	; Kontaktlnge zwichen AT und Knotenblech

	
	(setq afl_wnkl (Connect.get CastaData at_laengswinkel))
	
	(setq afl_wnkl (- afl_wnkl 90.0))
	(setq tan_afl	(tan (/ (* PI afl_wnkl) 180.0)))
	(if (< tan_afl 0) (setq tan_afl (- tan_afl)))
	(setq diff_1 (* rand_abst tan_afl))
	(setq diff_2 (- p_abstand_stz diff_1))
	(setq kontakt_laenge (- l_sch diff_2))


	(setq kontakt_laenge KONTAKTLAENGE)
	; e-Werte
	
	(setq e_abst (* 0.25 kontakt_laenge)) ; erstmal gleichmig verteilen 
	(print e_abst)
	
	(setq anteil_verbindung (* b_Trg tan_afl))
	(print anteil_verbindung)

	;; Mrz 2010 - Erweiterung auf Knotenbleche auf Flanschkante
	(setq anFlansch_Aussenkante 0)
	(setq AbstandFlansch 0.0)
	(setq blch_dlr (Blech.get Knotenblech delta_lr))
  	(if (< blch_dlr 0) (setq blch_dlr (- blch_dlr)))	; sozusagen absolut setzen
  	(if (> blch_dlr (- (* 0.5 h_Ht) t_Ht)) (setq anFlansch_Aussenkante 1))
  
	(setq qsform_HT	(Traeger.get HTrg qsform))
	(if (= (connect.get CastaData amHtSteg) 1) (progn
	    (if (= qsform_HT "K") (setq anFlansch_Aussenkante 1))
	    (if (= qsform_HT "R") (setq anFlansch_Aussenkante 1))
	))
  
  	(if (= anFlansch_Aussenkante 1) (progn
  	    ; (print "Mrzerweiterung - Berechne Schrauben e0 - STD 0")
	    (setq cos_Afl	(cos (/ (* PI afl_wnkl) 180.0)))
	    (setq b_Ht 		(Traeger.get HTrg b))
	    (setq h_Ht 		(Traeger.get HTrg h))
	
	    (if (= (connect.get CastaData amHtStegLinks) 1) (progn
	         (if (= qsform_ht "U") 
	         	(setq b_Ht 0)
	         	(setq b_Ht (* 0.5 b_Ht))
	         )
	    ))
	    (if (= (connect.get CastaData amHtStegRechts) 1) (progn
	         (if (= qsform_ht "U") 
	         	(setq b_Ht b_Ht)
	         	(setq b_Ht (* 0.5 b_Ht))
	         )
	    ))

	    (if (/= cos_Afl 0.0) (progn
		(setq AbstandFlansch (/ b_Ht cos_Afl))
	    ))
	    ; Juli 2010 - korrigiert, da Abstandflansch ansonsten
	    ; falsch berechnet wurde.
	    (if (= (connect.get CastaData amHtFlansch) 1) (progn
		(if (/= cos_Afl 0.0) (progn
		    (setq AbstandFlansch (/ (* 0.5 h_Ht) cos_Afl))
;		    (print AbstandFlansch)
		))
	    ))

	))
	;; Ende Erweiterung Mrz 2010

	;; 2019-07-25 --- Abstandflansch wird durch delta_V im ABTeil abgedeckt
	; (if (= (Connect.get CastaData amHtSteg) 1) (progn
		(setq R_oder_K_Profil 0)
		(if (= qsform_HT "R") (setq R_oder_K_Profil 1))
		(if (= qsform_HT "K") (setq R_oder_K_Profil 1))
		(if (= R_oder_K_Profil 1) (progn
			(setq AbstandFlansch 0.0)
		))
	; ))

	; Berechnung e0	
	(setq e0 (+ anteil_verbindung p_abstand_stz e_abst AbstandFlansch))


	(setq  dxS 0.0)
	(if (= (Connect.get CastaData amHtSteg) 1) (progn
		(setq schrauben_versatz knotenblech_soll_versatz)
		(if (= (Connect.get CastaData amHtStegLinks) 1) (progn
		  (if (= (Connect.get CastaData linkesEnde) 1) (progn
		    (if (= (Connect.get CastaData vAtr-vHtr)  1)  (setq  dxS  5.0))
		    (if (= (Connect.get CastaData vAtr-vHtr) -1)  (setq  dxS 15.0))
		  ))
		  (if (= (Connect.get CastaData rechtesEnde) 1) (progn
		    (if (= (Connect.get CastaData vAtr-vHtr) -1)  (setq  dxS  5.0))
		    (if (= (Connect.get CastaData vAtr-vHtr)  1)  (setq  dxS 15.0))
		  ))
		))
		(if (= (Connect.get CastaData amHtStegRechts) 1) (progn
		  (if (= (Connect.get CastaData linkesEnde) 1) (progn
		    (if (= (Connect.get CastaData vAtr-vHtr)  1)  (setq  dxS 15.0))
		    (if (= (Connect.get CastaData vAtr-vHtr) -1)  (setq  dxS  5.0))
		  ))
		  (if (= (Connect.get CastaData rechtesEnde) 1) (progn
		    (if (= (Connect.get CastaData vAtr-vHtr) -1)  (setq  dxS 15.0))
		    (if (= (Connect.get CastaData vAtr-vHtr)  1)  (setq  dxS  5.0))
		  ))
		))
	))
	; dxSKopf Anschluss am Flansch
	(if (= (Connect.get CastaData amHtFlansch) 1) (progn
		(setq dlr_HT (Traeger.get HTrg delta_LR))
		(if (= (Connect.get CastaData satr-lhtr)  1) (setq dxS (+ (* 0.5 dp_blech) dp_Auge)))
		(if (= (Connect.get CastaData satr-lhtr) -1) (setq dxS (* 0.5 dp_blech)))
	))

	; Werte setzen
	(Lochbild.set Lchb_ID 	(klemml		klemml)
				(dxSKopf	dxS)
				(e0		e0)
				(e1 		(* 1.5 e_abst))
	)
	
	; Lochbild dem HT hinzufgen
	(setq AbtlKnoBl	(Traeger.get Htrg AbTeil BlechID))
	(Traeger.addabtl Htrg Lchb_ID 0.0 0.0 _knblLochbild_ AbtlKnoBl)
	
	(setq AbtlKnoBlLchb    (Traeger.get Htrg AbTeil Lchb_ID))
	(Anbauteil.set AbtlKnoBlLchb 
		(delta_sx knotenblech_soll_versatz)
		(Master 1)
	)
;	(if (= (Connect.get CastaData amHtSteg) 1) (progn
;	    (if (= (Connect.get CastaData vatr-vhtr) -1) (print "Seitenrichtung ndern"))
;	))
;	(if (= (Connect.get CastaData amHtSteg) 1) (progn
;	    (if (= (Connect.get CastaData vatr-vhtr) -1) (Anbauteil.set AbtlKnoBlLchb (SeitRicht -1)))
;	))
;	(if (= (Connect.get CastaData amHtFlansch) 1) (progn
;	    (if (= (Connect.get CastaData vatr-shtr)  1) (Anbauteil.set AbtlKnoBlLchb (SeitRicht -1)))
;	))	
	
	(setq	blch_dlr  	(BLech.get BlechID delta_lr)
		dp_KnBl		(BLech.get BlechID dp)
		deltaV_at	(Traeger.get Tr_ID delta_v)
	)
	
	(print "ENDE LOCHBILD")
	(print "------------------------------------------------------------")
)


(defun createATLochbild (Lchb_ID)
	(print ">-----------------------------------------------------------")
	(print "ERZEUGE LOCHBILD AM AT")
	
	; TEST
	; +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	
	; +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	
	; Lochbildanbauteil whlen
	(if (= (Connect.get CastaData amHtFlansch) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(progn
					(if (= (Connect.get CastaData satr-shtr)  1)	(setq WINDVERBAND_LB _windvblchb_steg_links_)	)
					(if (= (Connect.get CastaData satr-shtr) -1)	(setq WINDVERBAND_LB _windvblchb_steg_links_)	)
					(if (= (Connect.get CastaData vatr-shtr)  1)	(setq WINDVERBAND_LB _windvblchb_flansch_links_)	)
					(if (= (Connect.get CastaData vatr-shtr) -1)	(setq WINDVERBAND_LB _windvblchb_flansch_links_)	)
				)
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(progn
					(if (= (Connect.get CastaData satr-shtr)  1)	(setq WINDVERBAND_LB _windvblchb_steg_rechts_)	)
					(if (= (Connect.get CastaData satr-shtr) -1)	(setq WINDVERBAND_LB _windvblchb_steg_rechts_)	)
					(if (= (Connect.get CastaData vatr-shtr)  1)	(setq WINDVERBAND_LB _windvblchb_flansch_rechts_)	)
					(if (= (Connect.get CastaData vatr-shtr) -1)	(setq WINDVERBAND_LB _windvblchb_flansch_rechts_)	)
				)
			)
		)
	)
	(if (= (Connect.get CastaData amHtSteg) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(progn
					(if (= (Connect.get CastaData vatr-shtr)  1)	(setq WINDVERBAND_LB _windvblchb_steg_links_)	)
					(if (= (Connect.get CastaData vatr-shtr) -1)	(setq WINDVERBAND_LB _windvblchb_steg_links_)	)
					
					(if (= (Connect.get CastaData satr-shtr)  1)	(setq WINDVERBAND_LB _windvblchb_flansch_links_)	)
					(if (= (Connect.get CastaData satr-shtr) -1)	(setq WINDVERBAND_LB _windvblchb_flansch_links_)	)
					
					(if (= (Connect.get CastaData satr-shtr)  0)	(setq WINDVERBAND_LB _windvblchb_flansch_links_)	)
				)
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(progn
					(if (= (Connect.get CastaData vatr-shtr)  1)	(setq WINDVERBAND_LB _windvblchb_steg_rechts_)	)
					(if (= (Connect.get CastaData vatr-shtr) -1)	(setq WINDVERBAND_LB _windvblchb_steg_rechts_)	)
					(if (= (Connect.get CastaData satr-shtr)  1)	(setq WINDVERBAND_LB _windvblchb_flansch_rechts_)	)
					(if (= (Connect.get CastaData satr-shtr) -1)	(setq WINDVERBAND_LB _windvblchb_flansch_rechts_)	)
					
					(if (= (Connect.get CastaData satr-shtr)  0)	(setq WINDVERBAND_LB _windvblchb_flansch_rechts_)	)
				)
			)
		)
	)
	
	(setq h_at	(Traeger.get Tr_ID h)
				b_at	(Traeger.get Tr_ID b)
	)
	(print h_at)
	(print b_at)
	(setq delta_v_abtl_at 0)
	(setq delta_lr_abtl_at 0)
	
	
	

	; Anteil delta_v HT
	; ----------------------------------------------
	(if (= (Connect.get CastaData amHtFlansch) 1)
		(progn
			(setq delta_v_ht	(Traeger.get Htrg delta_v))
			(print delta_v_ht)
			
			(setq at_winkel (Connect.get CastaData at_laengswinkel))
			(print at_winkel)
			
			(setq sinW (sin (/ (* PI at_winkel) 180.0)))
			(setq cosW (cos (/ (* PI at_winkel) 180.0)))
			(print cosW)
			(print sinW)
			
			;(if (/= cosW 0.0)
			;	(setq anteil_delta_v_abtl_ht (/ (* 1.0 delta_v_ht) cosW))
			;)
			(if (/= sinW 0.0)
				(setq anteil_delta_v_abtl_ht (/ (* 1.0 delta_v_ht) sinW))
				(setq anteil_delta_v_abtl_ht 0.0)
			)
			(print anteil_delta_v_abtl_ht)
			
			(if (> at_winkel 90.0)
				(setq delta_v_abtl_at (- anteil_delta_v_abtl_ht))
				(setq delta_v_abtl_at anteil_delta_v_abtl_ht)
			)
			(print delta_v_abtl_at)
			
			(if (> at_winkel 90.0)
				(if (= (Connect.get CastaData amHtOberflansch) 1) 	(setq delta_v_abtl_at (+ delta_v_abtl_at))	)
				(if (= (Connect.get CastaData amHtOberflansch) 1) 	(setq delta_v_abtl_at (- delta_v_abtl_at))	)
			)
			
			(if (> at_winkel 90.0)
				(if (= (Connect.get CastaData amHtUnterflansch) 1) 	(setq delta_v_abtl_at (- delta_v_abtl_at)))
				(if (= (Connect.get CastaData amHtUnterflansch) 1) 	(setq delta_v_abtl_at (+ delta_v_abtl_at)))
			)
			(print delta_v_abtl_at)
		)
	)
	
	
	; Anteil delta_lr HT
	; ----------------------------------------------
	(if (= (Connect.get CastaData amHtSteg) 1)
		(progn
			(setq delta_lr_ht	(Traeger.get Htrg delta_lr))
			(print delta_lr_ht)
			(setq at_winkel (Connect.get CastaData at_laengswinkel))
			(print at_winkel)
			
			(setq sinW (sin (/ (* PI at_winkel) 180.0)))
			(setq cosW (cos (/ (* PI at_winkel) 180.0)))
			(print cosW)
			
			(if (/= sinW 0.0)
				(setq anteil_delta_lr_abtl_ht (/ (* 1.0 delta_lr_ht) sinW))
			)
			(print anteil_delta_lr_abtl_ht)
			
			(if (> at_winkel 90.0)
				(setq delta_v_abtl_at (- anteil_delta_lr_abtl_ht))
				(setq delta_v_abtl_at anteil_delta_lr_abtl_ht)
			)
			(print delta_v_abtl_at)
			
			(if (> at_winkel 90.0)
				(if (= (Connect.get CastaData amHtStegLinks) 1) 	(setq delta_v_abtl_at (+ delta_v_abtl_at))	)
				(if (= (Connect.get CastaData amHtStegLinks) 1) 	(setq delta_v_abtl_at (- delta_v_abtl_at))	)
			)
			(if (> at_winkel 90.0)
				(if (= (Connect.get CastaData amHtStegRechts) 1) 	(setq delta_v_abtl_at (- delta_v_abtl_at))	)
				(if (= (Connect.get CastaData amHtStegRechts) 1) 	(setq delta_v_abtl_at (+ delta_v_abtl_at))	)
			)
			(print delta_v_abtl_at)
		)
	)
	


	; Anteil delta AT
	; ----------------------------------------------
	(setq delta_v_at (Traeger.get Tr_ID delta_v))
	(setq delta_lr_at (Traeger.get Tr_ID delta_lr))
	(print delta_v_at)
	(print delta_lr_at)
	
	(setq tanW (tan (/ (* PI at_winkel) 180.0)))
	(print tanW)
	
	(setq anteil_delta_v_at (/ (* 1.0 delta_v_at) tanW))
	(print anteil_delta_v_at)
	(setq anteil_delta_lr_at (/ (* 1.0 delta_lr_at) tanW))
	(print anteil_delta_lr_at)	
	
	(if (= (Connect.get CastaData linkesEnde) 1)
		(progn
			(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_v_abtl_at (+ delta_v_abtl_at anteil_delta_v_at))	)
			(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_v_abtl_at (- delta_v_abtl_at anteil_delta_v_at))	)
			(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta_v_abtl_at (+ delta_v_abtl_at anteil_delta_lr_at))	)
			(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta_v_abtl_at (- delta_v_abtl_at anteil_delta_lr_at))	)
		)
	)
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(progn
			(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_v_abtl_at (+ delta_v_abtl_at anteil_delta_v_at))	)
			(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_v_abtl_at (- delta_v_abtl_at anteil_delta_v_at))	)
			(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta_v_abtl_at (+ delta_v_abtl_at anteil_delta_lr_at))	)
			(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta_v_abtl_at (- delta_v_abtl_at anteil_delta_lr_at))	)
		)
	)
	(print delta_v_abtl_at)
	
	
	(setq anteil_delta_lr_abtl_at (/ delta_lr_abtl_at tanW))
	(print anteil_delta_lr_at)
	
	; delta_lr
	(if (= (Connect.get CastaData linkesEnde) 1)
		(progn
			(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_v_abtl_at (- delta_v_abtl_at anteil_delta_lr_abtl_at))	)
			(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_v_abtl_at (+ delta_v_abtl_at anteil_delta_lr_abtl_at))	)
			(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta_v_abtl_at (- delta_v_abtl_at anteil_delta_lr_abtl_at))	)
			(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta_v_abtl_at (+ delta_v_abtl_at anteil_delta_lr_abtl_at))	)
		)
	)
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(progn
			(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_v_abtl_at (+ delta_v_abtl_at anteil_delta_lr_abtl_at))	)
			(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_v_abtl_at (- delta_v_abtl_at anteil_delta_lr_abtl_at))	)
			(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta_v_abtl_at (+ delta_v_abtl_at anteil_delta_lr_abtl_at))	)
			(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta_v_abtl_at (- delta_v_abtl_at anteil_delta_lr_abtl_at))	)
		)
	)
	
	; Anbauteil hinzufgen
	(Traeger.addabtl Tr_ID Lchb_ID 0.0 0.0 WINDVERBAND_LB)

	(setq AbtlKnoBlLchbAT    (Traeger.get Tr_ID AbTeil Lchb_ID))
	(Anbauteil.set AbtlKnoBlLchbAT 	(Master 0)
					(delta_lr delta_lr_abtl_at)
					(delta_v 	delta_v_abtl_at)
	)
	
	(setq test_LB_Art (Lochbild.get Lchb_ID LB_Art))
	
	
;	(setq AbtlKnoBlLchb_HT    (Traeger.get HTrg AbTeil Lchb_ID))
;	(if (= (Connect.get CastaData amHtSteg) 1) (progn
;	    (if (= (Connect.get CastaData vatr-vhtr) -1) (Anbauteil.set AbtlKnoBlLchb_HT (SeitRicht -1)))
;	))
;	(if (= (Connect.get CastaData amHtFlansch) 1) (progn
;	    (if (= (Connect.get CastaData vatr-shtr)  1) (Anbauteil.set AbtlKnoBlLchb_HT (SeitRicht -1)))
;	))	
	
	; LOCHBILD-TEST
	; +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	(if (= LB_DEBUG 1)
		(progn
			(setq LB_DUMMY (Lochbild.create))
			(Lochbild.copy LB_DUMMY Lchb_ID)
			(Traeger.addabtl Tr_ID LB_DUMMY 0.0 0.0 WINDVERBAND_LB)
			(setq AbtlKnoBlLchbAT_DUMMY    (Traeger.get Tr_ID AbTeil LB_DUMMY))
			(Anbauteil.set AbtlKnoBlLchbAT_DUMMY 	(Master 1)
								(delta_lr delta_lr_abtl_at)
								(delta_v 	delta_v_abtl_at)
			)
			
			(Connect.storeAnschlObjs CastaData LB_DUMMY)
		)
	)
	; +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	(print "<---------------------------------------")
)


; ----------------------------------------------------------------------------------------
; Berechnet die Position des Knotenbleches entlang des Stegs fr den 1. Anschluss
; ----------------------------------------------------------------------------------------
(defun calcFirstConnection ()
	(print "BERECHNE ERSTEN ANSCHLUSS")
	; Korrektur aus Verschiebung delta_lr bzw. delta_v des AT ANSCHLUSS AM STEG
  (print delta_v_at)
  (print delta_lr_at)
  
  (setq at_verschiebung 0)
	(if (= (Connect.get CastaData amHtSteg) 1)
  	(progn
		  (if (= (Connect.get CastaData satr-lhtr)  1)	(setq at_verschiebung    delta_v_at))
		  (if (= (Connect.get CastaData satr-lhtr) -1)	(setq at_verschiebung    delta_v_at))
		  
		  (if (= (Connect.get CastaData vatr-vhtr) -1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq at_verschiebung    (- delta_v_at)))
		  		(if (= (Connect.get CastaData satr-lhtr) -1)	(setq at_verschiebung    (- delta_v_at)))
				)
			)
			
		)
	)
	(if (= (Connect.get CastaData amHtFlansch) 1)
  	(progn
		  (if (= (Connect.get CastaData satr-lhtr)  1)	(setq at_verschiebung    (- delta_v_at)))
		  (if (= (Connect.get CastaData satr-lhtr) -1)	(setq at_verschiebung    (- delta_v_at)))
		  
			(if (= (Connect.get CastaData vatr-shtr) 1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq at_verschiebung    delta_v_at))
		  		(if (= (Connect.get CastaData satr-lhtr) -1)	(setq at_verschiebung    delta_v_at))
				)
			)
		)
	)
  
  (print at_verschiebung)
  
  ; Knotenblech Verschiebung aus AT-Verschiebung
	(setq knotenblech_soll_versatz at_verschiebung)
	
	(setq schrauben_versatz knotenblech_soll_versatz)
	
	; Knotenblech Verschiebung aus HT-Verschiebung
	(if (= (Connect.get CastaData amHTFlansch) 1)
		(progn
			(setq knotenblech_soll_versatz (- knotenblech_soll_versatz delta_lr_ht))
		)
	)
	(if (= (Connect.get CastaData amHTSteg) 1)
		(progn
			(setq knotenblech_soll_versatz (- knotenblech_soll_versatz delta_v_ht))
		)
	)
	(print knotenblech_soll_versatz)
	(print "ENDE ERSTER ANSCHLUSS")
)



; ----------------------------------------------------------------------------------------
; Berechnet die Position des Knotenbleches entlang des Stegs fr den 2. Anschluss
; ----------------------------------------------------------------------------------------
(defun calcSecondConnection ()
	(print "------------------------------------------------------------------------------>")
	(print "BERECHNE ZWEITEN ANSCHLUSS")
	(print "TRGER IST BEREITS FIXIERT.")
	(print knotenblech_soll_versatz)
	(print dp_knbl)
	
		
	; Anschluss am HT-Flansch
	(if (= (Connect.get CastaData amHtFlansch) 1)
		(progn
			(if (= (Connect.get CastaData vatr-shtr) 1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr) 1)
						(setq knotenblech_soll_versatz (+ knotenblech_soll_versatz dp_knbl))
					)
					(if (= (Connect.get CastaData satr-lhtr) -1)
						(setq knotenblech_soll_versatz (- knotenblech_soll_versatz dp_knbl))
					)
				)
				(progn
					(if (= (Connect.get CastaData satr-lhtr) 1)
						(setq knotenblech_soll_versatz (+ knotenblech_soll_versatz dp_knbl))
					)
					(if (= (Connect.get CastaData satr-lhtr) -1)
						(setq knotenblech_soll_versatz (- knotenblech_soll_versatz dp_knbl))
					)
				)
			)
		)
	)
	
	; Anschluss am HT-Steg
	(if (= (Connect.get CastaData amHtSteg) 1)
		(progn
			(if (= (Connect.get CastaData vatr-vhtr) -1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr) 1)
						(setq knotenblech_soll_versatz (- knotenblech_soll_versatz dp_knbl))
					)
					(if (= (Connect.get CastaData satr-lhtr) -1)
						(setq knotenblech_soll_versatz (+ knotenblech_soll_versatz dp_knbl))
					)
				)
				(progn
					(if (= (Connect.get CastaData satr-lhtr) 1)
						(setq knotenblech_soll_versatz (- knotenblech_soll_versatz dp_knbl))
					)
					(if (= (Connect.get CastaData satr-lhtr) -1)
						(setq knotenblech_soll_versatz (+ knotenblech_soll_versatz dp_knbl))
					)
				)
			)
			
		)
	)
	(print knotenblech_soll_versatz)
	
	(print "ENDE ZWEITER ANSCHLUSS")
	(print "<------------------------------------------------------------------------------")
)

(defun calcXPosDelta_HT ()
   (print "calcXPosDelta_HT wurde komplett ersetzt")
)
(defun calcXPosDelta_HT_Alt ()
	(print "------------------------------------------------------------")
	(print "BERECHNE DELTA_HT AUSWIRKUNG")
	(if (= (Connect.get CastaData amHtFlansch) 1)
		(setq Winkel (connect.get CastaData at_laengswinkel))
	)
	(if (= (Connect.get CastaData amHtSteg) 1)
		(setq Winkel (connect.get CastaData at_laengswinkel))
	)
	(setq Winkel (- 90.0 Winkel))
	(setq sinW (sin (/ (* PI Winkel) 180.0)))
	(setq tanW (tan (/ (* PI Winkel) 180.0)))
	
	(print Winkel)
	(print tanW)
	
	(print xPosStz)
	
	(if (= (Connect.get CastaData amHTFlansch) 1)
		(progn
			(setq deltaXPos (* delta_v_ht tanW))
			(print deltaXPos)
	
			(if (= (Connect.get CastaData amHtUnterflansch) 1)
				(setq xPosStz (+ xPosStz deltaXPos))
			)
			(if (= (Connect.get CastaData amHtOberflansch) 1)
				(setq xPosStz (- xPosStz deltaXPos))
			)
		)
	)
	
	(if (= (Connect.get CastaData amHTSteg) 1)
		(progn
			(setq knotenblech_final_versatz (- knotenblech_soll_versatz delta_lr_ht))
			(setq deltaXPos (* delta_lr_ht tanW))
			(print deltaXPos)

			(setq dlr_AT (Traeger.get Tr_ID delta_LR))
			(setq dlr_AT_Laengs (/ dlr_AT sinW))
			(if (= (Connect.get CastaData vAtr-vHtr) -1) (setq dlr_AT_Laengs (- dlr_AT_Laengs)))
	
			(if (= (Connect.get CastaData amHtStegLinks) 1) (progn
				(setq xPosStz (- xPosStz deltaXPos))
				(if (= (Connect.get CastaData linkesEnde)  1) (setq xPosStz (+ xPosStz dlr_AT_Laengs)))
;				(if (= (Connect.get CastaData rechtesEnde) 1) (setq xPosStz (- xPosStz dlr_AT_Laengs)))
			))
			(if (= (Connect.get CastaData amHtStegRechts) 1) (progn
				(setq xPosStz (+ xPosStz deltaXPos))
;				(if (= (Connect.get CastaData linkesEnde)  1) (setq xPosStz (+ xPosStz dlr_AT_Laengs)))
				(if (= (Connect.get CastaData rechtesEnde) 1) (setq xPosStz (- xPosStz dlr_AT_Laengs)))
			))
		)
	)
	
	
	(print xPosStz)
	(print "--------------------------------------------------------ENDE")

)


; ----------------------------------------------------------------------------------------
; BERECHNET DIE NEUE XPOS, DIE AUS DER VERSCHIEBUNG DES AT RESULTIERT
; ----------------------------------------------------------------------------------------
(defun calcXPosDelta_AT ()
	(print ">-----------------------------------------------------------")
	(print "BERECHNE DELTA_AT AUSWIRKUNG")
	; xPos berechnen und setzen
	(print xPosStz)
	
	(setq h_Trg (Traeger.get Tr_ID h)
				b_Trg	(Traeger.get Tr_ID b)
	)
	
	(if (= (Connect.get CastaData amHtFlansch) 1)
  	(setq Winkel (connect.get CastaData AFl_VWinkel))
  )
  (if (= (Connect.get CastaData amHtSteg) 1)
  	(setq Winkel (connect.get CastaData AFl_HWinkel))
  )
  
  	(if (= Winkel 0.0) (alertBox "Winkel ist 0.0 - das kann eigentlich nicht sein!" "ERR_AngleCantBeZero"))
  
  	(if (= Winkel 0.0) (setq Winkel 90.0))			;; Nur eine Notlsung
  	
  	(setq sinAW (sin (/ (* PI Winkel) 180.0)))
	(print Winkel)
	
	(setq rwinkel (Traeger.get Tr_ID r_winkel))
	(print rwinkel)
	(setq anteil_aus_delta_lr (/ delta_lr_at sinAW))
	(print anteil_aus_delta_lr)
	
	(if (= (Connect.get CastaData amHtOberflansch) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(progn
					(if (= (Connect.get CastaData vatr-shtr)  1)	(setq xPosStz (- xPosStz anteil_aus_delta_lr)))
					(if (= (Connect.get CastaData vatr-shtr) -1)	(setq xPosStz (+ xPosStz anteil_aus_delta_lr)))
				)
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(progn
					(if (= (Connect.get CastaData vatr-shtr)  1)	(setq xPosStz (+ xPosStz anteil_aus_delta_lr)))
					(if (= (Connect.get CastaData vatr-shtr) -1)	(setq xPosStz (- xPosStz anteil_aus_delta_lr)))
				)
			)
		)
	)
	(if (= (Connect.get CastaData amHtUnterflansch) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(progn
					(if (= (Connect.get CastaData vatr-shtr)  1)	(setq xPosStz (+ xPosStz anteil_aus_delta_lr)))
					(if (= (Connect.get CastaData vatr-shtr) -1)	(setq xPosStz (- xPosStz anteil_aus_delta_lr)))
				)
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(progn
					(if (= (Connect.get CastaData vatr-shtr)  1)	(setq xPosStz (- xPosStz anteil_aus_delta_lr)))
					(if (= (Connect.get CastaData vatr-shtr) -1)	(setq xPosStz (+ xPosStz anteil_aus_delta_lr)))
				)
			)
		)
	)
	(if (= (Connect.get CastaData amHtStegLinks) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(progn
					(if (= (Connect.get CastaData vatr-vhtr)  1)	(setq xPosStz (+ xPosStz anteil_aus_delta_lr)))
					(if (= (Connect.get CastaData vatr-vhtr) -1)	(setq xPosStz (- xPosStz anteil_aus_delta_lr)))
				)
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(progn
					(if (= (Connect.get CastaData vatr-vhtr)  1)	(setq xPosStz (- xPosStz anteil_aus_delta_lr)))
					(if (= (Connect.get CastaData vatr-vhtr) -1)	(setq xPosStz (+ xPosStz anteil_aus_delta_lr)))
				)
			)
		)
	)
	(if (= (Connect.get CastaData amHtStegRechts) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(progn
					(if (= (Connect.get CastaData vatr-vhtr)  1)	(setq xPosStz (- xPosStz anteil_aus_delta_lr)))
					(if (= (Connect.get CastaData vatr-vhtr) -1)	(setq xPosStz (+ xPosStz anteil_aus_delta_lr)))
				)
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(progn
					(if (= (Connect.get CastaData vatr-vhtr)  1)	(setq xPosStz (+ xPosStz anteil_aus_delta_lr)))
					(if (= (Connect.get CastaData vatr-vhtr) -1)	(setq xPosStz (- xPosStz anteil_aus_delta_lr)))
				)
			)
		)
	)
				
	
	(print xPosStz)
	(print "<-----------------------------------------------------------")
)


(defun createAugenBlech (Blech_ID)
	
  (setq h_at (Traeger.get Tr_ID h))
	

  (if (= (Connect.get CastaData linkesEnde) 1)
  	(traeger.addabtl tr_id Blech_ID 0.0 0.0 _augenblech_links_)
  )
  (if (= (Connect.get CastaData rechtesEnde) 1)
  	(traeger.addabtl tr_id Blech_ID 0.0 0.0 _augenblech_rechts_)
  )
  
  ; Schlitzlaenge der Augenlasche
  (setq lSchlitz (Blech.get Blech_ID lSchlitz)) 
  (print lSchlitz)
  
  ; Breite der Augenlasche
  (setq bp_al (* h_at 2.0))
  (print bp_al)
  (setq min_bp_al (* 2.0 e_min_rund))
  
  (if (>= bp_al min_bp_al)
  	(setq bp_al bp_al)
  	(setq bp_al min_bp_al)
  )
  
  ; Lnge der Augenlasche
  (if (= STD 0)
	(setq hp_al (+ lSchlitz (* KONTAKTLAENGE 1.25)))
	(setq hp_al (+ lSchlitz anteil_rand_abst MIN_ABST_AUGENLCHB_BLECHENDE h_at))
  )
  
  (calcAndSetAugenBlechDicke augenBlech)	; -> dp_al
  (Blech.set Blech_ID	(bp bp_al)
  			(hp hp_al)
  )
  
  
)



; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
; ----------------------------------------------------------------------------------------
; VARIANTE 2
; ----------------------------------------------------------------------------------------
; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++


; ----------------------------------------------------------------------------------------
; Erzeugt das Knotenblech fr Variante 2
; ----------------------------------------------------------------------------------------
(defun manualKnotenBlechCreation (Lchb_ID)
	(print ">-----------------------------------------------------------")
	(print "BERECHNE KNOTENBLECH VAR_2")
	(setq h_ht 				(Traeger.get Htrg h)
				delta_v_ht	(Traeger.get Htrg delta_v)
				delta_lr_ht	(Traeger.get Htrg delta_lr)
	)
	(setq h_ht_halb (* 0.5 h_ht))
	
	(setq h_at				(Traeger.get Tr_ID h)
				b_at				(Traeger.get Tr_ID b)
				delta_v_at	(Traeger.get Tr_ID delta_v)
				delta_lr_at	(Traeger.get Tr_ID delta_lr)
	)
	
	(setq at_winkel (Connect.get CastaData at_laengswinkel)
				xPos_ht		(Connect.get CastaData xPos_ht)
	)
	
	(setq lb_e0 (Lochbild.get Lchb_ID e0))
	
	(setq tanATW (tan (/ (* PI at_winkel) 180.0)))
	(setq sinATW (sin (/ (* PI at_winkel) 180.0)))
	
	;(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq bp_blech (* 1.67 h_at)))
	;(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq bp_blech (* 1.67 h_at)))
	;(if (= (Connect.get CastaData satr-lhtr)  1)	(setq bp_blech (* 1.67 b_at)))
	;(if (= (Connect.get CastaData satr-lhtr) -1)	(setq bp_blech (* 1.67 b_at)))
	
	(setq lb_rand_abst (* 1.3 (* 1.5 e_min_rund))) ; TODO: Rotation AT evtl. noch beachten 
	(setq lb_stz_abst (* lb_e0 sinATW))
	(print lb_stz_abst)
	
	(setq bp_blech (+ lb_rand_abst lb_stz_abst))
	(setq bp_blech_rund (runde bp_blech auf 5.0))
	
	(setq hp_blech (* 1.2 bp_blech_rund))
	(setq hp_blech_rund (runde hp_blech auf 5.0))
	
	(setq help_1 (+ h_ht_halb bp_blech_rund))
	
	(setq help_2 (/ help_1 tanATW))
	
		
	; Blechecken
	(if (> at_winkel 90.0)
		(progn
			(setq y4_blech (* 0.5 bp_blech_rund))
			(setq x4_blech (- (/ y4_blech tanATW)))
			
			(setq x1_blech 0.0)
			(setq y1_blech 0.0)
		)
	)
	(if (< at_winkel 90.0)
		(progn
			(setq x4_blech 0.0)
			(setq y4_blech 0.0)
			
			(setq y1_blech (* 0.5 bp_blech_rund))
			(setq x1_blech (/ y1_blech tanATW))
		)
	)
	(if (= at_winkel 90.0)
		(progn
			(setq x4_blech 0.0)
			(setq y4_blech 0.0)
			(setq x1_blech 0.0)
			(setq y1_blech 0.0)
		)
	)
	
	(setq dok_blech (* 0.5 (- hp_blech_rund bp_blech_rund)))
	(if (> at_winkel 90.0)
		(setq dok_blech (- dok_blech))
	)
	(if (= at_winkel 90.0)
		(setq dok_blech 0.0)
	)

;  (print "Blechdaten setzen ...")
  (print "-------------------------------------------------------------------------Blechdaten Start")
  (print hp_blech_rund)
  (print bp_blech_rund)
  (print dok_blech)
  (print x1_blech)
  (print y1_blech)
  (print x4_blech)
  (print y4_blech)
  (print "-------------------------------------------------------------------------Blechdaten Ende")

  ; Korrektur, falls der Wert nicht mglich sein sollte
  (if (> x1_blech hp_blech_rund) (setq x1_blech hp_blech_rund))
  (if (> x4_blech hp_blech_rund) (setq x4_blech hp_blech_rund))

	  
  ; Default-Werte des Blechs
  (Blech.set knotenBlech 	(hp 	hp_blech_rund)
      				(bp 	bp_blech_rund)
      				(dok 	dok_blech)
      				(x1 	x1_blech)
      				(y1 	y1_blech)
      				(x4 	x4_blech)
      				(y4 	y4_blech)
  )
  
  (setq dp_knbl (Blech.get knotenBlech dp))
	(setq half_kbl (* 0.5 dp_knbl))
	
  (if (= Windverbandsstab_Umsetzen 1) (progn
	; +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	; 1. Anschluss (es liegt noch kein Anschluss am Windverbandstab vor)
	; +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	(calcFirstConnection)
		
	; +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	; 2. Anschluss
	; +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	; Wenn der Traeger bereits angeschlossen ist, mu das zweite Blech versetzt werden 
	(if (> (Connect.get CastaData anschl_anderesEnde) 0) (progn
		(calcSecondConnection)
	))
  ))  
  (if (= Windverbandsstab_Umsetzen 0) (progn
	(calcFirstConnection)
	(calcSecondConnection)
  ))
  ; xPos Knotenblech
  ; ----------------------------------------------
	;(if (> at_winkel 90.0) 
	;	(setq xPos_ht (+ xPos_ht (+ help_2 (* 0.5 hp_blech_rund))))
	;	(setq xPos_ht (+ xPos_ht (- help_2 (* 0.5 hp_blech_rund))))
	;)
	(print xPos_ht)
	

  
  (if (= (connect.get CastaData amHtOberFlansch) 1) (progn
      (traeger.addabtl Htrg knotenBlech xPos_ht 0.0 _knotenblech_of_)  ;
  ))
  (if (= (connect.get CastaData amHtUnterFlansch) 1) (progn
      (traeger.addabtl Htrg knotenBlech xPos_ht 0.0 _knotenblech_uf_)  ;
  ))
  (if (= (connect.get CastaData amHtStegLinks) 1) (progn
      (traeger.addabtl Htrg knotenBlech xPos_ht 0.0 _knotenblech_steg_li_)  ;    
  ))
  (if (= (connect.get CastaData amHtStegRechts) 1) (progn
      (traeger.addabtl Htrg knotenBlech xPos_ht 0.0 _knotenblech_steg_re_)  ;    
  ))
  
  

  
  ;(setq xPosStz      (Connect.get CastaData xPos_HT))
  ;(setq WnklAnschlFl (Connect.get CastaData afl_vwinkel))
  (setq xPosStz xPos_ht)
  
  ; Verschiebung des HT delta_v / delta_lr
    (calcXPosDelta_HT)
    ; Verschiebung des AT delta_v / delta_lr
    (calcXPosDelta_AT)
	
    (setq xPosStz (Connect.get CastaData xPos_HT))
    (print xPosStz)
    ; xPos setzen
    (setq AbtlKnBlech (traeger.get Htrg ABTeil knotenBlech))
    (Anbauteil.set  AbtlKnBlech (xPos xPosStz))

    (setq hpTest (Blech.get knotenBlech hp)
    	  bpTest (Blech.get knotenBlech bp)
    )
  
;    (print knotenblech_soll_versatz)
    (Blech.knotenblechschraeg knotenBlech 0.0 0.0 at_winkel)
;    (Blech.set knotenBlech (hp hpTest))
  
    (Blech.set knotenBlech (delta_lr knotenblech_soll_versatz))
    
  
    (print "<-----------------------------------------------------------")
)


(defun calcAndSetE0_Var2 (Lchb_ID parallel_abstand_stz)
	
	(setq	h_at 	(Traeger.get Tr_ID h)
		b_at	(Traeger.get Tr_ID b)
	)
	
	(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq at_halb (* 0.5 h_at)))
	(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq at_halb (* 0.5 h_at)))
	(if (= (Connect.get CastaData satr-lhtr)  1)	(setq at_halb (* 0.5 b_at)))
	(if (= (Connect.get CastaData satr-lhtr) -1)	(setq at_halb (* 0.5 b_at)))
	
	
	(setq at_winkel (Connect.get CastaData at_laengswinkel))
	
	(if (= (Connect.get CastaData amHTFlansch) 1) (progn
		(setq at_winkel (Connect.get CastaData h-atrgewnkl_flansch))
	))
	 
	
	
	(setq tanATW (tan (/ (* PI at_winkel) 180.0)))
	(setq sinATW (sin (/ (* PI at_winkel) 180.0)))
	
	(setq abst_lb_stz (* 1.5 MIN_ABST_AUGENLCHB_BLECHENDE)) ; Verhltniswert
	
	(setq e0 (/ abst_lb_stz sinATW))

	;(setq e0 1)
	(Lochbild.set Lchb_ID (e0 e0))

)
; ----------------------------------------------------------------------------------------
; Erzeugt das Lochbild fr Knotenblech Variante 2
; ----------------------------------------------------------------------------------------
(defun createLochbild_Var2 (Lchb_ID Blech_ID BlechAuge p_abstand_stz)


	(Lochbild.set Lchb_ID 	
				(Guete		"4.6")											
	)
	
	; allg. Daten
	(setq	dp_blech 	(Blech.get Blech_ID dp)
		bp_blech	(Blech.get Blech_ID bp)
		hp_blech  (Blech.get Blech_ID hp)
	)
	
	(setq dp_Auge		(Blech.get BlechAuge dp))
	
	(setq	t_at		(Traeger.get Tr_ID t)
		s_at		(Traeger.get Tr_ID s)
		b_at		(Traeger.get Tr_ID b)
		h_at		(Traeger.get Tr_ID h)
		delta_lr_at	(Traeger.get Tr_ID delta_lr)
	)
	(setq	delta_v_ht	(Traeger.get Htrg delta_v)
		delta_lr_ht	(Traeger.get Htrg delta_lr)
	)
	
	(setq	xPos_ht		(Connect.get CastaData xPos_ht)
		at_winkel	(Connect.get CastaData at_laengswinkel)
	)
	
		
	; Klemmlnge
	(setq klemml (+ dp_Auge dp_Blech))
	
	(setq dxS 0)
	; dxSKopf Anschluss am Steg
	(if (= (Connect.get CastaData amHtSteg) 1)
		(progn
			(if (= (Connect.get CastaData satr-vhtr)  1) (setq dxS (* 0.5 dp_blech)))
			(if (= (Connect.get CastaData satr-vhtr) -1) (setq dxS (+ (* 0.5 dp_blech) dp_Auge)))
			(if (= (Connect.get CastaData vatr-vhtr)  1) (setq dxS (+ (* 0.5 dp_blech) dp_Auge)))
			(if (= (Connect.get CastaData vatr-vhtr) -1) (setq dxS (* 0.5 dp_blech)))
			(if (= (Connect.get CastaData satr-lhtr) -1) (setq dxS (+ (* 0.5 dp_blech) dp_Auge)))
			(if (= (Connect.get CastaData satr-lhtr)  1) (setq dxS (* 0.5 dp_blech)))				
		)
	)
			
	; dxSKopf Anschluss am Flansch
	(if (= (Connect.get CastaData amHtFlansch) 1)
		(progn
			(if (= (Connect.get CastaData satr-lhtr)  1) (setq dxS (+ (* 0.5 dp_blech) dp_Auge)))
			(if (= (Connect.get CastaData satr-lhtr) -1) (setq dxS (* 0.5 dp_blech)))
		)
	)
	
	(print dxS)
	
	; Werte setzen
	(Lochbild.set Lchb_ID 	(klemml		klemml)
				(dxSKopf	dxS)
	)
	
	; xPos Lochbild-Anbauteil
	(setq xPos_LB xPos_ht)
	
	; Lochbild dem HT hinzufgen
	(setq AbtlKnoBl	(Traeger.get Htrg AbTeil Blech_ID))
	(Traeger.addabtl Htrg Lchb_ID 0.0 0.0 _knblLochbild_ AbtlKnoBl)

	(setq AbtlKnoBlLchb    (Traeger.get Htrg AbTeil Lchb_ID))
	(Anbauteil.set AbtlKnoBlLchb 	(Master 1)
					(delta_sx knotenblech_soll_versatz)
	)
	
	;; Mrz 2010 - Erweiterung auf Knotenbleche auf Flanschkante
	(setq anFlansch_Aussenkante 0)
	(setq AbstandFlansch 0.0)
	(setq blch_dlr (Blech.get Knotenblech delta_lr))
  	(if (< blch_dlr 0) (setq blch_dlr (- blch_dlr)))	; sozusagen absolut setzen
	(if (> blch_dlr (- (* 0.5 h_Ht) t_Ht)) (setq anFlansch_Aussenkante 1))

	(setq qsform_HT	(Traeger.get HTrg qsform))
	(if (= (connect.get CastaData amHtSteg) 1) (progn
	     (if (= qsform_HT "K") (setq anFlansch_Aussenkante 1))
	     (if (= qsform_HT "R") (setq anFlansch_Aussenkante 1))
	))
	
  
  	(if (= anFlansch_Aussenkante 1) (progn
	    (setq afl_wnkl	(Connect.get CastaData at_laengswinkel))
	    (setq afl_wnkl	(- afl_wnkl 90.0))
	    (setq cos_Afl	(cos (/ (* PI afl_wnkl) 180.0)))
	    (setq b_Ht 		(Traeger.get HTrg b))
	    (setq e0_Lochbild	(Lochbild.get Lchb_ID e0))

	
	    (if (= (connect.get CastaData amHtStegLinks) 1) (progn
	         (if (= qsform_HT "U") 
	         	(setq b_Ht 0)
	         	(setq b_Ht (* 0.5 b_Ht))
	         )
	    ))
	    (if (= (connect.get CastaData amHtStegRechts) 1) (progn
	         (if (= qsform_HT "U") 
	         	(setq b_Ht b_Ht)
	         	(setq b_Ht (* 0.5 b_Ht))
	         )
	    ))

	    (if (/= cos_Afl 0.0) (progn
		(setq AbstandFlansch (/ b_Ht cos_Afl))
	    ))

	    ; Juli 2010 - korrigiert, da Abstandflansch ansonsten
	    ; falsch berechnet wurde.
	    (if (= (connect.get CastaData amHtFlansch) 1) (progn
	        (setq h_Ht 		(Traeger.get HTrg h))
			(if (/= cos_Afl 0.0) (progn
				(setq AbstandFlansch (/ (* 0.5 h_Ht) cos_Afl))
			))
	    ))

		;; 2019-07-25 --- Abstandflansch wird durch delta_V im ABTeil abgedeckt
		; (if (= (Connect.get CastaData amHtSteg) 1) (progn
			(setq R_oder_K_Profil 0)
			(if (= qsform_HT "R") (setq R_oder_K_Profil 1))
			(if (= qsform_HT "K") (setq R_oder_K_Profil 1))
			(if (= R_oder_K_Profil 1) (progn
				(setq AbstandFlansch 0.0)
			))
		; ))
		
	    (setq e0_Lochbild (+ e0_Lochbild AbstandFlansch))
	    (if (= qsform_HT "U") (Lochbild.set Lchb_ID (e0 e0_Lochbild)))
	    (if (= qsform_HT "I") (Lochbild.set Lchb_ID (e0 e0_Lochbild)))
	    (if (= qsform_HT "R") (Lochbild.set Lchb_ID (e0 e0_Lochbild)))
    
	))
	

	;; Ende Erweiterung Mrz 2010
	
)



(defun calcAndSetAugenBlechDicke (Blech_ID)
	(print ">-----------------------------------------------------------")
	(print "BERECHNE DICKE DER AUGENLASCHE")
	(setq h_at (Traeger.get Tr_ID h))
	
	(setq dp_al 10)
	
  (if (= qsform_at "R")
  	(progn
  		(print "R_PROFIL")
  		(if (<= h_at 15.0)
  			(setq dp_al 5.0)
  			(setq dp_al 10.0)
  		)
  	) 
  )
	; ---------------
	(setq dp_al 10.0)
	; ---------------
  (print dp_al)
  (Blech.set Blech_ID (dp dp_al))
  (print "<-----------------------------------------------------------")
)


(defun calcAndSetKnotenBlechDicke (Blech_ID)
    (if (= K_VerbandsKnBlech 1) (setq dp_kb (Blech.get Blech_ID dp)))
    (if (= K_VerbandsKnBlech 0) (progn
	(print ">-----------------------------------------------------------")
	(print "BERECHNE DICKE DES KNOTENBLECHES")
	(setq dp_kb 10)
	(print dp_kb)
	
	(Blech.set Blech_ID (dp dp_kb))
	(print "<-----------------------------------------------------------")
    ))
)

; -----------------------------------------------------

(defun calcKnbl_LR ()
   (setq ABtl_Knbl_HT (Traeger.get HTrg   ABTeil knotenBlech))
   (setq delta_LR_abtl (Anbauteil.get ABtl_Knbl_HT delta_LR))
   (setq dOK_Blch (Blech.get knotenBlech dOK))

   (setq AbtlLchb_HT (Traeger.get HTrg   ABTeil knblLochbild))
   (setq Winkel (Anbauteil.get AbtlLchb_HT Winkel))
   (if (<= Winkel  90.0)  (setq Wst_Winkel Winkel)
   (if (<= Winkel 270.0)  (setq Wst_Winkel (- 180.0 Winkel))
   			  (setq Wst_Winkel (- 360.0 Winkel))
   ))

   (setq delta_LR_AT (Traeger.get Tr_ID delta_LR))

   (setq sin_WST (sin (/ (* PI Wst_Winkel) 180.0)))
   (setq cos_WST (cos (/ (* PI Wst_Winkel) 180.0)))
   (setq tan_WST (tan (/ (* PI Wst_Winkel) 180.0)))

   (setq delta_dOK (/ delta_LR_AT cos_WST))
   (if (= (Connect.get CastaData amHtSteg) 1)  (progn

	   (if (= (Connect.get CastaData amHtStegRechts) 1)  (progn
		(if (= (Connect.get CastaData vAtr-vHtr)  1) (progn
		    (if (= (Connect.get CastaData linkesEnde) 1) (setq delta_dOK (- delta_dOK)))
		))
		(if (= (Connect.get CastaData vAtr-vHtr) -1) (progn
		    (if (= (Connect.get CastaData rechtesEnde) 1) (setq delta_dOK (- delta_dOK)))
		))
	   ))
	   (if (= (Connect.get CastaData amHtStegLinks) 1)  (progn
		(if (= (Connect.get CastaData vAtr-vHtr)  -1) (progn
	           (if (= (Connect.get CastaData linkesEnde) 1) (setq delta_dOK (- delta_dOK)))
	        ))
		(if (= (Connect.get CastaData vAtr-vHtr)  1) (progn
		    (if (= (Connect.get CastaData rechtesEnde) 1) (setq delta_dOK (- delta_dOK)))
		))
	   ))
	   ; Horizontalverschiebung des HT hier noch bercksichtigen (Blechverschiebung)
	   (setq delta_LR_HT (Traeger.get HTrg delta_LR))
	   (setq dlr_Aus_HT (* delta_LR_HT tan_WST))
	   (if (= (Connect.get CastaData amHtStegLinks) 1)  (setq dlr_Aus_HT (- dlr_Aus_HT)))

	   (setq delta_dOK (+ delta_dOK dlr_Aus_HT))

	   ; Horizontalverschiebung des HT hier fr Lochbildverschiebung
	   (setq dlr_Lchb_Aus_HT (* sin_WST delta_LR_HT))
	   (print dlr_Lchb_Aus_HT)
	   (setq vorh_dlr_Lchb_HT (Anbauteil.get AbtlLchb_HT delta_LR))
	   (setq neu_dlr_Lchb_HT  (+ vorh_dlr_Lchb_HT dlr_Lchb_Aus_HT))
	   (Anbauteil.set AbtlLchb_HT (delta_LR neu_dlr_Lchb_HT))

   ))
   (if (= (Connect.get CastaData amHtFlansch) 1)  (progn
	(setq delta_dOK (- delta_dOK))
	(if (= (Connect.get CastaData amHtOberflansch) 1) (progn
	   (if (= (Connect.get CastaData vAtr-sHtr) 1) (progn
	       (if (= (Connect.get CastaData rechtesEnde) 1) (setq delta_dOK (- delta_dOK)))
	   ))
	   (if (= (Connect.get CastaData vAtr-sHtr) -1) (progn
	       (if (= (Connect.get CastaData linkesEnde) 1) (setq delta_dOK (- delta_dOK)))
	   ))
	))
	(if (= (Connect.get CastaData amHtUnterflansch) 1) (progn
	   (if (= (Connect.get CastaData vAtr-sHtr) -1) (progn
	       (if (= (Connect.get CastaData rechtesEnde) 1) (setq delta_dOK (- delta_dOK)))
	   ))
	   (if (= (Connect.get CastaData vAtr-sHtr)  1) (progn
	       (if (= (Connect.get CastaData linkesEnde) 1) (setq delta_dOK (- delta_dOK)))
	   ))
	))
	; Vertikalverschiebung des HT hier bercksichtigen
	(setq delta_V_HT (Traeger.get HTrg delta_V))
	(setq dlr_Aus_HT (* delta_V_HT tan_WST))
	(if (= (Connect.get CastaData amHtOberflansch) 1) (setq dlr_Aus_HT (- dlr_Aus_HT)))

	(setq delta_dOK (+ delta_dOK dlr_Aus_HT))

   ))

   (Blech.set knotenBlech (dOK (- dOK_Blch delta_dOK)))
   

)


(defun createLochbild_LR_Flansch ()

	(setq ABtl_Lochb_HT (Traeger.get HTrg   ABTeil knblLochbild))
	(setq ABtl_Lochb_AT (Traeger.get Tr_ID   ABTeil knblLochbild))
	(setq h_HT 		(Traeger.get HTrg h)
		  dv_HT		(Traeger.get HTrg delta_V)
		  dv_HT		(* 1.0 dv_HT)
	)
	(setq dlr_AT 		(Traeger.get Tr_ID delta_LR)
		  dlr_AT		(* 1.0 dlr_AT)
	)

	(setq Winkel (connect.get CastaData h-atrgewnkl_flansch))
	(setq SFlag (connect.get CastaData sAtr-lHtr))
	(setq sinW (sin (/ (* PI Winkel) 180.0)))
	(setq cosW (cos (/ (* PI Winkel) 180.0)))
	(setq tanW (tan (/ (* PI Winkel) 180.0)))
	
	(setq dLR_Ges_HT (* dv_HT cosW))
	(if (= (connect.get CastaData rechtesEnde) 1) (progn
		(if (= (connect.get CastaData sAtr-lHtr) -1) (progn
			(setq dLR_Ges_HT (- dLR_Ges_HT))
		))
	))
	(if (= (connect.get CastaData linkesEnde) 1) (progn
		(if (= (connect.get CastaData sAtr-lHtr) 1) (progn
			(setq dLR_Ges_HT (- dLR_Ges_HT))
		))
	))
	
	(setq lv_dlr_AT (/ dlr_AT tanW)) ; Lngsverschiebung aufgrund seitlicher Verschiebung des AT
	(if (= (connect.get CastaData linkesEnde)  1) (setq lv_dlr_AT (- lv_dlr_AT)))

	(setq dV_vVersch_HT (* -1.0 dv_HT sinW))
	
	(if (= (connect.get CastaData amhtUnterflansch ) 1) (progn
		(setq dV_Profil_HT  (/ (- (* 0.5 h_HT) dv_HT) sinW))
		(setq dv_Profilhoehe (/ h_HT sinW))
		(setq dV_Ges_HT  (- (- dV_Profil_HT dV_vVersch_HT)))
		(setq dV_Ges_HT (+ dV_Ges_HT dv_Profilhoehe))
		(setq dV_Ges_HT (+ dV_Ges_HT lv_dlr_AT))

		(setq dv_Lchb_AT (- dV_Profil_HT dv_Profilhoehe))
		(setq dv_Lchb_AT (+ (- dV_Profil_HT) dv_Profilhoehe lv_dlr_AT))

		(if (= (connect.get CastaData sAtr-lHtr)  1) (setq dLR_Ges_HT (+ dLR_Ges_HT dlr_AT)))
		(if (= (connect.get CastaData sAtr-lHtr) -1) (setq dLR_Ges_HT (- dLR_Ges_HT dlr_AT)))
	))
	(if (= (connect.get CastaData amhtOberflansch ) 1) (progn
		(setq dV_Profil_HT  (/ (- (* 0.5 h_HT) dv_HT) sinW))
		(setq dV_Ges_HT  (- dV_Profil_HT dV_vVersch_HT))
		(setq dV_Ges_HT (+ dV_Ges_HT lv_dlr_AT))
		
		(setq dv_Lchb_AT (+ dV_Profil_HT lv_dlr_AT))

		(if (= (connect.get CastaData sAtr-lHtr) -1) (setq dLR_Ges_HT (+ dLR_Ges_HT dlr_AT)))
		(if (= (connect.get CastaData sAtr-lHtr)  1) (setq dLR_Ges_HT (- dLR_Ges_HT dlr_AT)))
	))
	
	(Anbauteil.set ABtl_Lochb_HT 
  		(delta_v     dV_Ges_HT)
  		(delta_lr 	 dLR_Ges_HT)
	)
	(Anbauteil.set ABtl_Lochb_AT 
  		(delta_v     dv_Lchb_AT)
  		(delta_lr 	 0.0)
	)

	(if (= (connect.get CastaData amhtFlansch ) 1) (progn
		(Lochbild.set knblLochbild   (e0 0))
	))
)


(defun createLochbild_LR_Steg ()

	(setq ABtl_Lochb_HT (Traeger.get HTrg   ABTeil knblLochbild))
	(setq ABtl_Lochb_AT (Traeger.get Tr_ID   ABTeil knblLochbild))
	(setq bs_HT 		(Traeger.get HTrg s)			; Breite oder Stegdicke
		  dlr_HT		(Traeger.get HTrg delta_LR)
		  dlr_HT		(* 1.0 dlr_HT)
	)
  	(setq qsform_ht (Traeger.get HTrg qsform))
  	(if (= qsform_ht "K") (setq bs_HT  (Traeger.get HTrg b)))
  	(if (= qsform_ht "R") (setq bs_HT  (Traeger.get HTrg b)))
  	(if (= qsform_ht "U") (progn
  	   (if (= (Connect.get CastaData amHtStegRechts) 1)
  	   	(setq bs_HT (* 2.0 h_HT))
  	   	(setq bs_HT    0.0)
  	   )
  	))
	(setq dlr_AT 		(Traeger.get Tr_ID delta_LR)
		  dlr_AT		(* 1.0 dlr_AT)
	)

	(setq Winkel (connect.get CastaData h-atrgewnkl_steg))
	(setq SFlag (connect.get CastaData sAtr-lHtr))
	(setq sinW (sin (/ (* PI Winkel) 180.0)))
	(setq cosW (cos (/ (* PI Winkel) 180.0)))
	(setq tanW (tan (/ (* PI Winkel) 180.0)))
	
	; (setq dLR_Ges_HT (* (- dlr_HT) cosW))
	(setq dLR_Ges_HT 0.0)
	
	(setq lv_dlr_AT (/ dlr_AT tanW)) ; Lngsverschiebung aufgrund seitlicher Verschiebung des AT
	(if (= (connect.get CastaData linkesEnde)  1) (setq lv_dlr_AT (- lv_dlr_AT)))

	(setq dV_LR_Versch_HT (- (/ dlr_HT sinW) (* dlr_HT sinW)))
	(setq dV_LR_Versch_AT (- (/ dlr_HT sinW)))
	
	(if (= (connect.get CastaData amhtstegRechts) 1) (progn

		(setq dKante (Lochbild.get knblLochbild dOK))
		(setq offSet_PHalbe (/ (* 0.5 bs_HT) sinW))
		(setq dV_Ges_HT  (+ lv_dlr_AT dV_LR_Versch_HT))
		; (setq dV_Ges_HT (+ dV_Ges_HT lv_dlr_AT))

		(setq dv_Lchb_AT (+ (- dV_LR_Versch_AT) lv_dlr_AT))

		(if (= (connect.get CastaData sAtr-lHtr)  1) (setq dLR_Ges_HT (+ dLR_Ges_HT dlr_AT)))
		(if (= (connect.get CastaData sAtr-lHtr) -1) (setq dLR_Ges_HT (- dLR_Ges_HT dlr_AT)))
	))
	(if (= (connect.get CastaData amhtstegLinks) 1) (progn
		(setq dV_Profil_HT  (/ (- (* 0.5 bs_HT) dlr_HT) sinW))
		(setq dV_Ges_HT  (- dV_Profil_HT dV_LR_Versch_HT))
		(setq dV_Ges_HT (+ dV_Ges_HT lv_dlr_AT))
		
		(setq dV_Ges_HT  (- lv_dlr_AT dV_LR_Versch_HT))
		(setq dv_Lchb_AT (+ dV_LR_Versch_AT lv_dlr_AT))

		(if (= (connect.get CastaData sAtr-lHtr) -1) (setq dLR_Ges_HT (+ dLR_Ges_HT dlr_AT)))
		(if (= (connect.get CastaData sAtr-lHtr)  1) (setq dLR_Ges_HT (- dLR_Ges_HT dlr_AT)))
	))
	
	(Anbauteil.set ABtl_Lochb_HT 
  		(delta_v     dV_Ges_HT)
  		(delta_lr 	 dLR_Ges_HT)
	)
	(Anbauteil.set ABtl_Lochb_AT 
  		(delta_v     dv_Lchb_AT)
  		(delta_lr 	 0.0)
	)


)