; BEMERKUNG:
; 
; In der Datei befinden sich teilweise berflssige if-Schleifen.
; Diese sind jedoch vorerst absichtlich vorhanden, um besser testen zu knnen.
;

(defun init-windverband ()
	
    (setq Windverbandsstab_Umsetzen 0)
    (setq K_VerbandsKnBlech         0)
	
    (Connect.showAttributes CastaData)
    (setq LB_DEBUG 0)
	

    (if (objExist knotenBlech)  (progn
        (setq K_VerbandsKnBlech         1)
	; (print "Knotenblech ist schon angelegt!")
  	(setq knblLochbild	(Lochbild.create))
  	(Connect.storeAnschlObjs CastaData knblLochbild) 
      )
      (progn
	; (print "Knotenblech ist noch nicht angelegt!\nDies erfolgt nun ...")
  	(setq knotenBlech	(Blech.create))
  	(setq knblLochbild	(Lochbild.create))
  	(Connect.storeAnschlObjs CastaData knotenBlech knblLochbild) 
      )
    )
	
;	(setq knblLochbild (Lochbild.create))
;  	(setq knotenBlech (Blech.create))
;	(Connect.storeAnschlObjs CastaData knblLochbild knotenBlech)  
	
	(if (= STD 0)
		(progn
			(createKnotenBlech knotenBlech l_schr rand_abst)	
		)
		(progn
			(calcAndSetE0_Var2 knblLochbild parallel_abstand_stz)
			(manualKnotenBlechCreation knblLochbild)
		)
	)
		   
	(kuerzeProfil parallel_abstand_stz)
		  
	(if (= Windverbandsstab_Umsetzen 1) (progn
	    (if (= (Connect.get CastaData linkesEnde) 1) (progn
		(if (= (Connect.get CastaData anschl_anderesende) 0)   (positioniereVerband))
	    ))
	    (if (= (Connect.get CastaData rechtesEnde) 1) (progn
		(if (= (Connect.get CastaData anschl_anderesende) 0) (positioniereVerband))
	    ))
	))
  	
 	(if (= STD 0)
		(createLochbild knotenBlech knblLochbild rand_abst parallel_abstand_stz)
		(createLochbild_Var2 knblLochbild knotenBlech parallel_abstand_stz)
	)
 		
 	(createATLochbild knblLochbild)

    (calcLochbDelta_LR)
    (calcBlech_DOK)

 	
    (if (= 1 1) (progn
       (setq ABtl_Lochb_HT (Traeger.get HTrg  ABTeil knblLochbild))
       (setq ABtl_Lochb_AT (Traeger.get TR_ID ABTeil knblLochbild))
       (Anbauteil.set ABtl_Lochb_HT (master 1))
       (Anbauteil.set ABtl_Lochb_AT (master 0))
;       (Anbauteil.set ABtl_Lochb_HT (delta_lr (- Lchb_DeltaLR)))
;       (Lochbild.set knblLochbild (w0 50) (LB_Art 2))
   ))
	
	
)



(defun kuerzeProfil (p_abst_stz)
	(print ">-----------------------------------------------------------")
	(print "KUERZE PROFIL")
  ; Winkelprofil krzen ...
  ; korrekten Wert noch aus Sttzenprofil und Winkel berechnen
  (setq kuerzLng     0
        h_Ht     (Traeger.get HTrg h)
        b_Ht     (Traeger.get HTrg b)
        s_Ht     (Traeger.get HTrg s)
        t_Ht     (Traeger.get HTrg t)
        deltaV   (Traeger.get HTrg delta_V)
        deltaLR  (Traeger.get HTrg delta_LR)
  )
  (setq b_Trg    		(Traeger.get Tr_ID b)			; ist die Frage, wie der Stab liegt
        t_Trg    		(Traeger.get Tr_ID t)			; ob Breite oder Hhe entscheidend sind.
        rwnkl		 	(Traeger.get Tr_ID r_winkel)
        deltaV_at		(Traeger.get Tr_ID delta_v)
        deltaLR_at	(Traeger.get Tr_ID delta_lr)
  )
  
  (if (= (connect.get CastaData amHtOberFlansch) 1) (progn
      (setq kuerzLng (- (* 0.5 h_Ht) deltaV))
  ))
  (if (= (connect.get CastaData amHtUnterFlansch) 1) (progn
      (setq kuerzLng (+ (* 0.5 h_Ht) deltaV))
  ))

  (if (= (connect.get CastaData amHtStegLinks) 1) (progn
      (setq kuerzLng (- (* 0.5 s_Ht) deltaLR))
  ))
  (if (= (connect.get CastaData amHtStegRechts) 1) (progn
      (setq kuerzLng (+ (* 0.5 s_Ht) deltaLR))
  ))

  ;; Mrz 2010 - Windverbandsstab im Bereich der Flansche.
  (setq anFlansch_Aussenkante 0)
  (setq qsform_ht (Traeger.get HTrg qsform))
  (setq blch_dlr (Blech.get Knotenblech delta_lr))
  (if (< blch_dlr 0) (setq blch_dlr (- blch_dlr)))	; sozusagen absolut setzen

  (if (> blch_dlr (- (* 0.5 h_Ht) t_Ht)) (setq anFlansch_Aussenkante 1))

  (if (= qsform_HT "K") (progn
    (if (= (connect.get CastaData amHtSteg) 1) (progn
	(setq anFlansch_Aussenkante 1)
    ))
  ))

  
  (if (= anFlansch_Aussenkante 1) (progn
     ; (print "Mrzerweiterung - Windverbandsablngung")
     (if (= (connect.get CastaData amHtStegLinks) 1) (progn
         (setq kuerzLng (- (* 0.5 b_Ht) deltaLR))
         (if (= qsform_ht "U") (setq kuerzLng deltaLR))
     ))
     (if (= (connect.get CastaData amHtStegRechts) 1) (progn
         (setq kuerzLng (+ (* 0.5 b_Ht) deltaLR))
         (if (= qsform_ht "U") (setq kuerzLng (+ b_Ht deltaLR)))
     ))
  ))
  ;; Mrz 2010 - Ende Erweiterung

	
  (setq AFl_Winkel (connect.get CastaData at_laengswinkel))
  
  (print AFl_Winkel)
  (setq AFl_Winkel (- AFl_Winkel 90.0))
	(print AFl_Winkel)
  
  (setq sinAWnkl (sin (/ (* PI AFl_Winkel) 180.0))
  			cosAWnkl (cos (/ (* PI AFl_Winkel) 180.0))
  			tanAWnkl (tan (/ (* PI AFl_Winkel) 180.0))
  )
  (print tanAWnkl)
  
  
  ; Anteil, wenn Verbandstab entlang der HT-Lngsachse verschoben wird
	; --------------------------------------------------------
	(setq A_Winkel (connect.get CastaData at_laengswinkel))
  
	(setq tanAW (tan (/ (* PI A_Winkel) 180.0))
				sinAW	(sin (/ (* PI A_Winkel) 180.0))
	)
	
	(if (= (Connect.get CastaData amHtUnterFlansch) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta deltaLR_at))
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta (- deltaLR_at)))
				)
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta deltaLR_at))
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta (- deltaLR_at)))
				)
			)
		)
	)
	(if (= (Connect.get CastaData amHtOberFlansch) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta (- deltaLR_at)))
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta deltaLR_at))
				)
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta deltaLR_at))
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta (- deltaLR_at)))
				)
			)
		)
	)
		
	(if (= (Connect.get CastaData amHtSteg) 1)
		(progn
			(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta deltaLR_at))
			(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta (- deltaLR_at)))	
		)
	)
	
	
	(print delta)
	
	; --------------------------------------------------------------------------------------
	
	; 2. ANSCHLUSS
	; --------------------------------------------------------------------------------------
	
	(if (> (Connect.get CastaData anschl_anderesEnde) 0)
		(progn
			(setq t_trg_halb (* 0.5 t_Trg)) ; TODO: je nach Rotation h oder b verwenden
			
			(setq delta (+ delta t_trg_halb))
		)
	)
							
	; --------------------------------------------------------------------------------------
	(print delta)
	
	(setq anteil_delta (/ delta tanAW))
  
  (setq abstand_Stz p_abst_stz)
  
  (if (= cosAWnkl 0.0) (setq cosAWnkl 1.0))
  
  (setq anteil_Stz (/ kuerzLng cosAWnkl))
  (setq anteil_Verb (* 0.5 b_Trg tanAWnkl))
  
  
  
  (if (< AFl_Winkel 0) 
  	(setq deltaLNeu (+ abstand_Stz anteil_Stz (- anteil_Verb) anteil_delta))
  	(setq deltaLNeu (+ abstand_Stz anteil_Stz anteil_Verb anteil_delta))
  )
  
  
	;Krzen
  (if (= (connect.get CastaData LinkesEnde) 1) (progn
      (setq TrE_Links (Traeger.get Tr_ID links))
      (TrEnde.set TrE_Links (delta_L 0))
      (TrEnde.pTrim TrE_Links deltaLNeu)
  ))
  (if (= (connect.get CastaData RechtesEnde) 1) (progn
      (setq TrE_Rechts (Traeger.get Tr_ID rechts))
      (TrEnde.set TrE_Rechts (delta_L 0))			; erst einmal zurcksetzen
      (TrEnde.pTrim TrE_Rechts deltaLNeu)			; dann krzen
  ))

	(print "<-----------------------------------------------------------")
)


; ----------------------------------------------------------------------------------------
; Verschiebt den Trger passend zum Knotenblech (Flachstahl)
; ----------------------------------------------------------------------------------------
(defun positioniereVerband ()
	(print ">-----------------------------------------------------------")		
	(print "POSITIONIERE VERBAND")
	
	
  (setq RWinkel (Traeger.get Tr_ID R_Winkel)
        dp      (Blech.get   knotenBlech  dp)
        b_Trg    (Traeger.get Tr_ID b)			; ist die Frage, wie der Stab liegt
        h_Trg    (Traeger.get Tr_ID t)			; ob Breite oder Hhe entscheidend sind.
  )
  (print RWinkel)
  (print dp)
  
  ;Positionieren
  (print delta_v_at)
  (setq delta_kbl (* 0.5 (+ h_Trg dp)))
  (print delta_kbl)
  
  (setq delta_V 0)
  
	(if (= (Connect.get CastaData amHtSteg) 1)
		(progn
		  (if (= (Connect.get CastaData satr-lhtr) -1) (setq delta_V 		(+ delta_v_at delta_kbl)	))
		  (if (= (Connect.get CastaData satr-lhtr)  1) (setq delta_V 		(- delta_v_at delta_kbl)	))
		  
		  (if (= (Connect.get CastaData vatr-vhtr) -1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr) -1) (setq delta_V 		(- delta_v_at delta_kbl)	))
		  		(if (= (Connect.get CastaData satr-lhtr)  1) (setq delta_V 		(+ delta_v_at delta_kbl)	))
				)
			)
			
		)
	)
	(if (= (Connect.get CastaData amHtFlansch) 1)
		(progn
			(if (= (Connect.get CastaData satr-lhtr) -1) (setq delta_V 		(- delta_v_at delta_kbl)	))
		  (if (= (Connect.get CastaData satr-lhtr)  1) (setq delta_V 		(+ delta_v_at delta_kbl)	))
		  
			(if (= (Connect.get CastaData vatr-shtr) 1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr) -1) (setq delta_V 		(+ delta_v_at delta_kbl)	))
			  	(if (= (Connect.get CastaData satr-lhtr)  1) (setq delta_V 		(- delta_v_at delta_kbl)	))
			  )
			)
			
		)
	)
  
  (Traeger.set Tr_ID (delta_V delta_V))
	(print "<-----------------------------------------------------------")			
)

; ----------------------------------------------------------------------------------------
; ERZEUGT DAS KNOTENBLECH
; ---------------------------------------------------------------------------------------- 
(defun createKnotenBlech (Blech_ID l_schr rand_abst)
	(print ">-----------------------------------------------------------")
	(print "ERZEUGE KNOTENBLECH")
	
	
  
  ; Default-Werte des Blechs
  ; ------------------------------------------------------------------
  (Blech.set Blech_ID 	(dp 10)
      			(hp 200)
      			(bp 120)
  )
	
	; allg. Daten
	; ------------------------------------------------------------------
	(setq b_Trg   		(Traeger.get Tr_ID b)
				t_Trg	  		(Traeger.get Tr_ID t)
				RWinkel 		(Traeger.get Tr_ID R_Winkel)
				delta_v_at 	(Traeger.get Tr_ID delta_v)
				delta_lr_at (Traeger.get Tr_ID delta_lr)
	)
	
	(setq delta_v_ht 	(Traeger.get Htrg delta_v)
				delta_lr_ht	(Traeger.get Htrg delta_lr)
	)
	
	(setq anschl_winkel (Connect.get CastaData at_laengswinkel))
  
	(setq sinAW (sin (/ (* PI anschl_winkel) 180.0)))
	
	(setq dp_knbl (Blech.get Blech_ID dp))
	(setq half_kbl (* 0.5 dp_knbl))
	
	  
  ; lokale Verschiebung des Windverbandes bestimmen
  ; ------------------------------------------------------------------
  (setq wv_versatz 0)
  
  (if (= Windverbandsstab_Umsetzen 1) (progn
  	; +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  	; 1. Anschluss (es liegt noch kein Anschluss am Windverbandstab vor)
  	; +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 	(calcFirstConnection)
  
	; +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  	; 2. Anschluss
  	; +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  	; Wenn der Traeger bereits angeschlossen ist, mu das zweite Blech versetzt werden 
	(if (> (Connect.get CastaData anschl_anderesEnde) 0) (progn
			(calcSecondConnection)	
	))
   ))	
  (if (= Windverbandsstab_Umsetzen 0) (progn
 	(calcFirstConnection)
	(calcSecondConnection)	
  ))
		
  ; Anbauteil hinzufgen
  ; ------------------------------------------------------------------
  (if (= K_VerbandsKnBlech  0) (progn
	  (if (= (connect.get CastaData amHtOberFlansch) 1) (progn
	      (traeger.addabtl Htrg Blech_ID 0.0 0.0 _knotenblech_of_)  ;
	  ))
	  (if (= (connect.get CastaData amHtUnterFlansch) 1) (progn
	      (traeger.addabtl Htrg Blech_ID 0.0 0.0 _knotenblech_uf_)  ;
	  ))
	  (if (= (connect.get CastaData amHtStegLinks) 1) (progn
	      (traeger.addabtl Htrg Blech_ID 0.0 0.0 _knotenblech_steg_li_)  ;    
	  ))
	  (if (= (connect.get CastaData amHtStegRechts) 1) (progn
	      (traeger.addabtl Htrg Blech_ID 0.0 0.0 _knotenblech_steg_re_)  ;    
	  ))
  ))  
  
  ; xPos berechnen
  ; ------------------------------------------------------------------
	(setq xPosStz      (Connect.get CastaData xPos_HT))
  
  ; Verschiebung des HT delta_v / delta_lr
;	(calcXPosDelta_HT)
	
	; Verschiebung des AT delta_v / delta_lr
;	(calcXPosDelta_AT)
	
	; xPos setzen
	(setq AbtlKnBlech (traeger.get Htrg ABTeil Blech_ID))
  	(Anbauteil.set  AbtlKnBlech (xpos xPosStz))


	; d_schr berechnen
	; ------------------------------------------------------------------
	(setq d_schr (+ (* 0.5 b_Trg) rand_abst))
	
	
	 ; Objekt.Methode          Variable     d_Schr   l_Schrb  SchrAchsWnkl
  
  (if (= K_VerbandsKnBlech 0) (progn
        (Blech.knotenblechschraeg Blech_ID   d_schr      l_schr       anschl_winkel)
	(print "Knotenblech wird verschoben")
        (print knotenblech_soll_versatz)
	(Blech.set Blech_ID (delta_lr knotenblech_soll_versatz))
  ))
  												
	(print "<-----------------------------------------------------------")
)

; ----------------------------------------------------------------------------------------
; Berechnet den Knotenblechveratz (quer zum HT), wenn der Verband noch nicht angeschlossen wurde
; ----------------------------------------------------------------------------------------
(defun calcFirstConnection ()
	
  (if (= (Connect.get CastaData amHtSteg) 1)
  	(progn
		  (if (= (Connect.get CastaData satr-lhtr)  1)	(setq at_verschiebung    delta_v_at))
		  (if (= (Connect.get CastaData satr-lhtr) -1)	(setq at_verschiebung    delta_v_at))
		  
		  (if (= (Connect.get CastaData vatr-vhtr) -1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq at_verschiebung    (- delta_v_at)))
		  		(if (= (Connect.get CastaData satr-lhtr) -1)	(setq at_verschiebung    (- delta_v_at)))
				)
			)
			
		)
	)
	(if (= (Connect.get CastaData amHtFlansch) 1)
  	(progn
		  (if (= (Connect.get CastaData satr-lhtr)  1)	(setq at_verschiebung    (- delta_v_at)))
		  (if (= (Connect.get CastaData satr-lhtr) -1)	(setq at_verschiebung    (- delta_v_at)))
		  
			(if (= (Connect.get CastaData vatr-shtr) 1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq at_verschiebung    delta_v_at))
		  		(if (= (Connect.get CastaData satr-lhtr) -1)	(setq at_verschiebung    delta_v_at))
				)
			)
		)
	)
  
  (print at_verschiebung)
  
  
  ; Knotenblech Verschiebung aus AT-Verschiebung
  ; ------------------------------------------------------------------
	(setq knotenblech_soll_versatz at_verschiebung)
	
	(setq schrauben_versatz knotenblech_soll_versatz)
	
	
	; Knotenblech Verschiebung aus HT-Verschiebung
	; ------------------------------------------------------------------
	(if (= (Connect.get CastaData amHTFlansch) 1)
		(progn
			(setq knotenblech_soll_versatz (- knotenblech_soll_versatz delta_lr_ht))
		)
	)
	(if (= (Connect.get CastaData amHTSteg) 1)
		(progn
			(setq knotenblech_soll_versatz (- knotenblech_soll_versatz delta_v_ht))
		)
	)
	(print knotenblech_soll_versatz)
)




; ----------------------------------------------------------------------------------------
; Berechnet den die Verschiebung des Knotenbleches, wenn der Verband bereits angeschlossen wurde
; ----------------------------------------------------------------------------------------
(defun calcSecondConnection ()
	
	(print "TRGER IST BEREITS FIXIERT.")
	(setq t_trg (Traeger.get Tr_ID t))
	
	; Anschluss am HT-Flansch
	(if (= (Connect.get CastaData amHtFlansch) 1)
		(progn
			(if (= (Connect.get CastaData vatr-shtr) 1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr) 1)
						(setq knotenblech_soll_versatz (+ knotenblech_soll_versatz (+ half_kbl (* 0.5 t_trg))))
					)
					(if (= (Connect.get CastaData satr-lhtr) -1)
						(setq knotenblech_soll_versatz (- knotenblech_soll_versatz (+ half_kbl (* 0.5 t_trg))))
					)
				)
				(progn
					(if (= (Connect.get CastaData satr-lhtr) 1)
						(setq knotenblech_soll_versatz (+ knotenblech_soll_versatz (+ half_kbl (* 0.5 t_trg))))
					)
					(if (= (Connect.get CastaData satr-lhtr) -1)
						(setq knotenblech_soll_versatz (- knotenblech_soll_versatz (+ half_kbl (* 0.5 t_trg))))
					)
				)
			)
		)
	)
	
	; Anschluss am HT-Steg
	(if (= (Connect.get CastaData amHtSteg) 1)
		(progn
			(if (= (Connect.get CastaData vatr-vhtr) -1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr) 1)
						(setq knotenblech_soll_versatz (+ knotenblech_soll_versatz (+ half_kbl (* 0.5 t_trg))))
					)
					(if (= (Connect.get CastaData satr-lhtr) -1)
						(setq knotenblech_soll_versatz (- knotenblech_soll_versatz (+ half_kbl (* 0.5 t_trg))))
					)
				)
				(progn
					(if (= (Connect.get CastaData satr-lhtr) 1)
						(setq knotenblech_soll_versatz (+ knotenblech_soll_versatz (+ half_kbl (* 0.5 t_trg))))
					)
					(if (= (Connect.get CastaData satr-lhtr) -1)
						(setq knotenblech_soll_versatz (- knotenblech_soll_versatz (+ half_kbl (* 0.5 t_trg))))
					)
				)
			)
			
		)
	)
	
	(print knotenblech_soll_versatz)
)


; ----------------------------------------------------------------------------------------
; Erzeugt das Lochbild
; ----------------------------------------------------------------------------------------
(defun createLochbild (BlechID Lchb_ID rand_abst p_abstand_stz)
	(print ">-----------------------------------------------------------")
	(print "ERZEUGE LOCHBILD")
	; Juli 2010 - ich glaube, es wird nur diese Variante durchlaufen
	; createLochbild_Var2 knnte dann beim K-Verband herausgenommen werden.
	; oder wird als extra Anschluss angeboten. Deswegen noch drin.
	
	(Lochbild.set Lchb_ID 	(lb_art 	2)
				(S_Bez 		"M16")
				(Guete		"4.6")
				(w		"0 0")
				(e		"0 0 0 0 0 0")
				(Anz_S		3)
				(dok 		0)
				(klemml		20)
	)
	
	; allg. Daten
	(setq dp_Blech 	(Blech.get BlechID dp)
				d_sch 		(Blech.get BlechID knbl_dschr)
				l_sch			(Blech.get BlechID knbl_lschr)
	)
	
	(setq t_Trg 			(Traeger.get Tr_ID t)
				s_Trg				(Traeger.get Tr_ID s)
				b_Trg				(Traeger.get Tr_ID b)
				r_winkel		(Traeger.get Tr_ID r_winkel)
				delta_lr_at	(Traeger.get Tr_ID delta_lr)
	)
	(setq delta_v_ht	(Traeger.get Htrg delta_v)
				delta_lr_ht	(Traeger.get Htrg delta_lr)
	)
	
	; Klemmlnge
	(setq dicke_trg t_Trg)
	(setq klemml (+ dicke_trg dp_Blech))
	
		
	; Kontaktlnge zwichen AT und Knotenblech
	(if (= (Connect.get CastaData amHtFlansch) 1)
  	(setq afl_wnkl (Connect.get CastaData at_laengswinkel))
  )
  (if (= (Connect.get CastaData amHtSteg) 1)
  	(setq afl_wnkl (Connect.get CastaData at_laengswinkel))
  )
	
	(print afl_wnkl)
	(setq afl_wnkl (- afl_wnkl 90.0))
	(print afl_wnkl)
	(setq tan_afl	(tan (/ (* PI afl_wnkl) 180.0)))
	(print tan_afl)
	(if (< tan_afl 0) (setq tan_afl (- tan_afl)))
	(print tan_afl)
	(setq diff_1 (* rand_abst tan_afl))
	(print diff_1)
	(setq diff_2 (- p_abstand_stz diff_1))
	(print diff_2)
	(setq kontakt_laenge (- l_sch diff_2))
	(print kontakt_laenge)
	; e-Werte
	
	(setq e_abst (* 0.25 kontakt_laenge)) ; erstmal gleichmig verteilen 
	(print e_abst)
	
	(setq anteil_verbindung (* (* 0.5 b_Trg) tan_afl))
	(print anteil_verbindung)
	
	(setq e0 (+ anteil_verbindung p_abstand_stz e_abst))
	(print e0)
	
	;; Mrz 2010 - Erweiterung auf Knotenbleche auf Flanschkante
	(setq anFlansch_Aussenkante 0)
	(setq AbstandFlansch 0.0)

	(setq	qsform_HT	(Traeger.get HTrg qsform)
		t_HT		(Traeger.get HTrg t)
	)

	(setq blch_dlr (Blech.get Knotenblech delta_lr))
  	(if (< blch_dlr 0) (setq blch_dlr (- blch_dlr)))	; sozusagen absolut setzen
  	(if (> blch_dlr (- (* 0.5 h_Ht) t_Ht)) (setq anFlansch_Aussenkante 1))
  
	(if (= qsform_HT "K") (setq anFlansch_Aussenkante 1))
  
  	(if (= anFlansch_Aussenkante 1) (progn
	    (setq cos_Afl	(cos (/ (* PI afl_wnkl) 180.0)))
	    (setq b_Ht 		(Traeger.get HTrg b))
	
	    (if (= (connect.get CastaData amHtStegLinks) 1) (progn
	         (if (= qsform_ht "U") 
	         	(setq b_Ht 0)
	         	(setq b_Ht (* 0.5 b_Ht))
	         )
	    ))
	    (if (= (connect.get CastaData amHtStegRechts) 1) (progn
	         (if (= qsform_ht "U") 
	         	(setq b_Ht b_Ht)
	         	(setq b_Ht (* 0.5 b_Ht))
	         )
	    ))

	    (if (/= cos_Afl 0.0) (progn
		(setq AbstandFlansch (/ b_Ht cos_Afl))
	    ))
	))
	;; Ende Erweiterung Mrz 2010
	(setq e0 (+ e0 AbstandFlansch))
	
	(if (= (Connect.get CastaData amHtSteg) 1)
		(setq schrauben_versatz knotenblech_soll_versatz)
	)
	; Werte setzen
	(Lochbild.set Lchb_ID 	(klemml		klemml)
				(e0		e0)
				(e1 		(* 1.5 e_abst))
				;(e2		e_abst)
				;(delta_lr	knotenblech_soll_versatz)
	)
	(if (= (Connect.get CastaData amHtSteg) 1)   	(calc_DXSKopf_Steganschluss))
	(if (= (Connect.get CastaData amHtFlansch) 1)	(calc_DXSKopf_Flanschanschluss))
	
	; Lochbild dem HT hinzufgen
	(setq AbtlKnoBl	(Traeger.get Htrg AbTeil BlechID))
	(Traeger.addabtl Htrg Lchb_ID 0.0 0.0 _knblLochbild_ AbtlKnoBl)
	
	(setq AbtlKnoBlLchb    (Traeger.get Htrg AbTeil Lchb_ID))
	(Anbauteil.set AbtlKnoBlLchb	(Master 1))
	
	(print "<-----------------------------------------------------------")
)



(defun createATLochbild (Lchb_ID)
	(print ">-----------------------------------------------------------")
	(print  "ERZEUGE LOCHBILD AM AT")
	
	
	
	; Lochbildanbauteil whlen
	(if (= (Connect.get CastaData amHtFlansch) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(progn
					(if (= (Connect.get CastaData satr-shtr)  1)	(setq WINDVERBAND_LB _windvblchb_steg_links_)	)
					(if (= (Connect.get CastaData satr-shtr) -1)	(setq WINDVERBAND_LB _windvblchb_steg_links_)	)
					(if (= (Connect.get CastaData vatr-shtr)  1)	(setq WINDVERBAND_LB _windvblchb_flansch_links_)	)
					(if (= (Connect.get CastaData vatr-shtr) -1)	(setq WINDVERBAND_LB _windvblchb_flansch_links_)	)
				)
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(progn
					(if (= (Connect.get CastaData satr-shtr)  1)	(setq WINDVERBAND_LB _windvblchb_steg_rechts_)	)
					(if (= (Connect.get CastaData satr-shtr) -1)	(setq WINDVERBAND_LB _windvblchb_steg_rechts_)	)
					(if (= (Connect.get CastaData vatr-shtr)  1)	(setq WINDVERBAND_LB _windvblchb_flansch_rechts_)	)
					(if (= (Connect.get CastaData vatr-shtr) -1)	(setq WINDVERBAND_LB _windvblchb_flansch_rechts_)	)
				)
			)
		)
	)
	(if (= (Connect.get CastaData amHtSteg) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(progn
					(if (= (Connect.get CastaData vatr-shtr)  1)	(setq WINDVERBAND_LB _windvblchb_steg_links_)	)
					(if (= (Connect.get CastaData vatr-shtr) -1)	(setq WINDVERBAND_LB _windvblchb_steg_links_)	)
					(if (= (Connect.get CastaData satr-shtr)  1)	(setq WINDVERBAND_LB _windvblchb_flansch_links_)	)
					(if (= (Connect.get CastaData satr-shtr) -1)	(setq WINDVERBAND_LB _windvblchb_flansch_links_)	)
				)
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(progn
					(if (= (Connect.get CastaData vatr-shtr)  1)	(setq WINDVERBAND_LB _windvblchb_steg_rechts_)	)
					(if (= (Connect.get CastaData vatr-shtr) -1)	(setq WINDVERBAND_LB _windvblchb_steg_rechts_)	)
					(if (= (Connect.get CastaData satr-shtr)  1)	(setq WINDVERBAND_LB _windvblchb_flansch_rechts_)	)
					(if (= (Connect.get CastaData satr-shtr) -1)	(setq WINDVERBAND_LB _windvblchb_flansch_rechts_)	)
				)
			)
		)
	)
	
	(setq h_at	(Traeger.get Tr_ID h)
				b_at	(Traeger.get Tr_ID b)
	)
	(print h_at)
	(print b_at)
	(setq delta_v_abtl_at 0)
	(setq delta_lr_abtl_at 0)
	
	
	

	; Anteil delta_v HT
	; ----------------------------------------------
	(if (= (Connect.get CastaData amHtFlansch) 1)
		(progn
			(setq delta_v_ht	(Traeger.get Htrg delta_v))
			(print delta_v_ht)
			(setq at_winkel (Connect.get CastaData at_laengswinkel))
			(print at_winkel)
			(setq cosW (cos (/ (* PI at_winkel) 180.0)))
			(print cosW)
			
			(if (/= cosW 0.0)
				(setq anteil_delta_v_abtl_ht (/ (* 1.0 delta_v_ht) cosW))
				(setq anteil_delta_v_abtl_ht 0.0)
			)
			(print anteil_delta_v_abtl_ht)
			
			(if (> at_winkel 90.0)
				(setq delta_v_abtl_at (- anteil_delta_v_abtl_ht))
				(setq delta_v_abtl_at anteil_delta_v_abtl_ht)
			)
			(print delta_v_abtl_at)
			
			(if (= (Connect.get CastaData amHtOberflansch) 1) 	(setq delta_v_abtl_at (- delta_v_abtl_at))	)
			(if (= (Connect.get CastaData amHtUnterflansch) 1) 	(setq delta_v_abtl_at delta_v_abtl_at)	)
			(print delta_v_abtl_at)
		)
	)
	
	
	; Anteil delta_lr HT
	; ----------------------------------------------
	(if (= (Connect.get CastaData amHtSteg) 1)
		(progn
			(setq delta_lr_ht	(Traeger.get Htrg delta_lr))
			(print delta_lr_ht)
			(setq at_winkel (Connect.get CastaData at_laengswinkel))
			(print at_winkel)
			(setq cosW (cos (/ (* PI at_winkel) 180.0)))
			(print cosW)
			
			(if (/= cosW 0.0)
				(setq anteil_delta_lr_abtl_ht (/ (* 1.0 delta_lr_ht) cosW))
			)
			(print anteil_delta_lr_abtl_ht)
			
			(if (> at_winkel 90.0)
				(setq delta_v_abtl_at (- anteil_delta_lr_abtl_ht))
				(setq delta_v_abtl_at anteil_delta_lr_abtl_ht)
			)
			(print delta_v_abtl_at)
			
			(if (= (Connect.get CastaData amHtStegLinks) 1) 	(setq delta_v_abtl_at (- delta_v_abtl_at))	)
			(if (= (Connect.get CastaData amHtStegRechts) 1) 	(setq delta_v_abtl_at delta_v_abtl_at)	)
			(print delta_v_abtl_at)
		)
	)
	


	; Anteil delta AT
	; ----------------------------------------------
	(setq delta_v_at (Traeger.get Tr_ID delta_v))
	(setq delta_lr_at (Traeger.get Tr_ID delta_lr))
	(print delta_v_at)
	(print delta_lr_at)
	
	(setq tanW (tan (/ (* PI at_winkel) 180.0)))
	(print tanW)
	
	(setq anteil_delta_v_at (/ (* 1.0 delta_v_at) tanW))
	(print anteil_delta_v_at)
	(setq anteil_delta_lr_at (/ (* 1.0 delta_lr_at) tanW))
	(print anteil_delta_lr_at)	
	
	(if (= (Connect.get CastaData linkesEnde) 1)
		(progn
			(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_v_abtl_at (+ delta_v_abtl_at anteil_delta_v_at))	)
			(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_v_abtl_at (- delta_v_abtl_at anteil_delta_v_at))	)
			(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta_v_abtl_at (+ delta_v_abtl_at anteil_delta_lr_at))	)
			(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta_v_abtl_at (- delta_v_abtl_at anteil_delta_lr_at))	)
		)
	)
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(progn
			(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_v_abtl_at (+ delta_v_abtl_at anteil_delta_v_at))	)
			(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_v_abtl_at (- delta_v_abtl_at anteil_delta_v_at))	)
			(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta_v_abtl_at (+ delta_v_abtl_at anteil_delta_lr_at))	)
			(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta_v_abtl_at (- delta_v_abtl_at anteil_delta_lr_at))	)
		)
	)
	(print delta_v_abtl_at)
	
	
	(setq anteil_delta_lr_abtl_at (/ delta_lr_abtl_at tanW))
	(print anteil_delta_lr_at)
	
	; delta_lr
	(if (= (Connect.get CastaData linkesEnde) 1)
		(progn
			(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_v_abtl_at (- delta_v_abtl_at anteil_delta_lr_abtl_at))	)
			(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_v_abtl_at (+ delta_v_abtl_at anteil_delta_lr_abtl_at))	)
			(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta_v_abtl_at (- delta_v_abtl_at anteil_delta_lr_abtl_at))	)
			(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta_v_abtl_at (+ delta_v_abtl_at anteil_delta_lr_abtl_at))	)
		)
	)
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(progn
			(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_v_abtl_at (+ delta_v_abtl_at anteil_delta_lr_abtl_at))	)
			(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_v_abtl_at (- delta_v_abtl_at anteil_delta_lr_abtl_at))	)
			(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta_v_abtl_at (+ delta_v_abtl_at anteil_delta_lr_abtl_at))	)
			(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta_v_abtl_at (- delta_v_abtl_at anteil_delta_lr_abtl_at))	)
		)
	)
	(print delta_v_abtl_at)
	

	
	
	; Anbauteil hinzufgen
	(Traeger.addabtl Tr_ID Lchb_ID 0.0 0.0 WINDVERBAND_LB)
	
	(setq AbtlKnoBlLchbAT    (Traeger.get Tr_ID AbTeil Lchb_ID))
	(Anbauteil.set AbtlKnoBlLchbAT 	(Master 0)
																	(delta_lr delta_lr_abtl_at)
																	(delta_v 	delta_v_abtl_at)
	)
	
	
	(if (= LB_DEBUG 1)
		(progn
			; TEST
			; +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
			(setq LB_DUMMY (Lochbild.create))
			(Lochbild.copy LB_DUMMY Lchb_ID)
			(Traeger.addabtl Tr_ID LB_DUMMY 0.0 0.0 WINDVERBAND_LB)
			(setq AbtlKnoBlLchbAT_DUMMY    (Traeger.get Tr_ID AbTeil LB_DUMMY))
			(Anbauteil.set AbtlKnoBlLchbAT_DUMMY 	(Master 1)
																						(delta_lr delta_lr_abtl_at)
																						(delta_v 	delta_v_abtl_at)
			)
			
			(Connect.storeAnschlObjs CastaData LB_DUMMY)
			; +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	))
	(print "<---------------------------------------")
)



; ----------------------------------------------------------------------------------------
; Berechnet die Auswirkungen auf die XPos des Knotenbleches bei einer Verschiebung
; des HT in Richtung delta_v
; ----------------------------------------------------------------------------------------
(defun calcXPosDelta_HT ()
	(print ">-----------------------------------------------------------")
	(print "BERECHNE DELTA_HT AUSWIRKUNG")
	(if (= (Connect.get CastaData amHtFlansch) 1)
  	(setq Winkel (connect.get CastaData at_laengswinkel))
  )
  (if (= (Connect.get CastaData amHtSteg) 1)
  	(setq Winkel (connect.get CastaData at_laengswinkel))
  )
	
	(setq Winkel (- 90.0 Winkel))
	(setq tanW (tan (/ (* PI Winkel) 180.0)))
	
	(print Winkel)
	(print tanW)
	
	(print xPosStz)
	
	(if (= (Connect.get CastaData amHTFlansch) 1)
		(progn
			(setq deltaXPos (* delta_v_ht tanW))
			(print deltaXPos)
	
			(if (= (Connect.get CastaData amHtUnterflansch) 1)
				(setq xPosStz (+ xPosStz deltaXPos))
			)
			(if (= (Connect.get CastaData amHtOberflansch) 1)
				(setq xPosStz (- xPosStz deltaXPos))
			)
		)
	)
	(if (= (Connect.get CastaData amHTSteg) 1)
		(progn
			(setq knotenblech_final_versatz (- knotenblech_soll_versatz delta_lr_ht))
			(setq deltaXPos (* delta_lr_ht tanW))
			(print deltaXPos)
	
			(if (= (Connect.get CastaData amHtStegLinks) 1)
				(setq xPosStz (- xPosStz deltaXPos))
			)
			(if (= (Connect.get CastaData amHtStegRechts) 1)
				(setq xPosStz (+ xPosStz deltaXPos))
			)
		)
	)
	(print xPosStz)
	(print "<-------------------------------------------------------ENDE")
)

; ----------------------------------------------------------------------------------------
; BERECHNET DIE NEUE XPOS, DIE AUS DER VERSCHIEBUNG DES AT RESULTIERT
; ----------------------------------------------------------------------------------------
(defun calcXPosDelta_AT ()
	(print ">-----------------------------------------------------------")
	(print "BERECHNE DELTA_AT AUSWIRKUNG")
	; xPos berechnen und setzen
	(print xPosStz)
	
	(setq h_Trg (Traeger.get Tr_ID h)
				b_Trg	(Traeger.get Tr_ID b)
	)
	
	(setq Winkel (connect.get CastaData at_laengswinkel))
	(setq sinAW (sin (/ (* PI Winkel) 180.0)))
	(print Winkel)
	
	(setq rwinkel (Traeger.get Tr_ID r_winkel))
	(print rwinkel)
	
	(setq anteil_aus_delta_lr (/ delta_lr_at sinAW))
	(print anteil_aus_delta_lr)
	
	
	(if (= (Connect.get CastaData amHtFlansch) 1)
		(progn
			(if (= (Connect.get CastaData vatr-shtr) 1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq xPosStz (+ xPosStz anteil_aus_delta_lr)))
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq xPosStz (- xPosStz anteil_aus_delta_lr)))
				)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq xPosStz (+ xPosStz anteil_aus_delta_lr)))
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq xPosStz (- xPosStz anteil_aus_delta_lr)))
				)
			)
		)
	)
	
	
				
	(if (= (Connect.get CastaData amHtSteg) 1)
		(progn
			(if (= (Connect.get CastaData vatr-vhtr) -1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq xPosStz (+ xPosStz anteil_aus_delta_lr)))
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq xPosStz (- xPosStz anteil_aus_delta_lr)))	
				)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq xPosStz (+ xPosStz anteil_aus_delta_lr)))
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq xPosStz (- xPosStz anteil_aus_delta_lr)))	
				)
			)
		)
	)
				
	
	(print xPosStz)
	(print "<-----------------------------------------------------------")
)



; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
; ----------------------------------------------------------------------------------------
; VARIANTE 2
; ----------------------------------------------------------------------------------------
; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++


; ----------------------------------------------------------------------------------------
; Erzeugt das Knotenblech fr Variante 2
; ----------------------------------------------------------------------------------------
(defun manualKnotenBlechCreation (Lchb_ID)
	(print ">-----------------------------------------------------------")
	(print  "BERECHNE KNOTENBLECH VAR_2")
	(setq	h_ht 		(Traeger.get Htrg h)
		delta_v_ht	(Traeger.get Htrg delta_v)
		delta_lr_ht	(Traeger.get Htrg delta_lr)
	)
	(setq	h_ht_halb (* 0.5 h_ht))
	
	(setq	h_at		(Traeger.get Tr_ID h)
		b_at		(Traeger.get Tr_ID b)
		delta_v_at	(Traeger.get Tr_ID delta_v)
		delta_lr_at	(Traeger.get Tr_ID delta_lr)
	)
	
	(setq	at_winkel	(Connect.get CastaData at_laengswinkel)
		xPos_ht		(Connect.get CastaData xPos_ht)
	)
	
	(setq lb_e0 (Lochbild.get Lchb_ID e0))
	
	(setq tanATW (tan (/ (* PI at_winkel) 180.0)))
	(setq sinATW (sin (/ (* PI at_winkel) 180.0)))
	
	;(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq bp_blech (* 1.67 h_at)))
	;(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq bp_blech (* 1.67 h_at)))
	;(if (= (Connect.get CastaData satr-lhtr)  1)	(setq bp_blech (* 1.67 b_at)))
	;(if (= (Connect.get CastaData satr-lhtr) -1)	(setq bp_blech (* 1.67 b_at)))
	
	(setq lb_rand_abst (* 1.3 (* 0.5 b_at))) ; TODO: Rotation AT evtl. noch beachten 
	(setq lb_stz_abst (* lb_e0 sinATW))
	(print lb_stz_abst)
	
	(setq bp_blech (+ lb_rand_abst lb_stz_abst))
	(setq bp_blech_rund (runde bp_blech auf 5.0))
	
	(setq hp_blech (* 1.2 bp_blech_rund))
	(setq hp_blech_rund (runde hp_blech auf 5.0))
	
	(setq help_1 (+ h_ht_halb bp_blech_rund))
	
	(setq help_2 (/ help_1 tanATW))
	
		
	; Blechecken
	(if (> at_winkel 90.0)
		(progn
			(setq y4_blech (* 0.5 bp_blech_rund))
			(setq x4_blech (- (/ y4_blech tanATW)))
			
			(setq x1_blech 0.0)
			(setq y1_blech 0.0)
		)
	)
	(if (< at_winkel 90.0)
		(progn
			(setq x4_blech 0.0)
			(setq y4_blech 0.0)
			
			(setq y1_blech (* 0.5 bp_blech_rund))
			(setq x1_blech (/ y1_blech tanATW))
		)
	)
	(if (= at_winkel 90.0)
		(progn
			(setq x4_blech 0.0)
			(setq y4_blech 0.0)
			(setq x1_blech 0.0)
			(setq y1_blech 0.0)
		)
	)
	
	(setq dok_blech (* 0.5 (- hp_blech_rund bp_blech_rund)))
	(if (> at_winkel 90.0)
		(setq dok_blech (- dok_blech))
	)
	(if (= at_winkel 90.0)
		(setq dok_blech 0.0)
	)  
	
  ; Default-Werte des Blechs
  (Blech.set knotenBlech 	(dp 	10)
      				(hp 	hp_blech_rund)
      				(bp 	bp_blech_rund)
      				(dok 	dok_blech)
      				(x1 	x1_blech)
      				(y1 	y1_blech)
      				(x4 	x4_blech)
      				(y4 	y4_blech)
  )
  
  
  (setq dp_knbl (Blech.get knotenBlech dp))
  (setq half_kbl (* 0.5 dp_knbl))
  (if (= Windverbandsstab_Umsetzen 1) (progn
	; +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	; 1. Anschluss (es liegt noch kein Anschluss am Windverbandstab vor)
	; +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	(calcFirstConnection)
		
	; +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	; 2. Anschluss
	; +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	; Wenn der Traeger bereits angeschlossen ist, mu das zweite Blech versetzt werden 
	(if (> (Connect.get CastaData anschl_anderesEnde) 0) (progn
		(calcSecondConnection)
	))
  ))  
  (if (= Windverbandsstab_Umsetzen 0) (progn
	(calcFirstConnection)
	(calcSecondConnection)
  ))  
  
  
  ; xPos Knotenblech
  ; ----------------------------------------------
	;(if (> at_winkel 90.0) 
	;	(setq xPos_ht (+ xPos_ht (+ help_2 (* 0.5 hp_blech_rund))))
	;	(setq xPos_ht (+ xPos_ht (- help_2 (* 0.5 hp_blech_rund))))
	;)
	(print xPos_ht)
	

  
  (if (= (connect.get CastaData amHtOberFlansch) 1) (progn
      (traeger.addabtl Htrg knotenBlech xPos_ht 0.0 _knotenblech_of_)  ;
  ))
  (if (= (connect.get CastaData amHtUnterFlansch) 1) (progn
      (traeger.addabtl Htrg knotenBlech xPos_ht 0.0 _knotenblech_uf_)  ;
  ))
  (if (= (connect.get CastaData amHtStegLinks) 1) (progn
      (traeger.addabtl Htrg knotenBlech xPos_ht 0.0 _knotenblech_steg_li_)  ;    
  ))
  (if (= (connect.get CastaData amHtStegRechts) 1) (progn
      (traeger.addabtl Htrg knotenBlech xPos_ht 0.0 _knotenblech_steg_re_)  ;    
  ))
  
  
  
  ;(setq xPosStz      (Connect.get CastaData xPos_HT))
  ;(setq WnklAnschlFl (Connect.get CastaData afl_vwinkel))
  (setq xPosStz xPos_ht)
  
  ; Verschiebung des HT delta_v / delta_lr
	(calcXPosDelta_HT)
	
	; Verschiebung des AT delta_v / delta_lr
	(calcXPosDelta_AT)
	
	(print xPosStz)
	; xPos setzen
	(setq AbtlKnBlech (traeger.get Htrg ABTeil knotenBlech))
  (Anbauteil.set  AbtlKnBlech (xPos xPosStz))
  
  (Blech.knotenblechschraeg knotenBlech 0.0 0.0 at_winkel)
  
  (Blech.set knotenBlech (delta_lr knotenblech_soll_versatz))
  
  (print "<-----------------------------------------------------------")
)


(defun calcAndSetE0_Var2 (Lchb_ID parallel_abstand_stz)
	
	(setq h_at 	(Traeger.get Tr_ID h)
				b_at	(Traeger.get Tr_ID b)
	)
	
	(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq at_halb (* 0.5 h_at)))
	(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq at_halb (* 0.5 h_at)))
	(if (= (Connect.get CastaData satr-lhtr)  1)	(setq at_halb (* 0.5 b_at)))
	(if (= (Connect.get CastaData satr-lhtr) -1)	(setq at_halb (* 0.5 b_at)))
	
	
	(setq at_winkel (Connect.get CastaData at_laengswinkel))
	(setq tanATW (tan (/ (* PI at_winkel) 180.0)))
	(setq sinATW (sin (/ (* PI at_winkel) 180.0)))
	
	(if (/= sinATW 0.0)
		(setq e0_1 (/ parallel_abstand_stz sinATW))
		(setq e0_1 parallel_abstand_stz)
	)
	(print e0_1)
	
	(setq e0_2 (/ at_halb tanATW))
	(if (< e0_2 0.0)
		(setq e0_2 (- e0_2))
	)
	(print e0_2)
	
	(setq e0_3 at_halb)
	(print e0_3)
		
	(setq e0 (+ e0_1 e0_2 e0_3))
	(print e0)
	
	(Lochbild.set Lchb_ID (e0 e0))
)
; ----------------------------------------------------------------------------------------
; Erzeugt das Lochbild fr Knotenblech Variante 2
; ----------------------------------------------------------------------------------------
(defun createLochbild_Var2 (Lchb_ID Blech_ID p_abstand_stz)
	
	(Lochbild.set Lchb_ID 	(lb_art 	2)
													(S_Bez 		"M16")
													(Guete		"4.6")											
	)
	
	; allg. Daten
	(setq dp_blech 	(Blech.get Blech_ID dp)
				bp_blech	(Blech.get Blech_ID bp)
				hp_blech  (Blech.get Blech_ID hp)
	)
	
	(setq t_at				(Traeger.get Tr_ID t)
				s_at				(Traeger.get Tr_ID s)
				b_at				(Traeger.get Tr_ID b)
				h_at				(Traeger.get Tr_ID h)
				delta_lr_at	(Traeger.get Tr_ID delta_lr)
	)
	(setq delta_v_ht	(Traeger.get Htrg delta_v)
				delta_lr_ht	(Traeger.get Htrg delta_lr)
	)
	
	(setq xPos_ht (Connect.get CastaData xPos_ht)
				at_winkel	(Connect.get CastaData at_laengswinkel)
	)
	
	; Klemmlnge
	(setq dicke_trg t_at)
	(setq klemml (+ dicke_trg dp_blech))
	
	
	; dxSKopf berechnen und setzen
	(if (= (Connect.get CastaData amHtSteg) 1)   	(calc_DXSKopf_Steganschluss))
	(if (= (Connect.get CastaData amHtFlansch) 1)	(calc_DXSKopf_Flanschanschluss))
	
	
	; Werte setzen
	(Lochbild.set Lchb_ID 	(klemml		klemml))
	
	
	; xPos Lochbild-Anbauteil
	(setq xPos_LB xPos_ht)
	
	; Lochbild dem HT hinzufgen
	(setq AbtlKnoBl	(Traeger.get Htrg AbTeil Blech_ID))
	(Traeger.addabtl Htrg Lchb_ID 0.0 0.0 _knblLochbild_ AbtlKnoBl)
	
	(setq AbtlKnoBlLchb    (Traeger.get Htrg AbTeil Lchb_ID))
		
	(Anbauteil.set AbtlKnoBlLchb 	(Master 1)
					(delta_sx knotenblech_soll_versatz)
	)

	;; Mrz 2010 - Erweiterung auf Knotenbleche auf Flanschkante
	(setq anFlansch_Aussenkante 0)
	(setq AbstandFlansch 0.0)

	(setq	qsform_HT	(Traeger.get HTrg qsform)
		t_HT		(Traeger.get HTrg t)
	)

	(setq blch_dlr (Blech.get Knotenblech delta_lr))
  	(if (< blch_dlr 0) (setq blch_dlr (- blch_dlr)))	; sozusagen absolut setzen
	(if (> blch_dlr (- (* 0.5 h_Ht) t_Ht)) (setq anFlansch_Aussenkante 1))

	(if (= qsform_HT "K") (progn
	    (if (= (connect.get CastaData amHtSteg) 1) (progn
		(setq anFlansch_Aussenkante 1)
	    ))
	))
	
  
  	(if (= anFlansch_Aussenkante 1) (progn
	    (setq afl_wnkl	(Connect.get CastaData at_laengswinkel))
	    (setq afl_wnkl	(- afl_wnkl 90.0))
	    (setq cos_Afl	(cos (/ (* PI afl_wnkl) 180.0)))
	    (setq b_Ht 		(Traeger.get HTrg b))
	    (setq e0_Lochbild	(Lochbild.get Lchb_ID e0))

	
	    (if (= (connect.get CastaData amHtStegLinks) 1) (progn
	         (if (= qsform_HT "U") 
	         	(setq b_Ht 0)
	         	(setq b_Ht (* 0.5 b_Ht))
	         )
	    ))
	    (if (= (connect.get CastaData amHtStegRechts) 1) (progn
	         (if (= qsform_HT "U") 
	         	(setq b_Ht b_Ht)
	         	(setq b_Ht (* 0.5 b_Ht))
	         )
	    ))

	    (if (/= cos_Afl 0.0) (progn
		(setq AbstandFlansch (/ b_Ht cos_Afl))
	    ))
	    
	    (setq e0_Lochbild (+ e0_Lochbild AbstandFlansch))
	    (Lochbild.set Lchb_ID (e0 e0_Lochbild))
	))
	;; Ende Erweiterung Mrz 2010

)

; ---------------------------------------------------------------------
; Lochbildverschiebung berechnen
; ---------------------------------------------------------------------
(defun calcLochbDelta_LR ()
   (print "Berechne Verschiebungen des Lochbilds")

   (setq ABtl_Lochb_HT (Traeger.get HTrg   ABTeil knblLochbild))
   (setq ABtl_Lochb_AT (Traeger.get Tr_ID  ABTeil knblLochbild))

   (if (= (Connect.get CastaData amHtFlansch) 1) (progn
  	(setq 	Winkel	(connect.get CastaData AFl_VWinkel)
  		h_HT	(Traeger.get HTrg h)
  		v_HT	(Traeger.get HTrg delta_V)
  		b_Bl    (Blech.get   knotenBlech bp)
  		dlr_AT  (Traeger.get Tr_ID delta_LR)
  	)
  	(if (= (connect.get CastaData SAtr-VHtr) 1) (setq dlr_AT (- dlr_AT)))
   ))
   (if (= (Connect.get CastaData amHtSteg) 1) (progn
  	(setq 	Winkel (connect.get CastaData AFl_HWinkel)
  		h_HT	(Traeger.get HTrg s)		; ist eigentlich s oder b oder 0
  		v_HT	(Traeger.get HTrg delta_lr)	; ist eigentlich lr
  		b_Bl    (Blech.get   knotenBlech bp)
  		dlr_AT  (Traeger.get Tr_ID delta_LR)
  		dlr_AT  (- dlr_AT)
  	)
  	(setq qsform_ht (Traeger.get HTrg qsform))
  	(print qsform_ht)
  	(if (= qsform_ht "K") (setq h_HT  (Traeger.get HTrg b)))
  	(if (= qsform_ht "U") (progn
  	   (if (= (Connect.get CastaData amHtStegRechts) 1)
  	   	(setq h_HT (* 2.0 h_HT))
  	   	(setq h_HT    0.0)
  	   )
  	))

  	(if (= 1 2) (progn
  	  (if (= (connect.get CastaData AmHTStegRechts) 1)
  	    (if (= (connect.get CastaData VAtr-VHtr) 1) (setq dlr_AT (- dlr_AT)))
  	  )
  	  (if (= (connect.get CastaData AmHTStegLinks) 1)
  	    (if (= (connect.get CastaData SAtr-SHtr) -1) (setq dlr_AT (- dlr_AT)))
  	  )
  	))
  	; 
  	(if (= (connect.get CastaData AmHTSteg) 1)
  	     (if (= (Connect.get CastaData satr-shtr) -1) (setq dlr_AT (- dlr_AT)))
  	)

   ))
   (setq sinW (sin (/ (* PI Winkel) 180.0)))
   (setq cosW (cos (/ (* PI Winkel) 180.0)))
   (setq tanW (tan (/ (* PI Winkel) 180.0)))

   (setq 
           dLR_Ges_HT 0.0
           dv_Lchb_AT 0.0
           dV_Ges_HT  0.0
   )

   (setq StegLinks_OberFlansch 0  StegRechts_UnterFlansch 0)
   (if (= (Connect.get CastaData amHtStegLinks)    1) (setq StegLinks_OberFlansch   1))
   (if (= (Connect.get CastaData amHtOberflansch)  1) (setq StegLinks_OberFlansch   1))
   (if (= (Connect.get CastaData amHtStegRechts)   1) (setq StegRechts_UnterFlansch 1))
   (if (= (Connect.get CastaData amHtUnterflansch) 1) (setq StegRechts_UnterFlansch 1))


   (if (= StegLinks_OberFlansch  1) (progn
;       (if (< winkel 90.0) (print "StegLinks_OberFlansch   < winkel 90.0"))
;       (if (> winkel 90.0) (print "StegLinks_OberFlansch   > winkel 90.0"))
       (if (< winkel 90.0) 
          (setq  
          	 dlr_AT         (- dlr_AT)
		 dLR_Ges_HT     (- dlr_AT (* v_HT cosW))
		 dLR_Ges_HT_St  (- dlr_AT (* v_HT cosW))
		 dv_Lchb_AT     (+ (/ (- (* 0.5 h_HT) v_HT) sinW)  (/ dlr_AT tanW))
	  )
          (setq
          	 dlr_AT         (- dlr_AT)
		 dLR_Ges_HT     (- (+ dlr_AT (* v_HT cosW)))
		 dLR_Ges_HT_St  (- (+ dlr_AT (* v_HT cosW)))
		 dv_Lchb_AT     (- (/ (- (* 0.5 h_HT) v_HT) sinW)  (/ dlr_AT tanW))
          )
       )
       (if (= (Connect.get CastaData amHtStegLinks) 1)  (progn
	    (setq dLR_Ges_HT dLR_Ges_HT_St)

	    (if (= (Connect.get CastaData rechtesEnde) 1)  (progn
		; (if (< winkel 90.0) (setq dLR_Ges_HT (- (+ dlr_AT (* v_HT cosW)))))
		(if (> winkel 90.0) (setq dLR_Ges_HT (- (+ dlr_AT (* v_HT cosW)))))
	    ))
       ))

       (setq dV_Ges_HT   (+ (/ (* 0.5 h_HT) sinW) (/ dLR_Ges_HT tanW)))
   ))
   (if (= StegRechts_UnterFlansch  1) (progn
;       (if (< winkel 90.0) (print "StegRechts_UnterFlansch   < winkel 90.0"))
;       (if (> winkel 90.0) (print  "StegRechts_UnterFlansch   > winkel 90.0"))
       (print dlr_AT)
       (print v_HT)
       (if (< winkel 90.0) 
          (setq
          	 dlr_AT         (- dlr_AT)
          	 dLR_Ges_HT     (- dlr_AT (* v_HT cosW))
		 dv_Lchb_AT     (- (/ (+ (* 0.5 h_HT) v_HT) sinW)  (/ dlr_AT tanW))
          )
          (setq
          	 dlr_AT        (- dlr_AT)
          	 dLR_Ges_HT    (- (+ dlr_AT (* v_HT cosW)))
		 dv_Lchb_AT    (+ (/ (+ (* 0.5 h_HT) v_HT) sinW)  (/ dlr_AT tanW))
          )
       )
       (if (= (Connect.get CastaData amHtStegRechts) 1)  (progn
	    (if (= (Connect.get CastaData rechtesEnde) 1)  (progn
		; (if (< winkel 90.0) (setq dLR_Ges_HT (- (+ dlr_AT (* v_HT cosW)))))
		(if (> winkel 90.0) (setq dLR_Ges_HT (- (+ dlr_AT (* v_HT cosW)))))
	    ))
       ))


       (setq dV_Ges_HT   (+ (/ (- dLR_Ges_HT) tanW) (/ (* 0.5 h_HT) sinW)))
   ))
   ; -------------------------------------------------------------------------------


   (Anbauteil.set ABtl_Lochb_HT 
  		(delta_v     dV_Ges_HT)
  		(delta_lr (- dLR_Ges_HT))
   )
;   (setq dv_Lchb_AT dV_Ges_HT)
   (Anbauteil.set ABtl_Lochb_AT 
  		(delta_v  dv_Lchb_AT)
  		(delta_lr  0.0)
   )

   ; -------------------------------------------------------------------------------
   ; Schrauben - seitlicher Ausgleich (Schrauben-Achsverschiebung)
   (setq S_AchsVersch 0.0
   	 SeitRicht    0
   )
   (print "seitlicher Ausgleich (Schrauben-Achsverschiebung) ....................")
   (setq S_AchsVersch 0.0)
   (if (= (Connect.get CastaData amHtFlansch) 1) (progn
  	(setq 	lr_HT	(Traeger.get HTrg delta_LR))
        (if (= (Connect.get CastaData sAtr-vHtr) 0) 
        	(setq dv_AT   (Traeger.get Tr_ID delta_lr))
        	(setq dv_AT   (Traeger.get Tr_ID delta_V))
        )
  	(print lr_HT) (print dv_AT)
  	(if (= (Connect.get CastaData sAtr-sHtr) -1) (setq S_AchsVersch    (- (+ lr_HT dv_AT))))
  	(if (= (Connect.get CastaData sAtr-sHtr)  1) (setq S_AchsVersch    (- (- lr_HT dv_AT))))

  	(if (= (Connect.get CastaData vAtr-sHtr) -1) (setq S_AchsVersch    (- (+ lr_HT dv_AT))))
  	(if (= (Connect.get CastaData vAtr-sHtr)  1) (setq S_AchsVersch    (- (- lr_HT dv_AT))))
   ))
   (if (= (Connect.get CastaData amHtSteg) 1) (progn
  	(setq 	v_HT	(Traeger.get HTrg delta_V))
        (if (= (Connect.get CastaData sAtr-sHtr) 0) 
        	(setq dv_AT   (Traeger.get Tr_ID delta_lr))
        	(setq dv_AT   (Traeger.get Tr_ID delta_V))
        )

	(setq S_AchsVersch    (- (+ v_HT dv_AT)))
  	(if (= (Connect.get CastaData vAtr-vHtr) -1) (setq S_AchsVersch    (- (+ v_HT dv_AT))))
  	(if (= (Connect.get CastaData vAtr-vHtr)  1) (setq S_AchsVersch    (- (- v_HT dv_AT))))


  	(if (= (Connect.get CastaData sAtr-vHtr) -1) (setq S_AchsVersch    (- (+ v_HT dv_AT))))
  	(if (= (Connect.get CastaData sAtr-vHtr)  1) (setq S_AchsVersch    (- (- v_HT dv_AT))))
   ))

   (Anbauteil.set ABtl_Lochb_HT 
  		(delta_sx  S_AchsVersch)
;  		(delta_lr  50)
		(seitricht SeitRicht)
   )
   (Lochbild.set knblLochbild (dOK 0))

   (if (= 1 2) (progn
   	; Testbereich ...
   	(Anbauteil.set ABtl_Lochb_HT    (master 1))
   	(Anbauteil.set ABtl_Lochb_AT    (master 0))
	(Lochbild.set knblLochbild
			      (LB_Art 2)
			      (w   20)
	)
   ))

  
)
; ---------------------------------------------------------------------
; Blechverschiebung berechnen
; ---------------------------------------------------------------------
(defun calcBlech_DOK ()
    (print "Berechne OK-Blech zur Verschiebung lngs des H-Trgers")
    
    (Blech.set knotenBlech 
    		(x1 0) (y1 0)
    		(x4 0) (y4 0)
    )
    (setq VAbst_SysP 0.0)

    (if (= (Connect.get CastaData amHtFlansch) 1) (progn
  	(setq 	Winkel	(connect.get CastaData AFl_VWinkel)
  		h_HT	(Traeger.get HTrg h)
  		v_HT	(Traeger.get HTrg delta_V)
  		b_Bl    (Blech.get   knotenBlech bp)
  	)
  	; Unterscheidung Oberflansch / Unterflansch
;	(setq VAbst_SysP (* 0.5 h_HT))
;    	(if (= (Connect.get CastaData amhtoberflansch) 1) (progn
;    	    (setq VAbst_SysP (+ VAbst_SysP v_HT))
;    	))
  	; Unterscheidung Oberflansch / Unterflansch
	(setq VAbst_SysP (+ (* 0.5 h_HT) (* 0.5 b_Bl) v_HT))
    ))
    (if (= (Connect.get CastaData amHtSteg) 1) (progn
  	(setq Winkel (connect.get CastaData AFl_HWinkel))
	(setq VAbst_SysP 0.0)
    ))


    (setq hp (Blech.get knotenBlech hp))
    (setq dok_SysP (* 0.5 hp))
    (print dok_SysP)
    (Blech.set knotenBlech (dOK 0.0))

   (setq ABtl_Blechb_HT (Traeger.get HTrg  ABTeil knotenBlech))
   (setq abtlBlWnkl (Anbauteil.get ABtl_Blechb_HT Winkel))
   (print abtlBlWnkl)
   (Anbauteil.set ABtl_Blechb_HT (Winkel 90.0))

   (print Winkel)
   (if (/= Winkel 90.0) (progn
       (setq tanW (tan (/ (* PI Winkel) 180.0)))
       (if (/= tanW 0.0) (progn
           (setq dOK_Bl (- (/ VAbst_SysP tanW)))
       ))
   ))
       
   (Connect.ShowAttributes CastaData)
;   (Blech.set knotenBlech (dOK dOK_Bl))
;   (Blech.set knotenBlech (dOK  0))

)

(defun calc_DXSKopf_Steganschluss ()
;   (setq ABtl_Blechb_HT (Traeger.get HTrg ABTeil knotenBlech))
   (setq delta_LR_Blch (Blech.get knotenBlech delta_LR))

   (setq dv_HT 		(Traeger.get HTrg  delta_v))
   (setq dv_AT 		(Traeger.get Tr_ID delta_v))
   (setq d_Flach	(Traeger.get Tr_ID t))
   (setq dp_KnBlech	(Blech.get knotenBlech dp)) 

   (setq vOrdinate 0)	;; sicherheitshalber setzen
   (if (= (Connect.get CastaData vatr-vhtr)  1) (setq vOrdinate (- (- dv_HT dv_AT))))
   (if (= (Connect.get CastaData vatr-vhtr) -1) (setq vOrdinate (- (+ dv_HT dv_AT))))

   (setq vDiff (- vOrdinate delta_LR_Blch))

   (setq dxS (* 0.5 d_Flach))
   (if (> vDiff 0)    (setq dxS  (+ (* 0.5 d_Flach) dp_KnBlech)))
   (Lochbild.set knblLochbild   (dxSKopf	dxS))
   
   
)
(defun calc_DXSKopf_Flanschanschluss ()
   (setq delta_LR_Blch (Blech.get knotenBlech delta_LR))

   (setq dlr_HT 	(Traeger.get HTrg  delta_lr))
   (setq dv_AT 		(Traeger.get Tr_ID delta_v))
   (setq d_Flach	(Traeger.get Tr_ID t))
   (setq dp_KnBlech	(Blech.get knotenBlech dp)) 

   (setq hOrdinate 0)
   (if (= (Connect.get CastaData vatr-shtr)  1) (setq hOrdinate (- (- dlr_HT dv_AT))))
   (if (= (Connect.get CastaData vatr-shtr) -1) (setq hOrdinate (- (+ dlr_HT dv_AT))))

   (setq hDiff (- hOrdinate delta_LR_Blch))

   (setq dxS (* 0.5 d_Flach))
   (if (> hDiff 0)    (setq dxS  (+ (* 0.5 d_Flach) dp_KnBlech)))
   (Lochbild.set knblLochbild   (dxSKopf	dxS))

)
