(defun init-windverband ()
  (print "*clear*")
  (print "********************************************************************")
  (print "in init-connection - stz_Windverb_1");

  (print STD)  
; (Connect.showAttributes CastaData)
  (setq LB_DEBUG 0)
	
  (setq knblLochbild (Lochbild.create))
  (setq knotenBlech (Blech.create))
	(Connect.storeAnschlObjs CastaData knblLochbild knotenBlech)  
   
  
		
	(if (= STD 0)
		(progn
			(createKnotenBlech knotenBlech l_schr rand_abst)	
		)
		(progn
			; berechnet und setzt den e0-Wert des Lochbildes
			(calcAndSetE0_Var2 knblLochbild parallel_abstand_stz)
			
			; erzeugt das Knotenblech
			(manualKnotenBlechCreation knblLochbild)
		)
	)
	
	
	
	(if (= 1 1)	(progn
	; Krzt das Anschlussende des AT
	; ---------------------------------------------
		(kuerzeWinkelProfil parallel_abstand_stz)
  ))
	
	(if (= 1 1)	(progn
	; Positioniert den Verbandsstab
	; ---------------------------------------------
  (if (= (Connect.get CastaData linkesEnde) 1)
  	(progn
  		(if (= (Connect.get CastaData anschl_anderesende) 0)
  			(positioniereVerband)
  		)
  	)
  )
  (if (= (Connect.get CastaData rechtesEnde) 1)
  	(progn
  		(if (= (Connect.get CastaData anschl_anderesende) 0)
  			(positioniereVerband)
  		)
  	)
  )
  ))
	
	(if (= 1 1)	(progn
  (if (= STD 0)
		(createLochbild knotenBlech knblLochbild rand_abst parallel_abstand_stz)
		(createLochbild_Var2 knblLochbild knotenBlech parallel_abstand_stz)
	)
	))
	
	(if (= 1 1)	(progn
		(positioniereKnotenblech)
		(createATLochbild knblLochbild)
	))
	
	
)




; ====================================================================== 
(defun kuerzeWinkelProfil (p_abst_stz)
	(print "--------------------------------------------------------------------------------")
	(print "KUERZE PROFIL")
  ; Winkelprofil krzen ...
  ; korrekten Wert noch aus Sttzenprofil und Winkel berechnen
  (setq kuerzLng     0
        h_Ht     (Traeger.get HTrg h)
        s_Ht     (Traeger.get HTrg s)
        deltaV   (Traeger.get HTrg delta_V)
        deltaLR  (Traeger.get HTrg delta_LR)
  )
  (setq b_Trg    		(Traeger.get Tr_ID b)			
        h_Trg    		(Traeger.get Tr_ID h)			
        rwnkl		 		(Traeger.get Tr_ID r_winkel)
        deltaV_at		(Traeger.get Tr_ID delta_v)
        deltaLR_at	(Traeger.get Tr_ID delta_lr)
  )
  
  (if (= (connect.get CastaData amHtOberFlansch) 1) (progn
      (setq kuerzLng (- (* 0.5 h_Ht) deltaV))
  ))
  (if (= (connect.get CastaData amHtUnterFlansch) 1) (progn
      (setq kuerzLng (+ (* 0.5 h_Ht) deltaV))
  ))

  (if (= (connect.get CastaData amHtStegLinks) 1) (progn
      (setq kuerzLng (- (* 0.5 s_Ht) deltaLR))
  ))
  (if (= (connect.get CastaData amHtStegRechts) 1) (progn
      (setq kuerzLng (+ (* 0.5 s_Ht) deltaLR))
  ))

	
  (setq AFl_Winkel (connect.get CastaData at_laengswinkel))
  (print AFl_Winkel)
  (setq AFl_Winkel (- AFl_Winkel 90.0))
	(print AFl_Winkel)
  
  (setq sinAWnkl (sin (/ (* PI AFl_Winkel) 180.0))
  			cosAWnkl (cos (/ (* PI AFl_Winkel) 180.0))
  			tanAWnkl (tan (/ (* PI AFl_Winkel) 180.0))
  )
  (print tanAWnkl)
  
  
  (setq A_Winkel (connect.get CastaData at_laengswinkel))
	
	(print A_Winkel)
	(setq tanAW (tan (/ (* PI A_Winkel) 180.0))
				sinAW	(sin (/ (* PI A_Winkel) 180.0))
	)
	
	
	(setq delta 0)
	
	(if (= (Connect.get CastaData amHtUnterFlansch) 1)
		(progn
			(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta deltaLR_at))
			(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta (- deltaLR_at)))
			(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta deltaV_at))
			(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta (- deltaV_at)))
		)
	)
	(if (= (Connect.get CastaData amHtOberFlansch) 1)
		(progn
			(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta (- deltaLR_at)))
			(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta deltaLR_at))
			(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta deltaV_at))
			(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta (- deltaV_at)))	
		)
	)
		
	(if (= 1 1)
		(progn
	(if (= (Connect.get CastaData amHtFlansch) 1)
		(progn
			(if (= (Connect.get CastaData vatr-shtr)  1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta deltaLR_at))
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta (- deltaLR_at)))
				)
			)
			(if (= (Connect.get CastaData vatr-shtr) -1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta deltaLR_at))
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta (- deltaLR_at)))
				)
			)
			(if (= (Connect.get CastaData satr-shtr)  1)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta deltaV_at))
					(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta (- deltaV_at)))	
				)
			)
			(if (= (Connect.get CastaData satr-shtr) -1)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta deltaV_at))
					(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta (- deltaV_at)))	
				)
			)
		)
	)
))
	(if (= (Connect.get CastaData amHtSteg) 1)
		(progn
			(if (= (Connect.get CastaData vatr-vhtr)  1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta deltaLR_at))
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta (- deltaLR_at)))
				)
			)
			(if (= (Connect.get CastaData vatr-vhtr) -1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta deltaLR_at))
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta (- deltaLR_at)))
				)
			)
			(if (= (Connect.get CastaData satr-vhtr)  1)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta deltaV_at))
					(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta (- deltaV_at)))	
				)
			)
			(if (= (Connect.get CastaData satr-vhtr) -1)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta deltaV_at))
					(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta (- deltaV_at)))	
				)
			)
		)
	)
	
	
	
	(print delta)
	
	; --------------------------------------------------------------------------------------
	
	; 2. ANSCHLUSS
	; --------------------------------------------------------------------------------------
	(if (= 1 2)	(progn
	(if (> (Connect.get CastaData anschl_anderesEnde) 0)
		(progn
			(setq h_trg_halb (* 0.5 h_Trg)) ; TODO: je nach Rotation h oder b verwenden
			(setq b_trg_halb (* 0.5 b_Trg))
			
			(if (= (Connect.get CastaData amHtSteg) 1)
				(progn
					(if (= (Connect.get CastaData vatr-vhtr)  1)
						(progn
							(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta (- delta b_trg_halb)))
							(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta (+ delta b_trg_halb)))
						)
					)
					(if (= (Connect.get CastaData vatr-vhtr) -1)
						(progn
							(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta (- delta b_trg_halb)))
							(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta (+ delta b_trg_halb)))
						)
					)
					(if (= (Connect.get CastaData satr-vhtr)  1)
						(progn
							(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta (+ delta h_trg_halb)))
							(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta (- delta h_trg_halb)))
						)
					)
					(if (= (Connect.get CastaData satr-vhtr) -1)
						(progn
							(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta (+ delta h_trg_halb)))
							(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta (- delta h_trg_halb)))
						)
					)
				)
			)
			
			(if (= (Connect.get CastaData amHtFlansch) 1)
				(progn
					(if (= (Connect.get CastaData vatr-shtr)  1)
						(progn
							(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta (- delta b_trg_halb)))
							(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta (+ delta b_trg_halb)))
						)
					)
					(if (= (Connect.get CastaData vatr-shtr) -1)
						(progn
							(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta (- delta b_trg_halb)))
							(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta (+ delta b_trg_halb)))
						)
					)
					(if (= (Connect.get CastaData satr-shtr)  1)
						(progn
							(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta (+ delta h_trg_halb)))
							(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta (- delta h_trg_halb)))
						)
					)
					(if (= (Connect.get CastaData satr-shtr) -1)
						(progn
							(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta (+ delta h_trg_halb)))
							(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta (- delta h_trg_halb)))
						)
					)
				)
			)
			
		)
	)
	))
	
	; --------------------------------------------------------------------------------------
	(print delta)
	
	(setq anteil_delta (/ delta tanAW))
  (print anteil_delta)
	
  (setq abstand_Stz p_abst_stz)
  (print abstand_stz)
	
  (if (= cosAWnkl 0.0) (setq cosAWnkl 1.0))
  
  (setq anteil_Stz (/ kuerzLng cosAWnkl))
  (print anteil_stz)
	
	(if (= (Connect.get CastaData amHtFlansch) 1)
		(progn
  		(if (= (Connect.get CastaData amHtOberflansch) 1)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr)  1)
						(progn
							(if (= (Connect.get CastaData vatr-vhtr)  1)	(setq anteil_Verb 0.0))
							(if (= (Connect.get CastaData vatr-vhtr) -1)	(setq anteil_Verb (* h_Trg tanAWnkl)))
						)
					)
					(if (= (Connect.get CastaData vatr-lhtr) -1)
						(progn
							(if (= (Connect.get CastaData vatr-vhtr)  1)	(setq anteil_Verb 0.0))
							(if (= (Connect.get CastaData vatr-vhtr) -1)	(setq anteil_Verb (- (* h_Trg tanAWnkl))))
						)
					)
					(if (= (Connect.get CastaData satr-lhtr)  1)
						(progn
							(if (= (Connect.get CastaData satr-vhtr)  1)	(setq anteil_Verb (- (* b_Trg tanAWnkl))))
							(if (= (Connect.get CastaData satr-vhtr) -1)	(setq anteil_Verb 0.0))
							(if (= (Connect.get CastaData satr-vhtr)  0)
								(progn
									(if (= (Connect.get CastaData vatr-shtr)  1)	(setq anteil_Verb (- (* b_Trg tanAWnkl))))
									(if (= (Connect.get CastaData vatr-shtr) -1)	(setq anteil_Verb 0.0))
								)
							)
						)
					)
					(if (= (Connect.get CastaData satr-lhtr) -1)
						(progn
							(if (= (Connect.get CastaData satr-vhtr)  1)	(setq anteil_Verb (* b_Trg tanAWnkl)))
							(if (= (Connect.get CastaData satr-vhtr) -1)	(setq anteil_Verb 0.0))
							(if (= (Connect.get CastaData satr-vhtr)  0)
								(progn
									(if (= (Connect.get CastaData vatr-shtr)  1)	(setq anteil_Verb (* b_Trg tanAWnkl)))
									(if (= (Connect.get CastaData vatr-shtr) -1)	(setq anteil_Verb 0.0))
								)
							)
						)
					)
				)
			)
			(if (= (Connect.get CastaData amHtUnterflansch) 1)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr)  1)
						(progn
							(if (= (Connect.get CastaData vatr-vhtr)  1)	(setq anteil_Verb (* h_Trg tanAWnkl)))
							(if (= (Connect.get CastaData vatr-vhtr) -1)	(setq anteil_Verb 0.0))
						)
					)
					(if (= (Connect.get CastaData vatr-lhtr) -1)
						(progn
							(if (= (Connect.get CastaData vatr-vhtr)  1)	(setq anteil_Verb (- (* h_Trg tanAWnkl))))
							(if (= (Connect.get CastaData vatr-vhtr) -1)	(setq anteil_Verb 0.0))
						)
					)
					(if (= (Connect.get CastaData satr-lhtr)  1)
						(progn
							(if (= (Connect.get CastaData satr-vhtr)  1)	(setq anteil_Verb 0.0))
							(if (= (Connect.get CastaData satr-vhtr) -1)	(setq anteil_Verb (- (* b_Trg tanAWnkl))))
							(if (= (Connect.get CastaData satr-vhtr)  0)	
								(if (= (Connect.get CastaData vatr-shtr)  1)	(setq anteil_Verb 0.0))
								(if (= (Connect.get CastaData vatr-shtr) -1)	(setq anteil_Verb (- (* b_Trg tanAWnkl))))
							)
						)
					)
					(if (= (Connect.get CastaData satr-lhtr) -1)
						(progn
							(if (= (Connect.get CastaData satr-vhtr)  1)	(setq anteil_Verb 0.0))
							(if (= (Connect.get CastaData satr-vhtr) -1)	(setq anteil_Verb (* b_Trg tanAWnkl)))
							(if (= (Connect.get CastaData satr-vhtr)  0)	
								(if (= (Connect.get CastaData vatr-shtr)  1)	(setq anteil_Verb 0.0))
								(if (= (Connect.get CastaData vatr-shtr) -1)	(setq anteil_Verb (* b_Trg tanAWnkl)))
							)
						)
					)
				)
			)
  	)
  )
  (if (= (Connect.get CastaData amHtSteg) 1)
		(progn
			(if (= (Connect.get CastaData amHtStegLinks)  1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)
						(progn
							(if (= (Connect.get CastaData satr-shtr)  1)	(setq anteil_Verb (- (* b_Trg tanAWnkl))))
							(if (= (Connect.get CastaData satr-shtr) -1)	(setq anteil_Verb 0.0))
						)
					)
					(if (= (Connect.get CastaData satr-lhtr) -1)
						(progn
							(if (= (Connect.get CastaData satr-shtr)  1)	(setq anteil_Verb (* b_Trg tanAWnkl)))
							(if (= (Connect.get CastaData satr-shtr) -1)	(setq anteil_Verb 0.0))
						)
					)
					(if (= (Connect.get CastaData vatr-lhtr) -1)
						(progn
							(if (= (Connect.get CastaData vatr-shtr)  1)	(setq anteil_Verb 0.0))
							(if (= (Connect.get CastaData vatr-shtr) -1)	(setq anteil_Verb (- (* h_Trg tanAWnkl))))
						)
					)
					(if (= (Connect.get CastaData vatr-lhtr)  1)
						(progn
							(if (= (Connect.get CastaData vatr-shtr)  1)	(setq anteil_Verb 0.0))
							(if (= (Connect.get CastaData vatr-shtr) -1)	(setq anteil_Verb (* h_Trg tanAWnkl)))
						)
					)
				)
			)
			(if (= (Connect.get CastaData amHtStegRechts) 1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)
						(progn
							(if (= (Connect.get CastaData satr-shtr)  1)	(setq anteil_Verb 0.0))
							(if (= (Connect.get CastaData satr-shtr) -1)	(setq anteil_Verb (- (* b_Trg tanAWnkl))))
						)
					)
					(if (= (Connect.get CastaData satr-lhtr) -1)
						(progn
							(if (= (Connect.get CastaData satr-shtr)  1)	(setq anteil_Verb 0.0))
							(if (= (Connect.get CastaData satr-shtr) -1)	(setq anteil_Verb (* b_Trg tanAWnkl)))
						)
					)
					(if (= (Connect.get CastaData vatr-lhtr) -1)
						(progn
							(if (= (Connect.get CastaData vatr-shtr)  1)	(setq anteil_Verb (- (* h_Trg tanAWnkl))))
							(if (= (Connect.get CastaData vatr-shtr) -1)	(setq anteil_Verb 0.0))
						)
					)
					(if (= (Connect.get CastaData vatr-lhtr)  1)
						(progn
							(if (= (Connect.get CastaData vatr-shtr)  1)	(setq anteil_Verb (* h_Trg tanAWnkl)))
							(if (= (Connect.get CastaData vatr-shtr) -1)	(setq anteil_Verb 0.0))
						)
					)
				)
			)
		)
	)
  
	(print anteil_Verb)
  (print AFl_Winkel)
	
	(setq deltaLNeu abstand_Stz)
	(setq deltaLNeu (+ deltaLNeu anteil_Stz))
	(setq deltaLNeu (+ deltaLNeu anteil_delta))
	(setq deltaLNeu (+ deltaLNeu anteil_Verb ))
	
  ;(if (< AFl_Winkel 0.0) 
  	;(setq deltaLNeu (+ deltaLNeu anteil_Verb ))
  ;)
  
  (print deltaLNeu)
  
	
	;Krzen
  (if (= (connect.get CastaData LinkesEnde) 1) (progn
      (setq TrE_Links (Traeger.get Tr_ID links))
      (TrEnde.set TrE_Links (delta_L 0))
      (TrEnde.pTrim TrE_Links deltaLNeu)
  ))
  (if (= (connect.get CastaData RechtesEnde) 1) (progn
      (setq TrE_Rechts (Traeger.get Tr_ID rechts))
      (TrEnde.set TrE_Rechts (delta_L 0))			; erst einmal zurcksetzen
      (TrEnde.pTrim TrE_Rechts deltaLNeu)			; dann krzen
  ))

	(print "<-----------------------------------------------------------")
)





; ****************************************************************************************
; Verschiebt den Trger passend zum Knotenblech
; ****************************************************************************************
(defun positioniereVerband ()
	(print "--------------------------------------------------------------------------------")		
	(print "POSITIONIERE VERBAND")
	
	
  (setq RWinkel (Traeger.get Tr_ID R_Winkel)
        dp      (Blech.get   knotenBlech  dp)
        b_Trg    (Traeger.get Tr_ID b)			; ist die Frage, wie der Stab liegt
        h_Trg    (Traeger.get Tr_ID h)			; ob Breite oder Hhe entscheidend sind.
  )
  (print RWinkel)
  (print dp)
  (setq delta_v_at 	(Traeger.get Tr_ID delta_v)
  			delta_lr_at	(Traeger.get Tr_ID delta_lr)
  )
	
  ;Positionieren
  	
	(if (= (Connect.get CastaData amHtSteg) 1)
		(progn
			(if (= (Connect.get CastaData satr-shtr) -1)
				(Traeger.set Tr_ID 	(delta_V 	(- delta_v_at 	(* 0.5 dp))) 
														;(delta_LR (- delta_lr_at 	(* 0.5 b_Trg)))
				)
			)
			(if (= (Connect.get CastaData satr-shtr) 1)
				(Traeger.set Tr_ID 	(delta_V 	(- delta_v_at 	(* 0.5 dp))) 
														;(delta_LR (- delta_lr_at 	(* 0.5 b_Trg)))
				)
			)
			(if (= (Connect.get CastaData vatr-shtr) 1)
				(Traeger.set Tr_ID 	;(delta_V 	(+ delta_v_at 	(* 0.5 h_Trg))) 
														(delta_LR (+ delta_lr_at 	(* 0.5 dp)))
				)
			)
			(if (= (Connect.get CastaData vatr-shtr) -1)
				(Traeger.set Tr_ID 	;(delta_V 	(+ delta_v_at 	(* 0.5 h_Trg))) 
														(delta_LR (+ delta_lr_at 	(* 0.5 dp)))
				)
			)
			
		)
	)
	
	(if (= (Connect.get CastaData amHtFlansch) 1)
		(progn
			(if (= (Connect.get CastaData satr-vhtr) -1)
				(Traeger.set Tr_ID 	(delta_V 	(- delta_v_at 	(* 0.5 dp))) 
														;(delta_LR (- delta_lr_at 	(* 0.5 b_Trg)))
				)
			)
			(if (= (Connect.get CastaData satr-vhtr) 1)
				(Traeger.set Tr_ID 	(delta_V 	(- delta_v_at 	(* 0.5 dp))) 
														;(delta_LR (- delta_lr_at 	(* 0.5 b_Trg)))
				)
			)
			(if (= (Connect.get CastaData satr-vhtr)  0)
				(progn
					(if (= (Connect.get CastaData vatr-shtr)  1)	
						(Traeger.set Tr_ID 	(delta_V 	(- delta_v_at 	(* 0.5 dp))))
					)
					(if (= (Connect.get CastaData vatr-shtr) -1)	
						(Traeger.set Tr_ID 	(delta_V 	(- delta_v_at 	(* 0.5 dp))))
					)
				)
			)
			(if (= (Connect.get CastaData satr-shtr) 1)
				(Traeger.set Tr_ID 	;(delta_V 	(+ delta_v_at 	(* 0.5 h_Trg))) 
														(delta_LR (+ delta_lr_at 	(* 0.5 dp)))
				)
			)
			(if (= (Connect.get CastaData satr-shtr) -1)
				(Traeger.set Tr_ID 	;(delta_V 	(+ delta_v_at 	(* 0.5 h_Trg))) 
														(delta_LR (+ delta_lr_at 	(* 0.5 dp)))
				)
			)
		)
	)
	
	
	
	
	
	(print "--------------------------------------------------------------------------------")		
)

; ----------------------------------------------------------------------
; ---------------------------------------------------------------------- 
(defun createKnotenBlech (Blech_ID l_schr rand_abst)
	(print "------------------------------------------------------------")
	(print "ERZEUGE KNOTENBLECH **xx**")
	  
  ; Default-Werte des Blechs
  (Blech.set Blech_ID 	(dp 10)
      									(hp 200)
      									(bp 120)
  )
	
	; allg. Daten
	(setq b_Trg   		(Traeger.get Tr_ID b)
				h_Trg	  		(Traeger.get Tr_ID h)
				RWinkel 		(Traeger.get Tr_ID R_Winkel)
				delta_v_at 	(Traeger.get Tr_ID delta_v)
				delta_lr_at (Traeger.get Tr_ID delta_lr)
	)
	
	(setq delta_v_ht 	(Traeger.get Htrg delta_v)
				delta_lr_ht	(Traeger.get Htrg delta_lr)
	)
	
	(setq anschl_winkel (Connect.get CastaData at_laengswinkel))
	(print anschl_winkel)
	
	; wenn schrg, wird afl_winkel negativ ausgegeben ?????
	;(setq anschl_winkel (- anschl_winkel))
	
	(setq sinAW (sin (/ (* PI anschl_winkel) 180.0)))
	(print sinAW)
	
	
	(print RWinkel)
	(setq dp_knbl (Blech.get Blech_ID dp))
	(setq half_kbl (* 0.5 dp_knbl))
	(print half_kbl)
	  
  ; lokale Verschiebung des Windverbandes bestimmen
  (setq wv_versatz 0)
  
  ; +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  ; 1. Anschluss (es liegt noch kein Anschluss am Windverbandstab vor)
  ; +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  (calcFirstConnection)
	
	; +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  ; 2. Anschluss
  ; +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  ; Wenn der Traeger bereits angeschlossen ist, mu das zweite Blech versetzt werden 
	(if (> (Connect.get CastaData anschl_anderesEnde) 0)
		(progn
			(calcSecondConnection)
		)
	)
	
		
	(if (= (connect.get CastaData amHtOberFlansch) 1) (progn
      (traeger.addabtl Htrg Blech_ID 0.0 0.0 _knotenblech_of_)  ;
  ))
  (if (= (connect.get CastaData amHtUnterFlansch) 1) (progn
      (traeger.addabtl Htrg Blech_ID 0.0 0.0 _knotenblech_uf_)  ;
  ))
  (if (= (connect.get CastaData amHtStegLinks) 1) (progn
      (traeger.addabtl Htrg Blech_ID 0.0 0.0 _knotenblech_steg_li_)  ;    
  ))
  (if (= (connect.get CastaData amHtStegRechts) 1) (progn
      (traeger.addabtl Htrg Blech_ID 0.0 0.0 _knotenblech_steg_re_)  ;    
  ))
  
  
  
	(setq xPosStz      (Connect.get CastaData xPos_HT))
  ;(setq WnklAnschlFl (Connect.get CastaData afl_vwinkel))
  
  ; Verschiebung des HT delta_v / delta_lr
	(calcXPosDelta_HT)
	
	; Verschiebung des AT delta_v / delta_lr
	(calcXPosDelta_AT)
	
	(print "---------------------------------------------- Fehlersuche -3-")
	(print xPosStz)
	(print xPos_HT)

	(if (= (Connect.get CastaData anschl_anderesEnde) 10) (progn
	    (print "Anschluss am anderen Ende vorhanden ...")
	    (positioniereKnotenblech) ; => xPos_delta

	    (print "Anschluss am anderen Ende vorhanden ... xPos_delta berechnet")
	    ; (print xPos_delta)
	    (setq xPosStz (+ xPos_HT xPos_delta))
	    
	))

	
	; Positionieren des Knotenbleches beim ersten Anschluss
	(if (= (Connect.get CastaData anschl_anderesEnde) 0)
		(progn
			(positioniereKnotenblech) ; => xPos_delta
			
			(if (= (Connect.get CastaData amHtFlansch) 1)
				(progn
					(if (= (Connect.get CastaData amHtOberflansch) 1)
						(progn
							(if (= (Connect.get castaData satr-lhtr)  1)	(setq xPosStz (+ xPosStz xPos_delta)))
							(if (= (Connect.get castaData satr-lhtr) -1)	(setq xPosStz (- xPosStz xPos_delta)))
							(if (= (Connect.get castaData vatr-lhtr)  1)	(setq xPosStz (- xPosStz xPos_delta)))
							(if (= (Connect.get castaData vatr-lhtr) -1)	(setq xPosStz (+ xPosStz xPos_delta)))
						)
					)
					(if (= (Connect.get CastaData amHtUnterflansch) 1)
						(progn
							(if (= (Connect.get castaData satr-lhtr)  1)	(setq xPosStz (+ xPosStz xPos_delta)))
							(if (= (Connect.get castaData satr-lhtr) -1)	(setq xPosStz (- xPosStz xPos_delta)))
							(if (= (Connect.get castaData vatr-lhtr)  1)	(setq xPosStz (- xPosStz xPos_delta)))
							(if (= (Connect.get castaData vatr-lhtr) -1)	(setq xPosStz (+ xPosStz xPos_delta)))
						)
					)
				)
			)
			
			(if (= (Connect.get CastaData amHtSteg) 1)
				(progn
					(if (= (Connect.get CastaData amHtStegLinks)  1)
						(progn
							(if (= (Connect.get CastaData satr-lhtr)  1)	(setq xPosStz (+ xPosStz xPos_delta)))
							(if (= (Connect.get CastaData satr-lhtr) -1)	(setq xPosStz (- xPosStz xPos_delta)))
							(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq xPosStz (+ xPosStz xPos_delta)))
							(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq xPosStz (- xPosStz xPos_delta)))
						)
					)
					(if (= (Connect.get CastaData amHtStegRechts) 1)
						(progn
							(if (= (Connect.get CastaData satr-lhtr)  1)	(setq xPosStz (+ xPosStz xPos_delta)))
							(if (= (Connect.get CastaData satr-lhtr) -1)	(setq xPosStz (- xPosStz xPos_delta)))
							(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq xPosStz (+ xPosStz xPos_delta)))
							(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq xPosStz (- xPosStz xPos_delta)))
						)
					)
				)
			)
			
			
			(print xPosStz)
		)
	)
	
	
	; xPos setzen
	(setq AbtlKnBlech (traeger.get Htrg ABTeil Blech_ID))
  	(Anbauteil.set  AbtlKnBlech (xpos xPosStz))

	; d_schr berechnen	
	(if (= (Connect.get CastaData amHtFlansch) 1)
		(progn
			(if (= (Connect.get CastaData satr-shtr)  1) (setq d_schr (+ (* 0.5 h_Trg) rand_abst)))
			(if (= (Connect.get CastaData satr-shtr) -1) (setq d_schr (+ (* 0.5 h_Trg) rand_abst)))
			(if (= (Connect.get CastaData vatr-shtr)  1) (setq d_schr (+ (* 0.5 b_Trg) rand_abst)))
			(if (= (Connect.get CastaData vatr-shtr) -1) (setq d_schr (+ (* 0.5 b_Trg) rand_abst)))
		)
	)
	(if (= (Connect.get CastaData amHtSteg) 1)
		(progn
			(if (= (Connect.get CastaData satr-shtr)  1) (setq d_schr (+ (* 0.5 b_Trg) rand_abst)))
			(if (= (Connect.get CastaData satr-shtr) -1) (setq d_schr (+ (* 0.5 b_Trg) rand_abst)))
			(if (= (Connect.get CastaData vatr-shtr)  1) (setq d_schr (+ (* 0.5 h_Trg) rand_abst)))
			(if (= (Connect.get CastaData vatr-shtr) -1) (setq d_schr (+ (* 0.5 h_Trg) rand_abst)))
		)
	)
	;(if (= (Connect.get CastaData satr-lhtr) -1) (setq d_schr (+ (* 0.5 h_Trg) rand_abst)))
	;(if (= (Connect.get CastaData satr-lhtr)  1) (setq d_schr (+ (* 0.5 h_Trg) rand_abst)))
	
	 ; Objekt.Methode          Variable     d_Schr   l_Schrb  SchrAchsWnkl
	(Blech.knotenblechschraeg Blech_ID   d_schr      l_schr       anschl_winkel)
	(print knotenblech_soll_versatz)
	(Blech.set Blech_ID (delta_lr knotenblech_soll_versatz))
  												
 
	(print "ENDE KNOTENBLECH")
	(print "------------------------------------------------------------")
)

; ----------------------------------------------------------------------------------------
; Erzeugt das Lochbild
; ----------------------------------------------------------------------------------------
(defun createLochbild (BlechID Lchb_ID rand_abst p_abstand_stz)
	(print "------------------------------------------------------------")
	(print "ERZEUGE LOCHBILD")
	
	
	(Lochbild.set Lchb_ID 	(lb_art 	2)
															(S_Bez 		"M16")
															(Guete		"4.6")
															(w				"0 0")
															(e				"0 0 0 0 0 0")
															(Anz_S		3)
															(dok 			0)
															;(dxSKopf	20)
															;(klemml		20)
															;(dvhtrg		50)
	)
	
	; allg. Daten
	(setq dp_Blech 	(Blech.get BlechID dp)
				d_sch 		(Blech.get BlechID knbl_dschr)
				l_sch			(Blech.get BlechID knbl_lschr)
	)
	
	(setq t_Trg 			(Traeger.get Tr_ID t)
				s_Trg				(Traeger.get Tr_ID s)
				b_Trg				(Traeger.get Tr_ID b)
				h_Trg				(Traeger.get Tr_ID h)
				r_winkel		(Traeger.get Tr_ID r_winkel)
				delta_lr_at	(Traeger.get Tr_ID delta_lr)
	)
	(setq delta_v_ht	(Traeger.get Htrg delta_v)
				delta_lr_ht	(Traeger.get Htrg delta_lr)
	)
	
	; Klemmlnge
	(setq dicke_trg t_Trg)
	(setq klemml (+ dicke_trg dp_Blech))
	
	; dxSKopf Anschluss am Steg
	(if (= (Connect.get CastaData amHtSteg) 1)
		(progn
			(if (= (Connect.get CastaData satr-vhtr)  1) (setq dxS (* 0.5 dp_blech)))
			(if (= (Connect.get CastaData satr-vhtr) -1) (setq dxS (+ (* 0.5 dp_blech) t_Trg)))
			(if (= (Connect.get CastaData vatr-vhtr)  1) (setq dxS (+ (* 0.5 dp_blech) t_Trg)))
			(if (= (Connect.get CastaData vatr-vhtr) -1) (setq dxS (* 0.5 dp_blech)))
			;(if (= (Connect.get CastaData satr-lhtr) -1) (setq dxS (+ (* 0.5 dp_blech) t_Trg)))
			;(if (= (Connect.get CastaData satr-lhtr)  1) (setq dxS (* 0.5 dp_blech)))				
		)
	)
			
	; dxSKopf Anschluss am Flansch
	(if (= (Connect.get CastaData amHtFlansch) 1)
		(progn
			(if (= (Connect.get CastaData satr-shtr)  1) (setq dxS (* 0.5 dp_blech)))
			(if (= (Connect.get CastaData satr-shtr) -1) (setq dxS (+ (* 0.5 dp_blech) t_Trg)))
			(if (= (Connect.get CastaData vatr-shtr)  1) (setq dxS (+ (* 0.5 dp_blech) t_Trg)))
			(if (= (Connect.get CastaData vatr-shtr) -1) (setq dxS (* 0.5 dp_blech)))		
		)
	)
	
	(print dxS)
	
	
		
	; Kontaktlnge zwichen AT und Knotenblech
	(setq afl_wnkl (Connect.get CastaData at_laengswinkel))
	
	(print afl_wnkl)
	(setq afl_wnkl (- afl_wnkl 90.0))
	(print afl_wnkl)
	(setq tan_afl	(tan (/ (* PI afl_wnkl) 180.0)))
	(print tan_afl)
	(if (< tan_afl 0) (setq tan_afl (- tan_afl)))
	(print tan_afl)
	(setq diff_1 (* rand_abst tan_afl))
	(print diff_1)
	(setq diff_2 (- p_abstand_stz diff_1))
	(print diff_2)
	(setq kontakt_laenge (- l_sch diff_2))
	(print kontakt_laenge)
	; e-Werte
	
	(setq e_abst (* 0.25 kontakt_laenge)) ; erstmal gleichmig verteilen 
	(print e_abst)
	
	(if (= (Connect.get CastaData amHtFlansch) 1)
		(progn
			(if (= (Connect.get CastaData satr-shtr)  1) (setq anteil_verbindung (* (* 0.5 h_Trg) tan_afl)))
			(if (= (Connect.get CastaData satr-shtr) -1) (setq anteil_verbindung (* (* 0.5 h_Trg) tan_afl)))
			(if (= (Connect.get CastaData vatr-shtr)  1) (setq anteil_verbindung (* (* 0.5 b_Trg) tan_afl)))
			(if (= (Connect.get CastaData vatr-shtr) -1) (setq anteil_verbindung (* (* 0.5 b_Trg) tan_afl)))
		)
	)
	(if (= (Connect.get CastaData amHtSteg) 1)
		(progn
			(if (= (Connect.get CastaData satr-shtr)  1) (setq anteil_verbindung (* (* 0.5 b_Trg) tan_afl)))
			(if (= (Connect.get CastaData satr-shtr) -1) (setq anteil_verbindung (* (* 0.5 b_Trg) tan_afl)))
			(if (= (Connect.get CastaData vatr-shtr)  1) (setq anteil_verbindung (* (* 0.5 h_Trg) tan_afl)))
			(if (= (Connect.get CastaData vatr-shtr) -1) (setq anteil_verbindung (* (* 0.5 h_Trg) tan_afl)))
		)
	)
	(print anteil_verbindung)
	
	(setq e0 (+ anteil_verbindung p_abstand_stz e_abst))
	(print e0)
	
	(if (= (Connect.get CastaData amHtSteg) 1)
		(setq schrauben_versatz knotenblech_soll_versatz)
	)
	(print dxS)
	; Werte setzen
	(Lochbild.set Lchb_ID 	(klemml		klemml)
				(dxSKopf	dxS)
				(e0				e0)
				(e1 			(* 0.5 kontakt_laenge))
				;(e2				e_abst)
				;(delta_lr knotenblech_soll_versatz)
	)
	
	; Lochbild dem HT hinzufgen
	(setq AbtlKnoBl	(Traeger.get Htrg AbTeil BlechID))
	(Traeger.addabtl Htrg Lchb_ID 0.0 0.0 _knblLochbild_ AbtlKnoBl)
	
	(setq AbtlKnoBlLchb    (Traeger.get Htrg AbTeil Lchb_ID))
	(Anbauteil.set AbtlKnoBlLchb 	(Master 1)
			(delta_sx knotenblech_soll_versatz)
	)
	
	(setq xPos   (Anbauteil.get AbtlKnoBlLchb xPos))
	(setq xPosBl (Anbauteil.get AbtlKnoBl     xPos))
	(print "............................................................................ ===> xPos")
	(print xPos)
	(print xPosBl)
	
	
	(print "ENDE LOCHBILD")
	(print "------------------------------------------------------------")
)



; ----------------------------------------------------------------------------------------
; Erzeugt das Lochbild im AT
; ----------------------------------------------------------------------------------------
(defun createATLochbild (Lchb_ID)
	(print ">-----------------------------------------------------------")
	(print "ERZEUGE LOCHBILD AM AT")
	
		
	; Lochbildanbauteil whlen
	; ----------------------------------------------
	(if (= (Connect.get CastaData amHtFlansch) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(progn
					(if (= (Connect.get CastaData satr-shtr)  1)	(setq WINDVERBAND_LB _windvblchb_steg_links_)	)
					(if (= (Connect.get CastaData satr-shtr) -1)	(setq WINDVERBAND_LB _windvblchb_steg_links_)	)
					(if (= (Connect.get CastaData vatr-shtr)  1)	(setq WINDVERBAND_LB _windvblchb_flansch_links_)	)
					(if (= (Connect.get CastaData vatr-shtr) -1)	(setq WINDVERBAND_LB _windvblchb_flansch_links_)	)
				)
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(progn
					(if (= (Connect.get CastaData satr-shtr)  1)	(setq WINDVERBAND_LB _windvblchb_steg_rechts_)	)
					(if (= (Connect.get CastaData satr-shtr) -1)	(setq WINDVERBAND_LB _windvblchb_steg_rechts_)	)
					(if (= (Connect.get CastaData vatr-shtr)  1)	(setq WINDVERBAND_LB _windvblchb_flansch_rechts_)	)
					(if (= (Connect.get CastaData vatr-shtr) -1)	(setq WINDVERBAND_LB _windvblchb_flansch_rechts_)	)
				)
			)
		)
	)
	(if (= (Connect.get CastaData amHtSteg) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(progn
					(if (= (Connect.get CastaData vatr-shtr)  1)	(setq WINDVERBAND_LB _windvblchb_steg_links_)	)
					(if (= (Connect.get CastaData vatr-shtr) -1)	(setq WINDVERBAND_LB _windvblchb_steg_links_)	)
					(if (= (Connect.get CastaData satr-shtr)  1)	(setq WINDVERBAND_LB _windvblchb_flansch_links_)	)
					(if (= (Connect.get CastaData satr-shtr) -1)	(setq WINDVERBAND_LB _windvblchb_flansch_links_)	)
				)
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(progn
					(if (= (Connect.get CastaData vatr-shtr)  1)	(setq WINDVERBAND_LB _windvblchb_steg_rechts_)	)
					(if (= (Connect.get CastaData vatr-shtr) -1)	(setq WINDVERBAND_LB _windvblchb_steg_rechts_)	)
					(if (= (Connect.get CastaData satr-shtr)  1)	(setq WINDVERBAND_LB _windvblchb_flansch_rechts_)	)
					(if (= (Connect.get CastaData satr-shtr) -1)	(setq WINDVERBAND_LB _windvblchb_flansch_rechts_)	)
				)
			)
		)
	)
	
	

	; delta-Werte der Anbauteile
	; ++++++++++++++++++++++++++++++++++++++++++++++
	(setq h_at	(Traeger.get Tr_ID h)
				b_at	(Traeger.get Tr_ID b)
	)
	(print h_at)
	(print b_at)
	
	(setq delta_v_abtl_at 0)
	(setq delta_lr_abtl_at 0)
	
	; Positionierung Anbauteil (delta_lr Anbauteil) (halbe AT Breite/Hhe)
	; ----------------------------------------------
	(if (= 1 1)	(progn
	; ----------------------------------------------
	(print "Positionierung des Anbauteils (delta_lr)")
	(if (= (Connect.get CastaData amHtFlansch) 1)
		(progn
			(if (= (Connect.get CastaData satr-shtr)  1)	(setq delta_lr_abtl_at L_Abst_H));(* 0.5 h_at)))
			(if (= (Connect.get CastaData satr-shtr) -1)	(setq delta_lr_abtl_at L_Abst_H));(* 0.5 h_at)))
			(if (= (Connect.get CastaData vatr-shtr)  1)	(setq delta_lr_abtl_at L_Abst_B));(* 0.5 b_at)))
			(if (= (Connect.get CastaData vatr-shtr) -1)	(setq delta_lr_abtl_at L_Abst_B));(* 0.5 b_at)))
			
			
			(if (= (Connect.get CastaData linkesEnde) 1)
				(progn
					(if (= (Connect.get CastaData satr-shtr)  1)	(setq delta_lr_abtl_at delta_lr_abtl_at))
					(if (= (Connect.get CastaData satr-shtr) -1)	(setq delta_lr_abtl_at delta_lr_abtl_at))
					(if (= (Connect.get CastaData vatr-shtr)  1)	(setq delta_lr_abtl_at (- delta_lr_abtl_at)))
					(if (= (Connect.get CastaData vatr-shtr) -1)	(setq delta_lr_abtl_at (- delta_lr_abtl_at)))
				)
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(progn
					(if (= (Connect.get CastaData satr-shtr)  1)	(setq delta_lr_abtl_at (- delta_lr_abtl_at)))
					(if (= (Connect.get CastaData satr-shtr) -1)	(setq delta_lr_abtl_at (- delta_lr_abtl_at)))
					(if (= (Connect.get CastaData vatr-shtr)  1)	(setq delta_lr_abtl_at delta_lr_abtl_at))
					(if (= (Connect.get CastaData vatr-shtr) -1)	(setq delta_lr_abtl_at delta_lr_abtl_at))
				)
			)
		)
	)

        (print ".............. 1")
	(print delta_v_abtl_at)
	(print delta_lr_abtl_at)

	(if (= (Connect.get CastaData amHtSteg) 1)
		(progn
			(if (= (Connect.get CastaData vatr-shtr)  1)	(setq delta_lr_abtl_at L_Abst_H));(* 0.5 h_at)))
			(if (= (Connect.get CastaData vatr-shtr) -1)	(setq delta_lr_abtl_at L_Abst_H));(* 0.5 h_at)))
			(if (= (Connect.get CastaData satr-shtr)  1)	(setq delta_lr_abtl_at L_Abst_B));(* 0.5 b_at)))
			(if (= (Connect.get CastaData satr-shtr) -1)	(setq delta_lr_abtl_at L_Abst_B));(* 0.5 b_at)))
			
			
			(if (= (Connect.get CastaData linkesEnde) 1)
				(progn
					(if (= (Connect.get CastaData vatr-shtr)  1)	(setq delta_lr_abtl_at delta_lr_abtl_at))
					(if (= (Connect.get CastaData vatr-shtr) -1)	(setq delta_lr_abtl_at delta_lr_abtl_at))
					(if (= (Connect.get CastaData satr-shtr)  1)	(setq delta_lr_abtl_at (- delta_lr_abtl_at)))
					(if (= (Connect.get CastaData satr-shtr) -1)	(setq delta_lr_abtl_at (- delta_lr_abtl_at)))
				)
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(progn
					(if (= (Connect.get CastaData vatr-shtr)  1)	(setq delta_lr_abtl_at (- delta_lr_abtl_at)))
					(if (= (Connect.get CastaData vatr-shtr) -1)	(setq delta_lr_abtl_at (- delta_lr_abtl_at)))
					(if (= (Connect.get CastaData satr-shtr)  1)	(setq delta_lr_abtl_at delta_lr_abtl_at))
					(if (= (Connect.get CastaData satr-shtr) -1)	(setq delta_lr_abtl_at delta_lr_abtl_at))
				)
			)
		)
	)
	(print delta_lr_abtl_at)
	; ----------------------------------------------
	))	
	; ----------------------------------------------
	
	
        (print ".............. 2")
	(print delta_v_abtl_at)
	(print delta_lr_abtl_at)
	
	
	
	
	; Einfluss durch Verschiebung des HT
	; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	
	; Anteil delta_v HT
	; ----------------------------------------------
	(if (= 1 1)	(progn
	; ----------------------------------------------
		(if (= (Connect.get CastaData amHtFlansch) 1)
			(progn
				(setq delta_v_ht	(Traeger.get Htrg delta_v))
				(print delta_v_ht)
				
				(setq at_winkel (Connect.get CastaData at_laengswinkel))
				(print at_winkel)
				
				(setq cosW (cos (/ (* PI at_winkel) 180.0)))
				(setq sinW (sin (/ (* PI at_winkel) 180.0)))
				(print cosW)
				(print sinW)
				
				;(if (/= cosW 0.0)
				;	(setq anteil_delta_v_abtl_ht (/ (* 1.0 delta_v_ht) cosW))
				;)
				(if (/= sinW 0.0)
					(setq anteil_delta_v_abtl_ht (/ (* 1.0 delta_v_ht) sinW))
				)
				(print anteil_delta_v_abtl_ht)
				
				(if (> at_winkel 90.0)
					(setq delta_v_abtl_at (- anteil_delta_v_abtl_ht))
					(setq delta_v_abtl_at anteil_delta_v_abtl_ht)
				)
				(print delta_v_abtl_at)
				
				(if (> at_winkel 90.0)
					(if (= (Connect.get CastaData amHtOberflansch) 1) 	(setq delta_v_abtl_at (+ delta_v_abtl_at)))
					(if (= (Connect.get CastaData amHtOberflansch) 1) 	(setq delta_v_abtl_at (- delta_v_abtl_at)))
				)
				
				(if (> at_winkel 90.0)
					(if (= (Connect.get CastaData amHtUnterflansch) 1) 	(setq delta_v_abtl_at (- delta_v_abtl_at)))
					(if (= (Connect.get CastaData amHtUnterflansch) 1) 	(setq delta_v_abtl_at (+ delta_v_abtl_at)))
				)
				(print delta_v_abtl_at)
				
				
			)
		)
	; ----------------------------------------------
	))
	; ----------------------------------------------
	
        (print ".............. 3")
	(print delta_v_abtl_at)
	(print delta_lr_abtl_at)
	
	; Anteil delta_lr HT
	; ----------------------------------------------
	(if (= 1 1)	(progn
	; ----------------------------------------------
		(if (= (Connect.get CastaData amHtSteg) 1)
			(progn
				(setq delta_lr_ht	(Traeger.get Htrg delta_lr))
				(print delta_lr_ht)
				(setq at_winkel (Connect.get CastaData at_laengswinkel))
				(print at_winkel)
				(setq cosW (cos (/ (* PI at_winkel) 180.0)))
				(print cosW)
				
				(if (/= cosW 0.0)
					(setq anteil_delta_lr_abtl_ht (/ (* 1.0 delta_lr_ht) cosW))
				)
				(print anteil_delta_lr_abtl_ht)
				
				(if (> at_winkel 90.0)
					(setq delta_v_abtl_at (- anteil_delta_lr_abtl_ht))
					(setq delta_v_abtl_at anteil_delta_lr_abtl_ht)
				)
				(print delta_v_abtl_at)
				
				(if (= (Connect.get CastaData amHtStegLinks) 1) 	(setq delta_v_abtl_at (- delta_v_abtl_at))	)
				(if (= (Connect.get CastaData amHtStegRechts) 1) 	(setq delta_v_abtl_at delta_v_abtl_at)	)
				(print delta_v_abtl_at)
			)
		)
	(print delta_v_abtl_at)
	; ----------------------------------------------
	))
	; ----------------------------------------------
	

        (print ".............. 4")
	(print delta_v_abtl_at)
	(print delta_lr_abtl_at)

	
	
	; Einfluss durch Verschiebung des AT
	; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	
	
	; Anteil Verschiebung delta_v AT
	; ----------------------------------------------
	(if (= 1 1)	(progn
	; ----------------------------------------------
	(print "delta Verschiebungen AT")
	(print "--------------------------------------------------------------------------------")
	(setq delta_v_at (Traeger.get Tr_ID delta_v)
				delta_lr_at (Traeger.get Tr_ID delta_lr)
	)
	(print delta_v_at)
	(print delta_lr_at)
	(print delta_lr_abtl_at)
	
	(print at_winkel)
	(setq tanW (tan (/ (* PI at_winkel) 180.0)))
	(print tanW)
	
	(if (= (Connect.get CastaData amHtFlansch) 1)
		(progn
			(if (= (Connect.get CastaData rechtesEnde) 1)	(setq anteil_delta_v_at (/ (+ (* 1.0 delta_v_at) delta_lr_abtl_at) tanW)))
			(if (= (Connect.get CastaData linkesEnde) 1)	(setq anteil_delta_v_at (/ (- (* 1.0 delta_v_at) delta_lr_abtl_at) tanW)))
		)
	)
	(if (= (Connect.get CastaData amHtSteg) 1)
		(progn
			(if (= (Connect.get CastaData rechtesEnde) 1)	(setq anteil_delta_v_at (/ (+ (* 1.0 delta_v_at) delta_lr_abtl_at) tanW)))
			(if (= (Connect.get CastaData linkesEnde) 1)	(setq anteil_delta_v_at (/ (- (* 1.0 delta_v_at) delta_lr_abtl_at) tanW)))
		)
	)

        (print ".............. 5")
	(print delta_v_abtl_at)
	(print delta_lr_abtl_at)

	
	(if (= (Connect.get CastaData amHtFlansch) 1)
		(progn
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_v_abtl_at (- delta_v_abtl_at anteil_delta_v_at))	)
					(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_v_abtl_at (+ delta_v_abtl_at anteil_delta_v_at))	)
				)
			)
			
			(if (= (Connect.get CastaData linkesEnde) 1)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_v_abtl_at (+ delta_v_abtl_at anteil_delta_v_at))	)
					(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_v_abtl_at (- delta_v_abtl_at anteil_delta_v_at))	)
				)
			)
		)
	)
	
        (print ".............. 6")
	(print delta_v_abtl_at)
	(print delta_lr_abtl_at)
	
	(if (= (Connect.get CastaData amHtSteg) 1)
		(progn
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_v_abtl_at (- delta_v_abtl_at anteil_delta_v_at))	)
					(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_v_abtl_at (+ delta_v_abtl_at anteil_delta_v_at))	)
				)
			)
			
			(if (= (Connect.get CastaData linkesEnde) 1)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_v_abtl_at (+ delta_v_abtl_at anteil_delta_v_at))	)
					(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_v_abtl_at (- delta_v_abtl_at anteil_delta_v_at))	)
				)
			)
		)
	)
	(print delta_v_abtl_at)
	; ----------------------------------------------
	))	
	; ----------------------------------------------
	
        (print ".............. 7")
	(print delta_v_abtl_at)
	(print delta_lr_abtl_at)
	
	; Anteil Verschiebung delta_lr AT
	; ----------------------------------------------
	(if (= 1 1) (progn
	; ----------------------------------------------
	(print "--------------------------------------------------------------------------------")
	
	
	
	(if (= (Connect.get CastaData linkesEnde) 1)	
		(setq anteil_delta_lr_abtl_at (/ (- (* 1.0 delta_lr_at) delta_lr_abtl_at) tanW))
	)
	(if (= (Connect.get CastaData rechtesEnde) 1)	
		(setq anteil_delta_lr_abtl_at (/ (+ (* 1.0 delta_lr_at) delta_lr_abtl_at) tanW))
	)
	(print anteil_delta_lr_abtl_at)

	
	(if (= (Connect.get CastaData amHtFlansch) 1)
		(progn
			; delta_lr AT
			(print "ANTEIL delta_lr AT")
			(if (= (Connect.get CastaData linkesEnde) 1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)
						(progn
							(if (= (Connect.get CastaData vatr-shtr)  1)	(setq delta_v_abtl_at (+ delta_v_abtl_at anteil_delta_lr_abtl_at))	)
							(if (= (Connect.get CastaData vatr-shtr) -1)	(setq delta_v_abtl_at (+ delta_v_abtl_at anteil_delta_lr_abtl_at))	)
						)
					)
					(if (= (Connect.get CastaData satr-lhtr) -1)
						(progn
							(if (= (Connect.get CastaData vatr-shtr)  1)	(setq delta_v_abtl_at (- delta_v_abtl_at anteil_delta_lr_abtl_at))	)
							(if (= (Connect.get CastaData vatr-shtr) -1)	(setq delta_v_abtl_at (- delta_v_abtl_at anteil_delta_lr_abtl_at))	)
						)
					)
				)
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)
						(progn
							(if (= (Connect.get CastaData vatr-shtr)  1)	(setq delta_v_abtl_at (+ delta_v_abtl_at anteil_delta_lr_abtl_at))	)
							(if (= (Connect.get CastaData vatr-shtr) -1)	(setq delta_v_abtl_at (+ delta_v_abtl_at anteil_delta_lr_abtl_at))	)
						)
					)
					(if (= (Connect.get CastaData satr-lhtr) -1)
						(progn
							(if (= (Connect.get CastaData vatr-shtr)  1)	(setq delta_v_abtl_at (- delta_v_abtl_at anteil_delta_lr_abtl_at))	)
							(if (= (Connect.get CastaData vatr-shtr) -1)	(setq delta_v_abtl_at (- delta_v_abtl_at anteil_delta_lr_abtl_at))	)
						)
					)
				)
			)
			(print delta_v_abtl_at)
		)
	)
	(if (= (Connect.get CastaData amHtSteg) 1)
		(progn
			; delta_lr AT
			(print "ANTEIL delta_lr AT")
			(if (= (Connect.get CastaData linkesEnde) 1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)
						(progn
							(if (= (Connect.get CastaData vatr-vhtr)  1)	(setq delta_v_abtl_at (+ delta_v_abtl_at anteil_delta_lr_abtl_at))	)
							(if (= (Connect.get CastaData vatr-vhtr) -1)	(setq delta_v_abtl_at (+ delta_v_abtl_at anteil_delta_lr_abtl_at))	)
						)
					)
					(if (= (Connect.get CastaData satr-lhtr) -1)
						(progn
							(if (= (Connect.get CastaData vatr-vhtr)  1)	(setq delta_v_abtl_at (- delta_v_abtl_at anteil_delta_lr_abtl_at))	)
							(if (= (Connect.get CastaData vatr-vhtr) -1)	(setq delta_v_abtl_at (- delta_v_abtl_at anteil_delta_lr_abtl_at))	)
						)
					)
				)
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)
						(progn
							(if (= (Connect.get CastaData vatr-vhtr)  1)	(setq delta_v_abtl_at (+ delta_v_abtl_at anteil_delta_lr_abtl_at))	)
							(if (= (Connect.get CastaData vatr-vhtr) -1)	(setq delta_v_abtl_at (+ delta_v_abtl_at anteil_delta_lr_abtl_at))	)
						)
					)
					(if (= (Connect.get CastaData satr-lhtr) -1)
						(progn
							(if (= (Connect.get CastaData vatr-vhtr)  1)	(setq delta_v_abtl_at (- delta_v_abtl_at anteil_delta_lr_abtl_at))	)
							(if (= (Connect.get CastaData vatr-vhtr) -1)	(setq delta_v_abtl_at (- delta_v_abtl_at anteil_delta_lr_abtl_at))	)
						)
					)
				)
			)
			(print delta_v_abtl_at)
		)
	)
	; ----------------------------------------------
	))
	; ----------------------------------------------
	
	
        (print ".............. 8")
	(print delta_v_abtl_at)
	(print delta_lr_abtl_at)

	
	
	
	; Anbauteil hinzufgen
	; ----------------------------------------------
	(Traeger.addabtl Tr_ID Lchb_ID 0.0 0.0 WINDVERBAND_LB)
		
	(setq AbtlKnoBlLchbAT    (Traeger.get Tr_ID AbTeil Lchb_ID))
	
	(print delta_v_abtl_at)
	(print delta_lr_abtl_at)
	
;	(setq delta_lr_abtl_at 0)
;	(setq delta_v_abtl_at  0)
;        (setq LB_DEBUG 0)

	
	(Anbauteil.set AbtlKnoBlLchbAT 	(Master 0)
;					(delta_lr	delta_lr_abtl_at)
;					(delta_v	delta_v_abtl_at)
	)
	

	(setq AbtlKnoBlLchbHT    (Traeger.get HTrg AbTeil Lchb_ID))
	(setq xPos (Anbauteil.get AbtlKnoBlLchbHT xPos))
	(print xPos)
	
	
	; TEST
	; +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	(if (= LB_DEBUG 1)
		(progn
			(setq LB_DUMMY (Lochbild.create))
			(Lochbild.copy LB_DUMMY Lchb_ID)
			(Traeger.addabtl Tr_ID LB_DUMMY 0.0 0.0 WINDVERBAND_LB)
			(setq AbtlKnoBlLchbAT_DUMMY    (Traeger.get Tr_ID AbTeil LB_DUMMY))
			(Anbauteil.set AbtlKnoBlLchbAT_DUMMY 	(Master 1)
					(delta_lr	delta_lr_abtl_at)
					(delta_v 	delta_v_abtl_at)
			)
				
			(Connect.storeAnschlObjs CastaData LB_DUMMY)
		)
	)
	; +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	(print "<-----------------------------------------------------------")
)



; ----------------------------------------------------------------------------------------
; Berechnet die Position des Knotenbleches entlang des Stegs fr den 1. Anschluss
; ----------------------------------------------------------------------------------------
(defun calcFirstConnection ()
	(print "BERECHNE ERSTEN ANSCHLUSS")
	; Korrektur aus Verschiebung delta_lr bzw. delta_v des AT ANSCHLUSS AM STEG
  (print delta_v_at)
  (print delta_lr_at)
	(setq at_verschiebung 0)
	(if (= (Connect.get CastaData amHtSteg) 1)
		(progn
			(if (= (Connect.get CastaData satr-vhtr) -1) (setq at_verschiebung (- delta_lr_at)))
			(if (= (Connect.get CastaData satr-vhtr)  1) (setq at_verschiebung delta_lr_at))
			(if (= (Connect.get CastaData vatr-vhtr) -1) (setq at_verschiebung (- delta_v_at)))
			(if (= (Connect.get CastaData vatr-vhtr)  1) (setq at_verschiebung delta_v_at))
		)
	)
	(if (= (Connect.get CastaData amHtFlansch) 1)
		(progn
			(if (= (Connect.get CastaData satr-shtr)  1) (setq at_verschiebung delta_lr_at))
			(if (= (Connect.get CastaData satr-shtr) -1) (setq at_verschiebung (- delta_lr_at)))
			(if (= (Connect.get CastaData vatr-shtr)  1) (setq at_verschiebung delta_v_at))
			(if (= (Connect.get CastaData vatr-shtr) -1) (setq at_verschiebung (- delta_v_at)))
		)
	)
  
  (print at_verschiebung)
  
	; Knotenblech Verschiebung aus AT-Verschiebung
	(setq knotenblech_soll_versatz at_verschiebung)
	
	(setq schrauben_versatz knotenblech_soll_versatz)
	
	; Knotenblech Verschiebung aus HT-Verschiebung
	(if (= (Connect.get CastaData amHTFlansch) 1)
		(progn
			(setq knotenblech_soll_versatz (- knotenblech_soll_versatz delta_lr_ht))
		)
	)
	(if (= (Connect.get CastaData amHTSteg) 1)
		(progn
			(setq knotenblech_soll_versatz (- knotenblech_soll_versatz delta_v_ht))
		)
	)
	(print knotenblech_soll_versatz)
	(print "ENDE ERSTER ANSCHLUSS")
)



; ----------------------------------------------------------------------------------------
; Berechnet die Position des Knotenbleches entlang des Stegs fr den 2. Anschluss
; ----------------------------------------------------------------------------------------
(defun calcSecondConnection ()
	(print "BERECHNE ZWEITEN ANSCHLUSS")
	(print "TRGER IST BEREITS FIXIERT.")
	(print knotenblech_soll_versatz)
	(print half_kbl)
	; AM HT-STEG RECHTS

;;;;	AF nderung
;;;;	(setq merke_knbl_sollV  knotenblech_soll_versatz)

	
	(if (= (Connect.get CastaData amHtSteg) 1)
		(progn
			(if (= (Connect.get CastaData vatr-vhtr)  1) (setq knotenblech_soll_versatz (+ knotenblech_soll_versatz half_kbl)))
			(if (= (Connect.get CastaData vatr-vhtr) -1) (setq knotenblech_soll_versatz (- knotenblech_soll_versatz half_kbl)))
			(if (= (Connect.get CastaData satr-vhtr)  1) (setq knotenblech_soll_versatz (- knotenblech_soll_versatz half_kbl)))
			(if (= (Connect.get CastaData satr-vhtr) -1) (setq knotenblech_soll_versatz (+ knotenblech_soll_versatz half_kbl)))
		)
	)
	(if (= (Connect.get CastaData amHtFlansch) 1)
		(progn
			(if (= (Connect.get CastaData satr-shtr)  1) (setq knotenblech_soll_versatz (- knotenblech_soll_versatz half_kbl)))
			(if (= (Connect.get CastaData satr-shtr) -1) (setq knotenblech_soll_versatz (+ knotenblech_soll_versatz half_kbl)))
			(if (= (Connect.get CastaData vatr-shtr)  1) (setq knotenblech_soll_versatz (+ knotenblech_soll_versatz half_kbl)))
			(if (= (Connect.get CastaData vatr-shtr) -1) (setq knotenblech_soll_versatz (- knotenblech_soll_versatz half_kbl)))
		)
	)
	
;;;;	AF nderung
;;;;	(setq knotenblech_soll_versatz merke_knbl_sollV)
		
	(print knotenblech_soll_versatz)
	(print "ENDE ZWEITER ANSCHLUSS")
)



; ----------------------------------------------------------------------------------------
; Berechnet die Auswirkungen auf die XPos des Knotenbleches bei einer Verschiebung
; des HT in Richtung delta_v
; ----------------------------------------------------------------------------------------
(defun calcXPosDelta_HT ()
	(print "------------------------------------------------------------")
	(print "BERECHNE DELTA_HT AUSWIRKUNG")
	
	(setq Winkel (connect.get CastaData at_laengswinkel))
	
	(setq Winkel (- 90.0 Winkel))
	(setq tanW (tan (/ (* PI Winkel) 180.0)))
	
	(print Winkel)
	(print tanW)
	
	(print xPosStz)
	
	(if (= (Connect.get CastaData amHTFlansch) 1)
		(progn
			(setq deltaXPos (* delta_v_ht tanW))
			(print deltaXPos)
	
			(if (= (Connect.get CastaData amHtUnterflansch) 1)
				(setq xPosStz (+ xPosStz deltaXPos))
			)
			(if (= (Connect.get CastaData amHtOberflansch) 1)
				(setq xPosStz (- xPosStz deltaXPos))
			)
		)
	)
	(if (= (Connect.get CastaData amHTSteg) 1)
		(progn
			(setq knotenblech_final_versatz (- knotenblech_soll_versatz delta_lr_ht))
			(setq deltaXPos (* delta_lr_ht tanW))
			(print deltaXPos)
	
			(if (= (Connect.get CastaData amHtStegLinks) 1)
				(setq xPosStz (- xPosStz deltaXPos))
			)
			(if (= (Connect.get CastaData amHtStegRechts) 1)
				(setq xPosStz (+ xPosStz deltaXPos))
			)
		)
	)
	(print xPosStz)
	(print "--------------------------------------------------------ENDE")
)




(defun calcXPosDelta_AT ()
	(print "------------------------------------------------------------")
	(print "BERECHNE DELTA_AT AUSWIRKUNG")
	; xPos berechnen und setzen
	(print xPosStz)
	
	(setq	h_Trg (Traeger.get Tr_ID h)
		b_Trg (Traeger.get Tr_ID b)
		s_Trg (Traeger.get Tr_ID s)
	)
	
	(setq Winkel (connect.get CastaData at_laengswinkel))
	(setq sinAW (sin (/ (* PI Winkel) 180.0)))
	(print Winkel)
	
	(setq anteil_aus_delta_v (/ delta_v_at sinAW))
	(setq anteil_aus_delta_lr (/ delta_lr_at sinAW))
	(print anteil_aus_delta_v)
	(print anteil_aus_delta_lr)
	
	(if (= (Connect.get CastaData amHtSteg) 1)
		(progn
			(if (= (Connect.get CastaData vatr-vhtr)  1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq xPosStz (+ xPosStz anteil_aus_delta_lr)))
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq xPosStz (- xPosStz anteil_aus_delta_lr)))
				)
			)
			(if (= (Connect.get CastaData vatr-vhtr) -1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq xPosStz (+ xPosStz anteil_aus_delta_lr)))
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq xPosStz (- xPosStz anteil_aus_delta_lr)))
				)
			)
			(if (= (Connect.get CastaData satr-vhtr)  1)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq xPosStz (+ xPosStz anteil_aus_delta_v)))
					(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq xPosStz (- xPosStz anteil_aus_delta_v)))
				)
			)
			(if (= (Connect.get CastaData satr-vhtr) -1)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq xPosStz (+ xPosStz anteil_aus_delta_v)))
					(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq xPosStz (- xPosStz anteil_aus_delta_v)))
				)
			)
			
		)
	)
	
	(if (= (Connect.get CastaData amHtFlansch) 1)
		(progn
			(if (= (Connect.get CastaData satr-shtr)  1)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq xPosStz (+ xPosStz anteil_aus_delta_v)))
					(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq xPosStz (- xPosStz anteil_aus_delta_v)))
				)
			)
			(if (= (Connect.get CastaData satr-shtr) -1)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq xPosStz (+ xPosStz anteil_aus_delta_v)))
					(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq xPosStz (- xPosStz anteil_aus_delta_v)))
				)
			)
			(if (= (Connect.get CastaData vatr-shtr)  1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq xPosStz (+ xPosStz anteil_aus_delta_lr)))
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq xPosStz (- xPosStz anteil_aus_delta_lr)))
				)
			)
			(if (= (Connect.get CastaData vatr-shtr) -1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq xPosStz (+ xPosStz anteil_aus_delta_lr)))
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq xPosStz (- xPosStz anteil_aus_delta_lr)))
				)
			)
			
		)
	)
	
	(setq h_Trg_halb (* 0.5 h_Trg))
	
	
	
	(if (> (Connect.get CastaData anschl_anderesEnde) 0)
		(progn
			(setq	b_Trg (- b_Trg s_Trg)		;; AF - 062008
				h_Trg (- h_Trg s_Trg)
			)
			(if (= (Connect.get CastaData amHtSteg) 1)
				(progn
					(if (= (Connect.get CastaData vatr-vhtr)  1) (setq h_Trg_halb (* 0.5 b_Trg) ))
					(if (= (Connect.get CastaData vatr-vhtr) -1) (setq h_Trg_halb (* 0.5 b_Trg) ))
					(if (= (Connect.get CastaData satr-vhtr)  1) (setq h_Trg_halb (* 0.5 h_Trg) ))
					(if (= (Connect.get CastaData satr-vhtr) -1) (setq h_Trg_halb (* 0.5 h_Trg) ))
				)
			)
			(if (= (Connect.get CastaData amHtFlansch) 1)
				(progn
					(if (= (Connect.get CastaData vatr-vhtr)  1) (setq h_Trg_halb (* 0.5 h_Trg) ))
					(if (= (Connect.get CastaData vatr-vhtr) -1) (setq h_Trg_halb (* 0.5 h_Trg) ))
					(if (= (Connect.get CastaData satr-vhtr)  1) (setq h_Trg_halb (* 0.5 b_Trg) ))
					(if (= (Connect.get CastaData satr-vhtr) -1) (setq h_Trg_halb (* 0.5 b_Trg) ))
				)
			)
	
			(setq korr (/ h_Trg_halb sinAW))
			
			
			(if (= (Connect.get CastaData amHtSteg) 1)
				(progn
					(if (= (Connect.get CastaData vatr-vhtr)  1)
						(progn
							(if (= (Connect.get CastaData satr-lhtr)  1)	(setq xPosStz (+ xPosStz korr)))
							(if (= (Connect.get CastaData satr-lhtr) -1)	(setq xPosStz (- xPosStz korr)))
						)
					)
					(if (= (Connect.get CastaData vatr-vhtr) -1)
						(progn
							(if (= (Connect.get CastaData satr-lhtr)  1)	(setq xPosStz (+ xPosStz korr)))
							(if (= (Connect.get CastaData satr-lhtr) -1)	(setq xPosStz (- xPosStz korr)))
						)
					)
					(if (= (Connect.get CastaData satr-vhtr)  1)
						(progn
							(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq xPosStz (- xPosStz korr)))
							(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq xPosStz (+ xPosStz korr)))
						)
					)
					(if (= (Connect.get CastaData satr-vhtr) -1)
						(progn
							(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq xPosStz (- xPosStz korr)))
							(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq xPosStz (+ xPosStz korr)))
						)
					)
				)
			)
			
			(if (= (Connect.get CastaData amHtFlansch) 1)
				(progn
					(if (= (Connect.get CastaData satr-shtr)  1)
						(progn
							(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq xPosStz (- xPosStz korr)))
							(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq xPosStz (+ xPosStz korr)))
						)
					)
					(if (= (Connect.get CastaData satr-shtr) -1)
						(progn
							(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq xPosStz (- xPosStz korr)))
							(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq xPosStz (+ xPosStz korr)))
						)
					)
					(if (= (Connect.get CastaData vatr-shtr)  1)
						(progn
							(if (= (Connect.get CastaData satr-lhtr)  1)	(setq xPosStz (+ xPosStz korr)))
							(if (= (Connect.get CastaData satr-lhtr) -1)	(setq xPosStz (- xPosStz korr)))
						)
					)
					(if (= (Connect.get CastaData vatr-shtr) -1)
						(progn
							(if (= (Connect.get CastaData satr-lhtr)  1)	(setq xPosStz (+ xPosStz korr)))
							(if (= (Connect.get CastaData satr-lhtr) -1)	(setq xPosStz (- xPosStz korr)))
						)
					)
				)
			)
			
		)
	)
		
	
	(print xPosStz)
	(print "--------------------------------------------------------ENDE")
)








; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
; ----------------------------------------------------------------------------------------
; VARIANTE 2
; ----------------------------------------------------------------------------------------
; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++


; ----------------------------------------------------------------------------------------
; Erzeugt das Knotenblech fr Variante 2
; ----------------------------------------------------------------------------------------
(defun manualKnotenBlechCreation (Lchb_ID)
	(print ">-----------------------------------------------------------")
	(print "BERECHNE KNOTENBLECH VAR_2")
	(setq h_ht 				(Traeger.get Htrg h)
				delta_v_ht	(Traeger.get Htrg delta_v)
				delta_lr_ht	(Traeger.get Htrg delta_lr)
	)
	(setq h_ht_halb (* 0.5 h_ht))
	
	(setq	h_at		(Traeger.get Tr_ID h)
		b_at		(Traeger.get Tr_ID b)
		delta_v_at	(Traeger.get Tr_ID delta_v)
		delta_lr_at	(Traeger.get Tr_ID delta_lr)
	)
	
	(setq	at_winkel	(Connect.get CastaData at_laengswinkel)
		xPos_ht		(Connect.get CastaData xPos_ht)
	)
	(print xPos_ht)
	
	(setq lb_e0 (Lochbild.get Lchb_ID e0))
	
	(setq tanATW (tan (/ (* PI at_winkel) 180.0)))
	(setq sinATW (sin (/ (* PI at_winkel) 180.0)))
	
	;(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq bp_blech (* 1.67 h_at)))
	;(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq bp_blech (* 1.67 h_at)))
	;(if (= (Connect.get CastaData satr-lhtr)  1)	(setq bp_blech (* 1.67 b_at)))
	;(if (= (Connect.get CastaData satr-lhtr) -1)	(setq bp_blech (* 1.67 b_at)))
	
	(setq lb_rand_abst (* 1.3 (* 0.5 h_at))) ; TODO: Rotation AT evtl. noch beachten 
	(setq lb_stz_abst (* lb_e0 sinATW))
	(print lb_stz_abst)
	
	(setq bp_blech (+ lb_rand_abst lb_stz_abst))
	(setq bp_blech_rund (runde bp_blech auf 5.0))
	
	(setq hp_blech (* 1.2 bp_blech_rund))
	(setq hp_blech_rund (runde hp_blech auf 5.0))
	
	(setq help_1 (+ h_ht_halb bp_blech_rund))
	
	(setq help_2 (/ help_1 tanATW))
	
		
	; Blechecken
	(if (> at_winkel 90.0)
		(progn
			(setq y4_blech (* 0.5 bp_blech_rund))
			(setq x4_blech (- (/ y4_blech tanATW)))
			
			(setq x1_blech 0.0)
			(setq y1_blech 0.0)
		)
	)
	(if (< at_winkel 90.0)
		(progn
			(setq x4_blech 0.0)
			(setq y4_blech 0.0)
			
			(setq y1_blech (* 0.5 bp_blech_rund))
			(setq x1_blech (/ y1_blech tanATW))
		)
	)
	(if (= at_winkel 90.0)
		(progn
			(setq x4_blech 0.0)
			(setq y4_blech 0.0)
			(setq x1_blech 0.0)
			(setq y1_blech 0.0)
		)
	)
	
	(setq dok_blech (* 0.5 (- hp_blech_rund bp_blech_rund)))
	(if (> at_winkel 90.0)
		(setq dok_blech (- dok_blech))
	)
	(if (= at_winkel 90.0)
		(setq dok_blech 0.0)
	)
	
	; Default-Werte des Blechs
	(Blech.set knotenBlech 	(dp 	10)
      				(hp 	hp_blech_rund)
      				(bp 	bp_blech_rund)
      				(dok 	dok_blech)
      				(x1 	x1_blech)
      				(y1 	y1_blech)
      				(x4 	x4_blech)
      				(y4 	y4_blech)
	)
  
  
	(setq dp_knbl (Blech.get knotenBlech dp))
	(setq half_kbl (* 0.5 dp_knbl))
  ; +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  ; 1. Anschluss (es liegt noch kein Anschluss am Windverbandstab vor)
  ; +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	(calcFirstConnection)
	
	; +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  ; 2. Anschluss
  ; +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  ; Wenn der Traeger bereits angeschlossen ist, mu das zweite Blech versetzt werden 
	(if (> (Connect.get CastaData anschl_anderesEnde) 0)
		(progn
			(calcSecondConnection)
		)
	)
  
  
  
  ; xPos Knotenblech
  ; ----------------------------------------------
	;(if (> at_winkel 90.0) 
	;	(setq xPos_ht (+ xPos_ht (+ help_2 (* 0.5 hp_blech_rund))))
	;	(setq xPos_ht (+ xPos_ht (- help_2 (* 0.5 hp_blech_rund))))
	;)
	(print xPos_ht)
	

  
  (if (= (connect.get CastaData amHtOberFlansch) 1) (progn
      (traeger.addabtl Htrg knotenBlech xPos_ht 0.0 _knotenblech_of_)  ;
  ))
  (if (= (connect.get CastaData amHtUnterFlansch) 1) (progn
      (traeger.addabtl Htrg knotenBlech xPos_ht 0.0 _knotenblech_uf_)  ;
  ))
  (if (= (connect.get CastaData amHtStegLinks) 1) (progn
      (traeger.addabtl Htrg knotenBlech xPos_ht 0.0 _knotenblech_steg_li_)  ;    
  ))
  (if (= (connect.get CastaData amHtStegRechts) 1) (progn
      (traeger.addabtl Htrg knotenBlech xPos_ht 0.0 _knotenblech_steg_re_)  ;    
  ))
  
  
  
  ;(setq xPosStz      (Connect.get CastaData xPos_HT))
  ;(setq WnklAnschlFl (Connect.get CastaData afl_vwinkel))
  (setq xPosStz xPos_ht)
  
  ; Verschiebung des HT delta_v / delta_lr
	    (print "............................. delta_V - delta_lr bercksichtigen ...")
	    (print xPosStz)
	(calcXPosDelta_HT)
	    (print "............................. delta_V - delta_lr HT bercksichtigt")
	    (print xPosStz)
	
	; Verschiebung des AT delta_v / delta_lr
	(calcXPosDelta_AT)
	    (print "............................. delta_V - delta_lr AT bercksichtigt")
	    (print xPosStz)
	    ; (print xPos_delta)
	
	(if (= (Connect.get CastaData anschl_anderesEnde) 10) (progn
	    (print "............................. Anschluss am anderen Ende vorhanden ...")
	    (print xPosStz)
	    (positioniereKnotenblech) ; => xPos_delta

	    (print "Anschluss am anderen Ende vorhanden ... xPos_delta berechnet")
	    (print xPos_delta)
	    (setq xPosStz (+ xPos_HT xPos_delta))

	))
	
	; Positionieren des Knotenbleches beim ersten Anschluss
	(if (= (Connect.get CastaData anschl_anderesEnde) 0)
		(progn
			(positioniereKnotenblech) ; => xPos_delta

			(if (= (Connect.get CastaData amHtFlansch) 1)
				(progn
					(if (= (Connect.get CastaData amHtOberflansch) 1)
						(progn
							(if (= (Connect.get castaData satr-lhtr)  1)	(setq xPosStz (+ xPosStz xPos_delta)))
							(if (= (Connect.get castaData satr-lhtr) -1)	(setq xPosStz (- xPosStz xPos_delta)))
							(if (= (Connect.get castaData vatr-lhtr)  1)	(setq xPosStz (- xPosStz xPos_delta)))
							(if (= (Connect.get castaData vatr-lhtr) -1)	(setq xPosStz (+ xPosStz xPos_delta)))
						)
					)
					(if (= (Connect.get CastaData amHtUnterflansch) 1)
						(progn
							(if (= (Connect.get castaData satr-lhtr)  1)	(setq xPosStz (+ xPosStz xPos_delta)))
							(if (= (Connect.get castaData satr-lhtr) -1)	(setq xPosStz (- xPosStz xPos_delta)))
							(if (= (Connect.get castaData vatr-lhtr)  1)	(setq xPosStz (- xPosStz xPos_delta)))
							(if (= (Connect.get castaData vatr-lhtr) -1)	(setq xPosStz (+ xPosStz xPos_delta)))
						)
					)
				)
			)
			
			(if (= (Connect.get CastaData amHtSteg) 1)
				(progn
					(if (= (Connect.get CastaData amHtStegLinks)  1)
						(progn
							(if (= (Connect.get CastaData satr-lhtr)  1)	(setq xPosStz (+ xPosStz xPos_delta)))
							(if (= (Connect.get CastaData satr-lhtr) -1)	(setq xPosStz (- xPosStz xPos_delta)))
							(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq xPosStz (+ xPosStz xPos_delta)))
							(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq xPosStz (- xPosStz xPos_delta)))
						)
					)
					(if (= (Connect.get CastaData amHtStegRechts) 1)
						(progn
							(if (= (Connect.get CastaData satr-lhtr)  1)	(setq xPosStz (+ xPosStz xPos_delta)))
							(if (= (Connect.get CastaData satr-lhtr) -1)	(setq xPosStz (- xPosStz xPos_delta)))
							(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq xPosStz (+ xPosStz xPos_delta)))
							(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq xPosStz (- xPosStz xPos_delta)))
						)
					)
				)
			)
			
			
			(print xPosStz)
		)
	)
	
	(print "-------------------------- Endgltig xPos fr das Blech setzen ")
	(print xPosStz)
	; xPos setzen
	(setq AbtlKnBlech (traeger.get Htrg ABTeil knotenBlech))

	 ;   (setq xPosStz 2837.865425)


    (Anbauteil.set  AbtlKnBlech (xPos xPosStz))
  
    (Blech.knotenblechschraeg knotenBlech 0.0 0.0 at_winkel)
  
    (Blech.set knotenBlech (delta_lr knotenblech_soll_versatz))
  
    (print "<-----------------------------------------------------------")
)


(defun calcAndSetE0_Var2 (Lchb_ID parallel_abstand_stz)
	
	(setq h_at 	(Traeger.get Tr_ID h)
				b_at	(Traeger.get Tr_ID b)
	)
	
	(if (= (Connect.get CastaData amHtFlansch) 1)
		(progn
			(if (= (Connect.get CastaData vatr-shtr)  1)	(setq at_halb (* 0.5 b_at)))
			(if (= (Connect.get CastaData vatr-shtr) -1)	(setq at_halb (* 0.5 b_at)))
			(if (= (Connect.get CastaData satr-shtr)  1)	(setq at_halb (* 0.5 h_at)))
			(if (= (Connect.get CastaData satr-shtr) -1)	(setq at_halb (* 0.5 h_at)))
		)
	)
	(if (= (Connect.get CastaData amHtSteg) 1)
		(progn
			(if (= (Connect.get CastaData vatr-shtr)  1)	(setq at_halb (* 0.5 h_at)))
			(if (= (Connect.get CastaData vatr-shtr) -1)	(setq at_halb (* 0.5 h_at)))
			(if (= (Connect.get CastaData vatr-vhtr)  1)	(setq at_halb (* 0.5 b_at)))
			(if (= (Connect.get CastaData vatr-vhtr) -1)	(setq at_halb (* 0.5 b_at)))
		)
	)
	
	(setq at_winkel (Connect.get CastaData at_laengswinkel))
	(setq tanATW (tan (/ (* PI at_winkel) 180.0)))
	(setq sinATW (sin (/ (* PI at_winkel) 180.0)))
	(setq cosATW (cos (/ (* PI at_winkel) 180.0)))
	
	(if (/= sinATW 0.0)
		(setq e0_1 (/ parallel_abstand_stz sinATW))
		(setq e0_1 parallel_abstand_stz)
	)
	(print e0_1)
	
	(setq parallel_abstand_trgEnde_tmp (* e0_1 cosATW))
	(print parallel_abstand_trgEnde)
	(print parallel_abstand_trgEnde_tmp)
	(if (< parallel_abstand_trgEnde_tmp 0.0)	(setq parallel_abstand_trgEnde_tmp (* -1.0 parallel_abstand_trgEnde_tmp) ))
	(print parallel_abstand_trgEnde_tmp)
	
	(if (< parallel_abstand_trgEnde_tmp parallel_abstand_trgEnde)
		(setq e0_1 (/ parallel_abstand_trgEnde cosATW))
	)
	(print e0_1)
	
	(if (< e0_1 0.0)	(setq e0_1 (* -1.0 e0_1)))
	(print e0_1)
	
	(setq e0_2 (/ at_halb tanATW))
	(if (< e0_2 0.0)
		(setq e0_2 (- e0_2))
	)
	(print e0_2)
	
	(setq e0_3 at_halb)
	(print e0_3)
		
	(setq e0 (+ e0_1 e0_2 e0_3))
	(print e0)
	
	(Lochbild.set Lchb_ID (e0 e0))
)
; ----------------------------------------------------------------------------------------
; Erzeugt das Lochbild fr Knotenblech Variante 2
; ----------------------------------------------------------------------------------------
(defun createLochbild_Var2 (Lchb_ID Blech_ID p_abstand_stz)
	
	(Lochbild.set Lchb_ID 	(lb_art 	2)
													(S_Bez 		"M16")
													(Guete		"4.6")											
	)
	
	; allg. Daten
	(setq	dp_blech 	(Blech.get Blech_ID dp)
		bp_blech	(Blech.get Blech_ID bp)
		hp_blech 	(Blech.get Blech_ID hp)
	)
	
	(setq	t_at		(Traeger.get Tr_ID t)
		s_at		(Traeger.get Tr_ID s)
		b_at		(Traeger.get Tr_ID b)
		h_at		(Traeger.get Tr_ID h)
		delta_lr_at	(Traeger.get Tr_ID delta_lr)
	)
	(setq delta_v_ht	(Traeger.get Htrg delta_v)
				delta_lr_ht	(Traeger.get Htrg delta_lr)
	)
	
	(setq xPos_ht (Connect.get CastaData xPos_ht)
				at_winkel	(Connect.get CastaData at_laengswinkel)
	)
	
	; Klemmlnge
	(setq dicke_trg t_at)
	(setq klemml (+ dicke_trg dp_blech))
	
	
	; dxSKopf Anschluss am Steg
	(if (= (Connect.get CastaData amHtSteg) 1)
		(progn
			(if (= (Connect.get CastaData satr-vhtr)  1) (setq dxS (* 0.5 dp_blech)))
			(if (= (Connect.get CastaData satr-vhtr) -1) (setq dxS (+ (* 0.5 dp_blech) t_at)))
			(if (= (Connect.get CastaData vatr-vhtr)  1) (setq dxS (+ (* 0.5 dp_blech) t_at)))
			(if (= (Connect.get CastaData vatr-vhtr) -1) (setq dxS (* 0.5 dp_blech)))	
		)
	)
			
	; dxSKopf Anschluss am Flansch
	(if (= (Connect.get CastaData amHtFlansch) 1)
		(progn
			(if (= (Connect.get CastaData satr-shtr)  1) (setq dxS (* 0.5 dp_blech)))
			(if (= (Connect.get CastaData satr-shtr) -1) (setq dxS (+ (* 0.5 dp_blech) t_at)))
			(if (= (Connect.get CastaData vatr-shtr)  1) (setq dxS (+ (* 0.5 dp_blech) t_at)))
			(if (= (Connect.get CastaData vatr-shtr) -1) (setq dxS (* 0.5 dp_blech)))		
		)
	)
	
	(print dxS)
	
	
	
	
	
	; Werte setzen
	(Lochbild.set Lchb_ID 	(klemml		klemml)
				(dxSKopf	dxS)
	)
	
	
	; xPos Lochbild-Anbauteil
	
	
	
	(setq xPos_LB xPos_ht)
	
	; Lochbild dem HT hinzufgen
	(setq AbtlKnoBl	(Traeger.get Htrg AbTeil Blech_ID))
	(Traeger.addabtl Htrg Lchb_ID 0.0 0.0 _knblLochbild_ AbtlKnoBl)
	
	(setq AbtlKnoBlLchb    (Traeger.get Htrg AbTeil Lchb_ID))
		
	(Anbauteil.set AbtlKnoBlLchb 	(Master 1)
					(delta_sx knotenblech_soll_versatz)
	)
)


; NEUE METHODEN FR DIE VARIANTE OHNE STABVERSCHIEBUNG
; ====================================================

(defun positioniereKnotenblech ()
	(print "Positioniere Knotenblech")
	(print ">------------------------------------------------------------------------------")
	
	(setq	h_at 	(Traeger.get Tr_ID h)
		b_at	(Traeger.get Tr_ID b)
		d_at	(Traeger.get Tr_ID s)
		t_at	(Traeger.get Tr_ID t)
	)

	(print "--------------------------------------------- xPos-Fehlersuche -1-")
	(print xPosStz)
	
	(setq xPos_HT (Connect.get CastaData xPos_ht))
	(print xPos_HT)
	
	(setq at_winkel (Connect.get CastaData at_laengswinkel))
	(print at_winkel)
	
	(setq sinATW (sin (/ (* PI at_winkel) 180.0)))
	(print sinATW)
	
	; max. Lochdurchmesser d und min. Anreimae w 
	; ---------------------------------------------
	(getWMass) ; --> d_1, d_2, w_1, w_2, w_3
	(print d_1)
	(print d_2)
	(print w_1)
	(print w_2)
	(print w_3)
	
	(setq noH_at (* 0.5 (- h_at t_at)))
	(setq noB_at (* 0.5 (- b_at t_at)))
	(print noH_at)
	(print noB_at)
	
	(if (= b_at h_at)
		; gleichschenklig
		(progn
			(if (<= w_1 0.0)
				(progn
					(setq L_Abst_H noH_at)
					(setq L_Abst_B noB_at)
				)
				(progn
					(setq L_Abst_H w_1)
					(setq L_Abst_B w_1)
				)
			)
		)
		; ungleichschenklig
		(progn
			(if (<= w_1 0.0)
				(setq L_Abst_H noH_at)
				(setq L_Abst_H w_1)
			)
			(if (<= w_3 0.0)
				(setq L_Abst_B noB_at)
				(setq L_Abst_B w_3)
			)
		)
	)
	
	(print L_Abst_H)
	(print L_Abst_B)
	
	(if (= (Connect.get CastaData amHtFlansch) 1)
		(progn
			(if (= (Connect.get CastaData vatr-shtr)  1)	(setq t_seite L_Abst_B));(* 0.5 b_at)))
			(if (= (Connect.get CastaData vatr-shtr) -1)	(setq t_seite L_Abst_B));(* 0.5 b_at)))
			(if (= (Connect.get CastaData satr-shtr)  1)	(setq t_seite L_Abst_H));(* 0.5 h_at)))
			(if (= (Connect.get CastaData satr-shtr) -1)	(setq t_seite L_Abst_H));(* 0.5 h_at)))
		)
	)
	(if (= (Connect.get CastaData amHtSteg) 1)
		(progn
			(if (= (Connect.get CastaData vatr-shtr)  1)	(setq t_seite L_Abst_H));(* 0.5 h_at)))
			(if (= (Connect.get CastaData vatr-shtr) -1)	(setq t_seite L_Abst_H));(* 0.5 h_at)))
			(if (= (Connect.get CastaData vatr-vhtr)  1)	(setq t_seite L_Abst_B));(* 0.5 b_at)))
			(if (= (Connect.get CastaData vatr-vhtr) -1)	(setq t_seite L_Abst_B));(* 0.5 b_at)))
		)
	)
	(print t_seite)

	(print "--------------------------------------------- xPos-Fehlersuche -2-         <====")
	(print xPosStz)

	
	(setq xPos_delta (/ t_seite sinATW))
	(print xPos_delta)
	(print "<------------------------------------------------------------------------------")
)

; ---------------------------------------------------------------------------------------
;
; ---------------------------------------------------------------------------------------
(defun getWMass ()
	(print ">------------------------------------------------------------------------------")
	(print "BERECHNE LOCHABSTAND")
	
	(setq b_at 	(Traeger.get Tr_ID b)
				h_at	(Traeger.get Tr_ID h)
				t_at	(Traeger.get Tr_ID t)
	)
		
	(setq d_1 0.0
				d_2 0.0
				w_1	0.0
				w_2 0.0
				w_3 0.0
	)
	; erstmal 
	; TABELLENWERTE AUS STAHLBAU KOMPAKT (Kindman, Kraus, Niebuhr), 2006
	; Bercksichtigt neben der DIN 997 (1970) auch die DIN 18800 (1990)
	(if (= b_at h_at)
		; -----------------------------------------------------------------
		; Gleichschenklige Winkel
		; -----------------------------------------------------------------
		(progn
			(if (= h_at 50.0)
				(progn
					(if (= t_at 5.0)	(setq d_1 11.0		w_1	35.0))
					(if (= t_at 6.0)	(setq d_1 11.0		w_1	36.0))
				)
			)
			(if (= h_at 55.0)
				(progn
					(if (= t_at 6.0)	(setq d_1 13.0		w_1	36.0))
				)
			)
			(if (= h_at 60.0)
				(progn
					(if (= t_at 5.0)	(setq d_1 13.0		w_1	35.0))
					(if (= t_at 6.0)	(setq d_1 13.0		w_1	36.0))
					(if (= t_at 8.0)	(setq d_1 13.0		w_1	38.0))
				)
			)
			(if (= h_at 65.0)
					(if (= t_at 7.0)	(setq d_1 17.0 		w_1	42.0))
			)
			(if (= h_at 70.0)
				(progn
					(if (= t_at 6.0)	(setq d_1 21.0		w_1	41.0))
					(if (= t_at 7.0)	(setq d_1 21.0		w_1	42.0))
					(if (= t_at 9.0)	(setq d_1 21.0		w_1	44.0))
				)
			)
			(if (= h_at 75.0)
				(progn
					(if (= t_at 6.0)	(setq d_1 21.0		w_1	41.0))
					(if (= t_at 7.0)	(setq d_1 21.0		w_1	43.0))
					(if (= t_at 8.0)	(setq d_1 21.0		w_1	43.0))
				)
			)
			(if (= h_at 80.0)
				(progn
					(if (= t_at 6.0)	(setq d_1 25.0		w_1	48.0))
					(if (= t_at 8.0)	(setq d_1 25.0		w_1	50.0))
					(if (= t_at 10.0)	(setq d_1 21.0		w_1	46.0))
				)
			)
			(if (= h_at 90.0)
				(progn
					(if (= t_at 7.0)	(setq d_1 28.0		w_1	53.0))
					(if (= t_at 8.0)	(setq d_1 28.0		w_1	54.0))
					(if (= t_at 9.0)	(setq d_1 28.0		w_1	55.0))
					(if (= t_at 10.0)	(setq d_1 28.0		w_1	56.0))
				)
			)
			(if (= h_at 100.0)
				(progn
					(if (= t_at 8.0)	(setq d_1 28.0		w_1	55.0))
					(if (= t_at 10.0)	(setq d_1 28.0		w_1	57.0))
					(if (= t_at 12.0)	(setq d_1 28.0		w_1	59.0))
				)
			)
			(if (= h_at 110.0)
				(progn
					(if (= t_at 10.0)	(setq d_1 28.0		w_1	57.0))
					(if (= t_at 12.0)	(setq d_1 28.0		w_1	60.0))
				)
			)
			(if (= h_at 120.0)
				(progn
					(if (= t_at 10.0)	(setq d_1 28.0		w_1	60.0))
					(if (= t_at 11.0)	(setq d_1 28.0		w_1	59.0))
					(if (= t_at 12.0)	(setq d_1 28.0		w_1	60.0))
					(if (= t_at 13.0)	(setq d_1 28.0		w_1	61.0))
					(if (= t_at 15.0)	(setq d_1 28.0		w_1	63.0))
				)
			)
			(if (= h_at 130.0)
				(if (= t_at 12.0)	(setq d_1 28.0		w_1	61.0))
			)
			(if (= h_at 140.0)
				(if (= t_at 13.0)	(setq d_1 28.0		w_1	63.0))
			)
			(if (= h_at 150.0)
				(progn
					(if (= t_at 10.0)	(setq d_1 25.0		w_1	58.0	w_2 118.0))
					(if (= t_at 12.0)	(setq d_1 25.0		w_1	60.0	w_2 120.0))
					(if (= t_at 14.0)	(setq d_1 28.0		w_1	66.0	))
					(if (= t_at 15.0)	(setq d_1 28.0		w_1	66.0	))
					(if (= t_at 18.0)	(setq d_1 28.0		w_1	69.0	))
				)
			)
			(if (= h_at 160.0)
				(progn
					(if (= t_at 14.0)	(setq d_1 25.0		w_1	63.0	w_2 123.0))	
					(if (= t_at 15.0)	(setq d_1 25.0		w_1	64.0	w_2 124.0))
					(if (= t_at 16.0)	(setq d_1 25.0		w_1	65.0	w_2 125.0))
					(if (= t_at 17.0)	(setq d_1 25.0		w_1	66.0	w_2 126.0))
				)
			)
			(if (= h_at 180.0)
				(progn
					(if (= t_at 14.0)	(setq d_1 28.0		w_1	67.0	w_2 134.0))
					(if (= t_at 15.0)	(setq d_1 28.0		w_1	68.0	w_2 135.0))
					(if (= t_at 16.0)	(setq d_1 28.0		w_1	69.0	w_2 136.0))
					(if (= t_at 18.0)	(setq d_1 28.0		w_1	71.0	w_2 138.0))
					(if (= t_at 20.0)	(setq d_1 28.0		w_1	73.0	w_2 140.0))
				)
			)
			(if (= h_at 200.0)
				(progn
					(if (= t_at 16.0)	(setq d_1 28.0		w_1	69.0	w_2 136.0))
					(if (= t_at 17.0)	(setq d_1 28.0		w_1	70.0	w_2 137.0))
					(if (= t_at 18.0)	(setq d_1 28.0		w_1	71.0	w_2 138.0))
					(if (= t_at 19.0)	(setq d_1 28.0		w_1	72.0	w_2 139.0))
					(if (= t_at 20.0)	(setq d_1 28.0		w_1	73.0	w_2 140.0))
					(if (= t_at 21.0)	(setq d_1 28.0		w_1	74.0	w_2 141.0))
					(if (= t_at 22.0)	(setq d_1 28.0		w_1	75.0	w_2 142.0))
					(if (= t_at 24.0)	(setq d_1 28.0		w_1	77.0	w_2 144.0))
					(if (= t_at 26.0)	(setq d_1 28.0		w_1	79.0	w_2 146.0))
				)
			)
			(if (= h_at 250.0)
				(progn
					(if (= t_at 20.0)	(setq d_1 28.0		w_1	73.0	w_2 166.0))
					(if (= t_at 21.0)	(setq d_1 28.0		w_1	74.0	w_2 166.0))
					(if (= t_at 22.0)	(setq d_1 28.0		w_1	75.0	w_2 166.0))
					(if (= t_at 23.0)	(setq d_1 28.0		w_1	76.0	w_2 166.0))
					(if (= t_at 24.0)	(setq d_1 28.0		w_1	77.0	w_2 166.0))
					(if (= t_at 26.0)	(setq d_1 28.0		w_1	79.0	w_2 166.0))
					(if (= t_at 28.0)	(setq d_1 28.0		w_1	81.0	w_2 166.0))
					(if (= t_at 35.0)	(setq d_1 28.0		w_1	88.0	w_2 166.0))
				)
			)
		)
		; -----------------------------------------------------------------
		; Ungleichschenklige Winkel
		; -----------------------------------------------------------------
		(progn
			(if (= h_at 50.0)
				(progn
					(if (= b_at 30.0)
						(if (= t_at 5.0)	(setq d_1 11.0	w_1 35.0))
					)
					(if (= b_at 40.0)
						(if (= t_at 5.0)	(setq d_1 11.0	w_1 35.0))
					)
				)
			)
			(if (= h_at 60.0)
				(progn
					(if (= b_at 30.0)
						(if (= t_at 5.0)	(setq d_1 13.0	w_1 35.0))
					)
					(if (= b_at 40.0)
						(progn
							(if (= t_at 5.0)	(setq d_1 13.0	w_1 35.0))
							(if (= t_at 6.0)	(setq d_1 13.0	w_1 36.0))
							(if (= t_at 7.0)	(setq d_1 13.0	w_1 37.0))
						)
					)
				)
			)
			(if (= h_at 65.0)
				(if (= b_at 50.0)
						(if (= t_at 5.0)	(setq d_1 17.0	d_2 11.0		w_1 40.0		w_3 35.0))
						(if (= t_at 7.0)	(setq d_1 17.0							w_1 42.0))
						(if (= t_at 9.0)	(setq d_1 17.0							w_1 44.0))
				)
			)
			(if (= h_at 70.0)
				(if (= b_at 50.0)
						(if (= t_at 6.0)	(setq d_1 21.0	d_2 13.0		w_1 40.0		w_3 35.0))
				)
			)
			(if (= h_at 75.0)
				(progn
					(if (= b_at 50.0)
						(progn
							(if (= t_at 6.0)	(setq d_1 21.0	d_2 11.0		w_1 41.0		w_3 36.0))
							(if (= t_at 8.0)	(setq d_1 21.0							w_1 43.0))
							(if (= t_at 9.0)	(setq d_1 21.0							w_1 44.0))
						)
					)
					(if (= b_at 55.0)
						(progn
							(if (= t_at 5.0)	(setq d_1 21.0	d_2 13.0		w_1 40.0		w_3 35.0))
							(if (= t_at 7.0)	(setq d_1 21.0	d_2 13.0		w_1 42.0		w_3 37.0))
							(if (= t_at 9.0)	(setq d_1 21.0	d_2 13.0		w_1 44.0		w_3 39.0))
						)
					)
				)
			)
			(if (= h_at 80.0)
				(progn
					(if (= b_at 40.0)
						(progn
							(if (= t_at 6.0)	(setq d_1 25.0	w_1 46.0))
							(if (= t_at 8.0)	(setq d_1 25.0	w_1 48.0))
						)
					)
					(if (= b_at 60.0)	
						(if (= t_at 7.0)	(setq d_1 25.0	d_2 13.0		w_1 47.0		w_3 37.0))
					)
					(if (= b_at 65.0)
						(progn
							(if (= t_at 8.0)	(setq d_1 25.0	d_2 17.0		w_1 48.0		w_3 43.0))
							(if (= t_at 10.0)	(setq d_1 25.0	d_2 13.0		w_1 50.0		w_3 40.0))
						)
					)
				)
			)
			(if (= h_at 90.0)
				(if (= b_at 60.0)
					(progn
						(if (= t_at 6)	(setq d_1 25.0	d_2 13.0		w_1 48.0		w_3 36.0))
						(if (= t_at 8)	(setq d_1 28.0	d_2 13.0		w_1 53.0		w_3 38.0))
					)
				)
			)
			(if (= h_at 100.0)
				(progn
					(if (= b_at 50.0)
						(progn
							(if (= t_at 6.0)	(setq d_1 25.0	d_2 11.0		w_1 48.0		w_3 36.0))
							(if (= t_at 8.0)	(setq d_1 28.0							w_1 53.0))
							(if (= t_at 10.0)	(setq d_1 28.0							w_1 55.0))
						)
					)
					(if (= b_at 65.0)
						(progn
							(if (= t_at 7.0)	(setq d_1 28.0	d_2 17.0		w_1 56.0		w_3 42.0))
							(if (= t_at 8.0)	(setq d_1 28.0	d_2 17.0		w_1 53.0		w_3 43.0))
							(if (= t_at 9.0)	(setq d_1 28.0	d_2 17.0		w_1 54.0		w_3 44.0))
							(if (= t_at 10.0)	(setq d_1 28.0	d_2 13.0  	w_1 55.0		w_3 40.0))
							(if (= t_at 11.0)	(setq d_1 28.0	d_2 13.0		w_1 56.0		w_3 41.0))
						)
					)
					(if (= b_at 75.0)
						(progn
							(if (= t_at 7.0)	(setq d_1 28.0	d_2 21.0		w_1 56.0		w_3 43.0))
							(if (= t_at 8.0)	(setq d_1 28.0	d_2 21.0		w_1 53.0		w_3 44.0))
							(if (= t_at 9.0)	(setq d_1 28.0	d_2 21.0		w_1 54.0		w_3 45.0))
							(if (= t_at 10.0)	(setq d_1 28.0	d_2 21.0    w_1 55.0		w_3 46.0))
							(if (= t_at 11.0)	(setq d_1 28.0	d_2 21.0    w_1 56.0		w_3 47.0))
							(if (= t_at 12.0)	(setq d_1 28.0	d_2 21.0		w_1 57.0		w_3 48.0)) 
						)
					)
				)
			)
			(if (= h_at 120.0)
				(progn
					(if (= b_at 80.0)
						(progn
							(if (= t_at 8.0)	(setq d_1 28.0	d_2 21.0		w_1 64.0		w_3 45.0))
							(if (= t_at 10.0)	(setq d_1 28.0	d_2 21.0		w_1 60.0		w_3 47.0))
							(if (= t_at 12.0)	(setq d_1 28.0	d_2 21.0		w_1 58.0		w_3 49.0))
						)
					)
				)
			)
			(if (= h_at 125.0)
				(progn
					(if (= b_at 75.0)
						(progn
							(if (= t_at 8.0)	(setq d_1 28.0	d_2 21.0		w_1 64.0		w_3 45.0))
							(if (= t_at 10.0)	(setq d_1 28.0	d_2 21.0		w_1 65.0		w_3 47.0))
							(if (= t_at 12.0)	(setq d_1 28.0	d_2 21.0		w_1 58.0		w_3 49.0))
						)
					)
				)
			)
			(if (= h_at 130.0)
				(progn
					(if (= b_at 65.0)
						(progn
							(if (= t_at 8.0)	(setq d_1 28.0	d_2 17.0		w_1 64.0		w_3 43.0))
							(if (= t_at 10.0)	(setq d_1 28.0	d_2 13.0		w_1 70.0		w_3 40.0))
							(if (= t_at 12.0)	(setq d_1 28.0	d_2 13.0		w_1 58.0		w_3 42.0))
						)
					)
				)
			)
			(if (= h_at 130.0)
				(if (= b_at 90.0)
					(if (= t_at 12)		(setq d_1 28.0	d_2 25.0	w_1 59.0	w_3 56.0))
				)
			)
			(if (= h_at 135.0)
				(progn
					(if (= b_at 65.0)
						(progn
							(if (= t_at 8.0)	(setq d_1 28.0	d_2 17.0	w_1 64.0	w_3 43.0))
							(if (= t_at 10.0)	(setq d_1 28.0	d_2 13.0	w_1 75.0	w_3 40.0))
						)
					)
				)
			)
			(if (= h_at 150.0)
				(progn
					(if (= b_at 75.0)
						(progn
							(if (= t_at 9.0)	(setq d_1 25.0	d_2 21.0		w_1 53.0		w_2 113.0		w_3 47.0))
							(if (= t_at 10.0)	(setq d_1 25.0	d_2 21.0		w_1 54.0		w_2 114.0		w_3 48.0))
							(if (= t_at 11.0)	(setq d_1 25.0	d_2 21.0		w_1 53.0		w_2 113.0		w_3 47.0))
							(if (= t_at 12.0)	(setq d_1 25.0	d_2 21.0		w_1 56.0		w_2 116.0		w_3 50.0))
							(if (= t_at 15.0)	(setq d_1 25.0	d_2 17.0		w_1 59.0		w_2 119.0		w_3 50.0))
						)
					)
					(if (= b_at 90.0)
						(progn
							(if (= t_at 10.0)	(setq d_1 25.0	d_2 25.0		w_1 54.0		w_2 114.0		w_3 54.0))
							(if (= t_at 11.0)	(setq d_1 25.0	d_2 25.0		w_1 55.0		w_2 115.0		w_3 55.0))
							(if (= t_at 12.0)	(setq d_1 25.0	d_2 25.0		w_1 56.0		w_2 116.0		w_3 56.0))
							(if (= t_at 15.0)	(setq d_1 25.0	d_2 25.0		w_1 59.0		w_2 119.0		w_3 59.0))
						)
					)
					(if (= b_at 100.0)
						(progn
							(if (= t_at 10.0)	(setq d_1 25.0	d_2 28.0		w_1 54.0		w_2 114.0		w_3 57.0))
							(if (= t_at 12.0)	(setq d_1 25.0	d_2 28.0		w_1 56.0		w_2 116.0		w_3 59.0))
							(if (= t_at 14.0)	(setq d_1 25.0	d_2 28.0		w_1 59.0		w_2 119.0		w_3 62.0))
						)
					)
				)
			)
			(if (= h_at 160.0)
				(progn
					(if (= b_at 80.0)
						(progn
							(if (= t_at 10.0)	(setq d_1 28.0	d_2 21.0		w_1 58.0		w_2 125.0		w_3 49.0))
							(if (= t_at 12.0)	(setq d_1 25.0	d_2 21.0		w_1 57.0		w_2 117.0		w_3 51.0))
						)
					)
				)
			)
			(if (= h_at 180.0)
				(progn
					(if (= b_at 90.0)
						(progn
							(if (= t_at 10.0)	(setq d_1 28.0	d_2 25.0		w_1 59.0		w_2 126.0		w_3 56.0))
							(if (= t_at 12.0)	(setq d_1 28.0	d_2 25.0		w_1 61.0		w_2 128.0		w_3 58.0))
						)
					)
				)
			)
			(if (= h_at 200.0)
				(progn
					(if (= b_at 100.0)
						(progn
							(if (= t_at 10.0)	(setq d_1 28.0	d_2 28.0  	w_1 60.0		w_2 140.0		w_3 60.0))
							(if (= t_at 12.0)	(setq d_1 28.0	d_2 28.0  	w_1 62.0		w_2 129.0		w_3 62.0))
							(if (= t_at 14.0)	(setq d_1 28.0	d_2 28.0  	w_1 64.0		w_2 131.0		w_3 64.0))
							(if (= t_at 15.0) (setq d_1 28.0	d_2 28.0  	w_1 65.0		w_2 132.0		w_3 65.0))
						)
					)
					(if (= b_at 150.0)
						(progn
							(if (= t_at 12.0)	(setq d_1 28.0	d_2 28.0  	w_1 62.0		w_2 129.0		w_3 78.0))
							(if (= t_at 15.0)	(setq d_1 28.0	d_2 28.0  	w_1 65.0		w_2 132.0		w_3 66.0))
						)
					)
				)
			)
		)
	)
	
	(print "<------------------------------------------------------------------------------")
)