(defun init-windverband ()
  (print "********************************************************************")
  (print "in init-connection - L-Windverband - kreuzend - ***neu***");
  
  (Connect.showAttributes CastaData)
  (setq LB_DEBUG 0)
  
  ; Erstmal unterscheiden, 
  (setq StegAnschluss "null")
  (if (= (Connect.get CastaData at-von-rechts) 1) (progn
  	(if (= (Connect.get CastaData linkesEnde)  1) (setq StegAnschluss "links"))
  	(if (= (Connect.get CastaData rechtesEnde) 1) (setq StegAnschluss "rechts"))
  ))
  (if (= (Connect.get CastaData at-von-links) 1) (progn
  	(if (= (Connect.get CastaData rechtesEnde) 1) (setq StegAnschluss "links"))
  	(if (= (Connect.get CastaData linkesEnde)  1) (setq StegAnschluss "rechts"))
  ))
  (setq FlanschAnschluss "null")
  (if (= (Connect.get CastaData at-von-oben) 1) (progn
  	(if (= (Connect.get CastaData linkesEnde)  1) (setq FlanschAnschluss "unten"))
  	(if (= (Connect.get CastaData rechtesEnde) 1) (setq FlanschAnschluss "oben"))
  ))
  (if (= (Connect.get CastaData at-von-unten) 1) (progn
  	(if (= (Connect.get CastaData rechtesEnde) 1) (setq FlanschAnschluss "unten"))
  	(if (= (Connect.get CastaData linkesEnde)  1) (setq FlanschAnschluss "oben"))
  ))
  

  (calcLichtenAbst)

  (setq knblLochbild (Lochbild.create))
  (setq knotenBlech (Blech.create))
	(Connect.storeAnschlObjs CastaData knblLochbild knotenBlech)  
   
	(if (= STD 0)
		(progn
			(createKnotenBlech knotenBlech l_schr rand_abst)	
		)
		(progn
			; berechnet und setzt den e0-Wert des Lochbildes
			(calcAndSetE0_Var2 knblLochbild parallel_abstand_stz)
			
			; erzeugt das Knotenblech
			(manualKnotenBlechCreation knblLochbild)
		)
	)
	
	
	
   (if (= 1 1)	(progn
	; Krzt das Anschlussende des AT
	; ---------------------------------------------
		(kuerzeWinkelProfil parallel_abstand_stz)
   ))
	
   (if (= 1 1)	(progn
	; Positioniert den Verbandsstab
	; ---------------------------------------------
  	(if (= (Connect.get CastaData linkesEnde) 1)
  	  (progn
  		(if (= (Connect.get CastaData anschl_anderesende) 0)
  			(positioniereVerband)
  		)
  	  )
	)
  	(if (= (Connect.get CastaData rechtesEnde) 1)
  	  (progn
  		(if (= (Connect.get CastaData anschl_anderesende) 0)
  			(positioniereVerband)
  		)
  	  )
	)
  ))
	
  (if (= 1 1)	(progn
  	(if (= STD 0)
		(createLochbild knotenBlech knblLochbild rand_abst parallel_abstand_stz)
		(createLochbild_Var2 knblLochbild knotenBlech parallel_abstand_stz)
	)
  ))
	
  (if (= 1 1)	(progn
		(positioniereKnotenblech)
		(createATLochbild knblLochbild)
		(RichtungsDef_Lochbild knblLochbild)
  ))

  (calcLochbild_w)

  (if (= 1 2) (progn
; 	(Lochbild.set knblLochbild 
;				   (delta_w  40)	; ACHTUNG - geht in der WSZ links in die falsche Richtung!
;  				   (w0       0)
; 				   (LB_Art    0)
;  	)
  	(setq AbtlKnoBlLchbAT    (Traeger.get Tr_ID AbTeil knblLochbild))
	(Anbauteil.set AbtlKnoBlLchbAT 	(Master     0)
;					(SeitRicht  1)
	)

  	(setq AbtlKnoBlLchbHT    (Traeger.get HTrg AbTeil knblLochbild))
	(Anbauteil.set AbtlKnoBlLchbHT 	(Master     1)
;					(SeitRicht -1)
	)

  ))	

  (if (= 1 1) (progn
  	(setq AbtlKnoBlLchbHT    (Traeger.get HTrg AbTeil knblLochbild))
  	(setq AbtlKnoBl____HT    (Traeger.get HTrg AbTeil knotenBlech))
  	
  	(setq xPos_Lochbild (Anbauteil.get AbtlKnoBlLchbHT xPos))
  	(setq xPos_KnotenBl (Anbauteil.get AbtlKnoBl____HT xPos))

	(print xPos_Lochbild)
	(print xPos_KnotenBl)
  ))

  (if (= 1 2) (progn
  	(setq AbtlKnoBlLchbAT    (Traeger.get Tr_ID AbTeil knblLochbild))
  	(setq AbtlKnoBlLchbHT    (Traeger.get HTrg AbTeil knblLochbild))

 	(Lochbild.set knblLochbild (w0 30))

	(Anbauteil.set AbtlKnoBlLchbHT 	(Master	    1))
	(Anbauteil.set AbtlKnoBlLchbAT 	(Master     0))


  	(setq HT_delta_lr (Anbauteil.get AbtlKnoBlLchbHT delta_LR))  	(print HT_delta_lr)
;  	(setq HTwRichtung (Anbauteil.get AbtlKnoBlLchbHT SeitRicht))  	(print HTwRichtung)

  	(setq AT_delta_lr (Anbauteil.get AbtlKnoBlLchbAT delta_LR))  	(print AT_delta_lr)
;  	(setq ATwRichtung (Anbauteil.get AbtlKnoBlLchbAT SeitRicht))  	(print ATwRichtung)

  	(setq XPos_Lchb_HT (Anbauteil.get AbtlKnoBlLchbHT xPos))  	(print XPos_Lchb_HT)


;	(Anbauteil.set AbtlKnoBlLchbHT (delta_LR 0.0))

  ))

    (if (= 1 1) (progn
       (setq ABtl_Lochb_HT (Traeger.get HTrg  ABTeil knblLochbild))
       (setq ABtl_Lochb_AT (Traeger.get TR_ID ABTeil knblLochbild))
       (Anbauteil.set ABtl_Lochb_HT (master 1))
       (Anbauteil.set ABtl_Lochb_AT (master 0))
    ))


	
)




; ====================================================================== 
(defun kuerzeWinkelProfil (p_abst_stz)
	(print "--------------------------------------------------------------------------------")
	(print "KUERZE PROFIL")
  ; Winkelprofil krzen ...
  ; korrekten Wert noch aus Sttzenprofil und Winkel berechnen
  (setq kuerzLng     0
        h_Ht     	(Traeger.get HTrg h)
        b_Ht     	(Traeger.get HTrg b)
        s_Ht     	(Traeger.get HTrg s)
        deltaV   	(Traeger.get HTrg delta_V)
        deltaLR  	(Traeger.get HTrg delta_LR)
	qsform_HT	(Traeger.get HTrg qsform)
  )
  (setq b_Trg    	(Traeger.get Tr_ID b)			
        h_Trg    	(Traeger.get Tr_ID h)			
        rwnkl		(Traeger.get Tr_ID r_winkel)
        deltaV_at	(Traeger.get Tr_ID delta_v)
        deltaLR_at	(Traeger.get Tr_ID delta_lr)
  )
  
  (if (= FlanschAnschluss "oben") (progn
      (setq kuerzLng (- (* 0.5 h_Ht) deltaV))
  ))
  (if (= FlanschAnschluss "unten") (progn
      (setq kuerzLng (+ (* 0.5 h_Ht) deltaV))
  ))

  (if (= StegAnschluss "links") (progn
      (setq kuerzLng (- (* 0.5 s_Ht) deltaLR))
      (if (= qsform_HT "K") (setq kuerzLng (- (* 0.5 b_Ht) deltaLR)))
      (if (= qsform_HT "R") (setq kuerzLng (- (* 0.5 b_Ht) deltaLR)))
  ))
  (if (= StegAnschluss "rechts") (progn
      (setq kuerzLng (+ (* 0.5 s_Ht) deltaLR))
      (if (= qsform_HT "K") (setq kuerzLng (+ (* 0.5 b_Ht) deltaLR)))
      (if (= qsform_HT "R") (setq kuerzLng (+ (* 0.5 b_Ht) deltaLR)))
  ))

	
  (setq AFl_Winkel (connect.get CastaData at_laengswinkel))
  (print AFl_Winkel)
  (setq AFl_Winkel (- AFl_Winkel 90.0))
	(print AFl_Winkel)
  
  (setq sinAWnkl (sin (/ (* PI AFl_Winkel) 180.0))
  			cosAWnkl (cos (/ (* PI AFl_Winkel) 180.0))
  			tanAWnkl (tan (/ (* PI AFl_Winkel) 180.0))
  )
  (print tanAWnkl)
  
  
  (setq A_Winkel (connect.get CastaData at_laengswinkel))
	
	(print A_Winkel)
	(setq tanAW (tan (/ (* PI A_Winkel) 180.0))
				sinAW	(sin (/ (* PI A_Winkel) 180.0))
	)
	
	
	(setq delta 0)
	
	(if (= FlanschAnschluss "unten")
		(progn
			(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta deltaLR_at))
			(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta (- deltaLR_at)))
			(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta deltaV_at))
			(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta (- deltaV_at)))
		)
	)
	(if (= FlanschAnschluss "oben")
		(progn
			(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta (- deltaLR_at)))
			(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta deltaLR_at))
			(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta deltaV_at))
			(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta (- deltaV_at)))	
		)
	)
		
	(if (= 1 1) (progn
	    (if (/= FlanschAnschluss "null")
		(progn
			(if (= (Connect.get CastaData vatr-shtr)  1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta deltaLR_at))
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta (- deltaLR_at)))
				)
			)
			(if (= (Connect.get CastaData vatr-shtr) -1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta deltaLR_at))
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta (- deltaLR_at)))
				)
			)
			(if (= (Connect.get CastaData satr-shtr)  1)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta deltaV_at))
					(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta (- deltaV_at)))	
				)
			)
			(if (= (Connect.get CastaData satr-shtr) -1)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta deltaV_at))
					(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta (- deltaV_at)))	
				)
			)
		)
	    )
	))
	(if (/= StegAnschluss "null")
		(progn
			(if (= (Connect.get CastaData vatr-vhtr)  1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta deltaLR_at))
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta (- deltaLR_at)))
				)
			)
			(if (= (Connect.get CastaData vatr-vhtr) -1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta deltaLR_at))
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta (- deltaLR_at)))
				)
			)
			(if (= (Connect.get CastaData satr-vhtr)  1)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta deltaV_at))
					(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta (- deltaV_at)))	
				)
			)
			(if (= (Connect.get CastaData satr-vhtr) -1)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta deltaV_at))
					(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta (- deltaV_at)))	
				)
			)
		)
	)
	
	
	
	(print delta)
	
	; --------------------------------------------------------------------------------------
	
	; 2. ANSCHLUSS
	; --------------------------------------------------------------------------------------
	(if (= 1 2)	(progn
	(if (> (Connect.get CastaData anschl_anderesEnde) 0)
		(progn
			(setq h_trg_halb (* 0.5 h_Trg)) ; TODO: je nach Rotation h oder b verwenden
			(setq b_trg_halb (* 0.5 b_Trg))
			
			(if (/= StegAnschluss "null")
				(progn
					(if (= (Connect.get CastaData vatr-vhtr)  1)
						(progn
							(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta (- delta b_trg_halb)))
							(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta (+ delta b_trg_halb)))
						)
					)
					(if (= (Connect.get CastaData vatr-vhtr) -1)
						(progn
							(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta (- delta b_trg_halb)))
							(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta (+ delta b_trg_halb)))
						)
					)
					(if (= (Connect.get CastaData satr-vhtr)  1)
						(progn
							(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta (+ delta h_trg_halb)))
							(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta (- delta h_trg_halb)))
						)
					)
					(if (= (Connect.get CastaData satr-vhtr) -1)
						(progn
							(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta (+ delta h_trg_halb)))
							(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta (- delta h_trg_halb)))
						)
					)
				)
			)
			
			(if (/= FlanschAnschluss "null")
				(progn
					(if (= (Connect.get CastaData vatr-shtr)  1)
						(progn
							(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta (- delta b_trg_halb)))
							(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta (+ delta b_trg_halb)))
						)
					)
					(if (= (Connect.get CastaData vatr-shtr) -1)
						(progn
							(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta (- delta b_trg_halb)))
							(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta (+ delta b_trg_halb)))
						)
					)
					(if (= (Connect.get CastaData satr-shtr)  1)
						(progn
							(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta (+ delta h_trg_halb)))
							(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta (- delta h_trg_halb)))
						)
					)
					(if (= (Connect.get CastaData satr-shtr) -1)
						(progn
							(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta (+ delta h_trg_halb)))
							(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta (- delta h_trg_halb)))
						)
					)
				)
			)
			
		)
	)
	))
	
	; --------------------------------------------------------------------------------------
	(print delta)
	
	(setq anteil_delta (/ delta tanAW))
  (print anteil_delta)
	
  (setq abstand_Stz p_abst_stz)
  (print abstand_stz)
	
  (if (= cosAWnkl 0.0) (setq cosAWnkl 1.0))
  (setq anteil_Verb 0.0)
  
  (setq anteil_Stz (/ kuerzLng cosAWnkl))
  (print anteil_stz)
	
	(if (/= FlanschAnschluss "null")
		(progn
  		(if (= FlanschAnschluss "oben")
				(progn
					(if (= (Connect.get CastaData vatr-lhtr)  1)
						(progn
							(if (= (Connect.get CastaData vatr-vhtr)  1)	(setq anteil_Verb 0.0))
							(if (= (Connect.get CastaData vatr-vhtr) -1)	(setq anteil_Verb (* h_Trg tanAWnkl)))
						)
					)
					(if (= (Connect.get CastaData vatr-lhtr) -1)
						(progn
							(if (= (Connect.get CastaData vatr-vhtr)  1)	(setq anteil_Verb 0.0))
							(if (= (Connect.get CastaData vatr-vhtr) -1)	(setq anteil_Verb (- (* h_Trg tanAWnkl))))
						)
					)
					(if (= (Connect.get CastaData satr-lhtr)  1)
						(progn
							(if (= (Connect.get CastaData satr-vhtr)  1)	(setq anteil_Verb (- (* b_Trg tanAWnkl))))
							(if (= (Connect.get CastaData satr-vhtr) -1)	(setq anteil_Verb 0.0))
							(if (= (Connect.get CastaData satr-vhtr)  0)
								(progn
									(if (= (Connect.get CastaData vatr-shtr)  1)	(setq anteil_Verb (- (* b_Trg tanAWnkl))))
									(if (= (Connect.get CastaData vatr-shtr) -1)	(setq anteil_Verb 0.0))
								)
							)
						)
					)
					(if (= (Connect.get CastaData satr-lhtr) -1)
						(progn
							(if (= (Connect.get CastaData satr-vhtr)  1)	(setq anteil_Verb (* b_Trg tanAWnkl)))
							(if (= (Connect.get CastaData satr-vhtr) -1)	(setq anteil_Verb 0.0))
							(if (= (Connect.get CastaData satr-vhtr)  0)
								(progn
									(if (= (Connect.get CastaData vatr-shtr)  1)	(setq anteil_Verb (* b_Trg tanAWnkl)))
									(if (= (Connect.get CastaData vatr-shtr) -1)	(setq anteil_Verb 0.0))
								)
							)
						)
					)
				)
			)
			(if (= FlanschAnschluss "unten")
				(progn
					(if (= (Connect.get CastaData vatr-lhtr)  1)
						(progn
							(if (= (Connect.get CastaData vatr-vhtr)  1)	(setq anteil_Verb (* h_Trg tanAWnkl)))
							(if (= (Connect.get CastaData vatr-vhtr) -1)	(setq anteil_Verb 0.0))
						)
					)
					(if (= (Connect.get CastaData vatr-lhtr) -1)
						(progn
							(if (= (Connect.get CastaData vatr-vhtr)  1)	(setq anteil_Verb (- (* h_Trg tanAWnkl))))
							(if (= (Connect.get CastaData vatr-vhtr) -1)	(setq anteil_Verb 0.0))
						)
					)
					(if (= (Connect.get CastaData satr-lhtr)  1)
						(progn
							(if (= (Connect.get CastaData satr-vhtr)  1)	(setq anteil_Verb 0.0))
							(if (= (Connect.get CastaData satr-vhtr) -1)	(setq anteil_Verb (- (* b_Trg tanAWnkl))))
							(if (= (Connect.get CastaData satr-vhtr)  0)	
								(if (= (Connect.get CastaData vatr-shtr)  1)	(setq anteil_Verb 0.0))
								(if (= (Connect.get CastaData vatr-shtr) -1)	(setq anteil_Verb (- (* b_Trg tanAWnkl))))
							)
						)
					)
					(if (= (Connect.get CastaData satr-lhtr) -1)
						(progn
							(if (= (Connect.get CastaData satr-vhtr)  1)	(setq anteil_Verb 0.0))
							(if (= (Connect.get CastaData satr-vhtr) -1)	(setq anteil_Verb (* b_Trg tanAWnkl)))
							(if (= (Connect.get CastaData satr-vhtr)  0)	
								(if (= (Connect.get CastaData vatr-shtr)  1)	(setq anteil_Verb 0.0))
								(if (= (Connect.get CastaData vatr-shtr) -1)	(setq anteil_Verb (* b_Trg tanAWnkl)))
							)
						)
					)
				)
			)
  	)
  )
  (if (/= StegAnschluss "null")
		(progn
			(if (= StegAnschluss "links")
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)
						(progn
							(if (= (Connect.get CastaData satr-shtr)  1)	(setq anteil_Verb (- (* b_Trg tanAWnkl))))
							(if (= (Connect.get CastaData satr-shtr) -1)	(setq anteil_Verb 0.0))
						)
					)
					(if (= (Connect.get CastaData satr-lhtr) -1)
						(progn
							(if (= (Connect.get CastaData satr-shtr)  1)	(setq anteil_Verb (* b_Trg tanAWnkl)))
							(if (= (Connect.get CastaData satr-shtr) -1)	(setq anteil_Verb 0.0))
						)
					)
					(if (= (Connect.get CastaData vatr-lhtr) -1)
						(progn
							(if (= (Connect.get CastaData vatr-shtr)  1)	(setq anteil_Verb 0.0))
							(if (= (Connect.get CastaData vatr-shtr) -1)	(setq anteil_Verb (- (* h_Trg tanAWnkl))))
						)
					)
					(if (= (Connect.get CastaData vatr-lhtr)  1)
						(progn
							(if (= (Connect.get CastaData vatr-shtr)  1)	(setq anteil_Verb 0.0))
							(if (= (Connect.get CastaData vatr-shtr) -1)	(setq anteil_Verb (* h_Trg tanAWnkl)))
						)
					)
				)
			)
			(if (= StegAnschluss "rechts")
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)
						(progn
							(if (= (Connect.get CastaData satr-shtr)  1)	(setq anteil_Verb 0.0))
							(if (= (Connect.get CastaData satr-shtr) -1)	(setq anteil_Verb (- (* b_Trg tanAWnkl))))
						)
					)
					(if (= (Connect.get CastaData satr-lhtr) -1)
						(progn
							(if (= (Connect.get CastaData satr-shtr)  1)	(setq anteil_Verb 0.0))
							(if (= (Connect.get CastaData satr-shtr) -1)	(setq anteil_Verb (* b_Trg tanAWnkl)))
						)
					)
					(if (= (Connect.get CastaData vatr-lhtr) -1)
						(progn
							(if (= (Connect.get CastaData vatr-shtr)  1)	(setq anteil_Verb (- (* h_Trg tanAWnkl))))
							(if (= (Connect.get CastaData vatr-shtr) -1)	(setq anteil_Verb 0.0))
						)
					)
					(if (= (Connect.get CastaData vatr-lhtr)  1)
						(progn
							(if (= (Connect.get CastaData vatr-shtr)  1)	(setq anteil_Verb (* h_Trg tanAWnkl)))
							(if (= (Connect.get CastaData vatr-shtr) -1)	(setq anteil_Verb 0.0))
						)
					)
				)
			)
		)
	)
  
	(print anteil_Verb)
  	(print AFl_Winkel)
	
	(setq deltaLNeu abstand_Stz)
	(setq deltaLNeu (+ deltaLNeu anteil_Stz))
	(setq deltaLNeu (+ deltaLNeu anteil_delta))
	(setq deltaLNeu (+ deltaLNeu anteil_Verb ))
	
  ;(if (< AFl_Winkel 0.0) 
  	;(setq deltaLNeu (+ deltaLNeu anteil_Verb ))
  ;)
  
  (print deltaLNeu)
  
	
	;Krzen
  (if (= (connect.get CastaData LinkesEnde) 1) (progn
      (setq TrE_Links (Traeger.get Tr_ID links))
      (TrEnde.set TrE_Links (delta_L 0))
      (TrEnde.pTrim TrE_Links deltaLNeu)
  ))
  (if (= (connect.get CastaData RechtesEnde) 1) (progn
      (setq TrE_Rechts (Traeger.get Tr_ID rechts))
      (TrEnde.set TrE_Rechts (delta_L 0))			; erst einmal zurcksetzen
      (TrEnde.pTrim TrE_Rechts deltaLNeu)			; dann krzen
  ))

	(print "<-----------------------------------------------------------")
)





; ****************************************************************************************
; Verschiebt den Trger passend zum Knotenblech
; ****************************************************************************************
(defun positioniereVerband ()
	(print "--------------------------------------------------------------------------------")		
	(print  "POSITIONIERE VERBAND")
	
	
  (setq RWinkel (Traeger.get Tr_ID R_Winkel)
        dp      (Blech.get   knotenBlech  dp)
        b_Trg    (Traeger.get Tr_ID b)			; ist die Frage, wie der Stab liegt
        h_Trg    (Traeger.get Tr_ID h)			; ob Breite oder Hhe entscheidend sind.
  )
  (setq delta_v_at 	(Traeger.get Tr_ID delta_v)
  			delta_lr_at	(Traeger.get Tr_ID delta_lr)
  )

  (setq dp 0)	; Stab soll nicht um dp/2 verschoben werden
  ;Positionieren
  	
	(if (/= StegAnschluss "null")
		(progn
			(setq Sonderfall 0)
			(if (= (Connect.get CastaData satr-shtr) 0) (if (= (Connect.get CastaData vatr-shtr) 0) (setq Sonderfall 1)))
			  (if (= Sonderfall 1) (progn
			     (if (= (Connect.get CastaData satr-vhtr) -1) 
				(Traeger.set Tr_ID 	(delta_LR (+ delta_lr_at 	(* 0.5 dp))))
			     )
			     (if (= (Connect.get CastaData satr-vhtr)  1) 
				(Traeger.set Tr_ID 	(delta_LR (+ delta_lr_at 	(* 0.5 dp))))
			     )
			     (if (/= (Connect.get CastaData vatr-vhtr) 0) 
				(Traeger.set Tr_ID 	(delta_V (- delta_v_at	 	(* 0.5 dp))))
			     )
			  )
			  (progn
			    (if (= (Connect.get CastaData satr-shtr) -1)
				(Traeger.set Tr_ID 	(delta_V 	(- delta_v_at 	(* 0.5 dp))))
			    )
			    (if (= (Connect.get CastaData satr-shtr) 1)
				(Traeger.set Tr_ID 	(delta_V 	(- delta_v_at 	(* 0.5 dp))))
			    )
			    (if (= (Connect.get CastaData vatr-shtr) 1)
				(Traeger.set Tr_ID 	(delta_LR (+ delta_lr_at 	(* 0.5 dp))))
			    )
			    (if (= (Connect.get CastaData vatr-shtr) -1)
				(Traeger.set Tr_ID 	(delta_LR (+ delta_lr_at 	(* 0.5 dp))))
			    )
			))
			(setq FlagSenkrecht 0)
			(if (= (Connect.get CastaData v-atrgewnkl_steg) 90.0) (if (= (Connect.get CastaData h-atrgewnkl_steg) 90.0) (setq FlagSenkrecht 1)))
;			(if (= (Connect.get CastaData vatr-lhtr)  0) (setq FlagSenkrecht 0))
	    		(if (= FlagSenkrecht 1) (progn
	    			(setq delta_LR_Ges 0.0)
				(if (= (Connect.get CastaData vatr-lhtr)  1)	(Traeger.set Tr_ID (delta_LR (+  delta_lr_at (* 0.5 dp)))))
				(if (= (Connect.get CastaData vatr-lhtr) -1)	(Traeger.set Tr_ID (delta_LR (+  delta_lr_at (* 0.5 dp)))))
				(if (= (Connect.get CastaData satr-lhtr)  1)	(Traeger.set Tr_ID (delta_V  (-  delta_v_at  (* 0.5 dp)))))
				(if (= (Connect.get CastaData satr-lhtr) -1)	(Traeger.set Tr_ID (delta_V  (-  delta_v_at  (* 0.5 dp)))))
	    		))
		)
	)
	
	(if (/= FlanschAnschluss "null")
		(progn
			(if (= (Connect.get CastaData satr-vhtr) -1)
				(Traeger.set Tr_ID 	(delta_V 	(- delta_v_at 	(* 0.5 dp))) 
														;(delta_LR (- delta_lr_at 	(* 0.5 b_Trg)))
				)
			)
			(if (= (Connect.get CastaData satr-vhtr) 1)
				(Traeger.set Tr_ID 	(delta_V 	(- delta_v_at 	(* 0.5 dp))) 
														;(delta_LR (- delta_lr_at 	(* 0.5 b_Trg)))
				)
			)
			(if (= (Connect.get CastaData satr-vhtr)  0)
				(progn
					(if (= (Connect.get CastaData vatr-shtr)  1)	
						(Traeger.set Tr_ID 	(delta_V 	(- delta_v_at 	(* 0.5 dp))))
					)
					(if (= (Connect.get CastaData vatr-shtr) -1)	
						(Traeger.set Tr_ID 	(delta_V 	(- delta_v_at 	(* 0.5 dp))))
					)
				)
			)
			(if (= (Connect.get CastaData satr-shtr) 1)
				(Traeger.set Tr_ID 	;(delta_V 	(+ delta_v_at 	(* 0.5 h_Trg))) 
							(delta_LR (+ delta_lr_at 	(* 0.5 dp)))
				)
			)
			(if (= (Connect.get CastaData satr-shtr) -1)
				(Traeger.set Tr_ID 	;(delta_V 	(+ delta_v_at 	(* 0.5 h_Trg))) 
							(delta_LR (+ delta_lr_at 	(* 0.5 dp)))
				)
			)
		)
	)
	
	
	
	(print "--------------------------------------------------------------------------------")		
)

; ----------------------------------------------------------------------
; ---------------------------------------------------------------------- 
(defun createKnotenBlech (Blech_ID l_schr rand_abst)
	(print "------------------------------------------------------------")
	(print "ERZEUGE KNOTENBLECH")
	  
  	; Default-Werte des Blechs
  	(Blech.set Blech_ID 	(dp 10)
      				(hp 200)
      				(bp 120)
  	)
  	(if (> lichterAbst 0.0) (Blech.set Blech_ID (dp lichterAbst)))
	
	; allg. Daten
	(setq	b_Trg   	(Traeger.get Tr_ID b)
		h_Trg	  	(Traeger.get Tr_ID h)
		RWinkel 	(Traeger.get Tr_ID R_Winkel)
		delta_v_at 	(Traeger.get Tr_ID delta_v)
		delta_lr_at	(Traeger.get Tr_ID delta_lr)
	)
	
	(setq delta_v_ht 	(Traeger.get Htrg delta_v)
				delta_lr_ht	(Traeger.get Htrg delta_lr)
	)
	
	(setq anschl_winkel (Connect.get CastaData at_laengswinkel))
	(print anschl_winkel)
	
	; wenn schrg, wird afl_winkel negativ ausgegeben ?????
	;(setq anschl_winkel (- anschl_winkel))
	
	(setq sinAW (sin (/ (* PI anschl_winkel) 180.0)))
	(print sinAW)
	
	
	(print RWinkel)
	(setq dp_knbl (Blech.get Blech_ID dp))
	(setq half_kbl (* 0.5 dp_knbl))
	(print half_kbl)
	  
  ; lokale Verschiebung des Windverbandes bestimmen
  (setq wv_versatz 0)
  
  ; +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  ; 1. Anschluss (es liegt noch kein Anschluss am Windverbandstab vor)
  ; +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  (calcFirstConnection)
	
	; +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  ; 2. Anschluss
  ; +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  ; Wenn der Traeger bereits angeschlossen ist, mu das zweite Blech versetzt werden 
  (if (> (Connect.get CastaData anschl_anderesEnde) 0)
		(progn
			(calcSecondConnection)
		)
  )
	
		
  (if (= FlanschAnschluss "oben") (progn
      (traeger.addabtl Htrg Blech_ID 0.0 0.0 _knotenblech_of_)  ;
  ))
  (if (= FlanschAnschluss "unten") (progn
      (traeger.addabtl Htrg Blech_ID 0.0 0.0 _knotenblech_uf_)  ;
  ))
  (if (= StegAnschluss "links") (progn
      (traeger.addabtl Htrg Blech_ID 0.0 0.0 _knotenblech_steg_li_)  ;    
  ))
  (if (= StegAnschluss "rechts") (progn
      (traeger.addabtl Htrg Blech_ID 0.0 0.0 _knotenblech_steg_re_)  ;    
  ))
  
  
  
	(setq xPosStz      (Connect.get CastaData xPos_HT))
  ;(setq WnklAnschlFl (Connect.get CastaData afl_vwinkel))
  
  ; Verschiebung des HT delta_v / delta_lr
	(calcXPosDelta_HT)
	(print "--------------------------------------------------- Fehlersuche xPosStz -1-")
	(print xPosStz)


	
	; Verschiebung des AT delta_v / delta_lr
	(calcXPosDelta_AT)
	(print "--------------------------------------------------- Fehlersuche xPosStz -2-")
	(print xPosStz)
	
	; Positionieren des Knotenbleches - verbessert AF 06-2008
	(positioniereKnotenblech) ; => xPos_delta
	(print "Untersuchung xPosstz - nderungen")
	(print xPosStz)
			
	(if (/= FlanschAnschluss "null")
				(progn
					(if (= FlanschAnschluss "oben")
						(progn
							(if (= (Connect.get castaData satr-lhtr)  1)	(setq xPosStz (+ xPosStz xPos_delta)))
							(if (= (Connect.get castaData satr-lhtr) -1)	(setq xPosStz (- xPosStz xPos_delta)))
							(if (= (Connect.get castaData vatr-lhtr)  1)	(setq xPosStz (- xPosStz xPos_delta)))
							(if (= (Connect.get castaData vatr-lhtr) -1)	(setq xPosStz (+ xPosStz xPos_delta)))
						)
					)
					(if (= FlanschAnschluss "unten")
						(progn
							(if (= (Connect.get castaData satr-lhtr)  1)	(setq xPosStz (+ xPosStz xPos_delta)))
							(if (= (Connect.get castaData satr-lhtr) -1)	(setq xPosStz (- xPosStz xPos_delta)))
							(if (= (Connect.get castaData vatr-lhtr)  1)	(setq xPosStz (- xPosStz xPos_delta)))
							(if (= (Connect.get castaData vatr-lhtr) -1)	(setq xPosStz (+ xPosStz xPos_delta)))
						)
					)
				)
	)
	(print "nach Flanschuntersuchung")
	(print xPosStz)
	
	(if (/= StegAnschluss "null") (progn
		(if (= StegAnschluss "links") (progn
			(if (= (Connect.get CastaData satr-vhtr)  0) (progn
				(if (= (Connect.get CastaData satr-lhtr)  1)	(setq xPosStz (+ xPosStz xPos_delta)))
				(if (= (Connect.get CastaData satr-lhtr) -1)	(setq xPosStz (- xPosStz xPos_delta)))
;;				(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq xPosStz (+ xPosStz xPos_delta)))
;;				(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq xPosStz (- xPosStz xPos_delta)))
			))
			(if (= (Connect.get CastaData vatr-vhtr)  0) (progn
;;				(if (= (Connect.get CastaData satr-lhtr)  1)	(setq xPosStz (+ xPosStz xPos_delta)))
;;				(if (= (Connect.get CastaData satr-lhtr) -1)	(setq xPosStz (- xPosStz xPos_delta)))
				(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq xPosStz (+ xPosStz xPos_delta)))
				(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq xPosStz (- xPosStz xPos_delta)))
			))
		))
		(if (= StegAnschluss "rechts") (progn
;;			(if (= (Connect.get CastaData vatr-vhtr)  0) (if (= (Connect.get CastaData satr-vhtr) 0) (print  "Sonderfall")))
		
			(if (= (Connect.get CastaData satr-vhtr)  0) (progn
				(if (= (Connect.get CastaData satr-lhtr)  1)	(setq xPosStz (+ xPosStz xPos_delta)))
				(if (= (Connect.get CastaData satr-lhtr) -1)	(setq xPosStz (- xPosStz xPos_delta)))
			  )
		  	  (progn
				(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq xPosStz (+ xPosStz xPos_delta)))
				(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq xPosStz (- xPosStz xPos_delta)))
			))
		))
	))
	(print "nach Steguntersuchung")
	(print xPosStz)
	
	; xPos setzen
	(setq AbtlKnBlech (traeger.get Htrg ABTeil Blech_ID))
 	(Anbauteil.set  AbtlKnBlech (xpos xPosStz))

	; d_schr berechnen	
	(if (/= FlanschAnschluss "null")
		(progn
			(if (= (Connect.get CastaData satr-shtr)  1) (setq d_schr (+ (* 0.5 h_Trg) rand_abst)))
			(if (= (Connect.get CastaData satr-shtr) -1) (setq d_schr (+ (* 0.5 h_Trg) rand_abst)))
			(if (= (Connect.get CastaData vatr-shtr)  1) (setq d_schr (+ (* 0.5 b_Trg) rand_abst)))
			(if (= (Connect.get CastaData vatr-shtr) -1) (setq d_schr (+ (* 0.5 b_Trg) rand_abst)))
		)
	)
	(if (/= StegAnschluss "null")
		(progn
			(if (= (Connect.get CastaData satr-shtr)  1) (setq d_schr (+ (* 0.5 b_Trg) rand_abst)))
			(if (= (Connect.get CastaData satr-shtr) -1) (setq d_schr (+ (* 0.5 b_Trg) rand_abst)))
			(if (= (Connect.get CastaData vatr-shtr)  1) (setq d_schr (+ (* 0.5 h_Trg) rand_abst)))
			(if (= (Connect.get CastaData vatr-shtr) -1) (setq d_schr (+ (* 0.5 h_Trg) rand_abst)))

			(if (= (Connect.get CastaData satr-vhtr)  1) (setq d_schr (+ (* 0.5 h_Trg) rand_abst)))
			(if (= (Connect.get CastaData satr-vhtr) -1) (setq d_schr (+ (* 0.5 h_Trg) rand_abst)))
			(if (= (Connect.get CastaData satr-lhtr)  1) (setq d_schr (+ (* 0.5 b_Trg) rand_abst)))
			(if (= (Connect.get CastaData satr-lhtr) -1) (setq d_schr (+ (* 0.5 b_Trg) rand_abst)))
		)
	)
	;(if (= (Connect.get CastaData satr-lhtr) -1) (setq d_schr (+ (* 0.5 h_Trg) rand_abst)))
	;(if (= (Connect.get CastaData satr-lhtr)  1) (setq d_schr (+ (* 0.5 h_Trg) rand_abst)))
	
	
	 ; Objekt.Methode          Variable     d_Schr   l_Schrb  SchrAchsWnkl
	(Blech.knotenblechschraeg Blech_ID   d_schr      l_schr       anschl_winkel)

	(print knotenblech_soll_versatz)
	
 	(Blech.set Blech_ID (delta_lr knotenblech_soll_versatz))
  												
 
	(print "ENDE KNOTENBLECH")
	(print "------------------------------------------------------------")
)

; ----------------------------------------------------------------------------------------
; Erzeugt das Lochbild
; wird fr STD 0 eingesetzt ....
; ----------------------------------------------------------------------------------------
(defun createLochbild (BlechID Lchb_ID rand_abst p_abstand_stz)
	(print "------------------------------------------------------------")
	(print  "ERZEUGE LOCHBILD")

	(Lochbild.set Lchb_ID 	
				(S_Bez 		"M16")
				(Guete		"4.6")
				(w		"0 0")
				(e		"0 0 0 0 0 0")
				(Anz_S		3)
				(dok 		0)
				;(dxSKopf	20)
				;(klemml		20)
				;(dvhtrg		50)
	)
	
	; allg. Daten
	(setq	dp_Blech 	(Blech.get BlechID dp)
		d_sch 		(Blech.get BlechID knbl_dschr)
		l_sch		(Blech.get BlechID knbl_lschr)
	)
	
	(setq	t_Trg 		(Traeger.get Tr_ID t)
		s_Trg		(Traeger.get Tr_ID s)
		b_Trg		(Traeger.get Tr_ID b)
		h_Trg		(Traeger.get Tr_ID h)
		r_winkel	(Traeger.get Tr_ID r_winkel)
		delta_lr_at	(Traeger.get Tr_ID delta_lr)
	)
	(setq	delta_v_ht	(Traeger.get Htrg delta_v)
		delta_lr_ht	(Traeger.get Htrg delta_lr)
	)
	
	; Klemmlnge
	(setq dicke_trg t_Trg)
	(setq klemml (+ dicke_trg dp_Blech))
	
	; dxSKopf Anschluss am Steg
	(if (/= StegAnschluss "null")
		(progn
			(if (= (Connect.get CastaData satr-vhtr)  1) (setq dxS (* 0.5 dp_blech)))
			(if (= (Connect.get CastaData satr-vhtr) -1) (setq dxS (+ (* 0.5 dp_blech) t_Trg)))
			(if (= (Connect.get CastaData vatr-vhtr)  1) (setq dxS (+ (* 0.5 dp_blech) t_Trg)))
			(if (= (Connect.get CastaData vatr-vhtr) -1) (setq dxS (* 0.5 dp_blech)))
			;(if (= (Connect.get CastaData satr-lhtr) -1) (setq dxS (+ (* 0.5 dp_blech) t_Trg)))
			;(if (= (Connect.get CastaData satr-lhtr)  1) (setq dxS (* 0.5 dp_blech)))				

	    	    	(setq FlagSenkrecht 0)
	            	(if (= (Connect.get CastaData v-atrgewnkl_steg) 90.0) (if (= (Connect.get CastaData h-atrgewnkl_steg) 90.0) (setq FlagSenkrecht 1)))
			; (if (= (Connect.get CastaData vatr-lhtr)  0) (setq FlagSenkrecht 0))
			(if (= FlagSenkrecht 1) (if (= (Connect.get CastaData rechtesEnde)  1) (setq FlagSenkrecht 2)))
	    		(if (= FlagSenkrecht 1) (progn
				(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq dxS (+ (* 0.5 dp_blech) t_Trg)))
				(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq dxS (* 0.5 dp_blech)))
				(if (= (Connect.get CastaData satr-lhtr) -1)	(setq dxS (+ (* 0.5 dp_blech) t_Trg)))
				(if (= (Connect.get CastaData satr-lhtr)  1)	(setq dxS (* 0.5 dp_blech)))
	    		))
	    		(if (= FlagSenkrecht 2) (progn
				(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq dxS (+ (* 0.5 dp_blech) t_Trg)))
				(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq dxS (* 0.5 dp_blech)))
				(if (= (Connect.get CastaData satr-lhtr)  1)	(setq dxS (+ (* 0.5 dp_blech) t_Trg)))
				(if (= (Connect.get CastaData satr-lhtr) -1)	(setq dxS (* 0.5 dp_blech)))
	    		))

		)
	)
			
	; dxSKopf Anschluss am Flansch
	(if (/= FlanschAnschluss "null")
		(progn
			(if (= (Connect.get CastaData satr-shtr)  1) (setq dxS (* 0.5 dp_blech)))
			(if (= (Connect.get CastaData satr-shtr) -1) (setq dxS (+ (* 0.5 dp_blech) t_Trg)))
			(if (= (Connect.get CastaData vatr-shtr)  1) (setq dxS (+ (* 0.5 dp_blech) t_Trg)))
			(if (= (Connect.get CastaData vatr-shtr) -1) (setq dxS (* 0.5 dp_blech)))		
		)
	)
	
	(print dxS)
	
	
		
	; Kontaktlnge zwichen AT und Knotenblech
	(setq afl_wnkl (Connect.get CastaData at_laengswinkel))
	
	(print afl_wnkl)
	(setq afl_wnkl (- afl_wnkl 90.0))
	(print afl_wnkl)
	(setq tan_afl	(tan (/ (* PI afl_wnkl) 180.0)))
	(print tan_afl)
	(if (< tan_afl 0) (setq tan_afl (- tan_afl)))
	(print tan_afl)
	(setq diff_1 (* rand_abst tan_afl))
	(print diff_1)
	(setq diff_2 (- p_abstand_stz diff_1))
	(print diff_2)
	(setq kontakt_laenge (- l_sch diff_2))
	(print kontakt_laenge)
	; e-Werte
	
	(setq e_abst (* 0.25 kontakt_laenge)) ; erstmal gleichmig verteilen 
	(print e_abst)
	
	(if (/= FlanschAnschluss "null")
		(progn
			(if (= (Connect.get CastaData satr-shtr)  1) (setq anteil_verbindung (* (* 0.5 h_Trg) tan_afl)))
			(if (= (Connect.get CastaData satr-shtr) -1) (setq anteil_verbindung (* (* 0.5 h_Trg) tan_afl)))
			(if (= (Connect.get CastaData vatr-shtr)  1) (setq anteil_verbindung (* (* 0.5 b_Trg) tan_afl)))
			(if (= (Connect.get CastaData vatr-shtr) -1) (setq anteil_verbindung (* (* 0.5 b_Trg) tan_afl)))
		)
	)
	(if (/= StegAnschluss "null")
		(progn
			(if (= (Connect.get CastaData satr-shtr)  1) (setq anteil_verbindung (* (* 0.5 b_Trg) tan_afl)))
			(if (= (Connect.get CastaData satr-shtr) -1) (setq anteil_verbindung (* (* 0.5 b_Trg) tan_afl)))
			(if (= (Connect.get CastaData vatr-shtr)  1) (setq anteil_verbindung (* (* 0.5 h_Trg) tan_afl)))
			(if (= (Connect.get CastaData vatr-shtr) -1) (setq anteil_verbindung (* (* 0.5 h_Trg) tan_afl)))

			(if (= (Connect.get CastaData satr-vhtr)  1) (setq anteil_verbindung (* (* 0.5 h_Trg) tan_afl)))
			(if (= (Connect.get CastaData satr-vhtr) -1) (setq anteil_verbindung (* (* 0.5 h_Trg) tan_afl)))
			(if (= (Connect.get CastaData satr-lhtr)  1) (setq anteil_verbindung (* (* 0.5 b_Trg) tan_afl)))
			(if (= (Connect.get CastaData satr-lhtr) -1) (setq anteil_verbindung (* (* 0.5 b_Trg) tan_afl)))
		)
	)
	(print anteil_verbindung)
	
	(if (/= StegAnschluss "null") (progn
		(setq	qsform_HT	(Traeger.get HTrg qsform))
		(setq	b_HT		(Traeger.get HTrg b))
		(if (= qsform_HT "K") (setq e_abst (+ e_abst (* tan_afl 0.5 b_HT))))
		(if (= qsform_HT "R") (setq e_abst (+ e_abst (* tan_afl 0.5 b_HT))))
	))
	
	(setq e0 (+ anteil_verbindung p_abstand_stz e_abst))
	(print e0)
	
	(if (/= StegAnschluss "null")
		(setq schrauben_versatz knotenblech_soll_versatz)
	)
	(print dxS)
	; Werte setzen
	(Lochbild.set Lchb_ID 	(klemml		klemml)
				(dxSKopf	dxS)
				(e0		e0)
				(e1 		(* 0.5 kontakt_laenge))
				;(e2		e_abst)
				; (delta_lr knotenblech_soll_versatz)
				; (dlr-Achse knotenblech_soll_versatz)
	)
	
	; Lochbild dem HT hinzufgen
	(setq AbtlKnoBl	(Traeger.get Htrg AbTeil BlechID))
	(Traeger.addabtl Htrg Lchb_ID 0.0 0.0 _knblLochbild_ AbtlKnoBl)
	
	(setq AbtlKnoBlLchb    (Traeger.get Htrg AbTeil Lchb_ID))
	(Anbauteil.set AbtlKnoBlLchb 	(Master 1)
					(delta_sx knotenblech_soll_versatz)
	)

	(print "ENDE LOCHBILD")
	(print "------------------------------------------------------------")
)



; ----------------------------------------------------------------------------------------
; Erzeugt das Lochbild im AT
; ----------------------------------------------------------------------------------------
(defun createATLochbild (Lchb_ID)
	(print ">-----------------------------------------------------------")
	(print "ERZEUGE LOCHBILD AM AT")

;	(Connect.showAttributes CastaData)
		
	(setq WINDVERBAND_LB 0)

	; Lochbildanbauteil whlen
	; ----------------------------------------------
	(setq WINDVERBAND_LB 0)
	(if (/= FlanschAnschluss "null")
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(progn
					; abgendert Dez 2014
					(if (= (Connect.get CastaData vatr-vhtr)  0) (progn
					    (if (/= (Connect.get CastaData vatr-shtr)  0)	(setq WINDVERBAND_LB _windvblchb_flansch_links_)	)
					))
					(if (= (Connect.get CastaData satr-vhtr)  0) (progn
					    (if (/= (Connect.get CastaData satr-shtr)  0)	(setq WINDVERBAND_LB _windvblchb_steg_links_)	)
					))
				)
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(progn
					; abgendert Dez 2014
					(if (= (Connect.get CastaData vatr-vhtr)  0) (progn
					    (if (/= (Connect.get CastaData vatr-shtr)  0)	(setq WINDVERBAND_LB _windvblchb_flansch_rechts_)	)
					))
					(if (= (Connect.get CastaData satr-vhtr)  0) (progn
					    (if (/= (Connect.get CastaData satr-shtr)  0)	(setq WINDVERBAND_LB _windvblchb_steg_rechts_)	)
					))
				)
			)
		)
	)
	(if (/= StegAnschluss "null")
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(progn
					; abgendert Dez 2014
					(if (= (Connect.get CastaData vatr-vhtr)  0) (progn
					    (if (/= (Connect.get CastaData vatr-shtr)  0)	(setq WINDVERBAND_LB _windvblchb_steg_links_)	)
					    (if (/= (Connect.get CastaData satr-vhtr)  0)	(setq WINDVERBAND_LB _windvblchb_steg_links_)	)
					))
					(if (= (Connect.get CastaData satr-vhtr)  0) (progn
					    (if (/= (Connect.get CastaData satr-shtr)  0)	(setq WINDVERBAND_LB _windvblchb_flansch_links_)	)
					    (if (/= (Connect.get CastaData vatr-vhtr)  0)	(setq WINDVERBAND_LB _windvblchb_flansch_links_)	)
					))
				)
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(progn
					; abgendert Dez 2014
					(if (= (Connect.get CastaData vatr-vhtr)  0) (progn
					    (if (/= (Connect.get CastaData vatr-shtr)  0)	(setq WINDVERBAND_LB _windvblchb_steg_rechts_)	)
					    (if (/= (Connect.get CastaData satr-vhtr)  0)	(setq WINDVERBAND_LB _windvblchb_steg_rechts_)	)
					))
					(if (= (Connect.get CastaData satr-vhtr)  0) (progn
					    (if (/= (Connect.get CastaData satr-shtr)  0)	(setq WINDVERBAND_LB _windvblchb_flansch_rechts_)	)
					    (if (/= (Connect.get CastaData vatr-vhtr)  0)	(setq WINDVERBAND_LB _windvblchb_flansch_rechts_)	)
					))
				)
			)
		)
	)
	
	(if (= WINDVERBAND_LB 0) 
	    (alertBox "Dieses Anschluss-Makro ist fr den vorliegenden Fall nicht vorgesehen!"  "ERR_MacroNotDesignated")
	)

	; delta-Werte der Anbauteile
	; ++++++++++++++++++++++++++++++++++++++++++++++
	(setq	h_at	(Traeger.get Tr_ID h)
		b_at	(Traeger.get Tr_ID b)
	)
	(print h_at)
	(print b_at)
	
	(setq delta_v_abtl_at 0)
	(setq delta_lr_abtl_at 0)
	
	; Positionierung Anbauteil (delta_lr Anbauteil) (halbe AT Breite/Hhe)
	; ----------------------------------------------
    (if (= 1 1)	(progn
	; ----------------------------------------------
	(print "Positionierung des Anbauteils (delta_lr)")
	(if (/= FlanschAnschluss "null")
		(progn
			(if (= (Connect.get CastaData satr-shtr)  1)	(setq delta_lr_abtl_at L_Abst_H))	;(* 0.5 h_at)
			(if (= (Connect.get CastaData satr-shtr) -1)	(setq delta_lr_abtl_at L_Abst_H))	;(* 0.5 h_at)
			(if (= (Connect.get CastaData vatr-shtr)  1)	(setq delta_lr_abtl_at L_Abst_B))	;(* 0.5 b_at)
			(if (= (Connect.get CastaData vatr-shtr) -1)	(setq delta_lr_abtl_at L_Abst_B))	;(* 0.5 b_at)
			
			
			(if (= (Connect.get CastaData linkesEnde) 1)
				(progn
					(if (= (Connect.get CastaData satr-shtr)  1)	(setq delta_lr_abtl_at delta_lr_abtl_at))
					(if (= (Connect.get CastaData satr-shtr) -1)	(setq delta_lr_abtl_at delta_lr_abtl_at))
					(if (= (Connect.get CastaData vatr-shtr)  1)	(setq delta_lr_abtl_at (- delta_lr_abtl_at)))
					(if (= (Connect.get CastaData vatr-shtr) -1)	(setq delta_lr_abtl_at (- delta_lr_abtl_at)))
				)
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(progn
					(if (= (Connect.get CastaData satr-shtr)  1)	(setq delta_lr_abtl_at (- delta_lr_abtl_at)))
					(if (= (Connect.get CastaData satr-shtr) -1)	(setq delta_lr_abtl_at (- delta_lr_abtl_at)))
					(if (= (Connect.get CastaData vatr-shtr)  1)	(setq delta_lr_abtl_at delta_lr_abtl_at))
					(if (= (Connect.get CastaData vatr-shtr) -1)	(setq delta_lr_abtl_at delta_lr_abtl_at))
				)
			)
		)
	)

	(if (/= StegAnschluss "null")
		(progn


			(if (= (Connect.get CastaData vatr-shtr)  1)	(setq delta_lr_abtl_at L_Abst_H))	;(* 0.5 h_at)
			(if (= (Connect.get CastaData vatr-shtr) -1)	(setq delta_lr_abtl_at L_Abst_H))	;(* 0.5 h_at)
			(if (= (Connect.get CastaData satr-shtr)  1)	(setq delta_lr_abtl_at L_Abst_B))	;(* 0.5 b_at)
			(if (= (Connect.get CastaData satr-shtr) -1)	(setq delta_lr_abtl_at L_Abst_B))	;(* 0.5 b_at)

			(setq FlagSenkrecht 0)
			(if (= (Connect.get CastaData v-atrgewnkl_steg) 90.0) (if (= (Connect.get CastaData h-atrgewnkl_steg) 90.0) (setq FlagSenkrecht 1)))
;			(if (= (Connect.get CastaData vatr-lhtr)  0)	(setq FlagSenkrecht 0))
	    		(if (= FlagSenkrecht 1) (progn
				(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_lr_abtl_at L_Abst_H))
				(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_lr_abtl_at L_Abst_H))
				(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta_lr_abtl_at (- L_Abst_B)))
				(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta_lr_abtl_at (- L_Abst_B)))

				(if (= (Connect.get CastaData rechtesEnde) 1)  (setq delta_lr_abtl_at (- delta_lr_abtl_at)))
	    		))

			
			
			(if (= (Connect.get CastaData linkesEnde) 1)
				(progn
					(if (= (Connect.get CastaData vatr-shtr)  1)	(setq delta_lr_abtl_at delta_lr_abtl_at))
					(if (= (Connect.get CastaData vatr-shtr) -1)	(setq delta_lr_abtl_at delta_lr_abtl_at))
					(if (= (Connect.get CastaData satr-shtr)  1)	(setq delta_lr_abtl_at (- delta_lr_abtl_at)))
					(if (= (Connect.get CastaData satr-shtr) -1)	(setq delta_lr_abtl_at (- delta_lr_abtl_at)))
				)
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(progn
					(if (= (Connect.get CastaData vatr-shtr)  1)	(setq delta_lr_abtl_at (- delta_lr_abtl_at)))
					(if (= (Connect.get CastaData vatr-shtr) -1)	(setq delta_lr_abtl_at (- delta_lr_abtl_at)))
					(if (= (Connect.get CastaData satr-shtr)  1)	(setq delta_lr_abtl_at delta_lr_abtl_at))
					(if (= (Connect.get CastaData satr-shtr) -1)	(setq delta_lr_abtl_at delta_lr_abtl_at))
				)
			)
		)
	)
	(print delta_lr_abtl_at)
	; ----------------------------------------------
    ))	
	; ----------------------------------------------
	
	
	
	
	
	
	; Einfluss durch Verschiebung des HT
	; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	
	; Anteil delta_v HT
	; ----------------------------------------------
	(if (= 1 1)	(progn
	; ----------------------------------------------
		(if (/= FlanschAnschluss "null")
			(progn
				(setq delta_v_ht	(Traeger.get Htrg delta_v))
				(print delta_v_ht)
				
				(setq at_winkel (Connect.get CastaData at_laengswinkel))
				(print at_winkel)
				
				(setq cosW (cos (/ (* PI at_winkel) 180.0)))
				(setq sinW (sin (/ (* PI at_winkel) 180.0)))
				(print cosW)
				(print sinW)
				
				;(if (/= cosW 0.0)
				;	(setq anteil_delta_v_abtl_ht (/ (* 1.0 delta_v_ht) cosW))
				;)
				(if (/= sinW 0.0)
					(setq anteil_delta_v_abtl_ht (/ (* 1.0 delta_v_ht) sinW))
				)
				(print anteil_delta_v_abtl_ht)
				
				(if (> at_winkel 90.0)
					(setq delta_v_abtl_at (- anteil_delta_v_abtl_ht))
					(setq delta_v_abtl_at anteil_delta_v_abtl_ht)
				)
				(print delta_v_abtl_at)
				
				(if (> at_winkel 90.0)
					(if (= FlanschAnschluss "oben") 	(setq delta_v_abtl_at (+ delta_v_abtl_at)))
					(if (= FlanschAnschluss "oben") 	(setq delta_v_abtl_at (- delta_v_abtl_at)))
				)
				
				(if (> at_winkel 90.0)
					(if (= FlanschAnschluss "unten") 	(setq delta_v_abtl_at (- delta_v_abtl_at)))
					(if (= FlanschAnschluss "unten") 	(setq delta_v_abtl_at (+ delta_v_abtl_at)))
				)
				(print delta_v_abtl_at)
				
				
			)
		)
	; ----------------------------------------------
	))
	; ----------------------------------------------
	
	
	; Anteil delta_lr HT
	; ----------------------------------------------
	(if (= 1 1)	(progn
	; ----------------------------------------------
	        (setq anteil_delta_lr_abtl_ht 0.0)
		(if (/= StegAnschluss "null")
			(progn
				(setq delta_lr_ht	(Traeger.get Htrg delta_lr))
				(print delta_lr_ht)
				(setq at_winkel (Connect.get CastaData at_laengswinkel))
				(setq cosW (cos (/ (* PI at_winkel) 180.0)))
				(print cosW)

				(setq tanW (tan (/ (* PI at_winkel) 180.0)))
				(setq sinW (sin (/ (* PI at_winkel) 180.0)))

				; Gendert - August 2012 - cosW durch sinW ersetzt.
				; (if (/= cosW 0.0)
				; 	(setq anteil_delta_lr_abtl_ht (/ (* 1.0 delta_lr_ht) cosW))
				; )
				(if (/= sinW 0.0)
				    (setq anteil_delta_lr_abtl_ht (/ (* 1.0 delta_lr_ht) (- sinW)))
				)
				(print anteil_delta_lr_abtl_ht)
				
				(if (> at_winkel 90.0)
					(setq delta_v_abtl_at (- anteil_delta_lr_abtl_ht))
					(setq delta_v_abtl_at anteil_delta_lr_abtl_ht)
				)
				(print delta_v_abtl_at)
				
				(if (> at_winkel 90.0) (progn (if (= StegAnschluss "links")
						 	(setq delta_v_abtl_at (- delta_v_abtl_at))
				)))
				(if (< at_winkel 90.0) (progn (if (= StegAnschluss "rechts")
						 	(setq delta_v_abtl_at (- delta_v_abtl_at))
				)))
				
				(print delta_v_abtl_at)
			)
		)
	(print delta_v_abtl_at)
	; ----------------------------------------------
	))
	; ----------------------------------------------
	
	
	
	; Einfluss durch Verschiebung des AT
	; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	
	
	; Anteil Verschiebung delta_v AT
	; ----------------------------------------------
	(if (= 1 1)	(progn
	; ----------------------------------------------
	(print "delta Verschiebungen AT")
	(print "--------------------------------------------------------------------------------")
	(setq	delta_v_at (Traeger.get Tr_ID  delta_v)
		delta_lr_at (Traeger.get Tr_ID delta_lr)
	)
	(print delta_v_at)
	(print delta_lr_at)
	(print delta_lr_abtl_at)
	
	(print at_winkel)
	(setq tanW (tan (/ (* PI at_winkel) 180.0)))
	(print tanW)


	
	(if (/= FlanschAnschluss "null")
		(progn
			(if (= (Connect.get CastaData rechtesEnde) 1)	(setq anteil_delta_v_at (/ (+ (* 1.0 delta_v_at) delta_lr_abtl_at) tanW)))
			(if (= (Connect.get CastaData linkesEnde) 1)	(setq anteil_delta_v_at (/ (- (* 1.0 delta_v_at) delta_lr_abtl_at) tanW)))
		)
	)
	(if (/= StegAnschluss "null")
		(progn
			(if (= (Connect.get CastaData rechtesEnde) 1)	(setq anteil_delta_v_at (/ (+ (* 1.0 delta_v_at) delta_lr_abtl_at) tanW)))
			(if (= (Connect.get CastaData linkesEnde) 1)	(setq anteil_delta_v_at (/ (- (* 1.0 delta_v_at) delta_lr_abtl_at) tanW)))
		)
	)
	(print anteil_delta_v_at)
	
	(print delta_v_abtl_at)


	
	(if (/= FlanschAnschluss "null")
		(progn
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_v_abtl_at (- delta_v_abtl_at anteil_delta_v_at))	)
					(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_v_abtl_at (+ delta_v_abtl_at anteil_delta_v_at))	)
				)
			)
			
			(if (= (Connect.get CastaData linkesEnde) 1)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_v_abtl_at (+ delta_v_abtl_at anteil_delta_v_at))	)
					(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_v_abtl_at (- delta_v_abtl_at anteil_delta_v_at))	)
				)
			)
		)
	)
	
	
	(if (/= StegAnschluss "null")
		(progn
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_v_abtl_at (- delta_v_abtl_at anteil_delta_v_at))	)
					(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_v_abtl_at (+ delta_v_abtl_at anteil_delta_v_at))	)
				)
			)
			
			(if (= (Connect.get CastaData linkesEnde) 1)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_v_abtl_at (+ delta_v_abtl_at anteil_delta_v_at))	)
					(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_v_abtl_at (- delta_v_abtl_at anteil_delta_v_at))	)
				)
			)
		)
	)
	(print delta_v_abtl_at)
	; ----------------------------------------------
	))	
	; ----------------------------------------------
	
	
	; Anteil Verschiebung delta_lr AT
	; ----------------------------------------------
	(if (= 1 1) (progn
	; ----------------------------------------------
	(print "--------------------------------------------------------------------------------")
	
	
	
	(if (= (Connect.get CastaData linkesEnde) 1)	
		(setq anteil_delta_lr_abtl_at (/ (- (* 1.0 delta_lr_at) delta_lr_abtl_at) tanW))
	)
	(if (= (Connect.get CastaData rechtesEnde) 1)	
		(setq anteil_delta_lr_abtl_at (/ (+ (* 1.0 delta_lr_at) delta_lr_abtl_at) tanW))
	)

	
	
	(if (/= FlanschAnschluss "null")
		(progn
			; delta_lr AT
			(print "ANTEIL delta_lr AT")
			(if (= (Connect.get CastaData linkesEnde) 1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)
						(progn
							(if (= (Connect.get CastaData vatr-shtr)  1)	(setq delta_v_abtl_at (+ delta_v_abtl_at anteil_delta_lr_abtl_at))	)
							(if (= (Connect.get CastaData vatr-shtr) -1)	(setq delta_v_abtl_at (+ delta_v_abtl_at anteil_delta_lr_abtl_at))	)
						)
					)
					(if (= (Connect.get CastaData satr-lhtr) -1)
						(progn
							(if (= (Connect.get CastaData vatr-shtr)  1)	(setq delta_v_abtl_at (- delta_v_abtl_at anteil_delta_lr_abtl_at))	)
							(if (= (Connect.get CastaData vatr-shtr) -1)	(setq delta_v_abtl_at (- delta_v_abtl_at anteil_delta_lr_abtl_at))	)
						)
					)
				)
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)
						(progn
							(if (= (Connect.get CastaData vatr-shtr)  1)	(setq delta_v_abtl_at (+ delta_v_abtl_at anteil_delta_lr_abtl_at))	)
							(if (= (Connect.get CastaData vatr-shtr) -1)	(setq delta_v_abtl_at (+ delta_v_abtl_at anteil_delta_lr_abtl_at))	)
						)
					)
					(if (= (Connect.get CastaData satr-lhtr) -1)
						(progn
							(if (= (Connect.get CastaData vatr-shtr)  1)	(setq delta_v_abtl_at (- delta_v_abtl_at anteil_delta_lr_abtl_at))	)
							(if (= (Connect.get CastaData vatr-shtr) -1)	(setq delta_v_abtl_at (- delta_v_abtl_at anteil_delta_lr_abtl_at))	)
						)
					)
				)
			)
			(print delta_v_abtl_at)
		)
	)
	(if (/= StegAnschluss "null")
		(progn
			; delta_lr AT
			(print "ANTEIL delta_lr AT")
			
			(if (= (Connect.get CastaData linkesEnde) 1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)
						(progn
							(if (= (Connect.get CastaData vatr-vhtr)  1)	(setq delta_v_abtl_at (+ delta_v_abtl_at anteil_delta_lr_abtl_at))	)
							(if (= (Connect.get CastaData vatr-vhtr) -1)	(setq delta_v_abtl_at (+ delta_v_abtl_at anteil_delta_lr_abtl_at))	)
						)
					)
					(if (= (Connect.get CastaData satr-lhtr) -1)
						(progn
							(if (= (Connect.get CastaData vatr-vhtr)  1)	(setq delta_v_abtl_at (- delta_v_abtl_at anteil_delta_lr_abtl_at))	)
							(if (= (Connect.get CastaData vatr-vhtr) -1)	(setq delta_v_abtl_at (- delta_v_abtl_at anteil_delta_lr_abtl_at))	)
						)
					)
				)
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)
						(progn
							(if (= (Connect.get CastaData vatr-vhtr)  1)	(setq delta_v_abtl_at (+ delta_v_abtl_at anteil_delta_lr_abtl_at))	)
							(if (= (Connect.get CastaData vatr-vhtr) -1)	(setq delta_v_abtl_at (+ delta_v_abtl_at anteil_delta_lr_abtl_at))	)
						)
					)
					(if (= (Connect.get CastaData satr-lhtr) -1)
						(progn
							(if (= (Connect.get CastaData vatr-vhtr)  1)	(setq delta_v_abtl_at (- delta_v_abtl_at anteil_delta_lr_abtl_at))	)
							(if (= (Connect.get CastaData vatr-vhtr) -1)	(setq delta_v_abtl_at (- delta_v_abtl_at anteil_delta_lr_abtl_at))	)
						)
					)
				)
			)
			(print delta_v_abtl_at)
		)
	)
	; ----------------------------------------------
	))
	; ----------------------------------------------
	
	

	
	
	
	; Anbauteil hinzufgen
	; ----------------------------------------------
	(Traeger.addabtl Tr_ID Lchb_ID 0.0 0.0 WINDVERBAND_LB)
		
	(setq AbtlKnoBlLchbAT    (Traeger.get Tr_ID AbTeil Lchb_ID))
	
	(print delta_v_abtl_at)
	(print delta_lr_abtl_at)
	

	(Anbauteil.set AbtlKnoBlLchbAT 	(Master 0)
					(delta_lr delta_lr_abtl_at)
					(delta_v 	delta_v_abtl_at)
	)
	
	
	
	; TEST
	; +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	(if (= LB_DEBUG 1)
		(progn
			(setq LB_DUMMY (Lochbild.create))
			(Lochbild.copy LB_DUMMY Lchb_ID)
			(Traeger.addabtl Tr_ID LB_DUMMY 0.0 0.0 WINDVERBAND_LB)
			(setq AbtlKnoBlLchbAT_DUMMY    (Traeger.get Tr_ID AbTeil LB_DUMMY))
			(Anbauteil.set AbtlKnoBlLchbAT_DUMMY 	(Master 1)
																						(delta_lr delta_lr_abtl_at)
																						(delta_v 	delta_v_abtl_at)
			)
				
			(Connect.storeAnschlObjs CastaData LB_DUMMY)
		)
	)
	; +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	(print "<-----------------------------------------------------------")
)



; ----------------------------------------------------------------------------------------
; Berechnet die Position des Knotenbleches entlang des Stegs fr den 1. Anschluss
; ----------------------------------------------------------------------------------------
(defun calcFirstConnection ()
	(print "BERECHNE ERSTEN ANSCHLUSS")
	; Korrektur aus Verschiebung delta_lr bzw. delta_v des AT ANSCHLUSS AM STEG
	(print delta_v_at)
	(print delta_lr_at)

  	(setq	dp_KnoBl (Blech.get knotenBlech dp)
  		dp_KnoBl (* 0.5 dp_KnoBl)
  	)

	(setq at_verschiebung 0)
	(if (/= StegAnschluss "null")
		(progn
			(if (= (Connect.get CastaData satr-vhtr) -1) (setq at_verschiebung (+ (- delta_lr_at) dp_KnoBl)))
			(if (= (Connect.get CastaData satr-vhtr)  1) (setq at_verschiebung (- delta_lr_at dp_KnoBl)))
			(if (= (Connect.get CastaData vatr-vhtr) -1) (setq at_verschiebung (- (- delta_v_at) dp_KnoBl)))
			(if (= (Connect.get CastaData vatr-vhtr)  1) (setq at_verschiebung (+    delta_v_at  dp_KnoBl)))
		)
	)
	(if (/= FlanschAnschluss "null")
		(progn
			(if (= (Connect.get CastaData satr-shtr)  1) (setq at_verschiebung delta_lr_at))
			(if (= (Connect.get CastaData satr-shtr) -1) (setq at_verschiebung (- delta_lr_at)))
			(if (= (Connect.get CastaData vatr-shtr)  1) (setq at_verschiebung delta_v_at))
			(if (= (Connect.get CastaData vatr-shtr) -1) (setq at_verschiebung (- delta_v_at)))
		)
	)
  
 	(print at_verschiebung)
  
  ; Knotenblech Verschiebung aus AT-Verschiebung
	(setq knotenblech_soll_versatz at_verschiebung)
	
	(setq schrauben_versatz knotenblech_soll_versatz)
	
	; Knotenblech Verschiebung aus HT-Verschiebung
	(if (/= FlanschAnschluss "null")
		(progn
			(setq knotenblech_soll_versatz (- knotenblech_soll_versatz delta_lr_ht))
		)
	)
	(if (/= StegAnschluss "null")
		(progn
			(setq knotenblech_soll_versatz (- knotenblech_soll_versatz delta_v_ht))
		)
	)
	(print  knotenblech_soll_versatz)
	(print "ENDE ERSTER ANSCHLUSS")
)



; ----------------------------------------------------------------------------------------
; Berechnet die Position des Knotenbleches entlang des Stegs fr den 2. Anschluss
; ----------------------------------------------------------------------------------------
(defun calcSecondConnection ()
	(print "BERECHNE ZWEITEN ANSCHLUSS")
	(print "TRGER IST BEREITS FIXIERT.")
	(print knotenblech_soll_versatz)
	(print half_kbl)
	; AM HT-STEG RECHTS
	(setq   half_kbl 0) ; 	Soll nichts verschoben werden
	
	(if (/= StegAnschluss "null")
		(progn
			(if (= (Connect.get CastaData vatr-vhtr)  1) (setq knotenblech_soll_versatz (+ knotenblech_soll_versatz half_kbl)))
			(if (= (Connect.get CastaData vatr-vhtr) -1) (setq knotenblech_soll_versatz (- knotenblech_soll_versatz half_kbl)))
			(if (= (Connect.get CastaData satr-vhtr)  1) (setq knotenblech_soll_versatz (- knotenblech_soll_versatz half_kbl)))
			(if (= (Connect.get CastaData satr-vhtr) -1) (setq knotenblech_soll_versatz (+ knotenblech_soll_versatz half_kbl)))
		)
	)
	(if (/= FlanschAnschluss "null")
		(progn
			(if (= (Connect.get CastaData satr-shtr)  1) (setq knotenblech_soll_versatz (- knotenblech_soll_versatz half_kbl)))
			(if (= (Connect.get CastaData satr-shtr) -1) (setq knotenblech_soll_versatz (+ knotenblech_soll_versatz half_kbl)))
			(if (= (Connect.get CastaData vatr-shtr)  1) (setq knotenblech_soll_versatz (+ knotenblech_soll_versatz half_kbl)))
			(if (= (Connect.get CastaData vatr-shtr) -1) (setq knotenblech_soll_versatz (- knotenblech_soll_versatz half_kbl)))
		)
	)
		
	(print knotenblech_soll_versatz)
	(print "ENDE ZWEITER ANSCHLUSS")
)



; ----------------------------------------------------------------------------------------
; Berechnet die Auswirkungen auf die XPos des Knotenbleches bei einer Verschiebung
; des HT in Richtung delta_v
; ----------------------------------------------------------------------------------------
(defun calcXPosDelta_HT ()
	(print "------------------------------------------------------------")
	(print "BERECHNE DELTA_HT AUSWIRKUNG")
	
	(setq Winkel (connect.get CastaData at_laengswinkel))
	
	(setq Winkel (- 90.0 Winkel))
	(setq tanW (tan (/ (* PI Winkel) 180.0)))
	
	(print Winkel)
	(print tanW)
	
	(print xPosStz)
	
	(if (/= FlanschAnschluss "null")
		(progn
			(setq deltaXPos (* delta_v_ht tanW))
			(print deltaXPos)
	
			(if (= FlanschAnschluss "unten")
				(setq xPosStz (+ xPosStz deltaXPos))
			)
			(if (= FlanschAnschluss "oben")
				(setq xPosStz (- xPosStz deltaXPos))
			)
		)
	)
	(if (/= StegAnschluss "null")
		(progn
			(setq knotenblech_final_versatz (- knotenblech_soll_versatz delta_lr_ht))
			(setq deltaXPos (* delta_lr_ht tanW))
			(print deltaXPos)
	
			(if (= StegAnschluss "links")
				(setq xPosStz (- xPosStz deltaXPos))
			)
			(if (= StegAnschluss "rechts")
				(setq xPosStz (+ xPosStz deltaXPos))
			)
		)
	)
	(print xPosStz)
	(print "--------------------------------------------------------ENDE")
)




(defun calcXPosDelta_AT ()
	(print "------------------------------------------------------------")
	(print "BERECHNE DELTA_AT AUSWIRKUNG")
	; xPos berechnen und setzen
	(print xPosStz)
	
	(setq	h_Trg (Traeger.get Tr_ID h)
		b_Trg	(Traeger.get Tr_ID b)
	)
	
	(setq Winkel (connect.get CastaData at_laengswinkel))
	(setq sinAW (sin (/ (* PI Winkel) 180.0)))
	(print Winkel)
	
	(setq anteil_aus_delta_v (/ delta_v_at sinAW))
	(setq anteil_aus_delta_lr (/ delta_lr_at sinAW))
	(print anteil_aus_delta_v)
	(print anteil_aus_delta_lr)
	
	(if (/= StegAnschluss "null")
		(progn
			(if (= (Connect.get CastaData vatr-vhtr)  1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq xPosStz (+ xPosStz anteil_aus_delta_lr)))
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq xPosStz (- xPosStz anteil_aus_delta_lr)))
				)
			)
			(if (= (Connect.get CastaData vatr-vhtr) -1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq xPosStz (+ xPosStz anteil_aus_delta_lr)))
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq xPosStz (- xPosStz anteil_aus_delta_lr)))
				)
			)
			(if (= (Connect.get CastaData satr-vhtr)  1)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq xPosStz (+ xPosStz anteil_aus_delta_v)))
					(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq xPosStz (- xPosStz anteil_aus_delta_v)))
				)
			)
			(if (= (Connect.get CastaData satr-vhtr) -1)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq xPosStz (+ xPosStz anteil_aus_delta_v)))
					(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq xPosStz (- xPosStz anteil_aus_delta_v)))
				)
			)
			
		)
	)


	
	(if (/= FlanschAnschluss "null")
		(progn
			(if (= (Connect.get CastaData satr-shtr)  1)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq xPosStz (+ xPosStz anteil_aus_delta_v)))
					(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq xPosStz (- xPosStz anteil_aus_delta_v)))
				)
			)
			(if (= (Connect.get CastaData satr-shtr) -1)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq xPosStz (+ xPosStz anteil_aus_delta_v)))
					(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq xPosStz (- xPosStz anteil_aus_delta_v)))
				)
			)
			(if (= (Connect.get CastaData vatr-shtr)  1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq xPosStz (+ xPosStz anteil_aus_delta_lr)))
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq xPosStz (- xPosStz anteil_aus_delta_lr)))
				)
			)
			(if (= (Connect.get CastaData vatr-shtr) -1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq xPosStz (+ xPosStz anteil_aus_delta_lr)))
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq xPosStz (- xPosStz anteil_aus_delta_lr)))
				)
			)
			
		)
	)
	
	(setq h_Trg_halb (* 0.5 h_Trg))
  	
	
	(print xPosStz)
	(print "--------------------------------------------------------ENDE")
)








; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
; ----------------------------------------------------------------------------------------
; VARIANTE 2
; ----------------------------------------------------------------------------------------
; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++


; ----------------------------------------------------------------------------------------
; Erzeugt das Knotenblech fr Variante 2
; ----------------------------------------------------------------------------------------
(defun manualKnotenBlechCreation (Lchb_ID)
	(print ">-----------------------------------------------------------")
	(print "BERECHNE KNOTENBLECH VAR_2")
	(setq	h_ht		(Traeger.get Htrg h)
		delta_v_ht	(Traeger.get Htrg delta_v)
		delta_lr_ht	(Traeger.get Htrg delta_lr)
	)
	(setq h_ht_halb (* 0.5 h_ht))
	
	(setq	h_at		(Traeger.get Tr_ID h)
		b_at		(Traeger.get Tr_ID b)
		delta_v_at	(Traeger.get Tr_ID delta_v)
		delta_lr_at	(Traeger.get Tr_ID delta_lr)
	)
	
	(setq	at_winkel	(Connect.get CastaData at_laengswinkel)
		xPos_ht		(Connect.get CastaData xPos_ht)
	)
	(print xPos_ht)
	
	(setq lb_e0 (Lochbild.get Lchb_ID e0))
	
	(setq tanATW (tan (/ (* PI at_winkel) 180.0)))
	(setq sinATW (sin (/ (* PI at_winkel) 180.0)))
	
	;(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq bp_blech (* 1.67 h_at)))
	;(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq bp_blech (* 1.67 h_at)))
	;(if (= (Connect.get CastaData satr-lhtr)  1)	(setq bp_blech (* 1.67 b_at)))
	;(if (= (Connect.get CastaData satr-lhtr) -1)	(setq bp_blech (* 1.67 b_at)))
	
	(setq lb_rand_abst (* 1.3 (* 0.5 h_at))) ; TODO: Rotation AT evtl. noch beachten 
	(setq lb_stz_abst (* lb_e0 sinATW))
	(print lb_stz_abst)

	(setq bp_blech (+ lb_rand_abst lb_stz_abst))
	(setq bp_blech_rund (runde bp_blech auf 5.0))
	
	(setq hp_blech (* 1.2 bp_blech_rund))
	(setq hp_blech_rund (runde hp_blech auf 5.0))
	
	(setq help_1 (+ h_ht_halb bp_blech_rund))
	
	(setq help_2 (/ help_1 tanATW))
	
	; Blechecken
	(if (> at_winkel 90.0)
		(progn
			(setq y4_blech (* 0.5 bp_blech_rund))
			(setq x4_blech (- (/ y4_blech tanATW)))
			
			(setq x1_blech 0.0)
			(setq y1_blech 0.0)
		)
	)
	(if (< at_winkel 90.0)
		(progn
			(setq x4_blech 0.0)
			(setq y4_blech 0.0)
			
			(setq y1_blech (* 0.5 bp_blech_rund))
			(setq x1_blech (/ y1_blech tanATW))
		)
	)
	(if (= at_winkel 90.0)
		(progn
			(setq x4_blech 0.0)
			(setq y4_blech 0.0)
			(setq x1_blech 0.0)
			(setq y1_blech 0.0)
		)
	)
	
	(setq dok_blech (* 0.5 (- hp_blech_rund bp_blech_rund)))
	(if (> at_winkel 90.0)
		(setq dok_blech (- dok_blech))
	)
	(if (= at_winkel 90.0)
		(setq dok_blech 0.0)
	)
	
  ; Default-Werte des Blechs
  	(Blech.set knotenBlech 	(dp 	10)
      				(hp 	hp_blech_rund)
      				(bp 	bp_blech_rund)
      				(dok 	dok_blech)
      				(x1 	x1_blech)
      				(y1 	y1_blech)
      				(x4 	x4_blech)
      				(y4 	y4_blech)
	)
    	(if (> lichterAbst 0.0) (Blech.set knotenBlech (dp lichterAbst)))

  
  (setq dp_knbl (Blech.get knotenBlech dp))
  (setq half_kbl (* 0.5 dp_knbl))
  
  ; +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  ; 1. Anschluss (es liegt noch kein Anschluss am Windverbandstab vor)
  ; +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  (calcFirstConnection)
	
	; +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  ; 2. Anschluss
  ; +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  ; Wenn der Traeger bereits angeschlossen ist, mu das zweite Blech versetzt werden 
	(if (> (Connect.get CastaData anschl_anderesEnde) 0)
		(progn
			(calcSecondConnection)
		)
	)
  
  
  
  ; xPos Knotenblech
  ; ----------------------------------------------
	;(if (> at_winkel 90.0) 
	;	(setq xPos_ht (+ xPos_ht (+ help_2 (* 0.5 hp_blech_rund))))
	;	(setq xPos_ht (+ xPos_ht (- help_2 (* 0.5 hp_blech_rund))))
	;)
	(print xPos_ht)
	

  
  (if (= FlanschAnschluss "oben") (progn
      (traeger.addabtl Htrg knotenBlech xPos_ht 0.0 _knotenblech_of_)  ;
  ))
  (if (= FlanschAnschluss "unten") (progn
      (traeger.addabtl Htrg knotenBlech xPos_ht 0.0 _knotenblech_uf_)  ;
  ))
  (if (= StegAnschluss "links") (progn
      (traeger.addabtl Htrg knotenBlech xPos_ht 0.0 _knotenblech_steg_li_)  ;    
  ))
  (if (= StegAnschluss "rechts") (progn
      (traeger.addabtl Htrg knotenBlech xPos_ht 0.0 _knotenblech_steg_re_)  ;    
  ))
  
  
  
  ;(setq xPosStz      (Connect.get CastaData xPos_HT))
  ;(setq WnklAnschlFl (Connect.get CastaData afl_vwinkel))
  (setq xPosStz xPos_ht)
  
  ; Verschiebung des HT delta_v / delta_lr
	(calcXPosDelta_HT)
	
	; Verschiebung des AT delta_v / delta_lr
	(calcXPosDelta_AT)
	
	
	; Positionieren des Knotenbleches beim ersten Anschluss
	(positioniereKnotenblech) ; => xPos_delta
			
	(if (/= FlanschAnschluss "null")
				(progn
					(if (= FlanschAnschluss "oben")
						(progn
							(if (= (Connect.get castaData satr-lhtr)  1)	(setq xPosStz (+ xPosStz xPos_delta)))
							(if (= (Connect.get castaData satr-lhtr) -1)	(setq xPosStz (- xPosStz xPos_delta)))
							(if (= (Connect.get castaData vatr-lhtr)  1)	(setq xPosStz (- xPosStz xPos_delta)))
							(if (= (Connect.get castaData vatr-lhtr) -1)	(setq xPosStz (+ xPosStz xPos_delta)))
						)
					)
					(if (= FlanschAnschluss "unten")
						(progn
							(if (= (Connect.get castaData satr-lhtr)  1)	(setq xPosStz (+ xPosStz xPos_delta)))
							(if (= (Connect.get castaData satr-lhtr) -1)	(setq xPosStz (- xPosStz xPos_delta)))
							(if (= (Connect.get castaData vatr-lhtr)  1)	(setq xPosStz (- xPosStz xPos_delta)))
							(if (= (Connect.get castaData vatr-lhtr) -1)	(setq xPosStz (+ xPosStz xPos_delta)))
						)
					)
				)
	)
			
	(if (/= StegAnschluss "null")
				(progn
					(if (= StegAnschluss "links") (progn
						(if (= (Connect.get CastaData satr-vhtr)  0) (progn
							(if (= (Connect.get CastaData satr-lhtr)  1)	(setq xPosStz (+ xPosStz xPos_delta)))
							(if (= (Connect.get CastaData satr-lhtr) -1)	(setq xPosStz (- xPosStz xPos_delta)))
						))
						(if (= (Connect.get CastaData vatr-vhtr)  0) (progn
							(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq xPosStz (+ xPosStz xPos_delta)))
							(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq xPosStz (- xPosStz xPos_delta)))
						))
					))
					(if (= StegAnschluss "rechts") (progn
						(if (= (Connect.get CastaData satr-vhtr)  0) (progn
							(if (= (Connect.get CastaData satr-lhtr)  1)	(setq xPosStz (+ xPosStz xPos_delta)))
							(if (= (Connect.get CastaData satr-lhtr) -1)	(setq xPosStz (- xPosStz xPos_delta)))
						  )
					  	  (progn
							(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq xPosStz (+ xPosStz xPos_delta)))
							(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq xPosStz (- xPosStz xPos_delta)))
						))
					))
				)
	)
			
			
	
	(print xPosStz)
	; xPos setzen
	(setq AbtlKnBlech (traeger.get Htrg ABTeil knotenBlech))
	(Anbauteil.set  AbtlKnBlech (xPos xPosStz))
  
	(Blech.knotenblechschraeg knotenBlech 0.0 0.0 at_winkel)
  
 	(Blech.set knotenBlech (delta_lr knotenblech_soll_versatz))
  
    (print "<-----------------------------------------------------------")
)


(defun calcAndSetE0_Var2 (Lchb_ID parallel_abstand_stz)
	
	(setq	h_at 	(Traeger.get Tr_ID h)
		b_at	(Traeger.get Tr_ID b)
		at_halb  0.0
	)
	
	(if (/= FlanschAnschluss "null")
		(progn
			(if (= (Connect.get CastaData vatr-shtr)  1)	(setq at_halb (* 0.5 b_at)))
			(if (= (Connect.get CastaData vatr-shtr) -1)	(setq at_halb (* 0.5 b_at)))
			(if (= (Connect.get CastaData satr-shtr)  1)	(setq at_halb (* 0.5 h_at)))
			(if (= (Connect.get CastaData satr-shtr) -1)	(setq at_halb (* 0.5 h_at)))
		)
	)
	(if (/= StegAnschluss "null")
		(progn
			(if (= (Connect.get CastaData vatr-shtr)  1)	(setq at_halb (* 0.5 h_at)))
			(if (= (Connect.get CastaData vatr-shtr) -1)	(setq at_halb (* 0.5 h_at)))
			(if (= (Connect.get CastaData vatr-vhtr)  1)	(setq at_halb (* 0.5 b_at)))
			(if (= (Connect.get CastaData vatr-vhtr) -1)	(setq at_halb (* 0.5 b_at)))
		)
	)

	(setq at_winkel (Connect.get CastaData at_laengswinkel))
	(setq tanATW (tan (/ (* PI at_winkel) 180.0)))
	(setq sinATW (sin (/ (* PI at_winkel) 180.0)))
	(setq cosATW (cos (/ (* PI at_winkel) 180.0)))

	(if (/= sinATW 0.0)
		(setq e0_1 (/ parallel_abstand_stz sinATW))
		(setq e0_1 parallel_abstand_stz)
	)
	(print e0_1)

	
	(setq parallel_abstand_trgEnde_tmp (* e0_1 cosATW))
	

	(print parallel_abstand_trgEnde)
	(print parallel_abstand_trgEnde_tmp)
	(if (< parallel_abstand_trgEnde_tmp 0.0)	(setq parallel_abstand_trgEnde_tmp (* -1.0 parallel_abstand_trgEnde_tmp) ))
	(print parallel_abstand_trgEnde_tmp)

	
	(if (< parallel_abstand_trgEnde_tmp parallel_abstand_trgEnde)
		(if (/= cosATW 0.0) (progn
			(setq e0_1 (/ parallel_abstand_trgEnde cosATW))
		))
	)

	(if (/= StegAnschluss "null") (progn
		(setq	qsform_HT	(Traeger.get HTrg qsform))
		(setq	b_HT		(Traeger.get HTrg b))
		(if (= qsform_HT "K") (setq e0_1 (+ e0_1 (/ (* 0.5 b_HT) cosATW))))
		(if (= qsform_HT "R") (setq e0_1 (+ e0_1 (/ (* 0.5 b_HT) cosATW))))
	))

	(print e0_1)

	
	(if (< e0_1 0.0)	(setq e0_1 (* -1.0 e0_1)))
	(print e0_1)
	
	(setq e0_2 (/ at_halb tanATW))
	(if (< e0_2 0.0)
		(setq e0_2 (- e0_2))
	)
	(print e0_2)
	
	(setq e0_3 at_halb)
	(print e0_3)
		
	(setq e0 (+ e0_1 e0_2 e0_3))
	(print e0)
	
	(Lochbild.set Lchb_ID (e0 e0))
)
; ----------------------------------------------------------------------------------------
; Erzeugt das Lochbild fr Knotenblech Variante 2
; ----------------------------------------------------------------------------------------
(defun createLochbild_Var2 (Lchb_ID Blech_ID p_abstand_stz)
	
	(Lochbild.set Lchb_ID 	
				(S_Bez 		"M16")
				(Guete		"4.6")											
	)
	
	; allg. Daten
	(setq	dp_blech 	(Blech.get Blech_ID dp)
		bp_blech	(Blech.get Blech_ID bp)
		hp_blech	(Blech.get Blech_ID hp)
	)
	
	(setq	t_at		(Traeger.get Tr_ID t)
		s_at		(Traeger.get Tr_ID s)
		b_at		(Traeger.get Tr_ID b)
		h_at		(Traeger.get Tr_ID h)
		delta_lr_at	(Traeger.get Tr_ID delta_lr)
	)
	(setq	delta_v_ht	(Traeger.get Htrg delta_v)
		delta_lr_ht	(Traeger.get Htrg delta_lr)
	)
	
	(setq	xPos_ht		(Connect.get CastaData xPos_ht)
		at_winkel	(Connect.get CastaData at_laengswinkel)
	)
	
	; Klemmlnge
	(setq dicke_trg t_at)
	(setq klemml (+ dicke_trg dp_blech))
	
	
	; dxSKopf Anschluss am Steg
	(if (/= StegAnschluss "null")
		(progn
			(if (= (Connect.get CastaData satr-vhtr)  1) (setq dxS (* 0.5 dp_blech)))
			(if (= (Connect.get CastaData satr-vhtr) -1) (setq dxS (+ (* 0.5 dp_blech) t_at)))
			(if (= (Connect.get CastaData vatr-vhtr)  1) (setq dxS (+ (* 0.5 dp_blech) t_at)))
			(if (= (Connect.get CastaData vatr-vhtr) -1) (setq dxS (* 0.5 dp_blech)))	
		)
	)
			
	; dxSKopf Anschluss am Flansch
	(if (/= FlanschAnschluss "null")
		(progn
			(if (= (Connect.get CastaData satr-shtr)  1) (setq dxS (* 0.5 dp_blech)))
			(if (= (Connect.get CastaData satr-shtr) -1) (setq dxS (+ (* 0.5 dp_blech) t_at)))
			(if (= (Connect.get CastaData vatr-shtr)  1) (setq dxS (+ (* 0.5 dp_blech) t_at)))
			(if (= (Connect.get CastaData vatr-shtr) -1) (setq dxS (* 0.5 dp_blech)))		
		)
	)
	
	(print dxS)
	
	
	
	
	
	; Werte setzen
	(Lochbild.set Lchb_ID 	(klemml		klemml)
				(dxSKopf	dxS)
	)
	
	
	; xPos Lochbild-Anbauteil
	
	
	
	(setq xPos_LB xPos_ht)
	
	; Lochbild dem HT hinzufgen
	(setq AbtlKnoBl	(Traeger.get Htrg AbTeil Blech_ID))
	(Traeger.addabtl Htrg Lchb_ID 0.0 0.0 _knblLochbild_ AbtlKnoBl)
	
	(setq AbtlKnoBlLchb    (Traeger.get Htrg AbTeil Lchb_ID))
		
	(Anbauteil.set AbtlKnoBlLchb 	(Master 1)
					(delta_sx knotenblech_soll_versatz)
	)
	
	
)


; NEUE METHODEN FR DIE VARIANTE OHNE STABVERSCHIEBUNG
; ====================================================

(defun positioniereKnotenblech ()
	(print " ")
	(print " ")
;	(print "*clear*")
	(print "Positioniere Knotenblech")
	(print ">------------------------------------------------------------------------------")
	
	(setq	h_at 	(Traeger.get Tr_ID h)
		b_at	(Traeger.get Tr_ID b)
		d_at	(Traeger.get Tr_ID s)
		t_at	(Traeger.get Tr_ID t)
	)
	
	(setq xPos_HT (Connect.get CastaData xPos_ht))
	(print xPos_HT)
	
	(setq at_winkel (Connect.get CastaData at_laengswinkel))
	(print at_winkel)
	
	(setq sinATW (sin (/ (* PI at_winkel) 180.0)))
	(print sinATW)
	
	; max. Lochdurchmesser d und min. Anreimae w 
	; ---------------------------------------------
	(getWMass) ; --> d_1, d_2, w_1, w_2, w_3
	(print d_1)
	(print d_2)
	(print w_1)
	(print w_2)
	(print w_3)
	
	(setq noH_at (* 0.5 (- h_at t_at)))
	(setq noB_at (* 0.5 (- b_at t_at)))
	(print noH_at)
	(print noB_at)
	
	(if (= b_at h_at)
		; gleichschenklig
		(progn
			(if (<= w_1 0.0)
				(progn
					(setq L_Abst_H noH_at)
					(setq L_Abst_B noB_at)
				)
				(progn
					(setq L_Abst_H w_1)
					(setq L_Abst_B w_1)
				)
			)
		)
		; ungleichschenklig
		(progn
			(if (<= w_1 0.0)
				(setq L_Abst_H noH_at)
				(setq L_Abst_H w_1)
			)
			(if (<= w_3 0.0)
				(setq L_Abst_B noB_at)
				(setq L_Abst_B w_3)
			)
		)
	)
	
	(print L_Abst_H)
	(print L_Abst_B)
	
	(setq t_seite 0)
	
	(if (/= FlanschAnschluss "null")
		(progn
			(if (= (Connect.get CastaData vatr-shtr)  1)	(setq t_seite L_Abst_B));(* 0.5 b_at)))
			(if (= (Connect.get CastaData vatr-shtr) -1)	(setq t_seite L_Abst_B));(* 0.5 b_at)))
			(if (= (Connect.get CastaData satr-shtr)  1)	(setq t_seite L_Abst_H));(* 0.5 h_at)))
			(if (= (Connect.get CastaData satr-shtr) -1)	(setq t_seite L_Abst_H));(* 0.5 h_at)))
		)
	)
	(if (/= StegAnschluss "null")
		(progn
			(setq VAtr_SHtr_Test (Connect.get CastaData vatr-shtr))
			(setq VAtr_VHtr_Test (Connect.get CastaData vatr-vhtr))
			(setq VAtr_Wnkl_Test (Connect.get CastaData v-atrgewnkl_steg))
			(setq HAtr_Wnkl_Test (Connect.get CastaData h-atrgewnkl_steg))
			
			;; Sept. 2011 - nderungen
			(print "...")
			(print VAtr_SHtr_Test)
			(print VAtr_VHtr_Test)
			(print VAtr_Wnkl_Test)
			(print HAtr_Wnkl_Test)
			(print L_Abst_H)
			(print L_Abst_B)
			(print "...")

			(setq Sonderfall 0)
			(if (= (Connect.get CastaData vatr-shtr)  0) (if (= (Connect.get CastaData vatr-vhtr)  0) (setq Sonderfall 1)))
		
			(if (= Sonderfall 0) (progn
				(if (= (Connect.get CastaData vatr-shtr)  1)	(setq t_seite L_Abst_H));(* 0.5 h_at)))
				(if (= (Connect.get CastaData vatr-shtr) -1)	(setq t_seite L_Abst_H));(* 0.5 h_at)))
				(if (= (Connect.get CastaData vatr-vhtr)  1)	(setq t_seite L_Abst_B));(* 0.5 b_at)))
				(if (= (Connect.get CastaData vatr-vhtr) -1)	(setq t_seite L_Abst_B));(* 0.5 b_at)))
			))
			(if (= Sonderfall 1) (progn
				(if (= (Connect.get CastaData vatr-Lhtr)  1)	(setq t_seite L_Abst_H));(* 0.5 h_at)))
				(if (= (Connect.get CastaData vatr-Lhtr) -1)	(setq t_seite L_Abst_H));(* 0.5 h_at)))
			))			

			(setq FlagSenkrecht 0)
			(if (= (Connect.get CastaData v-atrgewnkl_steg) 90.0) (if (= (Connect.get CastaData h-atrgewnkl_steg) 90.0) (setq FlagSenkrecht 1)))
			(if (= (Connect.get CastaData vatr-lhtr)  0) (setq FlagSenkrecht 0))
	    		(if (= FlagSenkrecht 1) (progn
				(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq t_seite L_Abst_H))
				(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq t_seite L_Abst_H))
	    		))

		)
	)
	(print t_seite)
;	(setq t_Seite 10.0)
	
	(setq xPos_delta (/ t_seite sinATW))
	(print xPos_delta)
	(print sinATW)
	
;	(setq xPos_delta (* 0.5 xPos_delta))		; testen
;	(setq xPos_delta  0)				; testen
	(print "<------------------------------------------------------------------------------")
	(print " ")
	(print " ")
)

; ---------------------------------------------------------------------------------------
;
; ---------------------------------------------------------------------------------------
(defun getWMass ()
	(print ">------------------------------------------------------------------------------")
	(print "BERECHNE LOCHABSTAND")
	
	(setq b_at 	(Traeger.get Tr_ID b)
				h_at	(Traeger.get Tr_ID h)
				t_at	(Traeger.get Tr_ID t)
	)
		
	(setq d_1 0.0
				d_2 0.0
				w_1	0.0
				w_2 0.0
				w_3 0.0
	)
	; erstmal 
	; TABELLENWERTE AUS STAHLBAU KOMPAKT (Kindman, Kraus, Niebuhr), 2006
	; Bercksichtigt neben der DIN 997 (1970) auch die DIN 18800 (1990)
	(if (= b_at h_at)
		; -----------------------------------------------------------------
		; Gleichschenklige Winkel
		; -----------------------------------------------------------------
		(progn
			(if (= h_at 50.0)
				(progn
					(if (= t_at 5.0)	(setq d_1 11.0		w_1	35.0))
					(if (= t_at 6.0)	(setq d_1 11.0		w_1	36.0))
				)
			)
			(if (= h_at 55.0)
				(progn
					(if (= t_at 6.0)	(setq d_1 13.0		w_1	36.0))
				)
			)
			(if (= h_at 60.0)
				(progn
					(if (= t_at 5.0)	(setq d_1 13.0		w_1	35.0))
					(if (= t_at 6.0)	(setq d_1 13.0		w_1	36.0))
					(if (= t_at 8.0)	(setq d_1 13.0		w_1	38.0))
				)
			)
			(if (= h_at 65.0)
					(if (= t_at 7.0)	(setq d_1 17.0 		w_1	42.0))
			)
			(if (= h_at 70.0)
				(progn
					(if (= t_at 6.0)	(setq d_1 21.0		w_1	41.0))
					(if (= t_at 7.0)	(setq d_1 21.0		w_1	42.0))
					(if (= t_at 9.0)	(setq d_1 21.0		w_1	44.0))
				)
			)
			(if (= h_at 75.0)
				(progn
					(if (= t_at 6.0)	(setq d_1 21.0		w_1	41.0))
					(if (= t_at 7.0)	(setq d_1 21.0		w_1	43.0))
					(if (= t_at 8.0)	(setq d_1 21.0		w_1	43.0))
				)
			)
			(if (= h_at 80.0)
				(progn
					(if (= t_at 6.0)	(setq d_1 25.0		w_1	48.0))
					(if (= t_at 8.0)	(setq d_1 25.0		w_1	50.0))
					(if (= t_at 10.0)	(setq d_1 21.0		w_1	46.0))
				)
			)
			(if (= h_at 90.0)
				(progn
					(if (= t_at 7.0)	(setq d_1 28.0		w_1	53.0))
					(if (= t_at 8.0)	(setq d_1 28.0		w_1	54.0))
					(if (= t_at 9.0)	(setq d_1 28.0		w_1	55.0))
					(if (= t_at 10.0)	(setq d_1 28.0		w_1	56.0))
				)
			)
			(if (= h_at 100.0)
				(progn
					(if (= t_at 8.0)	(setq d_1 28.0		w_1	55.0))
					(if (= t_at 10.0)	(setq d_1 28.0		w_1	57.0))
					(if (= t_at 12.0)	(setq d_1 28.0		w_1	59.0))
				)
			)
			(if (= h_at 110.0)
				(progn
					(if (= t_at 10.0)	(setq d_1 28.0		w_1	57.0))
					(if (= t_at 12.0)	(setq d_1 28.0		w_1	60.0))
				)
			)
			(if (= h_at 120.0)
				(progn
					(if (= t_at 10.0)	(setq d_1 28.0		w_1	60.0))
					(if (= t_at 11.0)	(setq d_1 28.0		w_1	59.0))
					(if (= t_at 12.0)	(setq d_1 28.0		w_1	60.0))
					(if (= t_at 13.0)	(setq d_1 28.0		w_1	61.0))
					(if (= t_at 15.0)	(setq d_1 28.0		w_1	63.0))
				)
			)
			(if (= h_at 130.0)
				(if (= t_at 12.0)	(setq d_1 28.0		w_1	61.0))
			)
			(if (= h_at 140.0)
				(if (= t_at 13.0)	(setq d_1 28.0		w_1	63.0))
			)
			(if (= h_at 150.0)
				(progn
					(if (= t_at 10.0)	(setq d_1 25.0		w_1	58.0	w_2 118.0))
					(if (= t_at 12.0)	(setq d_1 25.0		w_1	60.0	w_2 120.0))
					(if (= t_at 14.0)	(setq d_1 28.0		w_1	66.0	))
					(if (= t_at 15.0)	(setq d_1 28.0		w_1	66.0	))
					(if (= t_at 18.0)	(setq d_1 28.0		w_1	69.0	))
				)
			)
			(if (= h_at 160.0)
				(progn
					(if (= t_at 14.0)	(setq d_1 25.0		w_1	63.0	w_2 123.0))	
					(if (= t_at 15.0)	(setq d_1 25.0		w_1	64.0	w_2 124.0))
					(if (= t_at 16.0)	(setq d_1 25.0		w_1	65.0	w_2 125.0))
					(if (= t_at 17.0)	(setq d_1 25.0		w_1	66.0	w_2 126.0))
				)
			)
			(if (= h_at 180.0)
				(progn
					(if (= t_at 14.0)	(setq d_1 28.0		w_1	67.0	w_2 134.0))
					(if (= t_at 15.0)	(setq d_1 28.0		w_1	68.0	w_2 135.0))
					(if (= t_at 16.0)	(setq d_1 28.0		w_1	69.0	w_2 136.0))
					(if (= t_at 18.0)	(setq d_1 28.0		w_1	71.0	w_2 138.0))
					(if (= t_at 20.0)	(setq d_1 28.0		w_1	73.0	w_2 140.0))
				)
			)
			(if (= h_at 200.0)
				(progn
					(if (= t_at 16.0)	(setq d_1 28.0		w_1	69.0	w_2 136.0))
					(if (= t_at 17.0)	(setq d_1 28.0		w_1	70.0	w_2 137.0))
					(if (= t_at 18.0)	(setq d_1 28.0		w_1	71.0	w_2 138.0))
					(if (= t_at 19.0)	(setq d_1 28.0		w_1	72.0	w_2 139.0))
					(if (= t_at 20.0)	(setq d_1 28.0		w_1	73.0	w_2 140.0))
					(if (= t_at 21.0)	(setq d_1 28.0		w_1	74.0	w_2 141.0))
					(if (= t_at 22.0)	(setq d_1 28.0		w_1	75.0	w_2 142.0))
					(if (= t_at 24.0)	(setq d_1 28.0		w_1	77.0	w_2 144.0))
					(if (= t_at 26.0)	(setq d_1 28.0		w_1	79.0	w_2 146.0))
				)
			)
			(if (= h_at 250.0)
				(progn
					(if (= t_at 20.0)	(setq d_1 28.0		w_1	73.0	w_2 166.0))
					(if (= t_at 21.0)	(setq d_1 28.0		w_1	74.0	w_2 166.0))
					(if (= t_at 22.0)	(setq d_1 28.0		w_1	75.0	w_2 166.0))
					(if (= t_at 23.0)	(setq d_1 28.0		w_1	76.0	w_2 166.0))
					(if (= t_at 24.0)	(setq d_1 28.0		w_1	77.0	w_2 166.0))
					(if (= t_at 26.0)	(setq d_1 28.0		w_1	79.0	w_2 166.0))
					(if (= t_at 28.0)	(setq d_1 28.0		w_1	81.0	w_2 166.0))
					(if (= t_at 35.0)	(setq d_1 28.0		w_1	88.0	w_2 166.0))
				)
			)
		)
		; -----------------------------------------------------------------
		; Ungleichschenklige Winkel
		; -----------------------------------------------------------------
		(progn
			(if (= h_at 50.0)
				(progn
					(if (= b_at 30.0)
						(if (= t_at 5.0)	(setq d_1 11.0	w_1 35.0))
					)
					(if (= b_at 40.0)
						(if (= t_at 5.0)	(setq d_1 11.0	w_1 35.0))
					)
				)
			)
			(if (= h_at 60.0)
				(progn
					(if (= b_at 30.0)
						(if (= t_at 5.0)	(setq d_1 13.0	w_1 35.0))
					)
					(if (= b_at 40.0)
						(progn
							(if (= t_at 5.0)	(setq d_1 13.0	w_1 35.0))
							(if (= t_at 6.0)	(setq d_1 13.0	w_1 36.0))
							(if (= t_at 7.0)	(setq d_1 13.0	w_1 37.0))
						)
					)
				)
			)
			(if (= h_at 65.0)
				(if (= b_at 50.0)
						(if (= t_at 5.0)	(setq d_1 17.0	d_2 11.0		w_1 40.0		w_3 35.0))
						(if (= t_at 7.0)	(setq d_1 17.0							w_1 42.0))
						(if (= t_at 9.0)	(setq d_1 17.0							w_1 44.0))
				)
			)
			(if (= h_at 70.0)
				(if (= b_at 50.0)
						(if (= t_at 6.0)	(setq d_1 21.0	d_2 13.0		w_1 40.0		w_3 35.0))
				)
			)
			(if (= h_at 75.0)
				(progn
					(if (= b_at 50.0)
						(progn
							(if (= t_at 6.0)	(setq d_1 21.0	d_2 11.0		w_1 41.0		w_3 36.0))
							(if (= t_at 8.0)	(setq d_1 21.0							w_1 43.0))
							(if (= t_at 9.0)	(setq d_1 21.0							w_1 44.0))
						)
					)
					(if (= b_at 55.0)
						(progn
							(if (= t_at 5.0)	(setq d_1 21.0	d_2 13.0		w_1 40.0		w_3 35.0))
							(if (= t_at 7.0)	(setq d_1 21.0	d_2 13.0		w_1 42.0		w_3 37.0))
							(if (= t_at 9.0)	(setq d_1 21.0	d_2 13.0		w_1 44.0		w_3 39.0))
						)
					)
				)
			)
			(if (= h_at 80.0)
				(progn
					(if (= b_at 40.0)
						(progn
							(if (= t_at 6.0)	(setq d_1 25.0	w_1 46.0))
							(if (= t_at 8.0)	(setq d_1 25.0	w_1 48.0))
						)
					)
					(if (= b_at 60.0)	
						(if (= t_at 7.0)	(setq d_1 25.0	d_2 13.0		w_1 47.0		w_3 37.0))
					)
					(if (= b_at 65.0)
						(progn
							(if (= t_at 8.0)	(setq d_1 25.0	d_2 17.0		w_1 48.0		w_3 43.0))
							(if (= t_at 10.0)	(setq d_1 25.0	d_2 13.0		w_1 50.0		w_3 40.0))
						)
					)
				)
			)
			(if (= h_at 90.0)
				(if (= b_at 60.0)
					(progn
						(if (= t_at 6)	(setq d_1 25.0	d_2 13.0		w_1 48.0		w_3 36.0))
						(if (= t_at 8)	(setq d_1 28.0	d_2 13.0		w_1 53.0		w_3 38.0))
					)
				)
			)
			(if (= h_at 100.0)
				(progn
					(if (= b_at 50.0)
						(progn
							(if (= t_at 6.0)	(setq d_1 25.0	d_2 11.0		w_1 48.0		w_3 36.0))
							(if (= t_at 8.0)	(setq d_1 28.0							w_1 53.0))
							(if (= t_at 10.0)	(setq d_1 28.0							w_1 55.0))
						)
					)
					(if (= b_at 65.0)
						(progn
							(if (= t_at 7.0)	(setq d_1 28.0	d_2 17.0		w_1 56.0		w_3 42.0))
							(if (= t_at 8.0)	(setq d_1 28.0	d_2 17.0		w_1 53.0		w_3 43.0))
							(if (= t_at 9.0)	(setq d_1 28.0	d_2 17.0		w_1 54.0		w_3 44.0))
							(if (= t_at 10.0)	(setq d_1 28.0	d_2 13.0  	w_1 55.0		w_3 40.0))
							(if (= t_at 11.0)	(setq d_1 28.0	d_2 13.0		w_1 56.0		w_3 41.0))
						)
					)
					(if (= b_at 75.0)
						(progn
							(if (= t_at 7.0)	(setq d_1 28.0	d_2 21.0		w_1 56.0		w_3 43.0))
							(if (= t_at 8.0)	(setq d_1 28.0	d_2 21.0		w_1 53.0		w_3 44.0))
							(if (= t_at 9.0)	(setq d_1 28.0	d_2 21.0		w_1 54.0		w_3 45.0))
							(if (= t_at 10.0)	(setq d_1 28.0	d_2 21.0    w_1 55.0		w_3 46.0))
							(if (= t_at 11.0)	(setq d_1 28.0	d_2 21.0    w_1 56.0		w_3 47.0))
							(if (= t_at 12.0)	(setq d_1 28.0	d_2 21.0		w_1 57.0		w_3 48.0)) 
						)
					)
				)
			)
			(if (= h_at 120.0)
				(progn
					(if (= b_at 80.0)
						(progn
							(if (= t_at 8.0)	(setq d_1 28.0	d_2 21.0		w_1 64.0		w_3 45.0))
							(if (= t_at 10.0)	(setq d_1 28.0	d_2 21.0		w_1 60.0		w_3 47.0))
							(if (= t_at 12.0)	(setq d_1 28.0	d_2 21.0		w_1 58.0		w_3 49.0))
						)
					)
				)
			)
			(if (= h_at 125.0)
				(progn
					(if (= b_at 75.0)
						(progn
							(if (= t_at 8.0)	(setq d_1 28.0	d_2 21.0		w_1 64.0		w_3 45.0))
							(if (= t_at 10.0)	(setq d_1 28.0	d_2 21.0		w_1 65.0		w_3 47.0))
							(if (= t_at 12.0)	(setq d_1 28.0	d_2 21.0		w_1 58.0		w_3 49.0))
						)
					)
				)
			)
			(if (= h_at 130.0)
				(progn
					(if (= b_at 65.0)
						(progn
							(if (= t_at 8.0)	(setq d_1 28.0	d_2 17.0		w_1 64.0		w_3 43.0))
							(if (= t_at 10.0)	(setq d_1 28.0	d_2 13.0		w_1 70.0		w_3 40.0))
							(if (= t_at 12.0)	(setq d_1 28.0	d_2 13.0		w_1 58.0		w_3 42.0))
						)
					)
				)
			)
			(if (= h_at 130.0)
				(if (= b_at 90.0)
					(if (= t_at 12)		(setq d_1 28.0	d_2 25.0	w_1 59.0	w_3 56.0))
				)
			)
			(if (= h_at 135.0)
				(progn
					(if (= b_at 65.0)
						(progn
							(if (= t_at 8.0)	(setq d_1 28.0	d_2 17.0	w_1 64.0	w_3 43.0))
							(if (= t_at 10.0)	(setq d_1 28.0	d_2 13.0	w_1 75.0	w_3 40.0))
						)
					)
				)
			)
			(if (= h_at 150.0)
				(progn
					(if (= b_at 75.0)
						(progn
							(if (= t_at 9.0)	(setq d_1 25.0	d_2 21.0		w_1 53.0		w_2 113.0		w_3 47.0))
							(if (= t_at 10.0)	(setq d_1 25.0	d_2 21.0		w_1 54.0		w_2 114.0		w_3 48.0))
							(if (= t_at 11.0)	(setq d_1 25.0	d_2 21.0		w_1 53.0		w_2 113.0		w_3 47.0))
							(if (= t_at 12.0)	(setq d_1 25.0	d_2 21.0		w_1 56.0		w_2 116.0		w_3 50.0))
							(if (= t_at 15.0)	(setq d_1 25.0	d_2 17.0		w_1 59.0		w_2 119.0		w_3 50.0))
						)
					)
					(if (= b_at 90.0)
						(progn
							(if (= t_at 10.0)	(setq d_1 25.0	d_2 25.0		w_1 54.0		w_2 114.0		w_3 54.0))
							(if (= t_at 11.0)	(setq d_1 25.0	d_2 25.0		w_1 55.0		w_2 115.0		w_3 55.0))
							(if (= t_at 12.0)	(setq d_1 25.0	d_2 25.0		w_1 56.0		w_2 116.0		w_3 56.0))
							(if (= t_at 15.0)	(setq d_1 25.0	d_2 25.0		w_1 59.0		w_2 119.0		w_3 59.0))
						)
					)
					(if (= b_at 100.0)
						(progn
							(if (= t_at 10.0)	(setq d_1 25.0	d_2 28.0		w_1 54.0		w_2 114.0		w_3 57.0))
							(if (= t_at 12.0)	(setq d_1 25.0	d_2 28.0		w_1 56.0		w_2 116.0		w_3 59.0))
							(if (= t_at 14.0)	(setq d_1 25.0	d_2 28.0		w_1 59.0		w_2 119.0		w_3 62.0))
						)
					)
				)
			)
			(if (= h_at 160.0)
				(progn
					(if (= b_at 80.0)
						(progn
							(if (= t_at 10.0)	(setq d_1 28.0	d_2 21.0		w_1 58.0		w_2 125.0		w_3 49.0))
							(if (= t_at 12.0)	(setq d_1 25.0	d_2 21.0		w_1 57.0		w_2 117.0		w_3 51.0))
						)
					)
				)
			)
			(if (= h_at 180.0)
				(progn
					(if (= b_at 90.0)
						(progn
							(if (= t_at 10.0)	(setq d_1 28.0	d_2 25.0		w_1 59.0		w_2 126.0		w_3 56.0))
							(if (= t_at 12.0)	(setq d_1 28.0	d_2 25.0		w_1 61.0		w_2 128.0		w_3 58.0))
						)
					)
				)
			)
			(if (= h_at 200.0)
				(progn
					(if (= b_at 100.0)
						(progn
							(if (= t_at 10.0)	(setq d_1 28.0	d_2 28.0  	w_1 60.0		w_2 140.0		w_3 60.0))
							(if (= t_at 12.0)	(setq d_1 28.0	d_2 28.0  	w_1 62.0		w_2 129.0		w_3 62.0))
							(if (= t_at 14.0)	(setq d_1 28.0	d_2 28.0  	w_1 64.0		w_2 131.0		w_3 64.0))
							(if (= t_at 15.0) (setq d_1 28.0	d_2 28.0  	w_1 65.0		w_2 132.0		w_3 65.0))
						)
					)
					(if (= b_at 150.0)
						(progn
							(if (= t_at 12.0)	(setq d_1 28.0	d_2 28.0  	w_1 62.0		w_2 129.0		w_3 78.0))
							(if (= t_at 15.0)	(setq d_1 28.0	d_2 28.0  	w_1 65.0		w_2 132.0		w_3 66.0))
						)
					)
				)
			)
		)
	)
	
	(print "<------------------------------------------------------------------------------")
)

(defun RichtungsDef_Lochbild (knbLochb)

   (setq lokRichtFakt 0)

   ; nur das wird gebraucht
    (if (= StegAnschluss "links")	(progn
	(if (= (Connect.get CastaData vatr-lhtr)  -1) (setq lokRichtFakt -1))
	(if (= (Connect.get CastaData vatr-vhtr)  -1) (setq lokRichtFakt -1))
    ))
    (if (= StegAnschluss "rechts")	(progn
	(if (= (Connect.get CastaData vatr-lhtr)  1) (setq lokRichtFakt -1))
	(if (= (Connect.get CastaData vatr-vhtr)  -1) (setq lokRichtFakt -1))
    ))

    (if (= FlanschAnschluss "oben")	(progn
	(if (= (Connect.get CastaData linkesEnde) 1)	(progn
	    (if (= (Connect.get CastaData vatr-lhtr)  -1) (setq lokRichtFakt -1))
	    (if (= (Connect.get CastaData satr-lhtr)  -1) (setq lokRichtFakt -1))
	))
	(if (= (Connect.get CastaData rechtesEnde) 1)	(progn
	    (if (= (Connect.get CastaData vatr-lhtr)  -1) (setq lokRichtFakt -1))
	    (if (= (Connect.get CastaData satr-lhtr)   1) (setq lokRichtFakt -1))
	))
    ))
    (if (= FlanschAnschluss "unten")	(progn
	(if (= (Connect.get CastaData linkesEnde) 1)	(progn
	    (if (= (Connect.get CastaData vatr-lhtr)   1) (setq lokRichtFakt -1))
	    (if (= (Connect.get CastaData satr-lhtr)   1) (setq lokRichtFakt -1))
	))
	(if (= (Connect.get CastaData rechtesEnde) 1)	(progn
	    (if (= (Connect.get CastaData vatr-lhtr)   1) (setq lokRichtFakt -1))
	    (if (= (Connect.get CastaData satr-lhtr)  -1) (setq lokRichtFakt -1))
	))
    ))

  	(setq AbtlKnoBlLchbHT    (Traeger.get HTrg AbTeil knblLochbild))
	(Anbauteil.set AbtlKnoBlLchbHT
					(SeitRicht lokRichtFakt)
	)
)

(defun calcLochbild_w ()
    (Connect.showAttributes CastaData)
    (print "in calcLochbild_w : Bestimmen des W-Maes fr das Lochbild")
 	(getWMass) ; --> d_1, d_2, w_1, w_2, w_3
	(print d_1)
	(print d_2)
	(print w_1)
	(print w_2)
	(print w_3)

    (setq w0   w_1)
    (setq wRichtung_HT 0  wRichtung_AT 0)

    ; gleichschenklige Winkel - Schraubenabstnde sind gleich
    (if (= w_3 0.0) (setq w_3 w_1))
    
    ; ........... Anschluss am Haupttrger-Flansch
    (if (/= FlanschAnschluss "null") (progn
        (if (= (Connect.get CastaData sATr-VHTr)  0) 
        	(setq w0 w_1)		; breiter  Winkel-Schenkel
        	(setq w0 w_3)		; schmaler Winkel-Schenkel
        )

	; Fall R_Winkel = 0.0 und R_Winkel = 180.0
        (if (= (Connect.get CastaData satr-vhtr)  0) (progn
            (if (= (Connect.get CastaData satr-shtr)  -1) (progn
		(setq wRichtung_HT  -1)
	    	(if (= (Connect.get CastaData rechtesEnde) 1) (progn
	    		(setq wRichtung_HT  1)
	    	))
            ))
            (if (= (Connect.get CastaData satr-shtr)  1) (progn
	    	(if (= (Connect.get CastaData rechtesEnde) 1) (progn
	    		(setq wRichtung_HT  -1)
	    	))
            ))
        ))
	; Fall R_Winkel = 90.0 und R_Winkel = -90.0
        (if (= (Connect.get CastaData satr-shtr)  0) (progn
            (if (= (Connect.get CastaData vatr-shtr)  -1) (progn
		(setq wRichtung_HT  -1)
            ))
;	    (if (= (Connect.get CastaData rechtesEnde) 1) (progn
;		; umdrehen der Def-Richtung
;		(Lochbild.set knblLochbild (LB_Art -2))
;	    ))
        ))
    ))    
    
    ; ........... Anschluss am Haupttrger-Steg
    (if (/= Steganschluss "null") (progn
        (if (= (Connect.get CastaData sATr-vHTr)  0) 
        	(setq w0     w_3)
        	(setq w0     w_1)
        )

	(if (= (Connect.get CastaData linkesEnde) 1) (progn
    	    (if (= (Connect.get CastaData vATr-vHTr)  1)
		(if (= (Connect.get CastaData sATr-vHTr)  0) (setq wRichtung_HT -1))
	    )
	    (if (= (Connect.get CastaData sATr-vHTr)  1)
		(if (= (Connect.get CastaData sATr-sHTr)  0) (setq wRichtung_HT -1))
	    )
	))
	(if (= (Connect.get CastaData rechtesEnde) 1) (progn
	    ; umdrehen der Def-Richtung
	    (if (= (Connect.get CastaData sATr-vHTr)  0) (progn
;	    	(Lochbild.set knblLochbild (LB_Art -2))
		(if (= (Connect.get CastaData vATr-vHTr)  1) (setq wRichtung_HT -1))
	    ))
	    (if (= (Connect.get CastaData sATr-sHTr)  0) (progn
		(if (= (Connect.get CastaData sATr-vHTr)  -1) (setq wRichtung_HT -1))
	    ))
	))
    ))

    
    ; Erst einmal auf 0 belassen ...
    ; (Lochbild.set knblLochbild  (w0 w0))

   (setq AbtlKnoBlLchbAT    (Traeger.get Tr_ID AbTeil knblLochbild))
   (setq AbtlKnoBlLchbHT    (Traeger.get HTrg AbTeil knblLochbild))

;   (Anbauteil.set AbtlKnoBlLchbAT (SeitRicht 0))
;   (Anbauteil.set AbtlKnoBlLchbHT (SeitRicht wRichtung_HT))
    
   (if (= 1 2) (progn
	(Lochbild.set knblLochbild (dxSKopf 0))
	(Anbauteil.set AbtlKnoBlLchbHT 	(Master	    1))
	(Anbauteil.set AbtlKnoBlLchbAT 	(Master     0))
   ))    

)

(defun calcLichtenAbst ()
	(print ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>")
	(print "BERECHNE LICHTEN ABSTAND DER TRGER")
	(setq	delta_v_at 	(Traeger.get Tr_ID delta_v)
		delta_lr_AT	(Traeger.get Tr_ID delta_lr)
		h_at		(Traeger.get Tr_ID h)
	)
	
	(setq	delta_v_ht	(Traeger.get Htrg delta_v)
		h_ht				(Traeger.get Htrg h)
	)
	
	(setq h_at_halb	(* 0.5 h_at))
	(setq h_ht_halb	(* 0.5 h_ht))
	
	(print delta_v_ht)
	(print h_ht_halb)
	(print delta_v_at)
	(print h_at_halb)
	
	(setq h_at_halb	0.0)
	
	(setq pos_ht 0.0)
	(setq pos_at 0.0)
	
	(if (= (Connect.get CastaData amHtOberflansch) 1)	(setq pos_ht (- delta_v_ht h_ht_halb)))
	(if (= (Connect.get CastaData amHtUnterflansch) 1)	(setq pos_ht (+ delta_v_ht h_ht_halb)))

	(setq lichterAbst 0.0)

	(if (= (Connect.get CastaData amHtOberflansch) 1)
		(progn
;			(if (= (Connect.get CastaData amAtOberflansch)  1)	(print "Flansch an Flansch - oben/oben"))
;			(if (= (Connect.get CastaData amAtUnterflansch) 1)	(print "Flansch an Flansch - unten/oben"))
;			(if (= (Connect.get CastaData amAtStegLinks)    1)	(print "Steg an Flansch - links/oben"))
;			(if (= (Connect.get CastaData amAtStegRechts  ) 1)	(print "Steg an Flansch - rechts/oben"))

			(if (= (Connect.get CastaData amAtOberflansch) 1)	(setq pos_at	(- (- delta_v_at h_at_halb)))	)
			(if (= (Connect.get CastaData amAtUnterflansch) 1)	(setq pos_at	(+ delta_v_at h_at_halb))	)

			(if (= (Connect.get CastaData amAtStegLinks) 1)		(setq pos_at	(- delta_lr_AT)))
			(if (= (Connect.get CastaData amAtStegRechts) 1)	(setq pos_at	   delta_lr_AT))
		)
	)
	(if (= (Connect.get CastaData amHtUnterflansch) 1)
		(progn
			(if (= (Connect.get CastaData amAtOberflansch) 1)	(setq pos_at	(- delta_v_at h_at_halb))	)
			(if (= (Connect.get CastaData amAtUnterflansch) 1)	(setq pos_at	(- (- delta_v_at) h_at_halb))	)

			(if (= (Connect.get CastaData amAtStegLinks) 1)		(setq pos_at	   delta_lr_AT))
			(if (= (Connect.get CastaData amAtStegRechts) 1)	(setq pos_at	(- delta_lr_AT)))
		)
	)
	
	
	(print pos_ht)
	(print pos_at)
	
	
	(if (/= pos_at pos_ht)
		(setq lichterAbst (- pos_ht pos_at))
	)
	
	
	(if (< lichterAbst 0.0)
		(setq lichterAbst (- lichterAbst))
	)
	(print lichterAbst)
	(print "<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<")
)

