(defun init-traegerenden ()
	;(calcHtEnden)
	
	(setq SCHRAUBENBILD 0)
	
	(if (= (Connect.get CastaData anschlzwAtEnden) 0)
		(progn
			(calcAuflagerLaenge) ; -> SCHRAUBEN_ANZ
			
			(if (= delta_l_atende 0.0)
				(calcAtEnde)
			)
		)	
	)
)

; ----------------------------------------------------------------------------------------
; BERECHNET DIE HT-ENDEN, WENN ANSCHLUSS AM HT ENDE
; ----------------------------------------------------------------------------------------
(defun calcHtEnden ()
	(setq b_at (Traeger.get Tr_ID b))
	(setq HTEnde 0)
	
	(if (= (Connect.get CastaData anHtLinkesEnde) 1)
		(progn
			(setq TrgEnde (Traeger.get Htrg links))
			(setq HTEnde 1)
		)
	)
	(if (= (Connect.get CastaData anHtRechtesEnde) 1)
		(progn
			(setq TrgEnde (Traeger.get Htrg rechts))
			(setq HTEnde 1)
		)
	)
	
	(if (= HTEnde 1)
		(TrEnde.set TrgEnde (delta_l (- (* 0.5 b_at))))
	)
)

; ----------------------------------------------------------------------------------------
; BERECHNET DIE HT-ENDEN, WENN ANSCHLUSS AM HT ENDE
; ----------------------------------------------------------------------------------------
(defun calcAtEnde ()
	(setq s_ht 				(Traeger.get Htrg s)
				delta_lr_ht	(Traeger.get Htrg delta_lr)
	)
	
	(if (= (Connect.get CastaData LinkesEnde) 1)
		(setq TrgEnde (Traeger.get Tr_ID links))
	)
	(if (= (Connect.get CastaData RechtesEnde) 1)
		(setq TrgEnde (Traeger.get Tr_ID rechts))
	)
	
	; halbe Stegbreite des HT (immer pos. -> Verkrzung)
	;(setq ablaengung_at	(* 0.5 s_ht))
	(setq ablaengung_at	5.0)
	
	
	; Anteil delta_lr Verschiebung des HT
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(progn
			(if (= (Connect.get CastaData vatr-vhtr)  1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1) (setq ablaengung_at (+ ablaengung_at delta_lr_ht)))
					(if (= (Connect.get CastaData satr-lhtr) -1) (setq ablaengung_at (- ablaengung_at delta_lr_ht)))
				)
			)
			(if (= (Connect.get CastaData vatr-vhtr) -1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1) (setq ablaengung_at (- ablaengung_at delta_lr_ht)))
					(if (= (Connect.get CastaData satr-lhtr) -1) (setq ablaengung_at (+ ablaengung_at delta_lr_ht)))
				)
			)
			(if (= (Connect.get CastaData vatr-lhtr)  1) (setq ablaengung_at (+ ablaengung_at delta_lr_ht)))
			(if (= (Connect.get CastaData vatr-lhtr) -1) (setq ablaengung_at (- ablaengung_at delta_lr_ht)))
		)
	)
	(if (= (Connect.get CastaData linkesEnde) 1)
		(progn
			(if (= (Connect.get CastaData vatr-vhtr)  1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1) (setq ablaengung_at (- ablaengung_at delta_lr_ht)))
					(if (= (Connect.get CastaData satr-lhtr) -1) (setq ablaengung_at (+ ablaengung_at delta_lr_ht)))
				)
			)
			(if (= (Connect.get CastaData vatr-vhtr) -1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1) (setq ablaengung_at (+ ablaengung_at delta_lr_ht)))
					(if (= (Connect.get CastaData satr-lhtr) -1) (setq ablaengung_at (- ablaengung_at delta_lr_ht)))
				)
			)
			(if (= (Connect.get CastaData vatr-lhtr)  1) (setq ablaengung_at (- ablaengung_at delta_lr_ht)))
			(if (= (Connect.get CastaData vatr-lhtr) -1) (setq ablaengung_at (+ ablaengung_at delta_lr_ht)))
		)
	)
	
	(if (= (Connect.get CastaData amAtSteg) 1)
		(setq ablaengung_at (- ablaengung_at))
	)
	
	(print delta_lr_ht)
	(print ablaengung_at)
	
	(TrEnde.set TrgEnde (delta_l ablaengung_at))
	
)


(defun calcAuflagerLaenge ()
	(print ">------------------------------------------------------------------------------")
	(print "BERECHNE DIE AUFLAGELNGE")
	
	(setq	b_ht 		(Traeger.get Htrg b)
		delta_lr_ht	(Traeger.get Htrg delta_lr)
	)
	
	(if (= (Connect.get CastaData linkesEnde) 1)	(setq AT_Ende (Traeger.get Tr_ID links)))
	(if (= (Connect.get CastaData rechtesEnde) 1)	(setq AT_Ende (Traeger.get Tr_ID rechts)))
	
	(setq delta_l_atende (TrEnde.get AT_Ende delta_l))
	(print delta_l_atende)
	
	(setq ht_links (- delta_lr_ht (* 0.5 b_ht)))
	(setq ht_rechts (+ ht_links b_ht))
	(print ht_links)
	(print ht_rechts)
	
	(setq trEnde_pos delta_l_atende)
	(print trEnde_pos)
	
	
	; SCHRAUBENBILD = 0 => normal
	; SCHRAUBENBILD = 1 => links/rechts
	
	(if (<= trEnde_pos ht_links)
		(progn
			(setq SCHRAUBENBILD 0)
		)
		(progn
			(if (> trEnde_pos ht_rechts)
				(progn
					(setq SCHRAUBENBILD 1)
				)
				(progn
					(setq SCHRAUBENBILD 1)
				)
			)
		)
	)
	
	
	(print "<------------------------------------------------------------------------------")
)