(defun init-traegerenden ()

  (print "++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++")
  (print "TRGERENDEN FR GEHRUNGSSTOSS")

;	(Connect.showAttributes CastaData)

  (setq TrLinks   (traeger.get tr_id links))
  (setq TrRechts  (traeger.get tr_id rechts))

  (setq HTrLinks   (traeger.get htrg links))
  (setq HTrRechts  (traeger.get htrg rechts))

	(setq a_winkel (Connect.get CastaData at_laengswinkel))
	(setq GlWinkel_new (Connect.get CastaData  v-atrgewnkl_kopf))

	(setq a_Winkel_neu 0.0)
	(if (> GlWinkel_new 90.0) (setq a_Winkel_neu (- GlWinkel_new 90.0)))
	(if (< GlWinkel_new 90.0) (setq a_Winkel_neu (- 90.0 GlWinkel_new)))

	(setq a_winkel a_Winkel_neu)
	 (if (= (Connect.get CastaData  anhtlinkesende  ) 1) (setq a_winkel (- 180.0 a_Winkel_neu)))

	(setq sinAW (sin (/ (* PI a_winkel) 180.0)))
	(setq tanAW (tan (/ (* PI a_winkel) 180.0)))
	(print tanAW)
	(print sinAW)

	 (setq sinAW_new (sin (/ (* PI a_Winkel_neu) 180.0)))
	 (setq tanAW_new (tan (/ (* PI a_Winkel_neu) 180.0)))

  (setq 	h_at        (Traeger.get Tr_ID h)
  			r_winkel_at	(Traeger.get Tr_ID r_winkel)
  			delta_v_at	(Traeger.get Tr_ID delta_v)
  )
  (setq 	h_ht        (Traeger.get HTrg  h)
			delta_v_ht	(Traeger.get Htrg  delta_v)
  )
  (setq delta_v_at (* 1.0 delta_v_at))
  (setq delta_v_ht (* 1.0 delta_v_ht))
  
  ; Bei Flachstahl gibt es keine Hhe (h - h_AT, h_HT) Daher ber t berechnen
  (setq qsTyp_AT (Traeger.get Tr_ID QsForm))
  (setq qsTyp_HT (Traeger.get Tr_ID QsForm))
  (if (= qsTyp_AT "F") (setq h_AT (Traeger.get Tr_ID t)))
  (if (= qsTyp_HT "F") (setq h_HT (Traeger.get HTrg  t)))
  
  
  (setq h_at_halb (* 0.5 h_at))
  (setq h_ht_halb (* 0.5 h_ht))
        
  (TrEndeReset)
  
  (calcWinkel)
	
	
	; neuer A-Winkel ...
	(setq AWinkel_New (- 180.0 OeffnWinkel))
	(setq sinAW (sin (/ (* PI AWinkel_New) 180.0)))
	(setq tanAW (tan (/ (* PI AWinkel_New) 180.0)))
	
	
	; delta_l aus delta_v HT berechnen
	; ------------------------------------
	(print "ANTEIL delta_v HT")
	(setq delta_v_ht (* 1.0 delta_v_ht))
	(setq htrg_dv_ht 0.0)
	(if (/= tanAW 0.0)
		(setq htrg_dv_ht (/ delta_v_ht tanAW))
	)

	(setq htrg_dv_at 0.0)
	(if (/= sinAW 0.0)
		(setq htrg_dv_at (/ delta_v_ht sinAW))
	)
	(print htrg_dv_at)
	
	 
	(if (= (Connect.get CastaData anHtLinkesEnde) 1)
		(progn
			(print "HT links")
			; gendert 2021-10-11
;			(if (= (Connect.get CastaData amHtOberflansch) 1)
;				(TrEnde.set HTrLinks (delta_l (- htrg_dv_ht)))
;			)
;			(if (= (Connect.get CastaData amHtUnterflansch) 1)
;				(TrEnde.set HTrLinks (delta_l htrg_dv_ht))
;			)
			(if (= (Connect.get CastaData amHtOberflansch) 1)
				(TrEnde.set HTrLinks (delta_l    htrg_dv_ht))
			)
			(if (= (Connect.get CastaData amHtUnterflansch) 1)
				(TrEnde.set HTrLinks (delta_l (- htrg_dv_ht)))
			)
		)
	)
	(if (= (Connect.get CastaData anHtRechtesEnde) 1)
		(progn
			(print "HT rechts")
			(if (= (Connect.get CastaData amHtOberflansch) 1)
				(TrEnde.set HTrRechts (delta_l htrg_dv_ht))
			)
			(if (= (Connect.get CastaData amHtUnterflansch) 1)
				(TrEnde.set HTrRechts (delta_l (- htrg_dv_ht)))
			)
		)
	)
	(if (= (Connect.get CastaData LinkesEnde) 1)
		(progn
			(print "aT links")
			(if (= (Connect.get CastaData amHtOberflansch) 1)
				(progn
					(TrEnde.set TrLinks (delta_l (- htrg_dv_at)))
				)
			)
			(if (= (Connect.get CastaData amHtUnterflansch) 1)
				(progn
					(print "HT UNTERFLANSCH")
					(TrEnde.set TrLinks (delta_l htrg_dv_at))
				)
			)
		)
	)
	(if (= (Connect.get CastaData RechtesEnde) 1)
		(progn
			(print "AT rechts")
			(if (= (Connect.get CastaData amHtOberflansch) 1)
				(TrEnde.set TrRechts (delta_l (- htrg_dv_at)))
			)
			(if (= (Connect.get CastaData amHtUnterflansch) 1)
				(TrEnde.set TrRechts (delta_l htrg_dv_at))
			)
			
		)
	)
	
	(if (= 1 1) (progn
	; delta_l aus delta_v AT berechnen
	; ------------------------------------
	(print "ANTEIL delta_v AT")
	(setq trg_dv_ht 0.0)
	(if (/= sinAW 0.0)
		(setq trg_dv_ht (/ delta_v_at sinAW))
	)
	(print trg_dv_ht)
	
	(setq trg_dv_at 0.0)
	(if (/= tanAW 0.0)	(setq trg_dv_at (/ delta_v_at tanAW)))
	(print trg_dv_at)
	
	(if (= (Connect.get CastaData amAtOberflansch) 1)
		(progn
			(setq trg_dv_ht (- trg_dv_ht))
			(setq trg_dv_at (- trg_dv_at))
		)
	)
  
  ; HAUPTTRGER
  (if (= (Connect.get CastaData anHtLinkesEnde) 1)
		(progn
			(setq delta_l_ht (TrEnde.get HTrLinks delta_l))
			(print "HT links")
			(if (= (Connect.get CastaData amHtOberflansch) 1)
				(progn
					(setq delta_l_ht (+ delta_l_ht trg_dv_ht))
					(TrEnde.set HTrLinks (delta_l delta_l_ht))
				)
			)
			(if (= (Connect.get CastaData amHtUnterflansch) 1)
				(progn
					(setq delta_l_ht (+ delta_l_ht trg_dv_ht))
					(TrEnde.set HTrLinks (delta_l delta_l_ht))
				)
			)
		)
	)
	(if (= (Connect.get CastaData anHtRechtesEnde) 1)
		(progn
			(print "HT rechts")
			(setq delta_l_ht (TrEnde.get HTrRechts delta_l))
			(if (= (Connect.get CastaData amHtOberflansch) 1)
				(progn
					(setq delta_l_ht (+ delta_l_ht trg_dv_ht))
					(TrEnde.set HTrRechts (delta_l delta_l_ht))
				)
			)
			(if (= (Connect.get CastaData amHtUnterflansch) 1)
				(progn
					(setq delta_l_ht (+ delta_l_ht trg_dv_ht))
					(TrEnde.set HTrRechts (delta_l delta_l_ht))
				)
			)
		)
	)
	
	; ANSCHLUSSTRGER
	(if (= (Connect.get CastaData at-von-oben) 1)
		(print "AT-von-Oben")
	)
	(if (= (Connect.get CastaData at-von-unten) 1)
		(print "AT-von-unten")
	)

	(if (= (Connect.get CastaData LinkesEnde) 1)
		(progn
			(print "aT links")
			(setq delta_l_at (TrEnde.get TrLinks delta_l))
			
			(if (= (Connect.get CastaData anHtRechtesEnde) 1) (TrEnde.set TrLinks (delta_l (- delta_l_at trg_dv_at))))
			(if (= (Connect.get CastaData anHtLinkesEnde) 1) (TrEnde.set TrLinks (delta_l (- delta_l_at trg_dv_at))))
		)
	)
	(if (= (Connect.get CastaData RechtesEnde) 1)
		(progn
			(print "AT rechts")
			(setq delta_l_at (TrEnde.get TrRechts delta_l))
;			(setq trg_dv_at (- trg_dv_at))

			(if (= (Connect.get CastaData anHtRechtesEnde) 1) (TrEnde.set TrRechts (delta_l (- delta_l_at trg_dv_at))))
			(if (= (Connect.get CastaData anHtLinkesEnde) 1) (TrEnde.set TrRechts (delta_l (- delta_l_at trg_dv_at))))
		)
	)
	
  ))
)


(defun calcGehrungsWinkel ()
	(setq OeffnWinkel (Connect.get CastaData oeffnungswinkel))
	(setq h1 (Traeger.get HTrg h))
	(setq h2 (Traeger.get Tr_ID h))

	(setq qsTyp_AT (Traeger.get Tr_ID QsForm))
	(setq qsTyp_HT (Traeger.get Tr_ID QsForm))
	(if (= qsTyp_HT "F") (setq h1 (Traeger.get HTrg  t)))
	(if (= qsTyp_AT "F") (setq h2 (Traeger.get Tr_ID t)))
	
	(setq sin_Oeff (sin (/ (* PI OeffnWinkel) 180.0)))
	(setq cos_Oeff (cos (/ (* PI OeffnWinkel) 180.0)))
	
	
	(setq Wg_Grad 0.0)
	(setq divTest (+ (/ h2 h1) cos_Oeff))
	(setq Calc_Allowed 1)
	(if (> divTest 0.0) (if (< divTest  0.000001) (setq Calc_Allowed 0)))
	(if (< divTest 0.0) (if (> divTest -0.000001) (setq Calc_Allowed 0)))

	(if (= Calc_Allowed 1) (progn
		(setq tan_WG (/ sin_Oeff (+ (/ h2 h1) cos_Oeff)))
		(setq Wg_rad (atan tan_WG))
		(setq Wg_Grad (/ (* 180.0 Wg_rad) PI))
	))
	(print Wg_Grad)
)
; ***************************************************************************************
;	
; ***************************************************************************************

(defun calcWinkel ()

	(calcGehrungsWinkel)
	(setq OeffnWinkel (Connect.get CastaData oeffnungswinkel))
	(setq ewinkel_at (- OeffnWinkel Wg_Grad))
	(setq ewinkel_ht Wg_Grad)

	(print ewinkel_ht) (print ewinkel_at)
	


	(if (= (Connect.get CastaData anHtRechtesEnde) 1)
		(progn
			(print "HT rechtes Ende")
			
				(if (= (Connect.get CastaData amHtUnterflansch) 1)	(setq ewinkel_ht ewinkel_ht))
				(if (= (Connect.get CastaData amHtOberflansch) 1)	(setq ewinkel_ht (- 180.0 ewinkel_ht)))
				(if (= (Connect.get CastaData amHtStegLinks) 1)		(setq ewinkel_ht (- 180.0 ewinkel_ht)))
				(if (= (Connect.get CastaData amHtStegRechts) 1)	(setq ewinkel_ht ewinkel_ht))

				; (if (= (Connect.get CastaData amHtUnterflansch) 1)	(setq ewinkel_ht (- 90.0 ewinkel_ht)))
				
				(if (= (Connect.get CastaData amHtFlansch) 1)	(TrEnde.set HTrRechts (v_winkel ewinkel_ht)))
				(if (= (Connect.get CastaData amHtSteg) 1)		(TrEnde.set HTrRechts (h_winkel ewinkel_ht)))
		)
	)
	(if (= (Connect.get CastaData anHtLinkesEnde) 1)
		(progn
			(print "HT linkes Ende")

				(if (= (Connect.get CastaData amHtUnterflansch) 1)	(setq ewinkel_ht (- 180.0 ewinkel_ht)))
				(if (= (Connect.get CastaData amHtOberflansch) 1)		(setq ewinkel_ht ewinkel_ht))
				(if (= (Connect.get CastaData amHtStegLinks) 1)			(setq ewinkel_ht ewinkel_ht))
				(if (= (Connect.get CastaData amHtStegRechts) 1)		(setq ewinkel_ht (- 180.0 ewinkel_ht)))

		
				(if (= (Connect.get CastaData amHtFlansch) 1)	(TrEnde.set HTrLinks (v_winkel ewinkel_ht)))
				(if (= (Connect.get CastaData amHtSteg) 1)		(TrEnde.set HTrLinks (h_winkel ewinkel_ht)))
		)
	)
	(print ewinkel_ht)
	
	
	
	(print ewinkel_at)
	(if (= (Connect.get CastaData RechtesEnde) 1) (progn
			(print "AT rechts")
			(if (= (Connect.get CastaData amATUnterflansch) 1) 
				(progn
					(print "AT rechts - AT UNTERF")
					(setq ewinkel_at ewinkel_at)
				)
			)
			(if (= (Connect.get CastaData amATOberflansch) 1) 
				(progn
					(print "AT OBERF")
					(setq ewinkel_at (- 180.0 ewinkel_at))
				)
			)
			
			(TrEnde.set TrRechts (v_winkel ewinkel_at))
	))
	(if (= (Connect.get CastaData LinkesEnde) 1) (progn
			(print "AT links")
			(if (= (Connect.get CastaData amATUnterflansch) 1) 
				(progn
					(print "AT links AT UNTERF")
					(setq ewinkel_at (- 180.0 ewinkel_at))
				)
			)
			(if (= (Connect.get CastaData amATOberflansch) 1) 
				(progn
					(print "AT OBERF")
					(setq ewinkel_at ewinkel_at)
				)
			)
			
			(TrEnde.set TrLinks (v_winkel ewinkel_at))
	))
	
	(print ewinkel_ht)
	(print ewinkel_at)
	
	(print "<------------------------------------------------------------------------------")

	
	
	
)
; ***************************************************************************************
;	
; ***************************************************************************************
(defun calcWinkel_Alt ()


	(print ">------------------------------------------------------------------------------")
	(print "BERECHNE WINKEL TRGERENDE")
	
	(if (= (Connect.get CastaData LinkesEnde)  1)	(setq At_Ende (Traeger.get Tr_ID links)))
	(if (= (Connect.get CastaData RechtesEnde) 1)	(setq At_Ende (Traeger.get Tr_ID rechts)))
	
	(if (= (Connect.get CastaData AnHtLinkesEnde)  1)	(setq Ht_Ende (Traeger.get Htrg links)))
	(if (= (Connect.get CastaData AnHtRechtesEnde) 1)	(setq Ht_Ende (Traeger.get Htrg links)))
	
	(setq wnkl_rkopf (Connect.get CastaData r-atrgewnkl_kopf))
	(setq wnkl_vkopf (Connect.get CastaData v-atrgewnkl_kopf))
	(setq wnkl_hkopf (Connect.get CastaData h-atrgewnkl_kopf))
	(print wnkl_vkopf)
	(print wnkl_hkopf)
	(print wnkl_rkopf)
	; Winkel berechnen
  ; ------------------------------------
  	; (setq a_winkel_Test (Connect.get CastaData at_laengswinkel))
	; (AlertBox a_winkel_Test) (AlertBox wnkl_vkopf)
	

	(print a_winkel)
	(setq neigung_at (- 90.0 a_winkel))
	(print neigung_at)
	(if (< neigung_at 0.0)
		(setq neigung_at (- neigung_at))
	)
  (AlertBox neigung_at)
	
	(setq OeffnWinkel (Connect.get CastaData oeffnungswinkel))
	(AlertBox OeffnWinkel)
	(setq neigung_at_Test (- OeffnWinkel 90.0))
	(AlertBox neigung_at_Test)
	(setq neigung_at neigung_at_Test)

	
	(setq cosNeigung (cos (/ (* PI neigung_at) 180.0)))
	(print cosNeigung)
	
	(setq abzug 0.0)
	(print tanAW)
	(if (/= tanAW 0.0)
		(setq abzug (/ h_ht tanAW))
	)
	(print abzug)
	
	(if (= (Connect.get CastaData anHtRechtesEnde) 1)
		(progn
			(if (> a_winkel 90.0)
				(setq abzug abzug)
				(setq abzug abzug)
			)
		)
	)
	(if (= (Connect.get CastaData anHtLinkesEnde) 1)
		(progn
			(if (> a_winkel 90.0)
				(setq abzug (- abzug))
				(setq abzug (- abzug))
			)
		)
	)
	(print abzug)
	
	(setq anteil_at 0.0)
	(if (/= cosNeigung 0.0)
	(setq anteil_at (/ h_at cosNeigung))
	)
	(print anteil_at)
	
	(setq help_var (- anteil_at abzug))
	(print help_var)
	
	(setq ewinkel_ht_rad 0.0)
	(if (/= help_var 0.0)
	(setq ewinkel_ht_rad (atan (/ h_ht help_var)))
	)
	(print ewinkel_ht_rad)
	
	(setq ewinkel_ht (* (/ ewinkel_ht_rad PI) 180.0))
	(print ewinkel_ht)
	
	(if (= (Connect.get CastaData anHtRechtesEnde) 1)
		(progn
			(print "HT rechtes Ende")
			(setq ewinkel_at (+ ewinkel_ht a_winkel))
			
				(if (= (Connect.get CastaData amHtUnterflansch) 1)	(setq ewinkel_ht ewinkel_ht))
				(if (= (Connect.get CastaData amHtOberflansch) 1)		(setq ewinkel_ht (- 180.0 ewinkel_ht)))
				(if (= (Connect.get CastaData amHtStegLinks) 1)			(setq ewinkel_ht (- 180.0 ewinkel_ht)))
				(if (= (Connect.get CastaData amHtStegRechts) 1)		(setq ewinkel_ht ewinkel_ht))

				; (if (= (Connect.get CastaData amHtUnterflansch) 1)	(setq ewinkel_ht (- 90.0 ewinkel_ht)))
				
				(if (= (Connect.get CastaData amHtFlansch) 1)	(TrEnde.set HTrRechts (v_winkel ewinkel_ht)))
				(if (= (Connect.get CastaData amHtSteg) 1)		(TrEnde.set HTrRechts (h_winkel ewinkel_ht)))
		)
	)
	(if (= (Connect.get CastaData anHtLinkesEnde) 1)
		(progn
			(print "HT linkes Ende")
			(setq ewinkel_at (- ewinkel_ht a_winkel))

				(if (= (Connect.get CastaData amHtUnterflansch) 1)	(setq ewinkel_ht (- 180.0 ewinkel_ht)))
				(if (= (Connect.get CastaData amHtOberflansch) 1)		(setq ewinkel_ht ewinkel_ht))
				(if (= (Connect.get CastaData amHtStegLinks) 1)			(setq ewinkel_ht ewinkel_ht))
				(if (= (Connect.get CastaData amHtStegRechts) 1)		(setq ewinkel_ht (- 180.0 ewinkel_ht)))

		
				(if (= (Connect.get CastaData amHtFlansch) 1)	(TrEnde.set HTrLinks (v_winkel ewinkel_ht)))
				(if (= (Connect.get CastaData amHtSteg) 1)		(TrEnde.set HTrLinks (h_winkel ewinkel_ht)))
		)
	)
	(print ewinkel_ht)
	
	
	
	(print ewinkel_at)
	(if (= (Connect.get CastaData RechtesEnde) 1) (progn
			(print "AT rechts")
			(if (= (Connect.get CastaData amATUnterflansch) 1) 
				(progn
					(print "AT rechts - AT UNTERF")
					(setq ewinkel_at (- 180.0 ewinkel_at))
					(AlertBox wnkl_vkopf)
					; (setq ewinkel_at (+ 180.0 (- 90.0 ewinkel_at))) ; ----------------------------- 2021)
				)
			)
			(if (= (Connect.get CastaData amATOberflansch) 1) 
				(progn
					(print "AT OBERF")
					(setq ewinkel_at ewinkel_at)
				)
			)
			
			(TrEnde.set TrRechts (v_winkel ewinkel_at))
	))
	(if (= (Connect.get CastaData LinkesEnde) 1) (progn
			(print "AT links")
			(if (= (Connect.get CastaData amATUnterflansch) 1) 
				(progn
					(AlertBox "AT UNTERF")
					(setq ewinkel_at ewinkel_at)
					(AlertBox wnkl_vkopf)
					; (setq ewinkel_at (+ 180.0 (- 90.0 ewinkel_at))) ; ----------------------------- 2021)
				)
			)
			(if (= (Connect.get CastaData amATOberflansch) 1) 
				(progn
					(print "AT OBERF")
					(setq ewinkel_at (- 180.0 ewinkel_at))
				)
			)
			
			(TrEnde.set TrLinks (v_winkel ewinkel_at))
	))
	
	(print ewinkel_ht)
	(print ewinkel_at)
	
	(print "<------------------------------------------------------------------------------")

)
  
(defun TrEndeReset ()
	(if (= (Connect.get CastaData LinkesEnde) 1) 	(setq At_Ende (Traeger.get Tr_ID links)))
	(if (= (Connect.get CastaData RechtesEnde) 1) (setq At_Ende (Traeger.get Tr_ID rechts)))
	
	(TrEnde.set At_Ende (delta_l 	0.0)
											(h_winkel 0.0)
											(v_winkel 0.0)
	)
	
	(if (= (Connect.get CastaData anHtLinkesEnde) 1) 	(setq Ht_Ende (Traeger.get Htrg links)))
	(if (= (Connect.get CastaData anHtRechtesEnde) 1) (setq Ht_Ende (Traeger.get Htrg rechts)))
	
	(TrEnde.set Ht_Ende (delta_l 	0.0)
											(h_winkel 0.0)
											(v_winkel 0.0)
	)
)