(defun init-traegerenden (abst)
	(print "++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++")
 
;  (Connect.showAttributes CastaData)

  (setq qsform_ht (Traeger.get Htrg qsform))
  (setq qsform_at	(Traeger.get Tr_ID qsform))
  
  (setq xSchnp		(connect.get CastaData xSp)
  	ySchnp		(connect.get CastaData ySp)
  	zSchnp		(connect.get CastaData zSp)
  	htanschlfl	(connect.get CastaData htanschlfl)
  	htmodify	(connect.get CastaData htmodify)
  	xpos_ht		(connect.get CastaData xpos_ht)
  	anzAnschl	(connect.get CastaData anz_weitere_anschl)
  )
  
  (if (= (connect.get CastaData amHtFlansch) 1) (print "Anschluss am Hautptrgerflansch"))
  (if (= (connect.get CastaData amHtSteg)    1) (print "Anschluss am Hautptrgersteg"))
  
	;linkes und rechtes Trgerende des Anschlusstrgers
  (setq TrLinks   (traeger.get tr_id links))
  (setq TrRechts  (traeger.get tr_id rechts))
	
	;linkes und rechtes Trgerende der Sttze
  (setq HTrLinks   (traeger.get htrg links))
  (setq HTrRechts  (traeger.get htrg rechts))


  (setq _links 1 _rechts 2)

  (setq bFlansch 0 yAkl 0 dxs 0 r_Winkel_at 0)
  (setq bFlansch (Traeger.get Tr_ID b))			; Ersatzwert bestimmen
  (setq bFlansch 0)					; Ersatzwert bestimmen

  
  (print anzAnschl)
	(if (= anzAnschl 0)
	    (progn
			; Verlngerung des Endes am Haupttrger
		(if (= (connect.get CastaData anHtLinkesEnde) 1) 
		  	(progn
				(print "-- linkes Haupttrgerende")
				(calcHaupttrg_TrgEnde HTrLinks)
		    )
		)
		(if (= (connect.get CastaData anHtRechtesEnde) 1) 
		  	(progn
				(print "-- rechtes Haupttrgerende")
				(calcHaupttrg_TrgEnde HTrRechts)
		    )
		)
	    )
	)
	
  ; Trgerende-Ablngung aufgrund des Sttzenprofils (Anschlusstrger)
  (if (= (connect.get CastaData RechtesEnde) 1) 
  	(progn
  		(print "Anschluss rechts am Anschlusstrger")
		(TrEnde.set TrRechts (endSpecial 0))	; initialisieren Abschrgungen, Schlitze, etc.
  		
		(berechneTrgEndeAblng TrRechts abst)
		(if (= qsform_ht "I")
			(berechneAusklinkungTrg TrRechts abst)
		)
		(if (= qsform_ht "U") (progn
		    ; Wenn am U-Rcken, dann braucht nichts ausgeklinkt zu werden.
		    (if (= (connect.get CastaData at-von-rechts) 1) (progn
			(berechneAusklinkungTrg TrRechts abst)
		    ))
		))
  	)
  )
  (if (= (connect.get CastaData LinkesEnde) 1) 
  	(progn
  		(print "Anschluss links am Anschlusstrger")
		(TrEnde.set TrLinks (endSpecial 0))	; initialisieren Abschrgungen, Schlitze, etc.

		(berechneTrgEndeAblng TrLinks abst)
		(if (= qsform_ht "I")
			(berechneAusklinkungTrg TrLinks abst)
		)
		(if (= qsform_ht "U") (progn
		    ; Wenn am U-Rcken, dann braucht nichts ausgeklinkt zu werden.
		    (if (= (connect.get CastaData at-von-links) 1) (progn
			(berechneAusklinkungTrg TrLinks abst)
		    ))
		))
  	)
  )

	(berechneATEndeWinkelHoriz)

  (print "++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++")
)



;----------------------------------------------------------------------- */
; Berechnung der Ablngung des Anschlusstrgers
; ---------------------------------------------------------------------- */
(defun berechneTrgEndeAblng (TrgEnde abstandTrgSteg)
	(print "------------------------------------------------------------")
	(print "BERECHNE AT-ENDE")

	(setq	s_htrg		(Traeger.get Htrg s)	;Stegdicke des Haupttrgers
		delta_lr_htrg	(Traeger.get Htrg delta_lr)
		b_ht		(Traeger.get Htrg b)
	)
	
	(setq	delta_v_trg 	(Traeger.get Tr_ID delta_v)
		delta_lr_trg 	(Traeger.get Tr_ID delta_lr)
	)
	(print delta_v_trg)
	
	(setq vWnklAT (Connect.get CastaData at_laengswinkel))
	(print vWnklAT)
	
	(if (= (Connect.get CastaData linkesEnde) 1)
		(progn
			(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq v_winkel_soll (- 180.0 vWnklAT)) )
			(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq v_winkel_soll vWnklAT) )
			(if (= (Connect.get CastaData satr-lhtr)  1)	(setq h_winkel_soll (- 180.0 vWnklAT)) )
			(if (= (Connect.get CastaData satr-lhtr) -1)	(setq h_winkel_soll vWnklAT) )				
		)
	)
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(progn
			(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq v_winkel_soll vWnklAT) )
			(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq v_winkel_soll (- 180.0 vWnklAT)) )
			(if (= (Connect.get CastaData satr-lhtr)  1)	(setq h_winkel_soll vWnklAT) )
			(if (= (Connect.get CastaData satr-lhtr) -1)	(setq h_winkel_soll (- 180.0 vWnklAT)) )		
		)
	)
		
	(if v_winkel_soll
		(TrEnde.set TrgEnde (v_winkel v_winkel_soll))
	)
	(if h_winkel_soll
		(TrEnde.set TrgEnde (h_winkel h_winkel_soll))
	)
	
	
	(setq sinW (sin (* PI (/ vWnklAT 180.0)))
			  tanW (tan (* PI (/ vWnklAT 180.0)))
	)
	
	(print tanW)
	(print delta_lr_htrg)
	(setq delta_l_aus_s_htrg 0.0)
	(if (= qsform_ht "I")	(setq delta_l_aus_s_htrg (* 0.5 s_htrg)))
	(if (= qsform_ht "U")	
		(progn
			(if (= (Connect.get CastaData amHtStegLinks) 1)		(setq delta_l_aus_s_htrg 0))
			(if (= (Connect.get CastaData amHtStegRechts) 1)	(setq delta_l_aus_s_htrg s_htrg))
		)
	)
	(if (= qsform_ht "K")	(setq delta_l_aus_s_htrg (* 0.5 b_ht)))
	(if (= qsform_ht "R")	(setq delta_l_aus_s_htrg (* 0.5 b_ht)))
	(if (= qsform_ht "F")	(setq delta_l_aus_s_htrg (* 0.5 b_ht)))
	
	(print delta_l_aus_s_htrg)
	
	; Anteil der Ablngung aus der Verschiebung des HT nach links bzw. rechts
	(if (= (Connect.get CastaData amHtStegRechts) 1)
		(progn
			(if (= (connect.get CastaData LinkesEnde) 1) 	(setq delta_lr_htrg (- delta_lr_htrg)))
			(if (= (connect.get CastaData RechtesEnde) 1) (setq delta_lr_htrg delta_lr_htrg))
		)
	)
	(if (= (Connect.get CastaData amHtStegLinks) 1)
		(progn
			(if (= (connect.get CastaData LinkesEnde) 1) 	(setq delta_lr_htrg delta_lr_htrg))
			(if (= (connect.get CastaData RechtesEnde) 1) (setq delta_lr_htrg (- delta_lr_htrg)))
		)
	)
	(print delta_lr_htrg)
	
	
	; Soll-Abstand zwischen Steg und Trgerende
	(if (= (Connect.get CastaData amHtStegRechts) 1)
		(progn
			(if (= (connect.get CastaData LinkesEnde) 1) 	(setq delta_l_soll (- (+ delta_l_aus_s_htrg abstandTrgSteg) delta_lr_htrg)))
			(if (= (connect.get CastaData RechtesEnde) 1) (setq delta_l_soll (+ delta_l_aus_s_htrg abstandTrgSteg delta_lr_htrg))) 
		)
	)
	(if (= (Connect.get CastaData amHtStegLinks) 1)
		(progn
			(if (= (connect.get CastaData LinkesEnde) 1) 	(setq delta_l_soll (- (+ delta_l_aus_s_htrg abstandTrgSteg) delta_lr_htrg)))
			(if (= (connect.get CastaData RechtesEnde) 1) (setq delta_l_soll (+ delta_l_aus_s_htrg abstandTrgSteg delta_lr_htrg))) 
		)
	)
	(print delta_l_soll)
	
	(setq delta_l_aus_delta_v (/ delta_v_trg tanW))
	(setq delta_l_aus_delta_lr (/ delta_lr_trg tanW))
	(print delta_l_aus_delta_v)
	(print sinW)
	(print delta_l_aus_delta_v)
	
	(if (= (connect.get CastaData vatr-lhtr)  1) 
		(setq delta_l_muss (+ (/ delta_l_soll sinW) delta_l_aus_delta_v)) ; Ablngung des Trgers um Soll-Abstand zu erhalten 
	)
	(if (= (connect.get CastaData vatr-lhtr) -1) 
		(setq delta_l_muss (- (/ delta_l_soll sinW) delta_l_aus_delta_v)) ; Ablngung des Trgers um Soll-Abstand zu erhalten 
	)
	(if (= (connect.get CastaData satr-lhtr)  1) 
		(setq delta_l_muss (+ (/ delta_l_soll sinW) delta_l_aus_delta_lr)) ; Ablngung des Trgers um Soll-Abstand zu erhalten 
	)
	(if (= (connect.get CastaData satr-lhtr) -1) 
		(setq delta_l_muss (- (/ delta_l_soll sinW) delta_l_aus_delta_lr)) ; Ablngung des Trgers um Soll-Abstand zu erhalten 
	)
	(print delta_l_muss)

	; falls die Ablngung schon ausreicht, dann nicht ndern im Copy-Modus
	(setq delta_L_Vorhanden (trEnde.get TrgEnde delta_L))
	(if (= (Connect.get CastaData CopyMode) 1) (progn
		(if (> delta_L_Vorhanden delta_l_muss) (setq delta_l_muss delta_L_Vorhanden))
	))
	(trEnde.set TrgEnde (delta_l 	delta_l_muss))
  (print "------------------------------------------------------------")
)


;----------------------------------------------------------------------- */
; Berechnung des horizontalen Winkels am AT-Ende
; ---------------------------------------------------------------------- */
(defun berechneATEndeWinkelHoriz ()
	(print "BERECHNE HORIZONTALEN ENDWINKEL DES AT")
	(print ">-----------------------------------------------------------")
	
	(if (= (Connect.get CastaData linkesEnde) 1)	(setq ATEnde (Traeger.get Tr_ID links)))
	(if (= (Connect.get CastaData rechtesEnde) 1)	(setq ATEnde (Traeger.get Tr_ID rechts)))
	
	(setq h_endwinkel_at (Connect.get CastaData h-atrgewnkl_steg))
	(print h_endwinkel_at)
	
	(setq h_winkel_at h_endwinkel_at)
	(print h_winkel_at)
	
	(TrEnde.set ATEnde (h_winkel h_winkel_at))
	(print "<-----------------------------------------------------------")
)

;----------------------------------------------------------------------- */
; Berechnung der Ausklinkungen des Anschlusstrgers
; ---------------------------------------------------------------------- */
(defun berechneAusklinkungTrg (TrgEnde abstandZumSteg)
	(print "------------------------------------------------------------")
	(print "BERECHNUNG DER AUSKLINKUNGEN")
	
	(setq	h_at 		(Traeger.get Tr_ID h)
		b_at		(Traeger.get Tr_ID b)
		delta_lr_at	(Traeger.get Tr_ID delta_lr)
		delta_v_at	(Traeger.get Tr_ID delta_v)
		r_winkel_at	(Traeger.get Tr_ID r_winkel)
		hc_at		(Traeger.get Tr_ID hc)
		qsform_at	(Traeger.get Tr_ID qsform)
	)
	
	(setq	h_ht		(Traeger.get Htrg h)
		b_ht		(Traeger.get Htrg b)
		hc_ht		(Traeger.get Htrg hc)
		r_ht		(Traeger.get Htrg r)
		t_ht		(Traeger.get Htrg t)
		s_ht		(Traeger.get Htrg s)
		delta_v_ht	(Traeger.get Htrg delta_v)
	)
	
	; Orientierung ermitteln
	; 	0 = Flansche parallel
	;		1 = Flansche kreuzen
	(if (= (Connect.get CastaData satr-vhtr)  1)	(setq ori 1))
	(if (= (Connect.get CastaData vatr-vhtr)  1)	(setq ori 0))
	(if (= (Connect.get CastaData satr-vhtr) -1)	(setq ori 1))
	(if (= (Connect.get CastaData vatr-vhtr) -1)	(setq ori 0))
	
	(print ori)
	
	; Berechnen der 4 Linien - TrgerOK, TrgerUK, obere Ausrundungslinie, untere Ausrundungslinie
	(setq zOK_HProf (- delta_v_ht (* 0.5 h_ht))		; Oberkante der Profile (neg. nach oben)
        zOK_AProf (- delta_v_at (* 0.5 h_at))
  )
	(setq zUK_HProf (+ zOK_HProf h_ht)				; Unterkante der Profile (neg. nach oben)
        zUK_AProf (+ zOK_AProf h_at)
  )
  ; obere Ausrundung der Profile
	(setq okAusr_Ht (+ zOK_HProf (* 0.5 (- h_ht hc_ht)))
		    okAusr_At (+ zOK_AProf (* 0.5 (- h_at hc_at)))
	)
	(setq ukAusr_Ht (+ okAusr_Ht hc_ht)	; untere Ausrundung der Profile
		    ukAusr_At (+ okAusr_At hc_at)
	)
	
	; linke und rechte Seite des AT
	
	(setq liKante_At (* 0.5 b_at))
	(setq reKante_At (- liKante_At b_at))
	(print liKante_At)
	(print reKante_At)
	
	; Bercksichtigung der AT_Rotation fr linke und rechte Seite des AT
	(setq h_at_halb (* 0.5 h_at))
	(setq b_at_halb (* 0.5 b_at))
	
	(setq diagonale (sqrt (+ (* h_at_halb h_at_halb) (* b_at_halb b_at_halb))))
	(print diagonale)
	
	(setq t_alpha_rad (acos (/ b_at_halb diagonale)))
	(print t_alpha_rad)
	
	(setq t_alpha_grad (/ (* t_alpha_rad 180.0) PI))
	(print t_alpha_grad)
	
	(setq wnkl (+ t_alpha_grad r_winkel_at))
	(print wnkl)
	
	(setq cosWW (cos (/ (* PI wnkl) 180.0)))
	(print cosWW)
	
	(setq x_neu (* diagonale cosWW))
	(print x_neu)
		
	
	
	
	(setq reKante_At (- x_neu))
	(setq liKante_At x_neu)
		
	(print liKante_At)
	(print reKante_At)
	
	; Anteil delta_lr AT
	
	(setq cosRotW (cos (/ (* PI r_winkel_at) 180.0)))
	
	(setq anteil_dlr_at (* delta_lr_at cosRotW))
	
	(if (= (Connect.get CastaData satr-vhtr) -1)
		(progn
			(setq liKante_At (- liKante_At anteil_dlr_at))
			(setq reKante_At (- reKante_At anteil_dlr_at))
		)
		
	)
	(if (= (Connect.get CastaData satr-vhtr)  1)
		(progn
			(setq liKante_At (- liKante_At anteil_dlr_at))
			(setq reKante_At (- reKante_At anteil_dlr_at))
			
			(setq liKante_At (- liKante_At))
			(setq reKante_At (- reKante_At))
		)
		
	)
	(print  liKante_At)
	(print  reKante_At)
	
	
	(if (= qsform_at "U")
		(progn
			(setq liKante_At delta_lr_at)
			(setq reKante_At (+ liKante_At b_at))
		)
	)
	
	(print zOK_HProf)
	(print zUK_HProf)
	(print okAusr_Ht)
	(print ukAusr_Ht)
	(print zOK_AProf)
	(print zUK_AProf)
	(print okAusr_At)
	(print ukAusr_At)
	(print liKante_At)
	(print reKante_At)
	
	(setq xakl 0)
	(setq yakl 0)
	(setq zakl 0)
   	(setq hSteg 0)
	
	; parallele Flansche (wie UZ-UZ)
	(if (= ori 0)
		(progn
			; Prfung, ob Ausklinkung notwendig ist
			; +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
			(print "FLANSCHE PARALLEL")
  		(setq diff_zakl 0)
		  ; Berechnung der oberen Ausklingungshhe
			; zAkl
			; Erfordlich, wenn OK des Anschlussprofils oberhalb der Ausrundungslinie des
			; Haupttrgerprofils liegt
		  (if (<= zOK_AProf okAusr_ht) 
		  	(progn
				(print "Oben ist eine Ausklinkung erforderlich")
		   		(setq	zAkl1 (+  (- zOK_AProf) okAusr_Ht)
		        		zAkl2 (+  (- zOK_AProf) okAusr_At)
		   		)
		   
		   		(if (> zAkl1 zAkl2) (progn
			      		(setq zAkl zAkl1)
			      		(setq diff_zakl (- zAkl1 zAkl2))
		      		    )
			      	    (progn
			       		(setq zAkl zAkl2)
			       		(setq diff_zakl (- zAkl2 zAkl1))
			      	    )
		   		)
		   		(setq xakl (- (* 0.5 (- s_ht b_ht))))
		   		(if (< zAkl 0) 	(progn
		   				(setq zAkl 0)
		   				(setq xakl 0)
		   		))		; Keine Ausklinkung erforderlich
			); progn
		   	(progn
		    		(print "Oben ist keine Ausklinkung oben erforderlich")
				(setq zAkl 0)
		      
			)
		  )
  
		  ; Berechnung der unteren Ausklinkung
		  ; Ist diese Ausklinkung  unten erforderlich?
		  ; Nur dann, wenn UK Profil oberhalb der unteren Ausrundungslinie liegt
		  (if (> zUK_AProf ukAusr_Ht) 
		  	(setq U_AKL_erforderlich 1)
		   	(setq U_AKL_erforderlich 0)
		  )   
   
		  (if (= U_AKL_erforderlich 1) 
		   	(progn
		   		(print "Unten ist eine Ausklinkung erforderlich")
		   		; die Hhen nach unten sind negativ. Deswegen den kleineren Wert suchen
		   		(if (< ukAusr_Ht ukAusr_At) 
		   			(setq ukRelevant ukAusr_Ht)
		   			(setq ukRelevant ukAusr_At)
				)
				(setq untereAkl (- h_at ukRelevant))
				(setq hSteg (- h_at untereAkl (+ zAkl zOK_AProf)))
		   		(setq xakl (- (* 0.5 (- s_ht b_ht))))
			)
			(progn
		   		(print "Unten ist keine Ausklinkung erforderlich!")
			)
		  )
		);PROGN ENDE
	); IF ENDE
		
	(if (= ori 1)
		(progn
			(print "FLANSCHE KREUZEN")
			(print "------------------------------------")
			(print zOK_HProf)
			(print zUK_HProf)
			(print "---------")
			(print okAusr_Ht)
			(print ukAusr_Ht)
			(print liKante_At)
			(print reKante_At)
			
			
			
			; Absolutbetrge
			(if (< okAusr_Ht 0.0)
				(setq okAusr_Ht_abs (- okAusr_Ht))
				(setq okAusr_Ht_abs okAusr_Ht)
			)
			(if (< ukAusr_Ht 0.0)
				(setq ukAusr_Ht_abs (- ukAusr_Ht))
				(setq ukAusr_Ht_abs ukAusr_Ht)
			)
			(if (< liKante_At 0.0)
				(setq liKante_At_abs (- liKante_At))
				(setq liKante_At_abs liKante_At)
			)
			(if (< reKante_At 0.0)
				(setq reKante_At_abs (- reKante_At))
				(setq reKante_At_abs reKante_At)
			)
			(print "---------")
			(print okAusr_Ht_abs)
			(print ukAusr_Ht_abs)
			(print liKante_At_abs)
			(print reKante_At_abs)
			
			(print hc_ht)
			
			(setq xakl 0)
			
			(if (= (Connect.get CastaData satr-vhtr)  1)
				(progn
					(if (<= liKante_At okAusr_ht) 
				  	(progn
							(print "links ist eine Ausklinkung erforderlich")
				   		(setq	yAkl (+  (- liKante_At) okAusr_Ht))
				   		(print yakl)
				   		(setq xakl (- (* 0.5 (- s_ht b_ht))))
				   		(print xakl)
				   		(if (< yAkl 0); Keine Ausklinkung erforderlich
				   			(progn
				   				 (setq yAkl 0)
				   				 (setq xakl 0)
				   			)
				   		)		
				    ); progn
				   	(progn
				    	(print "links ist keine Ausklinkung erforderlich")
				      (setq yAkl 0)
				    )
				  )
		  
				  (if (> reKante_At ukAusr_Ht) 
				  	(setq RE_AKL_erforderlich 1)
				   	(setq RE_AKL_erforderlich 0)
				  )   
		   
		   		(setq bFlansch 0)
				  (if (= RE_AKL_erforderlich 1) 
				   	(progn
				   		(print "rechts ist eine Ausklinkung erforderlich")
				   		(setq xakl (- (* 0.5 (- s_ht b_ht))))
				   		(setq rechteAkl (- reKante_At ukAusr_Ht_abs))
				   		(print rechteAkl)
							;(setq bflansch (- b_at rechteAkl (+ yAkl reKante_At)))
							(setq bflansch (- b_at rechteAkl yAkl ))
							(print bflansch)
				    )
				    (progn
				   		(print "rechts ist keine Ausklinkung erforderlich!")
				    )
				  )
				)
			)
			(if (= (Connect.get CastaData satr-vhtr) -1)
				(progn
					(setq bflansch 0.0)
					(if (<= reKante_At okAusr_ht) 
				  	(progn
							(print "rechts ist eine Ausklinkung erforderlich")
				   		(setq rechteAkl (- okAusr_ht reKante_AT))
				   		(print rechteAkl)
				   		
				   		(setq bflansch (- b_at rechteAkl))
				   		(print bflansch)
				   		(setq yAkl 0)
				   		(print yAkl)
				   		(setq xakl (- (* 0.5 (- s_ht b_ht))))
				    ); progn
				   	(progn
				    	(print "rechts ist keine Ausklinkung erforderlich")
				    	(setq yAkl 0)
				    	(setq xakl 0)
							(setq rechteAkl 0.0)
				    )
				  )
		  
				  (if (> liKante_At ukAusr_Ht) 
				  	(setq LI_AKL_erforderlich 1)
				   	(setq LI_AKL_erforderlich 0)
				  )
				  
				  (if (= LI_AKL_erforderlich 1)
				  	(progn
				  		(print "links ist eine Ausklinkung erforderlich")
				  		(setq yAkl (- liKante_At_abs ukAusr_Ht_abs))
				  		(setq xakl (- (* 0.5 (- s_ht b_ht))))
							
							(setq bflansch (- b_at rechteAkl yAkl ))
							(print bflansch)
				  	)
				  	(progn
				  		(print "links ist keine Ausklinkung erforderlich")
				  		(setq yAkl 0)
				  		
				  	)
				  ) 
				)
			)
			
			
			
			(setq zakl 0)
			(setq hsteg 0)
		)
	)
	
	;(setq xakl (+ xakl 10.0))

	(print xakl)
	(print yakl)
	(print zakl)
	(print hsteg)
		
	(if (> zakl h_AT) (setq zakl 0))
	
	(if xakl 	(trende.set TrgEnde (xakl 			xAKL)))
	(if yakl 	(trende.set TrgEnde (yakl 			yakl)))
	(if zakl 	(trende.set TrgEnde (zakl 			zakl)))
	(if hsteg 	(trende.set TrgEnde (hsteg 			hsteg)))
	(if bflansch 	(trende.set TrgEnde (bflansch 	bflansch)))
	
	;(trende.set TrgEnde (xakl 	xAKL)
	;										(yakl		yakl)
	;										(zakl  	zakl)
	;										(hsteg 	hSteg)
	;										(bflansch bflansch)
	;)
				
  
  (print "------------------------------------------------------------")
)



; ---------------------------------------------------------------------- */
(defun calcHaupttrg_TrgEnde (HTrg_TrEnde)
	(print "------------------------------------------------------------")
	(print "BERECHNE HT-ENDE")

	(setq HWnkl_Merken  (TrEnde.get HTrg_TrEnde H_Winkel)
	      deltaL_Merken (TrEnde.get HTrg_TrEnde delta_l)
	)
								
	(setq trgEndeWinkel (Connect.get CastaData afl_hwinkel))
	(print trgEndeWinkel)
	(if (= (Connect.get CastaData amHtStegLinks) 1)
		(setq trgEndeWinkel (- 180.0 trgEndeWinkel))
	)

	; Winkel des HT-Endes setzen
	(trEnde.set HTrg_TrEnde (H_Winkel (- trgEndeWinkel)))
	
	(setq tanW (tan (* PI (/ (- trgEndeWinkel 90.0) 180.0))))
	(setq cosW (cos (* PI (/ (- trgEndeWinkel 90.0) 180.0))))
	(print tanW)
	(print cosW)					
					

  ;(if (= anHTrgEnde 1) (progn   
	;(trEnde.set HTrg_TrEnde (V_Winkel trgEndeWinkel))

	;(setq hProf (traeger.get tr_id h))
	;(setq  delta_L (- (/ hProf 2.0)))
	;(setq delta_L_alt (TrEnde.get HTrg_TrEnde delta_l))
		;						(print delta_L_alt)
	; ist negativ - deswegen so rum abfragen. Wenn das Ende zu kurz ist, dann
	; muss es verlngert werden.
	;(if (> delta_L_alt delta_L)  (trende.set  HTrg_TrEnde (delta_l delta_L)))
  ;    )
  ; )

   (setq dvHTrID (Traeger.get HTrg delta_V))
   (setq tanW (tan (* PI (/ (- trgEndeWinkel 90.0) 180.0))))
   (TrEnde.set HTrg_TrEnde (delta_l (* dvHTrID tanW)))
   


   (setq cosW (cos (* PI (/ (- trgEndeWinkel 90.0) 180.0))))
   (setq dvTrID (Traeger.get Tr_ID delta_V))
   (if (/= cosW 0.0) (setq dvTrID (/ dvTrID cosW)))
   (TrEnde.ptrim    HTrg_TrEnde dvTrID)
   
;   (TrEnde.set HTrg_TrEnde (delta_l 0.0) (V_Winkel 90.0))

   
   (if (= (connect.get CastaData anhtlinkesende) 1)
	(TrEnde.set HTrg_TrEnde (delta_l (* dvHTrID tanW)))
   )
   (if (= (connect.get CastaData anhtrechtesende) 1)
	(TrEnde.set HTrg_TrEnde (delta_l (* (- dvHTrID) tanW)))
   )

   (print tanW)
   (print dvHTrID)

   (setq hProf (traeger.get Tr_ID h)
         dvTrID (Traeger.get Tr_ID delta_V)
   )
   (TrEnde.ptrim    HTrg_TrEnde (- dvTrID (* 0.5 hProf)))

   ; (AF) Nov.2009 - 	Profile werden nur verlngert aber nicht verkrzt
   ;			deswegen werden die alten Daten zurckkopiert, wenn
   ;			der Trger krzer werden sollte.
   (setq deltaL_Neu  (TrEnde.get HTrg_TrEnde delta_l))
   (if (> deltaL_Neu deltaL_Merken) (progn
	(TrEnde.set HTrg_TrEnde (H_Winkel HWnkl_Merken)
				(delta_l  deltaL_Merken)
	)
   ))

	(print "------------------------------------------------------------")
)

; derzeit nur verwendet von:
; - uz_an_stzCoup
(defun calcHTrgEndeAblaengung_Stz ()

  	(setq anzAnschl	 (connect.get CastaData anz_weitere_anschl))
  	(setq HTrLinks   (traeger.get htrg links))
  	(setq HTrRechts  (traeger.get htrg rechts))

	(if (= anzAnschl 0) (progn
			; Verlngerung des Endes am Haupttrger
		  (if (= (connect.get CastaData anHtLinkesEnde) 1) (progn
					(print "-- linkes Haupttrgerende")
					(calcHaupttrg_TrgEnde HTrLinks)
		  ))
		  (if (= (connect.get CastaData anHtRechtesEnde) 1) (progn
					(print "-- rechtes Haupttrgerende")
					(calcHaupttrg_TrgEnde HTrRechts)
		  ))
	))

)
