; --------------------------------------------------------------------------
;	Modul - wird verwendet von Druckrohr an Flansch
;	Anschlssen
;	letzte nderung: 12-2012 - Ablngung fr alle Winkel angepasst
(defun init-traegerenden ()
	
	(berechneAtEndeWinkel)
	(berechneAtEndeAblng)
)
; --------------------------------------------------------------------------
; --------------------------------------------------------------------------
(defun berechneAtEndeWinkel ()
	
	(print "*clear*")

	
	(if (= (Connect.get CastaData linkesEnde) 1)
		(setq AT_Ende (Traeger.get Tr_ID links))
	)
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(setq AT_Ende (Traeger.get Tr_ID rechts))
	)

	(setq at_v_winkel (Connect.get CastaData at_laengswinkel))
	(setq at_h_winkel (Connect.get CastaData at_rotawinkel))
	
	(setq at_v_winkel_flansch (Connect.get CastaData v-atrgewnkl_flansch))
	(setq at_h_winkel_flansch (Connect.get CastaData h-atrgewnkl_flansch))
	
	(setq	h_ht 		(Traeger.get Htrg h)
		delta_v_ht	(Traeger.get Htrg delta_v)
	)
	
	(TrEnde.set AT_Ende (delta_l 0))
	
	; Winkel
	; --------------------------------------------------------------------------------------
	(if (= 1 2)	(progn
	; --------------------------------------------------------------------------------------
	(if (= (Connect.get CastaData linkesEnde) 1)
		(progn
			(if (/= (Connect.get CastaData satr-shtr)  0)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq v_winkel_ende (- 180.0 at_v_winkel)) )
					(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq v_winkel_ende at_v_winkel) )
				)
			)
			(if (/= (Connect.get CastaData vatr-shtr)  0)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq h_winkel_ende (- 180.0 at_v_winkel)) )
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq h_winkel_ende at_v_winkel) )		
				)
			)		
		)
	)
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(progn
			(if (/= (Connect.get CastaData satr-shtr)  0)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq v_winkel_ende at_v_winkel) )
					(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq v_winkel_ende (- 180.0 at_v_winkel)) )
				)
			)
			(if (/= (Connect.get CastaData vatr-shtr)  0)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq h_winkel_ende at_v_winkel) )
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq h_winkel_ende (- 180.0 at_v_winkel)) )	
				)
			)
		)
	)
	; --------------------------------------------------------------------------------------
	))
	; --------------------------------------------------------------------------------------
	
	
	; neue Winkelberechnung
	; ----------------------------------------------
	
	(if (= (Connect.get CastaData amHtFlansch) 1)	
		(progn
			(setq h_winkel_ende at_h_winkel_flansch)
			(setq v_winkel_ende at_v_winkel_flansch)
		)
	)
		
	
	(if v_winkel_ende
		(TrEnde.set AT_Ende (v_winkel v_winkel_ende))
	)
	(if h_winkel_ende
		(TrEnde.set AT_Ende (h_winkel h_winkel_ende))
	)
	
	
)
; -----------------------------------------------------------
(defun berechneAtEndeAblng ()
; (debug on)
	(setq	VE_Winkel	(TrEnde.get  AT_Ende V_Winkel)
		HE_Winkel	(TrEnde.get  AT_Ende H_Winkel)
		delta_v_At	(Traeger.get Tr_ID delta_v)
		delta_lr_At	(Traeger.get Tr_ID delta_lr)
	)

	(setq delta_L_ausVEW 0.0)
	(setq delta_L_ausHEW 0.0)

	(setq tanBe1 0)
	(if (< VE_Winkel 89.5) (setq tanBe1 1))
	(if (> VE_Winkel 90.5) (setq tanBe1 1))
	(if (> tanBe1 0) (progn
		(setq tanVEW (tan (/ (* PI VE_Winkel) 180.0)))
		(setq delta_L_ausVEW (/ delta_v_At tanVEW))
	))

	(setq tanBe1 0)
	(if (< HE_Winkel 89.5) (setq tanBe1 1))
	(if (> HE_Winkel 90.5) (setq tanBe1 1))
	(if (> tanBe1 0) (progn
		(setq tanHEW (tan (/ (* PI HE_Winkel) 180.0)))
		(setq delta_L_ausHEW (/ delta_lr_At tanHEW))
	))

	(setq delta_l_neu (+ delta_L_ausVEW delta_L_ausHEW))
	
	(if (= (Connect.get CastaData LinkesEnde) 1) (setq delta_l_neu (- delta_l_neu)))
	

    	(TrEnde.set AT_Ende (delta_l delta_l_neu))
    	
    	
    	(setq	h_HT 	(Traeger.get HTrg h)
    		h_HT_2  (/ h_HT 2.0)
    		dv_HT	(Traeger.get HTrg delta_V)
    	)
	(if (= (Connect.get CastaData amHtUnterFlansch) 1) (setq dv_HT (- dv_HT)))
    	
    	
    	(TrEnde.ptrim  AT_Ende (- h_HT_2 dv_HT))

; (debug off)
)
; -----------------------------------------------------------
