(defun init-traegerenden ()
	
  (print "in mod-endinit-uz-stzsteg");
  
	;(connect.showAttributes CastaData)
  
  (setq connTest (connect.create))

  (setq xSchnp     (connect.get CastaData xSp)
  			ySchnp     (connect.get CastaData ySp)
  			zSchnp     (connect.get CastaData zSp)
  			htanschlfl (connect.get CastaData htanschlfl)
  			htmodify   (connect.get CastaData htmodify)
  			xpos_ht    (connect.get CastaData xpos_ht)
  )
  
  (if (= (connect.get CastaData amHtFlansch) 1) (print "Anschluss am Hautptrgerflansch"))
  (if (= (connect.get CastaData amHtSteg)    1) (print "Anschluss am Hautptrgersteg"))
  
	;linkes und rechtes Trgerende des Anschlusstrgers
  (setq TrLinks   (traeger.get tr_id links))
  (setq TrRechts  (traeger.get tr_id rechts))
	
	;linkes und rechtes Trgerende der Sttze
  (setq HTrLinks   (traeger.get htrg links))
  (setq HTrRechts  (traeger.get htrg rechts))

	(setq _links 1 _rechts 2)

	(setq abstandZumFlansch 10)
	
  ; Trgerende-Ablngung aufgrund des Sttzenprofils (Anschlusstrger)
  (if (= (connect.get CastaData RechtesEnde) 1) 
  	(progn
  		(print "Anschluss rechts am Anschlusstrger")
  		
			(berechneTrg TrRechts abstandZumFlansch)
			(trimATEnde TrRechts)
  	)
  )
  (if (= (connect.get CastaData LinkesEnde) 1) 
  	(progn
  		(print "Anschluss links am Anschlusstrger")
  		
			(berechneTrg TrLinks abstandZumFlansch)
			(trimATEnde TrLinks)
  	)
  )

	(if (= (Connect.get CastaData anz_weitere_anschl) 0)
		(if (= (connect.get CastaData AnschlzwHtEnden) 0)
			(progn
				(if (= (Connect.get CastaData anHtLinkesEnde) 1)
					(berechneTraegerEnde HTrLinks)
				)
				(if (= (Connect.get CastaData anHtRechtesEnde) 1)
					(berechneTraegerEnde HTrRechts)
				)			
			)
		)
	)

  
)

;----------------------------------------------------------------------- */
; Verlngert den HT bei Anschluss am Trgerende
; ---------------------------------------------------------------------- */
(defun berechneTraegerEnde (TrgEnde)
	
	(setq b_trg (Traeger.get Tr_ID b))
	(setq delta_l (- (* 0.5 b_trg)))
	(TrEnde.set TrgEnde (delta_l delta_l))
	
)

;----------------------------------------------------------------------- */
; Verlngert/Verkrzt den AT bei delta_lr Verschiebung des HT
; ---------------------------------------------------------------------- */
(defun trimATEnde (TrgEnde)
	(setq delta_lr_ht (Traeger.get Htrg delta_lr))
	
	(if (= (Connect.get CastaData amHTStegRechts) 1)
		(TrEnde.ptrim TrgEnde delta_lr_ht)
	)
	(if (= (Connect.get CastaData amHTStegLinks) 1)
		(TrEnde.ptrim TrgEnde (- delta_lr_ht))
	)
)

;----------------------------------------------------------------------- */
; Berechnung der Ausklinkungen des Anschlusstrgers
; ---------------------------------------------------------------------- */
(defun berechneTrg (TrgEnde abstandZumFlansch)
	(print "BERECHNE AT")
	(print "----------------------")
	(setq b_ht				(Traeger.get Htrg b)
				s_ht				(Traeger.get Htrg s)
				qsform_ht		(Traeger.get Htrg qsform)
	)
	
	(if (= qsform_ht "I")
		(setq delta_l_trgEnde	(+ (* 0.5 b_ht) abstandZumFlansch))
	)
	(if (= qsform_ht "U")
		(progn
			(if (= (Connect.get CastaData amHtStegLinks) 1)
				(setq delta_l_trgEnde	abstandZumFlansch)
			)
			(if (= (Connect.get CastaData amHtStegRechts) 1)
				(setq delta_l_trgEnde	(+ b_ht abstandZumFlansch))
			)
		)
	)
  
  (TrEnde.set TrgEnde (delta_l delta_l_trgEnde))
  (print "ENDE AUSKLINKUNGEN")
	(print "----------------------")
  
)




