; nderungsmarker
; AF-05-2012


(defun init-traegerenden ()
	(print "################################################################################")
  (print "mod-endinit-uz-stzsteg");
  (print "################################################################################")
	;(connect.showAttributes CastaData)
  
  (if (= (Connect.get CastaData amHTSteg) 0) (progn
  	(AlertBox "Achtung - Steganschluss ist eigentlich nicht mglich.\nAblngung und Trgerendewinkel knnen nicht verlsslich berechnet werden."  "WRN_WebConnectProblem")
  ))
  
    (setq okAusr_HtProf 		0.0
			okAusr_AnProf 		0.0
	)

  
  (setq	connTest (connect.create))

  (setq	xSchnp     (connect.get CastaData xSp)
  	ySchnp     (connect.get CastaData ySp)
  	zSchnp     (connect.get CastaData zSp)
  	htanschlfl (connect.get CastaData htanschlfl)
  	htmodify   (connect.get CastaData htmodify)
  	xpos_ht    (connect.get CastaData xpos_ht)
  )
  
  (setq qsform_ht		(Traeger.get Htrg qsform))
	
  (if (= (connect.get CastaData amHtFlansch) 1) (print "Anschluss am Hautptrgerflansch"))
  (if (= (connect.get CastaData amHtSteg)    1) (print "Anschluss am Hautptrgersteg"))
  
	;linkes und rechtes Trgerende des Anschlusstrgers
  (setq TrLinks   (traeger.get tr_id links))
  (setq TrRechts  (traeger.get tr_id rechts))
	
	;linkes und rechtes Trgerende der Sttze
  (setq HTrLinks   (traeger.get htrg links))
  (setq HTrRechts  (traeger.get htrg rechts))

	(setq _links 1 _rechts 2)

	;; gendert 2008-09-23 - AF 
	;; U-Profile wurden auch bei Rckenanschluss ausgeklinkt,
	;; Trimmen wurde nicht korrekt berechnet (am Rcken 0, Stegseite dagegen s)
	(setq AusklMoeglich 1)				; Ausklinkung kann vorhanden sein
							; bei U-Profil-Rcken-Anschluss nicht ...

	(setq abstandZumSteg 10.0)
	(if (= qsform_ht "K")	(setq abstandZumSteg 0.0))
	(if (= qsform_ht "U")	(progn
	    (if (= (Connect.get CastaData amHTStegLinks)  1) (setq AusklMoeglich 0))
	))
  ; Anschlusstrgerende-Ablngung aufgrund des Sttzenprofils (Anschlusstrger)
  (if (= (connect.get CastaData RechtesEnde) 1) 
  	(progn
  		(print "Anschluss rechts am Anschlusstrger")
			(initEnde TrRechts)
			(berechneATEndeWnkl TrRechts)
			(if (= AusklMoeglich 1) (berechneAusklinkungTrg TrRechts abstandZumSteg))
			(trimATEnde TrRechts)
  	)
  )
  (if (= (connect.get CastaData LinkesEnde) 1) 
  	(progn
  		(print "Anschluss links am Anschlusstrger")
			(initEnde TrLinks)
			(berechneATEndeWnkl TrLinks)
			(if (= AusklMoeglich 1) (berechneAusklinkungTrg TrLinks abstandZumSteg))
			(trimATEnde TrLinks)
  	)
  )

	; Berechnung des HT-Endes bei Anschluss am selbigen
	(if (= (connect.get CastaData AnschlzwHtEnden) 0)
		(progn
			(if (= (Connect.get CastaData anz_weitere_anschl) 0)
				(progn
					(if (= (Connect.get CastaData anHtLinkesEnde) 1)
						(berechneTraegerEnde HTrLinks)
					)
					(if (= (Connect.get CastaData anHtRechtesEnde) 1)
						(berechneTraegerEnde HTrRechts)
					)
				)
			)			
		)
	)

  (print "################################################################################")
)


(defun initEnde (TRG_ENDE)
	(trende.set TRG_ENDE 	
			(xakl 		0.0)
			(zakl  		0.0)
			(hsteg 		0.0)
			(delta_l 	0.0)
			(V_Winkel	90.0)	; nur zum debuggen
			(H_Winkel	90.0)	; dito
	)
)

;----------------------------------------------------------------------- */
; Verlngert den HT bei Anschluss am Trgerende
; ---------------------------------------------------------------------- */
(defun berechneTraegerEnde (TrgEnde)
	
	(print "KORREGIERE HT-ENDE ...")
	
	(setq qsform_ht (Traeger.get Htrg qsform))
	(setq qsform_at	(Traeger.get Tr_ID qsform))
	
	(setq afl_winkel (Connect.get CastaData afl_hwinkel))
	(print afl_winkel)
	
	(setq b_ht	(Traeger.get Htrg b))
	
	(if (= (Connect.get CastaData linkesEnde) 1)	(setq AtEnde (Traeger.get Tr_ID links)))
	(if (= (Connect.get CastaData rechtesEnde) 1)	(setq AtEnde (Traeger.get Tr_ID rechts)))
	
	(setq hscherl_at (TrEnde.get AtEnde hscherl))
	
	(setq hscherl_halb (* 0.5 hscherl_at))
		
	(setq b_ht_halb (* 0.5 b_ht))
	
	(setq tanAfl (tan (/ (* PI afl_winkel) 180.0)))
	(print tanafl)

	(setq delta_l_ht 0.0)

	(if (= qsform_ht "I")
		(progn
			(if (= qsform_at "I")
				(progn
					(setq verl_1 (/ b_ht_halb tanafl))
					(print verl_1)
	
					(setq delta_l_ht (- delta_l_ht hscherl_halb))
					(print delta_l_ht)
					
					(if (= (Connect.get CastaData anHtLinkesEnde) 1)	(setq delta_l_ht (+ delta_l_ht verl_1)))
					(if (= (Connect.get CastaData anHtRechtesEnde) 1)	(setq delta_l_ht (- delta_l_ht verl_1)))
					
					;(TrEnde.set TrgEnde (delta_l delta_l_ht))
				)
			)
			(if (= qsform_at "U")
				(progn
					(setq verl_2 (/ b_ht tanafl))
					(print verl_2) 
					
					(if (= (Connect.get CastaData anHtLinkesEnde) 1)
						(progn
							(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta_l_ht 0.0))
							(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta_l_ht (- hscherl_at)))
						)
					)
					(if (= (Connect.get CastaData anHtRechtesEnde) 1)
						(progn
							(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta_l_ht (- hscherl_at)))
							(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta_l_ht 0.0))
						)
					)
					
					;(if (= (Connect.get CastaData anHtLinkesEnde) 1)	(setq delta_l_ht (+ delta_l_ht verl_2)))
					;(if (= (Connect.get CastaData anHtRechtesEnde) 1)	(setq delta_l_ht (- delta_l_ht verl_2)))
					
					;(TrEnde.set TrgEnde (delta_l delta_l_ht))
				)	
			)
		)
	)
	(if (= qsform_ht "U")
		(progn
			(if (= qsform_at "I")
				(progn
					(setq verl_1 (/ b_ht_halb tanafl))
					(print verl_1)
	
					(setq delta_l_ht 0.0)
					
					(setq delta_l_ht (- delta_l_ht hscherl_halb))
					(print delta_l_ht)
					
					(if (= (Connect.get CastaData anHtLinkesEnde) 1)	(setq delta_l_ht (+ delta_l_ht verl_1)))
					(if (= (Connect.get CastaData anHtRechtesEnde) 1)	(setq delta_l_ht (- delta_l_ht verl_1)))
					
					;(TrEnde.set TrgEnde (delta_l delta_l_ht))
				)
			)
			(if (= qsform_at "U")
				(progn
					
					(if (= (Connect.get CastaData anHtLinkesEnde) 1)
						(progn
							(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta_l_ht 0.0))
							(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta_l_ht (- hscherl_at)))
						)
					)
					(if (= (Connect.get CastaData anHtRechtesEnde) 1)
						(progn
							(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta_l_ht (- hscherl_at)))
							(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta_l_ht 0.0))
						)
					)
					
					;(TrEnde.set TrgEnde (delta_l delta_l_ht))
				)	
			)
		)
	)
	
	; Anteil delta_lr Verschiebung AT
	; ----------------------------------------------
	(setq delta_lr_at (Traeger.get Tr_ID delta_lr))
	(print delta_lr_at)
	
	(if (= (Connect.get CastaData anHtLinkesEnde) 1)
		(progn
			(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta_l_ht (+ delta_l_ht delta_lr_at)))
			(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta_l_ht (- delta_l_ht delta_lr_at)))
		)
	)
	(if (= (Connect.get CastaData anHtRechtesEnde) 1)
		(progn
			(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta_l_ht (- delta_l_ht delta_lr_at)))
			(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta_l_ht (+ delta_l_ht delta_lr_at)))
		)
	)
	
	(print delta_l_ht)
	(TrEnde.set TrgEnde (delta_l delta_l_ht))
	(print "KORREKTUR FERTIG")
	
)

;----------------------------------------------------------------------- */
; Verlngert/Verkrzt den AT 
; ---------------------------------------------------------------------- */
(defun trimATEnde (TrgEnde)
	(print  "trimATEnde")

	(setq toTrim 0.0)
	
	; Anteil HT-Steg
	; -----------------------------------------------------------------
	(if (= 1 1)	(progn
	; -----------------------------------------------------------------
		(setq s_ht (Traeger.get Htrg s))
		(setq s_ht_halb (* 0.5 s_ht))
	
		(setq toTrim (+ toTrim s_ht_halb))
		(if (= qsform_ht "U") (progn
		  (if (= (Connect.get CastaData amHTStegLinks)  1) (setq toTrim 0.0))
		  (if (= (Connect.get CastaData amHTStegRechts) 1) (setq toTrim s_ht))
		))

		(if (= qsform_ht "K") (progn
		    (setq b_ht (Traeger.get Htrg b))
		    (setq toTrim (* 0.5 b_ht))
		))

	; -----------------------------------------------------------------
	))
	; -----------------------------------------------------------------
	
	; Anteil Verschiebung delta_lr beim HT
	; -----------------------------------------------------------------
	(if (= 1 1)	(progn
	; -----------------------------------------------------------------
		(setq delta_lr_ht (Traeger.get Htrg delta_lr))
	
		(if (= (Connect.get CastaData amHTStegRechts) 1)	(setq toTrim (+ toTrim delta_lr_ht)))
		(if (= (Connect.get CastaData amHTStegLinks) 1)		(setq toTrim (- toTrim delta_lr_ht)))
	; -----------------------------------------------------------------
	))
	; -----------------------------------------------------------------
	
	; Anteil Verschiebung delta_lr beim AT
	; -----------------------------------------------------------------
	(if (= 1 1)	(progn
	; -----------------------------------------------------------------
		(setq delta_lr_at (Traeger.get Tr_ID delta_lr))
		(print delta_lr_at)
		(setq at_h_wnkl_steg (Connect.get CastaData h-atrgewnkl_steg))
		(print at_h_wnkl_steg)
		
		(setq cosAW (cos (/ (* PI at_h_wnkl_steg) 180.0)))
		(print cosAW)
		
		(setq anteil_dlr_at (* delta_lr_at cosAW))
		; AF-09-2012
		(if (= (Connect.get CastaData rechtesEnde) 1) (setq  anteil_dlr_at (- anteil_dlr_at)))
		
		; AF-05-2012
		; knnte alles ausgemistet werden, wenn geprft
		(if (= (Connect.get CastaData amHtStegLinks) 1)
			(progn
;				(if (= (Connect.get CastaData vatr-vhtr)	1)
;					(progn
;						(if (= (Connect.get CastaData satr-lhtr)  1)	(setq toTrim (- toTrim anteil_dlr_at)))
;						(if (= (Connect.get CastaData satr-lhtr) -1)	(setq toTrim (+ toTrim anteil_dlr_at)))
;					)
;				)
;				(if (= (Connect.get CastaData vatr-vhtr) -1)
;					(progn
;						(if (= (Connect.get CastaData satr-lhtr)  1)	(setq toTrim (+ toTrim anteil_dlr_at)))
;						(if (= (Connect.get CastaData satr-lhtr) -1)	(setq toTrim (- toTrim anteil_dlr_at)))
;					)
;				)
				(if (= (Connect.get CastaData satr-lhtr-ex)  0)	(setq toTrim (- toTrim anteil_dlr_at)))
				(if (= (Connect.get CastaData satr-lhtr-ex)  1)	(setq toTrim (- toTrim anteil_dlr_at)))
				(if (= (Connect.get CastaData satr-lhtr-ex) -1)	(setq toTrim (- toTrim anteil_dlr_at)))
			)
		)
		(if (= (Connect.get CastaData amHtStegRechts) 1)
			(progn
;				(if (= (Connect.get CastaData vatr-vhtr)	1)
;					(progn
;						(if (= (Connect.get CastaData satr-lhtr-ex)  1)	(setq toTrim (+ toTrim anteil_dlr_at)))
;						(if (= (Connect.get CastaData satr-lhtr-ex) -1)	(setq toTrim (- toTrim anteil_dlr_at)))
;					)
;				)
;				(if (= (Connect.get CastaData vatr-vhtr) -1)
;					(progn
;						(if (= (Connect.get CastaData satr-lhtr-ex)  1)	(setq toTrim (- toTrim anteil_dlr_at)))
;						(if (= (Connect.get CastaData satr-lhtr-ex) -1)	(setq toTrim (+ toTrim anteil_dlr_at)))
;					)
;				)
				(if (= (Connect.get CastaData satr-lhtr-ex)  0)	(setq toTrim (- toTrim anteil_dlr_at)))
				(if (= (Connect.get CastaData satr-lhtr-ex)  1)	(setq toTrim (- toTrim anteil_dlr_at)))
				(if (= (Connect.get CastaData satr-lhtr-ex) -1)	(setq toTrim (- toTrim anteil_dlr_at)))
			)
		)
	; -----------------------------------------------------------------
	))
	; -----------------------------------------------------------------
	
	
	; Anteil Verschiebung delta_v beim AT
	; -----------------------------------------------------------------
	(if (= 1 1)	(progn
	; -----------------------------------------------------------------
		(setq delta_v_at (Traeger.get Tr_ID delta_v))
		(print delta_v_at)
		(setq at_v_wnkl_steg (Connect.get CastaData v-atrgewnkl_steg))
		(print at_v_wnkl_steg)
		
		(setq cosVW (cos (/ (* PI at_v_wnkl_steg) 180.0)))
		(print cosVW)
		
		(setq anteil_dv_at (* (* 1.0 delta_v_at) cosVW))
			
		(print anteil_dv_at)
		
		;; (if (= (Connect.get CastaData amHtStegLinks) 1)		(setq toTrim (- toTrim anteil_dv_at)))
		;; (if (= (Connect.get CastaData amHtStegRechts) 1)	(setq toTrim (- toTrim anteil_dv_at)))

		(if (= (Connect.get CastaData linkesEnde) 1)	(setq toTrim (- toTrim anteil_dv_at)))
		(if (= (Connect.get CastaData rechtesEnde) 1)	(setq toTrim (+ toTrim anteil_dv_at)))
	; -----------------------------------------------------------------
	))
	; -----------------------------------------------------------------
	
	(print toTrim)
	; Wert setzen
	; -----------------------------------------------------------------
	(TrEnde.ptrim TrgEnde toTrim)
	
)



;----------------------------------------------------------------------- */
; Berechnung der Ausklinkungen des Anschlusstrgers
; ---------------------------------------------------------------------- */
(defun berechneAusklinkungTrg (TrgEnde abstandZumSteg)
	(print ">-------------------------------------------------------------------------------")
	(print "BERECHNE AUSKLINKUNGEN")
	(print "----------------------")
	; Einholen aller Profildaten
  (setq		h_HtProf  (Traeger.get hTrg   h)
				h_AnProf  (Traeger.get Tr_ID  h)
				h_dOK     (traeger.get hTrg   delta_v)
				a_dOK     (traeger.get Tr_id  delta_v)
				hc_HtProf (Traeger.get hTrg   hc)
				hc_AnProf (Traeger.get Tr_ID  hc)
				rwinkel_at	(Traeger.get Tr_ID r_winkel)
  )
	
	(setq vscherl_at (TrEnde.get TrgEnde vscherl))
	(print vscherl_at)
	
	; Berechnen der 4 Linien - TrgerOK, TrgerUK, obere Ausrundungslinie, untere Ausrundungslinie

  (setq		zHProf (- h_dOK (* 0.5 h_HtProf))		; Oberkante der Profile (neg. nach oben)
				zAProf (- a_dOK (* 0.5 h_AnProf))
  )
  (print zHProf)
  (print zAProf)
	(setq	zUK_HProf (+ zHProf h_HtProf)				; Unterkante der Profile (neg. nach oben)
				zUK_AProf (+ zAProf h_AnProf)
  )
  (print zUK_HProf)
  (print zUK_AProf)
 
  ; obere Ausrundung der Profile
  (if (= hc_AnProf 0) (progn
	(setq  t_AT (Traeger.get Tr_ID t))
	
	(setq qsForm_AT (Traeger.get Tr_ID qsForm))
	(if (= qsForm_AT "K") (setq  hc_AnProf (-  h_AnProf  t_AT  t_AT)))
	(if (= qsForm_AT "I") (setq  hc_AnProf (-  h_AnProf  t_AT  t_AT)))
	(if (= qsForm_AT "U") (setq  hc_AnProf (-  h_AnProf  t_AT  t_AT)))
	(if (= qsForm_AT "C") (setq  hc_AnProf (-  h_AnProf  t_AT  t_AT)))
	(if (= qsForm_AT "T") (setq  hc_AnProf (-  h_AnProf  t_AT)))
  ))
  
  (setq okAusr_HtProf (+ zHProf (* 0.5 (- h_HtProf hc_HtProf)))
			okAusr_AnProf (+ zAProf (* 0.5 (- h_AnProf hc_AnProf)))
  )
  (print okAusr_HtProf)
  (print okAusr_AnProf)
  (setq		ukAusr_HtProf (+ okAusr_HtProf hc_HtProf)	; untere Ausrundung der Profile
				ukAusr_AnProf (+ okAusr_AnProf hc_AnProf)
  )
  (print ukAusr_HtProf)
  (print ukAusr_AnProf)
  
  ; NDERUNG FR ROTIERTE TRGER
  ; **********************************************************
	
	
	(if (= (Connect.get CastaData vatr-vhtr) -1) (progn
			(setq zaProf_tmp zaProf)
			(setq zuk_aprof_tmp zuk_aprof)
			(setq okausr_anprof_tmp okausr_anprof)
			(setq ukausr_anprof_tmp ukausr_anprof)
			
			(setq zaProf (- zuk_aprof_tmp))
			(setq zuk_aprof (- zaProf_tmp))
			(setq okausr_anprof (- ukausr_anprof_tmp))
			(setq ukausr_anprof (- okausr_anprof_tmp))
	))
	(print "----------------------------------------------------")
	(print zaProf)
	(print zuk_aprof)
	(print okausr_anprof)
	(print ukausr_anprof)
	  
  ; **********************************************************
  
  ; Berechnung der oberen Ausklingungshhe
	; zAkl
	; Erfordlich, wenn OK des Anschlussprofils oberhalb der Ausrundungslinie des
	; Haupttrgerprofils liegt
  (if (< zAProf okAusr_HtProf) 
  	(progn
		(print "Oben ist eine Ausklinkung erforderlich")
   		(setq	zAkl1 (+  (- zAProf) okAusr_HtProf)
					zAkl2 (+  (- zAProf) okAusr_AnProf)
   		)
   		(print zakl1)
   		(print zakl2)
   		
   		(if (> zAkl1 zAkl2) 	(progn
				(setq zAkl zAkl1)
				;(setq diff_zakl (- zAkl1 zAkl2))
			)
			(progn
				(setq zAkl zAkl2)
				;(setq diff_zakl (- zAkl2 zAkl1))
      	))
   		(if (< zAkl 0) (setq zAkl 0))		; Keine Ausklinkung erforderlich
    ); progn
   	(progn
    	(print "Oben ist keine Ausklinkung oben erforderlich")
		(setq zAkl 0)
    )
  )

  ; Berechnung der unteren Ausklinkung
	; Ist diese Ausklinkung  unten erforderlich?
	; Nur dann, wenn UK Profil oberhalb der unteren Ausrundungslinie liegt
  (if (> zUK_AProf ukAusr_HtProf) 
  	(setq U_AKL_erforderlich 1)
   	(setq U_AKL_erforderlich 0)
   )   
   
   (setq hSteg 0)
   (if (= U_AKL_erforderlich 1) 
   	(progn
   		(print "Unten ist eine Ausklinkung erforderlich")
   		; die Hhen nach unten sind negativ. Deswegen den kleineren Wert suchen
   		(if (< ukAusr_HtProf ukAusr_AnProf) 
   			(setq ukRelevant ukAusr_HtProf)
   			(setq ukRelevant ukAusr_AnProf)
		)
		(setq untereAkl (- h_AnProf ukRelevant))
		(setq hSteg (- h_AnProf untereAkl (+ zAkl zAProf)))
		(setq za_Value (* 1.0 (+ zAkl zAProf)))
		(setq za_Value (runde za_Value auf 5))
		(setq rund_uAkl (runde untereAkl auf 5))
		(setq hSteg (- h_AnProf rund_uAkl za_Value))
    )
    (progn
   		(print "Unten ist keine Ausklinkung erforderlich!")
    )
  )
  
  
  ; ab hier nun Setzen der Traegerinformationen
	(setq bProf 	(Traeger.get hTrg b))
	(setq sProf 	(Traeger.get hTrg s))
	(setq qsForm	(Traeger.get hTrg qsForm))
	(print qsForm)
	(print "-----------")
	
	(setq h_dOK (Traeger.get hTrg  delta_v))			(print h_dOK)
	(setq a_dOK (Traeger.get Tr_id delta_v))			(print a_dOK)
 
  (setq alter_hWinkel (TrEnde.get TrgEnde h_Winkel))		
  (print alter_hWinkel)
  
  (setq hwinkel (Connect.get CastaData at_laengswinkel))
  (print hwinkel)
  
  (setq delta_L 0 xAKL 0)
  
  (if (= qsForm "C") (setq qsForm "U"))
  (if (= qsForm "c") (setq qsForm "U"))
	; -- Profil-Ausklinkungsdaten
	; Abhngig vom Profil !!!
	(if (= qsForm "U")
		(progn
			(if (= (Connect.get CastaData amHtStegLinks) 1)
				(progn
					(setq  delta_L 0)
					(setq  xAKL    0)
					
				)
			)
			(if (= (Connect.get CastaData amHtStegRechts) 1)
				(progn
					(setq  delta_L sProf )
					(setq  xAKL    (- bProf delta_L))
				)
			)
		)
	)
	(if (= qsform "T")
		(progn
			(setq  delta_L (* 0.5 sProf))
			(setq  xAKL    (- (* 0.5 bProf) delta_L))
		)
	)
	(if (= qsform "I")
		(progn
			(setq  delta_L (* 0.5 sProf))
			(setq  xAKL    (- (* 0.5 bProf) delta_L))
		)
	)
	(if (= qsform "K")
		(progn
			(setq  delta_L (* 0.5 bProf))
			(setq  xAKL    0.0)
		)
	)
	(if (= qsForm "Z")
		(progn
			(setq  delta_L (* 0.5 sProf))
			(setq  xAKL    0.0)
		)
	)

	(print hwinkel)
	(print delta_l)
	; Winkel bercksichtigen, da Ausklinkungsl-gen und delta_l in Trgerrichtung definiert ist
	(setq sinWkl (sin (/ (* PI hwinkel) 180.0)) 
	      cosWkl (cos (/ (* PI hwinkel) 180.0)) 
	)
	
	(print sinWkl)
	(print cosWkl)
	
	(if (/= sinWkl 0.0) 
		(progn
			(if (< sinWkl 0.0)
				(setq sinWkl (- sinWkl))
			)
	    (setq delta_L (/ delta_L sinWkl))
	    (setq xAKL    (/ xAKL    sinWkl))
		)
	)
		
	
	; Ausklinkung
	; ------------------------------------------------------------------
	;(setq xAKL (runde xAKL auf 5))
	;(setq zAKL (runde zAKL auf 5))
   	
  (print zakl)
  (print hsteg)
 
	(if (= (Connect.get CastaData vatr-vhtr) -1)
		(progn
			(setq zakl_tmp zakl)
			(setq hsteg_tmp hsteg)
			
			(if (/= zakl_tmp 0.0)
				(progn
					(setq zakl_tmp (runde zakl_tmp auf 5))
					(if (/= hsteg_tmp 0.0)
						(progn
							(setq zakl (- h_AnProf (+ zakl_tmp hsteg_tmp)))
							(setq hsteg hsteg_tmp)
						)
						(progn
							(setq zakl 0)
							(setq hsteg (- h_AnProf zakl_tmp))
						)
					)
				)
				(progn
					(if (/= hsteg_tmp 0.0)
						(progn
							(setq hsteg 0)
							(setq zakl (- h_AnProf hsteg_tmp))
						)
					)
				)
			)
		)
	)
  (print zakl)
  (print hsteg) 	
  
  (setq SetDatenFlag 0)
  (if (> zAkl 0.0) (progn
        (setq SetDatenFlag 1)				; Flag setzen
	(setq	t_at 	(Traeger.get Tr_ID t)
		r_at	(Traeger.get Tr_ID r)
	)
	(setq zAkl_min (+ t_at r_at))
	(print zAkl_min)
			
	(if (< zAkl zAkl_min)	(setq zAkl zAkl_min))
			
  ))
  (if (> hSteg 0.0) (setq SetDatenFlag 1))				; Flag setzen
  
  
  (if (> xAkl 0)  (progn
  	(setq xAkl_n  (runde xAkl  auf 5))
  	(if (< (- xAkl_n xAkl) 5.0) (setq xAkl_n  (runde (+ xAkl 5.0)  auf 5)))
  	(setq xAkl xAkl_n)
  ))
  
  (if (> zAkl 0)  (setq zAkl  (runde zAkl  auf 5)))
  (if (> hSteg 0) (setq hSteg (runde hSteg ab  5)))
  
   ;; prfen der symmetrischen Ausklinkung
   (setq h_AT (Traeger.get Tr_ID h)
		 h_HT (Traeger.get HTrg h)
   )
   (if (= h_AT h_HT) (progn
		(setq u_zAkl (- h_AT hSteg zAkl))
		(if (/= u_zAkl zAkl) (progn
			(setq hSteg (- h_AT zAkl zAkl))
		))
   ))
  
  ; Wenn U-Profil am Rcken, ist keine Ausklinkung erforderlich.
  (if (= qsForm "U")
		(if (= (Connect.get CastaData amHtStegLinks) 1)
			(setq xAkl 0  zAkl 0 hSteg 0)
		)
  )

  (if (> SetDatenFlag 0) (progn
	(trende.set TrgEnde
			(xakl xAKL)
			(zakl  zAkl)
			(hsteg hSteg)
			;(h_winkel hwnkl_aflch)
	)
  ))
  
  (print "ENDE AUSKLINKUNGEN")
  (print "----------------------")
  (print "<-------------------------------------------------------------------------------")
)




(defun berechneATEndeWnkl (At_Ende)
	(print ">-------------------------------------------------------------------------------")
	(print "BERECHNE AT ENDWINKEL")
	
	; erstmal alles zurcksetzen
;	(initEnde At_Ende)
	
	; jetzt die Berechnung
	(setq 	b_ht 	(Traeger.get Htrg b))
	
	(setq	hscherl_at 	(TrEnde.get At_Ende hscherl)
		vscherl_at	(TrEnde.get At_Ende vscherl)
	)
	
	(print b_ht)
	
	; Horizontale Neigung des AT
	; ----------------------------------------------
	(setq at_h_winkel_steg (Connect.get CastaData h-atrgewnkl_steg))
	(print at_h_winkel_steg)

	(TrEnde.set At_Ende (h_winkel at_h_winkel_steg))
	
	; Vertikale Neigung des AT
	; ----------------------------------------------
	(setq at_v_winkel_steg (Connect.get CastaData v-atrgewnkl_steg))
	(print at_v_winkel_steg)

	; AF-05-2012
	(if (= (Connect.get CastaData amhtflansch) 1) (progn
		(setq at_v_winkel_steg (- 180.0 at_v_winkel_steg))
	))

	(TrEnde.set At_Ende (v_winkel at_v_winkel_steg))
	
	(connect.showAttributes CastaData)
	
	(print "<-------------------------------------------------------------------------------")
)


