(defun init-traegerenden ()
	
  (print "in mod-endinit-uz-stzsteg");
  
	(connect.showAttributes CastaData)
  
  (setq connTest (connect.create))

  (setq xSchnp     (connect.get CastaData xSp)
  			ySchnp     (connect.get CastaData ySp)
  			zSchnp     (connect.get CastaData zSp)
  			htanschlfl (connect.get CastaData htanschlfl)
  			htmodify   (connect.get CastaData htmodify)
  			xpos_ht    (connect.get CastaData xpos_ht)
  )
  
  (if (= (connect.get CastaData amHtFlansch) 1) (print "Anschluss am Hautptrgerflansch"))
  (if (= (connect.get CastaData amHtSteg)    1) (print "Anschluss am Hautptrgersteg"))
  
	;linkes und rechtes Trgerende des Anschlusstrgers
  (setq TrLinks   (traeger.get tr_id links))
  (setq TrRechts  (traeger.get tr_id rechts))
	
	;linkes und rechtes Trgerende der Sttze
  (setq HTrLinks   (traeger.get htrg links))
  (setq HTrRechts  (traeger.get htrg rechts))

	(setq _links 1 _rechts 2)

	(setq abstandZumSteg 10)
	
  ; Trgerende-Ablngung aufgrund des Sttzenprofils (Anschlusstrger)
  (if (= (connect.get CastaData RechtesEnde) 1) 
  	(progn
  		(print "Anschluss rechts am Anschlusstrger")
  		
			(berechneAusklinkungTrg TrRechts abstandZumSteg)
			(trimATEnde TrRechts)
  	)
  )
  (if (= (connect.get CastaData LinkesEnde) 1) 
  	(progn
  		(print "Anschluss links am Anschlusstrger")
  		
			(berechneAusklinkungTrg TrLinks abstandZumSteg)
			(trimATEnde TrLinks)
  	)
  )

	(if (= (connect.get CastaData AnschlzwHtEnden) 0)
		(progn
			(if (= (Connect.get CastaData anHtLinkesEnde) 1)
				(berechneTraegerEnde HTrLinks)
			)
			(if (= (Connect.get CastaData anHtRechtesEnde) 1)
				(berechneTraegerEnde HTrRechts)
			)			
		)
	)

  
)

;----------------------------------------------------------------------- */
; Verlngert den HT bei Anschluss am Trgerende
; ---------------------------------------------------------------------- */
(defun berechneTraegerEnde (TrgEnde)
	
	(setq b_trg (Traeger.get Tr_ID b))
	(setq delta_l (- (* 0.5 b_trg)))
	(TrEnde.set TrgEnde (delta_l delta_l))
	
)

;----------------------------------------------------------------------- */
; Verlngert/Verkrzt den AT bei delta_lr Verschiebung des HT
; ---------------------------------------------------------------------- */
(defun trimATEnde (TrgEnde)
	(setq delta_lr_ht (Traeger.get Htrg delta_lr))
	
	(if (= (Connect.get CastaData amHTStegRechts) 1)
		(TrEnde.ptrim TrgEnde delta_lr_ht)
	)
	(if (= (Connect.get CastaData amHTStegLinks) 1)
		(TrEnde.ptrim TrgEnde (- delta_lr_ht))
	)
)

;----------------------------------------------------------------------- */
; Berechnung der Ausklinkungen des Anschlusstrgers
; ---------------------------------------------------------------------- */
(defun berechneAusklinkungTrg (TrgEnde abstandZumSteg)
	(print "BERECHNE AUSKLINKUNGEN")
	(print "----------------------")
	; Einholen aller Profildaten
  (setq h_HtProf  (Traeger.get hTrg   h)
        h_AnProf  (Traeger.get Tr_ID  h)
				h_dOK     (traeger.get hTrg   delta_v)
				a_dOK     (traeger.get Tr_id  delta_v)
				hc_HtProf (Traeger.get hTrg   hc)
				hc_AnProf (Traeger.get Tr_ID  hc)
				rwinkel_at	(Traeger.get Tr_ID r_winkel)
  )
	
	; Berechnen der 4 Linien - TrgerOK, TrgerUK, obere Ausrundungslinie, untere Ausrundungslinie

  (setq zHProf (- h_dOK (* 0.5 h_HtProf))		; Oberkante der Profile (neg. nach oben)
        zAProf (- a_dOK (* 0.5 h_AnProf))
  )
  (print zHProf)
  (print zAProf)
	(setq zUK_HProf (+ zHProf h_HtProf)				; Unterkante der Profile (neg. nach oben)
        zUK_AProf (+ zAProf h_AnProf)
  )
  (print zUK_HProf)
  (print zUK_AProf)
  ; obere Ausrundung der Profile
  (setq okAusr_HtProf (+ zHProf (* 0.5 (- h_HtProf hc_HtProf)))
        okAusr_AnProf (+ zAProf (* 0.5 (- h_AnProf hc_AnProf)))
  )
  (print okAusr_HtProf)
  (print okAusr_AnProf)
  (setq ukAusr_HtProf (+ okAusr_HtProf hc_HtProf)	; untere Ausrundung der Profile
        ukAusr_AnProf (+ okAusr_AnProf hc_AnProf)
  )
  (print ukAusr_HtProf)
  (print ukAusr_AnProf)
  
  ; NDERUNG FR ROTIERTE TRGER
  ; **********************************************************
		
	; Feststellen, welcher Trger rotiert ist
	
	
	
	
	  
  ; **********************************************************
  
  ; Berechnung der oberen Ausklingungshhe
	; zAkl
	; Erfordlich, wenn OK des Anschlussprofils oberhalb der Ausrundungslinie des
	; Haupttrgerprofils liegt
  (if (<= zAProf okAusr_HtProf) 
  	(progn
			(print "Oben ist eine Ausklinkung erforderlich")
   		(setq	zAkl1 (+  (- zAProf) okAusr_HtProf)
        		zAkl2 (+  (- zAProf) okAusr_AnProf)
   		)
   		(print zakl1)
   		(print zakl2)
   		
   		(if (> zAkl1 zAkl2)
   			(progn
      		(setq zAkl zAkl1)
      		;(setq diff_zakl (- zAkl1 zAkl2))
      	)
      	(progn
       		(setq zAkl zAkl2)
       		;(setq diff_zakl (- zAkl2 zAkl1))
      	)
   		)
   		(if (< zAkl 0) (setq zAkl 0))		; Keine Ausklinkung erforderlich
    ); progn
   	(progn
    	(print "Oben ist keine Ausklinkung oben erforderlich")
      (setq zAkl 0)
    )
  )
  
  ; Berechnung der unteren Ausklinkung
	; Ist diese Ausklinkung  unten erforderlich?
	; Nur dann, wenn UK Profil oberhalb der unteren Ausrundungslinie liegt
  (if (> zUK_AProf ukAusr_HtProf) 
  	(setq U_AKL_erforderlich 1)
   	(setq U_AKL_erforderlich 0)
   )   
   
   (setq hSteg 0)
   (if (= U_AKL_erforderlich 1) 
   	(progn
   		(print "Unten ist eine Ausklinkung erforderlich")
   		; die Hhen nach unten sind negativ. Deswegen den kleineren Wert suchen
   		(if (< ukAusr_HtProf ukAusr_AnProf) 
   			(setq ukRelevant ukAusr_HtProf)
   			(setq ukRelevant ukAusr_AnProf)
			)
			(setq untereAkl (- h_AnProf ukRelevant))
			(setq hSteg (- h_AnProf untereAkl (+ zAkl zAProf)))
    )
    (progn
   		(print "Unten ist keine Ausklinkung erforderlich!")
    )
  )
  
  ; ab hier nun Setzen der Traegerinformationen
	
	(setq bProf 	(Traeger.get hTrg b))
	(setq sProf 	(Traeger.get hTrg s))
	(setq qsForm	(Traeger.get hTrg qsForm))
	(print qsForm)
	(print "-----------")
	
	(setq h_dOK (Traeger.get hTrg  delta_v))			(print h_dOK)
	(setq a_dOK (Traeger.get Tr_id delta_v))			(print a_dOK)
 
  (setq alter_hWinkel (TrEnde.get TrgEnde h_Winkel))		
  (print alter_hWinkel)
  (setq hwinkel (Connect.get CastaData afl_hwinkel))
  (print hwinkel)
  
  (if (= (Connect.get CastaData amHtStegLinks) 1)
		(setq hWinkel (- 180.0 hWinkel))
	)

	; -- Profil-Ausklinkungsdaten
	; Abhngig vom Profil !!!
	(if (= qsForm "U")
		(progn
			(if (= (Connect.get CastaData amHtStegLinks) 1)
				(progn
					(setq  delta_L 0)
					(setq  xAKL    0)
					
				)
			)
			(if (= (Connect.get CastaData amHtStegRechts) 1)
				(progn
					(setq  delta_L sProf )
					(setq  xAKL    (- bProf delta_L))
				)
			)
		)
		(progn
			(setq  delta_L (/ sProf 2.0))
			(setq  xAKL    (- (/ bProf 2.0) delta_L))
		)
	)
	(print hwinkel)
	
	(print delta_l)
	; Winkel bercksichtigen, da Ausklinkungsl-gen und delta_l in Trgerrichtung definiert ist
	(setq sinWkl (sin (/ (* PI hwinkel) 180.0)) 
	      cosWkl (cos (/ (* PI hwinkel) 180.0)) 
	)
	
	(print sinWkl)
	(print cosWkl)
	
	(if (/= sinWkl 0.0) 
		(progn
			(if (< sinWkl 0.0)
				(setq sinWkl (- sinWkl))
			)
	    (setq delta_L (/ delta_L sinWkl))
	    (setq xAKL    (/ xAKL    sinWkl))
		)
	)
	(print delta_l)
	(setq delta_l_soll (+ delta_L abstandZumSteg))
	
	;
	(setq delta_lr_at (Traeger.get Tr_ID delta_lr))
	
	(setq delta_lr_at_trim (* delta_lr_at cosWkl))
	(print delta_lr_at_trim)
	
	(if (= (Connect.get CastaData linkesEnde) 1)
		(setq delta_l_soll (- delta_l_soll delta_lr_at_trim))
	)
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(setq delta_l_soll (+ delta_l_soll delta_lr_at_trim))
	)
	
	; Winkel ndern, wenn AT rotiert
	(if (= rwinkel_at 180.0)
		(setq hwinkel (- hwinkel))
	)
	
	
	(print delta_l_soll)
	(trende.set TrgEnde	(delta_l 0)
											(h_winkel hwinkel)
	)
	(TrEnde.ptrim TrgEnde delta_l_soll)
	;(setq xAKL (runde xAKL auf 5))
	;(setq zAKL (runde zAKL auf 5))
   	
  (print zakl)
  (print hsteg)
  
  ; NDERUNG FR ROTIERTE TRGER
  ; **********************************************************
		
	; Feststellen, welcher Trger rotiert ist
	
	;(setq zakl_tmp zakl)
	;(setq hsteg_tmp hsteg)
	
	;(setq zakl 0)
	;(setq hsteg (- h_HtProf zakl_tmp))
	
	
	  
  ; **********************************************************
  
   	
  (if (> zAkl 0) 
  	(progn
	    (trende.set TrgEnde (xakl xAKL)
													(zakl  zAkl)
													(hsteg hSteg)
													;(h_winkel hwnkl_aflch)
	    )
		)
	)
	(if (> 	hSteg 0) 
		(progn
	    (trende.set TrgEnde (xakl xAKL)
													(zakl  zAkl)
													(hsteg hSteg)
													;(h_winkel hwnkl_aflch)
	    )
    )
  )
  
  (print "ENDE AUSKLINKUNGEN")
	(print "----------------------")
  
)




