(defun showTrgEnde ()
	(if (= (Connect.get CastaData rechtesEnde) 1) (progn
		(setq StzEnde (Traeger.get Tr_ID rechts))
		(setq dlStz_Test (TrEnde.get StzEnde delta_L))
		(AlertBox dlStz_Test)
	))
)



(defun init-traegerenden ()
	(print ">-----------------------------------------------------------")
	(print "IN mod-endinit-uz_auf_stzKopf")
	(print "------------------------------------------------------------")
	(print "BERECHNUNG DER TRGERENDEN")
  
;	(Connect.showAttributes CastaData)

	(setq vWinkel_trg 	(Connect.get CastaData trg_vwinkel))
	
	(if (>= vWinkel_trg 0.0)
		(setq at_is_stz 0)
	)
	(if (> vWinkel_trg 75.0)
		(setq at_is_stz 1)
	)
	(if (>= vWinkel_trg 105.0)
		(setq at_is_stz 0)
	)
	(if (> vWinkel_trg 255.0)
		(setq at_is_stz 1)
	)
	(if (> vWinkel_trg 285.0)
		(setq at_is_stz 0)
	)
;	(if (= at_is_stz 100)
;		(progn
;			(if (= (Connect.get CastaData amATUnterflansch) 1) (print "Connect.get CastaData amATUnterflansch."))
;			(if (= (Connect.get CastaData amATOberflansch) 1)   (print "Connect.get CastaData amATOberflansch."))
;		)
;		(progn
;			(if (= (Connect.get CastaData amHTUnterflansch) 1)  (print "Connect.get CastaData amHTUnterflansch."))
;			(if (= (Connect.get CastaData amHTOberflansch) 1)  (print "Connect.get CastaData amHTOberflansch."))
;		)
;	)

	
	(if (= at_is_stz 0)
		(progn
			(if (= (Connect.get CastaData amATUnterflansch) 1)
				(setConnection)
			)
			(if (= (Connect.get CastaData amATOberflansch) 1)
				(setConnection);(alertBox "Anschluss nicht mglich. Bitte rotieren Sie den Trger um 180."  "ERR_Rotate_Beam_180")
			)
		)
		(progn
			(if (= (Connect.get CastaData amHTUnterflansch) 1)
				(setConnection)
			)
			(if (= (Connect.get CastaData amHTOberflansch) 1)
				(setConnection);(alertBox "Anschluss nicht mglich. Bitte rotieren Sie den Trger um 180."  "ERR_Rotate_Beam_180")
			)
		)
	)



	(print "<-----------------------------------------------------------")
  
)

(defun setConnection ()
  (print "*clear*")	
	(print ">-----------------------------------------------------------")
	(print "SETCONNECTION")
  (if (= (connect.get CastaData AnschlzwHtEnden) 1) (progn
	    ; Anschluss zwischen HT-Enden
    	(print "Anschluss zwischen den HT-Enden")
		; ------------------------- Kalkulation der Sttze
		(print at_is_stz)
		(if (= at_is_stz 1)
			(calcStuetzenEnde Tr_ID Htrg)
			(calcStuetzenEnde HTrg Tr_ID)
		)
	)
    (progn																										; Anschluss NICHT zwischen HT-Enden
    	(print "Anschluss an HT-Ende")
    	(if (= (connect.get CastaData AnschlzwAtEnden) 0) (progn																								; Anschluss NICHT zwischen AT-Enden
			; Kalkulation des Trgerendes
      		(if (= at_is_stz 1)
      			(calcTraegerEnde Tr_ID Htrg)
      			(calcTraegerEnde HTrg Tr_ID)
      		)
      	))
	; Kalkulation der Sttze
    	(if (= at_is_stz 1)
		(calcStuetzenEnde Tr_ID Htrg)
		(calcStuetzenEnde HTrg Tr_ID)
	)
					
   
    )
  )
)
; ====================================================================== 
; ====================================================================== 
(defun calcTraegerEnde (ID_Stuetze ID_Unterzug)
  (print "------------------------------------------------------------")
  (print "BERECHNE UZ-ENDE")
  (setq h_stz  		(Traeger.get ID_Stuetze h)
  	rWnkl_htrg		(traeger.get ID_Stuetze r_winkel)
  	rWnkl_trg		(traeger.get ID_Unterzug r_winkel)
  	delta_v_stz		(Traeger.get ID_Stuetze delta_v)
	delta_v_uz		(Traeger.get ID_Unterzug delta_V)
	VWnkl  			(connect.get CastaData trg_VWinkel)
	VWnkl_ht		(connect.get CastaData hpttrg_VWinkel)
	afl_winkel_uz	(Connect.get CastaData afl_vwinkel)
	at_l_winkel		(Connect.get CastaData v-atrgewnkl_flansch)
  )
  
  ;	----------------------	Sept 2009 - Initialisierungen, da ansonsten Ausstieg aus makro wg.
  ;				nicht deklarierter Variablen
  (setq hProf2 0.0)		; Initialisierung ...
  (setq abtl_Winkel 0.0)	; Initialisierung ...
  
   ; (AF) Sept 2009 - ergnzt
   (if (= (Connect.get CastaData rechtesEnde) 1) (if (= (Connect.get CastaData amHtOberflansch) 1) (setq delta_v_uz (- delta_v_uz))))
   (if (= (Connect.get CastaData linkesEnde)  1) (if (= (Connect.get CastaData amHtUnterflansch) 1) (setq delta_v_uz (- delta_v_uz))))

   (if (> VWnkl 255.0) (if (< VWnkl 285.0) (setq delta_v_uz (- delta_v_uz))))
  
  
  ; ******************************************************************
  ; AT ist Unterzug
  ; ******************************************************************
  (if (= ID_Unterzug Tr_ID)
  	(progn
  		(print "ANSCHLUSSTRGER IST UNTERZUG")
  		
  		(if (= (Connect.get CastaData LinkesEnde) 1)
  			(setq TrgEnde (Traeger.get Tr_ID links))
  		)
  		(if (= (Connect.get CastaData RechtesEnde) 1)
  			(setq TrgEnde (Traeger.get Tr_ID rechts))
  		)
  		
  	
  		(setq	sinAlfa (sin (/ (* PI afl_winkel_uz) 180.0))
		  	cosAlfa (cos (/ (* PI afl_winkel_uz) 180.0))
		  	tanAlfa (tan (/ (* PI afl_winkel_uz) 180.0))
		)
		  
		(print afl_winkel_uz)
		  
		; Winkel
		(if (= (Connect.get CastaData linkesEnde) 1)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr)  1) (setq EWnkl_Trg (+ 180.0 afl_winkel_uz)))
					(if (= (Connect.get CastaData vatr-lhtr) -1) (setq EWnkl_Trg (- 180.0 afl_winkel_uz)))	
				)
		)
		(if (= (Connect.get CastaData rechtesEnde) 1)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr)  1) (setq EWnkl_Trg (- 180.0 afl_winkel_uz)))
					(if (= (Connect.get CastaData vatr-lhtr) -1) (setq EWnkl_Trg (+ 180.0 afl_winkel_uz)))
				)
		)
			
		(print EWnkl_Trg)
		(TrEnde.set TrgEnde (V_Winkel (- EWnkl_Trg)))
		
		  
		  
		; delta_l
   
		(print delta_v_stz)
		(if (= (Connect.get CastaData amHtUnterflansch) 1)
     			(setq hProf2 (- (+ (* 0.5 h_stz) (- delta_v_stz))));ok
     		)
     		(if (= (Connect.get CastaData amHtOberflansch) 1)
     			(setq hProf2 (- (+ (* 0.5 h_stz) delta_v_stz)));ok
     		)
        
				
		; Anteil delta_v Verschiebung AT
  		
  		(setq anteil_dv_at (* delta_v_uz cosAlfa))
  		(print anteil_dv_at)

		(if (= (Connect.get CastaData satr-shtr)  1) (setq hProf2 (+ hProf2 anteil_dv_at)))
		(if (= (Connect.get CastaData satr-shtr) -1) (setq hProf2 (- hProf2 anteil_dv_at)))
  		
  		
  		
  		;(TrEnde.set TrgEnde 	(delta_l  (- hProf2)))
  		(TrEnde.set TrgEnde (delta_l  0))
  		(TrEnde.ptrim TrgEnde hProf2)
		
	    ) ; Progn ...
	)
	
	
	
	; ******************************************************************
  ; HT ist Unterzug
  ; ******************************************************************
	(if (= ID_Unterzug Htrg)
  	(progn
  		(print "HAUPTTRGER IST UNTERZUG")
  		
		;; Sept 2009 (AF) eingefhrt, weil  Anschluss auch auf Riegel stehende Sttze bedienen soll
  		(if (= (Connect.get CastaData amHtOberflansch) 1)  (setq delta_v_stz (- delta_v_stz)))
  		
	  	(if (= (Connect.get CastaData rechtesEnde) 1)
	  		(progn
				(if (= (connect.get CastaData anHtLinkesEnde) 1) 
					(progn
					  (setq TrgEnde (Traeger.get ID_Unterzug links))
					  (if (= (Connect.get CastaData satr-shtr) -1)	(setq hProf2 (+ (* 0.5 h_stz) delta_v_stz)))
					  (if (= (Connect.get CastaData satr-shtr) 1)	(setq hProf2 (+ (* 0.5 h_stz) (- delta_v_stz))))    
					)
				)
				(if (= (connect.get CastaData anHtRechtesEnde) 1) 
					(progn
					  (setq TrgEnde (Traeger.get ID_Unterzug rechts))
					  (if (= (Connect.get CastaData satr-shtr) 1)	(setq hProf2 	(+ (* 0.5 h_stz) delta_v_stz)))
					  (if (= (Connect.get CastaData satr-shtr) -1)	(setq hProf2 	(+ (* 0.5 h_stz) (- delta_v_stz))))
					)
				)
			  )
		)
		(if (= (Connect.get CastaData linkesEnde) 1)
	  		(progn
				(if (= (connect.get CastaData anHtLinkesEnde) 1) 
				  (progn
				    (setq TrgEnde (Traeger.get ID_Unterzug links))
				    (if (= (Connect.get CastaData satr-shtr) -1)	(setq hProf2 (+ (* 0.5 h_stz) (- delta_v_stz))))
				    (if (= (Connect.get CastaData satr-shtr) 1)		(setq hProf2 (+ (* 0.5 h_stz) delta_v_stz)))    
				  )
				)
				(if (= (connect.get CastaData anHtRechtesEnde) 1) 
				  (progn
				    (setq TrgEnde (Traeger.get ID_Unterzug rechts))
				    (if (= (Connect.get CastaData satr-shtr) 1)		(setq hProf2 	(+ (* 0.5 h_stz) (- delta_v_stz))))
				    (if (= (Connect.get CastaData satr-shtr) -1)	(setq hProf2 	(+ (* 0.5 h_stz) delta_v_stz)))
				  )
				)
			)
		)

		;; Sept 2009 (AF) eingefhrt, weil  Anschluss auch auf Riegel stehende Sttze bedienen soll
		;; hier wieder Variable zurckstellen
  		(if (= (Connect.get CastaData amHtOberflansch) 1)  (setq delta_v_stz (- delta_v_stz)))

		  (print delta_v_uz)
		  (setq sinAlfa (sin (/ (* PI VWnkl_ht) 180.0))
		  	cosAlfa (cos (/ (* PI VWnkl_ht) 180.0))
		  	tanAlfa (tan (/ (* PI VWnkl_ht) 180.0))
		  )
		
		  (if (/= cosAlfa 0.0) (setq hProf2 (/ hProf2 cosAlfa)))

		  (if (= (connect.get CastaData anHtLinkesEnde) 1) 
		  	(progn
		  		(setq hProf2 (+ hProf2 (* tanAlfa delta_v_uz)))
		  	)
		  )
		  (if (= (connect.get CastaData anHtRechtesEnde) 1) 
		  	(progn
		  		(setq hProf2 (- hProf2 (* tanAlfa delta_v_uz)))
		  	)
		  )
		  
		  (print hProf2)
		  
			(print afl_winkel_uz)
			
			(setq EWnkl_Trg 90.0)
			; TrgEnde Winkel
			; ------------------------------------------
			(if (= (Connect.get CastaData amHtOberflansch) 1)
				(progn
					(if (= (Connect.get CastaData amAtOberflansch) 1)
						(progn
							(if (= (Connect.get CastaData anHtLinkesEnde) 1)
								(progn
									(if (= (Connect.get CastaData LinkesEnde) 1)	(setq EWnkl_Trg at_l_winkel))
									(if (= (Connect.get CastaData RechtesEnde) 1)	(setq EWnkl_Trg (- 180.0 at_l_winkel)))
								)
							)
							(if (= (Connect.get CastaData anHtRechtesEnde) 1)
								(progn
									(if (= (Connect.get CastaData LinkesEnde) 1)	(setq EWnkl_Trg (- 180.0 at_l_winkel)))
									(if (= (Connect.get CastaData RechtesEnde) 1)	(setq EWnkl_Trg at_l_winkel))
								)
							)
						)
					)
					(if (= (Connect.get CastaData amAtUnterflansch) 1)	
						(progn
							(if (= (Connect.get CastaData anHtLinkesEnde) 1)
								(progn
									(if (= (Connect.get CastaData LinkesEnde) 1)	(setq EWnkl_Trg (- 180.0 at_l_winkel)))
									(if (= (Connect.get CastaData RechtesEnde) 1)	(setq EWnkl_Trg at_l_winkel))
								)
							)
							(if (= (Connect.get CastaData anHtRechtesEnde) 1)
								(progn
									(if (= (Connect.get CastaData LinkesEnde) 1)	(setq EWnkl_Trg at_l_winkel))
									(if (= (Connect.get CastaData RechtesEnde) 1)	(setq EWnkl_Trg (- 180.0 at_l_winkel)))
								)
							)
						)
					)
				)
			)
			(if (= (Connect.get CastaData amHtUnterflansch) 1)
				(progn
					(if (= (Connect.get CastaData amAtOberflansch) 1)
						(progn
							(if (= (Connect.get CastaData anHtLinkesEnde) 1)
								(progn
									(if (= (Connect.get CastaData LinkesEnde) 1)	(setq EWnkl_Trg (- 180.0 at_l_winkel)))
									(if (= (Connect.get CastaData RechtesEnde) 1)	(setq EWnkl_Trg at_l_winkel))
								)
							)
							(if (= (Connect.get CastaData anHtRechtesEnde) 1)
								(progn
									(if (= (Connect.get CastaData LinkesEnde) 1)	(setq EWnkl_Trg at_l_winkel))
									(if (= (Connect.get CastaData RechtesEnde) 1)	(setq EWnkl_Trg (- 180.0 at_l_winkel)))
								)
							)
						)
					)
					(if (= (Connect.get CastaData amAtUnterflansch) 1)	
						(progn
							(if (= (Connect.get CastaData anHtLinkesEnde) 1)
								(progn
									(if (= (Connect.get CastaData LinkesEnde) 1)	(setq EWnkl_Trg at_l_winkel))
									(if (= (Connect.get CastaData RechtesEnde) 1)	(setq EWnkl_Trg (- 180.0 at_l_winkel)))
								)
							)
							(if (= (Connect.get CastaData anHtRechtesEnde) 1)
								(progn
									(if (= (Connect.get CastaData LinkesEnde) 1)	(setq EWnkl_Trg (- 180.0 at_l_winkel)))
									(if (= (Connect.get CastaData RechtesEnde) 1)	(setq EWnkl_Trg at_l_winkel))
								)
							)
						)
					)
				)
			)
			
			;(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq EWnkl_Trg (- 180.0 at_l_winkel)))
			;(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq EWnkl_Trg at_l_winkel))
			(print EWnkl_Trg)
		  	(TrEnde.set TrgEnde 	(delta_l  (- hProf2))
									(V_Winkel EWnkl_Trg)
		  	)
		)
	)
  (print "------------------------------------------------------------")

)
; ----------------------------------------------------------------------------------------
; Berechnet das Ende der Sttze
; ----------------------------------------------------------------------------------------
(defun calcStuetzenEnde (ID_Stuetze ID_Unterzug)

;	(if (= ID_Stuetze Tr_ID) (print "ID_Stuetze == Tr_ID"))
;	(if (= ID_Stuetze HTrg)  (print "ID_Stuetze == HTrg"))
	; --------------------------------------------------------------------------------------
	(if (= 1 1) (progn
	; --------------------------------------------------------------------------------------
	(print "--------------------------------------------------------------------------------")
	(print "BERECHNE STTZENENDEN")
	
	; Wenn AT = Sttze
  (if (= ID_Stuetze  Tr_ID) (progn
  	(print  "AT = Sttze")
  	(setq VWnkl  (connect.get CastaData HptTrg_VWinkel))
  	(if (= (connect.get CastaData LinkesEnde) 1) (progn
      		(setq TrgEnde (Traeger.get ID_Stuetze links))
  	))
  	(if (= (connect.get CastaData RechtesEnde) 1) (progn
      		(setq TrgEnde (Traeger.get ID_Stuetze rechts))
  	))
  	(print TrgEnde)
  ))
  ; Wenn AT = Unterzug
  (if (= ID_Unterzug Tr_ID) (progn
  	(print "AT = Unterzug")
  	(setq VWnkl  (connect.get CastaData trg_VWinkel))
  	
  	(if (= (connect.get CastaData anHtLinkesEnde) 1) 
  		(progn
  			(print "ht-links")
      			(setq TrgEnde (Traeger.get ID_Stuetze links))
  		)
  	)
  	(if (= (connect.get CastaData anHtRechtesEnde) 1) 
  		(progn
  			(print "ht-rechts")
      			(setq TrgEnde (Traeger.get ID_Stuetze rechts))
  		)
  	)
  ))
  
  
  (print VWnkl) 
  
  (setq hProf  		(Traeger.get ID_Unterzug h)
  	delta_v_stz  	(Traeger.get ID_Stuetze delta_v)
	delta_v_uz 	(Traeger.get ID_Unterzug delta_V)
  )


  (setq sinAlfa		(sin (/ (* PI VWnkl) 180.0))
  	cosAlfa		(cos (/ (* PI VWnkl) 180.0))
  	tanAlfa		(tan (/ (* PI VWnkl) 180.0))
  )

	(print hProf)
	(print delta_v_uz)	; ist (int) - muss nachher in double verwandelt werden
	(print delta_v_stz)
	
	(setq h_uz_halb	(* 0.5 hProf))
	
	
	; - wichtig - diese beiden Variablen schon einmal definieren,
	;   falls die if-Bedingung nicht zutrifft.
  (setq hEWnkl_Stz 90.0)
  (setq EWnkl_Stz 90.0)
	
  ; ******************************************************************
  ; AT ist Sttze
  ; ******************************************************************
  (if (= ID_Stuetze Tr_ID) 
  	(progn
  		(print "STTZE IST AT")

  		(print vwnkl)

			; vertikal Winkel
			; ------------------------------------------
			(if (= (Connect.get CastaData satr-shtr)  1)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq EWnkl_Stz (+ 90.0 VWnkl)))
					(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq EWnkl_Stz (- 90.0 VWnkl)))
				)
			)
			(if (= (Connect.get CastaData satr-shtr) -1)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq EWnkl_Stz (+ 90.0 VWnkl)))
					(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq EWnkl_Stz (- 90.0 VWnkl)))
				)
			)
			
			  		
  		(setq at_vwinkel (Connect.get CastaData trg_vwinkel))
  		
			
  		(if (> at_vwinkel 255.0)
  			(progn
  				(if (< at_vwinkel 285.0)
  					(progn
  						(setq EWnkl_Stz (- 180.0 EWnkl_Stz))
  					)
  				)
  			)
  		)
  		
			; horizontal Winkel
			; ------------------------------------------
			(setq h_wnkl_at_flansch (Connect.get CastaData h-atrgewnkl_flansch))
			
			(setq hEWnkl_Stz h_wnkl_at_flansch)
			
			
  		
  		; Lngennderung
			; ------------------------------------------
			(setq delta_l_Stz 0.0)

			; neu AF - 08-2009		Anteil Vertikalverschiebung der Sttze
			; (setq EWnkl (Connect.get CastaData v-atrgewnkl_kopf))
			; Korrektur Apr 2024 - hier neu
			(setq EWnkl_Neu (connect.get CastaData v-atrgewnkl_flansch))
			; (AlertBox EWnkl) (AlertBox EWnkl_Neu)
			(setq EWnkl (- 90.0 EWnkl_Neu))
			
			(if (= (Connect.get CastaData at-von-unten) 1) (progn
				(if (= (Connect.get CastaData amHTOberflansch) 1) (setq EWnkl (- EWnkl)))
			))
			(if (= (Connect.get CastaData at-von-oben) 1) (progn
				(if (= (Connect.get CastaData amHTUnterflansch) 1) (setq EWnkl (- EWnkl)))
			))
			
			(setq tanEWnkl (tan (/ (* PI EWnkl) 180.0)))
			(setq delta_v_stz_AF (Traeger.get Tr_ID delta_v))
			(setq delta_v_stz_AF (* 1.0 delta_v_stz_AF))
			

			; Korrektur Apr 2024

;			(if (/= tanEWnkl 0.0) (progn
;			    (if (= (connect.get CastaData RechtesEnde) 1)
;			      (if (= (Connect.get CastaData AmHTUnterFlansch) 1) (setq delta_l_Stz (- (* delta_v_stz_AF tanEWnkl))))
;			    )
;			    (if (= (connect.get CastaData LinkesEnde) 1)
;			      (if (= (Connect.get CastaData AmHTOberFlansch)  1) (setq delta_l_Stz    (* delta_v_stz_AF tanEWnkl)))
;			    )
;			    (if (= (connect.get CastaData LinkesEnde) 1)
;			      (if (= (Connect.get CastaData AmHTUnterFlansch) 1) (setq delta_l_Stz    (* delta_v_stz_AF tanEWnkl)))
;			    )
;			    (if (= (connect.get CastaData RechtesEnde) 1)
;			      (if (= (Connect.get CastaData AmHTOberFlansch)  1) (setq delta_l_Stz (- (* delta_v_stz_AF tanEWnkl))))
;			    )
;			))

			; Korrektur Apr 2024 - hier neu
			
			(setq delta_l_Stz 0.0)
			(if (/= tanEWnkl 0.0) (progn
				(setq delta_l_Stz    (* delta_v_stz_AF tanEWnkl))
			))
			; Ende Korrektur - AF 04-2024

			; Ende Korrektur - AF 08-2009

			; Start Korrektur - AF 04-2010
			
			(print "Korrektur 2010 - AF")
			(if (= (connect.get CastaData AnschlzwHtEnden) 5) (progn	
			    ;; muss merkwrdogerweise abgefangen werden !!
			    (if (= (connect.get CastaData LinkesEnde) 1) (progn
					(setq VWinkel_AF (connect.get CastaData v-atrgewnkl_flansch))
					(if (= (connect.get CastaData VAtr-LHtr) -1)
						(if (< VWinkel_AF 90.0) (setq delta_l_Stz (- delta_l_Stz)))
					)
					(if (= (connect.get CastaData VAtr-LHtr)  1)
						(if (> VWinkel_AF 90.0) (setq delta_l_Stz (- delta_l_Stz)))
					)
					(print delta_l_Stz)
					))
					(if (= (connect.get CastaData RechtesEnde) 1) (progn
					(setq VWinkel_AF (connect.get CastaData v-atrgewnkl_flansch))
					(if (= (connect.get CastaData VAtr-LHtr) -1)
						(if (> VWinkel_AF 90.0) (setq delta_l_Stz (- delta_l_Stz)))
					)
					(if (= (connect.get CastaData VAtr-LHtr)  1)
						(if (< VWinkel_AF 90.0) (setq delta_l_Stz (- delta_l_Stz)))
					)
					(print delta_l_Stz)
			    ))
			))
			; Ende Korrektur - AF 04-2010
			; Anteil Unterzughhe
			; ------------------------------------------

			
			(if (/= cosAlfa 0.0) (setq anteil_h_ht (/ h_uz_halb cosAlfa)))
			(print h_uz_halb)
			
			(setq delta_l_stz (+ delta_l_stz anteil_h_ht))
			
			
			; Anteil delta_v Unterzug
			; ------------------------------------------
			(if (= 1 1)	(progn
			; ------------------------------------------
				(print delta_v_uz)  		
				(print tanAlfa)
			
				(setq delta_v_uz (* 1.0 delta_v_uz))	; ist int ---> double
				(setq dv_verl (/ delta_v_uz cosAlfa))
				
	  			(print dv_verl)
	  		
				(if (= (Connect.get CastaData amHtOberflansch) 1)
					(progn
					  (if (= (connect.get CastaData LinkesEnde) 1)	(setq delta_l_stz (- delta_l_stz dv_verl)))
					  (if (= (connect.get CastaData RechtesEnde) 1)	(setq delta_l_stz (- delta_l_stz dv_verl)))
					)
				)
				(if (= (Connect.get CastaData amHtUnterflansch) 1)
					(progn
					  (if (= (connect.get CastaData LinkesEnde) 1)	(setq delta_l_stz (+ delta_l_stz dv_verl)))
					  (if (= (connect.get CastaData RechtesEnde) 1)	(setq delta_l_stz (+ delta_l_stz dv_verl)))
					)
				)
				
			; ------------------------------------------
			))
			; ------------------------------------------
  		
		
		
			(setq rWinkel_UZ (Connect.get CastaData  r-atrgewnkl_kopf))
			(if (/= rWinkel_UZ 180.0) (progn
					(setq Winkel_Fall 0)
					(if (> rWinkel_UZ -90.0) (if (< rWinkel_UZ 90.0) (progn
					 	(setq Winkel_Fall 1)
						(setq rWinkel_UZ (- rWinkel_UZ))
					)))
					(if (= Winkel_Fall 0) (progn
						(if (> rWinkel_UZ 270.0) 
							(setq rWinkel_UZ (- 360.0  rWinkel_UZ))
							(setq  rWinkel_UZ (- rWinkel_UZ 180.0))
						)
					))

					(setq dlr_UZ (Traeger.get Tr_ID delta_LR))
					
					(setq cosRoWnkl (cos (/ (* rWinkel_UZ PI) 180.0)))
					(setq tanRoWnkl (tan (/ (* rWinkel_UZ PI) 180.0)))
					(setq   anteil_h_ht_Rotiert (/ anteil_h_ht cosRoWnkl))
					; (setq  delta_l_stz  (+ (- delta_l_stz anteil_h_ht) anteil_h_ht_Rotiert))
					(setq  delta_l_stz  (/  delta_l_stz  cosRoWnkl))
					
					(if (= (connect.get CastaData  satr-shtr)  1)		(setq  delta_l_stz (- delta_l_stz (* tanRoWnkl dlr_UZ))))
					(if (= (connect.get CastaData  satr-shtr) -1)		(setq  delta_l_stz (- delta_l_stz (* tanRoWnkl dlr_UZ))))
			))
		)
	)

	; ******************************************************************
  ; HT ist Sttze
  ; ******************************************************************
  (if (= ID_Stuetze Htrg) 
  	(progn
  		(print "STTZE IST HT")
  		
  		(print vwnkl)
  		  		
  		(if (= (connect.get CastaData amHtUnterflansch) 1) 
		  	(progn
		  		(print "HT-UNTERFLANSCH")
		  		(if (= (Connect.get CastaData anHtrechtesEnde) 1)
		  			(progn
		  				(if (= (Connect.get CastaData vatr-lhtr) 1)
		  					(progn
									(if (= (Connect.get CastaData satr-shtr)  1)	(setq EWnkl_Stz (- 90.0 VWnkl)));ok
									(if (= (Connect.get CastaData satr-shtr) -1)	(setq EWnkl_Stz (+ 90.0 VWnkl)));ok
								)
							)
							(if (= (Connect.get CastaData vatr-lhtr) -1)
		  					(progn
									(if (= (Connect.get CastaData satr-shtr)  1)	(setq EWnkl_Stz (+ 90.0 VWnkl)));ok
									(if (= (Connect.get CastaData satr-shtr) -1)	(setq EWnkl_Stz (- 90.0 VWnkl)));ok
								)
							)
						)
					)
					(if (= (Connect.get CastaData anHtlinkesEnde) 1)
		  			(progn
							(if (= (Connect.get CastaData vatr-lhtr) 1)
		  					(progn
									(if (= (Connect.get CastaData satr-shtr)  1)	(setq EWnkl_Stz (- 90.0 VWnkl)))
									(if (= (Connect.get CastaData satr-shtr) -1)	(setq EWnkl_Stz (+ 90.0 VWnkl)));ok
								)
							)
							(if (= (Connect.get CastaData vatr-lhtr) -1)
		  					(progn
									(if (= (Connect.get CastaData satr-shtr)  1)	(setq EWnkl_Stz (+ 90.0 VWnkl)));ok
									(if (= (Connect.get CastaData satr-shtr) -1)	(setq EWnkl_Stz (- 90.0 VWnkl)))
								)
							)
						)
					)
		  	)
		  )
			(if (= (connect.get CastaData amHtOberflansch) 1) 
				(progn
					(print "HT-OBERFLANSCH")
					(if (= (Connect.get CastaData anHtrechtesEnde) 1)
		  			(progn
							(if (= (Connect.get CastaData vatr-lhtr) 1)
		  					(progn
									(if (= (Connect.get CastaData satr-shtr)  1)	(setq EWnkl_Stz (- 90.0 VWnkl)));ok
									(if (= (Connect.get CastaData satr-shtr) -1)	(setq EWnkl_Stz (+ 90.0 VWnkl)));ok
								)
							)
							(if (= (Connect.get CastaData vatr-lhtr) -1)
		  					(progn
									(if (= (Connect.get CastaData satr-shtr)  1)	(setq EWnkl_Stz (+ 90.0 VWnkl)));ok
									(if (= (Connect.get CastaData satr-shtr) -1)	(setq EWnkl_Stz (- 90.0 VWnkl)));ok
								)
							)
						)
					)
					(if (= (Connect.get CastaData anHtlinkesEnde) 1)
		  			(progn
							(if (= (Connect.get CastaData vatr-lhtr) 1)
		  					(progn
									(if (= (Connect.get CastaData satr-shtr)  1)	(setq EWnkl_Stz (- 90.0 VWnkl)));ok
									(if (= (Connect.get CastaData satr-shtr) -1)	(setq EWnkl_Stz (+ 90.0 VWnkl)));ok
								)
							)
							(if (= (Connect.get CastaData vatr-lhtr) -1)
		  					(progn
									(if (= (Connect.get CastaData satr-shtr)  1)	(setq EWnkl_Stz (+ 90.0 VWnkl)))
									(if (= (Connect.get CastaData satr-shtr) -1)	(setq EWnkl_Stz (- 90.0 VWnkl)));ok
								)
							)
						)
					)
		  	)
		  )
		  
			(if (= (Connect.get CastaData anschlzwAtEnden) 1)
				(progn
					(if (= (Connect.get CastaData anHtrechtesEnde) 1)
		  			(progn
							(if (= (Connect.get CastaData satr-shtr)  1)	(setq EWnkl_Stz (+ 90.0 VWnkl)))
							(if (= (Connect.get CastaData satr-shtr) -1)	(setq EWnkl_Stz (- 90.0 VWnkl)))
						)
					)
					(if (= (Connect.get CastaData anHtlinkesEnde) 1)
		  			(progn
							(if (= (Connect.get CastaData satr-shtr)  1)	(setq EWnkl_Stz (- 90.0 VWnkl)))
							(if (= (Connect.get CastaData satr-shtr) -1)	(setq EWnkl_Stz (+ 90.0 VWnkl)))
						)
					)
				)
			)
  		
  		
  		
  		(setq ht_vwinkel (Connect.get CastaData hpttrg_vwinkel))
  		(print ht_vwinkel)
  		
  		  		
  		(if (> ht_vwinkel 255.0)
  			(progn
  				(if (< ht_vwinkel 285.0)
  					(progn
  						(setq EWnkl_Stz (- 180.0 EWnkl_Stz))
  					)
  				)
  			)
  		)
  		
  		
  		
  		; Lngennderung
			; ------------------------------------------
			(setq delta_l_Stz 0.0)
			
			; neu AF - 08-2009
			(setq EWnkl (Connect.get CastaData v-atrgewnkl_flansch))
			(setq tanEWnkl (tan (/ (* PI EWnkl) 180.0)))
			(setq delta_v_stz_AF (Traeger.get HTrg delta_v))
			
			(if (/= tanEWnkl 0.0) (progn
			    (if (= (Connect.get CastaData AmHTUnterFlansch) 1) (setq delta_l_Stz (- (/ delta_v_stz_AF tanEWnkl))))
			    (if (= (Connect.get CastaData AmHTOberFlansch)  1) (setq delta_l_Stz    (/ delta_v_stz_AF tanEWnkl)))
			))
			; Ende Korrektur - AF 08-2009

			(print "Korrektur 2010 - AF")
			    (if (= (connect.get CastaData AnHtLinkesEnde) 1) (progn
					(setq VWinkel_AF (connect.get CastaData v-atrgewnkl_flansch))
					(if (= (connect.get CastaData SAtr-SHtr) -1)
						(if (= (connect.get CastaData rechtesEnde)  1)
							(setq delta_l_Stz  (- delta_l_Stz))
						)	
					)
					(if (= (connect.get CastaData SAtr-SHtr)  1)
						(if (= (connect.get CastaData rechtesEnde)  1)
							(setq delta_l_Stz (- delta_l_Stz))
						)	
					)
					(print delta_l_Stz)
			    ))
			    (if (= (connect.get CastaData AnHtRechtesEnde) 1) (progn
				(setq VWinkel_AF (connect.get CastaData v-atrgewnkl_flansch))
				(if (= (connect.get CastaData SAtr-SHtr) -1)
				    (if (= (connect.get CastaData rechtesEnde)  1)
				    	(setq delta_l_Stz (- delta_l_Stz))
				    )	
				)
				(if (= (connect.get CastaData SAtr-SHtr)  1)
				    (if (= (connect.get CastaData rechtesEnde)  1)
				    	(setq delta_l_Stz (- delta_l_Stz))
				    )	
				)
				(print delta_l_Stz)
			    ))

			;; (Connect.showAttributes 	CastaData)	
			
			; Anteil Unterzughhe
			; ------------------------------------------
			(print h_uz_halb)
			
			(if (/= cosAlfa 0.0) (setq anteil_h_ht (/ h_uz_halb cosAlfa)))
			(print h_uz_halb)
			
			(setq delta_l_stz (+ delta_l_stz anteil_h_ht))
			
			
			; Anteil delta_v Unterzug
			; ------------------------------------------
			(if (= 1 1)	(progn
			; ------------------------------------------
				(print delta_v_uz)  		
				(print tanAlfa)
			
				(setq dv_verl (/ delta_v_uz cosAlfa))
				
	  		(print dv_verl)
	  		
				
				
				(if (= (Connect.get CastaData amAtOberflansch) 1)
					(progn
					  (if (= (connect.get CastaData anHtLinkesEnde) 1)	(setq delta_l_stz (- delta_l_stz dv_verl)))
					  (if (= (connect.get CastaData anHtRechtesEnde) 1)	(setq delta_l_stz (- delta_l_stz dv_verl)))
					)
				)
				(if (= (Connect.get CastaData amAtUnterflansch) 1)
					(progn
					  (if (= (connect.get CastaData anHtLinkesEnde) 1)	(setq delta_l_stz (+ delta_l_stz dv_verl)))
					  (if (= (connect.get CastaData anHtRechtesEnde) 1)	(setq delta_l_stz (+ delta_l_stz dv_verl)))
					)
				)
				
			; ------------------------------------------
			))
			; ------------------------------------------
  		
  		
  		
  	)
  )
  ; ******************************************************************
  ; HT ist Sttze ENDE
  ; ******************************************************************
  
  
  (print delta_l_Stz)
  (print EWnkl_Stz)
  (print hEWnkl_Stz)
  (print TrgEnde)
  
  (TrEnde.set TrgEnde 	(delta_l 	delta_l_Stz)
  			(V_Winkel EWnkl_Stz)
  			(H_Winkel hEWnkl_Stz)
  )
  
  (print "--------------------------------------------------------------------------------")
  
	; --------------------------------------------------------------------------------------
	))
	; --------------------------------------------------------------------------------------
)
; ====================================================================== 
