(defun init-traegerenden ()
	(print ">-----------------------------------------------------------")
	(print "BERECHNUNG DER TRGERENDEN")
  
	(Connect.showAttributes CastaData)

	(setq vWinkel_trg 	(Connect.get CastaData trg_vwinkel))
	(print vWinkel_trg)
	
	(if (>= vWinkel_trg 0.0)
		(setq at_is_stz 0)
	)
	(if (> vWinkel_trg 45.0)
		(setq at_is_stz 1)
	)
	(if (>= vWinkel_trg 135.0)
		(setq at_is_stz 0)
	)
	(if (> vWinkel_trg 225.0)
		(setq at_is_stz 1)
	)
	(if (> vWinkel_trg 315.0)
		(setq at_is_stz 0)
	)
	
	(if (= at_is_stz 0)
		(progn
			(if (= (Connect.get CastaData amATUnterflansch) 1)
				(setConnection)
			)
			(if (= (Connect.get CastaData amATOberflansch) 1)
				(alertBox "Anschluss nicht mglich. Bitte rotieren Sie den Trger um 180."   "ERR_Rotate_Beam_180")
			)
		)
		(progn
			(if (= (Connect.get CastaData amHTUnterflansch) 1)
				(setConnection)
			)
			(if (= (Connect.get CastaData amHTOberflansch) 1)
				(alertBox "Anschluss nicht mglich. Bitte rotieren Sie den Trger um 180."   "ERR_Rotate_Beam_180")
			)
		)
	)



	(print "<-----------------------------------------------------------")
  
)

(defun setConnection ()
		
	
  (if (= (connect.get CastaData AnschlzwHtEnden) 1)
    (progn 																										; Anschluss zwischen HT-Enden
    	(print "Anschluss zwischen den HT-Enden")
			; ------------------------- Kalkulation der Sttze
			(if (= at_is_stz 1)
				(calcStuetzenEnde Tr_ID Htrg)
				(calcStuetzenEnde HTrg Tr_ID)
			)
    )
    (progn																										; Anschluss NICHT zwischen HT-Enden
    	(print "Anschluss an HT-Ende")
    	(if (= (connect.get CastaData AnschlzwAtEnden) 0)				
    		(progn																								; Anschluss NICHT zwischen AT-Enden
					; Kalkulation des Trgerendes
      		(if (= at_is_stz 1)
      			(calcTraegerEnde Tr_ID Htrg)
      			(calcTraegerEnde HTrg Tr_ID)
      		)
      	)
      )
			; Kalkulation der Sttze
      (if (= at_is_stz 1)
				(calcStuetzenEnde Tr_ID Htrg)
				(calcStuetzenEnde HTrg Tr_ID)
			)
					
   
    )
  )
)
; ====================================================================== 
; ====================================================================== 
(defun calcTraegerEnde (ID_Stuetze ID_Unterzug)
  (print "------------------------------------------------------------")
  (print "BERECHNE AT-ENDE")
  (setq h_stz  				(Traeger.get ID_Stuetze h)
  			rWnkl_htrg		(traeger.get ID_Stuetze r_winkel)
  			rWnkl_trg		  (traeger.get ID_Unterzug r_winkel)
  			delta_v_stz		(Traeger.get ID_Stuetze delta_v)
				delta_v_uz		(Traeger.get ID_Unterzug delta_V)
				VWnkl  				(connect.get CastaData trg_VWinkel)
				VWnkl_ht			(connect.get CastaData hpttrg_VWinkel)
				afl_winkel_uz (Connect.get CastaData afl_vwinkel)
  )
  
  (print VWnkl)
  
  ; ******************************************************************
  ; AT ist Unterzug
  ; ******************************************************************
  (if (= ID_Unterzug Tr_ID)
  	(progn
  		
  		(if (= (Connect.get CastaData LinkesEnde) 1)
  			(setq TrgEnde (Traeger.get Tr_ID links))
  		)
  		(if (= (Connect.get CastaData RechtesEnde) 1)
  			(setq TrgEnde (Traeger.get Tr_ID rechts))
  		)
  		
  	
  		(setq sinAlfa (sin (/ (* PI afl_winkel_uz) 180.0))
		  			cosAlfa (cos (/ (* PI afl_winkel_uz) 180.0))
		  			tanAlfa (tan (/ (* PI afl_winkel_uz) 180.0))
		  )
		  
		  (print afl_winkel_uz)
		  
		  
		  ; Winkel
			(if (= (Connect.get CastaData linkesEnde) 1)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr)  1) (setq EWnkl_Trg (+ 180.0 afl_winkel_uz)))
					(if (= (Connect.get CastaData vatr-lhtr) -1) (setq EWnkl_Trg (- 180.0 afl_winkel_uz)))	
				)
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr)  1) (setq EWnkl_Trg (- 180.0 afl_winkel_uz)))
					(if (= (Connect.get CastaData vatr-lhtr) -1) (setq EWnkl_Trg (+ 180.0 afl_winkel_uz)))
				)
			)
			
			(print EWnkl_Trg)
		  (TrEnde.set TrgEnde (V_Winkel (- EWnkl_Trg)))
		
		  
		  
		  ; delta_l
   
     	(print delta_v_stz)
     	(if (= (Connect.get CastaData amHtUnterflansch) 1)
     		(progn
     			(setq hProf2 (- (+ (* 0.5 h_stz) (- delta_v_stz))));ok
    		)
     	)
     	(if (= (Connect.get CastaData amHtOberflansch) 1)
     		(progn
     			(setq hProf2 (- (+ (* 0.5 h_stz) delta_v_stz)));ok
     		)
     	)
   
        
				
			; Anteil delta_v Verschiebung AT
  		
  		(setq anteil_dv_at (* delta_v_uz cosAlfa))
  		(print anteil_dv_at)
  		
  		(if (= (Connect.get CastaData vatr-lhtr)  1) (setq hProf2 (+ hProf2 anteil_dv_at)))
  		(if (= (Connect.get CastaData vatr-lhtr) -1) (setq hProf2 (- hProf2 anteil_dv_at)))
  		
  		
  		
  		
  		;(TrEnde.set TrgEnde 	(delta_l  (- hProf2)))
  		(TrEnde.set TrgEnde (delta_l  0))
  		(TrEnde.ptrim TrgEnde hProf2)
		
		)
	)
	
	
	
	; ******************************************************************
  ; HT ist Unterzug
  ; ******************************************************************
	(if (= ID_Unterzug Htrg)
  	(progn
  		(print "HAUPTTRGER IST UNTERZUG")
  		
	  	(if (= (Connect.get CastaData rechtesEnde) 1)
	  		(progn
					(if (= (connect.get CastaData anHtLinkesEnde) 1) 
						(progn
						  (setq TrgEnde (Traeger.get ID_Unterzug links))
							(if (= (Connect.get CastaData satr-shtr) -1)	(setq hProf2 (+ (* 0.5 h_stz) delta_v_stz)))
						  (if (= (Connect.get CastaData satr-shtr) 1)		(setq hProf2 (+ (* 0.5 h_stz) (- delta_v_stz))))    
						)
					)
					(if (= (connect.get CastaData anHtRechtesEnde) 1) 
						(progn
						  (setq TrgEnde (Traeger.get ID_Unterzug rechts))
							(if (= (Connect.get CastaData satr-shtr) 1)		(setq hProf2 	(+ (* 0.5 h_stz) delta_v_stz)))
							(if (= (Connect.get CastaData satr-shtr) -1)	(setq hProf2 	(+ (* 0.5 h_stz) (- delta_v_stz))))
						)
					)
				)
			)
			(if (= (Connect.get CastaData linkesEnde) 1)
	  		(progn
					(if (= (connect.get CastaData anHtLinkesEnde) 1) 
						(progn
						  (setq TrgEnde (Traeger.get ID_Unterzug links))
							(if (= (Connect.get CastaData satr-shtr) -1)	(setq hProf2 (+ (* 0.5 h_stz) (- delta_v_stz))))
						  (if (= (Connect.get CastaData satr-shtr) 1)		(setq hProf2 (+ (* 0.5 h_stz) delta_v_stz)))    
						)
					)
					(if (= (connect.get CastaData anHtRechtesEnde) 1) 
						(progn
						  (setq TrgEnde (Traeger.get ID_Unterzug rechts))
							(if (= (Connect.get CastaData satr-shtr) 1)		(setq hProf2 	(+ (* 0.5 h_stz) (- delta_v_stz))))
							(if (= (Connect.get CastaData satr-shtr) -1)	(setq hProf2 	(+ (* 0.5 h_stz) delta_v_stz)))
						)
					)
				)
			)
		  
		  (print hProf2)
		  
		  (setq sinAlfa (sin (/ (* PI VWnkl_ht) 180.0))
		  			cosAlfa (cos (/ (* PI VWnkl_ht) 180.0))
		  			tanAlfa (tan (/ (* PI VWnkl_ht) 180.0))
		  )
		
		  (if (/= cosAlfa 0.0) (setq hProf2 (/ hProf2 cosAlfa)))
		  
		  (if (= (connect.get CastaData anHtLinkesEnde) 1) 
		  	(progn
		  		(setq hProf2 (+ hProf2 (* delta_v_uz tanAlfa)))
		  	)
		  )
		  (if (= (connect.get CastaData anHtRechtesEnde) 1) 
		  	(progn
		  		(setq hProf2 (- hProf2 (* delta_v_uz tanAlfa)))
		  	)
		  )
		  
		  (print hProf2)
		  
		  (if (= (connect.get CastaData anHtLinkesEnde) 1) (progn
				(setq EWnkl_Trg (+ 180.0 afl_winkel_uz)))
		  )
		
		  (if (= (connect.get CastaData anHtRechtesEnde) 1) (progn
				(setq EWnkl_Trg (+ 180.0 afl_winkel_uz)))
		  )
			
			
			(print EWnkl_Trg)
		  (TrEnde.set TrgEnde 	(delta_l  (- hProf2))
		  											(V_Winkel (- EWnkl_Trg))
		  )
		)
	)
  (print "------------------------------------------------------------")
)
; ----------------------------------------------------------------------------------------
; Berechnet das Ende der Sttze
; ----------------------------------------------------------------------------------------
(defun calcStuetzenEnde (ID_Stuetze ID_Unterzug)
	
	(if (= 1 1) (progn
	(print "--------------------------------------------------------------------------------")
	(print "BERECHNE STTZENENDEN")
	
	; Wenn AT = Sttze
  (if (= ID_Stuetze  Tr_ID) (progn
  	(print "AT = Sttze")
  	(setq VWnkl  (connect.get CastaData HptTrg_VWinkel))
  	(if (= (connect.get CastaData LinkesEnde) 1) (progn
      		(setq TrgEnde (Traeger.get ID_Stuetze links))
  	))
  	(if (= (connect.get CastaData RechtesEnde) 1) (progn
      		(setq TrgEnde (Traeger.get ID_Stuetze rechts))
  	))
  ))
  ; Wenn AT = Unterzug
  (if (= ID_Unterzug Tr_ID) (progn
  	(print "AT = Unterzug")
  	(setq VWnkl  (connect.get CastaData trg_VWinkel))
  	
  	(if (= (connect.get CastaData anHtLinkesEnde) 1) 
  		(progn
  			(print "ht-links")
      	(setq TrgEnde (Traeger.get ID_Stuetze links))
  		)
  	)
  	(if (= (connect.get CastaData anHtRechtesEnde) 1) 
  		(progn
  			(print "ht-rechts")
      	(setq TrgEnde (Traeger.get ID_Stuetze rechts))
  		)
  	)
  ))
  
  
  (print VWnkl) 
  
  (setq hProf  				(Traeger.get ID_Unterzug h)
  			delta_v_htrg  (Traeger.get ID_Stuetze delta_v)
				deltaV 				(Traeger.get ID_Unterzug delta_V)
  )

  (setq sinAlfa (sin (/ (* PI VWnkl) 180.0))
  			cosAlfa (cos (/ (* PI VWnkl) 180.0))
  			tanAlfa (tan (/ (* PI VWnkl) 180.0))
  )

	(print deltaV)
	(setq hProf2 				(+ (* 0.5 hProf) deltaV))
	
	
	
  (if (/= cosAlfa 0.0) (setq hProf2 (/ hProf2 cosAlfa)))
  (print hProf2)

	
	; - wichtig - diese beiden Variablen schon einmal definieren,
	;   falls die if-Bedingung nicht zutrifft.
  (setq hEWnkl_Stz 90.0)
  
  ; ******************************************************************
  ; AT ist Sttze
  ; ******************************************************************
  (if (= ID_Stuetze Tr_ID) 
  	(progn
  		(setq EWnkl_Stz  90.0)
	
			(setq UZ_HWinkel   (connect.get CastaData HptTrg_HWinkel))	(print UZ_HWinkel)
			(setq Stz_RotaWnkl (Traeger.get ID_Stuetze R_Winkel)) 			
	
			;(setq Stz_RotaWnkl (- 360.0 Stz_RotaWnkl))
			;(setq Stz_RotaWnkl (- Stz_RotaWnkl 90.0))
			(if (< Stz_RotaWnkl 0.0) (setq Stz_RotaWnkl (+ Stz_RotaWnkl 360.0)))
			(if (= Stz_RotaWnkl 360.0) (setq Stz_RotaWnkl 0))
			(print Stz_RotaWnkl)
			
			(setq diffWinkel (- UZ_HWinkel Stz_RotaWnkl))
			(print diffWinkel)
			(if (= (connect.get CastaData LinkesEnde) 1) (progn
	    		(if (= diffWinkel    0.0) (setq EWnkl_Stz (+ 90.0 VWnkl)))
	    		(if (= diffWinkel  180.0) (setq EWnkl_Stz (- 90.0 VWnkl)))
	    		(if (= diffWinkel -180.0) (setq EWnkl_Stz (- 90.0 VWnkl)))
			))
			(if (= (connect.get CastaData RechtesEnde) 1) (progn
	    		(if (= diffWinkel    0.0) (setq EWnkl_Stz (+ 90.0 VWnkl)))
	    		(if (= diffWinkel  180.0) (setq EWnkl_Stz (- 90.0 VWnkl)))
	    		(if (= diffWinkel -180.0) (setq EWnkl_Stz (- 90.0 VWnkl)))
			))
	
			(setq nWnkl (- EWnkl_Stz 90.0))
			(print nWnkl)
			(setq tan_nWnkl (tan (/ (* PI nWnkl) 180.0)))
			(setq dV_Stz (Traeger.get ID_Stuetze delta_V))
			
			(if (/= dV_Stz 0.0) 
				(progn
	    		(setq dvDiff (* dV_Stz tan_nWnkl))
	    			(if (= (connect.get CastaData LinkesEnde) 1)
	    				(setq hProf2 (+ hProf2 dvDiff))
	    			)
	    			(if (= (connect.get CastaData RechtesEnde) 1)
	    				(setq hProf2 (- hProf2 dvDiff))
	    			)
				)
			)

			(print diffWinkel)
			(if (= (connect.get CastaData LinkesEnde) 1) (progn
	    		(if (= diffWinkel   90.0) (setq hEWnkl_Stz (- 90.0 VWnkl)))
	    		(if (= diffWinkel  -90.0) (setq hEWnkl_Stz (- 90.0 VWnkl)))
	    		(if (= diffWinkel  270.0) (setq hEWnkl_Stz (+ 90.0 VWnkl)))
	    		(if (= diffWinkel -270.0) (setq hEWnkl_Stz (+ 90.0 VWnkl)))
			))
			(if (= (connect.get CastaData RechtesEnde) 1) (progn
	    		(if (= diffWinkel   90.0) (setq hEWnkl_Stz (+ 90.0 VWnkl)))
	    		(if (= diffWinkel  -90.0) (setq hEWnkl_Stz (- 90.0 VWnkl)))
	    		(if (= diffWinkel  270.0) (setq hEWnkl_Stz (- 90.0 VWnkl)))
	    		(if (= diffWinkel -270.0) (setq hEWnkl_Stz (+ 90.0 VWnkl)))
			))
			(print hEWnkl_Stz)
			(setq dH_Stz (Traeger.get ID_Stuetze delta_lr))
			(if (/= dH_Stz 0.0) (progn
	    		(setq nWnkl (- hEWnkl_Stz 90.0))
	    		(setq tan_nWnkl (tan (/ (* PI nWnkl) 180.0)))
	    		(setq dvDiff (* dH_Stz tan_nWnkl))
	    
	    		(if (= (connect.get CastaData LinkesEnde) 1)
	    			(setq hProf2 (+ hProf2 dvDiff))
	    		)
	    		(if (= (connect.get CastaData RechtesEnde) 1)
	    			(setq hProf2 (- hProf2 dvDiff))
	    		)
			))
		)
	)

	; ******************************************************************
  ; HT ist Sttze
  ; ******************************************************************
  (if (= ID_Stuetze Htrg) 
  	(progn
  		(print "STTZE IST HT")
  		
  		(print vwnkl)
  		  		
  		(if (= (connect.get CastaData amHtUnterflansch) 1) 
		  	(progn
		  		(print "HT-UNTERFLANSCH")
		  		(if (= (Connect.get CastaData anHtrechtesEnde) 1)
		  			(progn
		  				(if (= (Connect.get CastaData vatr-lhtr) 1)
		  					(progn
									(if (= (Connect.get CastaData satr-shtr)  1)	(setq EWnkl_Stz (- 90.0 VWnkl)));ok
									(if (= (Connect.get CastaData satr-shtr) -1)	(setq EWnkl_Stz (+ 90.0 VWnkl)));ok
								)
							)
							(if (= (Connect.get CastaData vatr-lhtr) -1)
		  					(progn
									(if (= (Connect.get CastaData satr-shtr)  1)	(setq EWnkl_Stz (+ 90.0 VWnkl)));ok
									(if (= (Connect.get CastaData satr-shtr) -1)	(setq EWnkl_Stz (- 90.0 VWnkl)));ok
								)
							)
						)
					)
					(if (= (Connect.get CastaData anHtlinkesEnde) 1)
		  			(progn
							(if (= (Connect.get CastaData vatr-lhtr) 1)
		  					(progn
									(if (= (Connect.get CastaData satr-shtr)  1)	(setq EWnkl_Stz (- 90.0 VWnkl)))
									(if (= (Connect.get CastaData satr-shtr) -1)	(setq EWnkl_Stz (+ 90.0 VWnkl)));ok
								)
							)
							(if (= (Connect.get CastaData vatr-lhtr) -1)
		  					(progn
									(if (= (Connect.get CastaData satr-shtr)  1)	(setq EWnkl_Stz (+ 90.0 VWnkl)));ok
									(if (= (Connect.get CastaData satr-shtr) -1)	(setq EWnkl_Stz (- 90.0 VWnkl)))
								)
							)
						)
					)
		  	)
		  )
			(if (= (connect.get CastaData amHtOberflansch) 1) 
				(progn
					(print "HT-OBERFLANSCH")
					(if (= (Connect.get CastaData anHtrechtesEnde) 1)
		  			(progn
							(if (= (Connect.get CastaData vatr-lhtr) 1)
		  					(progn
									(if (= (Connect.get CastaData satr-shtr)  1)	(setq EWnkl_Stz (- 90.0 VWnkl)));ok
									(if (= (Connect.get CastaData satr-shtr) -1)	(setq EWnkl_Stz (+ 90.0 VWnkl)));ok
								)
							)
							(if (= (Connect.get CastaData vatr-lhtr) -1)
		  					(progn
									(if (= (Connect.get CastaData satr-shtr)  1)	(setq EWnkl_Stz (+ 90.0 VWnkl)));ok
									(if (= (Connect.get CastaData satr-shtr) -1)	(setq EWnkl_Stz (- 90.0 VWnkl)));ok
								)
							)
						)
					)
					(if (= (Connect.get CastaData anHtlinkesEnde) 1)
		  			(progn
							(if (= (Connect.get CastaData vatr-lhtr) 1)
		  					(progn
									(if (= (Connect.get CastaData satr-shtr)  1)	(setq EWnkl_Stz (- 90.0 VWnkl)));ok
									(if (= (Connect.get CastaData satr-shtr) -1)	(setq EWnkl_Stz (+ 90.0 VWnkl)));ok
								)
							)
							(if (= (Connect.get CastaData vatr-lhtr) -1)
		  					(progn
									(if (= (Connect.get CastaData satr-shtr)  1)	(setq EWnkl_Stz (+ 90.0 VWnkl)))
									(if (= (Connect.get CastaData satr-shtr) -1)	(setq EWnkl_Stz (- 90.0 VWnkl)));ok
								)
							)
						)
					)
		  	)
		  )
		  
			(if (= (Connect.get CastaData anschlzwAtEnden) 1)
				(progn
					(if (= (Connect.get CastaData anHtrechtesEnde) 1)
		  			(progn
							(if (= (Connect.get CastaData satr-shtr)  1)	(setq EWnkl_Stz (+ 90.0 VWnkl)))
							(if (= (Connect.get CastaData satr-shtr) -1)	(setq EWnkl_Stz (- 90.0 VWnkl)))
						)
					)
					(if (= (Connect.get CastaData anHtlinkesEnde) 1)
		  			(progn
							(if (= (Connect.get CastaData satr-shtr)  1)	(setq EWnkl_Stz (- 90.0 VWnkl)))
							(if (= (Connect.get CastaData satr-shtr) -1)	(setq EWnkl_Stz (+ 90.0 VWnkl)))
						)
					)
				)
			)
  		
  		
  		
  		(setq ht_vwinkel (Connect.get CastaData hpttrg_vwinkel))
  		(print ht_vwinkel)
  		
  		  		
  		(if (> ht_vwinkel 255.0)
  			(progn
  				(if (< ht_vwinkel 285.0)
  					(progn
  						(setq EWnkl_Stz (- 180.0 EWnkl_Stz))
  					)
  				)
  			)
  		)
  		
  		
  		
  		; Lngennderung
  		(print hprof2)
  		(setq rWnkl_Stz	(traeger.get ID_Stuetze r_winkel))
  		
  		(setq dv_verl (* delta_v_htrg tanAlfa))
  		(print dv_verl)
  		(if (= (Connect.get CastaData anschlzwAtEnden) 0)
  			(progn
		  		(if (= (Connect.get CastaData amHtOberflansch) 1)
		  			(progn
		  				(if (= (connect.get CastaData LinkesEnde) 1)	(setq hProf2 (+ hprof2 dv_verl)))
		  				(if (= (connect.get CastaData RechtesEnde) 1)	(setq hProf2 (- hprof2 dv_verl)))
		  			)
		  		)
		  		(if (= (Connect.get CastaData amHtUnterflansch) 1)
		  			(progn
		  				(if (= (connect.get CastaData LinkesEnde) 1)	(setq hProf2 (- hprof2 dv_verl)))
		  				(if (= (connect.get CastaData RechtesEnde) 1)	(setq hProf2 (+ hprof2 dv_verl)))
		  			)
		  		)
		  		(print hprof2)
		  	)
		  )
  		(if (= (Connect.get CastaData anschlzwAtEnden) 1)
  			(progn
  				(if (= (Connect.get CastaData anHtRechtesEnde) 1)
  					(progn
  						(if (= (Connect.get CastaData satr-shtr)  1)	(setq hProf2 (- hprof2 dv_verl)))
  						(if (= (Connect.get CastaData satr-shtr) -1)	(setq hProf2 (+ hprof2 dv_verl)))
  					)
  				)
  				(if (= (Connect.get CastaData anHtLinkesEnde) 1)
  					(progn
  						(if (= (Connect.get CastaData satr-shtr)  1)	(setq hProf2 (+ hprof2 dv_verl)))
  						(if (= (Connect.get CastaData satr-shtr) -1)	(setq hProf2 (- hprof2 dv_verl)))
  					)
  				)
  			)
  		)
  		
  		
  	)
  )
  
  
  
  (print hProf2)
  (print EWnkl_Stz)
  (print hEWnkl_Stz)
  (TrEnde.set TrgEnde 	(delta_l 	hProf2)
  											(V_Winkel EWnkl_Stz)
  											(H_Winkel hEWnkl_Stz)
  )
  
  (print "--------------------------------------------------------------------------------")
  
))
)
; ====================================================================== 
