(defun init-traegerenden ()
	(print ">-----------------------------------------------------------")
	(print "BERECHNUNG DER TRGERENDEN")

	(Connect.showAttributes CastaData)

	(setq vWinkel_trg 	(Connect.get CastaData trg_vwinkel))
	(print vWinkel_trg)
	
	(if (>= vWinkel_trg 0.0)
		(setq at_is_stz 0)
	)
	(if (> vWinkel_trg 45.0)
		(setq at_is_stz 1)
	)
	(if (>= vWinkel_trg 135.0)
		(setq at_is_stz 0)
	)
	(if (> vWinkel_trg 225.0)
		(setq at_is_stz 1)
	)
	(if (> vWinkel_trg 315.0)
		(setq at_is_stz 0)
	)

	(setq vWinkel_HTrg 	(Connect.get CastaData HptTrg_VWinkel))
	(if (> vWinkel_HTrg   80.0) (if (< vWinkel_HTrg 100.0) (setq at_is_stz 0)))
	(if (> vWinkel_HTrg  260.0) (if (< vWinkel_HTrg 280.0) (setq at_is_stz 0)))
	(if (> vWinkel_HTrg -100.0) (if (< vWinkel_HTrg -80.0) (setq at_is_stz 0)))
	
	
	; Wenn die Sttze der HT ist, ....
	(if (= at_is_stz 0)
		(progn

			(print "HT ist Sttze")
			(calcStuetzenEnde Htrg Tr_ID)
			
			(if (= (Connect.get CastaData AnschlZwAtEnden) 0)
				(progn
					(calcTraegerEnde Htrg Tr_ID)
				)
			)
		)
	)
	
	; Wenn die Sttze der AT ist, ....
	(if (= at_is_stz 1)
		(progn
			(print "AT ist Sttze")
			(calcStuetzenEnde Tr_ID Htrg)
			
			(if (= (Connect.get CastaData AnschlZwHtEnden) 0)
				(progn
					(calcTraegerEnde Tr_ID Htrg)
				)
			)
		)
	)
		
		
	(print "<-----------------------------------------------------------")
  
)



; ====================================================================== 
; ====================================================================== 
(defun calcTraegerEnde (ID_Stuetze ID_Unterzug)
  (print "------------------------------------------------------------")
  (print "BERECHNE AT-ENDE")
  (setq hProf  				(Traeger.get ID_Stuetze h)
  			bProf					(Traeger.get ID_Stuetze b)
  			rWnkl_htrg		(traeger.get ID_Stuetze r_winkel)
  			rWnkl_trg		  (traeger.get ID_Unterzug r_winkel)
  			delta_lr_htrg	(Traeger.get ID_Stuetze delta_lr)
				deltaV 				(Traeger.get ID_Unterzug delta_V)
				VWnkl  				(connect.get CastaData trg_VWinkel)
				VWnkl_ht			(connect.get CastaData hpttrg_VWinkel)
  )
  
  (setq EWnkl_Trg 0.0)
  (setq bProf2      0)
  
  (print VWnkl)
  
  
  ; AT ist der UZ
  ; **********************************************
  (if (= ID_Unterzug Tr_ID)
  	(progn
  		(if (= (Connect.get CastaData linkesEnde) 1)	(setq UZ_Ende (Traeger.get Tr_ID links)))
  		(if (= (Connect.get CastaData rechtesEnde) 1)	(setq UZ_Ende (Traeger.get Tr_ID rechts)))
  		
  		
	  	(if (= (Connect.get CastaData vatr-lhtr)  1)
	  		(progn
		  		(if (= (Connect.get CastaData satr-vhtr)  1)	(setq EWnkl_UZ (- 90.0 VWnkl)))
		  		(if (= (Connect.get CastaData satr-vhtr) -1)	(setq EWnkl_UZ (- 90.0 VWnkl)))
		  	)
		  )
			(if (= (Connect.get CastaData vatr-lhtr) -1)
	  		(progn
		  		(if (= (Connect.get CastaData satr-vhtr)  1)	(setq EWnkl_UZ (- 90.0 VWnkl)))
		  		(if (= (Connect.get CastaData satr-vhtr) -1)	(setq EWnkl_UZ (- 90.0 VWnkl)))
		  	)
		  )
		  
		  
			; Lngennderung des UZ
			(setq delta_l_uz 0.0)
			
			; Anteil Stz-Breite
			(setq anteil_stz_b (* 0.5 bProf))
			(setq delta_l_uz (- delta_l_uz anteil_stz_b))
			
			; Anteil delta_v des UZ an Lngennderung UZ
			(setq anteil_delta_v_uz (* deltaV tanAlfa))
			
			(if (= (Connect.get CastaData linkesEnde) 1)
				(progn
					(if (= (Connect.get CastaData satr-vhtr)  1)	(setq delta_l_uz (- delta_l_uz anteil_delta_v_uz)))
					(if (= (Connect.get CastaData satr-vhtr) -1)	(setq delta_l_uz (- delta_l_uz anteil_delta_v_uz)))
				)
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(progn
					(if (= (Connect.get CastaData satr-vhtr)  1)	(setq delta_l_uz (+ delta_l_uz anteil_delta_v_uz)))
					(if (= (Connect.get CastaData satr-vhtr) -1)	(setq delta_l_uz (+ delta_l_uz anteil_delta_v_uz)))
				)
			)
			
			; Anteil delta_lr der Stz an Lngennderung UZ
			(setq riegel_wnkl (Connect.get CastaData trg_vwinkel))
			(setq cosRW (cos (/ (* PI riegel_wnkl) 180.0)))
			(setq anteil_delta_lr_stz (/ delta_lr_htrg cosRW))
			
			(print delta_l_uz)
			(if (= (Connect.get CastaData linkesEnde) 1)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr) 1)
						(progn
							(if (= (Connect.get CastaData satr-vhtr)  1)	(setq delta_l_uz (+ delta_l_uz anteil_delta_lr_stz)))
							(if (= (Connect.get CastaData satr-vhtr) -1)	(setq delta_l_uz (- delta_l_uz anteil_delta_lr_stz)))
						)
					)
					(if (= (Connect.get CastaData vatr-lhtr) -1)
						(progn
							(if (= (Connect.get CastaData satr-vhtr)  1)	(setq delta_l_uz (- delta_l_uz anteil_delta_lr_stz)))
							(if (= (Connect.get CastaData satr-vhtr) -1)	(setq delta_l_uz (+ delta_l_uz anteil_delta_lr_stz)))
						)
					)
				)
			)
			(print delta_l_uz)
			
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr) 1)
						(progn
							(if (= (Connect.get CastaData satr-vhtr)  1)	(setq delta_l_uz (- delta_l_uz anteil_delta_lr_stz)))
							(if (= (Connect.get CastaData satr-vhtr) -1)	(setq delta_l_uz (+ delta_l_uz anteil_delta_lr_stz)))
						)
					)
					(if (= (Connect.get CastaData vatr-lhtr) -1)
						(progn
							(if (= (Connect.get CastaData satr-vhtr)  1)	(setq delta_l_uz (+ delta_l_uz anteil_delta_lr_stz)))
							(if (= (Connect.get CastaData satr-vhtr) -1)	(setq delta_l_uz (- delta_l_uz anteil_delta_lr_stz)))
						)
					)
				)
			)
			
			
		  (TrEnde.set UZ_Ende 	(delta_l  delta_l_uz)
		  											(V_Winkel EWnkl_UZ)
		  )
		)
	)
	
	
	
	
	
	
	; HT ist der UZ
  ; **********************************************
	(if (= ID_Unterzug Htrg)
  	(progn
  		(print "HAUPTTRGER IST UNTERZUG")
  		
	  	(if (= (Connect.get CastaData rechtesEnde) 1)
	  		(progn
					(if (= (connect.get CastaData anHtLinkesEnde) 1) 
						(progn
						  (setq TrgEnde (Traeger.get ID_Unterzug links))
							(if (= (Connect.get CastaData satr-lhtr) -1)	(setq bProf2 (+ (* 0.5 bProf) delta_lr_htrg)))
						  (if (= (Connect.get CastaData satr-lhtr) 1)		(setq bProf2 (+ (* 0.5 bProf) (- delta_lr_htrg))))    
						)
					)
					(if (= (connect.get CastaData anHtRechtesEnde) 1) 
						(progn
						  (setq TrgEnde (Traeger.get ID_Unterzug rechts))
							(if (= (Connect.get CastaData satr-lhtr) 1)		(setq bProf2 	(+ (* 0.5 bProf) delta_lr_htrg)))
							(if (= (Connect.get CastaData satr-lhtr) -1)	(setq bProf2 	(+ (* 0.5 bProf) (- delta_lr_htrg))))
						)
					)
				)
			)
			(if (= (Connect.get CastaData linkesEnde) 1)
	  		(progn
					(if (= (connect.get CastaData anHtLinkesEnde) 1) 
						(progn
						  (setq TrgEnde (Traeger.get ID_Unterzug links))
							(if (= (Connect.get CastaData satr-lhtr) -1)	(setq bProf2 (+ (* 0.5 bProf) delta_lr_htrg)))
						  (if (= (Connect.get CastaData satr-lhtr) 1)		(setq bProf2 (+ (* 0.5 bProf) (- delta_lr_htrg))))    
						)
					)
					(if (= (connect.get CastaData anHtRechtesEnde) 1) 
						(progn
						  (setq TrgEnde (Traeger.get ID_Unterzug rechts))
							(if (= (Connect.get CastaData satr-lhtr) 1)		(setq bProf2 	(+ (* 0.5 bProf) delta_lr_htrg)))
							(if (= (Connect.get CastaData satr-lhtr) -1)	(setq bProf2 	(+ (* 0.5 bProf) (- delta_lr_htrg))))
						)
					)
				)
			)
		  
		  (print bProf2)
		  
		  (setq sinAlfa (sin (/ (* PI VWnkl_ht) 180.0))
		  			cosAlfa (cos (/ (* PI VWnkl_ht) 180.0))
		  			tanAlfa (tan (/ (* PI VWnkl_ht) 180.0))
		  )
		
		  (if (/= cosAlfa 0.0) (setq bProf2 (/ bProf2 cosAlfa)))
		  
		  (if (= (connect.get CastaData anHtLinkesEnde) 1) 
		  	(progn
		  		(setq bProf2 (+ bProf2 (* deltaV tanAlfa)))
		  	)
		  )
		  (if (= (connect.get CastaData anHtRechtesEnde) 1) 
		  	(progn
		  		(setq bProf2 (- bProf2 (* deltaV tanAlfa)))
		  	)
		  )
		  
		  (print bProf2)
		  
		  (if (= (connect.get CastaData anHtLinkesEnde) 1) (progn
			 	(if (= rWnkl_trg   0.0) (setq EWnkl_Trg (+ 90.0 VWnkl_ht)))
			 	(if (= rWnkl_trg 180.0) (setq EWnkl_Trg (- 90.0 VWnkl_ht)))
		  ))
		
		  (if (= (connect.get CastaData anHtRechtesEnde) 1) (progn
				(if (= rWnkl_trg   0.0) (setq EWnkl_Trg (+ 90.0 VWnkl_ht)))
				(if (= rWnkl_trg 180.0) (setq EWnkl_Trg (- 90.0 VWnkl_ht  )))
		  ))
			
			
			(print EWnkl_Trg)
		  (TrEnde.set TrgEnde 	(delta_l  (- bProf2))
		  											(V_Winkel (- EWnkl_Trg))
		  )
		)
	)
  (print "------------------------------------------------------------")
)




; ----------------------------------------------------------------------------------------
; Berechnet das Ende der Sttze
; ----------------------------------------------------------------------------------------
(defun calcStuetzenEnde (ID_Stuetze ID_Unterzug)
	(print "*clear*")
	(print "--------------------------------------------------------------------------------")
	(print "BERECHNE STTZENENDEN")
	; Wenn AT = Sttze

	(connect.showAttributes CastaData)

  (if (= ID_Stuetze  Tr_ID) (progn
  	(print "AT = Sttze")
  	(setq VWnkl  (connect.get CastaData HptTrg_VWinkel))
  	(if (= (connect.get CastaData LinkesEnde) 1) (progn
      		(setq TrgEnde (Traeger.get ID_Stuetze links))
  	))
  	(if (= (connect.get CastaData RechtesEnde) 1) (progn
      		(setq TrgEnde (Traeger.get ID_Stuetze rechts))
  	))
  ))
  ; Wenn AT = Unterzug
  (if (= ID_Unterzug Tr_ID) (progn
  	(print "AT = Unterzug")
  	(setq VWnkl  (connect.get CastaData trg_VWinkel))
  	
  	(if (= (connect.get CastaData anHtLinkesEnde) 1) 
  		(progn
			(print "ht-links")
			(setq TrgEnde (Traeger.get ID_Stuetze links))
  		)
  	)
  	(if (= (connect.get CastaData anHtRechtesEnde) 1) 
  		(progn
			(print "ht-rechts")
			(setq TrgEnde (Traeger.get ID_Stuetze rechts))
  		)
  	)
  ))
  
  
  (print VWnkl) 
  
  (setq hProf  		(Traeger.get ID_Unterzug h)
  	delta_v_htrg 	(Traeger.get ID_Stuetze delta_v)
	deltaV		(Traeger.get ID_Unterzug delta_V)
	delta_lr_stz	(Traeger.get ID_Stuetze delta_lr)
  )

  (setq sinAlfa (sin (/ (* PI VWnkl) 180.0))
  	cosAlfa (cos (/ (* PI VWnkl) 180.0))
  	tanAlfa (tan (/ (* PI VWnkl) 180.0))
  )

	(print deltaV)
	

	
	; - wichtig - diese beiden Variablen schon einmal definieren,
	;   falls die if-Bedingung nicht zutrifft.
  (setq hEWnkl_Stz 90.0)
  
  
  ; Lngennderung der Sttze
  ; ------------------------------------------
  (setq h_riegel_halb (* 0.5 hProf))
  (if (> cosAlfa 0.0) (if (< cosAlfa  0.00001) (setq cosAlfa 0.0)))
  (if (< cosAlfa 0.0) (if (> cosAlfa -0.00001) (setq cosAlfa 0.0)))

  (if (= cosAlfa 0.0)
  	(setq delta_l_stz h_riegel_halb)
  	(setq delta_l_stz (/ h_riegel_halb cosAlfa))
  )
  (print delta_l_stz)
  
  
  ; Wenn Anschlusstrger die Sttze ist ...
  ; ******************************************************************
  (if (= ID_Stuetze Tr_ID) 
  	(progn
 		(print "AT ist Sttze")
  		(setq EWnkl_Stz  90.0)
	
			(print vwnkl)			
				
			(if (= (connect.get CastaData amHtUnterflansch) 1) 
		  	(progn		
					(if (= (Connect.get CastaData satr-lhtr)  1)
						(progn
							(if (= (Connect.get CastaData vatr-shtr)  1) (setq hEWnkl_Stz (- 90.0 vwnkl)))
							(if (= (Connect.get CastaData vatr-shtr) -1) (setq hEWnkl_Stz (+ 90.0 vwnkl)))
							(if (= (Connect.get CastaData linkesEnde) 1)
								(progn
									(if (= (Connect.get CastaData vatr-lhtr)  1) (setq hEWnkl_Stz (- 90.0 vwnkl)));ok
									(if (= (Connect.get CastaData vatr-lhtr) -1) (setq hEWnkl_Stz (- 90.0 vwnkl)));ok
								)
							)
							(if (= (Connect.get CastaData rechtesEnde) 1)
								(progn
									(if (= (Connect.get CastaData vatr-lhtr)  1) (setq hEWnkl_Stz (+ 90.0 vwnkl)));ok
									(if (= (Connect.get CastaData vatr-lhtr) -1) (setq hEWnkl_Stz (+ 90.0 vwnkl)));ok
								)
							)
						)
					)
					(if (= (Connect.get CastaData satr-lhtr) -1)
						(progn
							(if (= (Connect.get CastaData vatr-shtr)  1) (setq hEWnkl_Stz (- 90.0 vwnkl)))
							(if (= (Connect.get CastaData vatr-shtr) -1) (setq hEWnkl_Stz (+ 90.0 vwnkl)))
							(if (= (Connect.get CastaData linkesEnde) 1)
								(progn
									(if (= (Connect.get CastaData vatr-lhtr)  1) (setq hEWnkl_Stz (+ 90.0 vwnkl)));ok
									(if (= (Connect.get CastaData vatr-lhtr) -1) (setq hEWnkl_Stz (+ 90.0 vwnkl)));ok
								)
							)
							(if (= (Connect.get CastaData rechtesEnde) 1)
								(progn
									(if (= (Connect.get CastaData vatr-lhtr)  1) (setq hEWnkl_Stz (- 90.0 vwnkl)));ok
									(if (= (Connect.get CastaData vatr-lhtr) -1) (setq hEWnkl_Stz (- 90.0 vwnkl)));ok
								)
							)
						)
					)
				)
			)
			(if (= (connect.get CastaData amHtOberflansch) 1) 
		  	(progn			
					(if (= (Connect.get CastaData satr-lhtr)  1)
						(progn
							(if (= (Connect.get CastaData vatr-shtr)  1) (setq hEWnkl_Stz (+ 90.0 vwnkl)))
							(if (= (Connect.get CastaData vatr-shtr) -1) (setq hEWnkl_Stz (- 90.0 vwnkl)))
							(if (= (Connect.get CastaData linkesEnde) 1)
								(progn
									(if (= (Connect.get CastaData vatr-lhtr)  1) (setq hEWnkl_Stz (- 90.0 vwnkl)));ok
									(if (= (Connect.get CastaData vatr-lhtr) -1) (setq hEWnkl_Stz (- 90.0 vwnkl)))
									(if (= (Connect.get CastaData vatr-lhtr)  0) (setq hEWnkl_Stz (+ 90.0 vwnkl)))
								)
							)
							(if (= (Connect.get CastaData rechtesEnde) 1)
								(progn
									(if (= (Connect.get CastaData vatr-lhtr)  1) (setq hEWnkl_Stz (+ 90.0 vwnkl)))
									(if (= (Connect.get CastaData vatr-lhtr) -1) (setq hEWnkl_Stz (+ 90.0 vwnkl)))
									(if (= (Connect.get CastaData vatr-lhtr)  0) (setq hEWnkl_Stz (- 90.0 vwnkl)))
								)
							)
						)
					)
					(if (= (Connect.get CastaData satr-lhtr) -1)
						(progn
							(if (= (Connect.get CastaData vatr-shtr)  1) (setq hEWnkl_Stz (+ 90.0 vwnkl)))
							(if (= (Connect.get CastaData vatr-shtr) -1) (setq hEWnkl_Stz (- 90.0 vwnkl)))
							(if (= (Connect.get CastaData linkesEnde) 1)
								(progn
									(if (= (Connect.get CastaData vatr-lhtr)  1) (setq hEWnkl_Stz (+ 90.0 vwnkl)))
									(if (= (Connect.get CastaData vatr-lhtr) -1) (setq hEWnkl_Stz (+ 90.0 vwnkl)))
									(if (= (Connect.get CastaData vatr-lhtr)  0) (setq hEWnkl_Stz (- 90.0 vwnkl)))
								)
							)
							(if (= (Connect.get CastaData rechtesEnde) 1)
								(progn
									(if (= (Connect.get CastaData vatr-lhtr)  1) (setq hEWnkl_Stz (- 90.0 vwnkl)))
									(if (= (Connect.get CastaData vatr-lhtr) -1) (setq hEWnkl_Stz (- 90.0 vwnkl)))
									(if (= (Connect.get CastaData vatr-lhtr)  0) (setq hEWnkl_Stz (+ 90.0 vwnkl)))
								)
							)
						)
					)
				)
			)
			
			
			; Lngennderung der Sttze
			; ------------------------------------------
			
			; Anteil von delta_v des UZ an der Lngennderung der Stz
  		(if (= cosAlfa 0.0)
  			(setq anteil_delta_v_uz deltaV)
  			(setq anteil_delta_v_uz (/ deltaV cosAlfa))
  		)
  		(print anteil_delta_v_uz)
			(if (= (Connect.get CastaData amHtOberflansch) 1)		(setq anteil_delta_v_uz (- anteil_delta_v_uz)))
			(if (= (Connect.get CastaData amHtUnterflansch) 1)	(setq anteil_delta_v_uz anteil_delta_v_uz))
			
  		(setq delta_l_stz (+ delta_l_stz anteil_delta_v_uz))
			
			
			; Anteil aus delta_lr Verschiebung der Sttze
			(setq tanVW (tan (/ (* PI vwnkl) 180.0)))
			
			(setq anteil_dlr_stz (* delta_lr_stz tanVW))
			
			(if (= (Connect.get CastaData amHtUnterflansch) 1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta_l_stz (- delta_l_stz anteil_dlr_stz)))
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta_l_stz (+ delta_l_stz anteil_dlr_stz)))
				)
			)
			(if (= (Connect.get CastaData amHtOberflansch) 1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta_l_stz (+ delta_l_stz anteil_dlr_stz)))
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta_l_stz (- delta_l_stz anteil_dlr_stz)))
				)
			)
		)
	)





	; Wenn Haupttrger die Sttze ist ...
	; ******************************************************************
  (if (= ID_Stuetze Htrg) 
  	(progn
  		(print "STTZE IST HT")
  		(print "-------------")
  		(print vwnkl)
  		  		
  		; Abschrgung am Ende der Sttze
  		; ------------------------------------------  		
  		(if (= (Connect.get CastaData satr-vhtr)  1)
  			(progn
  				(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq hEWnkl_Stz (- 90.0 VWnkl)))
		  		(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq hEWnkl_Stz (- 90.0 VWnkl)))
		  	)
		  )
			(if (= (Connect.get CastaData satr-vhtr) -1)
  			(progn
  				(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq hEWnkl_Stz (+ 90.0 VWnkl)))
		  		(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq hEWnkl_Stz (+ 90.0 VWnkl)))
		  	)
		  )
  		
  		
  		
  		
  		; Anteil von delta_v des UZ an der Lngennderung der Stz
  		(if (= cosAlfa 0.0)
  			(setq anteil_delta_v_uz deltaV)
  			(setq anteil_delta_v_uz (/ deltaV cosAlfa))
  		)
  			
  		(setq delta_l_stz (+ delta_l_stz anteil_delta_v_uz))
  		
  		
  		; Anteil von delta_lr der Stz an der Lngennderung der Stz
  		(setq anteil_delta_lr_stz (* delta_lr_stz tanAlfa))
  		
  		(if (= (Connect.get CastaData satr-vhtr)  1)
  			(progn
  				(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_l_stz (- delta_l_stz anteil_delta_lr_stz)))
		  		(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_l_stz (+ delta_l_stz anteil_delta_lr_stz)))
		  	)
		  )
			(if (= (Connect.get CastaData satr-vhtr) -1)
  			(progn
  				(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_l_stz (+ delta_l_stz anteil_delta_lr_stz)))
		  		(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_l_stz (- delta_l_stz anteil_delta_lr_stz)))
		  	)
		  )
  		
  		
  		
  	)
  )
  
  (print "------------------------------------------------------------")
  
  
  (print hEWnkl_Stz)
  (TrEnde.set TrgEnde 	(delta_l 	delta_l_stz)
  											;(V_Winkel EWnkl_Stz)
  											(H_Winkel hEWnkl_Stz)
  )
  
  (print "--------------------------------------------------------------------------------")
)
; ====================================================================== 
