
(defun setConnection ()
	(print "Modul kreisfrmige Platte am Fundamentanschluss")
 
	(init-stzfund)
	(init-traegerende)
	
	; Ende festlegen
	(setq EndeFlag 0)
	(if (= (Connect.get CastaData linkesEnde)  1) (setq EndeFlag  1))
	(if (= (Connect.get CastaData rechtesEnde) 1) (setq EndeFlag -1))
   
	(if (/= EndeFlag 0) (progn
		(setq fussPl	(Blech.create))
		(Connect.storeAnschlObjs CastaData fussPl)
		(setq AnkerLchb (Lochbild.create))
		(Connect.storeAnschlObjs CastaData AnkerLchb)

		(Lochbild.set AnkerLchb (S_Bez "M16")
								(Laenge 250)
		)
		; createRingFlanschKpl  Trg blKopfpl lchbKpl dp li_re
		(createRingFlanschKpl Tr_ID fussPl  AnkerLchb 25  EndeFlag)
	  
	  
	  
		(if (= MitRadialSteifen 1) (progn
			(setq Schrb_Anz (Lochbild.get AnkerLchb Anz_S))
			(setq aussenRadius (Blech.get fussPl aRadius))
			(addRadialFahnenBlech aussenRadius Schrb_Anz)
		))
	))

)

; ----------------------------------------------------------------------------------------
; Erzeugt die kreisfrmige Kopf-/Fussplatte
; ---------------------------------------------------------------------------------------- 
(defun createRingFlanschKpl (Trg blKopfpl lchbKpl dp li_re)
		(print ">---------------------------------------------------------")
		(print "ERZEUGE BERSTEHENDE KOPFPLATTE")
    (if (= li_re  1) (setq TrgEnde (Traeger.get Trg links)))
    (if (= li_re -1) (setq TrgEnde (Traeger.get Trg rechts)))
    
    ; damit es auch wirklich senkrecht gestaltet wird.
    (TrEnde.set TrgEnde (delta_L 0.0) (V_Winkel 90.0))
    
  	(setq dp (* 1.0 dp))
  	
    ;(setq uebOben  10)	;; Kopfplattenposition zum Traeger
    ;(setq uebUnten 80)	;; Kopfplattenposition zum Traeger
    
    (setq b_at		(Traeger.get Tr_ID b)
    	  s_at		(Traeger.get Tr_ID s)
		  h_AT		(Traeger.get Tr_ID h)
    )

    (setq hProf		(Traeger.get Trg h)
          hNetto	hProf
    )
    
	(setq hNetto h_AT)

	(setq hMin h_AT)

		; Durchmesser ds der Schrauben
    (setq d_schraube (Lochbild.get lchbKpl sdurchm))

	(setq blRadius (+ (* 0.5 hNetto) (* 4 d_schraube)))
	(setq uebOben (- blRadius (* 0.5 hProf)))
	
	(setq Radius_Innen 0)
    (Blech.set blKopfpl
				(BlechTyp 1)			; runder Platte, 2 - Ring
				(dp    dp)
				(aRadius blRadius)
				(iRadius Radius_Innen)
         		(dOK   (- uebOben))
    )
	
    (if (= li_re  1) (traeger.addabtl Trg blKopfpl 0.0 0.0 _kopfplattelinks_))
    (if (= li_re -1) (traeger.addabtl Trg blKopfpl 0.0 0.0 _kopfplatterechts_))

    (if (= li_re  1) (traeger.addabtl Trg lchbKpl 0.0 0.0 _kpllochbildlinks_))
    (if (= li_re -1) (traeger.addabtl Trg lchbKpl 0.0 0.0 _kpllochbildrechts_))
   
   	(setq abtl_Lchb (Traeger.get Trg ABTeil lchbKpl))
	(Anbauteil.set abtl_Lchb (Master 1))
   	
    (print dp)
    (TrEnde.set TrgEnde (delta_l 0)) 
    (TrEnde.pTrim TrgEnde dp)
    (print "<---------------------------------------------------------")
	
	
			 (setq Radius (Blech.get blKopfpl aRadius))
		 (Lochbild.set lchbKpl (LB_Art 4))
		 (Lochbild.set lchbKpl 
			(w0 (- (* 2 blRadius) (* 3 d_schraube)))
		 )

		 (Lochbild.set lchbKpl (Anz_S 3))
		 (if (> Radius  60)  (Lochbild.set lchbKpl (Anz_S 4)))
		 (if (> Radius 120)  (Lochbild.set lchbKpl (Anz_S 5)))
		 (if (> Radius 180)  (Lochbild.set lchbKpl (Anz_S 6)))
		 (if (> Radius 240)  (Lochbild.set lchbKpl (Anz_S 7)))

)
; ---------------------------------------------------------------------- 
(defun addRadialFahnenBlech (Radius_Bl Schrb_Anz)

	(setq h_AT (Traeger.get Tr_ID h))
	(setq bp_RadFaBl (- Radius_Bl (* 0.5 h_AT)))

	(setq bp_RadFaBl (runde bp_RadFaBl ab 5))
		
	(print bp_RadFaBl)
	(print Radius_Bl)
	(print h_AT)
	
	(setq 	blRadFahne (Blech.create))
	(Blech.set blRadFahne 
			(hp (* 2 bp_RadFaBl))
			(bp bp_RadFaBl)
			(dp	12)
	)

	(if (= (Connect.get CastaData LinkesEnde) 1) (progn
			(setq XPos 0  dOK_Fakt 1)
			(setq TrgEnde (Traeger.get Tr_ID links))
			(setq dle_Offset (TrEnde.get TrgEnde delta_L))
	))
	(if (= (Connect.get CastaData RechtesEnde) 1) (progn
			(setq XPos (Traeger.get Tr_ID SysLng) dOK_Fakt -1)
			(setq TrgEnde (Traeger.get Tr_ID rechts))
			(setq dle_Offset (TrEnde.get TrgEnde delta_L))
	))

		
	(setq StartWinkel (* 0.5 (/ 360.0 Schrb_Anz)))
	(traeger.addabtl Tr_ID blRadFahne XPos 0.0  _radial_fahnenblech_)
		
	(setq abtl_RadBl (Traeger.get Tr_ID ABTeil blRadFahne blech))
	(Anbauteil.set abtl_RadBl (Anz Schrb_Anz) (Winkel StartWinkel))


	(setq hp_Bl (Blech.get blRadFahne hp))
	(if (= dOK_Fakt -1) (progn
			(Blech.set blRadFahne (dOK (- (* -0.5 hp_Bl) dle_Offset)))
			(Blech.set blRadFahne (x3 (* 0.5 bp_RadFaBl)) (y3 (* 1.4 bp_RadFaBl)))
	))
	(if (= dOK_Fakt  1) (progn
			(Blech.set blRadFahne (dOK (+ (*  0.5 hp_Bl) dle_Offset)))
			(Blech.set blRadFahne (x2 (* 0.5 bp_RadFaBl)) (y2 (* 1.4 bp_RadFaBl)))
	))
	(Connect.storeAnschlObjs CastaData blRadFahne)
)