; ----------------------------------------------------------------------------------------
; Berechnet die Abstnde, die beim Anschluss der Trger entstehen, wenn der AT und/oder 
; der HT seitlich verschoben werden. 
;
; Dazu gehren:
; -------------
;	diff_innen:			Abstand zwischen beiden Innenkanten
;	diff_r:					Abstand zwischen rechtem AT-Steg und Ht-Flansch
; diff_l:					Abstand zwischen linkem AT-Steg und Ht-Flansch
; diff_hts_atf_r	Abstand zwischen rechtem HT-Steg und At-Flansch
; diff_hts_atf_l	Abstand zwischen linkem HT-Steg und At-Flansch
;
;	BEMERKUNG:
; gilt Momentan nur, wenn der UZ mit dem Oberflansch nach oben liegt.
; ----------------------------------------------------------------------------------------
(defun calcUzStzFlanschAbst ()
	(print "------------------------------------------------------------")
	(print "BERECHNEN ABSTNDE FR UZ_STZ_FLANSCH")
	(print "------------------------------------------------------------")
	(setq b_ht				(Traeger.get Htrg b)
				t_ht				(Traeger.get Htrg t)
				s_ht				(Traeger.get Htrg s)
				r_ht				(Traeger.get Htrg r)
				delta_lr_ht	(Traeger.get Htrg delta_lr)
	)
	
	(setq b_at				(Traeger.get Tr_ID b)
				s_at				(Traeger.get Tr_ID s)
				delta_lr_at	(Traeger.get Tr_ID delta_lr)
	)
	
	
	; Linke und rechte Seite werden intern fest definiert.
	; Blickrichtung vom HT-Flansch zum UZ
	; ----------------------------------------------------
	
	; Ist der AT an der linken Seite angeschlossen...
	
	; Flanschkanten des AT
	(setq atFKante_r	(+ delta_lr_at (* 0.5 b_at)))
	(setq atFKante_l	(- atFKante_r b_at))
	
	; Stegkanten des AT
	(setq atSKante_r	(+ delta_lr_at (* 0.5 s_at)))
	(setq atSKante_l	(- atSKante_r s_at))
	
	; Ist der AT an der rechten Seite angeschlossen werden die Seiten getauscht.
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(progn
			(setq temp_atfr atFKante_r)
			(setq temp_atfl atFKante_l)
			(setq temp_atsr atSKante_r)
			(setq temp_atsl atSKante_l)
			
			(setq atFKante_r (- temp_atfl))
			(setq atFKante_l (- temp_atfr))
			(setq atSKante_r (- temp_atsl))
			(setq atSKante_l (- temp_atsr))
		)
	)
	
	(print atFKante_r)
	(print atFKante_l)
	(print atSKante_r)
	(print atSKante_l)
	
	(print "------------------------------------------------------------")
	
	; Flanschkanten des HT
	(setq htFKante_r	(+ delta_lr_ht (* 0.5 b_ht)))
	(setq htFKante_l	(- htFKante_r b_ht))
	
	; Innenkanten des HT
	(setq htIKante_r	(+ delta_lr_ht (* 0.5 s_ht) r_ht))
	(setq htIKante_l	(- htIKante_r s_ht (* 2.0 r_ht)))
		
	(setq temp_htfr htFKante_r)
	(setq temp_htfl htFKante_l)
	(setq temp_htir htIKante_r)
	(setq temp_htil htIKante_l)
					
	(setq htFKante_r (- temp_htfl))
	(setq htFKante_l (- temp_htfr))
	(setq htIKante_r (- temp_htil))
	(setq htIKante_l (- temp_htir))
				
	
	
	(print htFKante_r)
	(print htFKante_l)
	(print htIKante_r)
	(print htIKante_l)
	
	
	
	; diff_innen
	; -----------
	(if (>= atSKante_l htIKante_r)
		(progn
			(setq diff_innen	(- atSKante_l htIKante_r))
		)
		(progn
			(if (<= atSKante_r htIKante_l)
				(setq diff_innen	(- atSKante_r htIKante_l))
				(setq diff_innen	0)
			)
		)
	)
	
	
	(if (< diff_innen 0.0)
		(setq diff_innen (- diff_innen))
	)
	(print diff_innen)
	
	
	; diff_r
	; -------
	(setq diff_r (- htFKante_r atSKante_r))
	(if (< diff_r 0.0)
		(setq diff_r 0)
	)
	(print diff_r)
	
	
	; diff_l
	; -------
	(setq diff_l (- htFKante_l atSKante_l))
	(if (< diff_l 0.0)
		(setq diff_l (- diff_l))
		(setq diff_l 0)
	)
	(print diff_l)
	
	
	; diff_hts_atf_r
	; ---------------
	(setq diff_hts_atf_r (- atFKante_r htIKante_r))
	(if (< diff_hts_atf_r 0.0)
		(setq diff_hts_atf_r 0)
	)
	(print diff_hts_atf_r)
	
	
	; diff_hts_atf_l
	; ---------------
	(setq diff_hts_atf_l (- atFKante_l htIKante_l))
	(if (< diff_hts_atf_l 0.0)
		(setq diff_hts_atf_l (- diff_hts_atf_l))
		(setq diff_hts_atf_l 0)
	)
	(print diff_hts_atf_r)
	
	(print "------------------------------------------------------------")
	
	
)

; ----------------------------------------------------------------------------------------
; Berechnet die Lochbilddaten fr den Anschluss am Flansch
; ----------------------------------------------------------------------------------------
(defun calcFlanschLochbildDaten (Lochb_ID KPL_ID)
	(print "------------------------------------------------------------")
	(print "BERECHNE LOCHBILDDATEN")
	(Lochbild.set Lochb_ID (Guete   "4.6"))
	
	(setq		h_trg 		(Traeger.get Tr_ID h)
			s_trg 		(Traeger.get Tr_ID s)
			delta_lr_at	(Traeger.get Tr_ID delta_lr)
	)
	
	(setq		t_htrg 		(Traeger.get Htrg t)
			s_htrg		(Traeger.get Htrg s)
			r_htrg		(Traeger.get Htrg r)
			delta_l_ht	(Traeger.get Htrg delta_l)
			delta_lr_ht	(Traeger.get Htrg delta_lr)
	)
	
	(setq 		akt_hp 		(Blech.get KPL_ID hp)
			akt_dok		(Blech.get KPL_ID dok)
			dp_kpl		(Blech.get KPL_ID dp)
	)
	
	(if (= (Connect.get CastaData linkesEnde) 1)
		(setq 	AT_Ende 	(Traeger.get Tr_ID links))
	)
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(setq 	AT_Ende 	(Traeger.get Tr_ID rechts))
	)
	
	(setq vscherl_at (TrEnde.get At_Ende vscherl))
	
	(setq afl_vwinkel	(Connect.get CastaData afl_vwinkel))
	(print afl_vwinkel)
	(setq at_winkel (- 180.0 afl_vwinkel))
	(print at_winkel)
	(setq tanW (tan (/ (* PI at_winkel) 180.0)))
	(print tanW)
	(setq anteil_neigung_at (/ (* 1.0 dp_kpl) tanW))
	(print anteil_neigung_at)
	(setq h_trg_halb	(* h_trg 0.5))
	
	(print dp_kpl)
	(print t_htrg)
	
	(if (<= dp_kpl t_htrg)
		(setq minBlech dp_kpl)
		(setq minBlech t_htrg)
	)
	(print minBlech)
	(calcSchraube minBlech) ; -> S_Bez
	
	(Lochbild.set Lochb_ID (S_Bez S_Bez))
	
	; Den entsprechenden Durchmesser holen
	(setq d_schr (Lochbild.get Lochb_ID sdurchm))
	
	(setq e_rand (* d_schr 2.0))				; Randabstand
	(setq e_loch (* d_schr 4.0))			; Lochabstand
	
	(setq e_rand_rund (runde e_rand auf 5))
	(setq e_loch_rund (runde e_loch auf 5))
	
	(setq min_hp (+ e_loch_rund (* e_rand_rund 2.0))) ; min. Kopfplattenhhe aus Lochbild
	
	
	
	(if (> akt_hp min_hp)
		(progn
			(if (= (Connect.get CastaData vatr-lhtr) -1) (setq e0 (+ (* akt_hp 0.25) akt_dok anteil_neigung_at)))
			(if (= (Connect.get CastaData vatr-lhtr)  1) (setq e0 (+ (* akt_hp 0.25) akt_dok (- anteil_neigung_at))))	
			(if (= (Connect.get CastaData satr-lhtr) -1) (setq e0 (+ (* akt_hp 0.25) akt_dok anteil_neigung_at)))
			(if (= (Connect.get CastaData satr-lhtr)  1) (setq e0 (+ (* akt_hp 0.25) akt_dok (- anteil_neigung_at))))	
			(print e0)
			(setq e0rund (runde e0 auf 5))					(print e0rund)
			(setq e1 (* akt_hp 0.5))
			(setq e1rund (runde e1 auf 5))
			
			(Lochbild.set Lochb_ID 	(e0 e0rund)
															(e1 e1rund)
			)
		)
		(progn
			(Lochbild.set Lochb_ID (Anz_S 2))
			(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq e0 (+ (* 0.5 vscherl_at) anteil_neigung_at)))
			(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq e0 (+ (* 0.5 vscherl_at) (- anteil_neigung_at))))
			(if (= (Connect.get CastaData satr-lhtr) -1)	(setq e0 (+ (* 0.5 vscherl_at) anteil_neigung_at)))
			(if (= (Connect.get CastaData satr-lhtr)  1)	(setq e0 (+ (* 0.5 vscherl_at) (- anteil_neigung_at))))
			(setq e0rund (runde e0 auf 5))
			
			(Lochbild.set Lochb_ID 	(e0 e0rund)
															(e1 0)
			)
		)		
	)
	
	(if (= LB_DEBUG 1)
		(progn
			(if (> akt_hp min_hp)
				(Lochbild.set Lochb_ID 	(e2 400))
				(Lochbild.set Lochb_ID 	(e1 400))
			)
		)
	)
	
	
	
	; Anteil delta_lr Verschiebung 
	(print delta_lr_ht)
	(print delta_lr_at)
	
	(if (= (Connect.get CastaData satr-shtr)  1)	(setq anteil_dlr (- delta_lr_ht delta_lr_at)))
	(if (= (Connect.get CastaData satr-shtr) -1)	(setq anteil_dlr (+ delta_lr_ht delta_lr_at)))
	(if (= (Connect.get CastaData vatr-shtr)  1)	(setq anteil_dlr (- delta_lr_ht delta_lr_at)))
	(if (= (Connect.get CastaData vatr-shtr) -1)	(setq anteil_dlr (+ delta_lr_ht delta_lr_at)))
	
	(if (< anteil_dlr 0.0)
		(setq anteil_dlr (- anteil_dlr))
	)
	(print anteil_dlr)
	
	(setq min_e_aus_stz (+ s_htrg (* 2.0 r_htrg) d_schr))
	(print min_e_aus_stz)
	(print e_loch_rund)
	
	(if (>= e_loch_rund min_e_aus_stz)	
		(setq w0 (+ e_loch_rund anteil_dlr))
		(setq w0 (+ min_e_aus_stz anteil_dlr))
	)
	(setq w0 (runde w0 auf 5))
	
		
	(print w0)
	
	;(Lochbild.set Lchb_ID (w0 e1_blech_rund))
	(Lochbild.set Lochb_ID (w0 w0))
	
		
	(setq delta_w_lb (- (* 0.5 delta_lr_at)))
	
	; STTZENORIENTIERUNG ermitteln (oben->unten/unten->oben)
	(setq vWinkel_stz (Connect.get CastaData hpttrg_vwinkel))
	(print vWinkel_stz)
	
	
	
	(if (= (Connect.get CastaData vatr-lhtr) -1)
		(setq untenoben 1)
		(setq untenoben 0)
	)
		
	(print untenoben)
	
	(if (= untenoben 1)
		(progn
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(progn
					(if (= (Connect.get CastaData amHtOberflansch) 1)	(setq delta_w_lb (+ delta_w_lb (* 0.5 delta_lr_ht))))
					(if (= (Connect.get CastaData amHtUnterflansch) 1)	(setq delta_w_lb (- delta_w_lb (* 0.5 delta_lr_ht))))
				)
			)
			(if (= (Connect.get CastaData linkesEnde) 1)
				(progn
					(if (= (Connect.get CastaData amHtOberflansch) 1)	(setq delta_w_lb (- delta_w_lb (* 0.5 delta_lr_ht))))
					(if (= (Connect.get CastaData amHtUnterflansch) 1)	(setq delta_w_lb (+ delta_w_lb (* 0.5 delta_lr_ht))))
				)
			)
		)
	)
	(if (= untenoben 0)
		(progn
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(progn
					(if (= (Connect.get CastaData amHtOberflansch) 1)	(setq delta_w_lb (- delta_w_lb (* 0.5 delta_lr_ht))))
					(if (= (Connect.get CastaData amHtUnterflansch) 1)	(setq delta_w_lb (+ delta_w_lb (* 0.5 delta_lr_ht))))
				)
			)
			(if (= (Connect.get CastaData linkesEnde) 1)
				(progn
					(if (= (Connect.get CastaData amHtOberflansch) 1)	(setq delta_w_lb (+ delta_w_lb (* 0.5 delta_lr_ht))))
					(if (= (Connect.get CastaData amHtUnterflansch) 1)	(setq delta_w_lb (- delta_w_lb (* 0.5 delta_lr_ht))))
				)
			)
		)
	)

	(print delta_w_lb)
	
	(Lochbild.set Lochb_ID 	(klemml 	(+ t_htrg dp_kpl))
			      	(dxSKopf 	 dp_kpl)
			  ;	(delta_w	 delta_w_lb) 											
	)
		
	
	(print "ENDE LOCHBILDDATEN")
	(print "------------------------------------------------------------")
)


; ----------------------------------------------------------------------------------------
; Passt die Kopfplatte an die Daten des Lochbildes an
; ----------------------------------------------------------------------------------------
(defun korrigiereKpl (KPL_ID LOCHB_ID)
	(print "------------------------------------------------------------")
	(print "KORRIGIERE KOPFPLATTE")
	(print "------------------------------------------------------------")
	(setq lb_w		(Lochbild.get LOCHB_ID w0)
				d_schr 	(Lochbild.get LOCHB_ID sdurchm)
	)
	
	(setq delta_lr_at	(Traeger.get Tr_ID delta_lr)
				qsform_at		(Traeger.get Tr_ID qsform)
				b_at				(Traeger.get Tr_ID b)
	)
	
	(setq delta_lr_ht	(Traeger.get Htrg delta_lr))
	
	
	; neue Blechbreite
	(setq e_rand (* d_schr 2.0))			; Randabstand
	(setq e_loch (* d_schr 4.0))			; Lochabstand
	
	(setq e_rand_rund (runde e_rand auf 5))
	
	(setq bp_kpl (+ (* 2.0 e_rand_rund) lb_w))
	
	
	
	; delta_lr Verschiebung
	(print delta_lr_at)
	(setq delta_lr_kpl (- (* 0.5 delta_lr_at)))
	
	; STTZENORIENTIERUNG ermitteln (oben->unten/unten->oben)
	(setq vWinkel_stz (Connect.get CastaData hpttrg_vwinkel))
	(print vWinkel_stz)
	
	
	(if (= (Connect.get CastaData vatr-lhtr) -1)
		(setq untenoben 1)
		(setq untenoben 0)
	)
	
	(print untenoben)
	
	(if (= untenoben 1)
		(progn
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(progn
					(if (= (Connect.get CastaData amHtOberflansch) 1)	(setq delta_lr_kpl (+ delta_lr_kpl (* 0.5 delta_lr_ht))))
					(if (= (Connect.get CastaData amHtUnterflansch) 1)	(setq delta_lr_kpl (- delta_lr_kpl (* 0.5 delta_lr_ht))))
				)
			)
			(if (= (Connect.get CastaData linkesEnde) 1)
				(progn
					(if (= (Connect.get CastaData amHtOberflansch) 1)	(setq delta_lr_kpl (- delta_lr_kpl (* 0.5 delta_lr_ht))))
					(if (= (Connect.get CastaData amHtUnterflansch) 1)	(setq delta_lr_kpl (+ delta_lr_kpl (* 0.5 delta_lr_ht))))
				)
			)
		)
	)
	(if (= untenoben 0)
		(progn
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(progn
					(if (= (Connect.get CastaData amHtOberflansch) 1)	(setq delta_lr_kpl (- delta_lr_kpl (* 0.5 delta_lr_ht))))
					(if (= (Connect.get CastaData amHtUnterflansch) 1)	(setq delta_lr_kpl (+ delta_lr_kpl (* 0.5 delta_lr_ht))))
				)
			)
			(if (= (Connect.get CastaData linkesEnde) 1)
				(progn
					(if (= (Connect.get CastaData amHtOberflansch) 1)	(setq delta_lr_kpl (+ delta_lr_kpl (* 0.5 delta_lr_ht))))
					(if (= (Connect.get CastaData amHtUnterflansch) 1)	(setq delta_lr_kpl (- delta_lr_kpl (* 0.5 delta_lr_ht))))
				)
			)
		)
	)
	
	;(if (= qsform_at "U")
	;	(setq bp_kpl (* 2.0 bp_kpl))
	;)
	
	(Blech.set KPL_ID 	(bp 	bp_kpl)
											;(delta_lr delta_lr_kpl)
	)
	(print "------------------------------------------------------------")
)

; ----------------------------------------------------------------------------------------
; BERECHNUNG DER KOPFPLATTENDATEN
; ----------------------------------------------------------------------------------------
(defun calcAndSetBlechdaten (blKopfplatte TrgEnde)
	(print "------------------------------------------------------------")
	(print "BERECHNE BLECHDATEN")
	(print "------------------------------------------------------------")
  

  (setq hProf 		(Traeger.get Tr_ID h)
  	delta_lr_at	(Traeger.get Tr_ID delta_lr)
  	t_at		(Traeger.get Tr_ID t)
  )
  (setq t_ht		(Traeger.get Htrg	t))
  (setq t_at_rund	(runde t_at auf 10))
	
  (setq hp hProf)		; erstmal so voreinstellen
  (setq QsTyp (Traeger.get Tr_ID qsForm))
  (if (= QsTyp "F") (setq hp (Traeger.get Tr_ID t)))
  (setq bp 120)
  (setq dp  t_at_rund)
  (setq dOK  5)

  (setq EWinkel (TrEnde.get TrgEnde V_Winkel))
  (print EWinkel)
  
  (setq sinW (sin (* PI (/ EWinkel 180.0))))
  (if (/= sinW 0) (setq hp (/ hp sinW)))

  (setq hp (- hp dOK 5))	; wir erzeugen eine bndige Kopfplatte
  (setq hp (runde hp auf 5))      

  (if (= QsTyp "F") (progn
      (setq hp  120)
      (setq dOK (- (* 0.5 hp)))
  ))

	
  (Blech.set blKopfplatte	(dp dp) 
				(hp hp) 
				(bp bp) 
				(dOK dOK)
  )

  (setq htDeltaV (Traeger.get hTrg delta_V))

  (setq delta_L dp)
  (if (> vwnkl_aflch 180) (setq delta_L (- delta_L)))
  (print delta_L)
    		
  (TrEnde.pTrim TrgEnde dp)
  
	(print "------------------------------------------------------------")
)


; ----------------------------------------------------------------------------------------
; Schraubendurchmesser ermitteln
; ----------------------------------------------------------------------------------------
(defun calcSchraube (t_blech)
		
	; grobe Anhaltswerte fr Schraubenschaftdurchmesser
	(if (> t_blech 0.0)
		(setq S_Bez "M12")
	)
	(if (>= t_blech 6.0)
		(setq S_Bez "M16")
	)
	(if (>= t_blech 10.0)
		(setq S_Bez "M20")
	)
	(if (>= t_blech 15.0)
		(setq S_Bez "M24")
	)
	(if (>= t_blech 18.0)
		(setq S_Bez "M27")
	)
	(if (>= t_blech 21.0)
		(setq S_Bez "M30")
	)
	(if (>= t_blech 24.0)
		(setq S_Bez "M36")
	)
	
)

