; ----------------------------------------------------------------------------------------
; whlt die Schraube in Abhngigkeit von der Traegerhoehe 
; ----------------------------------------------------------------------------------------
(defun set_S_Bez (Trg Lchb_ID)
	(setq h_trg (Traeger.get Trg h))
	; Schaube anhand der Anschlusstrgerhhe auswhlen
	(if (< h_trg 300)
		(setq S_Bez "M16")
		(setq S_Bez "M20")
	)
	
	(Lochbild.set Lchb_ID (S_Bez S_Bez))
)

; ----------------------------------------------------------------------------------------
; Schraubendurchmesser ermitteln (in Abhngigkeit der min. Blechdicke)
; ----------------------------------------------------------------------------------------
(defun calcSchraube (t_blech)
		
	; grobe Anhaltswerte fr Schraubenschaftdurchmesser
	(if (> t_blech 0.0)
		(setq S_Bez "M12")
	)
	(if (> t_blech 6.0)
		(setq S_Bez "M16")
	)
	(if (> t_blech 10.0)
		(setq S_Bez "M20")
	)
	(if (> t_blech 15.0)
		(setq S_Bez "M24")
	)
	(if (> t_blech 18.0)
		(setq S_Bez "M27")
	)
	(if (> t_blech 21.0)
		(setq S_Bez "M30")
	)
	(if (> t_blech 24.0)
		(setq S_Bez "M36")
	)
)

; ----------------------------------------------------------------------------------------
; Berechnet die minimalen Loch- und Randabstnde
; ----------------------------------------------------------------------------------------
(defun calcMinRandLochAbst (Lchb_ID)
	; Den entsprechenden Durchmesser holen
	(setq d_schr (Lochbild.get Lchb_ID sdurchm))
	
	; Standardwerte
	(setq e_min (* 2.0 d_schr))				; Randabstand
	(setq e1_min (* 4.0 d_schr))			; Lochabstand
	
	; TEST
	; ++++++++++++++++++++++++++++++++++++++++++++++
	;(setq e_min (* 1.5 d_schr))				; Randabstand
	;(setq e1_min (* 3.0 d_schr))			; Lochabstand
	; ++++++++++++++++++++++++++++++++++++++++++++++
	
	; gerundet
	(setq e_min_rund (runde e_min auf 5.0))
	(setq e1_min_rund (runde e1_min auf 5.0))
	
	(setq min_h (+ e1_min_rund (* 2.0 e_min_rund))) ; min. Blechhhe aus Lochbild
	
)


; ----------------------------------------------------------------------------------------
; Berechnet die Schraubenanzahl
; ----------------------------------------------------------------------------------------
(defun calc_Anz_Schr (Lchb_ID Trg)
	
	(setq hc_trg (Traeger.get Trg hc))
	(print hc_trg)
	(calcMinRandLochAbst Lchb_ID)
	
	
	(if (> min_h hc_trg)
		(progn
			(print "2 Schrauben")
			(setq ANZ_SCHR 2)
		)
		(progn
			(print "4 Schrauben")
			(setq ANZ_SCHR 4)
		)
	)
	
	; Bei Ksten und Rohren unterscheiden
	(setq qsform_trg (Traeger.get Trg qsform))
	(if (= qsform_trg "K")
		(setq ANZ_SCHR 4)
	)
)

