
; VORLUFIGE VERSION

(defun checkEnv ()
	; Bereichsgrenzen fr HT-XPositionen aus AT-Lage bestimmen
	; ----------------------------------------------------------------
	(print "BERPRFE ANSCHLUSSUMGEBUNG")
	(setq xPos_ht (Connect.get CastaData xPos_ht))
			
	(setq h_at				(Traeger.get Tr_ID h)
				delta_v_at	(Traeger.get Tr_ID delta_v)
	)
			
	(if (= (Connect.get CastaData LinkesEnde) 1)
		(setq AT_Ende (Traeger.get Tr_ID links))
	)
	(if (= (Connect.get CastaData RechtesEnde) 1)
		(setq AT_Ende (Traeger.get Tr_ID rechts))
	)
			
	(setq h_at_halb (* 0.5 h_at))
			
	(if (/= (Connect.get CastaData vatr-lhtr)  0) (progn
		(if (= (Connect.get CastaData vatr-lhtr)  1) (progn
			(setq pos1 (+ (- xPos_ht h_at_halb) delta_v_at))
			(setq pos2 (+ pos1 h_at))
		))
		(if (= (Connect.get CastaData vatr-lhtr) -1) (progn
			(setq pos1 (- (- xPos_ht h_at_halb) delta_v_at))
			(setq pos2 (+ pos1 h_at))
		))
		(print xPos_ht)
		(print pos1)
		(print pos2)
				
		; Toleranzbereich
		; ----------------------------------------------------------------
		(setq tol 50)
				
		(getAllXPositionsAmHT pos1 pos2 tol) ; -> xPos1-xPos5 (je nachdem wieviele), anzahlAnbauteile
				
		; -> diff, xPosM1, xPosM2, massgebendeAnzahl
		(if (> anzahlAnbauteile 0)
			(progn 
				(if (= anzahlAnbauteile 1) (getMassgebXPos1 xPos1)) 
				(if (= anzahlAnbauteile 2) (getMassgebXPos2 xPos1 xPos2)) 
				(if (= anzahlAnbauteile 3) (getMassgebXPos3 xPos1 xPos2 xPos3)) 
				(if (= anzahlAnbauteile 4) (getMassgebXPos4 xPos1 xPos2 xPos3 xPos4)) 
				(if (= anzahlAnbauteile 5) (getMassgebXPos5 xPos1 xPos2 xPos3 xPos4 xPos5)) 
				
				(print "vor Ausklinkung")
				(print massgebendeAnzahl)
				(print xPosM1)
				(print xPosM2)
				(calcAusklinkungTrg AT_Ende xPosM1 xPosM2 massgebendeAnzahl)
			)
		) 
	))
)

; ----------------------------------------------------------------------------------------
; berprft auf Steifen in einem Bereich mit best. Toleranzbereich
; ----------------------------------------------------------------------------------------
(defun checkForSteifeAtEnv (P_1 P_2 ENV)
	(print "berprfung auf Steife")
	;(setq ENV 50)
	
	(setq anzStf (Traeger.get Htrg getAnzStf vertikalsteife (- P_1 ENV) (+ P_2 ENV)))
	(print anzStf)
	
	(if (> anzStf 0)
		(setq STF_VORH 1)
		(setq STF_VORH 0)
	)
	
	(print STF_VORH)
)


; ----------------------------------------------------------------------------------------
; berprft auf Kopfplatte in einem Bereich mit best. Toleranzbereich
; ----------------------------------------------------------------------------------------
(defun checkForKplAtEnv (P_1 P_2 ENV)
	(print "berprfung auf Kopfplatte")
	;(setq ENV 50)
	
	(setq abtlKpl (Traeger.get Htrg firstAbtl kopfplatte (- P_1 ENV) (+ P_2 ENV)))
	(print abtlKpl)
	
	(if abtlKpl
		(setq KPL_VORH 1)
		(setq KPL_VORH 0)
	)
	
	(print KPL_VORH)
)

; ----------------------------------------------------------------------------------------
; Ermittelt die Anzahl aller Anbauteile in dem Bereich von (- P_1 ENV) bis (+ P_2 ENV)
; ---------------------------------------------------------------------------------------- 
(defun getAnzahlAbtl (P_1 P_2 ENV)
	(print "ANZAHL DER ANBAUTEILE ERMITTELN")
	
	; Prfen, ob eine Kopfplatte vorhanden ist
	(checkForKplAtEnv P_1 P_2 ENV) ; -> KPL_VORH
	
	; Prfen, ob Steifen vorhanden sind
	(checkForSteifeAtEnv P_1 P_2 ENV) ; -> STF_VORH
	
	(setq anzahlAnbauteile 0)
		
	(if (= STF_VORH 1)
		(progn
			(setq anzSteifen (Traeger.get Htrg getAnzStf vertikalsteife (- P_1 ENV) (+ P_2 ENV)))
			(print anzSteifen)
			
			(setq anzahlAnbauteile anzSteifen)
		)
	)
	
	(if (= KPL_VORH 1)
		(progn
			(setq anzahlAnbauteile (+ anzahlAnbauteile 1))
		)
	)
	
	(print "-FINALLY-----------------------------")
	(print anzahlAnbauteile)
)


; ----------------------------------------------------------------------------------------
; Ermittelt die Anzahl der Steifen in dem Bereich von (- P_1 ENV) bis (+ P_2 ENV)
; ---------------------------------------------------------------------------------------- 
(defun getAnzahlSteifen (P_1 P_2 ENV)
	(print "ANZAHL DER STEIFEN ERMITTELN")
	
	; Prfen, ob Steifen vorhanden sind
	(checkForSteifeAtEnv P_1 P_2 ENV) ; -> STF_VORH
	
	(setq anzahlSteifen 0)
		
	(if (= STF_VORH 1)
		(progn
			(setq anzSteifen (Traeger.get Htrg getAnzStf vertikalsteife (- P_1 ENV) (+ P_2 ENV)))
			(print anzSteifen)
			
			(setq anzahlSteifen anzSteifen)
		)
	)
	
	
	(print "-FINALLY-----------------------------")
	(print anzahlSteifen)
)

; ----------------------------------------------------------------------------------------
; Ermittelt die xPositionen vorhandener Anbauteile in einem Bereich von P_1 bis P_2 
; plus Toleranzbereich (ENV).
; P_1 gilt immer vom linken Trgerende.
;
; Max. 5 Positionen
; ----------------------------------------------------------------------------------------
(defun getAllXPositionsAmHT (P_1 P_2 ENV)
	(print "ERMITTLUNG DER X-POSITIONEN")
	
	; Anzahl der Steifen ermitteln	
	(getAnzahlSteifen P_1 P_2 ENV) ; -> anzahlSteifen
	
	; Prfen, ob eine Kopfplatte vorhanden ist
	(checkForKplAtEnv P_1 P_2 ENV) ; -> KPL_VORH
		
	(setq counter 0)
		
	(Traeger.sortabtl Htrg)
	
	(if (> anzahlSteifen 0)
		(progn
			(setq abtl_stf (Traeger.get Htrg firstAbtl vertikalsteife (- P_1 ENV) (+ P_2 ENV)))
			
			; EINE STEIFE							
			(if (= anzahlSteifen 1)
				(progn
					(setq counter 1)				
					(setq abtl_stf (Traeger.get Htrg firstAbtl vertikalsteife (- P_1 ENV) (+ P_2 ENV)))
					
					(while abtl_stf
						(if abtl_stf
							(progn
								(setq xPos1 (Anbauteil.get abtl_stf xPos))
							)
						)
						(setq abtl_stf (Traeger.get Htrg nextAbtl vertikalsteife))
						
					)
				)
			)
			
			; ZWEI STEIFEN							
			(if (= anzahlSteifen 2)
				(progn
					(setq counter 2)				
					(setq abtl_stf (Traeger.get Htrg firstAbtl vertikalsteife (- P_1 ENV) (+ P_2 ENV)))
					(setq z 0)
					(while abtl_stf
						(if abtl_stf
							(progn
								(if (= z 0)	(setq xPos1 (Anbauteil.get abtl_stf xPos)))
								(if (= z 1)	(setq xPos2 (Anbauteil.get abtl_stf xPos)))
							)
						)
						(setq abtl_stf (Traeger.get Htrg nextAbtl vertikalsteife))
						(setq z (+ z 1))
					)
				)
			)
			
			; DREI STEIFEN							
			(if (= anzahlSteifen 3)
				(progn
					(setq counter 3)
					(setq abtl_stf (Traeger.get Htrg firstAbtl vertikalsteife (- P_1 ENV) (+ P_2 ENV)))
					(setq z 0)
					(while abtl_stf
						(if abtl_stf
							(progn
								(if (= z 0)	(setq xPos1 (Anbauteil.get abtl_stf xPos)))
								(if (= z 1)	(setq xPos2 (Anbauteil.get abtl_stf xPos)))
								(if (= z 2)	(setq xPos3 (Anbauteil.get abtl_stf xPos)))
							)
						)
						(setq abtl_stf (Traeger.get Htrg nextAbtl vertikalsteife))
						(setq z (+ z 1))
					)
				)
			)
			
			; VIER STEIFEN							
			(if (= anzahlSteifen 4)
				(progn
					(setq counter 4)				
					(setq abtl_stf (Traeger.get Htrg firstAbtl vertikalsteife (- P_1 ENV) (+ P_2 ENV)))
					(setq z 0)
					(while abtl_stf
						(if abtl_stf
							(progn
								(if (= z 0)	(setq xPos1 (Anbauteil.get abtl_stf xPos)))
								(if (= z 1)	(setq xPos2 (Anbauteil.get abtl_stf xPos)))
								(if (= z 2)	(setq xPos3 (Anbauteil.get abtl_stf xPos)))
								(if (= z 3)	(setq xPos4 (Anbauteil.get abtl_stf xPos)))
							)
						)
						(setq abtl_stf (Traeger.get Htrg nextAbtl vertikalsteife))
						(setq z (+ z 1))
					)
				)
			)
			
			; MEHR ALS VIER STEIFEN							
			(if (> anzahlSteifen 4)
				(progn
					(alertBox "Mehr als vier Steifen werden bei der automatischen Berechnung nicht bercksichtigt."  "WRN_MoreThan4Stiff")
				)
			)
			
		)
	)
	
	
	(if (= KPL_VORH 1)
		(progn
			(setq abtl_kpl (Traeger.get Htrg firstAbtl kopfplatte (- P_1 ENV) (+ P_2 ENV)))
		  (if abtl_kpl 
		  	(progn
			  	(if (= (Connect.get CastaData vatr-lhtr) -1)
			  		(progn
				  		(if (= anzahlSteifen 0)	(setq xPos1 (Anbauteil.get abtl_kpl xPos)))
				  		(if (= anzahlSteifen 1)	(setq xPos2 (Anbauteil.get abtl_kpl xPos)))
				  		(if (= anzahlSteifen 2)	(setq xPos3 (Anbauteil.get abtl_kpl xPos)))
				  		(if (= anzahlSteifen 3)	(setq xPos4 (Anbauteil.get abtl_kpl xPos)))
				  		(if (= anzahlSteifen 4)	(setq xPos5 (Anbauteil.get abtl_kpl xPos)))
				  	)
				  )
		      (if (= (Connect.get CastaData vatr-lhtr)  1)
			  		(progn
			  			(if xPos4 (setq xPos5 xPos4))
			  			(if xPos3 (setq xPos4 xPos3))
			  			(if xPos2 (setq xPos3 xPos2))
			  			(if xPos1 (setq xPos2 xPos1))
			  			(setq xPos1 (Anbauteil.get abtl_kpl xPos))
				  	)
				  )
		      (setq counter (+ counter 1))
		   	)
		  ) 
		)
	)
	
	(setq anzahlAnbauteile counter) 
	
	(print "-FINALLY-----------------------------")
	(if xPos1 (print xPos1))
	(if xPos2 (print xPos2))
	(if xPos3 (print xPos3))
	(if xPos4 (print xPos4))
	(if xPos_kpl (print xPos_kpl))
	(print anzahlAnbauteile)
	
	(print "-------------------------------------")
	;(sortXPos4 xPos1 xPos2 xPos3 xPos_kpl)
	
)

; ----------------------------------------------------------------------------------------
; Ermittelt die zwei magebenden Positionen bei 1 Anbauteilen
;
; IST ABHNGIG VON "getAllXPositionsAmHT" !!!
; ---------------------------------------------------------------------------------------- 
(defun getMassgebXPos1 (p1)
	(print "BERECHNE ABSTAND")
	(setq diff 0)
	(setq xPosM1 p1)
	(setq xPosM2 0)
	(setq massgebendeAnzahl 1)
		
	(print diff)
	(print xPosM1)
	(print xPosM2)
)

; ----------------------------------------------------------------------------------------
; Ermittelt die zwei magebenden Positionen bei 2 Anbauteilen
;
; IST ABHNGIG VON "getAllXPositionsAmHT" !!!
; ---------------------------------------------------------------------------------------- 
(defun getMassgebXPos2 (p1 p2)
	(print "BERECHNE ABSTAND")
	(setq diff (- p2 p1))
	(setq xPosM1 p1)
	(setq xPosM2 p2)
	(setq massgebendeAnzahl 2)
		
	(print diff)
	(print xPosM1)
	(print xPosM2)
)
; ----------------------------------------------------------------------------------------
; Ermittelt die zwei magebenden Positionen bei 3 Anbauteilen
;
; IST ABHNGIG VON "getAllXPositionsAmHT" !!!
; ---------------------------------------------------------------------------------------- 
(defun getMassgebXPos3 (p1 p2 p3)
	(print "BERECHNE ABSTAND")
	(setq diff (- p2 p1))
	(setq xPosM1 p1)
	(setq xPosM2 p2)
	
	(setq tmpDiff (- p3 p2))
	(if (> tmpDiff diff)
		(progn
			(setq diff tmpDiff)
			(setq xPosM1 p2)
			(setq xPosM2 p3)
		)
	)
	
	(setq massgebendeAnzahl 2)
		
	(print diff)
	(print xPosM1)
	(print xPosM2)
)
; ----------------------------------------------------------------------------------------
; Ermittelt die zwei magebenden Positionen bei 4 Anbauteilen
;
; IST ABHNGIG VON "getAllXPositionsAmHT" !!!
; ---------------------------------------------------------------------------------------- 
(defun getMassgebXPos4 (p1 p2 p3 p4)
	(print "BERECHNE ABSTAND")
	(setq diff (- p2 p1))
	(setq xPosM1 p1)
	(setq xPosM2 p2)
	
	(setq tmpDiff (- p3 p2))
	(if (> tmpDiff diff)
		(progn
			(setq diff tmpDiff)
			(setq xPosM1 p2)
			(setq xPosM2 p3)
		)
	)
	
	(setq tmpDiff (- p4 p3))
	(if (> tmpDiff diff)
		(progn
			(setq diff tmpDiff)
			(setq xPosM1 p3)
			(setq xPosM2 p4)
		)
	)
	
	(setq massgebendeAnzahl 2)
	
	(print diff)
	(print xPosM1)
	(print xPosM2)
)
; ----------------------------------------------------------------------------------------
; Ermittelt die zwei magebenden Positionen bei 5 Anbauteilen
;
; IST ABHNGIG VON "getAllXPositionsAmHT" !!!
; ---------------------------------------------------------------------------------------- 
(defun getMassgebXPos5 (p1 p2 p3 p4 p5)
	(print "BERECHNE ABSTAND")
	(setq diff (- p2 p1))
	(setq xPosM1 p1)
	(setq xPosM2 p2)
	
	(setq tmpDiff (- p3 p2))
	(if (> tmpDiff diff)
		(progn
			(setq diff tmpDiff)
			(setq xPosM1 p2)
			(setq xPosM2 p3)
		)
	)
	
	(setq tmpDiff (- p4 p3))
	(if (> tmpDiff diff)
		(progn
			(setq diff tmpDiff)
			(setq xPosM1 p3)
			(setq xPosM2 p4)
		)
	)
	
	(setq tmpDiff (- p5 p4))
	(if (> tmpDiff diff)
		(progn
			(setq diff tmpDiff)
			(setq xPosM1 p4)
			(setq xPosM2 p5)
		)
	)
	
	(setq massgebendeAnzahl 2)
	
	(print diff)
	(print xPosM1)
	(print xPosM2)
)


;----------------------------------------------------------------------- */
; Berechnung der Ausklinkungen des Anschlusstrgers
; ---------------------------------------------------------------------- */
(defun calcAusklinkungTrg (TrgEnde xPos_1 xPos_2 anzAbtl)
	(print "------------------------------------------------------------")
	(print "BERECHNUNG DER AUSKLINKUNGEN DURCH ANBAUTEIL")
	
	(setq h_at 				(Traeger.get Tr_ID h)
			  delta_v_at	(Traeger.get Tr_ID delta_v)
				hc_at				(Traeger.get Tr_ID hc)
				t_at				(Traeger.get Tr_ID t)
				r_at				(Traeger.get Tr_ID r)
	)
	
	(setq t_ht				(Traeger.get Htrg t)
				s_ht				(Traeger.get Htrg s)
				h_ht				(Traeger.get Htrg h)
	)
	
	(setq xPos_ht	(Connect.get CastaData xPos_ht))
	(print xPos_ht)
	
	(setq mittellinie_at 0)
	(if (= (Connect.get CastaData vatr-lhtr) -1) (setq mittellinie_at (- xPos_ht delta_v_at)))
	(if (= (Connect.get CastaData vatr-lhtr)  1) (setq mittellinie_at (+ xPos_ht delta_v_at)))
	(print mittellinie_at)
	
	(if (= (Connect.get CastaData vatr-lhtr) -1)
		(progn
	(setq oGrenze_at (- (+ (* 0.5 h_at) xPos_ht ) delta_v_at))
	(setq uGrenze_at (- xPos_ht (* 0.5 h_at) delta_v_at))
		)
	)
	(if (= (Connect.get CastaData vatr-lhtr)  1)
		(progn
			(setq oGrenze_at (- (+ (* 0.5 h_at) xPos_ht ) delta_v_at))
			(setq uGrenze_at (+ xPos_ht (* 0.5 h_at) delta_v_at))
		)
	)
	(print oGrenze_at)
	(print uGrenze_at)
	
	(print xPos_1)
	(print xPos_2)
	
	(setq diffOben  0)
	(setq diffUnten 0)
	
	(print anzAbtl)	
	; berprfung, wo bei EINEM Anbauteil ausgeklingt werden muss (oben / unten)
	(if (= anzAbtl 1)
		(progn
			(berechneAnteilSchraege xPos_1)	; -> anteil_schraege
			(setq oGrenze_abtl (- xPos_1 anteil_schraege))
			(setq uGrenze_abtl (+ xPos_1 anteil_schraege))
			(print oGrenze_abtl)
			(print uGrenze_abtl)
			
			(if (= (Connect.get CastaData vatr-lhtr) -1)
				(progn
			(if (< oGrenze_abtl oGrenze_at)
				(progn
					
					(if (> xPos_1 mittellinie_at)	
						(progn
							
							(setq diffOben (- oGrenze_abtl oGrenze_at))
							(setq auskl_o_erf 1)
							(setq auskl_u_erf 0)
						)
						(progn
							
							(setq diffUnten (- uGrenze_abtl uGrenze_at))
							(setq auskl_o_erf 0)
							(setq auskl_u_erf 1)
						)
					)
					
					(if (< uGrenze_abtl uGrenze_at)
						(progn
							(setq auskl_o_erf 0)
							(setq auskl_u_erf 0)
						)
					)
				)
				(progn
					(setq auskl_o_erf 0)
					(setq auskl_u_erf 0)
				)
			)
				)
			)
			(if (= (Connect.get CastaData vatr-lhtr)  1)
				(progn
					(if (> oGrenze_abtl oGrenze_at)
						(progn
							
							(if (< xPos_1 mittellinie_at)	
								(progn
									
									(setq diffOben (- oGrenze_abtl oGrenze_at))
									(setq auskl_o_erf 1)
									(setq auskl_u_erf 0)
								)
								(progn
									
									(setq diffUnten (- uGrenze_abtl uGrenze_at))
									(setq auskl_o_erf 0)
									(setq auskl_u_erf 1)
								)
							)
			
							(if (> uGrenze_abtl uGrenze_at)
								(progn
									(setq auskl_o_erf 0)
									(setq auskl_u_erf 0)
								)
							)
						)
						(progn
							(setq auskl_o_erf 0)
							(setq auskl_u_erf 0)
						)
					)
				)
			)
			
		)
	)
	
	; berprfung, wo bei ZWEI Anbauteilen ausgeklingt werden muss (oben / unten)
	(if (= anzAbtl 2)
		(progn			
			(if (= (Connect.get CastaData vatr-lhtr)  1)
				(progn
					(berechneAnteilSchraege xPos_1)	; -> anteil_schraege
					(setq oGrenze_abtl (- xPos_1 anteil_schraege))
					
					(berechneAnteilSchraege xPos_2)	; -> anteil_schraege
					(setq uGrenze_abtl (+ xPos_2 anteil_schraege))
				)
			)
			(if (= (Connect.get CastaData vatr-lhtr) -1)
				(progn
					(berechneAnteilSchraege xPos_2)	; -> anteil_schraege
					(setq oGrenze_abtl (- xPos_2 anteil_schraege))
					
					(berechneAnteilSchraege xPos_1)	; -> anteil_schraege
					(setq uGrenze_abtl (+ xPos_1 anteil_schraege))
				)
			)
			
			(print oGrenze_abtl)
			(print uGrenze_abtl)
				
						 
			(if (<= oGrenze_abtl oGrenze_at)	
				(setq auskl_o_erf 1)
				(setq auskl_o_erf 0)
			)
			
			(if (>= uGrenze_abtl uGrenze_at)	
				(setq auskl_u_erf 1)
				(setq auskl_u_erf 0)
			)			
			
			(if (= (Connect.get CastaData vatr-lhtr) -1)
				(progn
					(setq diffOben (- oGrenze_abtl oGrenze_at))
					(setq diffUnten (- uGrenze_abtl uGrenze_at))
				)
			)
			(if (= (Connect.get CastaData vatr-lhtr)  1)
				(progn
					(setq diffOben (+ oGrenze_abtl oGrenze_at))
					(setq diffUnten (+ uGrenze_abtl uGrenze_at))
				)
			)	
		)
	)
	(print auskl_o_erf)
	(print auskl_u_erf)	
	
	(if (< diffOben 0)	(setq diffOben (- diffOben)))
	(if (< diffUnten 0)	(setq diffUnten (- diffUnten)))
	(print diffOben)
	(print diffUnten)
			
	(setq tolerance (+ (* 0.5 t_ht) 10))
	(print tolerance)
	
	
	
	; AUSKLINKUNGEN
	(if (= auskl_o_erf 1)
		(progn
			(setq maxAuskl (* 0.5 h_at))
				
			(setq zakl (+ diffOben tolerance))
			
			(print maxAuskl)
			(print zakl)
			
			;(if (> zakl maxAuskl)	
				;(progn
					;(alertBox "Das Anbauteil wird vom AT ungnstig geschnitten. Bitte korrigieren Sie ggf. manuell."  "NOTE_AddPartBadCut")
					;(setq zakl 0)
				;)
			;)
						
			(if (= auskl_u_erf 1)
				(progn
					(print "UNTEN und OBEN ist eine Ausklinkung erforderlich")
					(setq maxAuskl (* 0.25 h_at))
					
					(setq hsteg (- h_at (+ zakl (+ diffunten tolerance))))
				)
				(progn
					(print "OBEN ist eine Ausklinkung erforderlich")
					(setq hsteg 0)
				)
			)
		)
		(progn
			(if (= auskl_u_erf 1)
				(progn
					(print "UNTEN ist eine Ausklinkung erforderlich")
					(setq maxAuskl (* 0.5 h_at))
					(setq zakl 0)
					(setq hsteg (- h_at (+ diffUnten tolerance)))
				)
				
				(progn
					(print "es ist KEINE Ausklinkung erforderlich")
					(setq zakl 0)
					(setq hsteg 0)
				)
			)
		)
	)

	(setq xakl_soll (+ (* 0.5 b_ht) 10))
	(print xakl_soll)
	
	;(if xakl
	;	(progn
	;		(if (< xakl xakl_soll)
	;			(setq xakl_soll (- xakl_soll (- xakl_soll xakl)))
	;		)
	;	)
	;)
	
	(if (>= hsteg hc_at)
		(progn
			(setq hsteg hc_at)
			(setq zakl (+ t_at r_at))
		)
	)
	
	(print xakl_soll)		
	(print zakl)
	(print hsteg)
	(print yakl)
	(print bflansch)
	
	(TrEnde.set TrgEnde (zakl 		zakl)
											(hsteg  	hsteg)
											(xakl 		xakl_soll)
											(yakl 		yakl)
											(bflansch	bflansch)	
	)	
  
  (print "------------------------------------------------------------")
)


; Berechnen den Anteil, der zustzlich ausgeklinkt werden muss, wenn schrge Anbauteile vorliegen
(defun berechneAnteilSchraege (abtl_pos)
	(setq ENV 20)
	
	(setq b_at (Traeger.get Tr_ID b))
	(setq b_at_halb (* 0.5 b_at))
	
	(setq KPL_ABTL 0)
	(setq STF_ABTL 0)
	
	(setq abtl (Traeger.get Htrg firstAbtl vertikalsteife (- abtl_pos ENV) (+ abtl_pos ENV)))
	(if abtl
		(progn
			(setq STF_ABTL 1)
		)
		(progn
			(setq abtl (Traeger.get Htrg firstAbtl kopfplatte (- abtl_pos ENV) (+ abtl_pos ENV)))
			(setq KPL_ABTL 1)
		)
	)
	(print abtl)
	
	(if abtl 
		(progn
			(if (= STF_ABTL 1)
				(progn
					(setq abtl_winkel (Anbauteil.get abtl winkel))
					(print abtl_winkel)
					(if (< abtl_winkel 0)
						(setq abtl_winkel (- abtl_winkel))
					)
					(print abtl_winkel)
				)
			)
			
			(if (= KPL_ABTL 1)
				(progn
					(if (= (Connect.get CastaData anHtLinkesEnde) 1)
						(setq Ht_Ende (Traeger.get Htrg links))
					)
					(if (= (Connect.get CastaData anHtRechtesEnde) 1)
						(setq Ht_Ende (Traeger.get Htrg rechts))
					)
					
					(setq TrEnde_vWinkel (TrEnde.get Ht_Ende v_winkel))
					(print TrEnde_vWinkel)
					
					(if (>= TrEnde_vWinkel 90.0)
						(setq abtl_winkel (- TrEnde_vWinkel 90.0))
						(setq abtl_winkel (- 90.0 TrEnde_vWinkel))
					)
				)
			)
			
			(setq tanAW (tan (/ (* PI abtl_winkel) 180.0)))
			
			(setq anteil_schraege (* b_at_halb tanAW))
			(print anteil_schraege)
		)
	)
)


