; *************************************************************************************************
; setzt die bereits vorhandene Ausklinkungswerte auf die Ausgangslage (0.0) zurck
; *************************************************************************************************
(defun resetAtEnde ()
	(if (= (Connect.get CastaData linkesEnde) 1)	(setq ATEnde (Traeger.get Tr_ID links)))
	(if (= (Connect.get CastaData rechtesEnde) 1)	(setq ATEnde (Traeger.get Tr_ID rechts)))
	
	(TrEnde.set ATEnde (xakl 		0.0)
											(yakl			0.0)
											(zakl  		0.0)
											(hsteg 		0.0)
											(bflansch 0.0)
											(delta_l  0.0)
	)
)

(defun resetHtEnde ()
	(if (= (Connect.get CastaData anHtlinkesEnde) 1)	(setq HTEnde (Traeger.get Htrg links)))
	(if (= (Connect.get CastaData anHtrechtesEnde) 1)	(setq HTEnde (Traeger.get Htrg rechts)))
	
	(TrEnde.set HTEnde (xakl 		0.0)
											(yakl			0.0)
											(zakl  		0.0)
											(hsteg 		0.0)
											(bflansch 0.0)
											(delta_l  0.0)
	)
)

(defun resetEnden ()
	(resetAtEnde)
	(resetHtEnde)
)


; ----------------------------------------------------------------------------------------
; Gibt das Traegerende des AT zurck
; ----------------------------------------------------------------------------------------
(defun getATEnde ()
	(if (= (Connect.get CastaData LinkesEnde) 1)
		(setq AtEnde (Traeger.get Tr_ID links))
	)
	(if (= (Connect.get CastaData RechtesEnde) 1)
		(setq AtEnde (Traeger.get Tr_ID rechts))
	)
)

; ----------------------------------------------------------------------------------------
; Gibt das Traegerende des AT zurck
; ----------------------------------------------------------------------------------------
(defun getHTEnde ()
	(if (= (Connect.get CastaData anHtLinkesEnde) 1)
		(setq HtEnde (Traeger.get Htrg links))
	)
	(if (= (Connect.get CastaData anHtRechtesEnde) 1)
		(setq HtEnde (Traeger.get Htrg rechts))
	)
)


(defun berechneTraegerKanten ()
	(print "MODUS = 0")
	(berechneKantenInModus 0)
)

(defun berechneTraegerKanten_1 (kpl)
	(print "MODUS = 1")
	(berechneKantenInModus 1)
)

(defun berechneTraegerKanten_2 (kplHtrg kplTrg)
	(print "MODUS = 2")
	(berechneKantenInModus 2)
)
; TODO
; ----------------------------------------------------------------------------------------
; Berechnet folgende Werte bei unterschiedlichen Trgern:
;
;	diff_oben:		Abstand der oberen Flanschkanten zueinander
;	diff_unten:		Abstand der unteren Flanschkanten zueinander
;	maxDiff:			Maximale Ausdehnung von Flanschkanten
; minDiff:			Minimale Ausdehnung von Flanschkanten
; max_oKante:		Maximalwert fr den obersten Flansch
; max_uKante:		Maximalwert fr den untersten Flansch
;	oKante_ht
; oKante_at
; uKante_ht
; uKante_at
;
;
; PARAMETER:
; ----------
; 
; ----------------------------------------------------------------------------------------
(defun berechneKantenInModus (modus)
	
	
	(print ">-----------------------------------------------------------")
	(print "BERECHNE TRGERUNTERSCHIEDE")
		
	(if (= modus 2)
		(progn
			(setq h_kpl_ht 	(Blech.get kplHtrg hp)
						dp_kpl_ht	(Blech.get kplHtrg dp)
			)
			(setq h_kpl_at 	(Blech.get kplTrg hp)
						dp_kpl_at	(Blech.get kplTrg dp)
			)
		)
	)
	
	(if (= modus 1)
		(progn
			(setq h_kpl 	(Blech.get kpl hp)
						dp_kpl	(Blech.get kpl dp)
			)
		)
	)
	
	(setq	h_ht 		(Traeger.get Htrg h)
		delta_v_ht	(Traeger.get Htrg delta_v)
		rwinkel_ht	(Traeger.get Htrg r_winkel)
	)
	
	(setq	h_at		(Traeger.get Tr_ID h)
		delta_v_at	(Traeger.get Tr_ID delta_v)
		rwinkel_at	(Traeger.get Tr_ID r_winkel)
	)
	
	(setq rwinkel_ht_rot (+ rwinkel_ht 180.0))
	
	(if (= rwinkel_at rwinkel_ht_rot)
		(setq delta_v_at (- delta_v_at))
	)
	
	(if (= (Connect.get CastaData linkesEnde) 1)	(setq TrgEnde_AT (Traeger.get Tr_ID links)))
	(if (= (Connect.get CastaData rechtesEnde) 1)	(setq TrgEnde_AT (Traeger.get Tr_ID rechts)))
	(if (= (Connect.get CastaData anHtLinkesEnde) 1)	(setq TrgEnde_HT (Traeger.get Htrg links)))
	(if (= (Connect.get CastaData anHtRechtesEnde) 1)	(setq TrgEnde_HT (Traeger.get Htrg rechts)))
	
	(setq vscherl_at 	(TrEnde.get TrgEnde_AT vscherl)		
				vwinkel_at	(TrEnde.get TrgEnde_AT v_winkel)
	)
	(setq vscherl_ht 	(TrEnde.get TrgEnde_HT vscherl)
				vwinkel_ht	(TrEnde.get TrgEnde_HT v_winkel)
	)
	
	(print vscherl_at)
	(print vscherl_ht)
	
	(print vwinkel_at)
	(print vwinkel_ht)
	
	(setq winkel_ht (- 90.0 vwinkel_ht))
	(setq winkel_at (- vwinkel_at 90.0))
	
	(print winkel_at)
	(print winkel_ht)
	
	(if (< winkel_ht 0.0)
		(setq winkel_ht (- winkel_ht))
	)
	(if (< winkel_at 0.0)
		(setq winkel_at (- winkel_at))
	)
	(print winkel_at)
	(print winkel_ht)
	
	(setq tanVW_at	(tan (/ (* PI winkel_at) 180.0)))
	(setq tanVW_ht	(tan (/ (* PI winkel_ht) 180.0)))
	(setq cosVW_at	(cos (/ (* PI winkel_at) 180.0)))
	(setq cosVW_ht	(cos (/ (* PI winkel_ht) 180.0)))
	(print tanVW_ht)
	(print tanVW_at)
	(print cosVW_ht)
	(print cosVW_at)
	
	
	
	(if (= modus 2)
		(progn
			(print "Berechne in Modus 2")
			; Anteil der Kopfplattendicke
			(setq anteil_kpl_ht (* 1.0 dp_kpl_ht tanVW_ht))
			(setq anteil_kpl_at (* 1.0 dp_kpl_at tanVW_at))
			
			(print anteil_kpl_ht)
			(print anteil_kpl_at)
				
			(if (< vscherl_at vscherl_ht)
				(progn
					(setq h_prof_mass vscherl_ht)			
					(setq h_prof vscherl_at)
					(setq isHtrg 1)
					(Blech.set kplTrg (hp h_kpl_ht))
				)
				(progn
					(setq h_prof_mass vscherl_at)
					(setq h_prof vscherl_ht)
					(setq isHtrg 0)
					(Blech.set kplHtrg (hp h_kpl_at))
				)
			)
		)
	)
	
	(if (= modus 1)
		(progn
			; Anteil der Kopfplattendicke
			(setq anteil_kpl_ht (* (* 0.5 dp_kpl) tanVW_ht))
			(setq anteil_kpl_at (* (* 0.5 dp_kpl) tanVW_at))
			
			(print anteil_kpl_ht)
			(print anteil_kpl_at)
				
			(if (< vscherl_at vscherl_ht)
				(progn
					(setq h_prof_mass vscherl_ht)			
					(setq h_prof vscherl_at)
					(setq isHtrg 1)
					(Blech.set kpl (hp h_kpl))
				)
				(progn
					(setq h_prof_mass vscherl_at)
					(setq h_prof vscherl_ht)
					(setq isHtrg 0)
					(Blech.set kpl (hp h_kpl))
				)
			)
		)
	)
	
	
	
	
	
	
	(setq vscherl_at_halb (* 0.5 vscherl_at))
	(setq vscherl_ht_halb (* 0.5 vscherl_ht))
	
	(setq delta_v_ht_scher (/ delta_v_ht cosVW_ht))
	(setq delta_v_at_scher (/ delta_v_at cosVW_at))
	
	(print delta_v_ht_scher)
	(print delta_v_at_scher)
	
	; Oberkante der Trger
	(setq oKante_ht (- delta_v_ht_scher vscherl_ht_halb))				(print oKante_ht)
	(setq uKante_ht (+ oKante_ht vscherl_ht))					(print uKante_ht)
	(setq oKante_at	(- delta_v_at_scher vscherl_at_halb))				(print oKante_at)
	(setq uKante_at (+ oKante_at vscherl_at))					(print uKante_at)
		
	(print "-----------------------------------")
	
	; Anteil der Kopfplatte hinzurechnen
	; Hier Addition auf Double umgestellt (AF) Sept 2009
	(setq oKante_ht (+ 0.0 oKante_ht anteil_kpl_ht))					(print oKante_ht)
	(setq uKante_ht (+ 0.0 uKante_ht anteil_kpl_ht))					(print uKante_ht)
	(setq oKante_at	(+ 0.0 oKante_at anteil_kpl_at))					(print oKante_at)
	(setq uKante_at (+ 0.0 uKante_at anteil_kpl_at))					(print uKante_at)
	
	; Differenz oben
	(if (< oKante_ht oKante_at)
		(setq diff_oben (- oKante_at oKante_ht))
		(setq diff_oben (- oKante_ht oKante_at))
	)
	(print diff_oben)
	
  ; Differenz unten
	(if (< uKante_ht uKante_at)
		(setq diff_unten (- uKante_at uKante_ht))
		(setq diff_unten (- uKante_ht uKante_at))
	)
	(print diff_unten)
	
	; Maximal- / Minimalwerte ermitteln (okante / ukante)
	(if (<= oKante_ht oKante_at)
		(progn
			(setq max_oKante oKante_ht)
			(setq min_oKante oKante_at)
		)
		(progn
			(setq max_oKante oKante_at)
			(setq min_oKante oKante_ht)
		)
	)
	(if (>= uKante_ht uKante_at)
		(progn
			(setq max_uKante uKante_ht)
			(setq min_uKante uKante_at)
		)
		(progn
			(setq max_uKante uKante_at)
			(setq min_uKante uKante_ht)
		)
	)
	(print max_oKante)
	(print max_uKante)
	(print min_oKante)
	(print min_uKante)
		
	(setq maxDiff (- max_oKante max_uKante))
	(setq minDiff (- min_oKante min_uKante))
	(print maxDiff)
	(print minDiff)
	
	(if (< maxDiff 0.0)
		(setq maxDiff (- maxDiff))
	)
	(if (< minDiff 0.0)
		(setq minDiff (- minDiff))
	)
	(print maxDiff)
	(print minDiff)
	(print "<-----------------------------------------------------------")
)