; ----------------------------------------------------------------------------------------
; Berechnet die Kopfplattendicke aus der Flanschdicke des AT
; ----------------------------------------------------------------------------------------
(defun setKplDicke (Blech_ID)
	(setq t_at (Traeger.get Tr_ID t))
	
	(setq kpl_dp (runde t_at auf 5))
	(print kpl_dp)
	
	(Blech.set Blech_ID (dp kpl_dp))
)

(defun calcAndSetVoutenDaten_mitKpl (Voute_ID Blech_ID)
	(print ">-----------------------------------------------------------")
	(print "BERECHNE VOUTENDATEN")
	
	(setq	l_at	(Traeger.get Tr_ID laenge)
		h_at	(Traeger.get Tr_ID h)
		b_at	(Traeger.get Tr_ID b)
	)
	
	(setq b_ht	(Traeger.get Htrg b))
	
	(setq kpl_dp	(Blech.get Blech_ID dp))
	
	(print l_at)
	
	(setq at_winkel (Connect.get CastaData at_laengswinkel))
	(setq tanAW (tan (/ (* PI at_winkel) 180.0)))
	(setq sinAW (sin (/ (* PI at_winkel) 180.0)))
	
	(setq anteil_kpl (/ kpl_dp sinAW))
	
	(setq l_at (- l_at anteil_kpl))
	(print l_at)
	
	(if (> at_winkel 90.0)
		(progn
			(setq anteil_at_neigung (/ h_at tanAW))
			(print anteil_at_neigung)
			
			(setq l_at (+ l_at anteil_at_neigung))
			(print l_at)
		)
	)
	
	; Voutenlnge
	(if (< l_at _Vouten_Default_Laenge)
		(setq laenge_voute l_at)
		(setq laenge_voute _Vouten_Default_Laenge)
	)
	(print laenge_voute)
	
	
	; Voutenhhe
	(setq hoehe_voute (* 0.5 laenge_voute))
	
	; Flanschbreite
	(if (<= b_at b_ht)
		(setq breite_flansch b_at)
		(setq breite_flansch b_ht)
	)
	
	; Daten setzen
	(Voute.set Voute_ID
		(laenge	 		laenge_voute) 
		(hsteg1	 		hoehe_voute) 
		(d_OK 			0) 
		(t_flansch  10) 
		(b_flansch  breite_flansch) 
		(t_steg	  	10)
	)

	; als Einstellung setzen - Alternative also
	(if (= _Voute_Aus_Profil 1) (progn
		(setq TrProfil (Traeger.get Tr_ID Profil))
		(Voute.set Voute_ID (Profil TrProfil))
	))
	
	(print ">-----------------------------------------------------------")
)





; ----------------------------------------------------------------------
(defun calcAndSetBlechdaten (Blech_ID Voute_ID)
	(print ">-------------------------------------------------------------------------------")
	(print "BERECHNE KOPFPLATTE")
	(if (= (Connect.get CastaData LinkesEnde) 1)
		(setq AT_Ende (Traeger.get Tr_ID links))
	)
	(if (= (Connect.get CastaData RechtesEnde) 1)
		(setq AT_Ende (Traeger.get Tr_ID rechts))
	)
	
	(setq vscherl_at	(TrEnde.get AT_Ende vscherl))
	
	(setq h_Voute 		(Voute.get Voute_ID hsteg1)
				t_voute_fl	(Voute.get Voute_ID t_flansch)
	)
	
  (setq hProf (Traeger.get Tr_ID h)
  			b_at	(Traeger.get Tr_ID b)
  )
	
	(setq b_ht	(Traeger.get Htrg b))
	
	; dok der Kopfplatte
	(setq dOK -10)
	
  (setq dp (Blech.get Blech_ID dp))
  
	; Kopfplattenbreite
	(if (<= b_at b_ht)
		(setq bp b_at)
		(setq bp b_ht)
	)
	
	; Kopfplattenhhe
	(setq hp (+ (- dok) vscherl_at h_Voute (* 3.0 t_voute_fl)))
  
  
  
	(Blech.set Blech_ID (dp dp) (hp hp) (bp bp) (dOK dOK))

  (setq htDeltaV (Traeger.get hTrg delta_V))


  (setq delta_L dp)
  (if (> vwnkl_aflch 180) (setq delta_L (- delta_L)))
  (print delta_L)
  
  (TrEnde.pTrim AT_Ende dp)

	(print "<-------------------------------------------------------------------------------")
)

; ----------------------------------------------------------------------
(defun calcAndSetLochbildDaten (Lchb_ID Blech_ID Voute_ID)
	(print "------------------------------------------------------------")
	(print "BERECHNE LOCHBILDDATEN")
	(Lochbild.set Lchb_ID 
		(S_Bez   "M20")
		(Guete   "4.6")
;		(e       "-1 1 60 0 0 0")
		(e       "0 510 0 0 0 0")
		(w       "80  0")

	)
	
	(if (= (Connect.get CastaData linkesEnde) 1)
  	(setq AT_Ende (Traeger.get Tr_ID links))
  )
  (if (= (Connect.get CastaData rechtesEnde) 1)
  	(setq AT_Ende (Traeger.get Tr_ID rechts))
  )
  
  (setq vscherl_at (TrEnde.get AT_Ende vscherl))
  (setq vscherl_at_halb (* 0.5 vscherl_at))
  
	(setq t_htrg (Traeger.get htrg t))
	
	(setq s_at	(Traeger.get Tr_ID s)
				t_at	(Traeger.get Tr_ID t)
				r_at	(Traeger.get Tr_ID r)
	)
	
	(setq dp_blech (Blech.get Blech_ID dp))
	
	(setq hp_kpl 	(Blech.get Blech_ID hp)
				bp_kpl	(Blech.get Blech_ID bp)
	)
	
	(Lochbild.set Lchb_ID (klemml (+ t_htrg dp_blech))
												(dxskopf dp_blech)
	)
	
	; Schraubengre berechnen
	(if (> t_htrg dp_blech)
		(setq min_blech dp_blech)
		(setq min_blech t_htrg)
	)
	(calcSchraube min_blech) ; => S_Bez
	(print S_Bez)
	
	; Schraubengre setzen
	(Lochbild.set Lchb_ID (S_Bez S_Bez))
	
	; Rand- u. Lochabstnde
	(calcMinRandLochAbst Lchb_ID) ; => e_min, e1_min, e_min_rund, e1_min_rund, h_min 
	
	; SchraubenLnge
	(setq schr_l (Lochbild.get Lchb_ID laenge))
	(print schr_l)
	
	; e0 berechnen	
	(setq at_winkel (Connect.get CastaData at_laengswinkel))
	
	(setq sinAW (sin (/ (* PI at_winkel) 180.0)))
	
	(setq t_r_at	(/ (+ t_at r_at) sinAW))
	
	(setq abst_schr_of	(+ t_r_at (* 1.0 e_min)))
	(setq e0 abst_schr_of)
	
	(if (> e0 vscherl_at_halb)
		(setq e0 vscherl_at_halb)
	)
	
	; e1 berechnen
	(setq ugVoutenWnkl	(Voute.get Voute_ID ug_winkel))
	(print ugVoutenWnkl)
	
	(setq tanUG	(tan (/ (* PI ugVoutenWnkl) 180.0)))
	(print tanUG)
	
	(setq min_Abst_von_VteUG (* schr_l tanUG))
	(print min_Abst_von_VteUG)
	
	(setq e1 (- hp_kpl e0 min_Abst_von_VteUG 40 40))
	(print e1)
	
	; w0 berechnen
	(setq w0 (+ (/ (- bp_kpl s_at) 2.0) s_at))
	
	(Lochbild.set Lchb_ID (e0 			e0)
												(e1 			e1)
												(w0 			w0)
												(dxskopf 	dp_blech)
	)
	
	(print "------------------------------------------------------------")
)


(defun	createFlanschLochb (flLochbild)
   (print "-----------------------------------------------------------")
   (print "ERZEUGE FLANSCHLOCHBILD ... (*)")
   (setq xPos 		(Connect.get CastaData xPos_HT)
   	 at_winkel	(Connect.get CastaData at_laengswinkel)
   )
   
   (setq hProf		(Traeger.get HTrg h)
   	 delta_v_ht	(Traeger.get Htrg delta_v)
   	 delta_lr_ht	(Traeger.get Htrg delta_lr)
   )
   
   (setq h_at		(Traeger.get Tr_ID h)
   	 delta_v_at	(Traeger.get Tr_ID delta_v)
   	 delta_lr_at	(Traeger.get Tr_ID delta_lr)
   )
   
   (print xPos)
   
  (if (= (Connect.get CastaData linkesEnde) 1)
  	(setq AT_Ende (Traeger.get Tr_ID links))
  )
  (if (= (Connect.get CastaData rechtesEnde) 1)
  	(setq AT_Ende (Traeger.get Tr_ID rechts))
  )
  
  (if (= (Connect.get CastaData amHtOberflansch) 1)
  	(setq Flansch _flanschlochbild_of_)
  )
  (if (= (Connect.get CastaData amHtUnterflansch) 1)
  	(setq Flansch _flanschlochbild_uf_)
  )
  
  (setq vscherl_at	(TrEnde.get AT_Ende vscherl))
  (setq vscherl_at_halb	(* 0.5 vscherl_at))

	(setq tan_W	(tan (/ (* PI at_winkel) 180.0)))
	(setq sin_W	(sin (/ (* PI at_winkel) 180.0)))
	
	(setq delta_v_abtl_ht 0)
	
	
	; Winkel Anbauteil
	(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq wAbtl   0.0))
	(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq wAbtl 180.0))


	; Positionierung Anbauteil HT an EFP Lochbild AT
	(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_v_abtl_ht (- delta_v_abtl_ht vscherl_at_halb))	)
	(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_v_abtl_ht (- delta_v_abtl_ht vscherl_at_halb))	)
 
 	(setq anteil_neigung_at	(/ (* 0.5 hProf) tan_W))
 	
 	(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_v_abtl_ht (+ delta_v_abtl_ht anteil_neigung_at))	)
	(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_v_abtl_ht (- delta_v_abtl_ht anteil_neigung_at))	)
	
	
 	; Verschiebung delta_v HT
 	(setq anteil_delta_v_ht	(/ delta_v_ht tan_W))
 	
	(if (= (Connect.get CastaData amHtOberflansch) 1)
		(progn
		 	(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_v_abtl_ht (- delta_v_abtl_ht anteil_delta_v_ht))	)
			(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_v_abtl_ht (+ delta_v_abtl_ht anteil_delta_v_ht))	)
		)
	)
	(if (= (Connect.get CastaData amHtUnterflansch) 1)
		(progn
		 	(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_v_abtl_ht (+ delta_v_abtl_ht anteil_delta_v_ht))	)
			(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_v_abtl_ht (- delta_v_abtl_ht anteil_delta_v_ht))	)
		)
	)
 	
 	
 	; Verschiebung delta_v AT
 	(setq anteil_delta_v_at	(/ delta_v_at sin_W))
 	(print anteil_delta_v_at)
 	
 	(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_v_abtl_ht (+ delta_v_abtl_ht anteil_delta_v_at))	)
	(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_v_abtl_ht (+ delta_v_abtl_ht anteil_delta_v_at))	)
	
	
	(if (= LB_DEBUG 1)
		(progn 	
			(setq DummyLochbild (Lochbild.create))  ; Testversion     <------
		  (Lochbild.copy DummyLochbild flLochbild)  ; Testversion     <------
  		
  		(traeger.addabtl Htrg DummyLochbild   xPos wAbtl Flansch)
  		
  		(setq abtl_ht (Traeger.get Htrg AbTeil DummyLochbild))
  	)
  	(progn
  		(traeger.addabtl Htrg flLochbild   xPos wAbtl Flansch)
  		
  		(setq abtl_ht (Traeger.get Htrg AbTeil flLochbild))
  	)
  )
  
    (setq delta_lr_abt_ht 0)
    (print delta_lr_at)
	
    (if (= 1 1) (progn
	; Verschiebung delta_lr AT
	(if (= (Connect.get CastaData rechtesEnde) 1)
  	    (progn
		(if (= (Connect.get CastaData amHTUnterflansch) 1) 	(setq delta_lr_abt_ht (- delta_lr_at)))
		(if (= (Connect.get CastaData amHTOberflansch) 1) 	(setq delta_lr_abt_ht delta_lr_at))
	    )
	)
	(if (= (Connect.get CastaData linkesEnde) 1)
  	    (progn
		(if (= (Connect.get CastaData amHTUnterflansch) 1) 	(setq delta_lr_abt_ht delta_lr_at))
		(if (= (Connect.get CastaData amHTOberflansch) 1) 	(setq delta_lr_abt_ht (- delta_lr_at)))
	    )
	)
    ))	
	
	; Verschiebung delta_lr HT
    (if (= 1 1) (progn
	(if (= (Connect.get CastaData rechtesEnde) 1)
	    (progn
		(if (= (Connect.get CastaData amHTUnterflansch) 1) 	(setq delta_lr_abt_ht (- delta_lr_abt_ht (* 1.0 delta_lr_ht))))
		(if (= (Connect.get CastaData amHTOberflansch) 1) 	(setq delta_lr_abt_ht (- delta_lr_abt_ht (* 1.0 delta_lr_ht))))
	    )
	)
	(if (= (Connect.get CastaData linkesEnde) 1)
  	    (progn
		(if (= (Connect.get CastaData amHTUnterflansch) 1) 	(setq delta_lr_abt_ht (- delta_lr_abt_ht (* 1.0 delta_lr_ht))))
		(if (= (Connect.get CastaData amHTOberflansch) 1) 	(setq delta_lr_abt_ht (- delta_lr_abt_ht (* 1.0 delta_lr_ht))))
	    )
	)
    ))
  
	(setq abtl_at (Traeger.get Tr_ID AbTeil flLochbild))

	(Anbauteil.set abtl_at 	(Master LB_DEBUG))
	
	(Anbauteil.set abtl_ht 	(Master 	1)
				(delta_v 	delta_v_abtl_ht)
				(delta_lr	delta_lr_abt_ht)
	)
	
	
)

(defun addAbtl_Kpl_AT ()
	(if (= (Connect.get CastaData linkesEnde) 1)
		(traeger.addabtl tr_id blKpl 0.0 0.0 _kopfplattelinks_)
	)
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(traeger.addabtl tr_id blKpl 0.0 0.0 _kopfplatterechts_)
	)
)
	
(defun addAbtl_Lchb_AT ()
	(if (= (Connect.get CastaData linkesEnde) 1)
		(traeger.addabtl tr_id lchbKpl 0.0 0.0 _kpllochbildlinks_)
	)
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(traeger.addabtl tr_id lchbKpl 0.0 0.0 _kpllochbildrechts_)
	)
)

(defun addAbtl_Voute_AT ()
	(if (= (Connect.get CastaData linkesEnde) 1)
		(traeger.addabtl tr_id uzVoute 0.0 0.0 _voutelinks_)
	)
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(traeger.addabtl tr_id uzVoute 0.0 0.0 _vouterechts_)
	)
)