; Module fr Pfettenanschlsse
	; setConnection
	; calcLichtenAbst
	; calcFutterBlech    - wird nicht verwendet
	; createFutterBlech  - wirdn nicht verwendet
	; setAnbauteilBlech
	; setFahnenblechLochbild
	; sucheFahnenBlech

(defun setConnection ()
	(init-traegerenden)
	
	(calcLichtenAbst) ; -> lichterAbst
	
	(if (= 1 2) (progn
	    (if (> lichterAbst 2.0)
		(progn
			(setq futterBlech (Blech.create))
			(Connect.storeAnschlObjs CastaData futterBlech)
			(print "FutterBlech-Objekt wurde erzeugt!")
			Funktion ist hier vorhanden, wird aber nicht eingesetzt
			(createFutterBlech futterBlech lichterAbst)
		)
	    )
	))
	
	(setq FB_Vorhanden 0)
	(sucheFahnenBlech)
	(print  FB_Vorhanden)

	(if (= FB_Vorhanden 1) (progn
		(print "vorhandenes Fahnenblech wird verwendet")
		(setq lchbAtrgSteg (Lochbild.create))
		(Connect.storeAnschlObjs CastaData  lchbAtrgSteg)
		(setq wFahnenWinkel FahnenBlech_Gefunden)
	)
	(progn
		; Fahnenblech erzeugen
		(setq wFahnenWinkel		(Winkel.create))		;
		(print "Default Winkeldaten")
		(Winkel.set wFahnenWinkel (wanz 1) (l 100) (profil "L100*8"))
		(Connect.storeAnschlObjs CastaData  wFahnenWinkel)

		
;		(setq Fahnenbl (blech.create))
		(setq lchbAtrgSteg (Lochbild.create))
;		(Connect.storeAnschlObjs CastaData  Fahnenbl lchbAtrgSteg)
		(Connect.storeAnschlObjs CastaData   lchbAtrgSteg)
;		(setAnbauteilBlech Fahnenbl)
		(setAnbauteilWinkel  wFahnenWinkel)
	))

	(setFahnenblechLochbild lchbAtrgSteg  wFahnenWinkel)
;	(setFahnenblechLochbild lchbAtrgSteg Fahnenbl wFahnenWinkel)
;	(applyTo_ZProfile Fahnenbl lchbAtrgSteg)
	
	
	(setq Abtl_LB_AT (Traeger.get Tr_ID ABTeil lchbAtrgSteg))
	(setq delta_V_Lchb_AT (Anbauteil.get Abtl_LB_AT delta_V))
	(if (< delta_V_Lchb_AT 0) (progn
	     (if (= (Connect.get CastaData LinkesEnde)  1) (progn
	         (setq TrgEnde (Traeger.get Tr_ID links))
	         (setq delta_L (TrEnde.get TrgEnde delta_L))
	         (if (> delta_L delta_V_Lchb_AT) (TrEnde.set TrgEnde (delta_L delta_V_Lchb_AT)))
	     ))
	     (if (= (Connect.get CastaData rechtesEnde)  1) (progn
	         (setq TrgEnde (Traeger.get Tr_ID rechts))
	         (setq delta_L (TrEnde.get TrgEnde delta_L))
	         (print delta_L)
	         (if (> delta_L delta_V_Lchb_AT) (TrEnde.set TrgEnde (delta_L delta_V_Lchb_AT)))
	     ))
	))
	
	

	; TEST
	; ******************************************************************
	; (setq AbtlFahnenLb_AT	(Traeger.get Tr_ID AbTeil lchbAtrgSteg))
	; (setq AbtlFahnenLb_HT	(Traeger.get Htrg AbTeil lchbAtrgSteg))
	; (Anbauteil.set AbtlFahnenLb_AT (Master 0))
	; (Anbauteil.set AbtlFahnenLb_HT (Master 1))
	; (Lochbild.set lchbAtrgSteg (e "0 15 85 0 0 0") (w0 0) (w1 0) (delta_w 50))
	; (Anbauteil.set AbtlFahnenLb_HT (delta_lr -70.0))


	; ******************************************************************
)



(defun calcLichtenAbst ()
	(print ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>")
	(print "BERECHNE LICHTEN ABSTAND DER TRGER")
	(setq	delta_v_at 	(Traeger.get Tr_ID delta_v)
			delta_lr_at	(Traeger.get Tr_ID delta_lr)
			h_at		(Traeger.get Tr_ID h)
			b_at		(Traeger.get Tr_ID b)
	)
	
	(setq	delta_v_ht	(Traeger.get Htrg delta_v)
			h_ht		(Traeger.get Htrg h)
	)
	
	(setq h_at_halb	(* 0.5 h_at))
	(setq h_ht_halb	(* 0.5 h_ht))

	(setq lichterAbst 0.0)
	
	(if (= (Connect.get CastaData amAtFlansch) 1)
		(progn
			(setq pos_ht	(- delta_v_ht h_ht_halb))
			(print pos_ht)
			
			;(setq upos_at (+ delta_v_at h_at_halb))
			
			(if (= (Connect.get CastaData amHtOberflansch) 1)
				(progn
					(if (= (Connect.get CastaData amAtOberflansch) 1)	(setq pos_at	(- (- delta_v_at h_at_halb)))	); noch nicht mglich
					(if (= (Connect.get CastaData amAtUnterflansch) 1)	(setq pos_at	(+ delta_v_at h_at_halb))	)
				)
			)
			(if (= (Connect.get CastaData amHtUnterflansch) 1)
				(progn
					(if (= (Connect.get CastaData amAtOberflansch) 1)	(setq pos_at	(+ (- delta_v_at) h_at_halb))	);ok
					(if (= (Connect.get CastaData amAtUnterflansch) 1)	(setq pos_at	(- (- delta_v_at) h_at_halb))	); noch nicht mglich
				)
			)
			(print pos_at)
		)
	)
	(if (= (Connect.get CastaData amAtFlansch) 1) (progn
		(setq Anschluss_Moeglich 0)
		(setq Anschluss_Oberhalb  0)
		(setq Anschluss_Unterhalb 0)
		(setq Anschluss_Oberhalb_OF_OF 0)
		(setq Anschluss_Unterhalb_UF_UF 0)

		(setq	dv_HT (Traeger.get HTrg delta_V)
					h_HT  (Traeger.get HTrg h)
					dv_HT (* 1.0 dv_HT)
		)
		(setq	dv_AT (Traeger.get Tr_ID delta_V)
					h_AT  (Traeger.get Tr_ID h)
					dv_AT (* 1.0 dv_AT)
		)
		
		(if (= (Connect.get CastaData vatr-vhtr) 1) (progn
			(setq dv_Versatz (- dv_HT dv_AT))
			(if (>= dv_Versatz (*  0.5 (+ h_HT  h_AT))) (setq Anschluss_Oberhalb 1))
			(if (<= dv_Versatz (* -0.5 (+ h_HT  h_AT))) (setq Anschluss_Unterhalb 1))
			(if (= Anschluss_Oberhalb 1) (progn
				(setq lichterAbst (- dv_Versatz (* 0.5 (+ h_HT h_AT))))
			))
			(if (= Anschluss_Unterhalb 1) (progn
				(setq lichterAbst (- (- dv_Versatz) (* 0.5 (+ h_HT h_AT))))
			))
		))
		(if (= (Connect.get CastaData vatr-vhtr) -1) (progn
			(setq dv_Versatz (+ dv_HT dv_AT))
			(if (>= dv_Versatz (*   0.5 (+ h_HT  h_AT))) (setq Anschluss_Oberhalb_OF_OF 1))
			(if (<= dv_Versatz (*  -0.5 (+ h_HT  h_AT))) (setq Anschluss_Unterhalb_UF_UF 1))
			(if (= Anschluss_Oberhalb_OF_OF 1) (progn
				(setq lichterAbst (- dv_Versatz (* 0.5 (+ h_HT h_AT))))
			))
			(if (= Anschluss_Unterhalb_UF_UF 1) (progn
				(setq lichterAbst (- (- dv_Versatz) (* 0.5 (+ h_HT h_AT))))
			))
		))
	))


	
	(if (= (Connect.get CastaData amAtSteg) 1)
		(progn
			(setq pos_ht	(- delta_v_ht h_ht_halb))
			(print pos_ht)
			
			(setq pos_at (- delta_lr_at))
			(print pos_at)
			(if (/= pos_at pos_ht)
				(if (< pos_at pos_ht)
					(progn
						(setq lichterAbst (- pos_at pos_ht))
					)
					;(progn
					;	(print "Die Trger berschneiden sich!")
					;)
				)
			)
		)
	)
	
	
	
	
	(print lichterAbst)
	
	(if (< lichterAbst 0.0)
		(setq lichterAbst (- lichterAbst))
	)
	(print lichterAbst)
	(print "<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<")
)




(defun calcFutterBlech (BLECH_ID ABST)
	(print ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>")
	(print "BERECHNE FUTTERBLECHDATEN")
	(setq b_at		(Traeger.get Tr_ID b)
				h_at		(Traeger.get Tr_ID h)
	)
	
	(setq b_ht		(Traeger.get Htrg b)
				s_ht		(Traeger.get Htrg s)
	)
	
	
	
	; Futterblechdicke
	(setq dp_futter ABST)
	
	; Breite
	(if (= (Connect.get CastaData amATFlansch) 1)	(setq bp_futter b_at))
	(if (= (Connect.get CastaData amATSteg) 1)		(setq bp_futter h_at))
	
	; Hhe
	(if (= (Connect.get CastaData anschlZwAtEnden) 0)
		(progn
			(setq hp_futter (- (* 0.5 b_ht) (* 0.5 s_ht)))
		)
		(progn
			(setq hp_futter b_ht)
		)
	)
	
	(Blech.set BLECH_ID	(hp hp_futter)
				(bp bp_futter)
				(dp dp_futter)
	)
	
	
	(print "<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<")
)



(defun createFutterBlech (BLECH_ID ABST)
	(print ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>")
	(print "ERZEUGE FUTTERBLECH")
	(calcFutterBlech BLECH_ID ABST)
	
	(setq delta_lr_ht 	(Traeger.get Htrg delta_lr)
				s_ht					(Traeger.get Htrg s)
	)
	
	(setq xPos_at	(Connect.get CastaData xPos_at))
	
	(setq hp_futter (Blech.get BLECH_ID hp)
				bp_futter	(Blech.get BLECH_ID bp)
	)
	
	; Beim Anschluss mit AT-Enden
	(if (= (Connect.get CastaData anschlZwAtEnden) 0)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq xPos_at (+ xPos_at (* 0.5 hp_futter) (* 0.5 s_ht))))
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq xPos_at (+ xPos_at (* 0.5 hp_futter) (* 0.5 s_ht))))
					(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq xPos_at (+ xPos_at (* 0.5 hp_futter) (* 0.5 s_ht))))
					(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq xPos_at (+ xPos_at (* 0.5 hp_futter) (* 0.5 s_ht))))
				)
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq xPos_at (- xPos_at (* 0.5 hp_futter) (* 0.5 s_ht))))
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq xPos_at (- xPos_at (* 0.5 hp_futter) (* 0.5 s_ht))))
					(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq xPos_at (- xPos_at (* 0.5 hp_futter) (* 0.5 s_ht))))
					(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq xPos_at (- xPos_at (* 0.5 hp_futter) (* 0.5 s_ht))))
				)
			)
		)
	)
	
	; Anteil delta_lr HT
	(if (= (Connect.get CastaData amATFlansch) 1)
		(progn
			(if (= (Connect.get CastaData amHtOberflansch) 1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq xPos_at (- xPos_at delta_lr_ht)))
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq xPos_at (+ xPos_at delta_lr_ht)))
				)
			)
			(if (= (Connect.get CastaData amHtUnterflansch) 1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq xPos_at (+ xPos_at delta_lr_ht)))
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq xPos_at (- xPos_at delta_lr_ht)))
				)
			)
		)
	)
	(if (= (Connect.get CastaData amATSteg) 1)
		(progn
			(if (= (Connect.get CastaData amHtOberflansch) 1)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq xPos_at (- xPos_at delta_lr_ht)))
					(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq xPos_at (+ xPos_at delta_lr_ht)))
				)
			)
			(if (= (Connect.get CastaData amHtUnterflansch) 1)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq xPos_at (+ xPos_at delta_lr_ht)))
					(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq xPos_at (- xPos_at delta_lr_ht)))
				)
			)
		)
	)	
		
	(if (= (Connect.get CastaData amATUnterFlansch) 1)	(Traeger.addabtl Tr_ID BLECH_ID xPos_at 0.0 _lasche_uf_))
	(if (= (Connect.get CastaData amATOberFlansch) 1)	(Traeger.addabtl Tr_ID BLECH_ID xPos_at 0.0 _lasche_of_))
	(if (= (Connect.get CastaData amATSteg) 1)		(Traeger.addabtl Tr_ID BLECH_ID xPos_at 0.0 _lasche_steg_li_))
	
	(if (= (Connect.get CastaData amATFlansch) 1)
		(progn
			
			(setq delta_lr_abtl_futter (- (* 0.5 bp_futter)))
			
			(setq futter_abtl (Traeger.get Tr_ID AbTeil BLECH_ID))
	
			(Anbauteil.set futter_abtl (delta_lr delta_lr_abtl_futter))
		)
	)
	(print "<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<")
)


; -------------------------------------------------------------
; Setzt das Anbauteil fr das Blech
; -------------------------------------------------------------
(defun setAnbauteilBlech (BLECH_ID)
	(print ">-----------------------------------------------------------")
	(print "SETZE ANBAUTEIL BLECH")
	
	; xPos
	(setq xPos_ht (Connect.get CastaData xPos_ht))
	(Blech.set BLECH_ID (dp 10) (hp 200) (bp 110) (dOK 0))
	
	; Anbauteil Winkel
	(setq r_winkel_at (Traeger.get Tr_ID r_winkel))
	(setq h_winkel_ht	(Connect.get CastaData hpttrg_hwinkel))
	(print h_winkel_ht)
	(print r_winkel_at)
	
	(setq r_winkel_blech (- h_winkel_ht r_winkel_at))
	
	(print r_winkel_blech)
	(setq r_winkel_blech 90.0)
	
	; xPos am HT berechnen
	; ----------------------------------------------
	
	; Anteil der delta_v Verschiebung des Riegels an xPos des Fahnenbleches
	; ----------------------------------------------
	(setq delta_v_ht (Traeger.get Htrg delta_v))
	(setq vwinkel_ht (Connect.get CastaData hpttrg_vwinkel))
	(setq tanW (tan (/ (* PI vwinkel_ht) 180.0)))
	
	(setq anteil_delta_v_ht_xPos (* delta_v_ht tanW))
	(print anteil_delta_v_ht_xPos)
	
;	Nicht erforderlich, da Vertikals Verschiebung in dieselbe Richtung gehen muss
;	Um es genau zu machen, msste der Rotationswinkel des AT noch bercksichtigt werden,
;	der dann dann 'anteil_delta_v_ht_xPos' zu 0 berechnen wrde.
;	(setq xPos_ht (- xPos_ht anteil_delta_v_ht_xPos))
	
	; Anbauteil Fahnenblech dem HT hinzufgen
	(if (= (Connect.get CastaData amHtOberflansch) 1)
		(Traeger.addabtl Htrg BLECH_ID xPos_ht r_winkel_blech _fahnenblech_of_)
	)
	(if (= (Connect.get CastaData amHtUnterflansch) 1)
		(Traeger.addabtl Htrg BLECH_ID xPos_ht r_winkel_blech _fahnenblech_uf_)
	)
	
	
	; delta_v Fahnenblech
	(setq delta_v_at (Traeger.get Tr_ID delta_v))
	(print delta_v_at)
	
	(if (= (Connect.get CastaData vatr-shtr)  0)
		(progn
			(if (= (Connect.get CastaData RechtesEnde) 1)	(setq delta_v_abtl_lasche (- delta_v_at))	)
			(if (= (Connect.get CastaData LinkesEnde)  1)	(setq delta_v_abtl_lasche delta_v_at)			)
		)
		(progn
			(setq delta_v_abtl_lasche delta_v_at)
		)
	)
	
	
	(setq delta_v_abtl_lasche	 0)
	
	

	; Neigung des Fahnenblechs bestimmen
	; --------------------------
	(setq nwinkel (Connect.get CastaData hpttrg_vwinkel))
	(print nwinkel)
	
	(if (= (Connect.get CastaData vatr-shtr)  1)	(setq nwinkel nwinkel))
	(if (= (Connect.get CastaData vatr-shtr) -1)	(setq nwinkel (- nwinkel)))
	
	; Werte setzen
	; --------------------------
	(setq abtl_lasche (Traeger.get Htrg Abteil BLECH_ID))
	
	(Anbauteil.set abtl_lasche 	(delta_v 		delta_v_abtl_lasche)
;					(delta_lr		delta_lr_abtl_lasche)
;					(neigwnkl_d	nwinkel)
	)
	
	
	(setq	h_AT	(Traeger.get	Tr_ID h)
		b_HT	(Traeger.get	HTrg  b)
		hp	(Blech.get	BLECH_ID  hp)
	)
	(setq bp (+ h_AT lichterAbst (- 5)))
	(Blech.set BLECH_ID (bp bp))
	(if (> hp b_HT) (Blech.set BLECH_ID (hp b_HT)))
	(print "<-----------------------------------------------------------")
)
; --------------------------------------------------------------------- +++++++++++++++++++++++++ ------------------------------------------------------------
(defun setAnbauteilWinkel (Winkel_ID)
	(print ">-----------------------------------------------------------")
	(print "SETZE ANBAUTEIL Winkel")
    (setq b_HT (Traeger.get HTrg   b))
    (setq h_AT (Traeger.get Tr_ID  h))
	
	(if (< h_AT 190) (progn
		(setq wProf "L100*8")
		(if (>= h_AT 120) (setq wProf "L100*8")) 
		(if (>= h_AT 140) (setq wProf "L120*10")) 
		(if (>= h_AT 160) (setq wProf "L140*13")) 
		(if (>= h_AT 180) (setq wProf "L160*15")) 
		(Winkel.set wFahnenWinkel (L (- b_HT 10)) (profil wProf))
	))
	(if (>= h_AT 190) (progn
		(setq slk_Winkel  (runde (- h_AT 15) auf 10))
		(setq sll_Winkel (runde (* 0.5 slk_Winkel) auf 5))
	
		(Winkel.set  wFahnenWinkel (profil "") (slk slk_Winkel) (sll sll_Winkel) (dw 10)  (L (- b_HT 10)))
	))

	; xPos
	(setq xPos_ht (Connect.get CastaData xPos_ht))
;	(Blech.set BLECH_ID (dp 10) (hp 200) (bp 110) (dOK 0))
	
	; Anbauteil Winkel
	(setq r_winkel_at (Traeger.get Tr_ID r_winkel))
	(setq h_winkel_ht	(Connect.get CastaData hpttrg_hwinkel))
	(print h_winkel_ht)
	(print r_winkel_at)
	
	(setq r_winkel_blech (- h_winkel_ht r_winkel_at))
	
	(print r_winkel_blech)

	(if (= (Connect.get CastaData satr-lhtr-ex)   1)	(progn
		(setq r_winkel_blech 180.0)
	))
	(if (= (Connect.get CastaData satr-lhtr-ex)  -1)	(progn
		(setq r_winkel_blech  0.0)
	))

	(setq diff_t 0.0)
	(setq qsForm_AT (Traeger.get Tr_ID QSForm))
	(if (= qsForm_AT "Z") (progn
		(setq  r_winkel_blech (+ r_winkel_blech 180.0))
		(if (>= r_winkel_blech 360.0) (setq r_winkel_blech (- r_winkel_blech 360.0)))
		(setq t_AT (Traeger.get Tr_ID t))
		(setq diff_t (* 0.5 t_AT))
	))
	
	; xPos am HT berechnen
	; ----------------------------------------------
	
	; Anteil der delta_v Verschiebung des Riegels an xPos des Fahnenbleches
	; ----------------------------------------------
	(setq delta_v_ht (Traeger.get Htrg delta_v))
	(setq delta_LR_At (Traeger.get Tr_ID delta_LR))
	(setq vwinkel_ht (Connect.get CastaData hpttrg_vwinkel))
	(setq tanW (tan (/ (* PI vwinkel_ht) 180.0)))
	
	(setq anteil_delta_v_ht_xPos (* delta_v_ht tanW))
	(print anteil_delta_v_ht_xPos)
	
;	Nicht erforderlich, da Vertikals Verschiebung in dieselbe Richtung gehen muss
;	Um es genau zu machen, msste der Rotationswinkel des AT noch bercksichtigt werden,
;	der dann dann 'anteil_delta_v_ht_xPos' zu 0 berechnen wrde.
;	(setq xPos_ht (- xPos_ht anteil_delta_v_ht_xPos))
	
	(if (= (Connect.get CastaData satr-lhtr-ex)  1)  (setq  xPos_ht (+ xPos_ht delta_LR_At diff_t)))
	(if (= (Connect.get CastaData satr-lhtr-ex) -1)  (setq  xPos_ht (- xPos_ht delta_LR_At  diff_t)))
	; Anbauteil Fahnenblech dem HT hinzufgen
	(if (= Anschluss_Oberhalb 1) (progn
		(if (= (Connect.get CastaData amHtOberflansch) 1)
			(Traeger.addabtl Htrg Winkel_ID xPos_ht r_winkel_blech _winkel_oberflansch_)
		)
		(if (= (Connect.get CastaData amHtUnterflansch) 1)
			(Traeger.addabtl Htrg Winkel_ID xPos_ht r_winkel_blech _winkel_oberflansch_)
		)
	))
	(if (= Anschluss_Unterhalb 1) (progn
		(if (= (Connect.get CastaData amHtOberflansch) 1)
			(Traeger.addabtl Htrg Winkel_ID xPos_ht r_winkel_blech _winkel_unterflansch_)
		)
		(if (= (Connect.get CastaData amHtUnterflansch) 1)
			(Traeger.addabtl Htrg Winkel_ID xPos_ht r_winkel_blech _winkel_unterflansch_)
		)
	))

	(if (= Anschluss_Oberhalb_OF_OF 1) (progn
		(print "Anschluss_Oberhalb_OF_OF")
		(if (= (Connect.get CastaData amHtOberflansch) 1)
			(Traeger.addabtl Htrg Winkel_ID xPos_ht r_winkel_blech _winkel_oberflansch_)
		)
		(if (= (Connect.get CastaData amHtUnterflansch) 1)
			(Traeger.addabtl Htrg Winkel_ID xPos_ht r_winkel_blech _winkel_oberflansch_)
		)
	))
	(if (= Anschluss_Unterhalb_UF_UF 1) (progn
		(print "Anschluss_Unterhalb_UF_UF")
		(if (= (Connect.get CastaData amHtOberflansch) 1)
			(Traeger.addabtl Htrg Winkel_ID xPos_ht r_winkel_blech _winkel_unterflansch_)
		)
		(if (= (Connect.get CastaData amHtUnterflansch) 1)
			(Traeger.addabtl Htrg Winkel_ID xPos_ht r_winkel_blech _winkel_unterflansch_)
		)
	))

	
;	(connect.showattributes CastaData)

;	(setq abtl_Winkel (Traeger.get HTrg ABTeil Winkel_ID))
;	(Anbauteil.set  abtl_Winkel (delta_V 50))
	(Winkel.set  Winkel_ID (delta_V 50))
	
	
	; delta_v Fahnenblech
	(setq delta_v_at (Traeger.get Tr_ID delta_v))
	(print delta_v_at)
	
	(if (= (Connect.get CastaData vatr-shtr)  0)
		(progn
			(if (= (Connect.get CastaData RechtesEnde) 1)	(setq delta_v_abtl_lasche (- delta_v_at))	)
			(if (= (Connect.get CastaData LinkesEnde)  1)	(setq delta_v_abtl_lasche delta_v_at)			)
		)
		(progn
			(setq delta_v_abtl_lasche delta_v_at)
		)
	)
	
	
	(setq delta_v_abtl_lasche	 0)

	; Neigung des Fahnenblechs bestimmen
	; --------------------------
	(setq nwinkel (Connect.get CastaData hpttrg_vwinkel))
	(print nwinkel)
	
	
	; Werte setzen
	; --------------------------
	(print "<-----------------------------------------------------------")
)


(defun setFahnenblechLochbild (LCHB_ID  Winkel_ID)	
	(print ">-----------------------------------------------------------")
	(print "SETZE ANBAUTEIL LOCHBILD")

	(Lochbild.set Lchb_ID	;(lb_art  LbArt)
			(Anz_S    4)
			(S_Bez   "M12")
			(Guete   "4.6")
			(e       "0  20 80 0 0 0")
			(w       "0  0")
	)

	
	
	(setq	h_ht		(Traeger.get Htrg h)
		s_ht		(Traeger.get Htrg s)
		b_Ht		(Traeger.get Htrg b)
		delta_v_ht 	(Traeger.get Htrg delta_v)
	)
	
	(setq	delta_v_at	(Traeger.get Tr_ID delta_v)
		delta_lr_at	(Traeger.get Tr_ID delta_lr)
		s_AT		(Traeger.get Tr_ID s)
		h_AT		(Traeger.get Tr_ID h)
	)
;	(setq hp_FahnenBl	(Blech.get BLECH_ID hp))
;	(setq dp_FahnenBl	(Blech.get BLECH_ID dp))

	(setq hp_FahnenBl	(Winkel.get Winkel_ID slk))
	(setq dp_FahnenBl	(Winkel.get Winkel_ID dw))
	
	(setq	xPos_ht 	(Connect.get CastaData xPos_ht))
	(setq	xPos_at 	(Connect.get CastaData xPos_at))
	
	; Lochbild HT
;	(setq AbtlFahnenBl	(Traeger.get Htrg AbTeil BLECH_ID))
;	(Traeger.addabtl Htrg LCHB_ID xPos_ht 0.0 _fahnblLochbild_ AbtlFahnenBl)	
	(setq AbtlWinkel	(Traeger.get Htrg AbTeil Winkel_ID))
	(Traeger.addabtl Htrg LCHB_ID xPos_ht 0.0 _fahnblLochbild_ AbtlWinkel)	

	(Lochbild.set Lchb_ID	(KlemmL  (+ s_AT dp_FahnenBl))
				(dxSKopf (* 1.0  dp_FahnenBl))
	)

	; Z-Profile werden von der anderen Seite geschraubt
	(setq qsForm_AT (Traeger.get Tr_ID QSForm))
	(if  (= qsForm_AT "Z") (progn
		(Lochbild.set Lchb_ID	(dxSKopf   0.0))
	))
	
	

	(setq AbtlFahnenLb_HT	(Traeger.get Htrg AbTeil LCHB_ID))
	(Anbauteil.set AbtlFahnenLb_HT (Winkel 90.0)
				    (delta_v 0)
	)

	(Traeger.addabtl Tr_ID LCHB_ID xPos_At 0.0 _steglochbild_system_)	

	; Hier finden jetzt alle Fallunterscheidungen statt
	; -------------------------------------------------
	(setLochbildAbtlAttr)

	
;	(if (= (Connect.get CastaData sATr-lHTr) -1) (progn
;		(setq LB_HTWinkel (Anbauteil.get AbtlFahnenLb_HT Winkel))
;		(Anbauteil.set AbtlFahnenLb_HT (Winkel (- LB_HTWinkel)))
;	))

	(setq delta_V_diff 0.0)
	(if (= (Connect.get CastaData amhtOberFlansch) 1) (progn
		(setq delta_V_diff (+ delta_v_at (- delta_v_ht) (* 0.5 (+ h_HT  h_AT))))
	))
	(if (= (Connect.get CastaData amhtUnterFlansch) 1) (progn
		(setq delta_V_diff (- delta_v_at delta_v_ht (* 0.5  h_HT) (* 0.5 h_AT)))
	))

	(setq w1 (/ h_AT 4.0) w2 (* 2 w1))	; Default-Wert
	(setq ih_AT (* 1 h_AT))
	(if (= ih_AT 105) (setq w1 30 w2 45))
	(if (= ih_AT 120) (setq w1 35 w2 50))
	(if (= ih_AT 140) (setq w1 40 w2 60))
	(if (= ih_AT 150) (setq w1 40 w2 70))
	(if (= ih_AT 160) (setq w1 40 w2 80))
	(if (= ih_AT 180) (setq w1 50 w2 80))
	(if (= ih_AT 200) (setq w1 60 w2 80))
	(if (= ih_AT 250) (setq w1 60 w2 130))
	(if (= ih_AT 300) (setq w1 75 w2 150))
	
	(setq w2 (+ w2 w1))	; Da bei uns jeweils von der Lochbildmitte aus gemessen wird (hier fiktiven Mitte
	(setq e0 (/ b_Ht 4))
	
	(Lochbild.set Lchb_ID
			(e       "0  0 0 0 0 0")
			(e0	 e0)
			(w0     w1)
			(w1     w2)
	)

	(if (= (Connect.get CastaData AnschlZwATEnden) 1) (progn
		(setq e0 (- e0) e1 (* 2 e0))
		(if (< e1 0) (setq e1 (- e1)))
		(Lochbild.set Lchb_ID (e0 e0) (e1 e1))
	))

	(Anbauteil.set AbtlFahnenLb_HT (Master 0))
	(Anbauteil.set AbtlFahnenLb_AT (Master 1))

)


(defun sucheFahnenBlech ()

  (setq xPos_HT (Connect.get CastaData xPos_HT))
  (setq gesKnoBlTyp 0) ; auf unknown setzen
  (if (= (connect.get CastaData amHtStegLinks)    1)  (setq gesKnoBlTyp _fahnenblech_steg_li_))
  (if (= (connect.get CastaData amHtStegRechts)   1)  (setq gesKnoBlTyp _fahnenblech_steg_re_))
  ; Flansche gehen vor, weil es auch vorbeilaufende Trger gibt.
  ; Deswegen in dieser Reihenfolge. - Aber hier sollte noch ein Flag eingefhrt werden
  ; vorbeilaufend oder hnlich, damit der Fall eindeutig identifiziert wird.
  (if (= Anschluss_Oberhalb  1) (setq  gesKnoBlTyp  _winkel_oberflansch_))
  (if (= Anschluss_Unterhalb 1) (setq  gesKnoBlTyp  _winkel_unterflansch_))
  (if (= Anschluss_Oberhalb_OF_OF  1) (setq  gesKnoBlTyp  _winkel_oberflansch_))
  (if (= Anschluss_Unterhalb_UF_UF 1) (setq  gesKnoBlTyp  _winkel_unterflansch_))

  (setq abtl_KnoBl (Traeger.get Htrg firstAbtl  WinkelAnbauteil (- xPos_HT 1.0) (+ xPos_HT 1.0)))
  (while abtl_KnoBl
  	(setq sType     (Anbauteil.get abtl_KnoBl is_type gesKnoBlTyp))
  	(if (= sType 1) (progn
	    (print "FahnenBlech gefunden -----------------------------------------------------")
	    (print sType)

;	    (showAbtlDaten abtl_KnoBl)	;; nur zu Entwicklungszwecken

;	    (setq afl_wnkl (Connect.get CastaData at_laengswinkel))

;	    (setq FahnenBlech_Gefunden (Anbauteil.get abtl_KnoBl Objekt Blech))
	    (setq FahnenBlech_Gefunden (Anbauteil.get abtl_KnoBl Objekt Winkel))
	    (setq xPosVorh (Anbauteil.get abtl_KnoBl xPos))
	    (setq FB_Vorhanden 1)
	))
  	(setq abtl_KnoBl (Traeger.get Htrg nextAbtl WinkelAnbauteil))
  )
  (setq abtl_KnoBl_T (Traeger.get Htrg firstAbtl FahnenBlech_Gefunden (- xPos_HT 0.1) (+ xPos_HT 0.1)))
  (if (existObj FahnenBlech_Gefunden) (progn
	  (if (existObj abtl_KnoBl_T)
	      (print  "OK - Objekt gefunden und passt");
	      (alertBox "Das Blech wurde mit einer greren Toleranz eingesetzt!\nBitte die Schraubenlngen nach nderung der Blechdicke berprfen!"  "NOTE_PlateThickness_BoltLength");
	  )
  ))

)


(defun setLochbildAbtlAttr ()
	(print ">> ------------------------ hier in setLochbildAbtlAttr")
	(print "*clear*")
	(Connect.ShowAttributes CastaData)
	(setq AT_Ausrichtung 0)
	(if (= Anschluss_Oberhalb 1)  (setq AT_Ausrichtung 1))
	(if (= Anschluss_Unterhalb 1) (setq AT_Ausrichtung -1))
	(if (= Anschluss_Oberhalb_OF_OF  1) (setq AT_Ausrichtung -1))
	(if (= Anschluss_Unterhalb_UF_UF 1) (setq AT_Ausrichtung  1))

	(setq AbtlFahnenLb_HT	(Traeger.get Htrg  AbTeil lchbAtrgSteg))
	(setq AbtlFahnenLb_AT	(Traeger.get Tr_ID AbTeil lchbAtrgSteg))

	(print "---------------------------------------------------- Variable ----")
	(print AT_Ausrichtung)
	
	(setq dlr_HT (Traeger.get HTrg delta_LR))
	(setq h_AT (Traeger.get Tr_ID h))
	(setq h_AT2 (* 0.5 h_AT))
	(print h_AT2)
	(print lichterAbst)
	(setq dLR_AT_AbtlLchb (+ (* 0.5 h_AT) lichterAbst))
	(print dLR_AT_AbtlLchb)
	
	(setq LchbFall 0)
	(if (= (Connect.get CastaData amhtOberFlansch) 1) (progn
		(if (= (Connect.get CastaData linkesEnde ) 1) (progn
			(if (= AT_Ausrichtung 1) (progn
				(setq LchbFall 1)
				(Anbauteil.set AbtlFahnenLb_HT (winkel -90.0))
				(Anbauteil.set AbtlFahnenLb_HT (delta_LR lichterAbst))

				(Anbauteil.set AbtlFahnenLb_AT (SeitRicht -1))
				(Anbauteil.set AbtlFahnenLb_AT (delta_LR (* -0.5 h_AT)))
				(Anbauteil.set AbtlFahnenLb_AT (delta_V  (- dlr_HT)))
				(Anbauteil.set AbtlFahnenLb_AT (winkel   0.0))
			))
			(if (= AT_Ausrichtung -1) (progn
				(setq LchbFall 8)
				(Anbauteil.set AbtlFahnenLb_HT (winkel 90.0))
				(Anbauteil.set AbtlFahnenLb_HT (delta_LR (- lichterAbst)))

				(Anbauteil.set AbtlFahnenLb_AT (winkel   0.0))
				(Anbauteil.set AbtlFahnenLb_AT (delta_V dlr_HT))
				(Anbauteil.set AbtlFahnenLb_AT (delta_LR (* 0.5 h_AT)))
			))
		))
		(if (= (Connect.get CastaData rechtesEnde ) 1) (progn
			(if (= AT_Ausrichtung 1) (progn
				(setq LchbFall 2)
				(Anbauteil.set AbtlFahnenLb_HT (delta_LR lichterAbst))
				(Anbauteil.set AbtlFahnenLb_HT (winkel  90.0))

				(Anbauteil.set AbtlFahnenLb_AT (delta_LR (* 0.5 h_AT)))
				(Anbauteil.set AbtlFahnenLb_AT (delta_V dlr_HT))
				(Anbauteil.set AbtlFahnenLb_AT (winkel 180.0))
			))
			(if (= AT_Ausrichtung -1) (progn
				(setq LchbFall 7)
				(Anbauteil.set AbtlFahnenLb_AT (SeitRicht -1))
				(Anbauteil.set AbtlFahnenLb_HT (delta_LR (- lichterAbst)))
				(Anbauteil.set AbtlFahnenLb_AT (delta_V (- dlr_HT)))

				(Anbauteil.set AbtlFahnenLb_AT (winkel -180.0))
				(Anbauteil.set AbtlFahnenLb_AT (delta_LR (* -0.5 h_AT)))
				(Anbauteil.set AbtlFahnenLb_HT (winkel  -90.0))
			))
		))
		(if (= (Connect.get CastaData AnschlZwAtEnden ) 1) (progn
			(if (= (Connect.get CastaData at-von-links) 1) (progn
				(setq LchbFall 11)
				(Anbauteil.set AbtlFahnenLb_HT (delta_LR (- lichterAbst)))
				(Anbauteil.set AbtlFahnenLb_HT (winkel   90.0))

				(Anbauteil.set AbtlFahnenLb_AT (winkel    0.0))
				(Anbauteil.set AbtlFahnenLb_AT (delta_LR (* 0.5 h_AT)))
				(Anbauteil.set AbtlFahnenLb_AT (delta_V  dlr_HT))
			))
			(if (= (Connect.get CastaData at-von-rechts) 1) (progn
				(setq LchbFall 12)
				(Anbauteil.set AbtlFahnenLb_HT (delta_LR  lichterAbst))
				(Anbauteil.set AbtlFahnenLb_HT (winkel   -90.0))

				(Anbauteil.set AbtlFahnenLb_AT (SeitRicht -1))
				(Anbauteil.set AbtlFahnenLb_AT (winkel   0.0))
				(Anbauteil.set AbtlFahnenLb_AT (delta_V  (- dlr_HT)))
				(Anbauteil.set AbtlFahnenLb_AT (delta_LR (* -0.5 h_AT)))
			))
		))
	))
	(if (= (Connect.get CastaData amhtUnterFlansch) 1) (progn
		(if (= (Connect.get CastaData rechtesEnde ) 1) (progn
			(if (= AT_Ausrichtung -1) (progn
				(setq LchbFall 3)
				(Anbauteil.set AbtlFahnenLb_AT (delta_LR (* -0.5 h_AT)))
				(Anbauteil.set AbtlFahnenLb_AT (delta_V dlr_HT))
				(Anbauteil.set AbtlFahnenLb_AT (winkel 180.0))
				(Anbauteil.set AbtlFahnenLb_HT (winkel  90.0))
				(Anbauteil.set AbtlFahnenLb_HT (delta_LR lichterAbst))
			))
			(if (= AT_Ausrichtung 1) (progn
				(setq LchbFall 5)
				(Anbauteil.set AbtlFahnenLb_AT (delta_LR (* 0.5 h_AT)))
				(Anbauteil.set AbtlFahnenLb_AT (delta_V (- dlr_HT)))
				(Anbauteil.set AbtlFahnenLb_AT (winkel 180.0))
				(Anbauteil.set AbtlFahnenLb_AT (SeitRicht -1))

				(Anbauteil.set AbtlFahnenLb_HT (winkel   -90.0))
				(Anbauteil.set AbtlFahnenLb_HT (delta_LR lichterAbst))
			))
		))
		(if (= (Connect.get CastaData AnschlZwAtEnden ) 1) (progn
			(if (= (Connect.get CastaData at-von-links) 1) (progn
				(setq LchbFall 9)
				(Anbauteil.set AbtlFahnenLb_HT (delta_LR lichterAbst))
				(Anbauteil.set AbtlFahnenLb_HT (winkel   90.0))

				(Anbauteil.set AbtlFahnenLb_AT (winkel    0.0))
				(Anbauteil.set AbtlFahnenLb_AT (delta_LR (* -0.5 h_AT)))
				(Anbauteil.set AbtlFahnenLb_AT (delta_V  dlr_HT))
			))
			(if (= (Connect.get CastaData at-von-rechts) 1) (progn
				(setq LchbFall 10)
				(Anbauteil.set AbtlFahnenLb_HT (delta_LR lichterAbst))
				(Anbauteil.set AbtlFahnenLb_HT (winkel   -90.0))

				(Anbauteil.set AbtlFahnenLb_AT (SeitRicht -1))
				(Anbauteil.set AbtlFahnenLb_AT (winkel   0.0))
				(Anbauteil.set AbtlFahnenLb_AT (delta_V  (- dlr_HT)))
				(Anbauteil.set AbtlFahnenLb_AT (delta_LR (* 0.5 h_AT)))
			))
		))

		(if (= (Connect.get CastaData linkesEnde ) 1) (progn
			(if (= AT_Ausrichtung -1) (progn
				(setq LchbFall 4)
				(Anbauteil.set AbtlFahnenLb_HT (delta_LR lichterAbst))
				(Anbauteil.set AbtlFahnenLb_HT (winkel -90.0))

				(Anbauteil.set AbtlFahnenLb_AT (SeitRicht -1))
				(Anbauteil.set AbtlFahnenLb_AT (delta_V  (- dlr_HT)))
				(Anbauteil.set AbtlFahnenLb_AT (delta_LR (* 0.5 h_AT)))
				(Anbauteil.set AbtlFahnenLb_AT (winkel   0.0))
			))
			(if (= AT_Ausrichtung  1) (progn
				(setq LchbFall 6)
				(Anbauteil.set AbtlFahnenLb_HT (delta_LR lichterAbst))
				(Anbauteil.set AbtlFahnenLb_HT (winkel 90.0))

				(Anbauteil.set AbtlFahnenLb_AT (delta_V  dlr_HT))
				(Anbauteil.set AbtlFahnenLb_AT (delta_LR (* -0.5 h_AT)))
				(Anbauteil.set AbtlFahnenLb_AT (winkel   0.0))
			))
		))
	))
	(if (= (Connect.get CastaData satr-lhtr) -1) (progn
		(if (= (Connect.get CastaData AnschlZwAtEnden ) 0) (progn
			(print "Nachbehandlung ....")
			(setq dv_Abtl_Lb_vorh (Anbauteil.get AbtlFahnenLb_AT delta_V))
			(Anbauteil.set AbtlFahnenLb_AT (delta_V (- dv_Abtl_Lb_vorh)))
		
			(setq LB_HTWinkel (Anbauteil.get AbtlFahnenLb_HT Winkel))
			(Anbauteil.set AbtlFahnenLb_HT (Winkel (- LB_HTWinkel)))
		))
	))

	; Anschluss oberhalb
	(if (= AT_Ausrichtung 1) (progn
		(if (= (Connect.get CastaData vatr-vhtr)  1) (Anbauteil.set AbtlFahnenLb_HT (delta_LR lichterAbst)))
		(if (= (Connect.get CastaData vatr-vhtr) -1) (Anbauteil.set AbtlFahnenLb_HT (delta_LR lichterAbst)))
	))
	; Anschluss oberhalb
	(if (= AT_Ausrichtung -1) (progn
		(if (= (Connect.get CastaData vatr-vhtr)  1) (Anbauteil.set AbtlFahnenLb_HT (delta_LR lichterAbst)))
		(if (= (Connect.get CastaData vatr-vhtr) -1) (Anbauteil.set AbtlFahnenLb_HT (delta_LR lichterAbst)))
	))


	(print LchbFall)
	(if (= LchbFall 0) (AlertBox "Fall noch nicht erfasst"))

	
	
	(if (= LchbFall 6) (progn
				(setq dlr_AT_Vorh (Anbauteil.get AbtlFahnenLb_AT delta_LR))
				(print dlr_AT_Vorh)
				(setq dlr_HT_vorh (Anbauteil.get AbtlFahnenLb_HT delta_LR))
				(print dlr_HT_vorh)

				(setq dV_AT_Vorh (Anbauteil.get AbtlFahnenLb_AT delta_V))
				(print dV_AT_Vorh)
				(setq dV_HT_Vorh (Anbauteil.get AbtlFahnenLb_HT delta_V))
				(print dV_HT_Vorh)

				(setq seitricht_AT_Vorh (Anbauteil.get AbtlFahnenLb_AT seitricht))
				(print seitricht_AT_Vorh)
				
				(setq seitricht_HT_Vorh (Anbauteil.get AbtlFahnenLb_HT seitricht))
				(print seitricht_HT_Vorh)

				(setq winkel_AT_Vorh (Anbauteil.get AbtlFahnenLb_AT winkel))
				(print winkel_AT_Vorh)
				
				(setq winkel_HT_Vorh (Anbauteil.get AbtlFahnenLb_HT winkel))
				(print winkel_HT_Vorh)
	))
)

