; Module fr Pfettenanschlsse
	; setConnection
	; calcLichtenAbst
	; calcFutterBlech    - wird nicht verwendet
	; createFutterBlech  - wirdn nicht verwendet
	; setAnbauteilWinkel_Steg
	; setWinkelLochbild
	; sucheWinkelAnbauteil

(defun setConnection ()
	(init-traegerenden)
	
	(calcLichtenAbst_Steg) ; -> lichterAbst
	
	(setq Wnkl_Vorhanden 0)
	(sucheWinkelAnbauteil)

	(print "*clear*")
	(Connect.showAttributes CastaData)

	(if (= Wnkl_Vorhanden 1) (progn
		(print "vorhandenes Winkelobjekt wird verwendet")
		(setq lchbAtrgSteg (Lochbild.create))
		(Connect.storeAnschlObjs CastaData  lchbAtrgSteg)
		(setq wFahnenWinkel WinkelAnbauteil_Gefunden)
	)
	(progn
		(print "Winkelobjekt erzeugen")
		; Winkelobjekt erzeugen
		(setq wFahnenWinkel (Winkel.create))
		(setq lchbAtrgSteg (Lochbild.create))
		(Connect.storeAnschlObjs CastaData  wFahnenWinkel lchbAtrgSteg)
		(Winkel.set wFahnenWinkel (wanz 1) (l 100) (profil "L100*8"))

		(setAnbauteilWinkel_Steg   wFahnenWinkel)
	))
	(setWinkelLochbild lchbAtrgSteg wFahnenWinkel)
	; (applyTo_ZProfile Fahnenbl lchbAtrgSteg)
	
)
(defun Teil_2 ()
	
	(setq Abtl_LB_AT (Traeger.get Tr_ID ABTeil lchbAtrgSteg))
	(setq delta_V_Lchb_AT (Anbauteil.get Abtl_LB_AT delta_V))
	(if (< delta_V_Lchb_AT 0) (progn
	     (if (= (Connect.get CastaData LinkesEnde)  1) (progn
	         (setq TrgEnde (Traeger.get Tr_ID links))
	         (setq delta_L (TrEnde.get TrgEnde delta_L))
	         (if (> delta_L delta_V_Lchb_AT) (TrEnde.set TrgEnde (delta_L delta_V_Lchb_AT)))
	     ))
	     (if (= (Connect.get CastaData rechtesEnde)  1) (progn
	         (setq TrgEnde (Traeger.get Tr_ID rechts))
	         (setq delta_L (TrEnde.get TrgEnde delta_L))
	         (print delta_L)
	         (if (> delta_L delta_V_Lchb_AT) (TrEnde.set TrgEnde (delta_L delta_V_Lchb_AT)))
	     ))
	))
	
	; TEST
	; ******************************************************************
	; (setq AbtlFahnenLb_AT	(Traeger.get Tr_ID AbTeil lchbAtrgSteg))
	; (setq AbtlFahnenLb_HT	(Traeger.get Htrg AbTeil lchbAtrgSteg))
	; (Anbauteil.set AbtlFahnenLb_AT (Master 0))
	; (Anbauteil.set AbtlFahnenLb_HT (Master 1))
	; (Lochbild.set lchbAtrgSteg (e "0 15 85 0 0 0") (w0 0) (w1 0) (delta_w 50))
	; (Anbauteil.set AbtlFahnenLb_HT (delta_lr -70.0))


	; ******************************************************************
)

(defun calcLichtenAbst_Steg ()
	(setq	b_Stz 	(Traeger.get HTrg b)
			dlr_Stz	(Traeger.get HTrg delta_LR)
	)
	(setq	h_AT  (Traeger.get Tr_ID h)
			dv_AT (Traeger.get Tr_ID delta_V)
	)


	(setq AT_Ausrichtung 0)		; Ausrichtung 1 - nach aussen, -1 nach innen
	(setq Abst_AT_zu_HT_Achse 0.0)
	(setq SysAbstand 0.0)
	(if (= (Connect.get CastaData vAtr-sHtr) -1) (progn
		(setq Abst_AT_zu_HT_Achse (+ dv_AT dlr_Stz))
		(if (> Abst_AT_zu_HT_Achse 0) (setq AT_Ausrichtung -1))		; (AlertBox "AT-Oberflansch nach innen")
		(if (< Abst_AT_zu_HT_Achse 0) (setq AT_Ausrichtung  1))		; (AlertBox "AT-Oberflansch nach aussen")
		(if (< Abst_AT_zu_HT_Achse 0) (setq SysAbstand (- (- Abst_AT_zu_HT_Achse) (* 0.5 h_AT))))
		(if (> Abst_AT_zu_HT_Achse 0) (setq SysAbstand (-    Abst_AT_zu_HT_Achse  (* 0.5 h_AT))))
	))
	(if (= (Connect.get CastaData vAtr-sHtr)  1) (progn
		(setq Abst_AT_zu_HT_Achse (- dv_AT dlr_Stz))
		(if (> Abst_AT_zu_HT_Achse 0) (setq AT_Ausrichtung -1))		; (AlertBox "AT-Oberflansch nach innen")
		(if (< Abst_AT_zu_HT_Achse 0) (setq AT_Ausrichtung  1)) 	; (AlertBox "AT-Oberflansch nach aussen")
		(if (< Abst_AT_zu_HT_Achse 0) (setq SysAbstand (- (- Abst_AT_zu_HT_Achse) (* 0.5 h_AT))))
		(if (> Abst_AT_zu_HT_Achse 0) (setq SysAbstand (-    Abst_AT_zu_HT_Achse  (* 0.5 h_AT))))
	))
	(setq  lichterAbst (- SysAbstand (* 0.5 b_Stz)))
	(print lichterAbst)
	(print "<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<")
)


(defun calcFutterBlech (BLECH_ID ABST)
	(print ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>")
	(print "BERECHNE FUTTERBLECHDATEN")
	(setq b_at		(Traeger.get Tr_ID b)
				h_at		(Traeger.get Tr_ID h)
	)
	
	(setq b_ht		(Traeger.get Htrg b)
				s_ht		(Traeger.get Htrg s)
	)
	
	
	
	; Futterblechdicke
	(setq dp_futter ABST)
	
	; Breite
	(if (= (Connect.get CastaData amATFlansch) 1)	(setq bp_futter b_at))
	(if (= (Connect.get CastaData amATSteg) 1)		(setq bp_futter h_at))
	
	; Hhe
	(if (= (Connect.get CastaData anschlZwAtEnden) 0)
		(progn
			(setq hp_futter (- (* 0.5 b_ht) (* 0.5 s_ht)))
		)
		(progn
			(setq hp_futter b_ht)
		)
	)
	
	(Blech.set BLECH_ID	(hp hp_futter)
				(bp bp_futter)
				(dp dp_futter)
	)
	
	
	(print "<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<")
)



; -------------------------------------------------------------
; Setzt das Anbauteil fr das Blech
; -------------------------------------------------------------
(defun setAnbauteilWinkel_Steg (WINKEL_ID)
	(print ">-----------------------------------------------------------")
	(print "SETZE ANBAUTEIL BLECH Steg")
	
	; xPos
	(setq xPos_ht (Connect.get CastaData xPos_ht))
	
	(setq	h_Stz 	(Traeger.get HTrg h)
			b_Stz 	(Traeger.get HTrg b)
			t_Stz 	(Traeger.get HTrg t)
			s_Stz 	(Traeger.get HTrg s)
			r_Stz 	(Traeger.get HTrg r)
			dlr_Stz	(Traeger.get HTrg delta_LR)
	)
	(setq	h_AT  (Traeger.get Tr_ID h)
			dv_AT (Traeger.get Tr_ID delta_V)
	)

	; Anbauteil Winkel
	(setq r_winkel_at (Traeger.get Tr_ID r_winkel))
	(setq h_winkel_ht	(Connect.get CastaData hpttrg_hwinkel))
	(print h_winkel_ht)
	(print r_winkel_at)
	
	(setq r_winkel_blech (- h_winkel_ht r_winkel_at))
	
	(print r_winkel_blech)
	(setq r_winkel_blech 0.0)
	(if (= (Connect.get CastaData satr-lhtr) 1) (setq r_winkel_blech 180.0))
	
	; xPos am HT berechnen
	; ----------------------------------------------
	
	; Anteil der delta_v Verschiebung des Riegels an xPos des Fahnenbleches
	; ----------------------------------------------
	
;	Nicht erforderlich, da Vertikals Verschiebung in dieselbe Richtung gehen muss
;	Um es genau zu machen, msste der Rotationswinkel des AT noch bercksichtigt werden,
;	der dann dann 'anteil_delta_v_ht_xPos' zu 0 berechnen wrde.
;	(setq xPos_ht (- xPos_ht anteil_delta_v_ht_xPos))
	
	(print "Winkel hinzufgen")

	; Anbauteil Fahnenblech dem HT hinzufgen
	(if (= (Connect.get CastaData amHtStegLinks) 1)
		(Traeger.addabtl Htrg WINKEL_ID xPos_ht r_winkel_blech _winkel_steg_links_)
	)
	(if (= (Connect.get CastaData amHtStegRechts) 1)
		(Traeger.addabtl Htrg WINKEL_ID xPos_ht r_winkel_blech _winkel_steg_rechts_)
	)
	(Winkel.set WINKEL_ID (wAbst (* 0.5 b_Stz))
						  (l      h_Stz)
	)
	(setq def_SL_Laenge (+ lichterAbst h_at))
	(if (> def_SL_Laenge 100) (Winkel.set WINKEL_ID (Profil "L120*80*10")))
	(if (> def_SL_Laenge 120) (Winkel.set WINKEL_ID (Profil "L150*100*10")))
	(if (> def_SL_Laenge 150) (Winkel.set WINKEL_ID (Profil "L180*90*10")))
	(if (> def_SL_Laenge 180) (Winkel.set WINKEL_ID (Profil "L200*100*10")))
	(if (> def_SL_Laenge 100) (Winkel.set WINKEL_ID (Lage 1)))
	
	
	(print "<-----------------------------------------------------------")

)

(defun setWinkelLochbild (LCHB_ID WINKEL_ID)	
	(print ">-----------------------------------------------------------")
	(print "SETZE ANBAUTEIL LOCHBILD")

	(Lochbild.set Lchb_ID	;(lb_art  LbArt)
			(Anz_S    4)
			(S_Bez   "M12")
			(Guete   "4.6")
			(e       "0  20 80 0 0 0")
			(w       "0  0")
	)

	
	
	(setq	h_ht		(Traeger.get Htrg h)
			s_ht		(Traeger.get Htrg s)
			b_Ht		(Traeger.get Htrg b)
			s_Stz		(Traeger.get Htrg s)
			b_Stz		(Traeger.get Htrg b)
			delta_v_ht 	(Traeger.get Htrg delta_v)
	)
	
	(setq	delta_v_at	(Traeger.get Tr_ID delta_v)
			delta_lr_at	(Traeger.get Tr_ID delta_lr)
			s_AT		(Traeger.get Tr_ID s)
			h_AT		(Traeger.get Tr_ID h)
	)
;	(setq hp_FahnenBl	100) ; Dummy - Winkellnge, sofern erforderlich
	(setq t_Winkel	(Winkel.get WINKEL_ID dw))  ; Dummy - Winkeldicke


	(setq	xPos_ht 	(Connect.get CastaData xPos_ht))
	(setq	xPos_at 	(Connect.get CastaData xPos_at))
	
	
	; Lochbild HT
	(print "Lochbild in Winkel hinzufgen")
	(setq AbtlFahnenBl	(Traeger.get Htrg AbTeil WINKEL_ID))
	(Traeger.addabtl Htrg LCHB_ID xPos_ht 0.0 _fahnblLochbild_ AbtlFahnenBl)	
;	(Traeger.addabtl Htrg LCHB_ID xPos_ht 0.0 _winkel_fahnenlb_ AbtlFahnenBl)

	(Lochbild.set Lchb_ID	(KlemmL  (+ s_AT t_Winkel))
				(dxSKopf (* 1.0  t_Winkel))
	)

	(setq AbtlFahnenLb_HT	(Traeger.get Htrg AbTeil LCHB_ID))
	(Anbauteil.set AbtlFahnenLb_HT (Winkel 90.0)
				    (delta_v 0)
	)

	(print "Lochbild dem AT hinzufgen")
	(Traeger.addabtl Tr_ID LCHB_ID xPos_At 0.0 _steglochbild_system_)	
	
	(setq AbtlFahnenLb_AT	(Traeger.get Tr_ID AbTeil LCHB_ID))

	
	(setq LB_RWinkel 0.0)


	(setq w1 (/ h_AT 4.0) w2 (* 2 w1))	; Default-Wert
	(setq ih_AT (* 1 h_AT))
	(if (= ih_AT 105) (setq w1 30 w2 45))
	(if (= ih_AT 120) (setq w1 35 w2 50))
	(if (= ih_AT 140) (setq w1 40 w2 60))
	(if (= ih_AT 150) (setq w1 40 w2 70))
	(if (= ih_AT 160) (setq w1 40 w2 80))
	(if (= ih_AT 180) (setq w1 50 w2 80))
	(if (= ih_AT 200) (setq w1 60 w2 80))
	(if (= ih_AT 250) (setq w1 60 w2 130))
	(if (= ih_AT 300) (setq w1 75 w2 150))
	
	(setq w2 (+ w2 w1))	; Da bei uns jeweils von der Lochbildmitte aus gemessen wird (hier fiktiven Mitte
	(setq e0 (/ b_Ht 4))
	(setq  wAbstand (- w2 w1))
	
	(setq wk1 lichterAbst)
	(setq wk2 (+ wk1 h_AT))

	(setq w1 (+ wk1 (* 0.5 h_AT) (* -0.5 wAbstand)))
	(setq w2 (+ wk1 (* 0.5 h_AT) (*  0.5 wAbstand)))
	
	(setq Sys_AT_Abst (+ (* 0.5 b_Stz) (- (* 0.5 s_Stz)) lichterAbst (* 0.5 h_AT)))
	(setq Sys_AT_Abst (+ lichterAbst (* 0.5 h_AT)))
	(Anbauteil.set AbtlFahnenLb_AT (delta_lr (- Sys_AT_Abst)))
	
	(Lochbild.set Lchb_ID
			(e       "0  0 0 0 0 0")
			(e0	 e0)
			(w0     w1)
			(w1     w2)
	)

	; AT_Ausrichtung  - (1) Oberflansch nach aussen   (-1) Oberflansch nach innen
	; Steg Seite 
	; Ende des AT
	(setq LchbFall 0)
	(if (= (Connect.get CastaData amhtstegrechts ) 1) (progn
		(if (= (Connect.get CastaData linkesEnde ) 1) (progn
			(if (= AT_Ausrichtung -1) (progn
				(setq LchbFall 1)
				(print AT_Ausrichtung)
				(print "am Ht Steg rechts")
				(print "am Ht Steg rechts")
				(Anbauteil.set AbtlFahnenLb_AT (SeitRicht -1))
				(Anbauteil.set AbtlFahnenLb_AT (delta_lr Sys_AT_Abst))
			))
			(if (= AT_Ausrichtung 1) (progn
				(setq LchbFall 3)
				(Anbauteil.set AbtlFahnenLb_HT (Winkel 270))
			))
		))
		(if (= (Connect.get CastaData rechtesEnde ) 1) (progn
			(if (= AT_Ausrichtung 1) (progn
				(setq LchbFall 2)
				(Anbauteil.set AbtlFahnenLb_AT (Winkel 180))
				(Anbauteil.set AbtlFahnenLb_AT (SeitRicht -1))
				(Anbauteil.set AbtlFahnenLb_AT (delta_lr Sys_AT_Abst))
			))
			(if (= AT_Ausrichtung -1) (progn
				(setq LchbFall 4)
				(Anbauteil.set AbtlFahnenLb_AT (Winkel 180))
				(Anbauteil.set AbtlFahnenLb_HT (Winkel 270))
			))
		))
		(if (= (Connect.get CastaData AnschlZwATEnden) 1) (progn
			(if (= (Connect.get CastaData at-von-unten) 1) (progn
				(if (= AT_Ausrichtung 1) (progn
					(setq LchbFall 9)
					(Anbauteil.set AbtlFahnenLb_HT (Winkel 270))
				))
				(if (= AT_Ausrichtung -1) (progn
					(setq LchbFall 15)
					(Anbauteil.set AbtlFahnenLb_AT (Winkel 180))
					(Anbauteil.set AbtlFahnenLb_HT (Winkel 270))
				))
			))
			(if (= (Connect.get CastaData at-von-oben) 1) (progn
				(if (= AT_Ausrichtung  1) (progn
					(setq LchbFall 16)
					(Anbauteil.set AbtlFahnenLb_HT (Winkel 270))
				))
				(if (= AT_Ausrichtung -1) (progn
					(setq LchbFall 10)
					(Anbauteil.set AbtlFahnenLb_AT (SeitRicht -1))
					(Anbauteil.set AbtlFahnenLb_AT (delta_lr Sys_AT_Abst))
				))
			))
		))
	))
	(if (= (Connect.get CastaData amhtstegLinks ) 1) (progn
		(if (= (Connect.get CastaData linkesEnde ) 1) (progn
			(if (= AT_Ausrichtung 1) (progn
				(setq LchbFall 6)
				(Anbauteil.set AbtlFahnenLb_AT (SeitRicht -1))
			))
			(if (= AT_Ausrichtung -1) (progn
				(setq LchbFall 8)
				(Anbauteil.set AbtlFahnenLb_AT (delta_lr Sys_AT_Abst))
				(Anbauteil.set AbtlFahnenLb_HT (Winkel 270))
			))
		))
		(if (= (Connect.get CastaData rechtesEnde ) 1) (progn
			(if (= AT_Ausrichtung 1) (progn
				(setq LchbFall 5)
				(Anbauteil.set AbtlFahnenLb_AT (delta_lr Sys_AT_Abst))
				(Anbauteil.set AbtlFahnenLb_AT (Winkel 180))
				(Anbauteil.set AbtlFahnenLb_HT (Winkel 270))
			))
			(if (= AT_Ausrichtung -1) (progn
				(setq LchbFall 7)
				(Anbauteil.set AbtlFahnenLb_AT (SeitRicht -1))
				(Anbauteil.set AbtlFahnenLb_AT (Winkel 180))
			))
		))
		(if (= (Connect.get CastaData AnschlZwATEnden) 1) (progn
			(if (= (Connect.get CastaData at-von-unten) 1) (progn
				(if (= AT_Ausrichtung -1) (progn
					(setq LchbFall 11)
					(Anbauteil.set AbtlFahnenLb_AT (delta_lr Sys_AT_Abst))
					(Anbauteil.set AbtlFahnenLb_HT (Winkel 270))
				))
				(if (= AT_Ausrichtung 1) (progn
					(setq LchbFall 14)
					(Anbauteil.set AbtlFahnenLb_AT (SeitRicht -1))
					(Anbauteil.set AbtlFahnenLb_HT (Winkel 270))
				))
			))
			(if (= (Connect.get CastaData at-von-oben) 1) (progn
				(if (= AT_Ausrichtung 1) (progn
					(setq LchbFall 12)
					(Anbauteil.set AbtlFahnenLb_AT (Winkel 180))
					(Anbauteil.set AbtlFahnenLb_AT (delta_lr Sys_AT_Abst))
					(Anbauteil.set AbtlFahnenLb_HT (Winkel 270))
				))
				(if (= AT_Ausrichtung -1) (progn
					(setq LchbFall 13)
					(Anbauteil.set AbtlFahnenLb_AT (delta_lr Sys_AT_Abst))
				))
			))
		))
	))
	; Nachbearbeitung, wenn hngend an der Sttze vorliegend
	(if (= (Connect.get CastaData satr-lhtr) -1) (progn
			(print "Nachbearbeitung")
			(setq HT_Abtl_Wnkl (Anbauteil.get AbtlFahnenLb_HT Winkel))
			(if (= HT_Abtl_Wnkl 270) (Anbauteil.set AbtlFahnenLb_HT (Winkel (- HT_Abtl_Wnkl 180.0))))
			(if (= HT_Abtl_Wnkl  90) (Anbauteil.set AbtlFahnenLb_HT (Winkel (+ HT_Abtl_Wnkl 180.0))))
			
	))
	
	
	
	(if (= LchbFall 0) (AlertBox "Fall noch nicht erfasst"))

	; (Anbauteil.set AbtlFahnenLb_AT (Winkel 180))
	; (Anbauteil.set AbtlFahnenLb_HT (Winkel 270))

	; (Lochbild.set Lchb_ID (w1 0))

	
	(if (= (Connect.get CastaData AnschlZwATEnden) 1) (progn
		(setq e0 (- e0) e1 (* 2 e0))
		(if (< e1 0) (setq e1 (- e1)))
		(Lochbild.set Lchb_ID (e0 e0) (e1 e1))
	))

	; Develop-Zwecke ....
	; (Lochbild.set Lchb_ID
	; 		(e       "0  40 160 0 0 0")
	; 		(w       "0  60")
	; )

	(Anbauteil.set AbtlFahnenLb_HT (Master 0))
	(Anbauteil.set AbtlFahnenLb_AT (Master 1))

)


(defun sucheWinkelAnbauteil ()

  (print "suche Winkel")

  (setq xPos_HT (Connect.get CastaData xPos_HT))
  (setq gesKnoBlTyp 0) ; auf unknown setzen
  (if (= (connect.get CastaData amHtStegLinks)    1)  (setq gesKnoBlTyp _winkel_steg_links_))
  (if (= (connect.get CastaData amHtStegRechts)   1)  (setq gesKnoBlTyp _winkel_steg_rechts_))

  ; Flansche gehen vor, weil es auch vorbeilaufende Trger gibt.
  ; Deswegen in dieser Reihenfolge. - Aber hier sollte noch ein Flag eingefhrt werden
  ; vorbeilaufend oder hnlich, damit der Fall eindeutig identifiziert wird.
  (if (= gesKnoBlTyp 0) (progn
	  (if (= (connect.get CastaData amHtOberFlansch)  1)  (setq gesKnoBlTyp _winkel_oberflansch_))
	  (if (= (connect.get CastaData amHtUnterFlansch) 1)  (setq gesKnoBlTyp _winkel_unterflansch_))
   ))

  (setq abtl_Wnkl (Traeger.get Htrg firstAbtl WinkelAnbauteil (- xPos_HT 0.5) (+ xPos_HT 0.5)))
  (while abtl_Wnkl
  	(setq sType     (Anbauteil.get abtl_Wnkl is_type gesKnoBlTyp))
  	(if (= sType 1) (progn
	    (print "Winkel gefunden -----------------------------------------------------")
	    (print sType)

;	    (showAbtlDaten abtl_Wnkl)	;; nur zu Entwicklungszwecken

;	    (setq afl_wnkl (Connect.get CastaData at_laengswinkel))

	    (setq WinkelAnbauteil_Gefunden (Anbauteil.get abtl_Wnkl Objekt Blech))
	    (setq xPosVorh (Anbauteil.get abtl_Wnkl xPos))
	    (setq Wnkl_Vorhanden 1)
	))
  	(setq abtl_Wnkl (Traeger.get Htrg nextAbtl FahnenBlech))
  )
  (setq abtl_Wnkl_T (Traeger.get Htrg firstAbtl WinkelAnbauteil_Gefunden (- xPos_HT 0.1) (+ xPos_HT 0.1)))
  (if (existObj WinkelAnbauteil_Gefunden) (progn
	  (if (existObj abtl_Wnkl_T)
	      (print  "OK - Objekt gefunden und passt");
	      (alertBox "Winkel wurde mit einer greren Toleranz eingesetzt!\nBitte die Schraubenlngen nach nderung der Blechdicke berprfen!"  "NOTE_PlateThickness_BoltLength");
	  )
  ))

)
