(defun init-traegerenden ()
	
	; Entwicklungshilfen
	; ----------------------------------------------
	(Connect.showAttributes CastaData)
	
	(if (= (Connect.get CastaData linkesEnde) 1)	(setq AT_Ende (Traeger.get Tr_ID links)))
	(if (= (Connect.get CastaData rechtesEnde) 1)	(setq AT_Ende (Traeger.get Tr_ID rechts)))
			
	; alles zurcksetzen
	; ----------------------------------------------
	(resetAtEnde AT_Ende)
	
	; Berechnung des Winkels am Ende des AT
	; ----------------------------------------------
	(calcTrEndeWnkl_AT)
	
	; Profilunterscheidung
	; ----------------------------------------------
	(setq qsform_ht (Traeger.get Htrg qsform))
	
	(if (= qsform_ht "I")	(behandelAusklinkungen))
	(if (= qsform_ht "U")
		(if (= (Connect.get CastaData amHtStegRechts) 1)	(behandelAusklinkungen))
	)
	(if (= qsform_ht "L")
		(if (= (Connect.get CastaData amHtStegRechts) 1)	(behandelAusklinkungen))
	)
		
	; Ablngung des AT berechnen
	; ----------------------------------------------
	(calcTrEndeAblng_AT)
)


; *************************************************************************************************
; fhrt die berprfung und Berechnung der Ausklinkungen durch
; *************************************************************************************************
(defun behandelAusklinkungen ()
	
	(setq AUSKlINKUNG 1)
	; prfen, ob Ausklinkung oder Coupon
	; ----------------------------------------------
	(checkForAusklinkung) ; => AUSKlINKUNG

	(print AUSKlINKUNG)
	
	; Ausklinkungen berechnen
	; ----------------------------------------------
	(if (= AUSKLINKUNG 1)
		(progn		
			(berechneAusklinkungTrg AT_Ende 10.0)
		)
		(progn
			(alertbox "Aufgrund der gegenseitigen Lage der Trger ist eine Ausklinkung nicht mehr sinnvoll.\nBitte verwenden Sie einen alternativen Anschluss, z.B. einen Coupon." "ERR_NotchTooLarge")
		)
	)
)


; ---------------------------------------------------------------------------------------
; Berechnet die Winkel des Traegerendes fr den AT
; ---------------------------------------------------------------------------------------
(defun calcTrEndeWnkl_AT ()
	(print "Berechne Abschrgung des Trgerendes")
	(print ">-------------------------------------------------------------------------------")
	
	; Trgerende des AT bestimmen
	(if (= (Connect.get CastaData linkesEnde) 1)	(setq AT_Ende (Traeger.get Tr_ID links)))
	(if (= (Connect.get CastaData rechtesEnde) 1)	(setq AT_Ende (Traeger.get Tr_ID rechts)))
	
	; Anschlusswinkel
	(setq vAtEndWnkl 	(Connect.get CastaData v-atrgewnkl_steg)
				hAtEndWnkl	(Connect.get CastaData h-atrgewnkl_steg)
	)
	(print vAtEndWnkl)
	(print hAtEndWnkl)
		
	; Winkel
	; ---------------------------------------------
	(setq v_winkel_ende vAtEndWnkl)
	(setq h_winkel_ende hAtEndWnkl)
	
	(TrEnde.set At_Ende (v_winkel v_winkel_ende))
	(TrEnde.set At_Ende (h_winkel h_winkel_ende))
	(print "<-------------------------------------------------------------------------------")
)


; ----------------------------------------------------------------------------------------
; Berechnet das Trgerende des Anschlusstrgers
; ----------------------------------------------------------------------------------------
(defun calcTrEndeAblng_AT ()
	(print "------------------------------------------------------------")
	(print "BERECHNE AT-ENDE")
	(print "KONTROLLE")
	
  (if (= (Connect.get CastaData linkesEnde) 1)	(setq AT_Ende (Traeger.get Tr_ID links)))
	(if (= (Connect.get CastaData rechtesEnde) 1)	(setq AT_Ende (Traeger.get Tr_ID rechts)))

	(setq at_v_winkel (Connect.get CastaData at_laengswinkel))
	(setq at_h_winkel (Connect.get CastaData at_rotawinkel))
	
	(setq s_ht 				(Traeger.get Htrg s)
				b_ht				(Traeger.get Htrg b)
				delta_lr_ht	(Traeger.get Htrg delta_lr)
				qsform_ht		(Traeger.get Htrg qsform)
	)
	;(print qsform_ht) 
	
	(TrEnde.set AT_Ende (delta_l 0.0))
	
	
	; Ablngung
	; ----------------------------------------------
	(setq delta_l_ende 0.0)
	
	(if (= qsform_ht "K")	(setq delta_l_ende (* 0.5 b_ht)))
	(if (= qsform_ht "U")	
		(progn
			(if (= AUSKLINKUNG 1)
				(setq delta_l_ende s_ht)
				(setq delta_l_ende b_ht)
			)
		)
	)
	(if (= qsform_ht "I")
		(progn
			(if (= AUSKLINKUNG 1)
				(setq delta_l_ende (* 0.5 s_ht))
				(setq delta_l_ende (* 0.5 b_ht))
			)
		)
	)
	(if (= qsform_ht "L")
		(progn
			(if (= AUSKLINKUNG 1)
				(setq delta_l_ende s_ht)
				(setq delta_l_ende 0.0)
			)
		)
	)
	
	(if (= (Connect.get CastaData amHtStegLinks) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)	(setq delta_l_ende (- delta_l_ende delta_lr_ht)))
			(if (= (Connect.get CastaData rechtesEnde) 1)	(setq delta_l_ende (- delta_l_ende delta_lr_ht )))
		)
	)
	(if (= (Connect.get CastaData amHtStegRechts) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)	(setq delta_l_ende (+ delta_lr_ht delta_l_ende)))
			(if (= (Connect.get CastaData rechtesEnde) 1)	(setq delta_l_ende (+ delta_lr_ht delta_l_ende)))
		)
	)
	
		
	; Anteil bei geneigtem und verschobenem AT
	(setq delta_v_at 	(Traeger.get Tr_ID delta_v)
				delta_lr_at	(Traeger.get Tr_ID delta_lr)
	)
	(print at_v_winkel)
	(print at_h_winkel)
	(setq tanAFL_v (tan (/ (* PI at_v_winkel) 180.0)))
	(setq cosAFL_v (cos (/ (* PI at_v_winkel) 180.0)))
	(print tanAFL_v)
	(print cosAFL_v)
	(print delta_v_at)
	(print delta_lr_at)
	
	(setq anteil_delta_v_at 0)
	(setq anteil_delta_lr_at 0)
	
	;(if (/= tanAFL_v 0.0)
	;	(progn
	;		(setq anteil_delta_v_at (/ (* 1.0 delta_v_at) tanAFL_v))
	;		(setq anteil_delta_lr_at (/ (* 1.0 delta_lr_at) tanAFL_v))
	;	)
	;)
	
	(setq anteil_delta_v_at (* (* 1.0 delta_v_at) cosAFL_v))
	(print anteil_delta_v_at)
		
	(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq anteil_delta (+ anteil_delta_v_at))	)
	(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq anteil_delta (- anteil_delta_v_at))	)		
	(if (= (Connect.get CastaData satr-lhtr)  1)	(setq anteil_delta (+ anteil_delta_lr_at))	)
	(if (= (Connect.get CastaData satr-lhtr) -1)	(setq anteil_delta (- anteil_delta_lr_at))	)
		
	(print anteil_delta_lr_at)
		
	;(TrEnde.set AT_Ende (delta_l anteil_delta))
	
	(print delta_l_ende)
	(print anteil_delta)
	
	(TrEnde.ptrim AT_Ende (+ delta_l_ende anteil_delta))
    
    
    
(if (= 1 2)	(progn
  	
	; KrzungsLnge
	; ----------------------------------------------
	(setq xKomp delta_l_ende)
	(print xKomp)
	
	(setq tanHW (tan (/ (* PI at_h_winkel) 180.0)))
	(print tanHW)
	
	(setq yKomp (* xKomp tanHW))
	(print yKomp)
	
	(setq xy (sqrt (+ (* xKomp xKomp) (* yKomp yKomp))))
	(print xy)
	
	(setq tanVW (tan (/ (* PI (- at_v_winkel 90.0)) 180.0)))
	(print tanHW)
	
	(setq zKomp (* xy tanVW))
	(print zKomp)
	
	(setq betrag (sqrt (+ (* xKomp xKomp) (* yKomp yKomp) (* zKomp zKomp))))
	(print betrag)
	
	(trende.set AT_Ende (delta_l betrag))
))
	(print "------------------------------------------------------------")
)



; *************************************************************************************************
; Berechnet die Ausklinkungen am Trgerende des AT
; *************************************************************************************************
(defun berechneAusklinkungTrg (TrgEnde abst)
	(print "------------------------------------------------------------")
	(print "BERECHNUNG DER AUSKLINKUNGEN")
		
	(setq h_at 				(Traeger.get Tr_ID h)
				b_at				(Traeger.get Tr_ID b)
				delta_lr_at	(Traeger.get Tr_ID delta_lr)
				delta_v_at	(Traeger.get Tr_ID delta_v)
				r_winkel_at	(Traeger.get Tr_ID r_winkel)
				hc_at				(Traeger.get Tr_ID hc)
				qsform_at		(Traeger.get Tr_ID qsform)
	)
	
	(setq h_ht				(Traeger.get Htrg h)
				b_ht				(Traeger.get Htrg b)
				hc_ht				(Traeger.get Htrg hc)
				r_ht				(Traeger.get Htrg r)
				t_ht				(Traeger.get Htrg t)
				s_ht				(Traeger.get Htrg s)
				delta_v_ht	(Traeger.get Htrg delta_v)
				qsform_ht		(Traeger.get Htrg qsform)
	)
	
	; Orientierung ermitteln
	; 	0 = Flansche parallel
	;		1 = Flansche kreuzen
	(if (= (Connect.get CastaData satr-vhtr)  1)	(setq ori 1))
	(if (= (Connect.get CastaData vatr-vhtr)  1)	(setq ori 0))
	(if (= (Connect.get CastaData satr-vhtr) -1)	(setq ori 1))
	(if (= (Connect.get CastaData vatr-vhtr) -1)	(setq ori 0))
	
	(print ori)
	
	; Berechnen der 4 Linien - TrgerOK, TrgerUK, obere Ausrundungslinie, untere Ausrundungslinie
	(setq zOK_HProf (- delta_v_ht (* 0.5 h_ht))		; Oberkante der Profile (neg. nach oben)
        zOK_AProf (- delta_v_at (* 0.5 h_at))
  )
	(if (= qsform_ht "L")	(setq zOK_HProf (- delta_v_ht 1000000)))
	
	(print zOK_HProf)
	(print zOK_AProf)
	
	(setq zUK_HProf (+ zOK_HProf h_ht)				; Unterkante der Profile (neg. nach oben)
        zUK_AProf (+ zOK_AProf h_at)
  )
	(if (= qsform_ht "L")	(setq zUK_HProf delta_v_ht))
	(print zUK_HProf)
	(print zUK_AProf)
	
  ; obere Ausrundung der Profile
	(setq okAusr_Ht (+ zOK_HProf (* 0.5 (- h_ht hc_ht)))
		    okAusr_At (+ zOK_AProf (* 0.5 (- h_at hc_at)))
	)
	(if (= qsform_ht "L")	(setq okAusr_Ht (+ zOK_HProf 5.0)))
	
	(setq ukAusr_Ht (+ okAusr_Ht hc_ht)	; untere Ausrundung der Profile
		    ukAusr_At (+ okAusr_At hc_at)
	)
	(if (= qsform_ht "L")	(setq ukAusr_Ht (- zUK_HProf (+ 5.0 t_ht))))
	
	
	; linke und rechte Seite des AT
	(setq liKante_At (- (* 0.5 b_at)))
	(setq reKante_At (+ liKante_At b_at))
	(print liKante_At)
	(print reKante_At)
	
	; Bercksichtigung der AT_Rotation fr linke und rechte Seite des AT
	(setq h_at_halb (* 0.5 h_at))
	(setq b_at_halb (* 0.5 b_at))
	
	(setq diagonale (sqrt (+ (* h_at_halb h_at_halb) (* b_at_halb b_at_halb))))
	(print diagonale)
	
	(setq t_alpha_rad (acos (/ b_at_halb diagonale)))
	(print t_alpha_rad)
	
	(setq t_alpha_grad (/ (* t_alpha_rad 180.0) PI))
	(print t_alpha_grad)
	
	(setq wnkl (+ t_alpha_grad r_winkel_at))
	(print wnkl)
	
	(setq cosWW (cos (/ (* PI wnkl) 180.0)))
	(print cosWW)
	
	(setq x_neu (* diagonale cosWW))
	(print x_neu)
		
	
	(setq reKante_At x_neu)
	(setq liKante_At (- x_neu))
	(print liKante_At)
	(print reKante_At)
	
	; Anteil delta_lr AT
	
	(setq cosRotW (cos (/ (* PI r_winkel_at) 180.0)))
	
	(setq anteil_dlr_at (* delta_lr_at cosRotW))
	
	(setq liKante_At (+ liKante_At anteil_dlr_at))
	(setq reKante_At (+ reKante_At anteil_dlr_at))
	
	(print liKante_At)
	(print reKante_At)
	
	
	(if (= qsform_at "U")
		(progn
			(setq liKante_At delta_lr_at)
			(setq reKante_At (+ liKante_At b_at))
		)
	)
	
	(print zOK_HProf)
	(print zUK_HProf)
	(print okAusr_Ht)
	(print ukAusr_Ht)
	(print zOK_AProf)
	(print zUK_AProf)
	(print okAusr_At)
	(print ukAusr_At)
	(print liKante_At)
	(print reKante_At)
	
	
	; parallele Flansche (wie UZ-UZ)
	(if (= ori 0)
		(progn
			; Prfung, ob Ausklinkung notwendig ist
			; +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
			(print "FLANSCHE PARALLEL")
  		(setq diff_zakl 0.0)
			(setq xakl 0.0)
		  ; Berechnung der oberen Ausklingungshhe
			; zAkl
			; Erfordlich, wenn OK des Anschlussprofils oberhalb der Ausrundungslinie des
			; Haupttrgerprofils liegt
		  (if (<= zOK_AProf okAusr_ht) 
		  	(progn
					(print "Oben ist eine Ausklinkung erforderlich")
		   		(setq	zAkl1 (+  (- zOK_AProf) okAusr_Ht)
		        		zAkl2 (+  (- zOK_AProf) okAusr_At)
		   		)
		   
		   		(if (> zAkl1 zAkl2)
		   			(progn
		      		(setq zAkl zAkl1)
		      		(setq diff_zakl (- zAkl1 zAkl2))
		      	)
		      	(progn
		       		(setq zAkl zAkl2)
		       		(setq diff_zakl (- zAkl2 zAkl1))
		      	)
		   		)
		   		(setq xakl (+ (- (* 0.5 (- s_ht b_ht))) abst))
					(if (= qsform_ht "U") (setq xakl (+ (- (- s_ht b_ht)) abst)))
		   		(if (< zAkl 0) 
		   			(progn
		   				(setq zAkl 0)
		   				(setq xakl 0)
		   			)
		   		)		; Keine Ausklinkung erforderlich
		    ); progn
		   	(progn
		    	(print "Oben ist keine Ausklinkung oben erforderlich")
		      (setq zAkl 0)
		      
		    )
		  )
  
		  ; Berechnung der unteren Ausklinkung
			; Ist diese Ausklinkung  unten erforderlich?
			; Nur dann, wenn UK Profil oberhalb der unteren Ausrundungslinie liegt
		  (if (> zUK_AProf ukAusr_Ht) 
		  	(setq U_AKL_erforderlich 1)
		   	(setq U_AKL_erforderlich 0)
		  )   
   
   		(setq hSteg 0.0)
		  (if (= U_AKL_erforderlich 1) 
		   	(progn
		   		(print "Unten ist eine Ausklinkung erforderlich")
		   		; die Hhen nach unten sind negativ. Deswegen den kleineren Wert suchen
		   		(if (< ukAusr_Ht ukAusr_At) 
		   			(setq ukRelevant ukAusr_Ht)
		   			(setq ukRelevant ukAusr_At)
					)
					(setq untereAkl (- h_at ukRelevant))
					(setq hSteg (- h_at untereAkl (+ zAkl zOK_AProf)))
					(setq xakl (+ (- (* 0.5 (- s_ht b_ht))) abst))
					(if (= qsform_ht "L") (setq xakl (+ (- b_ht s_ht) abst)))
		    )
		    (progn
		   		(print "Unten ist keine Ausklinkung erforderlich!")
		    )
		  )
	
			(setq yakl 0.0)
			(setq bflansch 0.0)
			
			; Neigung bercksichtigen
			; ------------------------------------------
			(setq h_wnkl_at	(Connect.get CastaData h-atrgewnkl_steg))
			(print h_wnkl_at)
			
			(setq sinW	(sin (/ (* PI h_wnkl_at) 180.0)))
			(print sinW)
			
			(print xakl)
			(setq xakl (/ xakl sinW))
			(print xakl)
			
		);PROGN ENDE
	); IF ENDE
		
		
		
	(if (= ori 1)
		(progn
			(print "FLANSCHE KREUZEN")
			(print "------------------------------------")
			(print zOK_HProf)
			(print zUK_HProf)
			(print "---------")
			(print okAusr_Ht)
			(print ukAusr_Ht)
			(print liKante_At)
			(print reKante_At)
			
			
			
			; Absolutbetrge
			(if (< okAusr_Ht 0.0)
				(setq okAusr_Ht_abs (- okAusr_Ht))
				(setq okAusr_Ht_abs okAusr_Ht)
			)
			(if (< ukAusr_Ht 0.0)
				(setq ukAusr_Ht_abs (- ukAusr_Ht))
				(setq ukAusr_Ht_abs ukAusr_Ht)
			)
			(if (< liKante_At 0.0)
				(setq liKante_At_abs (- liKante_At))
				(setq liKante_At_abs liKante_At)
			)
			(if (< reKante_At 0.0)
				(setq reKante_At_abs (- reKante_At))
				(setq reKante_At_abs reKante_At)
			)
			(print "---------")
			(print okAusr_Ht_abs)
			(print ukAusr_Ht_abs)
			(print liKante_At_abs)
			(print reKante_At_abs)
			
			(print hc_ht)
			
			(setq xakl 0)
			
			(if (= (Connect.get CastaData satr-vhtr)  1)
				(progn
					(if (<= liKante_At okAusr_ht) 
				  	(progn
							(print "links ist eine Ausklinkung erforderlich")
				   		(setq	yAkl (+  (- liKante_At) okAusr_Ht))
				   		(print yakl)
				   		(setq xakl (+ (- (* 0.5 (- s_ht b_ht))) abst))
							(if (= qsform_ht "U") (setq xakl (+ (- (- s_ht b_ht)) abst)))
				   		(print xakl)
				   		(if (< yAkl 0); Keine Ausklinkung erforderlich
				   			(progn
				   				 (setq yAkl 0)
				   				 (setq xakl 0)
				   			)
				   		)		
				    ); progn
				   	(progn
				    	(print "links ist keine Ausklinkung erforderlich")
				      (setq yAkl 0)
				    )
				  )
		  
				  (if (> reKante_At ukAusr_Ht) 
				  	(setq RE_AKL_erforderlich 1)
				   	(setq RE_AKL_erforderlich 0)
				  )   
		   
		   		(setq bFlansch 0)
				  (if (= RE_AKL_erforderlich 1) 
				   	(progn
				   		(print "rechts ist eine Ausklinkung erforderlich")
				   		(setq xakl (+ (- (* 0.5 (- s_ht b_ht))) abst))
							(if (= qsform_ht "U") (setq xakl (+ (- (- s_ht b_ht)) abst)))
				   		(setq rechteAkl (- reKante_At_abs ukAusr_Ht_abs))
				   		(print rechteAkl)
							;(setq bflansch (- b_at rechteAkl (+ yAkl reKante_At)))
							(setq bflansch (- b_at rechteAkl yAkl ))
							(print bflansch)
				    )
				    (progn
				   		(print "rechts ist keine Ausklinkung erforderlich!")
				    )
				  )
				)
			)
			(if (= (Connect.get CastaData satr-vhtr) -1)
				(progn
					(setq bflansch 0)
					(if (>= reKante_At_abs okAusr_ht_abs) 
				  	(progn
							(print "rechts ist eine Ausklinkung erforderlich")
				   		(setq rechteAkl (- reKante_AT_abs okAusr_ht_abs))
				   		(print rechteAkl)
				   		
				   		(setq bflansch (- b_at rechteAkl))
				   		(print bflansch)
				   		(setq yAkl 0)
				   		(print yAkl)
				   		(setq xakl (+ (- (* 0.5 (- s_ht b_ht))) abst))
							(if (= qsform_ht "U") (setq xakl (+ (- (- s_ht b_ht)) abst)))
				    ); progn
				   	(progn
				    	(print "rechts ist keine Ausklinkung erforderlich")
				    	(setq yAkl 0)
				    	(setq xakl 0)
				    )
				  )
		  
				  (if (> liKante_At_abs ukAusr_Ht_abs) 
				  	(setq LI_AKL_erforderlich 1)
				   	(setq LI_AKL_erforderlich 0)
				  )
				  
				  (if (= LI_AKL_erforderlich 1)
				  	(progn
				  		(print "links ist eine Ausklinkung erforderlich")
				  		(setq yAkl (- liKante_At_abs ukAusr_Ht_abs))
				  		(setq xakl (+ (- (* 0.5 (- s_ht b_ht))) abst))
							(if (= qsform_ht "U") (setq xakl (+ (- (- s_ht b_ht)) abst)))
							(setq bflansch (- b_at rechteAkl yAkl ))
							(print bflansch)
				  	)
				  	(progn
				  		(print "links ist keine Ausklinkung erforderlich")
				  		(setq yAkl 0)
				  		
				  	)
				  ) 
				)
			)
			
			
			
			(setq zakl 0)
			(setq hsteg 0)
			
			
			; Neigung bercksichtigen
			; ------------------------------------------
			(setq v_wnkl_at	(Connect.get CastaData v-atrgewnkl_steg))
			(print v_wnkl_at)
			
			(setq sinW	(sin (/ (* PI v_wnkl_at) 180.0)))
			(print sinW)
			
			(print xakl)
			(setq xakl (/ xakl sinW))
			(print xakl)
		)
	)
	
		
	(print xakl)
	(print yakl)
	(print zakl)
	(print hsteg)
		
	(if xakl 			(trende.set TrgEnde (xakl 			xAKL)))
	(if yakl 			(trende.set TrgEnde (yakl 			yakl)))
	(if zakl 			(trende.set TrgEnde (zakl 			zakl)))
	(if hsteg 		(trende.set TrgEnde (hsteg 			hsteg)))
	(if bflansch 	(trende.set TrgEnde (bflansch 	bflansch)))
	
	  
  (print "------------------------------------------------------------")
)

; *************************************************************************************************
; berprft, ob eine Ausklinkung verwendet werden soll oder besser ein Coupon
; anhand der Trgerlage
; wenn sich die Flansche kreuzen, ist eine Neigung um die vertikale AT-Achse erlaubt,
; wenn die Flansche parallel liegen, ist eine Neigung um die horiz. Achse erlaubt.
; *************************************************************************************************
(defun checkForAusklinkung ()
	(print ">------------------------------------------------------------------------------")
	(print "Ausklinkung oder Coupon")
	
	(setq h_wnkl_at (Connect.get CastaData h-atrgewnkl_steg))
	(setq v_wnkl_at (Connect.get CastaData v-atrgewnkl_steg))
	(print h_wnkl_at)
	(print v_wnkl_at)
	
	
(if (= 1 2)	(progn
	(if (= (Connect.get CastaData satr-vhtr)  1)
		(progn
			(print "FLANSCHE KREUZEN")
			(if (/= (Connect.get CastaData vatr-vhtr) 0)
				(progn
					(setq AUSKLINKUNG 0)
				)
				(progn
					(if (= h_wnkl_at 90.0) ; bei den Winkeln wre es besser einen Toleranzbereich von ca. 2 zuzulassen.
						(setq AUSKLINKUNG 1)
						(setq AUSKLINKUNG 0)
					)
				)
			)
		)
	)
	(if (= (Connect.get CastaData satr-vhtr) -1)	
		(progn
			(if (/= (Connect.get CastaData vatr-vhtr) 0)	
				(progn
					(setq AUSKLINKUNG 0)
				)
				(progn
					(if (= h_wnkl_at 90.0)
						(setq AUSKLINKUNG 1)
						(setq AUSKLINKUNG 0)
					)
				)
			)
		)
	)
	(if (= (Connect.get CastaData satr-vhtr)  0)
		(progn
			(if (/= (Connect.get CastaData vatr-vhtr) 0)
				(progn
					(if (= v_wnkl_at 90.0)
						(setq AUSKLINKUNG 1)
						(setq AUSKLINKUNG 0)
					)
				)
				(progn
					(setq AUSKLINKUNG 0)
				)
			)
		)
	)
))

	
	(print AUSKLINKUNG)
	(print "<------------------------------------------------------------------------------")
)


; *************************************************************************************************
; setzt die bereits vorhandene Ausklinkungswerte auf die Ausgangslage (0.0) zurck
; *************************************************************************************************
(defun resetAtEnde (TrgEnde)
	(TrEnde.set TrgEnde (xakl 		0.0)
											(yakl			0.0)
											(zakl  		0.0)
											(hsteg 		0.0)
											(bflansch 0.0)
											(delta_l  0.0)
	)
)