; $	HT	QT(IUK)		 	AF(S)		P(EZ)
; $ AT	QT(IUTLF)	AF(K)		P(E)
; $	AE	V(-)				H(-)		R(-)

; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;
;	
; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
(defun load-modules ()
   (load "mod-add-schweiss-querschn")
)


(defun init-connection ()

	(print "*clear*")
	(print "Neuer Anschluss")

	(connect.showattributes CastaData)
	(setConnection)
)

(defun setConnection ()

	(setq TrgEnde nil)
	(if  (= (Connect.get CastaData linkesEnde) 1) (setq TrgEnde (Traeger.get Tr_ID links)))
	(if  (= (Connect.get CastaData rechtesEnde) 1) (setq TrgEnde (Traeger.get Tr_ID rechts)))
	
	(if TrgEnde (progn
		(reset_TrgEnde)
		(setTrgEndeWinkel_AT)
		(setTrgAblaengung_AT)
		(SchweissProfil_Einsetzen_St)
	))
	
)
(defun reset_TrgEnde ()
	(TrEnde.set TrgEnde 	(l_voute_oben 0)
							(h_voute_oben 0)
							(l_voute_unten 0)
							(h_voute_unten 0)
							(delta_L 0.0)
							(V_Winkel 90.0)
							(H_Winkel 90.0)
	)
)

(defun setTrgEndeWinkel_AT ()
	(setq W_H_Atr (Connect.get CastaData  h-atrgewnkl_steg))
	(setq W_V_Atr (Connect.get CastaData  v-atrgewnkl_steg))

	(TrEnde.set TrgEnde 
				(H_Winkel  W_H_Atr)
				(V_Winkel  W_V_Atr)
	)
)

(defun setTrgAblaengung_AT ()

	(setq alfa_V2 (TrEnde.get TrgEnde Alfa_V2))
	(setq alfa_H2 (TrEnde.get TrgEnde Alfa_H2))

	(setq cos_Alfa_H2  (cos (/ (* PI  alfa_H2) 180.0)))
	(setq cos_Alfa_V2  (cos (/ (* PI  alfa_V2) 180.0)))
	
	(setq qType_AT (Traeger.get HTrg qsForm))
	(if (= qType_AT "K") 
		(setq	abst_HT 			(Traeger.get HTrg b))
		(setq	abst_HT 			(Traeger.get HTrg t))
	)
	(setq	
				dlr_AT			(Traeger.get Tr_ID delta_LR)
				delta_LR_HT		(Traeger.get HTrg delta_LR)
	)

	(setq trim_H_HT (* 0.5  abst_HT))
	(if  (= (Connect.get CastaData linkesEnde) 1) (progn
		(if  (= (Connect.get CastaData  at-von-links) 1)  	(setq trim_H_HT (+ trim_H_HT  delta_LR_HT)))
		(if  (= (Connect.get CastaData  at-von-rechts) 1)  	(setq trim_H_HT (- trim_H_HT  delta_LR_HT)))
	))
	(if  (= (Connect.get CastaData rechtesEnde) 1) (progn
		(if  (= (Connect.get CastaData  at-von-links) 1)  	(setq trim_H_HT (- trim_H_HT  delta_LR_HT)))
		(if  (= (Connect.get CastaData  at-von-rechts) 1)  	(setq trim_H_HT (+ trim_H_HT  delta_LR_HT)))
	))
	(TrEnde.pTrim TrgEnde  trim_H_HT)
	
	(setq cosH_AT (cos (/ (* PI  W_H_Atr) 180.0)))
	(setq trim_dlr_AT (* cos_Alfa_H2  dlr_AT))	
	(if  (= (Connect.get CastaData linkesEnde) 1) (setq  trim_dlr_AT (- trim_dlr_AT)))
	(TrEnde.pTrim TrgEnde  trim_dlr_AT)

	(setq dv_AT (Traeger.get Tr_ID delta_V))
	(setq cosV_AT (cos (/ (* PI  W_V_Atr) 180.0)))
	(setq trim_dv_AT (* cos_Alfa_V2  dv_AT))		; hier mit Alfa_V2 berechnet
	(if  (= (Connect.get CastaData linkesEnde) 1) (setq  trim_dv_AT (- trim_dv_AT)))
	(TrEnde.pTrim TrgEnde  trim_dv_AT)
	
	
)
