; $	HT	QT(R)		AF(K)		P(E)
; $	AT	QT(R)		AF(K)		P(E)
; $ AE	V(-)		H(-)		R(-)

; ---------------------------------------------------------------------- */
(defun load-modules ()
   (load "mod-endinit-uz-stzgehrung")
)
; ---------------------------------------------------------------------- */
(defun init-connection ()

  (print "*clear*")
  (print "in init-connection - Gehrung an Stz-Ende");
  (setq Achsen_RotationsWinkel (Connect.get CastaData AT_rotawinkel))
  (setq Achsen_LaengsWinkel    (Connect.get CastaData AT_laengswinkel))

  (if (= (connect.get CastaData amAtSteg) 1) (progn
	(print "================ AM-AT-Steg========================")
  ))
  (if (= (connect.get CastaData amAtFlansch) 1) (progn
	(print "------------------ AM-AT-Flansch -------------------------")
  ))
  (if (= (connect.get CastaData amHtSteg) 1) (progn
	(print "================ AM-HT-Steg========================")
  ))
  (if (= (connect.get CastaData amHtFlansch) 1) (progn
	(print "------------------ AM-HT-Flansch -------------------------")
  ))
  (print "------------------------")
  (print Achsen_RotationsWinkel)
  (print Achsen_LaengsWinkel)


  (setzeTraegerEndWinkel)
  
  ; erst mal Workarounds
  (wa_Sonderfaelle)

  (print "-----------------------------------------------------")
  (Connect.showAttributes CastaData)
  
;   (Move)
;   (Berechne)

)
(defun setzeTraegerEndWinkel ()
  (if (= (Connect.get CastaData anHtLinkesEnde)  1) (setq HTrg_Ende (Traeger.get HTrg links)))
  (if (= (Connect.get CastaData anHtRechtesEnde) 1) (setq HTrg_Ende (Traeger.get HTrg rechts)))
  
  (if (= (Connect.get CastaData LinkesEnde)      1) (setq ATrg_Ende (Traeger.get Tr_ID links)))
  (if (= (Connect.get CastaData RechtesEnde)     1) (setq ATrg_Ende (Traeger.get Tr_ID rechts)))

  
  
  (setq RW (- 90.0 Achsen_RotationsWinkel))
  (if (> Achsen_RotationsWinkel 180.0) (setq RW (+ RW 180.0)))
  (print RW)
  
  (setq cos_RW (cos (* PI (/ RW 180.0))))
  (setq alpha_rad (acos (/ 1.0 (sqrt (+ (* cos_RW cos_RW) 1.0)))))
  (setq alpha (/ (* 180.0 alpha_rad) PI))
  (print alpha)

  (setq RW Achsen_RotationsWinkel)
  (print RW)
  (setq cos_RW (cos (* PI (/ RW 180.0))))
  (setq beta_rad (acos (/ 1.0 (sqrt (+ (* cos_RW cos_RW) 1.0)))))
  (setq beta (/ (* 180.0 beta_rad) PI))
  (print beta)


  
  (setq AT_VWinkel 90.0)
  (setq AT_HWinkel 45.0)
  (if (>= Achsen_RotationsWinkel 180.0) (setq AT_HWinkel (+ AT_HWinkel 90.0)))
  
  (setq HT_HWinkel (+ 90.0 alpha))
  (setq HT_VWinkel (+ 90.0 beta))
  (if (> Achsen_RotationsWinkel 180.0) (progn
	(print "Fall Achsen_RotationsWinkel > 180.0")
	(print alpha) (print beta)
	(setq HT_HWinkel (- 180.0 HT_HWinkel))
  ))
  (if (> Achsen_RotationsWinkel 90.0) (progn
	(if (< Achsen_RotationsWinkel 270.0) (progn
		(print "Fall Achsen_RotationsWinkel > 90.0 und < 270.0")
		(print alpha) (print beta)
		(setq HT_VWinkel (- 180.0 HT_VWinkel))
	))
  ))

  (if (= (connect.get CastaData  anhtlinkesende) 1) (progn
	(setq AT_HWinkel (- 180.0 AT_HWinkel))
	(setq HT_HWinkel (- 180.0 HT_HWinkel))
	(setq HT_VWinkel (- 180.0 HT_VWinkel))
  ))
  (if (= (connect.get CastaData  rechtesende) 1) (progn
	 (setq AT_HWinkel (+ 180.0 AT_HWinkel))
	 (if (> AT_HWinkel 180.0) (setq AT_HWinkel (- 360.0 AT_HWinkel)))
	 ; (AlertBox HT_HWinkel)
	 ; (AlertBox HT_VWinkel)
	 (setq HT_HWinkel (+ 180.0 HT_HWinkel))
	 (setq HT_VWinkel (+ 180.0 HT_VWinkel))
	 (if (> HT_HWinkel 180.0) (setq HT_HWinkel (- 360.0 HT_HWinkel)))
	 (if (> HT_VWinkel 180.0) (setq HT_VWinkel (- 360.0 HT_VWinkel)))
  ))

   (if (/=  achsen_laengswinkel 90.0) (progn
	 (print "Achsen_LaengsWinkel ist schrg -----------------------")
	 (print AT_HWinkel) (print AT_VWinkel)
	 (print HT_HWinkel) (print HT_VWinkel)

	 (setq wDiff 0.0)
	 (if (> achsen_laengswinkel 90.0) (setq wDiff (/ (- achsen_laengswinkel 90.0) 2.0)))
	 (if (< achsen_laengswinkel 90.0) (setq wDiff (/ (- 90.0 achsen_laengswinkel) 2.0)))
	 ; Der achsen_laengswinkel scheint nicht korrekt definiert zu sein.
	 ; wenn aber Definition gendert wird, mssen alls Makros durchsucht werden, wer den verwendet.
	 (setq V_AtrWKopf (Connect.get CastaData v-atrgewnkl_kopf))
	 (if (= (Connect.get CastaData amHTFlansch) 1) (if (= (Connect.get CastaData amATFlansch) 1) (progn
		(if (> V_AtrWKopf 90.0) (if (> Achsen_RotationsWinkel 90.0) (setq wDiff (- wDiff))))
	 )))
	 (if (= (Connect.get CastaData amHTSteg) 1) (if (= (Connect.get CastaData amATSteg) 1) (progn
		(if (> Achsen_RotationsWinkel 90.0) (setq wDiff (- wDiff)))
	 )))
	 
	 
	
	 (if (= (Connect.get CastaData amHTFlansch) 1) (setq HT_VWinkel (- HT_VWinkel wDiff)))
	 (if (= (Connect.get CastaData amHTFlansch) 1) (setq AT_HWinkel (+ AT_HWinkel wDiff)))

	 (if (= (Connect.get CastaData amHTSteg) 1) (if (= (Connect.get CastaData amATSteg) 1) (progn
		    (setq HT_HWinkel (- HT_HWinkel wDiff))
			(setq AT_HWinkel (+ AT_HWinkel wDiff))
	 )))
    ))

   ; Sonderfall
   
   (print "Sonderflle ------")
  (setq Sonderfall 0)
  (if (= Achsen_RotationsWinkel   0.0) (setq Sonderfall 1))
  (if (= Achsen_RotationsWinkel 180.0) (setq Sonderfall 1))
  (if (= Sonderfall 1) (progn
	(print "Sonderfall = 1")
	(if (= (connect.get CastaData  LinkesEnde) 1) (if (= (connect.get CastaData  anhtLinkesEnde) 1) (progn
		 (print "AT-links an HT-links")
		(if (= (connect.get CastaData  amAtOberflansch) 1) (setq AT_HWinkel (+ AT_HWinkel 90.0)))
		(if (= (connect.get CastaData  amAtStegLinks) 1) (setq AT_HWinkel (+ AT_HWinkel 90.0)))
	)))
	(if (= (connect.get CastaData  LinkesEnde) 1) (if (= (connect.get CastaData  anhtRechtesEnde) 1) (progn
		 (print "AT-links an HT-rechts")
		(if (= (connect.get CastaData  amAtUnterflansch) 1) (setq AT_HWinkel (+ AT_HWinkel 90.0)))
		(if (= (connect.get CastaData  amAtStegRechts) 1) (setq AT_HWinkel (+ AT_HWinkel 90.0)))
	)))
	(if (= (connect.get CastaData  RechtesEnde) 1) (if (= (connect.get CastaData  anhtRechtesEnde) 1) (progn
		 (print "AT-rechts an HT-rechts")
		(if (= (connect.get CastaData  amAtUnterflansch) 1) (setq AT_HWinkel (+ AT_HWinkel 90.0)))
		(if (= (connect.get CastaData  amAtStegRechts) 1) (setq AT_HWinkel (+ AT_HWinkel 90.0)))
	)))
	(if (= (connect.get CastaData  RechtesEnde) 1) (if (= (connect.get CastaData  anhtLinkesEnde) 1) (progn
		 (print "AT-rechts an HT-links")
		(if (= (connect.get CastaData  amAtOberflansch) 1) (setq AT_HWinkel (+ AT_HWinkel 90.0)))
		(if (= (connect.get CastaData  amAtStegLinks) 1) (setq AT_HWinkel (+ AT_HWinkel 90.0)))
	)))
	(if (> AT_HWinkel 180.0) (setq AT_HWinkel (- AT_HWinkel 180.0)))
	
;	(if (= (connect.get CastaData  LinkesEnde) 1) (setq AT_HWinkel (- 180.0 AT_HWinkel)))
  ))
  (if (= Achsen_RotationsWinkel 180.0) (progn
	(setq AT_HWinkel (- 180.0 AT_HWinkel))
  ))
  (if (= Sonderfall 2) (progn
	(AlertBox "Sonderfall = 2")
	(if (= (connect.get CastaData  anhtRechtesEnde) 1) (if (= (connect.get CastaData  amAtStegLinks) 1) (setq AT_HWinkel (+ AT_HWinkel 90.0))))
	(if (= (connect.get CastaData  anhtLinkesEnde) 1) (if (= (connect.get CastaData  amAtStegRechts) 1) (setq AT_HWinkel (+ AT_HWinkel 90.0))))
	(if (> AT_HWinkel 180.0) (setq AT_HWinkel (- AT_HWinkel 180.0)))
  ))
  (if (> Sonderfall 0) (if (= (connect.get CastaData amAtflansch) 1) (progn
	(print "Winkel tauschen")
	(setq W_Tausch AT_HWinkel)
	(setq AT_HWinkel AT_VWinkel)
	(setq AT_VWinkel W_Tausch)
  )))
  
  (TrEnde.set HTrg_Ende (H_Winkel HT_HWinkel) (V_Winkel HT_VWinkel))
  (TrEnde.set ATrg_Ende (H_Winkel AT_HWinkel) (V_Winkel AT_VWinkel))
  
  (if (= 1 2) (progn
	  (if (= (connect.get CastaData at-von-oben) 1) (progn
		(setq HT_VWinkel (+ HT_VWinkel 90.0))
		(TrEnde.set HTrg_Ende (H_Winkel HT_HWinkel) (V_Winkel HT_VWinkel))
	  ))
	  (if (= (connect.get CastaData at-von-unten) 1) (progn
		(setq HT_VWinkel (+ HT_VWinkel 90.0))
		(TrEnde.set HTrg_Ende (H_Winkel HT_HWinkel) (V_Winkel HT_VWinkel))
	  ))
	   (if (= (connect.get CastaData amAtflansch) 1) (progn
		 (if (= (connect.get CastaData amAtOberflansch) 1) (progn
			(setq AT_HWinkel (+ AT_HWinkel 90.0))
		 ))
		 (AlertBox "hier am AT-Flansch")
		 (TrEnde.set ATrg_Ende (V_Winkel AT_HWinkel) (H_Winkel AT_VWinkel))
	   ))
	  (if (= (connect.get CastaData amAtStegRechts ) 1) (progn
		(AlertBox "hier amAtStegRechts")
		(setq AT_HWinkel (+ AT_HWinkel 90.0))
		(print AT_HWinkel)
		(TrEnde.set ATrg_Ende (H_Winkel AT_HWinkel) (V_Winkel AT_VWinkel))
	  ))
	  ;(if (= (connect.get CastaData amHTFlansch ) 1) (progn
	  ;	(AlertBox "hier am HT-Flansch")
	  ; (TrEnde.set ATrg_Ende (V_Winkel AT_HWinkel) (H_Winkel AT_VWinkel))
	  ;))
   ))
)


; ----------------------------------- alte Lsung
(defun Berechne ()

  ; Berechnen des horizontalen Winkels
  (setq hWinkel_Steg    (Connect.get CastaData h-atrgewnkl_steg))
  (setq vWinkel_Flansch (Connect.get CastaData v-atrgewnkl_flansch))
  (print hWinkel_Steg)
  
  (setq FlanschAnschluss 0)
  (if (= hWinkel_Steg 180.0) (setq FlanschAnschluss 1))
  (if (= hWinkel_Steg   0.0) (setq FlanschAnschluss 1))
  
  (if (= FlanschAnschluss 1) (progn 		; Anschluss an Stegseite nicht mglich - Flansch einsetzen
    		(setq GehrungsWinkel (/ vWinkel_Flansch 2.0))
  		(calcEndWinkel GehrungsWinkel)
  		(print GehrungsWinkel) (print Alfa_H) (print Alfa_V)
  		(setEndWinkel_FlanschAnschl GehrungsWinkel Alfa_H Alfa_V)
	); progn-Ende
	(progn
    		(setq GehrungsWinkel (/ hWinkel_Steg 2.0))
    		
  		 (calcEndWinkel_Neu GehrungsWinkel)

  		; (calcEndWinkel GehrungsWinkel)
  		; (setEndWinkel_StegAnschl GehrungsWinkel Alfa_H Alfa_V)
  ))

  (Connect.ShowAttributes CastaData)

;  (Move)
)
(defun calcEndWinkel (wGehrung)
  
  (setq VWinkel_Steg (Connect.get CastaData v-atrgewnkl_steg))
  (setq wVertikal    (- 90.0 VWinkel_Steg))
  
  (setq hProf  (Traeger.get HTrg h)
  	hProf2 (* 0.5 hProf)
  )
  
  (setq sinW_V  (sin (* PI (/ wVertikal 180.0))))
  (setq cosW_V  (cos (* PI (/ wVertikal 180.0))))
  (setq tanW_G  (tan (* PI (/ wGehrung  180.0))))

  
  (if (> cosW_V (- 0.0001)) (if (< cosW_V 0.0001) (setq cosW_V 0.0)))
  (if (> sinW_V (- 0.0001)) (if (< sinW_V 0.0001) (setq sinW_V 0.0)))

  (setq Alfa_H 90.0 Alfa_V 90.0)

  (print "Zwischenwerte: ........................")
  (print cosW_V) (print sinW_V)
  (print wGehrung)

  (if (= cosW_V 0.0) (progn
        (setq Alfa_V  (- 90.0 wGehrung)			; normalerweile 45.0
              Alfa_H  90.0
        )
     )
     (progn
        (if (= sinW_V 0.0) (progn
            (setq Alfa_H wGehrung		; normalerweise 45.0
                  Alfa_V 90.0
            )
          )
          (progn
		  (setq L1 (/ (* hProf2 tanW_G) cosW_V))
		  (setq L2 (/ (* hProf2 tanW_G) sinW_V))
		  
		  (print L1)
		  (print L2)
		  
		  (setq tan_Alfa_H (/ L1 hProf2))
		  (setq Alfa_H_rad (atan tan_Alfa_H))
		  (setq Alfa_H (/ (* 180.0 Alfa_H_rad) PI))
		
		  (setq tan_Alfa_V (/ L2 hProf2))
		  (setq Alfa_V_rad (atan tan_Alfa_V))
		  (setq Alfa_V (/ (* 180.0 Alfa_V_rad) PI))
		
		  (print "--------------- Ergebnisse : -----------------")
		  (print wGehrung)
		  (print wVertikal)
		  
		  (print Alfa_H_rad)
		  (print Alfa_H)
		
		  (print Alfa_V_rad)
		  (print Alfa_V)
          )
        )
     )
  )
)
(defun setEndWinkel_StegAnschl (wGehrung Alfa_H Alfa_V)
  (if (= (Connect.get CastaData anHtLinkesEnde)  1) (setq HTrg_Ende (Traeger.get HTrg links)))
  (if (= (Connect.get CastaData anHtRechtesEnde) 1) (setq HTrg_Ende (Traeger.get HTrg rechts)))
  
  (if (= (Connect.get CastaData LinkesEnde)      1) (setq ATrg_Ende (Traeger.get Tr_ID links)))
  (if (= (Connect.get CastaData RechtesEnde)     1) (setq ATrg_Ende (Traeger.get Tr_ID rechts)))

  (setq GFall 0)

  (if (= (Connect.get CastaData anHtLinkesEnde)      1) (progn
      (if (= (Connect.get CastaData LinkesEnde)      1) (progn
	  (if (= (Connect.get CastaData sAtr-lHtr)       1) (setq GFall 1))
	  (if (= (Connect.get CastaData sAtr-lHtr)      -1) (setq GFall 2))
      ))
      (if (= (Connect.get CastaData RechtesEnde)      1) (progn
	  (if (= (Connect.get CastaData sAtr-lHtr)       1) (setq GFall 4))
	  (if (= (Connect.get CastaData sAtr-lHtr)      -1) (setq GFall 3))
      ))
  ))
  (if (= (Connect.get CastaData anHtRechtesEnde)      1) (progn
      (if (= (Connect.get CastaData LinkesEnde)      1) (progn
	  (if (= (Connect.get CastaData sAtr-lHtr)      -1) (setq GFall 1))
	  (if (= (Connect.get CastaData sAtr-lHtr)       1) (setq GFall 2))
      ))
      (if (= (Connect.get CastaData RechtesEnde)      1) (progn
	  (if (= (Connect.get CastaData sAtr-lHtr)      -1) (setq GFall 4))
	  (if (= (Connect.get CastaData sAtr-lHtr)       1) (setq GFall 3))
      ))
  ))

;  (setq GFall 4)

  (setq  HT_HWinkel 90.0)
  (setq  HT_VWinkel 90.0)

  (if (= (Connect.get CastaData amHTStegLinks)      1) (progn
	  (if (= GFall 1) (progn
	      (setq  HT_VWinkel (+ 180.0 Alfa_V))
	      ;(setq  HT_VWinkel (- 90.0 Alfa_V))
	      (setq  HT_HWinkel  (- 90.0 Alfa_H))
	      ; (setq  HT_VWinkel 90.0)
	      (print Alfa_V)
	      (print HT_VWinkel)
	      (TrEnde.set ATrg_Ende (H_Winkel (+ 90.0 wGehrung)))
	  ))
	  (if (= GFall 2) (progn
	      (setq  HT_VWinkel    (- Alfa_V))
	      (print Alfa_V)
	      (setq  HT_HWinkel (- 180.0 Alfa_H))
	      (TrEnde.set ATrg_Ende (H_Winkel wGehrung))
	  ))
  ))
  (if (= (Connect.get CastaData amHTStegRechts)      1) (progn
	  (if (= GFall 1) (progn
	      (setq  HT_VWinkel (- 180.0 Alfa_V))
	      (setq  HT_HWinkel Alfa_H)
	      (TrEnde.set ATrg_Ende (H_Winkel (+ 90.0 wGehrung)))
	  ))
	  (if (= GFall 2) (progn
	      (setq  HT_VWinkel    Alfa_V)
	      (setq  HT_HWinkel (- 180.0 Alfa_H))
	      (TrEnde.set ATrg_Ende (H_Winkel wGehrung))
	  ))
  ))
  (if (= (Connect.get CastaData amHTFlansch)      1) (progn
     (if (= GFall 3) (progn
       ; (print "amHTFlansch - Fall 3")
       (setq  HT_VWinkel Alfa_V)
       (setq  HT_HWinkel Alfa_H)
       (TrEnde.set ATrg_Ende (H_Winkel (+ 90.0 wGehrung)))
     ))
     (if (= GFall 4) (progn
       ; (print "amHTFlansch - Fall 4")
       (setq  HT_VWinkel   (- 180.0 Alfa_V))
       (setq  HT_HWinkel   (- 180.0 Alfa_H))
       (TrEnde.set ATrg_Ende (H_Winkel wGehrung))
    ))
  ))
  (if (= (Connect.get CastaData amHTSteg)      1) (progn
     (if (= GFall 3) (progn
       ; (print "amHTSteg - Fall 3")
       (setq  HT_VWinkel (- 180.0 Alfa_V))
       (setq  HT_HWinkel Alfa_H)
       (TrEnde.set ATrg_Ende (H_Winkel (+ 90.0 wGehrung)))
     ))
     (if (= GFall 4) (progn
       ; (print "amHTSteg - Fall 4")
       (print Alfa_V)
       (setq  HT_VWinkel   (- 180.0 Alfa_V))
       (setq  HT_HWinkel   (- 180.0 Alfa_H))
       (TrEnde.set ATrg_Ende (H_Winkel wGehrung))
     ))
  ))

  (if (= 1 2) (progn
	  (if (= GFall 1) (progn
	      (setq  HT_VWinkel (- 180.0 Alfa_V))
	      (setq  HT_HWinkel (- 90.0 Alfa_H))
	      (TrEnde.set ATrg_Ende (H_Winkel (+ 90.0 wGehrung)))
	  ))
  ))




  (TrEnde.set HTrg_Ende (H_Winkel  HT_HWinkel))
  (TrEnde.set HTrg_Ende (V_Winkel  HT_VWinkel))

  

)
(defun setEndWinkel_FlanschAnschl (wGehrung Alfa_H Alfa_V)
  (if (= (Connect.get CastaData anHtLinkesEnde)  1) (setq HTrg_Ende (Traeger.get HTrg links)))
  (if (= (Connect.get CastaData anHtRechtesEnde) 1) (setq HTrg_Ende (Traeger.get HTrg rechts)))
  
  (if (= (Connect.get CastaData LinkesEnde)      1) (setq ATrg_Ende (Traeger.get Tr_ID links)))
  (if (= (Connect.get CastaData RechtesEnde)     1) (setq ATrg_Ende (Traeger.get Tr_ID rechts)))

  (setq AT_VWinkel 90.0)
  (setq HT_VWinkel 90.0)

  (setq GFall 0)
 
  (if (= (Connect.get CastaData anHtLinkesEnde) 1) (progn
     (if (= (Connect.get CastaData LinkesEnde)     1) (progn
	(if (= (Connect.get CastaData vAtr-lHtr)      -1) (setq GFall 3))
	(if (= (Connect.get CastaData vAtr-lHtr)       1) (setq GFall 4))
     ))
     (if (= (Connect.get CastaData RechtesEnde)     1) (progn
	(if (= (Connect.get CastaData vAtr-lHtr)      -1) (setq GFall 4))
	(if (= (Connect.get CastaData vAtr-lHtr)       1) (setq GFall 3))
     ))
  ))
  (if (= (Connect.get CastaData anHtRechtesEnde) 1) (progn
     (if (= (Connect.get CastaData LinkesEnde)     1) (progn
	(if (= (Connect.get CastaData vAtr-lHtr)      -1) (setq GFall 1))
	(if (= (Connect.get CastaData vAtr-lHtr)       1) (setq GFall 2))
     ))
     (if (= (Connect.get CastaData RechtesEnde)     1) (progn
	(if (= (Connect.get CastaData vAtr-lHtr)      -1) (setq GFall 2))
	(if (= (Connect.get CastaData vAtr-lHtr)       1) (setq GFall 1))
     ))
  ))

  (print ".") (print GFall) (print "___________")
  (print wGehrung)
  (if (= GFall 1) (progn
	(setq AT_VWinkel (+  90.0 wGehrung))
	(setq HT_VWinkel (+  90.0 wGehrung))
  ))
  (if (= GFall 2) (progn
	(setq AT_VWinkel wGehrung)
	(setq HT_VWinkel (- 180.0 wGehrung))
  ))
  (if (= GFall 3) (progn
	(setq AT_VWinkel wGehrung)
	(setq HT_VWinkel wGehrung)
  ))
  (if (= GFall 4) (progn
	(setq AT_VWinkel (+  90.0 wGehrung))
	(setq HT_VWinkel (-  90.0 wGehrung))
  ))

  (TrEnde.set ATrg_Ende (V_Winkel  AT_VWinkel)	(H_Winkel  90.0))
  (TrEnde.set HTrg_Ende (V_Winkel  HT_VWinkel)  (H_Winkel  90.0))


)

(defun Move ()
	; Traegerende bestimmen
  (if (= (Connect.get CastaData anHtLinkesEnde)  1) (setq HTrg_Ende (Traeger.get HTrg links)))
  (if (= (Connect.get CastaData anHtRechtesEnde) 1) (setq HTrg_Ende (Traeger.get HTrg rechts)))
  
  (if (= (Connect.get CastaData LinkesEnde)      1) (setq ATrg_Ende (Traeger.get Tr_ID links)))
  (if (= (Connect.get CastaData RechtesEnde)     1) (setq ATrg_Ende (Traeger.get Tr_ID rechts)))

	; Vertikalwinkel verschieben
  (setq EVWinkel (TrEnde.get HTrg_Ende H_Winkel))
  (TrEnde.set HTrg_Ende (H_Winkel (+ EVWinkel 1.0)))

;  (setq EVWinkel (TrEnde.get ATrg_Ende V_Winkel))
;  (TrEnde.set ATrg_Ende (V_Winkel (+ EVWinkel 1.0)))

	; Horizontalwinkel verschieben
;	 (setq EHWinkel (TrEnde.get ATrg_Ende H_Winkel))
;	 (TrEnde.set ATrg_Ende (H_Winkel (+ EHWinkel 2.0)))
	


  
)

(defun calcEndWinkel_Neu (wGehrung)
  
  (print "in Funktion calcEndWinkel_Neu ....................")
  
  (setq VWinkel_Steg (Connect.get CastaData v-atrgewnkl_steg))
  (setq HWinkel_Steg (Connect.get CastaData h-atrgewnkl_steg))
  (setq wVertikal    (- 90.0 VWinkel_Steg))
  (setq wHorizontal  (- 90.0 hWinkel_Steg))
  
  (setq  wHorizontal  HWinkel_Steg)
  (if (> HWinkel_Steg 90.0) (setq wHorizontal (- 180.0 HWinkel_Steg)))

  (setq  wVertikal  VWinkel_Steg)
  (if (> VWinkel_Steg 90.0) (setq wVertikal (- VWinkel_Steg 90.0)))
  
  (if (= (Connect.get CastaData anHtLinkesEnde)  1) (setq HTrg_Ende (Traeger.get HTrg links)))
  (if (= (Connect.get CastaData anHtRechtesEnde) 1) (setq HTrg_Ende (Traeger.get HTrg rechts)))
  
  (if (= (Connect.get CastaData LinkesEnde)      1) (setq ATrg_Ende (Traeger.get Tr_ID links)))
  (if (= (Connect.get CastaData RechtesEnde)     1) (setq ATrg_Ende (Traeger.get Tr_ID rechts)))

  (TrEnde.set ATrg_Ende (H_Winkel  (+ 90.0 (/ wHorizontal 2.0))) (V_Winkel 90.0))
  (TrEnde.set HTrg_Ende (H_Winkel  (- 90.0 (/ wHorizontal 2.0))) (V_Winkel 90.0))

)
(defun Dummy2 ()  
  
  (setq hProf  (Traeger.get HTrg h)
  	hProf2 (* 0.5 hProf)
  )

  (setq sinW_H  (sin (* PI (/ wHorizontal 180.0))))
  (setq cosW_H  (cos (* PI (/ wHorizontal 180.0))))
  (setq tanW_H  (tan (* PI (/ wHorizontal 180.0))))
  
  (setq sinW_V  (sin (* PI (/ wVertikal 180.0))))
  (setq cosW_V  (cos (* PI (/ wVertikal 180.0))))
  (setq tanW_V  (tan (* PI (/ wVertikal 180.0))))
  (setq tanW_G  (tan (* PI (/ wGehrung  180.0))))

  
  (if (> cosW_V (- 0.0001)) (if (< cosW_V 0.0001) (setq cosW_V 0.0)))
  (if (> sinW_V (- 0.0001)) (if (< sinW_V 0.0001) (setq sinW_V 0.0)))

  (setq Alfa_H 90.0 Alfa_V 90.0)

  (print "Zwischenwerte: ........................")
  (print HWinkel_Steg)
  (print VWinkel_Steg)
  (print " ")
  (print wHorizontal)
  (print wVertikal)
  
  
  (print cosW_H) (print sinW_H)
  (print cosW_V) (print sinW_V)
  (print wGehrung)
  
  (setq RLng (* hProf2 (- 1.0 sinW_H)))
  (print hProf2)
  (print RLng)
  (setq LFS1      (/ RLng cosW_H))
  (setq hSchnitt  (* LFS1 tanW_V))
  (setq LFS2      (/ LFS1 cosW_V))
  
  (print LFS1)
  (print LFS2)
  (print hSchnitt)
  
  (setq x_HT_Ges  (* hProf2 cosW_H))
  (setq Rx_HT     (* RLng tanW_H))
  (setq x_HT (-   x_HT_Ges Rx_HT))
  (print x_HT)
  
  (setq tan_Gehr_Hori (/ x_HT hProf2))
  (setq horWnk_Rad (atan tan_Gehr_Hori))
  (setq horWnk     (/ (* 180.0 horWnk_Rad) PI))
  (print horWnk)

  (if (= (Connect.get CastaData anHtLinkesEnde)  1) (setq HTrg_Ende (Traeger.get HTrg links)))
  (if (= (Connect.get CastaData anHtRechtesEnde) 1) (setq HTrg_Ende (Traeger.get HTrg rechts)))
  
  (if (= (Connect.get CastaData LinkesEnde)      1) (setq ATrg_Ende (Traeger.get Tr_ID links)))
  (if (= (Connect.get CastaData RechtesEnde)     1) (setq ATrg_Ende (Traeger.get Tr_ID rechts)))

  (TrEnde.set ATrg_Ende (H_Winkel  (- 90.0 horWnk)) (V_Winkel 90.0))
  (TrEnde.set HTrg_Ende (H_Winkel  (+ 90.0 horWnk)) (V_Winkel 90.0))

  
)

(defun wa_Sonderfaelle ()
	(print "*clear*")
	(print "in wa_Sonderfaelle - hier clear")
	(Connect.showAttributes CastaData)

)
