; $	HT	QT(RKF)		AF(FSK)		P(EZ)
; $	AT	QT(RK)		AF(K)		P(E)
; $	AE	V(-)		H(-)		R(-)

; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;
;	
; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
(defun load-modules ()
   (if (= (Connect.get CastaData amHtSteg)    1) (progn
 	(load "mod-endinit-uz-stzsteg")
	(load "mod-multiconnect-stz-steg")
   ))

   (if (= (Connect.get CastaData amHtFlansch) 1) (progn
 	(load "mod-endinit-uz-stzflansch")		
	(load "mod-help-uz_an_stzFlansch")
   ))
   (load "mod-messages")
   (load "mod-add-schweiss-querschn")	; neu - Juni 2019
)


(defun init-connection ()

	(if (= (Connect.get CastaData amHtSteg)    1) (init-traegerenden 0))
	(if (= (Connect.get CastaData amHtFlansch) 1) (init-traegerenden))
	
	(setConnection)
	; (connect.showattributes CastaData)
)

(defun setConnection ()
	(print "*clear*")
	(Connect.showAttributes CastaData)

	(createKopfplatte)
	
	(createHandlaufPin)
	
	(kuerzePfostenProfil)

)

(defun createKopfplatte ()

	(setq h_AT (Traeger.get Tr_ID h))
	(setq bl_Kopfpl (Blech.create))
	
	(setq QsForm_AT (Traeger.get Tr_ID qsform))

	(Blech.set bl_Kopfpl (BlechTyp 1) (dp 8) (aRadius (* 0.5 h_AT)))
	(if (= QsForm_AT "K") (progn
		(setq b_AT (Traeger.get Tr_ID b))
		(Blech.set bl_Kopfpl (BlechTyp 0) (aRadius 0) (dp 8) (hp h_AT) (bp b_AT))
	))
	
	(if (= (Connect.get CastaData LinkesEnde) 1)  (progn
		(setq TrgEnde (Traeger.get Tr_ID links))
		(TrEnde.set TrgEnde (V_Winkel 90.0))
		(traeger.addabtl tr_id bl_Kopfpl 0.0 0.0 _kopfplattelinks_)
	))
	(if (= (Connect.get CastaData RechtesEnde) 1) (progn
		(setq TrgEnde (Traeger.get Tr_ID rechts))
		(TrEnde.set TrgEnde (V_Winkel 90.0))
		(traeger.addabtl tr_id bl_Kopfpl 0.0 0.0 _kopfplatterechts_)
	))
	
	(Connect.storeAnschlObjs CastaData bl_Kopfpl)

)

(defun createHandlaufPin ()
	(setq HL_Pin (Traeger.create))
	(Traeger.set HL_Pin (Profil "Rd 12") (SysLng 60) (Laenge 60))
	
	(if (= (Connect.get CastaData LinkesEnde) 1)  (progn
		(setq TrgEnde (Traeger.get Tr_ID links))
		(traeger.addabtl tr_id HL_Pin 0.0 0.0 _hlhpin_endelinks_)
	))
	(if (= (Connect.get CastaData RechtesEnde) 1) (progn
		(setq TrgEnde (Traeger.get Tr_ID rechts))
		(traeger.addabtl tr_id HL_Pin 0.0 0.0 _hlhpin_enderechts_)
	))
	
	(Connect.storeAnschlObjs CastaData HL_Pin)
	
	(Traeger.set HL_Pin (formFkt "cb_HandlaufPin"))
)

(defun kuerzePfostenProfil ()

; )
; (defun IST_RAUS ()

	(setq KrzLaenge 0.0)
	(setq dp 	(Blech.get bl_Kopfpl dp))
	(setq l_Pin (Traeger.get HL_Pin   SysLng)
	      b_Pin (Traeger.get HL_Pin   b)
	)
	(setq SWnkl (connect.get CastaData v-atrgewnkl_flansch))
	(if (> SWnkl 90.0) (setq SWnkl (- 180.0 SWnkl)))
	(setq TanAlfa (tan (/ (* PI SWnkl) 180.0)))
	(setq VAnteil (/ (* 0.25 b_Pin) TanAlfa))
	
	(if (= (Connect.get CastaData LinkesEnde) 1)  (progn
		(setq TrgEnde (Traeger.get Tr_ID links))
		(setq l_Vorh (TrEnde.get TrgEnde delta_L))
		(setq l_Neu (+ l_Vorh dp l_Pin))
		(TrEnde.pTrim TrgEnde (+ l_Pin dp VAnteil))
	))
	(if (= (Connect.get CastaData RechtesEnde) 1) (progn
		(setq TrgEnde (Traeger.get Tr_ID rechts))
		(setq l_Vorh (TrEnde.get TrgEnde delta_L))
		(setq l_Neu (+ l_Vorh dp l_Pin))
		(TrEnde.pTrim TrgEnde (+ l_Pin dp VAnteil))
	))


)
(defun cb_HandlaufPin (zp)
	(if (= zp 0) (progn
		(setq lng_Alt (Traeger.get HL_Pin SysLng))
	))
	(if (= zp 1) (progn
		(setq lng_Neu (Traeger.get HL_Pin SysLng))
		
		(if (/= lng_Alt lng_Neu) (progn
			(setq diffLng (- lng_Neu lng_Alt))
			(if (= (Connect.get CastaData LinkesEnde) 1)  (setq TrgEnde (Traeger.get Tr_ID links)))
			(if (= (Connect.get CastaData RechtesEnde) 1) (setq TrgEnde (Traeger.get Tr_ID rechts)))
			(if (objExist TrgEnde) (progn
				(setq l_Vorh (TrEnde.get TrgEnde delta_L))
				(setq l_Neu (+ l_Vorh diffLng))
				(TrEnde.set TrgEnde (delta_L l_Neu))
			))
		
		))
	))


)

