; $	HT	QT(RKF)		AF(FSK)		P(EZ)
; $	AT	QT(RK)		AF(K)		P(E)
; $	AE	V(-)		H(-)		R(-)

; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;
;	
; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
(defun load-modules ()
   (if (= (Connect.get CastaData amHtSteg)    1) (progn
 	(load "mod-endinit-uz-stzsteg")
	(load "mod-multiconnect-stz-steg")
   ))

   (if (= (Connect.get CastaData amHtFlansch) 1) (progn
 	(load "mod-endinit-uz-stzflansch")		
	(load "mod-help-uz_an_stzFlansch")
   ))
   (load "mod-messages")
   (load "mod-add-schweiss-querschn")	; neu - Juni 2019
)


(defun init-connection ()


	(if (= (Connect.get CastaData amHtSteg)    1) (init-traegerenden 0))
	(if (= (Connect.get CastaData amHtFlansch) 1) (init-traegerenden))
	
	(setConnection)
	; (connect.showattributes CastaData)
)

(defun setConnection ()
	(print "*clear*")
	(Connect.showAttributes CastaData)

	;	Neu hinzugefügt, Juni 2019
	(if (= (Connect.get CastaData amHtSteg)    1) (SchweissProfil_Einsetzen_St))
	(if (= (Connect.get CastaData amHtFlansch) 1) (SchweissProfil_Einsetzen_Fl))

	(setq t_Sattel 2)
	(getAussattelungsMasz)
	; Hier eintragen, wieviele mm das Profil in den Pfosten / HT hineinragen
	; soll, und wieviele mm demzufolge der Metallbauer aussatteln muss
	(AussattelungsKorrektur t_Sattel)
)

(defun	getAussattelungsMasz ()
    (print "*clear*")
	
	(setq ask_Aussattelung 1)
	(setq qsform_ht		(Traeger.get Htrg qsform))
	(if (= qsform_ht "K") (progn
		(setq t_Sattel 0.0)			; muss nichts ausgesattelt werden
		(setq ask_Aussattelung 0)	; und braucht nicht dynamisch erfolgen
	))
	(if (= qsform_ht "F") (progn
		(setq t_Sattel 0.0)			; muss nichts ausgesattelt werden
		(setq ask_Aussattelung 0)	; und braucht nicht dynamisch erfolgen
	))
	(if (= ask_Aussattelung 1) (progn
		(setq VarConfigFile "AussattelungstiefeSettings.lsp")
		
		(loadConfig VarConfigFile)		; Letzte Werte einladen

		(setq CopyMode (Connect.get CastaData CopyMode))
		;(setq CopyMode 1)

		(if (= CopyMode 0) (progn
			(Connect.createDialog    CastaData)
			(Connect.storedialogctrl CastaData   "Tiefe der Aussattelung", "d", "t_Sattel", t_Sattel)
			(Connect.OpenDialog      CastaData  "Aussattelungstiefe.bmp")
		))
		
		(writeConfig VarConfigFile t_Sattel)
	))
)

(defun SchweissProfil_Einsetzen ()

	; Anschlussdaten ...
	; X-Position
	(setq xPos_ht		(Connect.get CastaData xPos_ht))
	; Rotationswinkel des AT
	(setq rWinkel 0.0)
	(setq rWinkel_AT	(Connect.get CastaData r-atrgewnkl_steg ))

	(if (= (Connect.get CastaData linkesEnde)  1) (progn
	    (if (= (Connect.get CastaData amHtStegLinks)   1) (setq rWinkel    (- rWinkel_AT 90.0)))
	    (if (= (Connect.get CastaData amHtStegRechts)  1) (setq rWinkel (- (- rWinkel_AT 90.0))))
	))
	(if (= (Connect.get CastaData rechtesEnde)  1) (progn
	    (if (= (Connect.get CastaData amHtStegLinks)   1) (setq rWinkel (- (- rWinkel_AT 90.0))))
	    (if (= (Connect.get CastaData amHtStegRechts)  1) (setq rWinkel    (- rWinkel_AT 90.0)))
	))


	(if (= (Connect.get CastaData amHtStegLinks)  1) (Traeger.addJoinProfil HTrg Tr_ID xPos_ht rWinkel _steg_links_))
	(if (= (Connect.get CastaData amHtStegRechts) 1) (Traeger.addJoinProfil HTrg Tr_ID xPos_ht rWinkel _steg_rechts_))
	
	; Anbauteil ermitteln
	(setq abtl_Trg (Traeger.get HTrg abTeil Tr_ID))
	(if (= (Connect.get CastaData linkesEnde)     1) (Anbauteil.set abtl_Trg (addflag  _endelinks_)))
	(if (= (Connect.get CastaData rechtesEnde)    1) (Anbauteil.set abtl_Trg (addflag _enderechts_)))
	(if (= (Connect.get CastaData amHtStegLinks)  1) (Anbauteil.set abtl_Trg (addflag _steg_links_)))
	(if (= (Connect.get CastaData amHtStegRechts) 1) (Anbauteil.set abtl_Trg (addflag _steg_rechts_)))

	
	(setq	dv_HT 	(Traeger.get HTrg delta_V))
	(setq	dv_AT 	(Traeger.get Tr_ID delta_V)
		dlr_AT	(Traeger.get Tr_ID delta_LR)
	)

	(print "*clear*")
	(print rWinkel)
	(setq sinWnk  (sin (* PI (/ rWinkel 180.0))))
	(setq cosWnk  (cos (* PI (/ rWinkel 180.0))))


	(setq delta_V_Abtl (- dv_AT))
	
	

	
	(setq delta_LR_Abtl 0.0)
	(if (= (Connect.get CastaData linkesEnde)  1) (progn
	    (if (= (Connect.get CastaData amHtStegLinks)   1) (setq delta_LR_Abtl    dlr_AT))
	    (if (= (Connect.get CastaData amHtStegRechts)  1) (setq delta_LR_Abtl (- dlr_AT)))
	))
	(if (= (Connect.get CastaData rechtesEnde)  1) (progn
	    (if (= (Connect.get CastaData amHtStegLinks)   1) (setq delta_LR_Abtl (- dlr_AT)))
	    (if (= (Connect.get CastaData amHtStegRechts)  1) (setq delta_LR_Abtl    dlr_AT))
	))

	(setq delta_V_Abtl_Set  (- (* cosWnk delta_V_Abtl)  (* sinWnk delta_LR_Abtl)))
	(setq delta_LR_Abtl_Set (+ (* cosWnk delta_LR_Abtl) (* sinWnk delta_V_Abtl)))

	(setq delta_V_Abtl_Set (- delta_V_Abtl_Set dv_HT))
	(Anbauteil.set abtl_Trg (delta_V  delta_V_Abtl_Set))
	(Anbauteil.set abtl_Trg (delta_LR delta_LR_Abtl_Set))

)

(defun AussattelungsKorrektur (AsMasz)
	(if (= (Connect.get CastaData linkesEnde)     1) (setq Tr_Ende (Traeger.get Tr_ID links)))
	(if (= (Connect.get CastaData rechtesEnde)    1) (setq Tr_Ende (Traeger.get Tr_ID rechts)))
	
	(setq delta_L     (TrEnde.get Tr_Ende delta_L))
	(setq delta_L_Neu (- delta_L AsMasz))
	
	(TrEnde.set Tr_Ende (delta_L delta_L_Neu))
)