; ---------------------------------------------------------------------------
; Darstellung der WSZ-Ansicht
; Version 1.30		(April  2007)
; Version 1.32		(August 2007)
; Version 2.00		(Januar 2009)
; ---------------------------------------------------------------------------
(defun Main ()
   (print ">>>>>>>>>>>>>>> starte Werkstattzeichnungsprogramm")
   (setq ProfName (Traeger.get WSZ_Trg Profil))
   (print ProfName)
   
   ; Definitionen, falls Config-Datei nicht geladen wird.
   (setq sg25 2.5)	;; zur Sicherheit hier defaultmig definieren
   (setq sg35 3.5)	;; zur Sicherheit hier defaultmig definieren
   
   (loadConfig "bemaszungs_config.lsp")
   
   (draw_traeger)

   (print "neu - alle Layer der Bemaung freigeben!")
   (drawing.delallayer draw1) 
   (print ">>>>>>>>>>>>>>> beende Werkstattzeichnungsprogramm")
)
(defun draw_traeger ()


	(showDebugInfos)	; Lokale Funktion um Linien zu zeichnen, etc.
		
  (setq TrTest (traeger.create))
  (setq TrLi   (trende.create))

;  ---- Zeichnen der Kopfplattenansichten ...
   (setq bProf   (Traeger.get WSZ_Trg b)
         sysLng  (Traeger.get WSZ_Trg syslng)
         deltaV  (Traeger.get WSZ_Trg delta_v)
   )

   (setq Trg_links   (traeger.get WSZ_Trg links))
   (setq Trg_rechts  (traeger.get WSZ_Trg rechts))

;  Achtung - wird weiter unten noch einmal berechnet.
;  Wenn nderungen, dann bei beiden Berechnungen angleichen!
  (setq dlLinks  (TrEnde.get Trg_links  delta_l)
        dlRechts (TrEnde.get Trg_rechts delta_l)
        hWnklLi  (TrEnde.get Trg_links  H_Winkel)
        hWnklRe  (TrEnde.get Trg_rechts H_Winkel)
        vWnklLi  (TrEnde.get Trg_links  V_Winkel)
        vWnklRe  (TrEnde.get Trg_rechts V_Winkel)
	xsLinks  (- -500  (/ bProf 2) (- dlLinks))
        xsRechts (+  500  (/ bProf 2) (- dlRechts) sysLng)
	vscherl_links	(TrEnde.get Trg_links vscherl)
	vscherl_rechts	(TrEnde.get Trg_rechts vscherl)
  )


   (if (> vWnklLi 90.0)
	(setq vWnklLi (- vWnklLi 90.0))
   )
   (if (> vWnklRe 90.0)
	(setq vWnklRe (- 90.0 vWnklRe))
   )
   (setq cosW_l (cos (/ (* PI vWnklLi) 180.0)))
   (setq cosW_r (cos (/ (* PI vWnklRe) 180.0)))
   (setq verschieb_r (* (* 1.5 vscherl_rechts) cosW_r))
   (setq verschieb_l (* (* 1.5 vscherl_links) cosW_l))
   (print verschieb_l)
	 
	(if (< vWnklLi 80.0) (setq xsLinks  (- xsLinks verschieb_l)))
   (if (> vWnklLi 80.0) (setq xsLinks  (- xsLinks verschieb_l)))
   (if (< vWnklRe 80.0) (setq xsRechts (+ xsRechts verschieb_r)))
   (if (> vWnklRe 80.0) (setq xsRechts (+ xsRechts verschieb_r)))
	 
   (setq QSForm   (Traeger.get WSZ_Trg QSForm))
   (print QSForm)

   (setq BlAbtlAnz (traeger.get WSZ_Trg AnzAbtl  Bleche     amOberflansch))
   (setq LbAbtlAnz (traeger.get WSZ_Trg AnzAbtl  Lochbilder amOberflansch))
   (setq amOberflansch (+ BlAbtlAnz LbAbtlAnz))

   (setq zeichneDraufsicht 1)
   (if (/= hWnklLi 90.0)    (setq zeichneDraufsicht 1))
   (if (/= hWnklRe 90.0)    (setq zeichneDraufsicht 1))
   (if (>  amOberflansch 0) (setq zeichneDraufsicht 1))
   (if (= QSForm "R")       (setq zeichneDraufsicht 1))
   (if (= QSForm "L")       (setq zeichneDraufsicht 1))
   (if (= QSForm "F")       (setq zeichneDraufsicht 1))
   (if (= QSForm "K")       (setq zeichneDraufsicht 1))


   (setq BlAbtlAnz (traeger.get WSZ_Trg AnzAbtl  Bleche     amUnterflansch))
   (setq LbAbtlAnz (traeger.get WSZ_Trg AnzAbtl  Lochbilder amUnterflansch))
   (setq amUnterflansch (+ BlAbtlAnz LbAbtlAnz))
   (print BlAbtlAnz)
   (print LbAbtlAnz)
   (print amUnterflansch)

    (setq zeichneDruntersicht 0)
    (if (> amUnterflansch 0) (setq zeichneDruntersicht 1))
    (if (= QSForm "R")       (setq zeichneDruntersicht 0))
    (if (= QSForm "L")       (setq zeichneDruntersicht 0))
    (if (= QSForm "F")       (setq zeichneDruntersicht 0))
    
    ; nur zum Entwickeln immer zeichnen ...
    (setq zeichneDruntersicht 1)

    (setq xMain 0.0)	;	noch nicht einsetzbar - Verschiebungen mssen
    (setq yMain 200.0)	;	explizit mit allen Zeichnungsmglichkeiten getestet
    			;	werden
    (if (= zeichneDruntersicht 1) (setq yMain (+ yMain 140.0)))
    
    (setq yMain 0.0)	; 	zurcksetzen, falls Druntersicht gezeichnet wird,
    			;	bis ausgetestet.

    (setq yAbstandSchnitte yMain) ; nur zur Sicherheit initialisieren ...

    (setq  hProf  (Traeger.get WSZ_Trg h))


  (if (objexist draw1)  (print "++++++++++++ draw1 existiert!")
  			(print "------------ draw1 existiert noch nicht!")
  )

  (if (objexist draw1) (progn
      	 (setq SchnitteErstellen 0)

         (setq scale (drawing.get draw1 scale))
	 (setq yAbstandSchnitte 2500.0)
	 (setq yAbstandSchnitte (+ yAbstandSchnitte (/ 100.0 scale)))
      )
      (progn				;; else-Teil - Drawing-Objekt anlegen
         (setq draw1 (drawing.create))	; Drawing-Objekt erzeugen
         (setq scale (drawing.get draw1 scale))

	 (setq yMain            (/ yMain            scale))
  	 (setq yAbstandSchnitte (+ yMain (/ 140.0 scale)))
  	 (if (= zeichneDraufsicht 1) (setq yAbstandSchnitte (+ yMain (/ 500.0 scale))))
;  	 (setq yAbstandSchnitte (- yAbstandSchnitte (* 0.5 hProf)))

	 (setq yAbstandSchnitte 2500.0)
	 (setq yAbstandSchnitte (+ yAbstandSchnitte (/ 100.0 scale)))

	 (setq pXl (* xsLinks  scale)) (setq pYl (* (- deltaV) scale))
	 (setq pXr (* xsRechts scale)) (setq pYr (* (- deltaV) scale))
	 (setq xScaled (* xMain    scale))
	 (setq yScaled (* yMain    scale))
;	 (setq yScaled yMain)
	 
;	 (setq yAbstandSchnitte (/ yAbstandSchnitte scale))
;  	(setq yAbstandSchnitte (- (/ yAbstandSchnitte scale) (* 0.5 hProf)))

	 (setq pXl (+ pXl xScaled))
	 (setq pXr (+ pXr xScaled))

         (drawing.createTrgPosBez  draw1 WSZ_Trg xScaled yScaled 0.0 0.0)  ; Trgerposition nur beim ersten Aufruf eintragen
         (if abtl_kopfplatte_links  (drawing.createSchnPosBez draw1 abtl_kopfplatte_links  pXl yScaled 0.0))
         (if abtl_kopfplatte_rechts (drawing.createSchnPosBez draw1 abtl_kopfplatte_rechts pXr yScaled 0.0))

				; Einzelbilddarstellung der Anbauteile (Bleche)
         (Traeger.drawabtlschnitte WSZ_Trg 0.0 yAbstandSchnitte scale)

         (setq SchnitteErstellen 1)

	 (if (objExist _maxkoord_) (progn
	     (print _maxkoord_)
             (setq maxX_Schnitt (coord.get _maxkoord_ x))
             (print maxX_Schnitt)
           )
           ;else
           (setq maxX_Schnitt 0)
         )
     )
  )
  (drawing.delallayer draw1)		;; Bemaungslayer aber jedes Mal freigeben.



;  (if abtl_kopfplatte_links    (print abtl_kopfplatte_links))
;  (if abtl_kopfplatte_rechts   (print abtl_kopfplatte_rechts))

   (layer "stahl")
;  (traeger.ansicht     WSZ_Trg  0 yMain  0  "maorbbds")
;  (traeger.ansicht     WSZ_Trg  0 1000.0 0  "masrbbds")

; ------ A N S I C H T ----------------------------------------------
; ----- Traeger in der Ansicht zeichnen und anschlieend bemaen
    (setq VAbstandOben 0.0)
    (traeger.ansicht     WSZ_Trg  xMain yMain 0  "masrbbds")
    (drawing.layer_rect draw1 "trga_lb")		   ; neu
    
    (GesamtBemaszung_Ansicht)

    (bemaszeAkl Trg_links  -1) ; links  bemaen ... "traeger_li" "oben" "rechts"
    (bemaszeAkl Trg_rechts  1) ; rechts bemaem ... "traeger_re" "oben" "links"

;  ---- Zeichnen der Kopfplattenansichten ...
   (setq bProf   (Traeger.get WSZ_Trg b)
         hProf   (Traeger.get WSZ_Trg h)
         sysLng  (Traeger.get WSZ_Trg syslng)
;         bp    (Blech.get *NochErmitteln* bp)	 
   )
   (setq scale (drawing.get draw1 scale))

;  Achtung - wird oben schon einmal berechnet.
;  Wenn nderungen, dann bei beiden Berechnungen angleichen!
  (setq dlLinks  (TrEnde.get Trg_links  delta_l)
        dlRechts (TrEnde.get Trg_rechts delta_l)
				xsLinks  (- -500  (/ bProf 2) (- dlLinks))
        xsRechts (+  500  (/ bProf 2) (- dlRechts) sysLng)
				vscherl_links		(TrEnde.get Trg_links vscherl)
				vscherl_rechts	(TrEnde.get Trg_rechts vscherl)
  )
	 
	 
	 (print vWnklLi)
	 
	 (setq cosW_l (cos (/ (* PI vWnklLi) 180.0)))
	 (setq cosW_r (cos (/ (* PI vWnklRe) 180.0)))
	 (setq verschieb_r (* (* 1.5 vscherl_rechts) cosW_r))
	 (setq verschieb_l (* (* 1.5 vscherl_links) cosW_l))
	 (print verschieb_l)
	 
   ;(if (< vWnklLi 80.0) (setq xsLinks  (- xsLinks (* 0.5 hProf))))
   ;(if (> vWnklLi 80.0) (setq xsLinks  (- xsLinks (* 0.5 hProf))))
   ;(if (< vWnklRe 80.0) (setq xsRechts (+ xsRechts (* 0.5 hProf))))
   ;(if (> vWnklRe 80.0) (setq xsRechts (+ xsRechts (* 0.5 hProf))))
	 (if (< vWnklLi 80.0) (setq xsLinks  (- xsLinks verschieb_l)))
   (if (> vWnklLi 80.0) (setq xsLinks  (- xsLinks verschieb_l)))
   (if (< vWnklRe 80.0) (setq xsRechts (+ xsRechts verschieb_r)))
   (if (> vWnklRe 80.0) (setq xsRechts (+ xsRechts verschieb_r)))
	 
	 
   (if abtl_kopfplatte_links     (drawKopfplAnsicht WSZ_Trg abtl_kopfplatte_links  xsLinks  yMain -1))
   (if abtl_kopfplatte_rechts    (drawKopfplAnsicht WSZ_Trg abtl_kopfplatte_rechts xsRechts yMain  1))

   (setq  AnzAugenBl (Traeger.get WSZ_Trg AnzAbtl Augenblech))
   (if (> AnzAugenBl 0) (progn
     (setq abtlAugBl (Traeger.get wsz_trg firstAbtl Augenblech))
     (while abtlAugBl
       (setq xPosABl (Anbauteil.get abtlAugBl XPos))
       (anbauteil.drawPosBez abtlAugBl xPosABl 1440.0)
       (anbauteil.drawSwnBez abtlAugBl xPosABl 1400.0)

        (setq abtlAugBl (Traeger.get wsz_trg nextAbtl))
     )
   ))
   
   (print "Coupon-Schnitt zeichnen <-------------------------")
   (print maxX_Schnitt)
   (setq hProf   (Traeger.get WSZ_Trg h))
   (setq orgMaxX_Schnitt maxX_Schnitt)
   (if (> maxX_Schnitt 0) (setq maxX_Schnitt (+ maxX_Schnitt 500)))
;   (drawCouponSchnitte  maxX_Schnitt (- (+ yMain 3000.0) (* 0.5 hProf)))
   (print yAbstandSchnitte)
   (drawCouponSchnitte  maxX_Schnitt (- yAbstandSchnitte (* 0.5 hProf)))
   
   (setq maxX_Schnitt orgMaxX_Schnitt)

; ------ D R A U F S I C H T ----------------------------------------------
; ----- Traeger in der Draufsicht zeichnen und anschlieend bemaen
    (drawing.delallayer draw1)
    
    (setq hWszTrg (Traeger.get WSZ_Trg h)
    	  bWszTrg (Traeger.get WSZ_Trg b)
    )
    (setq y_StlPosition (+ (* yMain scale) 150.0))

    (setq y_StlPosition  (+ yMain (/ 15.0 scale)))
    (setq y_StlPosition  (+ yMain (* 6.0 hWszTrg scale)))
;    (setq y_StlPosition     yMain)

    (if   (> hWszTrg 700) (setq y_StlPosition (+  y_StlPosition 50.0))) ;; Msste noch genauer berechnet werden

    (if (= zeichneDruntersicht 1) (progn
        (drawing.delallayer draw1)
        (setq yDrunterSicht (- yMain (/ 140.0 scale) 20.0))
        (traeger.drSicht WSZ_Trg 0.0   yDrunterSicht  0.0 "meor s" "Druntersicht")
        (GesamtBemaszung_Draufsicht -1)
;        (setq y_StlPosition (+ y_StlPosition (* 0.5 (+ hWszTrg bWszTrg) scale) (* 800.0 scale)))
        (setq y_StlPosition (+ y_StlPosition (* (+ hWszTrg bWszTrg) scale) (* 300.0 scale) 25.0))

;        (setq y_StlPosition yDrunterSicht)
    ))

    (print scale)

    (drawing.delallayer draw1)
    (if (= QSForm "I") (setq VAbstandOben (+ VAbstandOben 250.0)))
    (setq yDraufsicht (+ yMain (/ 120.0 scale) VAbstandOben))
    (if (= zeichneDraufsicht 1) (progn
        (drawing.delallayer draw1)
        (traeger.drSicht WSZ_Trg 0.0  yDraufsicht  0.0 "meor s" "Draufsicht")
        (GesamtBemaszung_Draufsicht 1)
    ))

    (setq sysLng (Traeger.get WSZ_Trg syslng)
          hProf  (Traeger.get WSZ_Trg h)
    )
    (print scale)
    (Traeger.TraegerStlListe WSZ_Trg (- (* sysLng scale)  250.0) (- (* hProf scale) y_StlPosition))


)
; ======================================================================
(defun drawKopfplAnsicht (Trschnitt_ID AbteilSchnitt x y seite)

     (setq deltaV (Traeger.get Trschnitt_ID delta_v)
	   hProf  (Traeger.get Trschnitt_ID h)
     )
;    (setq ySchnitt (+ y deltaV))
     (setq ySchnitt (+ y (* 0.5 hProf)))

     (if (= seite -1) 
         (setq bSeiteSchr "rechts" bSeiteBlech "links")
         (setq bSeiteSchr "links"  bSeiteBlech "rechts")
     )

     (drawing.delallayer draw1) 

     (layer "Profile") 
     (if (= seite -1) 
         (traeger.schnitt Trschnitt_ID x ySchnitt 0.0 "omlsr" AbteilSchnitt)
         (traeger.schnitt Trschnitt_ID x ySchnitt 0.0 "omlsl" AbteilSchnitt)
     )

     (setq dOK 0)
     (setq AnzBempBlechLayer (drawing.get draw1 AnzBemP "blech"))
     (print AnzBempBlechLayer)
     (if (> AnzBempBlechLayer 0) (progn
         (setq blBlech (Anbauteil.get AbteilSchnitt objekt blech))
         (if blBlech 
             (setq dOK (Blech.get blBlech dOK)
                   bp  (Blech.get blBlech dp)
             )
         )
     ))
     
     (setq scale (drawing.get draw1 scale)
           yOffset (/ 35.0 scale)
     )
     (print scale)

     
     (anbauteil.drawSwnBez ABTeilSchnitt (- x 200) (+ (- (* 0.5 hProf) deltaV dOK) (+ y yOffset)))


     (drawing.comblayer draw1 "profilq" "blech") 
     (drawing.comblayer draw1 "winkel") 
     (drawing.set draw1 (abstand 20.0) (schrift sg25) (versetzt 1)) 
     (drawing.layer_rect draw1 "combi") 
     (drawing.bem_ver draw1 "combi" bSeiteBlech) 

     (drawing.set draw1 (abstand 15.0)) 
     (drawing.bem_hor draw1 "blech" "oben") 
     (drawing.set draw1 (abstand 25.0)) 
     (drawing.bem_hor draw1 "combi" "oben")

     (drawing.set draw1 (abstand 20.0)) 
     (drawing.del_layer draw1 "combi")
     (drawing.comblayer draw1 "blech" "lochbild") ; Blech-Lochbild-Bem (falls Kopfplatte vorhanden)
     (drawing.comblayer_g draw1 "winkel") 	  ; Winkel dazu (falls Winkel vorhanden)
     (drawing.bem_ver draw1 "combi" bSeiteSchr)
     (drawing.bem_hor draw1 "combi" "unten")

)
; ======================================================================
; beachte Integer-Konstante lire 
; ----------------------------------------------------------------------
(defun bemaszeAkl (TrgEnde lire)  ; (TrgEnde bemLayer obenUnten linksRechts)

   (if (< lire 0)
	(setq bemlayer "traeger_li" obenUnten "oben" linksRechts "links"  AnzBemp (drawing.get draw1 anzBemP "traeger_li"))
	(setq bemlayer "traeger_re" obenUnten "oben" linksRechts "rechts" AnzBemp (drawing.get draw1 anzBemP "traeger_re"))
   )

   (setq AnzAkl (trende.get TrgEnde Anz_Akl))
   (if (= AnzAkl 0) 
      (progn
         (setq supress "0")

    	 (if AnzBemp (progn
  	    (if (> AnzBemp 0) (progn
		(drawing.set draw1 (abstand 15.0) (schrift sg25))
		(drawing.layer_rect draw1 bemLayer)
		(drawing.bem_hor draw1 bemLayer  obenUnten)
    	     ))
    	 ))
      )
     ; else
      (progn 
         (if (= AnzAkl 1) (setq supress "e") (setq supress "m"))

	;  Da es sich um einen ausgeklinkten Traeger handelt, muss die Ausklinkung
	;  vermaszt werden
	(setq scale (drawing.get draw1 scale))
	(drawing.set draw1 (abstand 15.0) (schrift sg25))
	(drawing.layer_rect draw1 bemLayer)
	(drawing.bem_hor draw1 bemLayer  obenUnten)
	(drawing.set draw1 (supress supress))
	(drawing.bem_ver draw1 bemLayer  linksRechts)
	(drawing.set draw1 (supress "0"))
      )
   )
)
; ====================================================================== 
(defun GesamtBemaszung_Ansicht_1 ()
    (print "dummy GesamtBemaszung_Ansicht")
)
(defun GesamtBemaszung_Ansicht ()
;   (print "in Bemaung der Ansicht")
;  (print "*clear*")
;   (drawing.dump_all draw1)

;   (drawing.showbem_p draw1 "traeger_li" 3.0 -2)
;   (drawing.showbem_p draw1 "traeger_re" 3.0 -2)


    (setq qstype (Traeger.get Wsz_Trg qsForm))

    (drawing.set draw1 (versetzt 0))

    (drawing.del_layer draw1 "combi")
    (drawing.comblayer draw1 "traeger_li" "traeger_re")
    (drawing.copy2layer draw1 "combi" "store1")
   
    ; so - und nun hier kombinieren - OFlansch, UFlansch, Steg

    (setq vAbstBem 40.0)
    
    
    (setq AnzBemp (drawing.get draw1 anzBemP "trg_coup_lchb_li"))
    (if (> AnzBemp 0) (progn
        (drawing.del_layer draw1 "combi")
        (drawing.comblayer draw1 "trg_coup_lchb_li" "abtl_coupon_li")
        (drawing.set draw1 (abstand vAbstBem) (schrift sg25) (versetzt 1))
        (drawing.bem_hor draw1 "combi"  "oben")    ; Bemassung Coupons mit Lochbildern
        (setq y2 (drawing.get draw1 y2))
        (setq vAbstBem (+ vAbstBem 10.0))
        (drawing.set draw1 (versetzt 0))
    ))

    (setq AnzBemp (drawing.get draw1 anzBemP "abtl_coupon_li"))
    (if (> AnzBemp 0) (progn
        (drawing.del_layer draw1 "combi")
        (drawing.comblayer draw1 "store1" "abtl_coupon_li")
        (drawing.set draw1 (abstand vAbstBem) (schrift sg25))
        (drawing.bem_hor draw1 "combi"  "oben")    ; Bemassung Coupons mit Lochbildern
        (setq y2 (drawing.get draw1 y2))
        (setq vAbstBem (+ vAbstBem 10.0))
        (drawing.set draw1 (versetzt 0))
    ))


    ; Bleche auf dem Oberflansch
    (drawing.del_layer draw1 "combi")
;   (drawing.comblayer draw1 "store1")
    (drawing.comblayer draw1 "trg_oberflansch")

    (drawing.comblayer draw1 "trg_of_bleche")
    (setq AnzBemp (drawing.get draw1 anzBemP "combi"))
    (if (> AnzBemp 2) (progn
       (drawing.set draw1 (abstand vAbstBem) (schrift sg25))
       (drawing.bem_hor draw1 "combi"  "oben")    ; Bemassung Traeger netto mit OF-Blechen
       (setq vAbstBem (+ vAbstBem 10.0))
    ))

    (drawing.set draw1 (abstand vAbstBem) (schrift sg35))
    (drawing.bem_hor_G draw1 "store1"  "oben" "Trgerachse")    ; Gesamtbemaung mit Endschrgen (knnte optional sein)
    (setq vAbstBem (+ vAbstBem 10.0))

    (setq VAbstandOben vAbstBem);

    ; ------------------------------------------------------------------
    (setq vAbstBem 30.0)
    (drawing.del_layer draw1 "combi")
    (drawing.comblayer_g draw1 "store1")
    (drawing.comblayer draw1 "trg_steg_lchb")
    
    (setq AnzBemp (drawing.get draw1 anzBemP "combi"))
    (if (> AnzBemp 2) (progn
        (drawing.set draw1 (abstand vAbstBem) (schrift sg25) (showadddist 1))
        (drawing.bem_hor draw1 "combi"  "unten")    ; Bemassung Traeger netto mit Lochbildern im Steg
        (setq y2 (drawing.get draw1 y2))
;       (drawing.set draw1 (y2 (- y2 vAbstBem)))
;       (setq vAbstBem 10.0)
        (setq vAbstBem (+ vAbstBem 10.0))
    ))

    (if (= qsType "L") (progn
        (print "Winkelansicht")
        (if (> AnzBemp 2) (progn
            (drawing.set draw1 (abstand 15.0) (schrift sg25) (versetzt 1) (showadddist 1))
            (drawing.bem_ver draw1 "combi"  "rechts")    ; Bemassung Traeger netto mit Stegblechen
            (drawing.set draw1 (versetzt 0))
        ))
    ))
   (drawing.set draw1 (showadddist 0))

    (setq AnzBemp (drawing.get draw1 anzBemP "trg_coup_lchb_re"))
    (if (> AnzBemp 0) (progn
        (drawing.del_layer draw1 "combi")
        (drawing.comblayer draw1 "trg_coup_lchb_re" "abtl_coupon_re")
        (drawing.set draw1 (abstand vAbstBem) (schrift sg25) (versetzt 1) (showadddist 0))
        (drawing.bem_hor draw1 "combi"  "unten")    ; Bemassung Coupons mit Lochbildern
        (setq y2 (drawing.get draw1 y2))
        (setq vAbstBem (+ vAbstBem 10.0))
        (drawing.set draw1 (versetzt 0) (showadddist 0))
    ))

    (setq AnzBemp (drawing.get draw1 anzBemP "abtl_coupon_re"))
    (if (> AnzBemp 0) (progn
        (drawing.del_layer draw1 "combi")
        (drawing.comblayer draw1 "store1" "abtl_coupon_re")
        (drawing.set draw1 (abstand vAbstBem) (schrift sg25) (showadddist 1))
        (drawing.bem_hor draw1 "combi"  "unten")    ; Bemassung Coupons mit Lochbildern
        (setq y2 (drawing.get draw1 y2))
        (setq vAbstBem (+ vAbstBem 10.0))
        (drawing.set draw1 (versetzt 0) (showadddist 0))
    ))


    (drawing.del_layer draw1 "combi")
    (drawing.comblayer_g draw1 "store1")
    (drawing.comblayer draw1 "trg_steg_bleche")
    (setq AnzBemp (drawing.get draw1 anzBemP "combi"))
    (if (> AnzBemp 2) (progn
        (drawing.set draw1 (abstand vAbstBem) (schrift sg25))
        (drawing.bem_hor draw1 "combi"  "unten")    ; Bemassung Traeger netto mit Stegblechen
        (setq vAbstBem (+ vAbstBem 10.0))
    ))


    (drawing.del_layer draw1 "combi")
;   (drawing.comblayer_g draw1 "store1")
    (drawing.comblayer draw1 "trg_unterflansch")
    (drawing.comblayer draw1 "trg_uf_bleche")
    (setq AnzBemp (drawing.get draw1 anzBemP "combi"))
    (if (> AnzBemp 2) (progn
        (drawing.set draw1 (abstand vAbstBem) (schrift sg25))
        (drawing.bem_hor draw1 "combi"  "unten")    ; Bemassung Traeger netto mit UF-Blechen
        (setq vAbstBem (+ vAbstBem 10.0))
    ))
        
    ; Bemaung der Schrauben oben ...
    (drawing.del_layer draw1 "combi")
    (drawing.comblayer_g draw1 "store1")
    (drawing.comblayer draw1 "trg_uf_lchb")
    (setq AnzBemp (drawing.get draw1 anzBemP "combi"))
    (if (> AnzBemp 2) (progn
        (drawing.set draw1 (abstand vAbstBem) (schrift sg25) (showadddist 1))
        (drawing.bem_hor draw1 "combi"  "unten")    ; Bemassung Traeger netto mit Lochbildern im Unterflansch
        (drawing.set draw1 (showadddist 0))
        (setq vAbstBem (+ vAbstBem 10.0))
    ))
        

    (drawing.del_layer draw1 "combi")
    (drawing.comblayer_g draw1 "store1")
    (drawing.comblayer draw1 "trg_of_lchb")
    (setq AnzBemp (drawing.get draw1 anzBemP "combi"))
    (if (> AnzBemp 2) (progn
        (drawing.set draw1 (abstand vAbstBem) (schrift sg25) (showadddist 1))
        (drawing.bem_hor draw1 "combi"  "oben")    ; Bemassung Traeger netto mit Lochbildern im Oberflansch
        (setq vAbstBem (+ vAbstBem 10.0))
    ))

    (drawing.set draw1 (abstand vAbstBem) (schrift sg35) (showadddist 0))
;    (drawing.bem_hor draw1 "trga_lb"  "unten")    ; Bemassung Traeger netto
;    (drawing.bem_hor draw1 "traegersys"  "unten")  ; Bemassung Traeger-Achsen


)

; ====================================================================== 
(defun GesamtBemaszung_Draufsicht_1 (SichtRichtung)
   (print "Dummy GesamtBemaszung_Draufsicht -----------")

;   Testen einzelner Layer fr die Bemaung
;   (drawing.dump_all draw1)
;   (drawing.layer_rect draw1 "traeger")
;   (drawing.set draw1 (abstand 20.0) (schrift sg25))
;   (drawing.bem_hor draw1 "trg_unterflansch"  "unten")    ; Bemassung Traeger netto mit Lochbildern im Oberflansch
;   (drawing.bem_hor draw1 "trg_oberflansch"  "oben")    ; Bemassung Traeger netto mit Lochbildern im Oberflansch

)
(defun GesamtBemaszung_Draufsicht (SichtRichtung)
    (print "Bemae Draufsicht")
;   (drawing.dump_all draw1)

;   Fr Kopf- und Fuplatten hier noch etwas einfallen lassen
;   nur eine kurze Makette am Kopf oder Fu des Trgers erforderlich
;    (drawing.comblayer draw1 "trga_abt")

    (drawing.del_layer draw1 "combi")
    (drawing.comblayer draw1 "traeger_li" "traeger_re")
    (drawing.copy2layer draw1 "combi" "store1")
    (drawing.copy2layer draw1 "traeger" "store1")

    (drawing.layer_rect draw1 "traeger")
    (drawing.set draw1 (versetzt 0))

;   (drawing.showbem_p draw1 "traeger_li" 3.0 -2)
;   (drawing.showbem_p draw1 "traeger_re" 3.0 -2)
;   (drawing.showbem_p draw1 "traeger" 3.0 -2)
;   (drawing.showbem_p draw1 "traegersys" 3.0 -2)
;   (drawing.showbem_p draw1 "trg_oberflansch"        5.0 -3)
;   (drawing.showbem_p draw1 "trg_oberflansch_links"  5.0 -3)
;   (drawing.showbem_p draw1 "trg_oberflansch_rechts" 5.0 -5)

;    (drawing.showbem_p draw1 "trg_unterflansch_links" 3.0 -2)
;    (drawing.showbem_p draw1 "trg_oberflansch_links" 4.0 -3)
;    (drawing.showbem_p draw1 "traeger" 3.0 -2)
;    (drawing.showbem_p draw1 "traeger" 4.0 -2)
;    (if (= SichtRichtung  1)     (drawing.showbem_p draw1 "trg_oberflansch_links" 3.0 -2))
;    (if (= SichtRichtung -1)     (drawing.showbem_p draw1 "trg_unterflansch_links" 3.0 -2))


    (setq qstype (Traeger.get Wsz_Trg qsForm))
    (if (= qsType "L") (drawing.copy2layer draw1 "store1" "trg_uf_lchb"))


    ; so - und nun hier kombinieren - Oberflansch
    (setq vAbstBem 15.0);

    ; ----- Bemaung Ausklinkungen Oberflansch/Unterflansch
    (if (= SichtRichtung  1) (setq BemHorLage "oben"))
    (if (= SichtRichtung -1) (setq BemHorLage "oben"))
    (setq AnzBemp (drawing.get draw1 anzBemP "traeger_li"))
    (if (> AnzBemp 0) (progn
       (drawing.layer_rect draw1 "traeger_li")
       (drawing.set draw1 (abstand vAbstBem) (schrift sg25) (supress "0") (versetzt 1))
       (drawing.bem_hor draw1 "traeger_li"  BemHorLage)    ; Bemassung Ausklinkung links im Flansch
       (drawing.set draw1 (versetzt 0))
       (drawing.bem_ver draw1 "traeger_li"  "rechts")      ; Bemassung Ausklinkung links im Flansch
       (setq AnzBemp (drawing.get draw1 anzBemP "traeger_re"))
       (if (= AnzBemp 0) (setq vAbstBem (+ vAbstBem 10.0)))
    ))
    (setq AnzBemp (drawing.get draw1 anzBemP "traeger_re"))
    (if (> AnzBemp 0) (progn
       (drawing.layer_rect draw1 "traeger_re")
       (drawing.set draw1 (abstand vAbstBem) (schrift sg25) (supress "0") (versetzt 1))
       (drawing.bem_hor draw1 "traeger_re"  BemHorLage)    ; Bemassung Flansch-Ausklinkung rechts
       (drawing.set draw1 (versetzt 0))
       (drawing.bem_ver draw1 "traeger_re"  "links")       ; Bemassung Flansch-Ausklinkung rechts
       (setq AnzBemp (drawing.get draw1 anzBemP "traeger_re"))
       (setq vAbstBem (+ vAbstBem 10.0))
    ))
    (drawing.set draw1 (versetzt 0))

    ; ----- Bemaung Lochbilder Oberflansch
    (drawing.del_layer draw1 "combi")
    (setq AnzBemp (drawing.get draw1 anzBemP "trg_of_lchb"))
    (if (> AnzBemp 0) (progn
        (drawing.comblayer_g draw1 "trg_oberflansch")
        (drawing.comblayer draw1 "trg_of_lchb")
        (drawing.set draw1 (abstand vAbstBem) (schrift sg25)  (showadddist 1))
        (drawing.bem_hor draw1 "combi"  "oben")    ; Bemassung Traeger netto mit Lochbildern im Oberflansch
        (setq y1 (drawing.get draw1 y1))
        (drawing.set draw1  (showadddist 0))
;       (drawing.set draw1 (y1 (+ y1 15.0)))
;       (setq vAbstBem 10.0)
        (setq vAbstBem (+ vAbstBem 10.0))
    ))
    (drawing.del_layer draw1 "combi")
    (drawing.comblayer_g draw1 "trg_oberflansch")
    (drawing.comblayer draw1 "trg_of_bleche")
    (setq AnzBemp (drawing.get draw1 anzBemP "combi"))
    (if (> AnzBemp 2) (progn
        (drawing.set draw1 (abstand vAbstBem) (schrift sg25))
        (drawing.bem_hor draw1 "combi"  "oben")    ; Bemassung Traeger netto mit OF-Blechen
        (setq vAbstBem (+ vAbstBem 10.0))
    ))

    (if (= qstype "L") (progn
      (print "Winkel-Draufsicht")
      (setq AnzBemp (drawing.get draw1 anzBemP "store1"))
      (if (> AnzBemp 2) (progn
         (print "Bemaung vertikal")
         (drawing.set draw1 (abstand 15.0) (schrift sg25)  (versetzt 1))
         (drawing.bem_ver draw1 "store1"  "rechts")    ; Lochbilder vertikal bei L-Profilen
         (drawing.set draw1  (versetzt 0))
      ))
    ))


    (drawing.del_layer draw1 "combi")
    (if (= SichtRichtung  1) (drawing.comblayer draw1 "trg_oberflansch_links"  "trg_oberflansch_rechts"))
    (if (= SichtRichtung -1) (drawing.comblayer draw1 "trg_unterflansch_links" "trg_unterflansch_rechts"))

    ; (drawing.comblayer draw1 "trg_oberflansch" "trg_unterflansch")

    (setq mKettenBezchn  0)
    (setq zeichneBem     1)
    (if (= SichtRichtung   1) (setq mKettenBezchn "Oberflansch"))
    (if (= SichtRichtung  -1) (setq mKettenBezchn "Unterflansch"))

    (if (= qstype "L") (setq zeichneBem     0))
    (if (= qstype "K") (setq zeichneBem     0))
    (if (= qstype "R") (setq zeichneBem     0))
    (if (= zeichneBem 1) (progn
        (drawing.set draw1 (abstand vAbstBem) (schrift sg35))
        (drawing.bem_hor_g draw1 "combi"  "oben" mKettenBezchn)    ; Bemaung Traeger netto gesamt
        (setq vAbstBem (+ vAbstBem 10.0))
    ))     
    (setq zeichneBem     1)

    (drawing.del_layer draw1 "combi")
    (if (= SichtRichtung   1) (progn

;	(drawing.showbem_p draw1 "traeger" 3.0 -2)
;	(drawing.showbem_p draw1 "traegersys" 3.0 -2)
;	(drawing.showbem_p draw1 "trg_oberflansch_links"   2.0 -3)
;	(drawing.showbem_p draw1 "trg_oberflansch_rechts"  2.0 -1)
;	(drawing.showbem_p draw1 "trg_unterflansch_links"  1.5 -2)
;	(drawing.showbem_p draw1 "trg_unterflansch_rechts" 1.5 -2)


    	(drawing.comblayer draw1 "trg_oberflansch_links"  "trg_oberflansch_rechts")
    	(drawing.comblayer draw1 "trg_unterflansch_links" "trg_unterflansch_rechts")
    	(drawing.comblayer draw1 "traegersys" "traeger")
    	
    	(if (= qstype "R") (progn
    	   (drawing.del_layer draw1 "combi")
    	   (drawing.comblayer draw1 "traeger")
    	))
    	(drawing.set draw1 (abstand vAbstBem) (schrift sg35))
    	
    	(drawing.bem_hor_g draw1 "combi"  "oben" "Profil gesamt")    ; Bemaung Traeger netto gesamt
    	(setq vAbstBem (+ vAbstBem 10.0))
    ))


    ; so - und nun hier kombinieren - Unterflansch
    (setq vAbstBem 15.0);
    (drawing.del_layer draw1 "combi")
    (setq AnzBemp (drawing.get draw1 anzBemP "trg_uf_lchb"))
    (setq AnzUnterflanschLchb AnzBemp) (print AnzUnterflanschLchb)
    (if (> AnzBemp 0) (progn
        (drawing.comblayer draw1 "trg_unterflansch_links")
        (drawing.comblayer draw1 "trg_uf_lchb")
        (drawing.set draw1 (abstand vAbstBem) (schrift sg25)  (showadddist 1))
        (drawing.bem_hor draw1 "combi"  "unten")    ; Bemassung Traeger netto mit Lochbildern im Oberflansch
;       (setq vAbstBem (+ vAbstBem 10.0))
        (setq y2 (drawing.get draw1 y2))
;       (drawing.set draw1 (y2 (- y2 15.0)))
        (drawing.set draw1  (showadddist 0))

;       (setq vAbstBem 10.0)
        (setq vAbstBem (+ vAbstBem 10.0))
    ))
    

    (drawing.del_layer draw1 "combi")
    (drawing.comblayer_g draw1 "store1")
    (drawing.comblayer draw1 "trg_steg_bleche")

    (setq AnzBemp (drawing.get draw1 anzBemP "combi"))
   (print AnzBemp)
    (if (> AnzBemp 2) (progn
        (drawing.set draw1 (abstand vAbstBem) (schrift sg25))
        (drawing.bem_hor draw1 "combi"  "unten")    ; Bemassung Traeger netto mit Stegblechen
        (setq vAbstBem (+ vAbstBem 10.0))
    ))

;  Achtung - nur einsetzen, wenn Augenbleche vorhanden sind:
   (setq AnzAugenBl (Traeger.get WSZ_Trg AnzAbtl Augenblech))
   (if (> AnzAugenBl 0) (progn
      (drawing.del_layer draw1 "combi")
      (drawing.comblayer_g draw1 "trg_oberflansch")
      (drawing.comblayer draw1 "trg_steg_bleche")
      (setq AnzBemp (drawing.get draw1 anzBemP "combi"))
      (if (> AnzBemp 2) (progn
          (drawing.set draw1 (abstand vAbstBem) (schrift sg25))
          (drawing.bem_hor draw1 "combi"  "unten")    ; Bemassung Traeger netto mit Stegblechen
          (setq vAbstBem (+ vAbstBem 10.0))
      ))
    ))


    (drawing.del_layer draw1 "combi")
;    (drawing.comblayer_g draw1 "store1")
    (drawing.comblayer_g draw1 "trg_unterflansch_links")
    (drawing.comblayer draw1 "trg_uf_bleche")
    (setq AnzBemp (drawing.get draw1 anzBemP "combi"))
    (if (> AnzBemp 2) (progn
        (drawing.set draw1 (abstand vAbstBem) (schrift sg25))
        (drawing.bem_hor draw1 "combi"  "unten")    ; Bemassung Traeger netto mit UF-Blechen
        (setq vAbstBem (+ vAbstBem 10.0))
    ))

    (setq DrawHorBem 0)
    (if (/= hWnklLi 90.0) (setq DrawHorBem 1))
    (if (/= hWnklRe 90.0) (setq DrawHorBem 1))

    (if (= DrawHorBem 1) (progn
        (drawing.del_layer draw1 "combi")
        (drawing.comblayer draw1 "traeger_li" "traeger_re")
        (drawing.set draw1 (abstand vAbstBem) (schrift sg25))
;        (drawing.bem_hor draw1 "combi"  "unten")    ; Bemassung Traeger Gesamtlnge
;    	(drawing.showbem_p draw1 "combi"        5.0 -3)
            (setq vAbstBem (+ vAbstBem 10.0))
    ))

    (drawing.del_layer draw1 "combi")
    (if (= qstype "R") 
        (print "Rohr - keine Bemaung")
    	(progn
            (if (= SichtRichtung  1) (drawing.comblayer draw1 "trg_oberflansch_links"  "trg_oberflansch_rechts"))
    	    (if (= SichtRichtung -1) (drawing.comblayer draw1 "trg_unterflansch_links" "trg_unterflansch_rechts"))
    	    (setq AnzBemp (drawing.get draw1 anzBemP "combi"))
	    (if (> AnzBemp 2) (progn
        	(drawing.set draw1 (abstand vAbstBem) (schrift sg35))
        	(drawing.bem_hor   draw1 "combi"  "unten")    ; Bemassung mit vertikalen Trgerenden 
    	    ))
    	)
    )


  
)

; ======================================================================
(defun showDebugInfos ()
;  (setq "_debug_" 1)
;  (line   -500   0   500    0)
;  (line     0    0   0    500)
;  (line -100 180   600	180)
  
  ;(line 100 -100 100 200)
  
;  (Traeger.set wsz_trg (delta_lr 200))
;  (Traeger.set wsz_trg (delta_v  100))

)
; ======================================================================
(defun drawCouponSchnitte (xSchnitt ySchnitt)

     (drawing.delallayer draw1) 
     (setq hProf     (Traeger.get wsz_trg h)
     	   ySchnitt  (+ ySchnitt (* 0.5 hProf))
     )
     (setq mStab (drawing.get draw1 scale))

     (setq abtlFirstCP (Traeger.get wsz_trg firstAbtl coupon))
     (if abtlFirstCP (Traeger.sortabtl wsz_trg))
 
     (setq abtlFirstCP (Traeger.get wsz_trg firstAbtl coupon))
     (while abtlFirstCP (progn
        (setq xPos_alt (Anbauteil.get abtlFirstCP xPos))
     	(print "Zeichne Coupon-Schnitt")
	
        (drawing.delallayer draw1) 						; Bemaung vorbereiten
        (traeger.schnitt wsz_trg xSchnitt ySchnitt 0.0 "omlsm" abtlFirstCP)	; Zeichnen
        ;  omlsm - das m an letzter Pos (0-4:4) bedeutet, dass es nicht am Ende mit Trgerneigung
        ;  gezeichnet werden soll sondern ein vertikaler Schnitt in der Mitte des Trgerprofils

	; ---------- Bemaungfunktion 
        (drawing.layer_rect draw1 "profilq")
        (drawing.set draw1 (abstand 15) (schrift sg25))
        (drawing.comblayer draw1 "abtl_coupon_li" "abtl_coupon_re")
        (drawing.bem_hor draw1 "combi" "oben")    ; Bemaung Coupon

        ; (drawing.comblayer_g draw1 "store1")
        (drawing.comblayer draw1 "profilq")
        (drawing.bem_ver draw1 "combi"  "rechts")    ; Bemaung Traeger und Coupon
        (drawing.bem_hor draw1 "combi"  "unten")   ; Bemaung Traeger und Coupon

	(if (= SchnitteErstellen 1) (progn
	    (drawing.createSchnPosBez draw1 abtlFirstCP (* mStab xSchnitt) (* mStab (+ ySchnitt 300)) 0.0)
        ))
        (anbauteil.drawSwnBez abtlFirstCP xSchnitt (+ ySchnitt 260))

        (setq abtlFirstCP (Traeger.get wsz_trg nextAbtl))
        
        
        ; --------- Anbauteile sind sortiert. Das nchste muss mindestens
        ; 10 mm entfernt sein, ansonsten sollte es mit der Schnittroutine
        ; mitgezeichnet werden.
        (if abtlFirstCP (progn
           (setq xPos_neu (Anbauteil.get abtlFirstCP xPos))
           (if (< (- xPos_neu xPos_alt) 10) (progn
	      (if (= SchnitteErstellen 1) (progn
	          (drawing.createSchnPosBez draw1 abtlFirstCP (* mStab xSchnitt) (* mStab (+ ySchnitt 400)) 0.0)
	      ))
              (anbauteil.drawSwnBez abtlFirstCP xSchnitt (+ ySchnitt 360))

              (setq abtlFirstCP (Traeger.get wsz_trg nextAbtl))
           ))
        ))
        (setq xSchnitt (+ xSchnitt 750))
               
        
     ))

)
