; ---------------------------------------------------------------------------
; Darstellung der WSZ-Ansicht
; Version 1.30		(April  2007)
; Version 1.32		(August 2007)
; Version 2.00		(Januar 2009)
; Version 2.01		(Mrz   2009)
; Version 5.00		(Mrz   2013)
; Version 12.00		(Jan    2022)
; ---------------------------------------------------------------------------

(defun Main__1 ()
  (if (objexist draw1)  (progn
		(setq bZeichnungsInit   0)	; Initialisierung nicht durchlaufen
     )
     (progn
		(setq bZeichnungsInit   1)	; Initialisierung anschlieend durchlaufen
		(setq draw1 (drawing.create))	; Drawing-Objekt erzeugen
     )
  )
  (if (= bZeichnungsInit 1) (progn
         (drawing.createTrgPosBez  draw1 WSZ_Trg 0.0 0.0 0.0 0.0)  ; Trgerposition nur beim ersten Aufruf eintragen
  ))

  (traeger.ansicht     WSZ_Trg  0.0 0.0 0  "masrbbds")
)
(defun Main__2 ()

  (if (objexist draw1)  (progn
		(setq bZeichnungsInit   0)	; Initialisierung nicht durchlaufen
     )
     (progn
		(setq bZeichnungsInit   1)	; Initialisierung anschlieend durchlaufen
		(setq draw1 (drawing.create))	; Drawing-Objekt erzeugen
     )
  )

    (traeger.drSicht WSZ_Trg 0.0  0.0  0.0 "meor s" "Draufsicht")

	(drawing.set draw1 (abstand 25) (versetzt 0))
    (drawing.layer_rect draw1 "traeger")
    (drawing.set draw1 (versetzt 0))
;    (drawing.bem_ver_G   draw1 "traeger"  "links")    ; Bemassung Schubprofillnge links
    (drawing.bem_ver   draw1 "traeger"  "rechts")    ; Bemassung Schubprofillnge links
;    (drawing.bem_hor_G   draw1 "traeger"  "unten")    ; Bemassung Schubprofillnge links
    (drawing.bem_hor   draw1 "traeger"  "oben")    ; Bemassung Schubprofillnge links

)

(defun Main__3 ()
   (print ">>>>>>>>>>>>>>> starte Werkstattzeichnungsprogramm")
   (setq ProfName (Traeger.get WSZ_Trg Profil))

   ; Definitionen, falls Config-Datei nicht geladen wird.
   (setq sg25 2.5)	;; zur Sicherheit hier defaultmig definieren
   (setq sg35 3.5)	;; zur Sicherheit hier defaultmig definieren
   (setq sgNC_Add 1.5)	;; zur Sicherheit hier defaultmig definieren
   (setq PosnrMode 1) 	;; zur Sicherheit hier defaultmig definieren
   (setq KplProjMode 0) ;; Defaultwert (amerikanische Darstellung)
   
   (loadConfig "bemaszungs_config.lsp")

   (setq QSForm   (Traeger.get WSZ_Trg QSForm))
   (if (= QSForm "G") (load "showStufenAnsicht"))
   
   (draw_traeger)


   (print "neu - alle Layer der Bemaung freigeben!")
   (drawing.delallayer draw1) 
   (print ">>>>>>>>>>>>>>> beende Werkstattzeichnungsprogramm")
)
(defun draw_traeger ()

; (showDebugInfos)	; Lokale Funktion um Linien zu zeichnen, etc.
		
;  (setq TrTest (traeger.create))
;  (setq TrLi   (trende.create))

;  ---- Zeichnen der Kopfplattenansichten ...
   (setq Trg_links   (traeger.get WSZ_Trg links))
   (setq Trg_rechts  (traeger.get WSZ_Trg rechts))

   (setq hWnklLi  (TrEnde.get Trg_links  H_Winkel)
         hWnklRe  (TrEnde.get Trg_rechts H_Winkel)
         vWnklLi  (TrEnde.get Trg_links  V_Winkel)
         vWnklRe  (TrEnde.get Trg_rechts V_Winkel)
   )

   (setq QSForm   (Traeger.get WSZ_Trg QSForm))

   (setq BlAbtlAnz (traeger.get WSZ_Trg AnzAbtl  Bleche     amOberflansch))
   (setq LbAbtlAnz (traeger.get WSZ_Trg AnzAbtl  Lochbilder amOberflansch))
   (setq amOberflansch (+ BlAbtlAnz LbAbtlAnz))

   (setq zeichneDraufsicht    1)	; Defaultwert Draufsicht 
   (if (/= hWnklLi 90.0)    (setq zeichneDraufsicht 1))
   (if (/= hWnklRe 90.0)    (setq zeichneDraufsicht 1))
   (if (>  amOberflansch 0) (setq zeichneDraufsicht 1))
   (if (= QSForm "R")       (setq zeichneDraufsicht 1))
   (if (= QSForm "L")       (setq zeichneDraufsicht 1))
   (if (= QSForm "F")       (setq zeichneDraufsicht 1))
   (if (= QSForm "K")       (setq zeichneDraufsicht 1))

   (setq BlAbtlAnz (traeger.get WSZ_Trg AnzAbtl  Bleche     amUnterflansch))
   (setq LbAbtlAnz (traeger.get WSZ_Trg AnzAbtl  Lochbilder amUnterflansch))
   (setq WiAbtlAnz (traeger.get WSZ_Trg AnzAbtl  Winkel     amUnterflansch))
   (setq TrAbtlAnz (traeger.get WSZ_Trg AnzAbtl  Traeger    amUnterflansch))
   (setq amUnterflansch (+ BlAbtlAnz LbAbtlAnz WiAbtlAnz TrAbtlAnz))
   (print BlAbtlAnz)
   (print LbAbtlAnz)
   (print amUnterflansch)

    (setq zeichneDruntersicht 0)
    (if (> amUnterflansch 0) (setq zeichneDruntersicht 1))
    (if (= QSForm "R")       (setq zeichneDruntersicht 0))
    (if (= QSForm "L")       (setq zeichneDruntersicht 0))
    ; (if (= QSForm "F")       (setq zeichneDruntersicht 0))
	(checkSpezielleAuskl Trg_links)
	(checkSpezielleAuskl Trg_rechts)
    
    ; nur zum Entwickeln zeichnen ...
    ; ein- oder ausschalten zum Testen
    ; (setq zeichneDruntersicht  0)
    ; (setq zeichneDraufsicht    0)

    (setq xMain   0.0)	;	noch nicht einsetzbar - Verschiebungen mssen
    (setq yMain   0.0)	; 	zurcksetzen, falls Druntersicht gezeichnet wird,
						;	bis ausgetestet.


;  (print "*clear*")
  (if (objexist draw1)  (progn
		(print "no op")
		; (setq bZeichnungsInit   0)	; Initialisierung nicht durchlaufen
     )
     (progn
		(setq bZeichnungsInit   1)	; Initialisierung anschlieend durchlaufen
		(setq draw1 (drawing.create))	; Drawing-Objekt erzeugen
  		(setq NaturGroesse (drawing.get draw1 NaturGroesse))
		(if (= NaturGroesse 1) (drawing.set draw1 (scale 1.0)))
     )
  )

  ; initialize values for drawing ...
  (drawing.setWeldingText draw1 "a = %d"  "a_St = %d, a_Fl = %d"   "a_Kpl = %d, a_Fl = %d, a_Trg = %d")
;  (drawing.setWeldingText draw1 "a = %d"  "a_rod = %d, a_Pka = %d"    "a_BlCz = %d, a_Pka = %d, a_Bel = %d")
  (drawing.set draw1 (txtszNCAdd sgNC_Add))
  (drawing.set draw1 (PosnrAusf  0))
  (drawing.set draw1 (StlAusf 1))

  
  (setq scale (drawing.get draw1 scale))
  (calcKplSchnittPos)

  (setq  hProf  (Traeger.get WSZ_Trg h)
	 bProf  (Traeger.get WSZ_Trg b)
	 dvProf (Traeger.get WSZ_Trg delta_v)
	 deltaV (Traeger.get WSZ_Trg delta_v)
  )
  (setq bProf_Versch (* 0.5 bProf))
  (if (= QSForm "U") (setq bProf_Versch (+ (/ 30.0 scale) bProf)))

  (print scale)
  ; (setq yMain (+ yMain dvProf))
  (print "yMain zu Beginn") (print yMain)
 
  (calcMaxHoeheAnsicht)		; Vouten und Kopfplatten fr Ansichtsbereich prfen --> hMaxAnsicht
 
   (setq yAbstandSchnitte (+ yMain (/ 200.0 scale)  (* 1.5 hProf) bProf_Versch))
   (setq yDraufsicht      (+ yMain (/  85.0 scale)  (* 0.5 hProf) bProf_Versch))
   (setq yDrunterSicht    (- yMain (/  70.0 scale)  (* 0.5 hProf) bProf_Versch))
   (setq y_StlPosition    (- yMain (/ 175.0  scale) (* 0.5 hProf)))
   
;   (AlertBox NaturGroesse)
   (if (= NaturGroesse 0) (setq yDrunterSicht (-  yDrunterSicht hMaxAnsicht)))
   
  (if (= zeichneDraufsicht   0) (setq yAbstandSchnitte (+ yMain (/ 100.0 scale)  (* 0.5 hProf))))
  (if (= zeichneDruntersicht 0) (setq y_StlPosition    (- yMain (/ 100.0 scale)  (* 0.5 hProf))))

  (if (= QSForm "F") (setq yAbstandSchnitte (+ yAbstandSchnitte (/ 20.0 scale))))

;   (setq p1 (coord.create))
;   (coord.set p1 (x   0.0)  (y  y_StlPosition))
;   (coord.draw p1 2.5 6)
  
   (if (= KplProjMode 1) (progn
        (setq yTausch		yDraufsicht)
        (setq yDraufsicht	yDrunterSicht)
        (setq yDrunterSicht	yTausch)

		(setq yDraufsicht      (- yMain (/  80.0 scale)  (* 1.0 hProf) bProf_Versch))
		(setq yDrunterSicht    (+ yMain (/  90.0 scale)  (* 0.5 hProf) bProf_Versch))

		(if (= NaturGroesse 0) (setq yDraufsicht (-  yDraufsicht hMaxAnsicht)))

		(setq yAbstandSchnitte (+ yMain (/ 200.0 scale)  (* 1.5 hProf)))
		(setq y_StlPosition    (- yMain (/ 200.0  scale) (* 0.5 hProf)))

		(if (= zeichneDruntersicht 0) (setq yAbstandSchnitte (+ yMain (/ 100.0 scale)  (* 0.5 hProf))))
   ))

  (if (= bZeichnungsInit 1) 
      (progn				;; else-Teil - Drawing-Objekt anlegen

	 (setq pXl (* xsLinks  scale)) (setq pYl (* (- deltaV) scale))
	 (setq pXr (* xsRechts scale)) (setq pYr (* (- deltaV) scale))
	 
	 (print "yMain fr Berechnung yScaled") (print yMain)
	 
	 (setq xScaled (* xMain    scale))
	 (setq yScaled (* yMain    scale))
;	 (setq yScaled yMain)
;	 (if (= NaturGroesse 1) (setq yScaled (+ yScaled deltaV)))

	 (if (= QType "c") (progn
		(print  hProf) (print deltaV)
		; (setq yScaled (+ yScaled (* deltaV scale)))
	 ))
	 
	 (setq pXl (+ pXl xScaled))
	 (setq pXr (+ pXr xScaled))
	 
	 (setq pXl_1 (- (* xsLinks scale) 20.0))
	 (setq pYl_1  50.0)

	 (setq pXl_2 (* xsLinks scale))
	 (setq pYl_2  10.0)
	 
         ; ..................................................................  Trgerpositionsbezeichnung
         (drawing.set draw1 (PosnrAusf PosnrMode))
         (drawing.createTrgPosBez  draw1 WSZ_Trg xScaled yScaled 0.0 0.0)  ; Trgerposition nur beim ersten Aufruf eintragen
         (drawing.set draw1 (PosnrAusf 0))

	 (setq xOffset (/ 40.0 scale))
	 
     )
  )
  (drawing.delallayer draw1)		;; Bemaungslayer aber jedes Mal freigeben.

; ------ A N S I C H T ----------------------------------------------
; ----- Traeger in der Ansicht zeichnen und anschlieend bemaen
   (setq VAbstandOben 0.0)
   (layer "stahl")
   ; .......................................................................  Trger Ansicht zeichnen
    (traeger.ansicht     WSZ_Trg  xMain yMain 0  "masrbbds")
    (drawing.layer_rect draw1 "trga_lb")		   ; neu
	(if (= QType "F") (progn
	   (drawing.del_layer draw1 "combi")
	   (drawing.comblayer draw1 "traeger_li" "traeger_re")
       (drawing.layer_rect draw1 "combi")		   ; neu
	))
;   (drawing.showbem_p draw1 "trga_lb" 3.0 -2)
;   (drawing.showbem_p draw1 "traeger_li" 3.0 -2)
;   (drawing.showbem_p draw1 "traeger_re" 3.0 -2)
;   (drawing.showbem_p draw1 "profilq" 3.0 -2)
;   (drawing.showbem_p draw1 "traeger" 3.0 -2)

   ; .......................................................................  Bemaung Ansicht zeichnen
    (GesamtBemaszung_Ansicht)

    (bemaszeAkl Trg_links  -1) ; links  bemaen ... "traeger_li" "oben" "rechts"
    (bemaszeAkl Trg_rechts  1) ; rechts bemaem ... "traeger_re" "oben" "links"

    (drawing.delallayer draw1)

;  ---- Zeichnen der Kopfplattenansichten ...
   (setq bProf   (Traeger.get WSZ_Trg b)
         hProf   (Traeger.get WSZ_Trg h)
         sysLng  (Traeger.get WSZ_Trg syslng)
;         bp    (Blech.get *NochErmitteln* bp)	 
   )
   (setq scale (drawing.get draw1 scale))

;  Achtung - wird oben schon einmal berechnet.
;  Wenn nderungen, dann bei beiden Berechnungen angleichen!
  (calcKplSchnittPos)

   (setq  AnzAugenBl (Traeger.get WSZ_Trg AnzAbtl Augenblech))
   (if (> AnzAugenBl 0) (progn
	 (setq trgLaenge (traeger.get wsz_Trg Laenge))
     (setq abtlAugBl (Traeger.get wsz_trg firstAbtl Augenblech))
     (while abtlAugBl
       (setq xPosABl (Anbauteil.get abtlAugBl XPos))
       (if (> xPosABl (* 0.5 trgLaenge)) 
		  (setq xPosABl (+ xPosABl 50.0))
		  (progn
			(setq bl_Augbl (Anbauteil.get  abtlAugBl objekt Blech))
			(setq hp_Bl (Blech.get bl_Augbl hp))
			(setq xPosABl (- xPosABl hp_Bl -50.0))
		  )
	   )
       ; ....................................................................  Schweinaht, PosBez zeichnen
       ; (anbauteil.drawPosBez abtlAugBl xPosABl (+ yDraufsicht (/ 30.0 scale)))
       ; (anbauteil.drawSwnBez abtlAugBl xPosABl (+ yDraufsicht (/ 26.5 scale)))

        (setq abtlAugBl (Traeger.get wsz_trg nextAbtl))
     )
   ))


; ------ D R A U F S I C H T ----------------------------------------------
; ----- Traeger in der Draufsicht zeichnen und anschlieend bemaen
    (drawing.delallayer draw1)
    
    (setq hWszTrg (Traeger.get WSZ_Trg h)
    	  bWszTrg (Traeger.get WSZ_Trg b)
    )

    (if (= zeichneDruntersicht 1) (progn
        (drawing.delallayer draw1)
        (traeger.drSicht WSZ_Trg 0.0   yDrunterSicht  0.0 "meor s" "Druntersicht")
        (GesamtBemaszung_Draufsicht -1)
    ))

    (drawing.delallayer draw1)
    (if (= QSForm "I") (setq VAbstandOben (+ VAbstandOben 250.0)))
    (if (= zeichneDraufsicht 1) (progn
        (drawing.delallayer draw1)
        (traeger.drSicht WSZ_Trg 0.0  yDraufsicht  0.0 "meor s" "Draufsicht")
        (GesamtBemaszung_Draufsicht 1)
    ))

    (setq sysLng (Traeger.get WSZ_Trg laenge)
          hProf  (Traeger.get WSZ_Trg h)
    )
	
    (drawing.delallayer draw1)
    
    (if (= bZeichnungsInit 1) 
		(drawing.OptimizePosBez draw1)
    )
	(setq bZeichnungsInit   0)
)
; ======================================================================
; beachte Integer-Konstante lire 
; ----------------------------------------------------------------------
(defun bemaszeAkl (TrgEnde lire)  ; (TrgEnde bemLayer obenUnten linksRechts)

   (if (< lire 0)
	(setq bemlayer "traeger_li" obenUnten "oben" linksRechts "links"  AnzBemp (drawing.get draw1 anzBemP "traeger_li"))
	(setq bemlayer "traeger_re" obenUnten "oben" linksRechts "rechts" AnzBemp (drawing.get draw1 anzBemP "traeger_re"))
   )

   (setq VoutOben  (TrEnde.get TrgEnde voute_oben))
   (setq VoutUnten (TrEnde.get TrgEnde voute_unten))
   (if (= VoutOben 1) (progn
        (setq supress "0")
   	(if (< lire 0) 
   	 	(setq vBemLayer "trg_oberflansch_links")
   	 	(setq vBemLayer "trg_oberflansch_rechts")
   	)
	(drawing.set draw1 (abstand 15.0) (schrift sg25))
	(drawing.layer_rect draw1 vBemLayer)
	(drawing.bem_hor draw1 vBemLayer  "oben")
   ))
   (if (= VoutUnten 1) (progn
        (setq supress "0")
   	(if (< lire 0) 
   	 	(setq vBemLayer "trg_unterflansch_links")
   	 	(setq vBemLayer "trg_unterflansch_rechts")
   	)
	(drawing.set draw1 (abstand 15.0) (schrift sg25))
	(drawing.layer_rect draw1 vBemLayer)
	(drawing.bem_hor draw1 vBemLayer  "unten")
   ))
   (if (> (+ VoutOben VoutUnten) 0) (progn
	(drawing.del_layer draw1 "combi")
   	(if (< lire 0) 
	    (drawing.comblayer draw1 "trg_oberflansch_links" "trg_unterflansch_links") ; 
	    (drawing.comblayer draw1 "trg_oberflansch_rechts" "trg_unterflansch_rechts") ; 
	)
	(drawing.set draw1 (abstand 10.0) (schrift sg25))
	(drawing.layer_rect draw1 "combi")
	(if (< lire 0)	(drawing.bem_ver draw1 "combi"  "links")
			(drawing.bem_ver draw1 "combi"  "rechts")
	)
   ))


   (setq AnzAkl (trende.get TrgEnde Anz_Akl))
;   (print  AnzAkl)
   (if (= AnzAkl 0) 
      (progn
         (setq supress "0")

    	 (if AnzBemp (progn
  	    (if (> AnzBemp 0) (progn
		(drawing.set draw1 (abstand 15.0) (schrift sg25))
		(drawing.layer_rect draw1 bemLayer)
		(drawing.bem_hor draw1 bemLayer  obenUnten)
    	     ))
    	 ))
      )
     ; else
      (progn 
        (setq supress "e")
        (setq supress "0")
        (if (= AnzAkl 2) (setq supress "m"))

        ; (drawing.showbem_p draw1 bemLayer 3.0 -2)

	;  Da es sich um einen ausgeklinkten Traeger handelt, muss die Ausklinkung
	;  vermaszt werden
	(setq scale (drawing.get draw1 scale))
	
	(drawing.set draw1 (abstand 15.0) (schrift sg25))
	;  (drawing.layer_rect draw1 bemLayer)
	(drawing.layer_rect draw1 "traeger")
	(drawing.bem_hor draw1 bemLayer  obenUnten)
	(drawing.set draw1 (supress supress))
	(drawing.bem_ver draw1 bemLayer  linksRechts)
	(drawing.set draw1 (supress "0"))
      )
   )
)
; ====================================================================== 
(defun GesamtBemaszung_Ansicht_1 ()
    (print "dummy GesamtBemaszung_Ansicht")
)
(defun GesamtBemaszung_Ansicht ()
   (print "in Bemaung der Ansicht")
   ; (drawing.dump_all draw1)

    (setq qstype (Traeger.get Wsz_Trg qsForm))

    (drawing.set draw1 (versetzt 0))

    (drawing.del_layer draw1 "combi")
    (drawing.comblayer draw1 "traeger_li" "traeger_re")
    (drawing.copy2layer draw1 "combi" "store1")

    ; eingesetzt Jan. 2012 - ging vorher anscheinend auch ohne
    ; (drawing.layer_rect draw1 "combi")
    ; (drawing.showbem_p draw1 "combi" 3.0 -2)
    ; (drawing.showbem_p draw1 "traeger" 3.0 -2)
    (drawing.layer_rect draw1 "traeger")
	
    ; so - und nun hier kombinieren - OFlansch, UFlansch, Steg

    (setq vAbstBem 40.0)

    
    (setq AnzBemp (drawing.get draw1 anzBemP "trg_coup_lchb_li"))
    (if (> AnzBemp 0) (progn
        (drawing.del_layer draw1 "combi")
        (drawing.comblayer draw1 "trg_coup_lchb_li" "abtl_coupon_li")
        (drawing.set draw1 (abstand vAbstBem) (schrift sg25) (versetzt 1))
        (drawing.bem_hor draw1 "combi"  "oben")    ; Bemassung Coupons mit Lochbildern
        (setq y2 (drawing.get draw1 y2))
        (setq vAbstBem (+ vAbstBem 10.0))
        (drawing.set draw1 (versetzt 0))
    ))

    (setq AnzBemp (drawing.get draw1 anzBemP "abtl_coupon_li"))
    (if (> AnzBemp 0) (progn
        (drawing.del_layer draw1 "combi")
        (drawing.comblayer draw1 "store1" "abtl_coupon_li")
        (drawing.set draw1 (abstand vAbstBem) (schrift sg25))
        (drawing.bem_hor draw1 "combi"  "oben")    ; Bemassung Coupons mit Lochbildern
        (setq y2 (drawing.get draw1 y2))
        (setq vAbstBem (+ vAbstBem 10.0))
        (drawing.set draw1 (versetzt 0))
    ))

    ; Bleche auf dem Oberflansch
    (drawing.del_layer draw1 "combi")
;   (drawing.comblayer draw1 "store1")
    (drawing.comblayer draw1 "trg_oberflansch")

    (drawing.comblayer draw1 "trg_of_bleche")
    (setq AnzBemp (drawing.get draw1 anzBemP "combi"))
    (if (> AnzBemp 2) (progn
       (drawing.set draw1 (abstand vAbstBem) (schrift sg25))
       (drawing.bem_hor draw1 "combi"  "oben")    ; Bemassung Traeger netto mit OF-Blechen
       (setq vAbstBem (+ vAbstBem 10.0))
    ))

;   (drawing.showbem_p draw1 "store1" 3.0 -2)

    (drawing.set draw1 (abstand vAbstBem) (schrift sg35))
    (setq bemK_Bez "Trgerachse") ; translate pl  "axis of beam"
    (if (/= qstype "F")
       (drawing.bem_hor_G draw1 "store1"  "oben" bemK_Bez)    ; Gesamtbemaung mit Endschrgen (knnte optional sein)
    )
    (setq vAbstBem (+ vAbstBem 10.0))

    (setq VAbstandOben vAbstBem);

    ; ------------------------------------------------------------------
    ; ------------------------------------------------------------------
    (setq AnzBemp (drawing.get draw1 anzBemP "kopf_winkel_links"))
    (if (> AnzBemp 0) (progn
        (drawing.set draw1 (abstand 10.0) (schrift sg25) (versetzt 1))
		(drawing.del_layer draw1 "combi")
        (drawing.comblayer_g draw1 "kopf_winkel_links")
        (drawing.comblayer_i draw1 "trg_steg_lchb")
        
        ; (drawing.bem_hor draw1 "combi"  "unten")    ; Bemassung Winkel mit Lochbildern
		; (drawing.showbem_p draw1 "combi" 3.0 -2)
    ))

    (setq AnzBemp (drawing.get draw1 anzBemP "kopf_winkel_rechts"))
    (if (> AnzBemp 0) (progn
        (drawing.set draw1 (abstand 10.0) (schrift sg25))
		(drawing.del_layer draw1 "combi")
        (drawing.comblayer_g draw1 "kopf_winkel_rechts")
        (drawing.comblayer_i draw1 "trg_steg_lchb")
        
        (drawing.bem_hor draw1 "combi"  "unten")    ; Bemassung Winkel mit Lochbildern
		; (drawing.showbem_p draw1 "combi" 3.0 -2) 
    ))
    (drawing.set draw1 (versetzt 0))

    ; ------------------------------------------------------------------

    (setq vAbstBem 30.0)
    (drawing.del_layer draw1 "combi")
    (drawing.comblayer_g draw1 "store1")
    (if (/= qsType "F") (progn
		(drawing.comblayer draw1 "trg_steg_lchb")
	))

	; (drawing.showbem_p draw1 "store1" 5.0 -2) 

    (setq AnzBemp (drawing.get draw1 anzBemP "combi"))
    (if (> AnzBemp 2) (progn
        (drawing.set draw1 (abstand vAbstBem) (schrift sg25) (showadddist 1))
        (drawing.bem_hor draw1 "combi"  "unten")    ; Bemassung Traeger netto mit Lochbildern im Steg
        (setq y2 (drawing.get draw1 y2))
;       (drawing.set draw1 (y2 (- y2 vAbstBem)))
;       (setq vAbstBem 10.0)
        (setq vAbstBem (+ vAbstBem 10.0))
		; (drawing.showbem_p draw1 "combi" 4.0 -2) 
    ))

     (if (= qsType "L") (progn
        (print "Winkelansicht")
	    (drawing.del_layer draw1 "combi")
		(drawing.comblayer draw1 "traeger_li" "traeger_re")
		; (drawing.comblayer draw1 "trg_oberflansch")
		; (drawing.comblayer draw1 "trg_of_lchb")
		; (drawing.comblayer draw1 "trg_of_bleche")
		; (drawing.showbem_p draw1 "combi" 3.0 -2) 
		(setq AnzBemp (drawing.get draw1 anzBemP "combi"))
        (if (>= AnzBemp 2) (progn
            (drawing.set draw1 (abstand 15.0) (schrift sg25) (versetzt 1) (showadddist 0))
            (drawing.bem_ver draw1 "combi"  "rechts")    ; Bemassung Traeger netto mit Stegblechen
            (drawing.set draw1 (versetzt 0))
        ))
    ))
   (drawing.set draw1 (showadddist 0))

    (setq AnzBemp (drawing.get draw1 anzBemP "trg_coup_lchb_re"))
    (if (> AnzBemp 0) (progn
        (drawing.del_layer draw1 "combi")
        (drawing.comblayer draw1 "trg_coup_lchb_re" "abtl_coupon_re")
        (drawing.set draw1 (abstand vAbstBem) (schrift sg25) (versetzt 1) (showadddist 0))
        (drawing.bem_hor draw1 "combi"  "unten")    ; Bemassung Coupons mit Lochbildern
        (setq y2 (drawing.get draw1 y2))
        (setq vAbstBem (+ vAbstBem 10.0))
        (drawing.set draw1 (versetzt 0) (showadddist 0))
    ))

    (setq AnzBemp (drawing.get draw1 anzBemP "abtl_coupon_re"))
    (if (> AnzBemp 0) (progn
        (drawing.del_layer draw1 "combi")
        (drawing.comblayer draw1 "store1" "abtl_coupon_re")
        (drawing.set draw1 (abstand vAbstBem) (schrift sg25) (showadddist 1))
        (drawing.bem_hor draw1 "combi"  "unten")    ; Bemassung Coupons mit Lochbildern
        (setq y2 (drawing.get draw1 y2))
        (setq vAbstBem (+ vAbstBem 10.0))
        (drawing.set draw1 (versetzt 0) (showadddist 0))
    ))

	; Hier Flachstahl - Korrektur - Stegbleche in Zukunft besser in der breiten Ansicht vermaen
    (drawing.del_layer draw1 "combi")
	; ---------------------------
	; (drawing.showbem_p draw1 "store1" 2.0 -2)
	; (drawing.showbem_p draw1 "trg_steg_bleche" 3.0 -2)
	(if (= QSForm "F") (drawing.layer_rect draw1 "store1"))
	; ---------------------------
    (drawing.comblayer_g draw1 "store1")
    (drawing.comblayer draw1 "trg_steg_bleche")
    (setq AnzBemp (drawing.get draw1 anzBemP "combi"))
    (if (> AnzBemp 2) (progn
        (drawing.set draw1 (abstand vAbstBem) (schrift sg25))
        (drawing.bem_hor draw1 "combi"  "unten")    ; Bemassung Traeger netto mit Stegblechen
        (setq vAbstBem (+ vAbstBem 10.0))
		; (drawing.showbem_p draw1 "combi" 4.0 -2) 
    ))

    (drawing.del_layer draw1 "combi")
    (drawing.comblayer_g draw1 "store1")
    (setq AnzBemp (drawing.get draw1 anzBemP "profilq"))
    (if (> AnzBemp 2) (progn
    	(drawing.comblayer_g draw1 "profilq")
        (drawing.set draw1 (abstand vAbstBem) (schrift sg25))
        (drawing.bem_hor draw1 "combi"  "unten")    ; Bemassung Traeger netto mit Stegblechen
        (setq vAbstBem (+ vAbstBem 10.0))
    ))

    (drawing.del_layer draw1 "combi")
;   (drawing.comblayer_g draw1 "store1")
    (drawing.comblayer draw1 "trg_unterflansch")
    (drawing.comblayer draw1 "trg_uf_bleche")
    (setq AnzBemp (drawing.get draw1 anzBemP "combi"))
    (if (> AnzBemp 2) (progn
        (drawing.set draw1 (abstand vAbstBem) (schrift sg25))
        (drawing.bem_hor draw1 "combi"  "unten")    ; Bemassung Traeger netto mit UF-Blechen
        (setq vAbstBem (+ vAbstBem 10.0))
    ))
        
    ; Bemaung der Schrauben oben ...
    (drawing.del_layer draw1 "combi")
    (drawing.comblayer_g draw1 "store1")
    (drawing.comblayer draw1 "trg_uf_lchb")
    (setq AnzBemp (drawing.get draw1 anzBemP "combi"))
    (if (> AnzBemp 2) (progn
        (drawing.set draw1 (abstand vAbstBem) (schrift sg25) (showadddist 1))
        (drawing.bem_hor draw1 "combi"  "unten")    ; Bemassung Traeger netto mit Lochbildern im Unterflansch
        (drawing.set draw1 (showadddist 0))
        (setq vAbstBem (+ vAbstBem 10.0))
    ))
        

    (drawing.del_layer draw1 "combi")
    (drawing.comblayer_g draw1 "store1")
    (drawing.comblayer draw1 "trg_of_lchb")
    (setq AnzBemp (drawing.get draw1 anzBemP "combi"))
    (if (> AnzBemp 2) (progn
        (drawing.set draw1 (abstand vAbstBem) (schrift sg25) (showadddist 1))
        (drawing.bem_hor draw1 "combi"  "oben")    ; Bemassung Traeger netto mit Lochbildern im Oberflansch
        (setq vAbstBem (+ vAbstBem 10.0))
    ))

    (drawing.set draw1 (abstand vAbstBem) (schrift sg35) (showadddist 0))
;    (drawing.bem_hor draw1 "trga_lb"  "unten")    ; Bemassung Traeger netto
;    (drawing.bem_hor draw1 "traegersys"  "unten")  ; Bemassung Traeger-Achsen


    ; ------------------------------------------------------------------
    (setq AnzBemp (drawing.get draw1 anzBemP "kopf_winkel_links"))
    (if (> AnzBemp 0) (progn
        (drawing.set draw1 (abstand 15.0) (schrift sg25) (versetzt 1))
		(drawing.del_layer draw1 "combi")
        (drawing.comblayer_g draw1 "kopf_winkel_links")
        (drawing.comblayer_i draw1 "trg_steg_lchb")
        
        (drawing.layer_rect draw1 "combi")
        
        (drawing.bem_ver draw1 "combi"  "links")    ; Bemassung Winkel mit Lochbildern
	;	(drawing.showbem_p draw1 "combi" 3.0 -2)

        (drawing.bem_hor draw1 "combi"  "unten")    ; Bemassung Winkel mit Lochbildern
    ))

    (setq AnzBemp (drawing.get draw1 anzBemP "kopf_winkel_rechts"))
    (if (> AnzBemp 0) (progn
        (drawing.set draw1 (abstand 10.0) (schrift sg25))
	(drawing.del_layer draw1 "combi")
        (drawing.comblayer_g draw1 "kopf_winkel_rechts")
        (drawing.comblayer_i draw1 "trg_steg_lchb")

        (drawing.layer_rect draw1 "combi")
        
        (drawing.bem_ver draw1 "combi"  "rechts")    ; Bemassung Winkel mit Lochbildern
	;	(drawing.showbem_p draw1 "combi" 3.0 -2) 
    ))
    (drawing.set draw1 (versetzt 0))

    ; Schubprofil-Bemaung
    (setq AnzBemp (drawing.get draw1 anzBemP "schubprofil_li"))
    (if (> AnzBemp 1) (progn
	(drawing.layer_rect draw1 "schubprofil_li")
        (drawing.set draw1 (abstand 10) (schrift sg25) (versetzt 0))
        (drawing.bem_hor   draw1 "schubprofil_li"  "oben")    ; Bemassung Schubprofillnge links
    ))
    (setq AnzBemp (drawing.get draw1 anzBemP "schubprofil_re"))
    (if (> AnzBemp 1) (progn
	(drawing.layer_rect draw1 "schubprofil_re")
        (drawing.set draw1 (abstand 10) (schrift sg25) (versetzt 0))
        (drawing.bem_hor   draw1 "schubprofil_re"  "oben")    ; Bemassung Schubprofillnge links
    ))


)

; ====================================================================== 
(defun GesamtBemaszung_Draufsicht_1 (SichtRichtung)
   (print "Dummy GesamtBemaszung_Draufsicht -----------")

;   Testen einzelner Layer fr die Bemaung
;   (drawing.dump_all draw1)
;   (drawing.layer_rect draw1 "traeger")
;   (drawing.set draw1 (abstand 20.0) (schrift sg25))
;   (drawing.bem_hor draw1 "trg_unterflansch"  "unten")    ; Bemassung Traeger netto mit Lochbildern im Oberflansch
;   (drawing.bem_hor draw1 "trg_oberflansch"  "oben")    ; Bemassung Traeger netto mit Lochbildern im Oberflansch

)
(defun GesamtBemaszung_Draufsicht (SichtRichtung)
    (print "Bemae Draufsicht")
;   (drawing.dump_all draw1)

;   Fr Kopf- und Fuplatten hier noch etwas einfallen lassen
;   nur eine kurze Makette am Kopf oder Fu des Trgers erforderlich
;    (drawing.comblayer draw1 "trga_abt")

    (drawing.del_layer draw1 "combi")
    (drawing.comblayer draw1 "traeger_li" "traeger_re")
    (drawing.copy2layer draw1 "combi" "store1")
    (drawing.copy2layer draw1 "traeger" "store1")

    (drawing.layer_rect draw1 "traeger")
    (drawing.set draw1 (versetzt 0))

;   (drawing.showbem_p draw1 "schubprofil_li" 3.0 -2)
;   (drawing.showbem_p draw1 "schubprofil_re" 3.0 -2)
;    (drawing.showbem_p draw1 "traeger_li" 3.0 -2)
;   (drawing.showbem_p draw1 "traeger_re" 3.0 -2)
;   (drawing.showbem_p draw1 "traeger" 3.0 -2)
;   (drawing.showbem_p draw1 "traegersys" 3.0 -2)
;   (drawing.showbem_p draw1 "trg_oberflansch"        5.0 -3)
;   (drawing.showbem_p draw1 "trg_oberflansch_links"  5.0 -3)
;   (drawing.showbem_p draw1 "trg_oberflansch_rechts" 5.0 -5)

;    (drawing.showbem_p draw1 "trg_unterflansch_links" 3.0 -2)
;    (drawing.showbem_p draw1 "trg_oberflansch_links" 4.0 -3)
;    (drawing.showbem_p draw1 "trg_uf_lchb" 3.0 -2)
;    (drawing.showbem_p draw1 "trg_unterflansch" 4.0 -2)
;    (if (= SichtRichtung  1)     (drawing.showbem_p draw1 "trg_oberflansch_links" 3.0 -2))
;    (if (= SichtRichtung -1)     (drawing.showbem_p draw1 "trg_unterflansch_links" 3.0 -2))

;   (if (= SichtRichtung  1)     (drawing.showbem_p draw1 "trg_of_lchb" 3.0 -2))
;    (if (= SichtRichtung -1)     (drawing.showbem_p draw1 "trg_uf_lchb" 3.0 -2))

;    (if (= SichtRichtung  1)     (drawing.showbem_p draw1 "trg_steg_bleche" 3.0 -1))
;    (if (= SichtRichtung  1)     (drawing.showbem_p draw1 "abtl_coupon_li" 3.0 -2))
;    (if (= SichtRichtung  1)     (drawing.showbem_p draw1 "abtl_coupon_re" 3.0 -2))



    (setq qstype (Traeger.get Wsz_Trg qsForm))
    (if (= qsType "L") (drawing.copy2layer draw1 "store1" "trg_uf_lchb"))


    ; so - und nun hier kombinieren - Oberflansch
    (setq vAbstBem 15.0);

    ; ----- Bemaung Ausklinkungen Oberflansch/Unterflansch
    (if (= SichtRichtung  1) (setq BemHorLage "oben"))
    (if (= SichtRichtung -1) (setq BemHorLage "oben"))
    (setq AnzBemp (drawing.get draw1 anzBemP "traeger_li"))
	(if (= qsType "R") (setq AnzBemp 0))
    (if (> AnzBemp 0) (progn
       (drawing.layer_rect draw1 "traeger_li")
       (drawing.set draw1 (abstand vAbstBem) (schrift sg25) (supress "0") (versetzt 1))
       (drawing.bem_hor draw1 "traeger_li"  BemHorLage)    ; Bemassung Ausklinkung links im Flansch
       (drawing.set draw1 (versetzt 0))
       (drawing.bem_ver draw1 "traeger_li"  "rechts")      ; Bemassung Ausklinkung links im Flansch
       (setq AnzBemp (drawing.get draw1 anzBemP "traeger_re"))
       (if (= AnzBemp 0) (setq vAbstBem (+ vAbstBem 10.0)))
    ))
    (setq AnzBemp (drawing.get draw1 anzBemP "traeger_re"))
	(if (= qsType "R") (setq AnzBemp 0))
    (if (> AnzBemp 0) (progn
       (drawing.layer_rect draw1 "traeger_re")
       (drawing.set draw1 (abstand vAbstBem) (schrift sg25) (supress "0") (versetzt 1))
       (drawing.bem_hor draw1 "traeger_re"  BemHorLage)    ; Bemassung Flansch-Ausklinkung rechts
       (drawing.set draw1 (versetzt 0))
       (drawing.bem_ver draw1 "traeger_re"  "links")       ; Bemassung Flansch-Ausklinkung rechts
       (setq AnzBemp (drawing.get draw1 anzBemP "traeger_re"))
       (setq vAbstBem (+ vAbstBem 10.0))
    ))
    (drawing.set draw1 (versetzt 0))

    ; ----- Bemaung Lochbilder Oberflansch
    (drawing.del_layer draw1 "combi")
    (setq AnzBemp (drawing.get draw1 anzBemP "trg_of_lchb"))
    (if (> AnzBemp 0) (progn
        (drawing.comblayer_g draw1 "trg_oberflansch")
        (drawing.comblayer draw1 "trg_of_lchb")
        (drawing.set draw1 (abstand vAbstBem) (schrift sg25)  (showadddist 1))
		
		; Bemassung Traeger netto mit Lochbildern im Oberflansch - bei Flachstahl unterhalb des Profils
		(if (= qsType "F") 
			(drawing.bem_hor draw1 "combi"  "unten")    
			(drawing.bem_hor draw1 "combi"  "oben")    
		)
        (setq y1 (drawing.get draw1 y1))
        (drawing.set draw1  (showadddist 0))
;       (drawing.set draw1 (y1 (+ y1 15.0)))
;       (setq vAbstBem 10.0)
        (setq vAbstBem (+ vAbstBem 10.0))
    ))
    (drawing.del_layer draw1 "combi")
    (drawing.comblayer_g draw1 "trg_oberflansch")
    (drawing.comblayer draw1 "trg_of_bleche")
    (setq AnzBemp (drawing.get draw1 anzBemP "combi"))
	(if (> AnzBemp 2) (progn
        (drawing.set draw1 (abstand vAbstBem) (schrift sg25))
        (drawing.bem_hor draw1 "combi"  "oben")    ; Bemassung Traeger netto mit OF-Blechen
        (setq vAbstBem (+ vAbstBem 10.0))
	))

    (if (= qstype "L") (progn
      (print "Winkel-Draufsicht")
      (setq AnzBemp (drawing.get draw1 anzBemP "store1"))
      (if (> AnzBemp 2) (progn
         (print "Bemaung vertikal")
         (drawing.set draw1 (abstand 15.0) (schrift sg25)  (versetzt 1))
         (drawing.bem_ver draw1 "store1"  "rechts")    ; Lochbilder vertikal bei L-Profilen
         (drawing.set draw1  (versetzt 0))
      ))
    ))

    (if (= SichtRichtung   1) (progn
        (drawing.del_layer draw1 "combi")
        (drawing.comblayer_g draw1 "trg_oberflansch_links")
        (drawing.comblayer draw1 "abtl_coupon_li")
        (setq AnzBemp (drawing.get draw1 anzBemP "combi"))
       (if (> AnzBemp 2) (progn
            (drawing.set draw1 (abstand vAbstBem) (schrift sg25))
            (drawing.bem_hor draw1 "combi"  "oben")    ; Bemassung Traeger netto mit Couponblechen
            (setq vAbstBem (+ vAbstBem 10.0))
        ))
    ))

    (drawing.del_layer draw1 "combi")
    (if (= SichtRichtung  1) (drawing.comblayer draw1 "trg_oberflansch_links"  "trg_oberflansch_rechts"))
    (if (= SichtRichtung -1) (drawing.comblayer draw1 "trg_unterflansch_links" "trg_unterflansch_rechts"))

    ; (drawing.comblayer draw1 "trg_oberflansch" "trg_unterflansch")

    (setq mKettenBezchn  0)
    (setq zeichneBem     1)
    (if (= SichtRichtung   1) (setq mKettenBezchn "Oberflansch"))  ; translate pl "top flange"
    (if (= SichtRichtung  -1) (setq mKettenBezchn "Unterflansch")) ; translate pl "bottom flange"

    (if (= qstype "L") (setq zeichneBem     0))
    (if (= qstype "K") (setq zeichneBem     0))
    (if (= qstype "R") (setq zeichneBem     0))
;    (if (= qstype "F") (setq zeichneBem     0))		; Flachstahl
    (if (= qstype "B") (setq zeichneBem     0))		; Gitterrost
    (if (= zeichneBem 1) (progn
        (drawing.set draw1 (abstand vAbstBem) (schrift sg35))
        (drawing.bem_hor_g draw1 "combi"  "oben" mKettenBezchn)    ; Bemaung Traeger netto gesamt
        (setq vAbstBem (+ vAbstBem 10.0))
    ))     
    (setq zeichneBem     1)

    (drawing.del_layer draw1 "combi")
    (if (= SichtRichtung   1) (progn

;	(drawing.showbem_p draw1 "traeger" 3.0 -2)
;	(drawing.showbem_p draw1 "traegersys" 3.0 -2)
;	(drawing.showbem_p draw1 "trg_oberflansch_links"   2.0 -3)
;	(drawing.showbem_p draw1 "trg_oberflansch_rechts"  2.0 -1)
;	(drawing.showbem_p draw1 "trg_unterflansch_links"  1.5 -2)
;	(drawing.showbem_p draw1 "trg_unterflansch_rechts" 1.5 -2)


    	(drawing.comblayer draw1 "trg_oberflansch_links"  "trg_oberflansch_rechts")
    	(drawing.comblayer draw1 "trg_unterflansch_links" "trg_unterflansch_rechts")
    	(drawing.comblayer draw1 "traegersys" "traeger")
    	
    	(if (= qstype "R") (progn
    	   (drawing.del_layer draw1 "combi")
    	   (drawing.comblayer draw1 "traeger")
    	))
    	(drawing.set draw1 (abstand vAbstBem) (schrift sg35))
    	
    	(drawing.bem_hor_g draw1 "combi"  "oben" "Profil gesamt")    ; Bemaung Traeger netto gesamt
    	(setq vAbstBem (+ vAbstBem 10.0))
    ))

    ; so - und nun hier kombinieren - Unterflansch
    (setq vAbstBem 15.0);
    (drawing.del_layer draw1 "combi")
    (setq AnzBemp (drawing.get draw1 anzBemP "trg_uf_lchb"))	(print AnzBemp)
    (setq AnzUnterflanschLchb AnzBemp) 				(print AnzUnterflanschLchb)
    (if (> AnzBemp 0) (progn
        (drawing.comblayer draw1 "trg_unterflansch_links")
        (drawing.comblayer draw1 "trg_uf_lchb")
        (drawing.set draw1 (abstand vAbstBem) (schrift sg25)  (showadddist 1))

        (setq AnzUF_LI (drawing.get draw1 anzBemP "trg_unterflansch_links"))	(print AnzUF_LI)

	(setq U_C_Profil 0)
    	(if (= qstype "c") (setq U_C_Profil 1))
    	(if (= qstype "U") (setq U_C_Profil 1))

    	(if (= U_C_Profil 1) (progn
    	    (setq AnzUF (drawing.get draw1 anzBemP "trg_unterflansch_links"))
    	    (if (= AnzUF 0) (drawing.comblayer draw1 "trg_unterflansch"))
    	    (if (> AnzUF 0) (drawing.comblayer draw1 "trg_unterflansch_rechts"))
    	))

      (drawing.bem_hor draw1 "combi"  "unten")    ; Bemassung Traeger netto mit Lochbildern im Oberflansch
;       (setq vAbstBem (+ vAbstBem 10.0))
        (setq y2 (drawing.get draw1 y2))
;       (drawing.set draw1 (y2 (- y2 15.0)))
        (drawing.set draw1  (showadddist 0))

;       (setq vAbstBem 10.0)
        (setq vAbstBem (+ vAbstBem 10.0))
    ))

    (drawing.del_layer draw1 "combi")
;    (drawing.comblayer_g draw1 "store1")
	(if (= SichtRichtung   1) (progn
		(drawing.comblayer draw1 "trg_oberflansch")
	))
	(if (= SichtRichtung  -1) (progn
		(drawing.comblayer draw1 "trg_unterflansch")
	))
	(drawing.comblayer draw1 "trg_steg_bleche")

	; ----------------------------------------  Bereich Blech am Steg bemaen
    (setq AnzBemp (drawing.get draw1 anzBemP "combi"))
    (if (> AnzBemp 2) (progn
;	(drawing.showbem_p draw1 "combi"   		1.0 -3)
;	(drawing.showbem_p draw1 "trg_steg_bleche"      2.0 -3)
		(setq drawBemFlag 0)
        (if (= qsType "R") (setq drawBemFlag 1))
        (if (= qsType "K") (setq drawBemFlag 1))

        (if (= drawBemFlag 1) (progn
		  (drawing.copy2layer draw1 "combi" "store1")
		  (drawing.del_layer draw1 "combi")
          (drawing.comblayer_g draw1 "store1")
          (drawing.comblayer_g draw1 "traeger_li")
          (drawing.comblayer_g draw1 "traeger_re")

		  ;(drawing.showbem_p draw1 "traeger_li" 3.0 -2)
		  
		  (setq mStab (drawing.get draw1 scale))
          (setq b (Traeger.get wsz_trg b))
          (setq vAbstBem (+ vAbstBem (* 0.5 mstab b) 5.0))

		  ; Apr. 2021 - in den Bereich hier verschoben - somit nur bei R oder K-Profilen
		  (drawing.set draw1 (abstand vAbstBem) (schrift sg25))
		  (drawing.bem_hor draw1 "combi"  "unten")    ; Bemassung Traeger netto mit Stegblechen
		  (setq vAbstBem (+ vAbstBem 10.0))

	  ))
    ))

    ; ---------------------------------------------- Bereich unten

	(drawing.del_layer draw1 "combi")
    (drawing.comblayer_g draw1 "store1")
    (setq AnzBemp (drawing.get draw1 anzBemP "profilq"))
    (if (> AnzBemp 2) (progn
    	(drawing.comblayer_g draw1 "profilq")
        (drawing.set draw1 (abstand vAbstBem) (schrift sg25))
        (drawing.bem_hor draw1 "combi"  "unten")    ; Bemassung Traeger netto mit Stegblechen
        (setq vAbstBem (+ vAbstBem 10.0))
    ))
	
;  Achtung - nur einsetzen, wenn Augenbleche vorhanden sind:
   (setq AnzAugenBl (Traeger.get WSZ_Trg AnzAbtl Augenblech))
   (if (> AnzAugenBl 0) (progn
      (drawing.del_layer draw1 "combi")
      (drawing.comblayer_g draw1 "trg_oberflansch")
      (drawing.comblayer draw1 "trg_steg_bleche")
      (setq AnzBemp (drawing.get draw1 anzBemP "combi"))
      (if (> AnzBemp 2) (progn
          (drawing.set draw1 (abstand vAbstBem) (schrift sg25))
          (drawing.bem_hor draw1 "combi"  "unten")    ; Bemassung Traeger netto mit Stegblechen
          (setq vAbstBem (+ vAbstBem 10.0))
	  ))

	  ;; Vertikalbemaung Augenblech mit Lochbild
	  ;; (drawing.dump_all draw1)
	  ;; (drawing.showbem_p draw1 "trg_steg_bleche" 3.0 -2)
      (drawing.del_layer draw1 "combi")
      (drawing.comblayer_g draw1 "trg_steg_bleche")
      (drawing.comblayer draw1 "traeger_li")
      (drawing.comblayer draw1 "traeger_re")
	  (drawing.layer_rect draw1 "combi")
      (drawing.bem_ver draw1 "combi"  "links")    ; Bemassung Traeger netto mit Stegblechen

  ))

;  Bemaung der Couponbleche auf der rechten Seite:
      (drawing.del_layer draw1 "combi")
      (drawing.comblayer_g draw1 "trg_oberflansch_rechts")
      (drawing.comblayer draw1 "abtl_coupon_re")
      (setq AnzBemp (drawing.get draw1 anzBemP "combi"))
      (if (> AnzBemp 2) (progn
          (drawing.set draw1 (abstand vAbstBem) (schrift sg25))
          (drawing.bem_hor draw1 "combi"  "unten")    ; Bemassung Traeger netto mit Couponblechen
          (setq vAbstBem (+ vAbstBem 10.0))
      ))


    (drawing.del_layer draw1 "combi")
;    (drawing.comblayer_g draw1 "store1")
    (drawing.comblayer_g draw1 "trg_unterflansch_links")
    (if (= qstype "F") (progn
    	(drawing.del_layer draw1 "combi")
	(drawing.comblayer_g draw1 "traeger_li" "traeger_re")
    ))
    (drawing.comblayer draw1 "trg_uf_bleche")
    (setq AnzBemp (drawing.get draw1 anzBemP "combi"))
    (if (> AnzBemp 2) (progn
        (drawing.set draw1 (abstand vAbstBem) (schrift sg25))
        (drawing.bem_hor draw1 "combi"  "unten")    ; Bemassung Traeger netto mit UF-Blechen
        (setq vAbstBem (+ vAbstBem 10.0))
    ))

    (setq DrawHorBem 0)
    (if (/= hWnklLi 90.0) (setq DrawHorBem 1))
    (if (/= hWnklRe 90.0) (setq DrawHorBem 1))

    (if (= DrawHorBem 1) (progn
        (drawing.del_layer draw1 "combi")
        (drawing.comblayer draw1 "traeger_li" "traeger_re")
        (drawing.set draw1 (abstand vAbstBem) (schrift sg25))
;        (drawing.bem_hor draw1 "combi"  "unten")    ; Bemassung Traeger Gesamtlnge
;    	(drawing.showbem_p draw1 "combi"        5.0 -3)
            (setq vAbstBem (+ vAbstBem 10.0))
    ))

    (drawing.del_layer draw1 "combi")
    (if (= qstype "R") 
        (print "Rohr - keine Bemaung")
    	(progn
            (if (= SichtRichtung  1) (drawing.comblayer draw1 "trg_oberflansch_links"  "trg_oberflansch_rechts"))
    	    (if (= SichtRichtung -1) (drawing.comblayer draw1 "trg_unterflansch_links" "trg_unterflansch_rechts"))
    	    (setq AnzBemp (drawing.get draw1 anzBemP "combi"))
	    (if (> AnzBemp 2) (progn
        	(drawing.set draw1 (abstand vAbstBem) (schrift sg35))
        	(drawing.bem_hor   draw1 "combi"  "unten")    ; Bemassung mit vertikalen Trgerenden 
                (setq vAbstBem (+ vAbstBem 10.0))
    	    ))
    	)
    )

	; - hier kommt nochmal eine Gesamtbemaung - kollidiert aber, wenn Lochbildbemaung vorliegt.
    (if (= qstype "F") 	(progn
		(setq DrawHorBem 0)
    	(setq AnzBemp (drawing.get draw1 anzBemP "trg_oberflansch"))
		(if (> AnzBemp 4) (setq DrawHorBem 1))
		(if (/= hWnklLi 90.0) (setq DrawHorBem 1))
		(if (/= hWnklRe 90.0) (setq DrawHorBem 1))
	    (if (= DrawHorBem 1) (progn
		(drawing.layer_rect draw1 "trg_oberflansch")
        	(drawing.set draw1 (abstand vAbstBem) (schrift sg25) (versetzt 0))
        	(drawing.bem_hor   draw1 "trg_oberflansch"  "oben")    ; Bemassung mit vertikalen Trgerenden 

	        (drawing.set draw1  (versetzt 1))
        	(drawing.bem_ver   draw1 "trg_oberflansch"  "links")    ; Bemassung mit vertikalen Trgerenden 
                (setq vAbstBem (+ vAbstBem 10.0))
    	    ))
    ))
 
	(if (= SichtRichtung -1) (progn
		; (setq vAbstBem (drawing.get draw1 vAbstBem))
		(setq y_Stl_Scaled (* y_StlPosition scale))
		(setq y2 (drawing.get draw1 y2))
		(setq yMin_Stl (- y2 vAbstBem))
		(if (= NaturGroesse 1) (setq yMin_Stl (* yMin_Stl scale)))
		(if (< yMin_Stl y_Stl_Scaled) (setq y_StlPosition (/ (- yMin_Stl 10) scale)))
	))
 
)

; ======================================================================
(defun showDebugInfos ()
;  (setq "_debug_" 1)
  (line   -500    0   1100     0)
;  (line   1000    0   1000   100)
;  (line   1000  100      0   100)
;  (line      0  100      0     0)

;  (line   -100   300   1100  300)
;  (line   -100  -300   1100 -300)

;  (line     0    0   0    500)
;  (line -100 180   600	180)
  
  ;(line 100 -100 100 200)
  
;  (Traeger.set wsz_trg (delta_lr 200))
;  (Traeger.set wsz_trg (delta_v  100))

)
; ======================================================================
(defun drawCouponSchnitte (xSchnitt ySchnitt)

; )
; (defun Dummy ()

     (drawing.delallayer draw1) 
	 (drawing.set draw1 (versetzt 1))

     (setq hProf 		(Traeger.get wsz_trg h)
		   bProf			(Traeger.get wsz_trg b)
		   b2			    (/ bProf 2)
     	   ySchnitt  (+ ySchnitt (* 0.5 hProf))
     )
     (setq mStab (drawing.get draw1 scale))

     (setq abtlFirstCP (Traeger.get wsz_trg firstAbtl coupon))
     (if abtlFirstCP (Traeger.sortabtl wsz_trg))
 
     (setq abtlFirstCP (Traeger.get wsz_trg firstAbtl coupon))
     (while abtlFirstCP (progn
        (setq xPos_alt (Anbauteil.get abtlFirstCP xPos))
     	; (print "Zeichne Coupon-Schnitt")
	
        (drawing.delallayer draw1) 						; Bemaung vorbereiten
        ; ......................................................................  Couponeinzel im Schnitt zeichnen
        (traeger.schnitt wsz_trg xSchnitt ySchnitt 0.0 "omlsm" abtlFirstCP)	; Zeichnen
        ;  omlsm - das m an letzter Pos (0-4:4) bedeutet, dass es nicht am Ende mit Trgerneigung
        ;  gezeichnet werden soll sondern ein vertikaler Schnitt in der Mitte des Trgerprofils

	; ---------- Bemaungfunktion 
        (drawing.layer_rect draw1 "profilq")
        (drawing.set draw1 (abstand 15) (schrift sg25))
        (drawing.comblayer draw1 "abtl_coupon_li" "abtl_coupon_re")
        (drawing.bem_hor draw1 "combi" "oben")    ; Bemaung Coupon

        ; (drawing.comblayer_g draw1 "store1")
        (drawing.comblayer draw1 "profilq")
        (drawing.bem_ver draw1 "combi"  "rechts")    ; Bemaung Traeger und Coupon
        (drawing.bem_hor draw1 "combi"  "unten")   ; Bemaung Traeger und Coupon

        ;     ..................................................................  Schweinahtbez. zeichnen

        ; (setq abtlFirstCP (Traeger.get wsz_trg nextAbtl))
        (setq abtlFirstCP (Traeger.get wsz_trg nextAbtlPos))
        
        
        ; --------- Anbauteile sind sortiert. Das nchste muss mindestens
        ; 10 mm entfernt sein, ansonsten sollte es mit der Schnittroutine
        ; mitgezeichnet werden.
        (if abtlFirstCP (progn
             (setq xPos_neu (Anbauteil.get abtlFirstCP xPos))
             (if (< (- xPos_neu xPos_alt) 10) (progn
                ;     .............................................................  Schweinahtbez. zeichnen

                (setq abtlFirstCP (Traeger.get wsz_trg nextAbtl))
           ))
        ))

		(setq Abstand (+ (* bProf mStab) 30.0))
		(if (< Abstand 70.0) (setq Abstand 70.0))
		(setq xSchnitt (+ xSchnitt (/ Abstand mStab)))
		

        ; (setq xSchnitt (+ xSchnitt (/ 60.0 mStab)))
        ; (setq xSchnitt (+ xSchnitt bProf (/ 30.0 mStab)))
     ))

     (setq abtlFirstCP (Traeger.get wsz_trg firstAbtl coupon))
     (while abtlFirstCP (progn
     	(print "Zeichne Coupon-Draufsicht")
		
		(setq	cp_Trg			(Anbauteil.get 	abtlFirstCP		Objekt Coupon))
		(setq 	bProf			(Traeger.get cp_Trg b)
					b2			    (/ bProf 2)
		)


        (drawing.delallayer draw1) 						; Bemaung vorbereiten

		 (Anbauteil.drSicht abtlFirstCP  xSchnitt  ySchnitt  0.0)
		 
		 (print "--------------------------------------------")
		 (print "Coupon-Einzelteil") ; (drawing.dump_all draw1)
		 (print "--------------------------------------------")

        (drawing.comblayer draw1 "lochbild" "traeger")
		(drawing.layer_rect draw1 "combi")

		 (drawing.bem_ver draw1 "combi"  "rechts")    ; Bemaung Couponflansch und Lochbild
		 (drawing.bem_hor draw1 "combi"  "unten")    ; Bemaung Couponflansch und Lochbild

	 
        ; (setq xSchnitt (+ xSchnitt (/ 60.0 mStab)))
        (setq xSchnitt (+ xSchnitt bProf (/ 30.0 mStab)))

        ; (setq abtlFirstCP (Traeger.get wsz_trg nextAbtl))
        (setq abtlFirstCP (Traeger.get wsz_trg nextAbtlPos))
	 ))

)
(defun calcKplSchnittPos ()

   (setq Trg_links   (traeger.get WSZ_Trg links))
   (setq Trg_rechts  (traeger.get WSZ_Trg rechts))

;  Achtung - wird weiter unten noch einmal berechnet.
;  Wenn nderungen, dann bei beiden Berechnungen angleichen!
  (setq bProf    (Traeger.get wsz_Trg   b)
        sysLng   (Traeger.get WSZ_Trg syslng)

  	dlLinks  (TrEnde.get Trg_links  delta_l)
        dlRechts (TrEnde.get Trg_rechts delta_l)
        hWnklLi  (TrEnde.get Trg_links  H_Winkel)
        hWnklRe  (TrEnde.get Trg_rechts H_Winkel)
        vWnklLi  (TrEnde.get Trg_links  V_Winkel)
        vWnklRe  (TrEnde.get Trg_rechts V_Winkel)
	xsLinks  (- (/ -50.0 scale) (/ bProf 2) (- dlLinks))
        xsRechts (+ (/  50.0 scale) (/ bProf 2) (- dlRechts) sysLng)
	vscherl_links	(TrEnde.get Trg_links vscherl)
	vscherl_rechts	(TrEnde.get Trg_rechts vscherl)
  )


   (if (> vWnklLi 90.0)
	(setq vWnklLi (- vWnklLi 90.0))
   )
   (if (> vWnklRe 90.0)
	(setq vWnklRe (- 90.0 vWnklRe))
   )
   (setq cosW_l (cos (/ (* PI vWnklLi) 180.0)))
   (setq cosW_r (cos (/ (* PI vWnklRe) 180.0)))
   (setq verschieb_r (* (* 1.5 vscherl_rechts) cosW_r))
   (setq verschieb_l (* (* 1.5 vscherl_links) cosW_l))
   (print verschieb_l)
	 
   (if (< vWnklLi 80.0) (setq xsLinks  (- xsLinks verschieb_l)))
   (if (> vWnklLi 80.0) (setq xsLinks  (- xsLinks verschieb_l)))
   (if (< vWnklRe 80.0) (setq xsRechts (+ xsRechts verschieb_r)))
   (if (> vWnklRe 80.0) (setq xsRechts (+ xsRechts verschieb_r)))
   
   (setq QType (Traeger.get WSZ_Trg QsForm))
   (if (= QType "F") (progn
   	(setq 
		xsLinks  (- (/ -50.0 scale) (/ bProf 2) (- dlLinks))
        	xsRechts (+ (/  50.0 scale) (/ bProf 2) (- dlRechts) sysLng)
        )
        (if (< sysLng 800.0) (setq  xsRechts (+ (/  80.0 scale) (/ bProf 2) (- dlRechts) sysLng)))
   ))
   
   ; neu in V6.00 - falls Schubprofil vorhanden, dann Schnitte etwas versetzen
   (setq abtl_SchubProf (Traeger.get WSZ_Trg firstAbtl schubprofil))
   (if (objexist abtl_SchubProf) (progn
   	(setq trgSchubProf (Anbauteil.get abtl_SchubProf objekt traeger))
   	(setq spLaenge (Traeger.get trgSchubProf sysLng))
   	(if (Anbauteil.get abtl_SchubProf is_type _endelinks_)  (setq xsLinks  (- xsLinks spLaenge)))
   	(if (Anbauteil.get abtl_SchubProf is_type _enderechts_) (setq xsRechts (+ xsRechts spLaenge)))
   ))
   
   

)
; --------------------------------------------------------------
(defun drawVoutAlsDetail (VoutenObj hAbstand)
;	(print  "Voute zeichnen")
  (setq mStab (drawing.get draw1 scale))
  (setq xVoute (Voute.get VoutenObj laenge))
  (setq xVoute (- (/ -20.0 mStab) xVoute))

  (setq yVoute (- -1200.0 hAbstand))
  (if abtl_kopfplatte_links  (progn
     (setq kplBlech (Anbauteil.get abtl_kopfplatte_links Objekt blech))
     (if kplBlech (progn
        (setq hp (Blech.get kplBlech hp))
        (setq yVoute (- (- hp) (/ 50.0 mStab) hAbstand))
     ))
  ))



  (drawing.delallayer draw1) 
  (setq vAbstBem 10.0);

  (Voute.drawVoutenProfil VoutenObj xVoute  yVoute  0.0  "m")
        (drawing.comblayer draw1 "traeger_li" "traeger_re")
	(drawing.layer_rect draw1 "combi")
        (drawing.set draw1 (abstand vAbstBem) (schrift sg25) (versetzt 1))

      	(drawing.bem_hor   draw1 "traeger_li"  "oben")    ; Bemassung mit vertikalen Trgerenden 
      	(drawing.bem_hor   draw1 "traeger_re"  "unten")    ; Bemassung mit vertikalen Trgerenden 

      	(drawing.bem_ver   draw1 "traeger_li"  "links")    ; Bemassung mit vertikalen Trgerenden 
      	(drawing.bem_ver   draw1 "traeger_re"  "rechts")    ; Bemassung mit vertikalen Trgerenden 

  	(setq vAbstBem (+ vAbstBem 8.0))
  	 (drawing.set draw1 (abstand vAbstBem) (versetzt 0))
      	(drawing.bem_hor_g   draw1 "combi"  "unten")    ; Bemassung mit vertikalen Trgerenden 
 
 	(setq abtlV (Traeger.get wsz_Trg ABTeil VoutenObj))
 	
	(setq mStab_Txt mStab)								; angepasst auf 1:1 Export - Jan 2022
	(setq xv_Offset 10.0 yv_Offset 15.0)
	(if (= Naturgroesse 1) 
	   (setq mStab_Txt 1.0  xv_Offset 130.0 yv_Offset 180.0)
	)
 	(setq xVoute (* xVoute mStab_Txt))
 	(setq yVoute (* yVoute mStab_Txt))
         (drawing.createSchnPosBez draw1 abtlV  (+ xVoute xv_Offset) (+ yVoute yv_Offset) xVoute yVoute)
)

(defun calcMaxHoeheAnsicht ()
	(setq hMaxAnsicht 0.0)
	(setq  AnzVouten (Traeger.get WSZ_Trg AnzAbtl Vouten))
	(if (> AnzVouten 0) (progn
     (setq abtlVoute (Traeger.get wsz_trg firstAbtl Vouten))
     (while abtlVoute
        (setq VoutenObj (Anbauteil.get abtlVoute objekt voute))
        (setq hVoute (Voute.get VoutenObj hSteg1))
		(if (< hMaxAnsicht hVoute) (setq hMaxAnsicht hVoute))
		(setq abtlVoute (Traeger.get wsz_trg nextAbtl))
     )
	))
	(if abtl_kopfplatte_links   (progn
		(setq h_Trg (Traeger.get wsz_trg h))
        (setq kplBlech (Anbauteil.get abtl_kopfplatte_links objekt blech))
		(setq hp (Blech.get kplBlech hp))
		(setq hp_Ueberstand (- hp h_Trg))
		(if (> hp_Ueberstand hMaxAnsicht) (setq hMaxAnsicht hp_Ueberstand))
	))
	(if abtl_kopfplatte_rechts  (progn
		(setq h_Trg (Traeger.get wsz_trg h))
        (setq kplBlech (Anbauteil.get abtl_kopfplatte_rechts objekt blech))
		(setq hp (Blech.get kplBlech hp))
		(setq hp_Ueberstand (- hp h_Trg))
		(if (> hp_Ueberstand hMaxAnsicht) (setq hMaxAnsicht hp_Ueberstand))
	))
	(print hMaxAnsicht)
	(if (< hMaxAnsicht 100.0) (setq hMaxAnsicht (+  hMaxAnsicht (/ 25.0 scale))))
	(if (< scale 0.1)   (setq hMaxAnsicht (+ hMaxAnsicht 50.0)))
	(if (< scale 0.067) (setq hMaxAnsicht (+ hMaxAnsicht 50.0)))
	
)
(defun checkSpezielleAuskl (Trg_Ende)
	(setq AnzAkl (TrEnde.get Trg_Ende Anz_Akl))
	(setq horAkl 0)

	(setq xAkl (TrEnde.get Trg_Ende xAkl))
	(if (> AnzAkl 0) (progn
		(setq yAkl (TrEnde.get Trg_Ende yAkl))
		(setq bFln (TrEnde.get Trg_Ende bFlansch))
		(if (> yAkl 0) (setq horAkl 1))
		(if (> bFln 0) (setq horAkl 1))
	))
	
	(if (> horAkl 0) (setq zeichneDruntersicht 1))
)



