; $	HT	QT(IU)	AF(K)		P(E)
; $	AT	QT(IU)	AF(K)		P(E)
; $	AE	V(90)		H(90)		R(-)

; Montagesto ber Laschen an Trgersteg
; **************************************
(defun init-connection ()
	
	(setq LB_DEBUG 0)
	
	(setq steglasche_re 			(blech.create))
	(setq steglasche_li 			(blech.create))
	(setq flanschlasche_uf		(blech.create))
	(setq druckstck						(blech.create))
	(setq steglochbild					(Lochbild.create))
	(setq flanschlochbildunten	(Lochbild.create))
	(Connect.storeAnschlObjs CastaData 	steglasche_re 
																			steglasche_li 
																			flanschlasche_uf
																			druckstck 
																			steglochbild 
																			flanschlochbildunten
	)
	
	(setq delta_l_trg 5)
	
	(kuerzeTraeger delta_l_trg)
	
	(createStegLaschen)
	(createFlanschLaschenAussen)
	
	(createStegLochbild steglochbild)
	(createFlanschlochbild flanschlochbildunten)
	(setFlanschLaschenAussen)
	
	(calcLochbildVersatz)	; *neu* Juni 2013
	
	(createDruckstueck druckstck delta_l_trg)
	
	
	; CALLBACKS
	(Blech.set steglasche_re 		(formFkt "cb_steglasche_re"))
	(Blech.set steglasche_li 		(formFkt "cb_steglasche_li"))
	(Blech.set flanschlasche_uf (formFkt "cb_flanschlasche_uf"))
	(Blech.set druckstck 				(formFkt "cb_druckstck"))
)


; ========================================================================================
; CALLBACK-FUNKTIONEN
; ========================================================================================

; ----------------------------------------------------------------------------------------
; Callback fr rechte Steglasche
; ----------------------------------------------------------------------------------------
(defun cb_steglasche_re (zp)
	(print "in Callback-Funktion cb_KplBlech")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dpAlt (Blech.get steglasche_re dp))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq dpNeu (Blech.get steglasche_re dp))
	    
	    (print dpAlt) (print dpNeu)
	    
	    (if (/= dpAlt dpNeu) (progn
	       (setq dpDiff (- dpNeu dpAlt))
	       (setq alteKlemml 	(Lochbild.get steglochbild Klemml))
	       
	       (Lochbild.set steglochbild 	(Klemml  (+ alteKlemml dpDiff))
	       															;(dxSKopf (+ altesDxSKopf dpDiff))	       	
	       )
	    ))
	))
)

; ----------------------------------------------------------------------------------------
; Callback fr linke Steglasche
; ----------------------------------------------------------------------------------------
(defun cb_steglasche_li (zp)
	(print "in Callback-Funktion cb_KplBlech")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dpAlt (Blech.get steglasche_li dp))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq dpNeu (Blech.get steglasche_li dp))
	    
	    (print dpAlt) (print dpNeu)
	    
	    (if (/= dpAlt dpNeu) (progn
	       (setq dpDiff (- dpNeu dpAlt))
	       (setq alteKlemml (Lochbild.get steglochbild Klemml))
	       (setq altesDxSKopf	(Lochbild.get steglochbild dxSKopf))
	       
	       (Lochbild.set steglochbild 	(Klemml (+ alteKlemml dpDiff))
	       															(dxSKopf (+ altesDxSKopf dpDiff))
	       )
	    ))
	))
)

; ----------------------------------------------------------------------------------------
; Callback fr Flanschlasche
; ----------------------------------------------------------------------------------------
(defun cb_flanschlasche_uf (zp)
	(print "in Callback-Funktion cb_flanschlasche_uf")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dpAlt (Blech.get flanschlasche_uf dp))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq dpNeu (Blech.get flanschlasche_uf dp))
	    
	    (print dpAlt) (print dpNeu)
	    
	    (if (/= dpAlt dpNeu) (progn
	       (setq dpDiff (- dpNeu dpAlt))
	       (setq alteKlemml (Lochbild.get flanschlochbildunten Klemml))
	       (setq altesDxSKopf	(Lochbild.get flanschlochbildunten dxSKopf))
	       
	       (Lochbild.set flanschlochbildunten 	(Klemml (+ alteKlemml dpDiff))
	       																			(dxSKopf (+ altesDxSKopf dpDiff))
	       )
	    ))
	))
)

; ----------------------------------------------------------------------------------------
; Callback fr Druckstck
; ----------------------------------------------------------------------------------------
(defun cb_druckstck (zp)
	(print "in Callback-Funktion cb_druckstck")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dpAlt (Blech.get druckstck dp))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq dpNeu (Blech.get druckstck dp))
	    
	    (print dpAlt) (print dpNeu)
	    
	    (if (/= dpAlt dpNeu) (progn
	    	(setq dpDiff (- dpNeu dpAlt))
	       
	    	(if (= (Connect.get CastaData LinkesEnde) 1)
	    		(setq AT_Ende (Traeger.get Tr_ID links))
	    	)
	    	(if (= (Connect.get CastaData RechtesEnde) 1)
	    		(setq AT_Ende (Traeger.get Tr_ID rechts))
	    	)       
	    	
	    	(TrEnde.ptrim AT_Ende (- (* dpDiff 0.5)))
	       
	       
	      (if (= (Connect.get CastaData anHtLinkesEnde) 1)
	    		(setq HT_Ende (Traeger.get Htrg links))
	    	)
	    	(if (= (Connect.get CastaData anHtRechtesEnde) 1)
	    		(setq HT_Ende (Traeger.get Htrg rechts))
	    	)       
	    	
	    	(TrEnde.ptrim HT_Ende (* dpDiff 0.5))
	      
	    ))
	))
)


; ----------------------------------------------------------------------------------------
; ERZEUGT DIE STEGLASCHEN
; ----------------------------------------------------------------------------------------
(defun createStegLaschen ()
	
	(setq xPos_ht (Connect.get CastaData xPos_ht)
				xPos_at	(Connect.get CastaData xPos_at)
	)
	
	(setq hc_ht 	(Traeger.get Htrg hc)
				h_ht		(Traeger.get Htrg h)
				s_ht		(Traeger.get Htrg s)
	)
	
	(setq hc_at		(Traeger.get Tr_ID hc)
				h_at		(Traeger.get Tr_ID h)
	)
	
	
	; massgebenden Traeger bestimmen
	(if (<= hc_ht hc_at)
		(setq mass_h hc_ht)
		(setq mass_h hc_at)
	)
	
	; Laschenbreite
	(setq h_lasche (* 0.75 mass_h))
	(setq h_lasche_rund (runde h_lasche auf 5))
	
	; delta_lr Lasche
	(setq s_ht_halb (* 0.5 s_ht))
	(setq delta_lr_lasche s_ht_halb)
	
	; Laschenhhe
	(setq hp_lasche h_ht)
	
		
	(Blech.set steglasche_re 	(dp 	s_ht) 
														(hp 	hp_lasche) 
														(bp 	h_lasche_rund) 
														;(delta_lr 20)
														;(dok 	dok_lasche)
	)
	(Blech.set steglasche_li 	(dp 	s_ht) 
														(hp 	hp_lasche) 
														(bp 	h_lasche_rund) 
														;(delta_lr 20)
														;(dok 	dok_lasche)
	)
	
	
	
	
	(Traeger.addabtl Tr_ID steglasche_re xPos_at 0.0 _lasche_steg_re_)
	(Traeger.addabtl Tr_ID steglasche_li xPos_at 0.0 _lasche_steg_li_)
)

; ----------------------------------------------------------------------------------------
; ERZEUGT DIE USSEREN FLANSCHLASCHEN
; ----------------------------------------------------------------------------------------
(defun createFlanschLaschenAussen ()
	
	(setq b_ht	(Traeger.get Htrg b)
				h_ht	(Traeger.get Htrg h)
				t_ht	(Traeger.get Htrg t)
	)
	
	(setq b_at 	(Traeger.get Tr_ID b)
				h_at	(Traeger.get Tr_ID h)
	)
	
	; massgeb. Breite ermitteln
	(if (<= b_ht b_at)
		(setq mass_b b_ht)
		(setq mass_b b_at)
	)
	
	; massgeb. Hhe ermitteln
	(if (<= h_ht h_at)
		(setq mass_h h_ht)
		(setq mass_h h_at)
	)
		
	
	; Flanschlaschenbreite
	(setq bp_f_lasche mass_b)
	
	; Flanschlaschenhhe
	(setq hp_f_lasche mass_h)
		
	
	(Blech.set flanschlasche_uf 	(dp 	t_ht) 
																(hp 	hp_f_lasche) 
																(bp 	bp_f_lasche) 
	)
	
	(Traeger.addabtl Tr_ID flanschlasche_uf xPos_at 0.0 _lasche_uf_)
)


; ----------------------------------------------------------------------------------------
; Positioniert die Lasche am Unterflansch
; ----------------------------------------------------------------------------------------
(defun setFlanschLaschenAussen ()
	(print ">-------------------------------------------------------------------------------")
	(print "SETZE FLANSCHLASCHEN")
	
	(setq qsform_ht (Traeger.get Htrg qsform))
	
	(setq lasche_abtl_uf (Traeger.get Tr_ID AbTeil flanschlasche_uf))
	
	; U-Profil
	; ----------------------------------------------
	(if (= qsform_ht "U")
		(progn
			(Anbauteil.set lasche_abtl_uf (delta_lr (- (* 0.5 bp_f_lasche))))
		)
	)
	(print "<-------------------------------------------------------------------------------")
)




; ----------------------------------------------------------------------------------------
; BILDET EINEN SPALT ZWISCHEN DEN TRAEGERN
; ----------------------------------------------------------------------------------------
(defun kuerzeTraeger (dl)
	(if (= (Connect.get CastaData anHtLinkesEnde) 1)
		(setq TrgEnde_HT (Traeger.get Htrg links))
	)
	(if (= (Connect.get CastaData anHtRechtesEnde) 1)
		(setq TrgEnde_HT (Traeger.get Htrg rechts))
	)
	(if (= (Connect.get CastaData LinkesEnde) 1)
		(setq TrgEnde_AT (Traeger.get Tr_ID links))
	)
	(if (= (Connect.get CastaData RechtesEnde) 1)
		(setq TrgEnde_AT (Traeger.get Tr_ID rechts))
	)
	
	(TrEnde.set TrgEnde_HT (delta_l dl))
	(TrEnde.set TrgEnde_AT (delta_l dl))
)


; ----------------------------------------------------------------------------------------
; BERECHNET DAS STEGLOCHBILD
; ----------------------------------------------------------------------------------------
(defun createStegLochbild (LchbID)
	(print ">-----------------------------------------------------------")
	(print "ERZEUGE STEGLOCHBILD")
	
	(Lochbild.set LchbID
		(S_Bez   "M20")
		(Guete   "4.6")
		(e       "100  0 0 0 0 0")
		(w       "100  0")
	)
	
	(setq s_ht 			(Traeger.get Htrg s)
				h_ht			(Traeger.get Htrg h)
				qsform_ht	(Traeger.get Htrg qsform)
	)
	
	(setq xPos_ht (Connect.get CastaData xPos_ht)
				xPos_at	(Connect.get CastaData xPos_at)
	)
	
	(setq hp_blech_li (Blech.get steglasche_li hp)
				bp_blech_li	(Blech.get steglasche_li bp)
	)
	(setq dp_blech_li (Blech.get steglasche_li dp))
	(setq dp_blech_re (Blech.get steglasche_re dp))
	
	; Klemmlnge
	(setq klemm (+ s_ht dp_blech_li dp_blech_re))
		
	; dxsKopf	
	(if (= qsform_ht "I")	
		(setq dxskopf (+ (* 0.5 s_ht) dp_blech_li))
	)
	(if (= qsform_ht "U")
		(progn
			(setq dxskopf dp_blech_li)
		)
	)	
	
	; Schraubengre	
	(if	(<= s_ht dp_blech_li)
		(setq minT s_ht)
		(setq minT dp_blech_li)
	)
	(calcSchraube minT)
	(Lochbild.set LchbID (S_Bez S_Bez))
	
	; Loch- und Randabstnde
	(setq schr_d (Lochbild.get LchbID sdurchm))
	
	(setq randabstand (* 2.0 schr_d))
	(setq lochabstand	(* 4.0 schr_d))
	
	(setq ra_rund (runde randabstand auf 5))
	(setq la_rund (runde lochabstand auf 5))
	
	(setq minhpSeite (+ la_rund (* 2.0 ra_rund)))
	(setq anteil_dl (* 2.0 delta_l_trg))
	
	(setq minHp (+ (* 2.0 minhpSeite) anteil_dl))
	
	(if (< hp_blech_li minHp)
		(progn
			(setq hp_blech_li minHp)
			(setq hp_blech_re minHp)
			
			(Blech.set steglasche_li (hp hp_blech_li))
			(Blech.set steglasche_re (hp hp_blech_re))
		)
	)
	
	(if (> minhpSeite bp_blech_li)
		(setq DOPPEL 0)
		(setq DOPPEL 1)
	)
	(print DOPPEL)
	
	(if (= DOPPEL 1)
		(progn
			(setq e0 (+ (* 0.25 hp_blech_li) anteil_dl))
			(setq e1 (+ (* 0.75 hp_blech_li) anteil_dl))
			(setq w0 (* 0.5 bp_blech_li))
			
			(Lochbild.set LchbID 	(e0 		e0)
														(e1 		e1)
														(w0 		w0)
														(klemml klemm)
														(Lb_Art   16)
														(dxSKopf dxskopf)
			)
		)
	)
	
	(if (= DOPPEL 0)
		(progn
			(setq e0 (+ (* 0.25 hp_blech_li) anteil_dl))
			(setq e1 (+ (* 0.75 hp_blech_li) anteil_dl))
			(setq w0 (* 0.5 bp_blech_li))
			
			(Lochbild.set LchbID 	(e0 		e0)
														(e1 		e1)
														(w0			w0);1)		;w0 = 0!!!!!!!!!!
														(klemml klemm)
														(Lb_Art   16)
														(dxSKopf dxskopf)
			)
		)
	)
	
	(Traeger.addabtl Htrg LchbID xPos_ht 0.0 _steglochbild_system_)
	(Traeger.addabtl Tr_ID LchbID xPos_at 0.0 _steglochbild_system_)
	
	(setq Abtl_StegLchb_ht (Traeger.get Htrg ABTeil LchbID))
  (Anbauteil.set Abtl_StegLchb_ht (Master 1))
  (setq Abtl_StegLchb_at (Traeger.get Tr_ID ABTeil LchbID))
  (Anbauteil.set Abtl_StegLchb_at (Master 0))
  (print ">-----------------------------------------------------------")
)

; ----------------------------------------------------------------------------------------
; BERECHNET DAS LOCHBILD AM OBERFLANSCH
; ----------------------------------------------------------------------------------------
(defun createFlanschlochbild (LchbID2)
	(print ">-----------------------------------------------------------")
	(print "ERZEUGE FLANSCHLOCHBILD")
	
	
	(Lochbild.set LchbID2
		(S_Bez   "M20")
		(Guete   "4.6")
		(e       "100  0 0 0 0 0")
		(w       "100  0")
	)
	
	(setq t_ht 			(Traeger.get Htrg t)
				h_ht			(Traeger.get Htrg h)
				b_ht			(Traeger.get Htrg b)
				s_ht			(Traeger.get Htrg s)
				r_ht			(Traeger.get Htrg r)
				qsform_ht	(Traeger.get Htrg qsform)
	)
	
	(setq xPos_ht (Connect.get CastaData xPos_ht)
				xPos_at (Connect.get CastaData xPos_at)
	)
	
	(setq dp_blech (Blech.get flanschlasche_uf dp)
				hp_blech (Blech.get flanschlasche_uf hp)
				bp_blech (Blech.get flanschlasche_uf bp)
	)
	(setq klemm (+ t_ht dp_blech))
		
	(setq dxskopf dp_blech)
		
	; Schraubengre bestimmen
	(setq s_bez (Lochbild.get steglochbild S_Bez))
	(Lochbild.set LchbID2 (S_Bez s_bez))
	; Einzelreihe oder Doppelreihe
	
	(setq DOPPEL 1) ; standardmig Doppelreihe
	; Den entsprechenden Durchmesser holen
	(setq d_schr (Lochbild.get LchbID2 sdurchm))
	; Standardwerte
	(setq e_min (* d_schr 2.0))				; Randabstand
	(setq e1_min (* d_schr 4.0))			; Lochabstand
	; gerundet
	(setq e_min_rund (runde e_min auf 5))
	(setq e1_min_rund (runde e1_min auf 5))
	
	(setq min_h (+ e1_min_rund (* e_min_rund 2.0))) 
	(print min_h)
	(setq minHp (+ (* 2.0 min_h) (* 2.0 delta_l_trg)))
	
	(if (> minHp hp_blech)
		(progn
			(setq hp_blech minHp)
			
			(Blech.set flanschlasche_uf (hp hp_blech))
		)
	)
	
	(setq flanschanteil (- b_ht (+ (* 2.0 r_ht) s_ht)))
	(setq flanschseite (* 0.5 flanschanteil))
	(setq flanschseite_viertel (* 0.25 flanschseite))
	
	(if (< flanschseite min_h)
		(setq DOPPEL 0)
	)
	
	(if (= qsform_ht "U")
		(setq DOPPEL 0)
	)
	
	(if (= DOPPEL 1)
		(progn
			(setq e0 (+ (* 0.25 hp_blech) 10))
			(setq e1 (+ (* 0.75 hp_blech) 10))
			(setq w0 (+ (+ (* 2.0 r_ht) s_ht) (* 2.0 flanschseite_viertel)))
			(setq w1 (+ flanschseite w0))
	
			(Lochbild.set LchbID2 	(e0 		e0)
															(e1 		e1)
															(w0 		w0)
															(w1 		w1)
															(klemml klemm)
															(Lb_Art   16)
															(dxSKopf dxskopf)
															
			)
		)
	)
	
	(if (= DOPPEL 0)
		(progn
			(setq e0 (+ (* 0.25 hp_blech) 10))
			(setq e1 (+ (* 0.75 hp_blech) 10))
			(setq w0 (+ (+ (* 2.0 r_ht) s_ht) flanschseite))
			
	
			(Lochbild.set LchbID2 	(e0 		e0)
															(e1 		e1)
															(w0 		w0)
															(klemml klemm)
															(Lb_Art   16)
															(dxSKopf dxskopf)
															
			)
		)
	)
	
	
	
	
	  
	
	(Traeger.addabtl Htrg LchbID2 xPos_ht 0.0 _flanschlochbild_uf_)
	(Traeger.addabtl Tr_ID LchbID2 xPos_at 0.0 _flanschlochbild_uf_)
	
	(setq Abtl_StegLchb_ht (Traeger.get Htrg ABTeil LchbID2))
  (Anbauteil.set Abtl_StegLchb_ht (Master 1))
  (setq Abtl_StegLchb_at (Traeger.get Tr_ID ABTeil LchbID2))
  (Anbauteil.set Abtl_StegLchb_at (Master 0))
	
	
	
	(setq qsform_ht (Traeger.get Htrg qsform))
	
	(if (= qsform_ht "U")
		(progn
			(setq delta_lr_abtl_laschen (- (* 0.5 bp_blech)))
						
			(Anbauteil.set Abtl_StegLchb_ht (delta_lr delta_lr_abtl_laschen))
			(Anbauteil.set Abtl_StegLchb_at (delta_lr delta_lr_abtl_laschen))
		)
	)
	
	
	; LOCHBILD-TEST
	;===================================================================
	(if (= LB_DEBUG 1)
		(progn
						
			(setq dummy (Lochbild.create))
			(Lochbild.copy dummy LchbID2)
						
			(Traeger.addabtl Tr_ID dummy xPos_at 0.0 _flanschlochbild_uf_)
			
			(setq dummy_abtl (Traeger.get Tr_ID Abteil dummy))
			(Anbauteil.set dummy_abtl (Master 1)
																(delta_lr delta_lr_abtl_laschen)
			)
			
		)
	)
	;===================================================================
  (print ">-----------------------------------------------------------")
)

; ----------------------------------------------------------------------------------------
; Schraubendurchmesser ermitteln
; ----------------------------------------------------------------------------------------
(defun calcSchraube (t_blech)
	(print "Whle Schraube")
	(print t_blech)	
	; grobe Anhaltswerte fr Schraubenschaftdurchmesser
	(if (> t_blech 0.0)
		(setq S_Bez "M12")
	)
	(if (> t_blech 6.0)
		(setq S_Bez "M16")
	)
	(if (> t_blech 10.0)
		(setq S_Bez "M20")
	)
	(if (> t_blech 15.0)
		(setq S_Bez "M24")
	)
	(if (> t_blech 18.0)
		(setq S_Bez "M27")
	)
	(if (> t_blech 21.0)
		(setq S_Bez "M30")
	)
	(if (> t_blech 24.0)
		(setq S_Bez "M36")
	)
	(print S_Bez)
)

; ----------------------------------------------------------------------------------------
; ERZEUGT DAS DRUCKSTCK
; ----------------------------------------------------------------------------------------
(defun createDruckstueck (BLECHID delta_l_trg)
	(if (= (Connect.get CastaData linkesEnde) 1)
		(setq AtEnde (Traeger.get Tr_ID links))
	)
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(setq AtEnde (Traeger.get Tr_ID rechts))
	)
	
	(setq b_at	(Traeger.get Tr_ID b)
				t_at	(Traeger.get Tr_ID t)
	)
	
	(setq xPos_at	(Connect.get CastaData xPos_at))
	
	; Breite
	(setq bp_dst	b_at)
	
	;Hhe
	(setq hp_dst	(* 3.0 t_at))
	
	;Dicke
	(setq dp_dst	(* 2.0 delta_l_trg))
	
	(Blech.set BLECHID 	(hp		hp_dst)
											(bp		bp_dst)
											(dp		dp_dst)
											(dok	(- t_at))
	)
	
	(if (= qsform_ht "U")	(Blech.set BLECHID (delta_lr (* 0.5 bp_dst))))
	
	
	(if (= (Connect.get CastaData linkesEnde) 1)
		(Traeger.addabtl Tr_ID BLECHID xPos_at 0.0 _kopfplattelinks_)
	)
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(Traeger.addabtl Tr_ID BLECHID xPos_at 0.0 _kopfplatterechts_)
	)
		
)

(defun calcLochbildVersatz ()
     (setq dv_HT (Traeger.get HTrg  delta_V))
     (setq dv_AT (Traeger.get Tr_ID delta_V))
     
     (setq dvDiff (- dv_HT dv_AT))

     (setq Abtl_Lchb_HT (Traeger.get HTrg  ABTeil steglochbild))
     (setq Abtl_Lchb_AT (Traeger.get Tr_ID ABTeil steglochbild))

     (Anbauteil.set Abtl_Lchb_HT (delta_LR dvDiff))

)