; $ HT	QT(IU)	AF(K)		P(E)
; $	AT	QT(IU)	AF(K)		P(E)
; $	AE	V(90)		H(90)		R(-)

; Montagesto ber Laschen an Trgersteg
; **************************************
(defun init-connection ()
	
	(setq steglasche_re (blech.create))
	(setq steglasche_li (blech.create))
	(setq steglochbild	(Lochbild.create))
	(Connect.storeAnschlObjs CastaData steglasche_re steglasche_li steglochbild)
	
	(setq delta_l_trg 5)
	
	(kuerzeTraeger delta_l_trg)
	
	(createStegLaschen)
	
	(createStegLochbild steglochbild)
	(calcLochbildVersatz)


	; CALLBACKS
	(Blech.set steglasche_re (formFkt "cb_steglasche_re"))
	(Blech.set steglasche_li (formFkt "cb_steglasche_li"))
)


; ========================================================================================
; CALLBACK-FUNKTIONEN
; ========================================================================================

; ----------------------------------------------------------------------------------------
; Callback fr rechte Steglasche
; ----------------------------------------------------------------------------------------
(defun cb_steglasche_re (zp)
	(print "in Callback-Funktion cb_KplBlech")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dpAlt (Blech.get steglasche_re dp))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq dpNeu (Blech.get steglasche_re dp))
	    
	    (print dpAlt) (print dpNeu)
	    
	    (if (/= dpAlt dpNeu) (progn
	       (setq dpDiff (- dpNeu dpAlt))
	       (setq alteKlemml 	(Lochbild.get steglochbild Klemml))
	       
	       (Lochbild.set steglochbild 	(Klemml  (+ alteKlemml dpDiff))
	       															;(dxSKopf (+ altesDxSKopf dpDiff))	       	
	       )
	    ))
	))
)

; ----------------------------------------------------------------------------------------
; Callback fr linke Steglasche
; ----------------------------------------------------------------------------------------
(defun cb_steglasche_li (zp)
	(print "in Callback-Funktion cb_KplBlech")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dpAlt (Blech.get steglasche_li dp))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq dpNeu (Blech.get steglasche_li dp))
	    
	    (print dpAlt) (print dpNeu)
	    
	    (if (/= dpAlt dpNeu) (progn
	       (setq dpDiff (- dpNeu dpAlt))
	       (setq alteKlemml (Lochbild.get steglochbild Klemml))
	       (setq altesDxSKopf	(Lochbild.get steglochbild dxSKopf))
	       
	       (Lochbild.set steglochbild 	(Klemml (+ alteKlemml dpDiff))
	       															(dxSKopf (+ altesDxSKopf dpDiff))
	       )
	    ))
	))
)



; ----------------------------------------------------------------------------------------
; ERZEUGT DIE LASCHEN
; ----------------------------------------------------------------------------------------
(defun createStegLaschen ()
	(print "------------------------------------------------------------")
	(print "ERZEUGE STEGLASCHEN")
	(print "------------------------------------------------------------")
	(setq xPos_ht (Connect.get CastaData xPos_ht)
				xPos_at	(Connect.get CastaData xPos_at)
	)
	
	(setq hc_ht 	(Traeger.get Htrg hc)
				h_ht		(Traeger.get Htrg h)
				s_ht		(Traeger.get Htrg s)
	)
	
	(setq hc_at		(Traeger.get Tr_ID hc)
				h_at		(Traeger.get Tr_ID h)
				s_at		(Traeger.get Tr_ID s)
	)
	
	
	; massgebenden Traeger bestimmen
	(if (<= hc_ht hc_at)
		(setq mass_h hc_ht)
		(setq mass_h hc_at)
	)
	
	; Laschenbreite
	(setq h_lasche (* 1.0 mass_h))
	(setq h_lasche_rund (runde h_lasche auf 5))
	
	; delta_lr Lasche
	(setq s_ht_halb (* 0.5 s_ht))
	(setq delta_lr_lasche s_ht_halb)
	
	; Laschenhhe
	(setq hp_lasche h_ht)
	
		
	(Blech.set steglasche_re 	(dp 	s_ht) 
														(hp 	hp_lasche) 
														(bp 	h_lasche_rund) 
														;(delta_lr 20)
														;(dok 	dok_lasche)
	)
	(Blech.set steglasche_li 	(dp 	s_ht) 
														(hp 	hp_lasche) 
														(bp 	h_lasche_rund) 
														;(delta_lr 20)
														;(dok 	dok_lasche)
	)
	
	
	(if (>= s_at s_ht)
		(progn
			(Traeger.addabtl Tr_ID steglasche_re xPos_at 0.0 _lasche_steg_re_)
			(Traeger.addabtl Tr_ID steglasche_li xPos_at 0.0 _lasche_steg_li_)
		)
		(progn
			(Traeger.addabtl Htrg steglasche_re xPos_ht 0.0 _lasche_steg_re_)
			(Traeger.addabtl Htrg steglasche_li xPos_ht 0.0 _lasche_steg_li_)
		)
	)
	
	(print "------------------------------------------------------------")
)

; ----------------------------------------------------------------------------------------
; BILDET EINEN SPALT ZWISCHEN DEN TRAEGERN
; ----------------------------------------------------------------------------------------
(defun kuerzeTraeger (dl)
	(if (= (Connect.get CastaData anHtLinkesEnde) 1)
		(setq TrgEnde_HT (Traeger.get Htrg links))
	)
	(if (= (Connect.get CastaData anHtRechtesEnde) 1)
		(setq TrgEnde_HT (Traeger.get Htrg rechts))
	)
	(if (= (Connect.get CastaData LinkesEnde) 1)
		(setq TrgEnde_AT (Traeger.get Tr_ID links))
	)
	(if (= (Connect.get CastaData RechtesEnde) 1)
		(setq TrgEnde_AT (Traeger.get Tr_ID rechts))
	)
	
	(TrEnde.set TrgEnde_HT (delta_l dl))
	(TrEnde.set TrgEnde_AT (delta_l dl))
)

; ----------------------------------------------------------------------------------------
; BERECHNET DAS LOCHBILD
; ----------------------------------------------------------------------------------------
(defun createStegLochbild (LchbID)
	(print ">-----------------------------------------------------------")
	(print "ERZEUGE STEGLOCHBILD")
	
	(Lochbild.set LchbID
		(S_Bez   "M20")
		(Guete   "4.6")
		(e       "100  0 0 0 0 0")
		(w       "100  0")
	)
	
	(setq s_ht 			(Traeger.get Htrg s)
				h_ht			(Traeger.get Htrg h)
				qsform_ht (Traeger.get Htrg qsform)
	)
	
	(setq xPos_ht (Connect.get CastaData xPos_ht)
				xPos_at	(Connect.get CastaData xPos_at)
	)
	
	(setq hp_blech_li (Blech.get steglasche_li hp)
				bp_blech_li	(Blech.get steglasche_li bp)
	)
	(setq dp_blech_li (Blech.get steglasche_li dp))
	(setq dp_blech_re (Blech.get steglasche_re dp))
	
	; Klemmlnge
	(setq klemm (+ s_ht dp_blech_li dp_blech_re))
		
	; dxsKopf	
	(if (= qsform_ht "I")	
		(setq dxskopf (+ (* 0.5 s_ht) dp_blech_li))
	)
	(if (= qsform_ht "U")
		(progn
			(setq dxskopf dp_blech_li)
		)
	)
	
	; Schraubengre	
	(if	(<= s_ht dp_blech_li)
		(setq minT s_ht)
		(setq minT dp_blech_li)
	)
	(calcSchraube minT)
	(Lochbild.set LchbID (S_Bez S_Bez))
	
	; Loch- und Randabstnde
	(setq schr_d (Lochbild.get LchbID sdurchm))
	
	(setq randabstand (* 2.0 schr_d))
	(setq lochabstand	(* 4.0 schr_d))
	
	(setq ra_rund (runde randabstand auf 5))
	(setq la_rund (runde lochabstand auf 5))
	
	(setq minhpSeite (+ la_rund (* 2.0 ra_rund)))
	(setq anteil_dl (* 2.0 delta_l_trg))
	
	(setq minHp (+ (* 2.0 minhpSeite) anteil_dl))
	
	(if (< hp_blech_li minHp)
		(progn
			(setq hp_blech_li minHp)
			(setq hp_blech_re minHp)
			
			(Blech.set steglasche_li (hp hp_blech_li))
			(Blech.set steglasche_re (hp hp_blech_re))
		)
	)
	
	(if (> minhpSeite bp_blech_li)
		(setq DOPPEL 0)
		(setq DOPPEL 1)
	)
	(print DOPPEL)
	
	(if (= DOPPEL 1)
		(progn
			(setq e0 (+ (* 0.25 hp_blech_li) anteil_dl))
			(setq e1 (+ (* 0.75 hp_blech_li) anteil_dl))
			(setq w0 (* 0.5 bp_blech_li))
			
			(Lochbild.set LchbID 	(e0 		e0)
														(e1 		e1)
														(w0 		w0)
														(klemml klemm)
														(Lb_Art   16)
														(dxSKopf dxskopf)
			)
		)
	)
	
	(if (= DOPPEL 0)
		(progn
			(setq e0 (+ (* 0.25 hp_blech_li) anteil_dl))
			(setq e1 (+ (* 0.75 hp_blech_li) anteil_dl))
						
			(Lochbild.set LchbID 	(e0 		e0)
														(e1 		e1)
														(w0			1)		;w0 = 0!!!!!!!!!!
														(klemml klemm)
														(Lb_Art   16)
														(dxSKopf dxskopf)
			)
		)
	)
	
	(Traeger.addabtl Htrg LchbID xPos_ht 0.0 _steglochbild_system_)
	(Traeger.addabtl Tr_ID LchbID xPos_at 0.0 _steglochbild_system_)
	
	(setq Abtl_StegLchb_ht (Traeger.get Htrg ABTeil LchbID))
  (Anbauteil.set Abtl_StegLchb_ht (Master 1))
  (setq Abtl_StegLchb_at (Traeger.get Tr_ID ABTeil LchbID))
  (Anbauteil.set Abtl_StegLchb_at (Master 0))
  (print ">-----------------------------------------------------------")
)

; ----------------------------------------------------------------------------------------
; Schraubendurchmesser ermitteln
; ----------------------------------------------------------------------------------------
(defun calcSchraube (t_blech)
		
	; grobe Anhaltswerte fr Schraubenschaftdurchmesser
	(if (> t_blech 0.0)
		(setq S_Bez "M12")
	)
	(if (> t_blech 6.0)
		(setq S_Bez "M16")
	)
	(if (> t_blech 10.0)
		(setq S_Bez "M20")
	)
	(if (> t_blech 15.0)
		(setq S_Bez "M24")
	)
	(if (> t_blech 18.0)
		(setq S_Bez "M27")
	)
	(if (> t_blech 21.0)
		(setq S_Bez "M30")
	)
	(if (> t_blech 24.0)
		(setq S_Bez "M36")
	)
	
)

(defun calcLochbildVersatz ()
     (setq dv_HT (Traeger.get HTrg  delta_V))
     (setq dv_AT (Traeger.get Tr_ID delta_V))
     
     (setq dvDiff (- dv_AT dv_HT))

     (setq Abtl_Lchb_HT (Traeger.get HTrg  ABTeil steglochbild))
     (setq Abtl_Lchb_AT (Traeger.get Tr_ID ABTeil steglochbild))

     (Anbauteil.set Abtl_Lchb_AT (delta_LR dvDiff))

)