; $	HT	QT(IURK)	AF(FS)		P(EZ)
; $	AT	QT(L)		AF(K)			P(E)
; $	AE	V(-)		H(-)			R(-)

(defun load-modules ()
	; Profil prfen
	(setq qsform_at (Traeger.get Tr_ID qsform))
  (print qsform_at)
  
  (if (= qsform_at "L")	(load "mod-calc-windverband_L_GTC"))
  
  (if (= qsform_at "F")	(load "mod-calc-windverband_F"))
  (if (= qsform_at "U") (alertBox "Anschluss noch nicht mglich."  "Connection_Not_Possible_Yet"));
  (if (= qsform_at "I") (alertBox "Anschluss noch nicht mglich."  "Connection_Not_Possible_Yet"));
  (if (= qsform_at "R") (load "mod-calc-windverband_R"));
  (if (= qsform_at "K") (alertBox "Anschluss noch nicht mglich."  "Connection_Not_Possible_Yet"));
  
  (load "mod-lochbild")
)

(defun init-connection ()
	(print "********************************************************************")
  (print "in init-connection - stz_Windverb_1");
   
  (connect.ShowAttributes CastaData)

  ; neu eingebaut - Sept 2011 
  (setq AnschlussAusfuehren 1)
  (setq qsform_Ht (Traeger.get HTrg qsform))
  (if (= qsform_Ht "R") (Untersuchung_AnschlMoegl))
 
  (setq K-Verband 0)
    
  (setq l_schr 200)
  (setq parallel_abstand_stz 30)
  (setq rand_abst 10)

	
	(setq STD 0)
  (if (= AnschlussAusfuehren 1) (progn
	
	(if (= qsform_at "R")
		(rProf)
	)
	(if (= qsform_at "F")
		(fProf)
	)
	(if (= qsform_at "L")
		(progn
			(init-windverband)
			(cutBlechAt_HTXPos)
		
			; CALLBACKS
			(Blech.set knotenBlech 	(formFkt "cb_knotenBlech"))
		)
	)

	(if (= qsform_Ht "R") (Untersuchung_Knbl_Aussmitte))


	; ------------- Test-Szenario
	(if (= 1 2) (progn
		(print "*clear*")
	  	(setq AbtlKnoBlLchbAT    (Traeger.get Tr_ID AbTeil knblLochbild))
	  	(setq AbtlKnoBlLchbHT    (Traeger.get HTrg  AbTeil knblLochbild))
	  	
	  	(Anbauteil.set AbtlKnoBlLchbAT (Master 0))
	  	(Anbauteil.set AbtlKnoBlLchbHT (Master 1))
	 	
	  	(Lochbild.set knblLochbild (delta_w    20))
	 	(Lochbild.set knblLochbild (w0         10))
	 	(Lochbild.set knblLochbild (e1         100) (e2 20))
	  	; (Lochbild.set knblLochbild (lb_art 0))
	
		(print "Check-Seitenrichtungen")  	
	  	(setq SeitRichtung_AT (Anbauteil.get AbtlKnoBlLchbAT SeitRicht))
	  	(print SeitRichtung_AT)
	  	(setq SeitRichtung_HT (Anbauteil.get AbtlKnoBlLchbHT SeitRicht))
	  	(print SeitRichtung_HT)
	  	
	 ; 	(Anbauteil.set AbtlKnoBlLchbHT (SeitRicht  -1))
	
		(setq LB_Art (Lochbild.get knblLochbild LB_Art))
		(print LB_Art)
		
	))
  ))
	
)
; --- ergnzt Sept. 2011 fr Anschlsse an Rohre als Haupttrger
(defun Untersuchung_AnschlMoegl ()
    (if (= (Connect.get CastaData amHtSteg) 1) (progn
	(setq EbenenWinkel (Connect.get CastaData afl_VWinkel))
	(if (/= EbenenWinkel 90.0) (setq AnschlussAusfuehren 0))
    ))
    (if (= (Connect.get CastaData amHtFlansch) 1) (progn
	(setq EbenenWinkel (Connect.get CastaData afl_HWinkel))
	(if (/= EbenenWinkel 0.0) (setq AnschlussAusfuehren 0))
    ))
    (if (= AnschlussAusfuehren 0) (AlertBox "Anschluss wird nicht erstellt!\nDer Winkel in der Windverbandsebene ist unpassend." "ERR_AngleInPlaneProblem"))
)
(defun Untersuchung_Knbl_Aussmitte ()
   (if (objExist knotenBlech) (progn
      (setq	h_HT	(Traeger.get HTrg h)
		r	(/ h_HT 2.0)
		a	(Blech.get knotenBlech delta_LR)
		dp	(Blech.get knotenBlech dp)
		a1	(- a (* 0.5 dp))
		a2	(+ a (* 0.5 dp))
      )
      (setq	x1	(- r (sqrt (- (* r r) (* a1 a1)))))
      (setq	x2	(- r (sqrt (- (* r r) (* a2 a2)))))
      
      (if (< x1 x2) (progn
          (if (>= x1 1.0) (WarnMeldung_Ausmitte x2))
      ))
      (if (< x2 x1) (progn
          (if (>= x2 1.0) (WarnMeldung_Ausmitte x1))
      ))
   ))
)
(defun WarnMeldung_Ausmitte (klaffende_Fuge)
  (alertBox "Achtung!!\n\nDurch die ausmittige Lage des Knotenblechs ist ein Spalt von 1mm der nahen Kante zu verzeichnen!\nBitte beachten Sie die klaffende Fuge - durch Schweinaht zu verschlieen." "NOTE_GapToClose")
  (alertBox klaffende_Fuge)
)


; ----------------------------------------------------------------------------------------
(defun rProf ()
	
	(setq delta_v_at 	(Traeger.get Tr_ID delta_v))
	(setq delta_lr_at	(Traeger.get Tr_ID delta_lr))
	
	(if (= (Connect.get CastaData satr-lhtr) 0)
		(progn
			(Traeger.set Tr_ID (r_winkel 90.0))
			(alertBox "Die Orientierung des Anschlusstrgers wird durch das Programm angepasst. Bitte wiederholen Sie nun Ihre Eingabe." "NOTE_BracingBeamRotationCorrection")
		)
		(progn
			(if (= (Connect.get CastaData amHtFlansch) 1)
				(progn
					(if (/= (Connect.get CastaData satr-vhtr) 0)
						(progn
							(if (/= (Connect.get CastaData vatr-shtr) 0)
								(progn 
									(init-windverband)
									; CALLBACKS
									(Blech.set knotenBlech 	(formFkt "cb_knotenBlech"))
									(Blech.set augenBlech 	(formFkt "cb_augenBlech"))
								)
								(alertBox "Bitte passen Sie die rel. Lage des Anschlusstrgers dem Haupttrger an." "ModifyRelativePos_AT_HT")
							)
						)
						(progn
							(if (/= (Connect.get CastaData vatr-shtr) 0)
								(progn 
									(init-windverband)
									; CALLBACKS
									(Blech.set knotenBlech 	(formFkt "cb_knotenBlech"))
									(Blech.set augenBlech 	(formFkt "cb_augenBlech"))
								)
								(alertBox "Bitte passen Sie die rel. Lage des Anschlusstrgers dem Haupttrger an." "ModifyRelativePos_AT_HT")
							)
						)
					)
				)
			)
			(if (= (Connect.get CastaData amHtSteg) 1)
				(progn
					(if (/= (Connect.get CastaData vatr-vhtr) 0)
						(progn
							(init-windverband)
							; CALLBACKS
							(Blech.set knotenBlech 	(formFkt "cb_knotenBlech"))
							(Blech.set augenBlech 	(formFkt "cb_augenBlech"))
						)		
					)
				)
			)
		)
	)
	
	
)


; ----------------------------------------------------------------------------------------
(defun fProf ()
	
	(if (= (Connect.get CastaData amHtFlansch) 1)
		(progn
			(if (/= (Connect.get CastaData satr-shtr) 0)
				(progn
					(alertBox "Anschluss nicht mglich! Bitte rotieren Sie den Anschlusstrger um 90."  "ERR_Rotate_AT_90")
				)
				(progn
					(init-windverband)
					
					; CALLBACKS
					(Blech.set knotenBlech 	(formFkt "cb_knotenBlech"))
				)
			)
		)
	)
			
	(if (= (Connect.get CastaData amHtSteg) 1)
		(progn
			(if (/= (Connect.get CastaData satr-vhtr) 0)
				(progn
					(alertBox "Anschluss nicht mglich! Bitte rotieren Sie den Anschlusstrger um 90."  "ERR_Rotate_AT_90")
				)
				(progn
					(init-windverband)
					; CALLBACKS
					(Blech.set knotenBlech 	(formFkt "cb_knotenBlech"))
				)
			)
		)
	)
			
)



; ========================================================================================
; CALLBACK-FUNKTIONEN
; ========================================================================================

; ----------------------------------------------------------------------------------------
; Callback fr Knotenblech am HT
; ----------------------------------------------------------------------------------------
(defun cb_knotenBlech (zp)
	(print "in Callback-Funktion cb_knotenBlech")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dpAlt 				(Blech.get knotenBlech dp))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq dpNeu (Blech.get knotenBlech dp))
	    
	    (print dpAlt) (print dpNeu)
	    
	    (if (/= dpAlt dpNeu) (progn
					(setq dpDiff (- dpNeu dpAlt))
					(setq alteKlemml 		(Lochbild.get knblLochbild Klemml)
								altesDxSKopf	(Lochbild.get knblLochbild dxSKopf)
					)
					
					(setq delta_lr_Alt 	(Blech.get knotenBlech delta_lr))
					
					(setq qsform_at (Traeger.get Tr_ID qsform))
					
					; Flachstahl
					; --------------------------------------
					(if (= qsform_at "F")
						(progn
							(print "Flachstahl-Profil")
							(Lochbild.set knblLochbild 	(Klemml 	(+ alteKlemml dpDiff)))
							
							(if (= (Connect.get CastaData satr-lhtr)  1)
								(progn
									(Blech.set knotenBlech (delta_lr (+ delta_lr_alt (* 0.5 dpDiff))))
								)
							)
							(if (= (Connect.get CastaData satr-lhtr) -1)	
								(progn
									(Blech.set knotenBlech (delta_lr (- delta_lr_alt (* 0.5 dpDiff))))
									(Lochbild.set knblLochbild 	(dxsKopf	(+ altesDxSKopf dpDiff)))
								)
							)
						)
					)
					
					
					; Winkelprofil
					; --------------------------------------
					(if (= qsform_at "L")
						(progn
							(print "Winkel-Profil")
							(Lochbild.set knblLochbild 	(Klemml 	(+ alteKlemml dpDiff))
																					;(dxsKopf	(+ altesDxSKopf (* 0.5 dpDiff)))
							)
							
							(Connect.showAttributes CastaData)
							
							; HT STEG
							; ----------------------------------
							(if (= (Connect.get CastaData amHtSteg) 1)
								(progn
									(if (= (Connect.get CastaData vatr-vhtr)  1)
										(progn
											(if (= (Connect.get CastaData satr-lhtr) -1)	(Blech.set knotenBlech (delta_lr (+ delta_lr_alt (* 0.5 dpDiff)))))
											(if (= (Connect.get CastaData satr-lhtr)  1)	(Blech.set knotenBlech (delta_lr (+ delta_lr_alt (* 0.5 dpDiff)))))
										)
									)
									(if (= (Connect.get CastaData vatr-vhtr) -1)
										(progn
											(if (= (Connect.get CastaData satr-lhtr) -1)	
												(progn
													(Blech.set knotenBlech (delta_lr (- delta_lr_alt (* 0.5 dpDiff))))
													(Lochbild.set knblLochbild 	(dxsKopf	(+ altesDxSKopf dpDiff)))
												)
											)
											(if (= (Connect.get CastaData satr-lhtr)  1)
												(progn
													(Blech.set knotenBlech (delta_lr (- delta_lr_alt (* 0.5 dpDiff))))
													(Lochbild.set knblLochbild 	(dxsKopf	(+ altesDxSKopf dpDiff)))
												)
											)
										)
									)
									(if (= (Connect.get CastaData satr-vhtr)  1)
										(progn
											(if (= (Connect.get CastaData vatr-lhtr) -1)
												(progn
													(Blech.set knotenBlech (delta_lr (- delta_lr_alt (* 0.5 dpDiff))))
													(Lochbild.set knblLochbild 	(dxsKopf	(+ altesDxSKopf dpDiff)))
												)
											)
											(if (= (Connect.get CastaData vatr-lhtr)  1)	
												(progn
													(Blech.set knotenBlech (delta_lr (- delta_lr_alt (* 0.5 dpDiff))))
													(Lochbild.set knblLochbild 	(dxsKopf	(+ altesDxSKopf dpDiff)))
												)
											)
										)
									)
									(if (= (Connect.get CastaData satr-vhtr) -1)
										(progn
											(if (= (Connect.get CastaData vatr-lhtr) -1)	(Blech.set knotenBlech (delta_lr (+ delta_lr_alt (* 0.5 dpDiff)))))
											(if (= (Connect.get CastaData vatr-lhtr)  1)	(Blech.set knotenBlech (delta_lr (+ delta_lr_alt (* 0.5 dpDiff)))))
										)
									)
								)
							)
			
							
							; HT FLANSCH
							; ----------------------------------
							(if (= (Connect.get CastaData amHtFlansch) 1)
								(progn
									(if (= (Connect.get CastaData vatr-shtr)  1)
										(progn
											(if (= (Connect.get CastaData satr-lhtr) -1)	(Blech.set knotenBlech (delta_lr (+ delta_lr_alt (* 0.5 dpDiff)))))
											(if (= (Connect.get CastaData satr-lhtr)  1)	(Blech.set knotenBlech (delta_lr (+ delta_lr_alt (* 0.5 dpDiff)))))
										)
									)
									(if (= (Connect.get CastaData vatr-shtr) -1)
										(progn
											(if (= (Connect.get CastaData satr-lhtr) -1)	
												(progn
													(Blech.set knotenBlech (delta_lr (- delta_lr_alt (* 0.5 dpDiff))))
													(Lochbild.set knblLochbild 	(dxsKopf	(+ altesDxSKopf dpDiff)))
												)
											)
											(if (= (Connect.get CastaData satr-lhtr)  1)
												(progn
													(Blech.set knotenBlech (delta_lr (- delta_lr_alt (* 0.5 dpDiff))))
													(Lochbild.set knblLochbild 	(dxsKopf	(+ altesDxSKopf dpDiff)))
												)
											)
										)
									)
									(if (= (Connect.get CastaData satr-shtr)  1)
										(progn
											(if (= (Connect.get CastaData vatr-lhtr) -1)	
												(progn
													(Blech.set knotenBlech (delta_lr (- delta_lr_alt (* 0.5 dpDiff))))
													(Lochbild.set knblLochbild 	(dxsKopf	(+ altesDxSKopf dpDiff)))
												)
											)
											(if (= (Connect.get CastaData vatr-lhtr)  1)	
												(progn
													(Blech.set knotenBlech (delta_lr (- delta_lr_alt (* 0.5 dpDiff))))
													(Lochbild.set knblLochbild 	(dxsKopf	(+ altesDxSKopf dpDiff)))
												)
											)
										)
									)
									(if (= (Connect.get CastaData satr-shtr) -1)
										(progn
											(if (= (Connect.get CastaData vatr-lhtr) -1)	(Blech.set knotenBlech (delta_lr (+ delta_lr_alt (* 0.5 dpDiff)))))
											(if (= (Connect.get CastaData vatr-lhtr)  1)	(Blech.set knotenBlech (delta_lr (+ delta_lr_alt (* 0.5 dpDiff)))))
										)
									)
								)
							)
							
						)
					)
							
					; Rundstahl
					; --------------------------------------
					(if (= qsform_at "R")
						(progn
							(print "Rundstahl-Profil")
							(Lochbild.set knblLochbild 	(Klemml 	(+ alteKlemml dpDiff))
																					;(dxsKopf	(+ altesDxSKopf (* 0.5 dpDiff)))
							)
							
							(if (= (Connect.get CastaData satr-lhtr)  1)
								(progn
									(Blech.set knotenBlech (delta_lr (+ delta_lr_alt (* 0.5 dpDiff))))
								)
							)
							(if (= (Connect.get CastaData satr-lhtr) -1)	
								(progn
									(Blech.set knotenBlech (delta_lr (- delta_lr_alt (* 0.5 dpDiff))))
									(Lochbild.set knblLochbild 	(dxsKopf	(+ altesDxSKopf dpDiff)))
								)
							)
						)
					)	
					
					
	    ))
	))
)


; ----------------------------------------------------------------------------------------
; Callback fr die Augenlasche bei Rundprofilen
; ----------------------------------------------------------------------------------------
(defun cb_augenBlech (zp)
	(print "in Callback-Funktion cb_augenBlech")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dpAlt (Blech.get augenBlech dp))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq dpNeu (Blech.get augenBlech dp))
	    
	    (print dpAlt) (print dpNeu)
	    
	    (if (/= dpAlt dpNeu) (progn
					(setq dpDiff (- dpNeu dpAlt))
					(setq alteKlemml 		(Lochbild.get knblLochbild Klemml)
								altesDxSKopf	(Lochbild.get knblLochbild dxSKopf)
					)
					(print altesDxSKopf)
					
					(setq delta_lr_Alt 	(Blech.get knotenBlech delta_lr))
					
					(setq qsform_at (Traeger.get Tr_ID qsform))
					
					
					(Lochbild.set knblLochbild 	(Klemml 	(+ alteKlemml dpDiff))
																			(dxsKopf	(+ altesDxSKopf (* 0.5 dpDiff)))
					)
						
					
					(if (= (Connect.get CastaData satr-lhtr)  1)
						(progn
							(Blech.set knotenBlech (delta_lr (+ delta_lr_alt (* 0.5 dpDiff))))
						)
					)
					(if (= (Connect.get CastaData satr-lhtr) -1)	
						(progn
							(Blech.set knotenBlech (delta_lr (- delta_lr_alt (* 0.5 dpDiff))))
						)
					)
	    ))
	))
)

(defun cutBlechAt_HTXPos ()
	(print "*clear*")

	(setq Abtl_BL (Traeger.get HTrg ABTeil knotenBlech))
	(setq xPos_BL (Anbauteil.get Abtl_BL xPos))
	(setq xPos_HT (Connect.get CastaData xPos_HT))
	(setq LB_Winkel (Anbauteil.get Abtl_BL Winkel))
	
	(print xPos_BL) (print xPos_HT) (print LB_Winkel)
	
	; Wenn an Flansch angeschlossen wird
	(setq h_HT (Traeger.get HTrg h) h_Ht2  (/ h_HT 2.0))
	(setq s_HT (Traeger.get HTrg h) s_Ht2  (/ s_HT 2.0))
	(setq hp   (Blech.get knotenBlech hp) hp2  (* 0.5 hp))
	(setq bp   (Blech.get knotenBlech bp) bp2  (* 0.5 bp))
	(setq dOK  (Blech.get knotenBlech dOK))

	(setq SpaltMasz 10)
	
	(setq tanAlfa (tan (/ (* LB_Winkel PI) 180.0)))
	(print tanAlfa)

	(if (= (Connect.get CastaData amHTFlansch) 1) (progn
			(setq dv (/ h_Ht2 (tan (/ (* LB_Winkel PI) 180.0))))
	))
	(if (= (Connect.get CastaData amHTSteg) 1) (progn
			(setq dv (/ s_Ht2 (tan (/ (* LB_Winkel PI) 180.0))))
	))
	
	(if (= (Connect.get CastaData amHTFlansch) 1) (progn
		(if (> LB_Winkel 90.0) (progn
			(print dv)
			(setq xv_Bl (/ (* 1.0 (+ h_Ht2 bp2)) tanAlfa))
			(setq xp_Bl_Help (+  xPos_BL xv_Bl))
			 (setq xp_Bl_Help (+ xp_Bl_Help SpaltMasz))
			
			(setq x_Pkt (+ xp_Bl_Help hp2 (- dOK)))
			(print "-------------") (print xv_Bl) (print xp_Bl_Help) (print x_Pkt)
			
			(setq hpDiff (- x_Pkt xPos_HT))
			(print hpDiff)
			
			(setq delta_V_BL (Anbauteil.get Abtl_BL delta_V))
			(setq delta_V_BL (Blech.get knotenBlech dOK))
			(print delta_V_BL)
			(setq hp_Neu (- hp hpDiff))
			(setq dvBL_neu (+ delta_V_BL (* 0.5 hpDiff)))
			
			(Blech.set knotenBlech (hp hp_Neu) (dOK dvBL_neu))
			
			(setq x4_vorh (Blech.get knotenBlech x4) y4_vorh (Blech.get knotenBlech y4))
			(print x4_vorh) (print y4_vorh)
			(setq x4_neu (- x4_vorh hpDiff))
			(setq y4_neu (- y4_vorh (* hpDiff (- tanAlfa))))
			
			(print x4_neu) (print y4_neu)
			(setq SetBlechValues 1)
			(if (<= x4_neu 0) (setq SetBlechValues 0))
			(if (<= y4_neu 0) (setq SetBlechValues 0))
			(if (>  x4_neu hp_Neu) (setq SetBlechValues 0))
			(if (>  y4_neu bp) (setq SetBlechValues 0))
			
			(if (= SetBlechValues 1)
				(Blech.set knotenBlech (x4 x4_neu) (y4 y4_neu))
			)
		))
		(if (< LB_Winkel 90.0) (progn
			(setq xv_Bl (/ (* 1.0 (+ h_Ht2 bp2)) tanAlfa))
			(setq xp_Bl_Help (+  xPos_BL xv_Bl))
			(setq x_Pkt (- xp_Bl_Help hp2 dOK))
			(print "-------------") (print xv_Bl) (print xp_Bl_Help) (print x_Pkt)

			(setq hpDiff (- xPos_HT x_Pkt))
			(print hpDiff)
			
			(setq delta_V_BL (Anbauteil.get Abtl_BL delta_V))
			(setq delta_V_BL (Blech.get knotenBlech dOK))
			(print delta_V_BL)
			(setq hp_Neu (- hp hpDiff))
			(setq dvBL_neu (- delta_V_BL (* 0.5 hpDiff)))
			
			(Blech.set knotenBlech (hp hp_Neu) (dOK dvBL_neu))
			
			(setq x1_vorh (Blech.get knotenBlech x1) y1_vorh (Blech.get knotenBlech y1))
			(print x1_vorh) (print y1_vorh)
			(setq x1_neu (- x1_vorh hpDiff))
			(setq y1_neu (- y1_vorh (* hpDiff tanAlfa)))

			(setq SetBlechValues 1)
			(if (<= x1_neu 0) (setq SetBlechValues 0))
			(if (<= y1_neu 0) (setq SetBlechValues 0))
			(if (>  x1_neu hp_Neu) (setq SetBlechValues 0))
			(if (>  y1_neu bp) (setq SetBlechValues 0))
			
			(if (= SetBlechValues 1)
				(Blech.set knotenBlech (x1 x1_neu) (y1 y1_neu))
			)
		))
	))
	; (Connect.showAttributes CastaData)
	
)




