(defun init-connection ()
	(print "********************************************************************")
  (print "in init-connection - stz_Windverb_1");
 
;  (Traeger.set Tr_ID (delta_V 200))
 
  
;  (connect.ShowAttributes CastaData)
 
  ; Tr_ID ist der Verbandsstab
  ; HTrg  ist die Sttze, an die angeschlossen wird
  
  
  (setq l_schr 200)
  (setq parallel_abstand_stz 30)
  (setq rand_abst 10)
	
  
	(createKnotenBlech l_schr rand_abst)
  ; Entweder Anschlussauswahl fr Profiltypen auch noch erstellen
  ; oder hier eine Fallunterscheidung machen, falls es sich nicht um ein
  ; Winkelprofil handelt
  (kuerzeWinkelProfil parallel_abstand_stz)
  
	
  (if (= (Connect.get CastaData linkesEnde) 1)
  	
  	(progn
  		(if (= (Connect.get CastaData anschl_anderesende) 0)
  			
  			(positioniereVerband)
  		)
  	)
  )
  (if (= (Connect.get CastaData rechtesEnde) 1)
  	
  	(progn
  		(if (= (Connect.get CastaData anschl_anderesende) 0)
  			
  			(positioniereVerband)
  		)
  	)
  )
  	
  
  
  (createLochbild knotenBlech rand_abst parallel_abstand_stz)
)
; ====================================================================== 
(defun kuerzeWinkelProfil (p_abst_stz)

  ; Winkelprofil krzen ...
  ; korrekten Wert noch aus Sttzenprofil und Winkel berechnen
  (setq kuerzLng     0
        h_Ht     (Traeger.get HTrg h)
        s_Ht     (Traeger.get HTrg s)
        deltaV   (Traeger.get HTrg delta_V)
        deltaLR  (Traeger.get HTrg delta_LR)
        b_Trg    (Traeger.get Tr_ID b)			; ist die Frage, wie der Stab liegt
        h_Trg    (Traeger.get Tr_ID h)			; ob Breite oder Hhe entscheidend sind.
  )
  (if (= (connect.get CastaData amHtOberFlansch) 1) (progn
      (setq kuerzLng (- (* 0.5 h_Ht) deltaV))
  ))
  (if (= (connect.get CastaData amHtUnterFlansch) 1) (progn
      (setq kuerzLng (+ (* 0.5 h_Ht) deltaV))
  ))

  (if (= (connect.get CastaData amHtStegLinks) 1) (progn
      (setq kuerzLng (- (* 0.5 s_Ht) deltaLR))
  ))
  (if (= (connect.get CastaData amHtStegRechts) 1) (progn
      (setq kuerzLng (+ (* 0.5 s_Ht) deltaLR))
  ))

  (setq AFl_Winkel (connect.get CastaData AFl_VWinkel))
  (print AFl_Winkel)
  (setq    AFl_Winkel (- AFl_Winkel 90.0) 
  )
(print AFl_Winkel)
  ;(print AFl_Winkel)
  (setq sinAWnkl (sin (/ (* PI AFl_Winkel) 180.0))
  			cosAWnkl (cos (/ (* PI AFl_Winkel) 180.0))
  			tanAWnkl (tan (/ (* PI AFl_Winkel) 180.0))
  )
  
  (setq abstand_Stz p_abst_stz)
  
  (if (= cosAWnkl 0.0) (setq cosAWnkl 1.0))
  ;(setq deltaLNeu (+ (/ kuerzLng cosAWnkl) (* 0.5 b_Trg tanAWnkl)))
  (setq anteil_Stz (/ kuerzLng cosAWnkl))
  (setq anteil_Verb (* 0.5 b_Trg tanAWnkl))
  
  (if (< AFl_Winkel 0) 
  	(setq deltaLNeu (+ abstand_Stz anteil_Stz (- anteil_Verb)))
  	(setq deltaLNeu (+ abstand_Stz anteil_Stz anteil_Verb))
  )
  
  ;(print kuerzLng)
  ;(print b_Trg)
  ;(print abstand_Stz)
  ;(print anteil_Stz)
  ;(print anteil_Verb)
  ;(print deltaLNeu)
  
  
  
	;Krzen
  (if (= (connect.get CastaData LinkesEnde) 1) (progn
      (setq TrE_Links (Traeger.get Tr_ID links))
      (TrEnde.set TrE_Links (delta_L 0))
      (TrEnde.pTrim TrE_Links deltaLNeu)
  ))
  (if (= (connect.get CastaData RechtesEnde) 1) (progn
      (setq TrE_Rechts (Traeger.get Tr_ID rechts))
      (TrEnde.set TrE_Rechts (delta_L 0))			; erst einmal zurcksetzen
      (TrEnde.pTrim TrE_Rechts deltaLNeu)			; dann krzen
  ))

	
)

; ----------------------------------------------------------------------
; Verschiebt den Trger Passend zum Knotenblech
; ---------------------------------------------------------------------- 
(defun positioniereVerband ()
	
	(print "in positioniereWinkelProfil")
	(print "------------------------------")		
	;Positionieren
  (setq RWinkel (Traeger.get Tr_ID R_Winkel)
        dp      (Blech.get   knotenBlech  dp)
        b_Trg    (Traeger.get Tr_ID b)			; ist die Frage, wie der Stab liegt
        h_Trg    (Traeger.get Tr_ID h)			; ob Breite oder Hhe entscheidend sind.
  )
  (print RWinkel)
  (print dp)
  
  
  (if (= RWinkel   0.0) (Traeger.set Tr_ID (delta_V (+ delta_v_at (*  0.5 h_Trg))) (delta_LR (+ delta_lr_at (* 0.5 dp)))))
  (if (= RWinkel  90.0) (Traeger.set Tr_ID (delta_V (- delta_v_at (* 	0.5    dp))) (delta_LR (- delta_lr_at (* 0.5 b_Trg)))))
  (if (= RWinkel 180.0) (Traeger.set Tr_ID (delta_V (+ delta_v_at (*  0.5 h_Trg))) (delta_LR (+ delta_lr_at (* 0.5    dp)))))
  (if (= RWinkel 270.0) (Traeger.set Tr_ID (delta_V (- delta_v_at (*  0.5    dp))) (delta_LR (- delta_lr_at (* 0.5 b_Trg)))))
				
)

; ----------------------------------------------------------------------
; Erzeugt das Knotenblech
; ---------------------------------------------------------------------- 
(defun createKnotenBlech (l_schr rand_abst)
	(print "------------------------------------------------------------")
	(print "ERZEUGE KNOTENBLECH")
	
  (setq knotenBlech (Blech.create))
  (Connect.storeAnschlObjs CastaData knotenBlech)
  
  (Blech.set knotenBlech 	(dp 10)
      										(hp 200)
      										(bp 120)
  )

	(setq b_Trg   		(Traeger.get Tr_ID b)
				h_Trg	  		(Traeger.get Tr_ID h)
				RWinkel 		(Traeger.get Tr_ID R_Winkel)
				delta_v_at 	(Traeger.get Tr_ID delta_v)
				delta_lr_at (Traeger.get Tr_ID delta_lr)
	)
	(print RWinkel)
	(setq dp_knbl (Blech.get knotenBlech dp))
	
	
	(setq delta_v_ht (Traeger.get Htrg delta_v))
  
  
  ; Nur zur Kontrolle -> wird wieder entfernt
  (if (/= delta_v_ht 0.0)
  	(progn
  		(print " > HT in delta_v verschoben")			
  		(print delta_v_ht)
  	)
  )
  (if (/= delta_v_at 0.0)
  	(progn
  		(print " > AT in delta_v verschoben")		
  		(print delta_v_at)
  	)
  )
  (if (/= delta_lr_at 0.0)
  	(progn
  		(print " > AT in delta_lr verschoben")		
  		(print delta_lr_at)
  	)
  )
  
  
  
  ; lokale Verschiebung des Windverbandes bestimmen
  (setq wv_versatz 0)
  
  
  ; ++++++++++++++++++++++++++++++++++++++++
  ; 1. Anschluss
  ; ++++++++++++++++++++++++++++++++++++++++
  
  ; Verschiebung aus delta_lr bzw. delta_v des AT ANSCHLUSS AM STEG
  (if (= (Connect.get CastaData amHtStegRechts) 1)
  	(progn
  		(if (= (Connect.get CastaData linkesEnde) 1)
  			(progn
  				(if (= RWinkel 0.0)
  					(progn
  						(if (< delta_lr_at 0.0) 	(setq at_verschiebung (- delta_lr_at)))
  						(if (>= delta_lr_at 0.0)	(setq at_verschiebung delta_lr_at))
  					)
  				)
  				(if (= RWinkel 90.0)
  					(progn
  						(if (< delta_v_at 0.0) 	(setq at_verschiebung (- delta_v_at)))
  						(if (>= delta_v_at 0.0)	(setq at_verschiebung delta_v_at))
  					)
  				)
  				(if (= RWinkel 180.0)
  					(progn
  						(if (< delta_lr_at 0.0) 	(setq at_verschiebung delta_lr_at))
  						(if (>= delta_lr_at 0.0)	(setq at_verschiebung (- delta_lr_at)))
  					)
  				)
  				(if (= RWinkel 270.0)
  					(progn
  						(if (< delta_v_at 0.0) 	(setq at_verschiebung delta_v_at))
  						(if (>= delta_v_at 0.0)	(setq at_verschiebung (- delta_v_at)))
  					)
  				)
  			)
  		)
  		(if (= (Connect.get CastaData rechtesEnde) 1)
  			(progn
  			)
  		)
  	)
  ) 
  
  (print at_verschiebung)
  
	; Absolutbetrge berechnen
	(if (< delta_lr_at 0.0) 
		(setq d_lr_at_abs (- delta_lr_at))
		(setq d_lr_at_abs delta_lr_at)
	)
	(if (< delta_v_ht 0.0) 
		(setq d_v_ht_abs (- delta_v_ht))
		(setq d_v_ht_abs delta_v_ht)
	)
	
	(print d_lr_at_abs)
	
	(setq half_kbl (* 0.5 dp_knbl))
	
	; Wenn noch kein Anschluss vorhanden, dann soll das Knotenblech an die Stelle gesetzt
	; werden, an der sich der Verbandstab befindet. Der Stab wird nachher um die halbe
	; Blechbreite verschoben.
	(if (< delta_v_ht 0.0)
		(progn
			(if (< d_lr_at_abs d_v_ht_abs)
				(setq knotenblech_soll_versatz (- d_v_ht_abs d_lr_at_abs))
				(setq knotenblech_soll_versatz (- (- d_lr_at_abs d_v_ht_abs))) 
			)
		)
		(progn
			(if (< d_lr_at_abs d_v_ht_abs)
				(setq knotenblech_soll_versatz (- (- d_v_ht_abs d_lr_at_abs)))
				(setq knotenblech_soll_versatz (- d_lr_at_abs d_v_ht_abs))
			)
		)		
	)
	(if (= delta_v_ht 0.0)
		(progn
			(if (= (Connect.get CastaData amHtStegLinks) 1)
				(progn			
					(if (= RWinkel   0.0) (setq knotenblech_soll_versatz delta_lr_at))
					(if (= RWinkel  90.0) (setq knotenblech_soll_versatz delta_v_at))
					(if (= RWinkel 180.0) (setq knotenblech_soll_versatz delta_lr_at))
					(if (= RWinkel 270.0) (setq knotenblech_soll_versatz delta_v_at))
				)
			)
			(if (= (Connect.get CastaData amHtStegRechts) 1)
				(progn			
					(if (= RWinkel   0.0) (setq knotenblech_soll_versatz (- delta_lr_at)))
					(if (= RWinkel  90.0) (setq knotenblech_soll_versatz delta_v_at))
					(if (= RWinkel 180.0) (setq knotenblech_soll_versatz delta_lr_at))
					(if (= RWinkel 270.0) (setq knotenblech_soll_versatz delta_v_at))
				)
			)
		)
	)
	
	
	(print knotenblech_soll_versatz)
	
	
	; ++++++++++++++++++++++++++++++++++++++++
  ; 2. Anschluss
  ; ++++++++++++++++++++++++++++++++++++++++
	; Wenn der Traeger bereits angeschlossen ist, mu das zweite Blech versetzt werden 
	(if (> (Connect.get CastaData anschl_anderesEnde) 0)
		(progn
			(print "TRGER IST BEREITS FIXIERT.")
			(if (< delta_v_ht 0.0)
				(progn
					
					(if (< delta_lr_at 0.0)
						(setq knotenblech_soll_versatz (- knotenblech_soll_versatz half_kbl))
						(setq knotenblech_soll_versatz (+ knotenblech_soll_versatz half_kbl))
					)
				)
				(progn
					(if (< delta_lr_at 0.0)
						(setq knotenblech_soll_versatz (+ knotenblech_soll_versatz half_kbl))
						(setq knotenblech_soll_versatz (- knotenblech_soll_versatz half_kbl))
					)
				)
			)
		)
	)
	(print knotenblech_soll_versatz)
	
  (setq xPosStz      (connect.get CastaData xPos_HT))
  (setq WnklAnschlFl (Connect.get CastaData afl_vwinkel))
  
  
  (if (= (connect.get CastaData amHtOberFlansch) 1) (progn
      (traeger.addabtl Htrg knotenBlech 0.0 0.0 _knotenblech_of_)  ;
      (if (= (connect.get CastaData linkesEnde) 1) (print "Anschluss am AT links"))
      (if (= (connect.get CastaData rechtesEnde) 1) (print "Anschluss am AT rechts"))
  ))
  (if (= (connect.get CastaData amHtUnterFlansch) 1) (progn
      (traeger.addabtl Htrg knotenBlech 0.0 0.0 _knotenblech_uf_)  ;
      (if (= (connect.get CastaData linkesEnde) 1) (print "Anschluss am AT links"))
      (if (= (connect.get CastaData rechtesEnde) 1) (print "Anschluss am AT rechts"))
  ))

  (if (= (connect.get CastaData amHtStegLinks) 1) (progn
      (traeger.addabtl Htrg knotenBlech 0.0 0.0 _knotenblech_steg_li_)  ;
      (if (= (connect.get CastaData linkesEnde) 1) (print "Anschluss am AT links"))
      (if (= (connect.get CastaData rechtesEnde) 1) (print "Anschluss am AT rechts"))
  ))
  (if (= (connect.get CastaData amHtStegRechts) 1) (progn
      (traeger.addabtl Htrg knotenBlech 0.0 0.0 _knotenblech_steg_re_)  ;
      (if (= (connect.get CastaData linkesEnde) 1) (print "Anschluss am AT links"))
      (if (= (connect.get CastaData rechtesEnde) 1) (print "Anschluss am AT rechts"))
  ))

  (setq AbtlKnBlech (traeger.get Htrg ABTeil knotenBlech))
  (Anbauteil.set  AbtlKnBlech (xpos xPosStz))

	
	;(print b_Trg)
	;(print h_Trg)
	
	(if (= RWinkel   0.0) (setq d_schr (+ (* 0.5 b_Trg) rand_abst)))
	(if (= RWinkel  90.0) (setq d_schr (+ (* 0.5 h_Trg) rand_abst)))
	(if (= RWinkel 180.0) (setq d_schr (+ (* 0.5 b_Trg) rand_abst)))
	(if (= RWinkel 270.0) (setq d_schr (+ (* 0.5 h_Trg) rand_abst)))
	
	(print d_schr)
  ; Objekt.Methode          Variable     d_Schr   l_Schrb  SchrAchsWnkl
  (Blech.knotenblechschraeg knotenBlech   d_schr      l_schr       WnklAnschlFl)
  
  (Blech.set knotenBlech (delta_lr knotenblech_soll_versatz))
 
	(print "ENDE KNOTENBLECH")
	(print "------------------------------------------------------------")
)

; ----------------------------------------------------------------------------------------
; Erzeugt das Lochbild
; ----------------------------------------------------------------------------------------
(defun createLochbild (BlechID rand_abst p_abstand_stz)
	(setq knblLochbild (Lochbild.create))
	(Connect.storeAnschlObjs CastaData knblLochbild)
	
	(Lochbild.set knblLochbild 	(lb_art 	2)
															(S_Bez 		"M16")
															(Guete		"4.6")
															(w				"0 0")
															(e				"0 0 0 0 0 0")
															(Anz_S		3)
															(dok 			0)
															(dxSKopf	20)
															(klemml		20)
															(dvhtrg		50)
	)
	
	; allg. Daten
	(setq dp_Blech 	(Blech.get BlechID dp)
				d_sch 		(Blech.get BlechID knbl_dschr)
				l_sch			(Blech.get BlechID knbl_lschr)
	)
	
	(setq t_Trg 			(Traeger.get Tr_ID t)
				s_Trg				(Traeger.get Tr_ID s)
				b_Trg				(Traeger.get Tr_ID b)
				r_winkel		(Traeger.get Tr_ID r_winkel)
				delta_lr_at	(Traeger.get Tr_ID delta_lr)
	)
	(setq delta_v_ht	(Traeger.get Htrg delta_v))
	
	; Klemmlnge
	(setq dicke_trg t_Trg)
	(setq klemml (+ dicke_trg dp_Blech))
	
	; dxSKopf Anschluss am Steg
	(if (= (Connect.get CastaData amHtStegLinks) 1)
		(progn
			(print "AM HT-STEG LINKS")
			(if (= (Connect.get CastaData linkesEnde) 1)
				(progn
					(print "AM AT LINKS")
					(if (= r_winkel   0.0) (setq dxS (* 0.5 dp_blech)))
					(if (= r_winkel  90.0) (setq dxS (+ (* 0.5 dp_blech) t_Trg)))
					(if (= r_winkel 180.0) (setq dxS (+ (* 0.5 dp_blech) s_trg)))
					(if (= r_winkel 270.0) (setq dxS (* 0.5 dp_blech)))	
				)
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(progn
					(print "AM AT RECHTS")
					(if (= r_winkel   0.0) (setq dxS (+ (* 0.5 dp_blech) s_Trg)))
					(if (= r_winkel  90.0) (setq dxS (* 0.5 dp_blech)))
					(if (= r_winkel 180.0) (setq dxS (* 0.5 dp_blech)))
					(if (= r_winkel 270.0) (setq dxS (+ (* 0.5 dp_blech) t_Trg)))					
				)
			)
		)
	)
	(if (= (Connect.get CastaData amHtStegRechts) 1)
		(progn
			(print "AM HT-STEG RECHTS")
			(if (= (Connect.get CastaData linkesEnde) 1)
				(progn
					(print "AM AT LINKS")
					(if (= r_winkel   0.0) (setq dxS (+ (* 0.5 dp_blech) s_Trg)))
					(if (= r_winkel  90.0) (setq dxS (* 0.5 dp_blech)))
					(if (= r_winkel 180.0) (setq dxS (* 0.5 dp_blech)))
					(if (= r_winkel 270.0) (setq dxS (+ (* 0.5 dp_blech) t_Trg)))	
				)
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(progn
					(print "AM AT RECHTS")
					(if (= r_winkel   0.0) (setq dxS (* 0.5 dp_blech)))
					(if (= r_winkel  90.0) (setq dxS (+ (* 0.5 dp_blech) t_Trg)))
					(if (= r_winkel 180.0) (setq dxS (+ (* 0.5 dp_blech) s_trg)))
					(if (= r_winkel 270.0) (setq dxS (* 0.5 dp_blech)))	
				)
			)
		)
	)
			
	; dxSKopf Anschluss am Flansch
	(if (= (Connect.get CastaData amHtOberflansch) 1)
		(progn
			(print "AM HT-STEG LINKS")
			(if (= (Connect.get CastaData linkesEnde) 1)
				(progn
					(print "AM AT LINKS")
					(if (= r_winkel   0.0) (setq dxS (* 0.5 dp_blech)))
					(if (= r_winkel  90.0) (setq dxS (+ (* 0.5 dp_blech) t_Trg)))
					(if (= r_winkel 180.0) (setq dxS (+ (* 0.5 dp_blech) s_trg)))
					(if (= r_winkel 270.0) (setq dxS (* 0.5 dp_blech)))	
				)
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(progn
					(print "AM AT RECHTS")
					(if (= r_winkel   0.0) (setq dxS (+ (* 0.5 dp_blech) s_Trg)))
					(if (= r_winkel  90.0) (setq dxS (* 0.5 dp_blech)))
					(if (= r_winkel 180.0) (setq dxS (* 0.5 dp_blech)))
					(if (= r_winkel 270.0) (setq dxS (+ (* 0.5 dp_blech) t_Trg)))					
				)
			)
		)
	)
	(if (= (Connect.get CastaData amHtUnterflansch) 1)
		(progn
			(print "AM HT-STEG RECHTS")
			(if (= (Connect.get CastaData linkesEnde) 1)
				(progn
					(print "AM AT LINKS")
					(if (= r_winkel   0.0) (setq dxS (+ (* 0.5 dp_blech) s_Trg)))
					(if (= r_winkel  90.0) (setq dxS (* 0.5 dp_blech)))
					(if (= r_winkel 180.0) (setq dxS (* 0.5 dp_blech)))
					(if (= r_winkel 270.0) (setq dxS (+ (* 0.5 dp_blech) t_Trg)))	
				)
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(progn
					(print "AM AT RECHTS")
					(if (= r_winkel   0.0) (setq dxS (* 0.5 dp_blech)))
					(if (= r_winkel  90.0) (setq dxS (+ (* 0.5 dp_blech) t_Trg)))
					(if (= r_winkel 180.0) (setq dxS (+ (* 0.5 dp_blech) s_trg)))
					(if (= r_winkel 270.0) (setq dxS (* 0.5 dp_blech)))	
				)
			)
		)
	)
	
	(print dxS)
	
	
		
	; Kontaktlnge zwichen AT und Knotenblech
	
	(setq afl_wnkl (Connect.get CastaData afl_vwinkel))
	(print afl_wnkl)
	(setq afl_wnkl (- afl_wnkl 90.0))
	(print afl_wnkl)
	(setq tan_afl	(tan (/ (* PI afl_wnkl) 180.0)))
	(print tan_afl)
	(if (< tan_afl 0) (setq tan_afl (- tan_afl)))
	(print tan_afl)
	(setq diff_1 (* rand_abst tan_afl))
	(print diff_1)
	(setq diff_2 (- p_abstand_stz diff_1))
	(print diff_2)
	(setq kontakt_laenge (- l_sch diff_2))
	(print kontakt_laenge)
	; e-Werte
	
	(setq e_abst (* 0.25 kontakt_laenge)) ; erstmal gleichmig verteilen 
	(print e_abst)
	
	(setq anteil_verbindung (* (* 0.5 b_Trg) tan_afl))
	(print anteil_verbindung)
	
	(setq e0 (+ anteil_verbindung p_abstand_stz e_abst))
	(print e0)
	(Lochbild.set knblLochbild 	(klemml		klemml)
															(dxSKopf	dxS)
															(e0				e0)
															(e1 			e_abst)
															(e2				e_abst)
															
	)
	(setq test1 (Lochbild.get knblLochbild dvhtrg)
				test2	(Lochbild.get knblLochbild dvatrg)
	)
	(print test1)
	(print test2)
	
	(setq AbtlKnoBl	(Traeger.get Htrg AbTeil BlechID))
	(Traeger.addabtl Htrg knblLochbild 0.0 0.0 _knblLochbild_ AbtlKnoBl)
)