; $	HT	QT(IUKF)			AF(FS)		P(EZ)
; $ 	AT	QT(U)			AF(K)			P(E)
; $	AE	V(-)			H(-)			R(-)

(defun load-modules ()
  ; Profil prfen
  (setq qsform_at (Traeger.get Tr_ID qsform))
  (print qsform_at)
  
  
  (if (= qsform_at "U") (load "mod-calc-windverband_U"))
  
  (load "mod-lochbild")
)

(defun init-connection ()

  (print "*clear*")
  (print "********************************************************************")
  (print "in init-connection - stz_Windverb_U-Prof");
   
  (connect.ShowAttributes CastaData)
 
  
  (setq b_at (Traeger.get Tr_ID b))
  
  (setq l_schr 0);200)
  (setq parallel_abstand_stz 30)
	(setq parallel_abstand_trgEnde 30)
  (setq rand_abst (* 0.5 b_at))
	
	(setq STD 1)
	
	(if (= qsform_at "U") (uProf))
	
)

; ----------------------------------------------------------------------------------------
(defun uProf ()
	(if (= (Connect.get CastaData vatr-lhtr) 0) (progn
		(alertBox "Die Orientierung des Anschlusstrgers passt nicht."  "WRN_AT_OrientationNotSuitable")
	    )
	    (progn
		(if (= (Connect.get CastaData amHtSteg) 1) (progn
			(if (= (Connect.get CastaData vatr-vhtr) 0)
				(progn
					(init-windverband)
					; CALLBACKS
					(Blech.set knotenBlech 	(formFkt "cb_knotenBlech"))
				)
			)
		))
		(if (= (Connect.get CastaData amHtFlansch) 1) (progn
			(print "amHtFlansch ... ")
			(if (= (Connect.get CastaData vatr-shtr) 0)
				(progn
					(print "vatr-shtr == 0 ... ")
					(init-windverband)
					; CALLBACKS
					(Blech.set knotenBlech 	(formFkt "cb_knotenBlech"))
				)
			)
		))
	))

)
; ----------------------------------------------------------------------------------------



; ----------------------------------------------------------------------------------------






; ========================================================================================
; CALLBACK-FUNKTIONEN
; ========================================================================================

; ----------------------------------------------------------------------------------------
; Callback fr Knotenblech am HT
; ----------------------------------------------------------------------------------------
(defun cb_knotenBlech (zp)
	(print "in Callback-Funktion cb_knotenBlech")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dpAlt (Blech.get knotenBlech dp))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq dpNeu (Blech.get knotenBlech dp))
	    
	    (print dpAlt) (print dpNeu)
	    
	    (if (/= dpAlt dpNeu) (progn
		(setq dpDiff (- dpNeu dpAlt))
		(setq	alteKlemml 	(Lochbild.get knblLochbild Klemml)
			altesDxSKopf	(Lochbild.get knblLochbild dxSKopf)
		)
					
		(setq delta_lr_Alt 	(Blech.get knotenBlech delta_lr))
				
		(setq delta_v_at_alt	(Traeger.get Tr_ID delta_v)
			delta_lr_at_alt	(Traeger.get Tr_ID delta_lr)
		)
		(print delta_v_at_alt)
		(print delta_lr_at_alt)
					
		(setq qsform_at (Traeger.get Tr_ID qsform))
					
					
		; U-Profil
		; --------------------------------------
		(print "U-Profil")
		(Lochbild.set knblLochbild 	(Klemml 	(+ alteKlemml dpDiff)))
		(if (= (Connect.get CastaData vatr-lhtr) 1)
		    (Lochbild.set knblLochbild 	(dxsKopf	(+ altesDxSKopf dpDiff)))
		)
						
		(Connect.showAttributes CastaData)
					
		; HT STEG
		; ----------------------------------
		(if (= (Connect.get CastaData amHtSteg) 1) (progn
			(if (= (Connect.get CastaData vatr-vhtr)  1) (progn
				(if (= (Connect.get CastaData satr-lhtr) -1)	(Blech.set knotenBlech (delta_lr (+ delta_lr_alt (* 0.5 dpDiff)))))
				(if (= (Connect.get CastaData satr-lhtr)  1)	(Blech.set knotenBlech (delta_lr (+ delta_lr_alt (* 0.5 dpDiff)))))
				
			))
			(if (= (Connect.get CastaData vatr-vhtr) -1) (progn
				(if (= (Connect.get CastaData satr-lhtr) -1)	(Blech.set knotenBlech (delta_lr (- delta_lr_alt (* 0.5 dpDiff)))))
				(if (= (Connect.get CastaData satr-lhtr)  1)	(Blech.set knotenBlech (delta_lr (- delta_lr_alt (* 0.5 dpDiff)))))
			))
			(if (= (Connect.get CastaData satr-vhtr)  1) (progn
				(if (= (Connect.get CastaData vatr-lhtr) -1)	(Blech.set knotenBlech (delta_lr (- delta_lr_alt (* 0.5 dpDiff)))))
				(if (= (Connect.get CastaData vatr-lhtr)  1)	(Blech.set knotenBlech (delta_lr (- delta_lr_alt (* 0.5 dpDiff)))))
			))
			(if (= (Connect.get CastaData satr-vhtr) -1) (progn
				(if (= (Connect.get CastaData vatr-lhtr) -1)	(Blech.set knotenBlech (delta_lr (+ delta_lr_alt (* 0.5 dpDiff)))))
				(if (= (Connect.get CastaData vatr-lhtr)  1)	(Blech.set knotenBlech (delta_lr (+ delta_lr_alt (* 0.5 dpDiff)))))
			))
		))

						
		; HT FLANSCH
		; ----------------------------------
		(if (= (Connect.get CastaData amHtFlansch) 1) (progn
;			Das folgende kann nicht eintreten - bzw. ist von dieser Variante nicht vorgesehen
;			und zwar satr-lhtr (seitlich AT zu lngs HT)
;			(if (= (Connect.get CastaData vatr-shtr)  1) (progn
;				(if (= (Connect.get CastaData satr-lhtr) -1)	(Blech.set knotenBlech (delta_lr (+ delta_lr_alt (* 0.5 dpDiff)))))
;				(if (= (Connect.get CastaData satr-lhtr)  1)	(Blech.set knotenBlech (delta_lr (+ delta_lr_alt (* 0.5 dpDiff)))))
;			))
			(if (= (Connect.get CastaData satr-shtr)  1) (progn
				(if (= (Connect.get CastaData vatr-lhtr) -1)	(Blech.set knotenBlech (delta_lr (- delta_lr_alt (* 0.5 dpDiff)))))
				(if (= (Connect.get CastaData vatr-lhtr)  1)	(Blech.set knotenBlech (delta_lr (- delta_lr_alt (* 0.5 dpDiff)))))
			))
			(if (= (Connect.get CastaData satr-shtr) -1) (progn
				(if (= (Connect.get CastaData vatr-lhtr) -1) 	(Blech.set	knotenBlech	(delta_lr  (+ delta_lr_alt (* 0.5 dpDiff)))))
				(if (= (Connect.get CastaData vatr-lhtr)  1)	(Blech.set knotenBlech (delta_lr (+ delta_lr_alt (* 0.5 dpDiff)))))
			))
		))
	))
    ))
)







