; $	HT	QT(IU)		AF(FS)		P(EZ)
; $ 	AT	QT(IU)		AF(K)		P(E)
; $	AE	V(90)			H(90)		R(0)
	
(defun load-modules ()
	(print "Anschluss:")
	(if (= (Connect.get CastaData amHtOberflansch) 1)
		(progn
			(print "am HT-Oberflansch")
			(load "mod-endinit-uz-stzflansch-abstand")
		)
	)
	(if (= (Connect.get CastaData amHtUnterflansch) 1)
		(progn
			(print "am HT-Unterflansch")
			(load "mod-endinit-uz-stzflansch-abstand")
		) 
	)
	(if (= (Connect.get CastaData amHtStegLinks) 1)
		(progn
			(print "am HT Steg links")
			(load "mod-endinit-uz-stzsteg") 
			(load "mod-auskl-steifen-amSteg")
		)
	)
	(if (= (Connect.get CastaData amHtStegRechts) 1)
		(progn
			(print "am HT Steg rechts")
			(load "mod-endinit-uz-stzsteg")
			(load "mod-auskl-steifen-amSteg")
		) 
	)
  (load "mod-lochbild")
)




(defun init-connection ()
	
	(setq LB_DEBUG 0)
	
	;(connect.showattributes CastaData)
	
	(checkPosition)
	
	(if (= isInside 1)
		(progn
			(print "in init-connection uz_an_stz mit Fahne .........................")
			(if (= (Connect.get CastaData amHtSteg) 1)
		  	(init-traegerenden 10)	; hier werden die Traegerenden gestutzt
		  )
		  (if (= (Connect.get CastaData amHtFlansch) 1)
		  	(init-traegerenden)	; hier werden die Traegerenden gestutzt
		  )
		  (print "nach init-traegerenden")
		  
		  (if (= (Connect.get CastaData amHtSteg) 1)
		  	(progn		  
		  		(checkForSteifen)
				  (if (= STEIFE_VORHANDEN 1)
				  	(alertBox "Es ist bereits ein Anschluss mit Anbauteilen am HT-Steg vorhanden. Die Anschlsse knnten sich berschneiden."   "WRN_WebConnection_Overlapping_AP")
				  )
				)
			)
		  (setConnection)
		)
		(progn
			(alertBox "Anschluss nicht mglich!" "Connection_Not_Possible")
		)
	)
  
)



(defun setConnection ()

	(setq bFahnenbl (blech.create))
	(setq knagge	(blech.create))
	(setq lchbAtrgSteg (Lochbild.create))
		
	(Connect.storeAnschlObjs CastaData bFahnenbl lchbAtrgSteg knagge)
	
	(print "Fahnenblech erzeugt")
  (Blech.set bFahnenbl (dp 10) (hp 200) (bp 110) (dOK 0))
	(print "Default Blechdaten")
  (setq XPos 		(Connect.get CastaData XPos_HT))
  (setq XPos_at (Connect.get CastaData XPos_AT))
  (print XPos)
  
  (setq abstzumSteg 10)
  
  ; Fahnenblech-Anbauteil dem HT hinzufgen
  ; ----------------------------------------------
  
  ; Anschlsse am Flansch des Haupttrgers
  (if (= (Connect.get CastaData amHtOberflansch) 1) 
  	(traeger.addabtl hTrg bFahnenbl XPos 0.0 _fahnenblech_of_)	
  )
  (if (= (Connect.get CastaData amHtUnterflansch) 1) 
  	(traeger.addabtl hTrg bFahnenbl XPos 0.0 _fahnenblech_uf_)	
  )
  
  ; Anschlsse am Steg des Haupttrgers
  (if (= (Connect.get CastaData amHtStegLinks) 1) 
 		(traeger.addabtl hTrg bFahnenbl XPos 0.0 _fahnenblech_steg_li_)
  )
  (if (= (Connect.get CastaData amHtStegRechts) 1) 
  	(traeger.addabtl hTrg bFahnenbl XPos 0.0 _fahnenblech_steg_re_)
  )

	; Blechdaten berechnen
  (calcAndSetBlechdaten bFahnenbl)

	; Anbauteil Fahne
	(setAnbauteilFahne bFahnenbl)

	; Lochbild-Anbauteil dem HT hinzufgen
	(setq AbtlFahnenBl	(Traeger.get Htrg AbTeil bFahnenbl))
	(Traeger.addabtl Htrg lchbAtrgSteg XPos 180.0 _fahnblLochbild_ AbtlFahnenBl)
	
	
	(if (= (Connect.get CastaData LinkesEnde) 1)
		(progn			
			(calcAndSetLochbildDaten lchbAtrgSteg bFahnenbl TrLinks)
			(traeger.addabtl tr_id lchbAtrgSteg 0.0 0.0 _WnklSteglochbildLinks_)
		)
	)
	(if (= (Connect.get CastaData RechtesEnde) 1)
		(progn			
			(calcAndSetLochbildDaten lchbAtrgSteg bFahnenbl TrRechts)
			(traeger.addabtl tr_id lchbAtrgSteg xPos_at 0.0 _WnklSteglochbildRechts_)
		)
	)
   
  ; Knagge erzeugen 
	(createKnagge knagge)
	
	
	(setLochbild lchbAtrgSteg)


	; CALLBACKS
	(Blech.set knagge 	(formFkt "cb_knagge"))
	(Blech.set bFahnenbl 	(formFkt "cb_bFahnenbl"))
	(Lochbild.set lchbAtrgSteg (formFkt "cb_FahnenLchb_$lb"))
)




; ========================================================================================
; CALLBACK-FUNKTIONEN
; ========================================================================================

; --------------------------------------------------------------------
; Calback bei Knaggennderung
; --------------------------------------------------------------------
(defun cb_knagge (zp)
	(print "in Callback-Funktion cb_knagge")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq hpAlt  (Blech.get knagge hp))
	    (setq dOKAlt (Blech.get knagge dOK))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
		(setq hpNeu  (Blech.get knagge hp))
	    (setq dOKNeu (Blech.get knagge dOK))
	    
	    (print hpAlt) (print hpNeu)

	    (if (/= dOKAlt dOKNeu) (progn
			(if (= (Connect.get CastaData CopyMode) 1) (progn
				(Blech.set knagge (dOK dOKAlt))
			))
		))
	    
	    (if (/= hpAlt hpNeu) (progn
			(setq hpDiff (- hpNeu hpAlt))
			(Blech.set knagge (dOK (- dOKAlt (* 0.5 hpDiff))))
	    ))
	))
)

; ----------------------------------------------------------------------------------------
; Callback fr Fahne am HT
; ----------------------------------------------------------------------------------------
(defun cb_bFahnenbl (zp)
	(print "in Callback-Funktion cb_bFahnenbl")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dpAlt 	(Blech.get bFahnenbl dp))
	    (setq hpAlt 	(Blech.get bFahnenbl hp))
	    (setq dokAlt 	(Blech.get bFahnenbl dok))
	    (print "*clear*")
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
		(setq dpNeu (Blech.get bFahnenbl dp))
		(setq hpNeu (Blech.get bFahnenbl hp))
		(setq dokNeu (Blech.get bFahnenbl dok))
		
		(print dpAlt) (print dpNeu)
		(print hpAlt) (print hpNeu)
		(print dokAlt) (print dokNeu)
		(print "--------------------------------------")
		
		; nderung der dOK im CopyMode nicht erwnscht
	    (if (/= dOKAlt dOKNeu) (progn
			(if (= (Connect.get CastaData CopyMode) 1) (progn
				(Blech.set bFahnenbl (dOK dOKAlt))
			))
		))

		; nderung der Blechdicke
		(if (/= dpAlt dpNeu) (progn
			(setq dpDiff (- dpNeu dpAlt))
			
			(setq qsform_at	(Traeger.get Tr_ID qsform))
			
			(setq alteKlemml 	(Lochbild.get lchbAtrgSteg Klemml)
						dxs_alt			(Lochbild.get lchbAtrgSteg dxskopf)
			)
			
			(setq delta_lr_blech_alt (Blech.get bFahnenbl delta_lr))
			(print delta_lr_blech_alt)
			
			(setq klemml_neu	(+ alteKlemml dpDiff))
			
			(setq dxs_neu (+ dxs_alt (* 0.5 dpDiff)))
			
			(if (= qsform_at "I")
				(setq delta_lr_blech_neu (+ delta_lr_blech_alt (* 0.5 dpDiff)))
			)
			(if (= qsform_at "U")
				(progn
					
					(if (= (Connect.get CastaData amHtSteg) 1)
						(progn
							(if (= (Connect.get CastaData satr-vhtr)  1)	
								(setq delta_lr_blech_neu (+ delta_lr_blech_alt (* 0.5 dpDiff)))
							)
							(if (= (Connect.get CastaData satr-vhtr) -1)	
								(setq delta_lr_blech_neu (- delta_lr_blech_alt (* 0.5 dpDiff)))
							)
						)
					)
						(if (= (Connect.get CastaData amHtFlansch) 1)
						(progn
							(if (= (Connect.get CastaData satr-shtr)  1)	
								(setq delta_lr_blech_neu (+ delta_lr_blech_alt (* 0.5 dpDiff)))
							)
							(if (= (Connect.get CastaData satr-shtr) -1)	
								(setq delta_lr_blech_neu (- delta_lr_blech_alt (* 0.5 dpDiff)))
							)
						)
					)
					
				)
			)
			
			(print delta_lr_blech_neu)		  	
			
			(Blech.set bFahnenbl (delta_lr delta_lr_blech_neu))
			              
			(Lochbild.set lchbAtrgSteg 	(klemml klemml_neu)
							(dxskopf dxs_neu)
			)    
			(setq abtl_lb_ht (Traeger.get Htrg AbTeil lchbAtrgSteg))
			(setq delta_sx_abtl_ht_neu delta_lr_blech_neu )
			(Anbauteil.set abtl_lb_ht (delta_sx delta_sx_abtl_ht_neu))
		))
		    
		; nderung der Blechhhe
		(if (/= hpAlt hpNeu) (progn
		  (setq hpDiff (- hpNeu hpAlt))
		))
		
		; Verschiebung des Bleches in HT-Lngsrichtung
		(if (/= dokAlt dokNeu) (progn
			(setq dokDiff (- dokNeu dokAlt))
		))
	))
)

(defun cb_FahnenLchb_$lb (zp)
	(if (= (Connect.get CastaData CopyMode) 1) (progn
		(if (= zp 0) (progn
			(setq e0_alt (Lochbild.get lchbAtrgSteg e0))
		))
		(if (= zp 1) (progn
			(Lochbild.set lchbAtrgSteg (e0 e0_alt))
		))
	))
)


; ------------------------------------------------------------------------
; Erzeugt die Lochbilder
; ------------------------------------------------------------------------
(defun setLochbild (LOCHB_ID)
	
	(setq h_ht				(Traeger.get Htrg h)
				s_ht				(Traeger.get Htrg s)
				delta_v_ht 	(Traeger.get Htrg delta_v)
	)
	
	(setq delta_v_at	(Traeger.get Tr_ID delta_v)
				hc_at				(Traeger.get Tr_ID hc)
				t_at				(Traeger.get Tr_ID t)
				r_at				(Traeger.get Tr_ID r)
				h_at				(Traeger.get Tr_ID h)
	)
	
	(setq xPos_ht 		(Connect.get CastaData xPos_ht))
	
	(setq lb_ht_abtl (Traeger.get Htrg Abteil LOCHB_ID))
	(setq lb_at_abtl (Traeger.get Tr_ID Abteil LOCHB_ID))
	
	
	; Anbauteil HT
	; ----------------------------------------------
	
	; Positionieren (an AT)
	(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_v_abtl_ht (- (* 0.5 h_at))))
	(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_v_abtl_ht (- (* 0.5 h_at))))
	
	(print delta_v_abtl_ht)
	
	; Anteil delta_v AT
	(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_v_abtl_ht (+ delta_v_abtl_ht delta_v_at)))
	(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_v_abtl_ht (+ delta_v_abtl_ht delta_v_at)))
	
	
	(Anbauteil.set lb_ht_abtl (delta_v delta_v_abtl_ht))
	
		
		
	; Anbauteil AT
	; ----------------------------------------------
	;(setq e_diff (- (+ (* hc_at 0.25) t_at r_at) (* 0.5 h_fahne)))
	
	(if (= (Connect.get CastaData amHtUnterFlansch) 1) 	(setq delta_lr_abtl_at (+ (* 0.5 h_ht) delta_v_ht)))
	(if (= (Connect.get CastaData amHtOberFlansch) 1) 	(setq delta_lr_abtl_at (- (* 0.5 h_ht) delta_v_ht)))
	
	(if (= (Connect.get CastaData amHtStegLinks) 1) 	(setq delta_lr_abtl_at (- (* 0.5 s_ht) delta_lr_ht)))
	(if (= (Connect.get CastaData amHtStegRechts) 1) 	(setq delta_lr_abtl_at (+ (* 0.5 s_ht) delta_lr_ht)))
	
	(Anbauteil.set lb_at_abtl ;(delta_v 		e_diff)
														(delta_lr 	delta_lr_abtl_at)
	)
	
	; Winkel Anbauteil HT
	; ----------------------------------------------
	(setq winkel_abtl_ht 0.0)
	
	(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq winkel_abtl_ht   0.0))
	(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq winkel_abtl_ht 180.0))
	
	(Anbauteil.set lb_ht_abtl (winkel winkel_abtl_ht))
	
	
	
	(if (= LB_DEBUG 1)
		(progn
			(Anbauteil.set lb_ht_abtl (Master 1))
			(Anbauteil.set lb_at_abtl (Master 1))
		)
		(progn
			(Anbauteil.set lb_ht_abtl (Master 1))
			(Anbauteil.set lb_at_abtl (Master 0))
		)
	)
	
)

; ------------------------------------------------------------------------
; Erzeugt ein Fahnenblech
; ------------------------------------------------------------------------
(defun calcAndSetBlechdaten (fahnenblech)
	(print "------------------------------------------------------------")
	(print "BERECHNE BLECHDATEN")
	
	(setq hc_trg 				(Traeger.get Tr_ID hc)
				delta_v_trg 	(Traeger.get Tr_ID delta_v)
				delta_lr_trg	(Traeger.get Tr_ID delta_lr)
				rwnkl_trg			(Traeger.get Tr_ID r_winkel)
				tSteg 				(Traeger.get Tr_ID s)
				qsform				(Traeger.get Tr_ID qsform)
	)
	(print delta_v_trg)
	(print delta_lr_trg)
	
	(setq s_htrg 				(Traeger.get Htrg s)
				h_ht					(Traeger.get Htrg h)
				delta_v_htrg	(Traeger.get Htrg delta_v)
				delta_lr_htrg	(Traeger.get Htrg delta_lr)
	)
	
	(Blech.set fahnenblech 	(dp 				s_htrg))
	
	(setq afl_winkel		(Connect.get CastaData afl_vwinkel))
	
	(setq tanAfl (tan (/ (* PI afl_winkel) 180.0)))
	
	; Blechdicke
	; ----------------------------------------------
	(setq dp (runde tSteg auf 5))
	
	; Schraubenbezeichnung aus min. Blechdicke ("mod-lochbild")
	(if (< dp tSteg)
		(setq min_bl dp)
		(setq min_bl tSteg)
	)
	(calcSchraube min_bl) 	; -> S_Bez
	(print s_bez)
	; Schraubenbezeichnung den Lochbildern zuweisen
	(Lochbild.set lchbAtrgSteg (S_Bez S_Bez))
	
	; default Rand- und Lochabstnde aus Schraubendurchmesser bestimmen
	(calcMinRandLochAbst lchbAtrgSteg)	; -> e_min_rund, e1_min_rund, min_h
	
	
	
	(if (= rwnkl_trg 180.0) (setq delta_v_trg (- delta_v_trg)))
	
	(print delta_lr_trg)
	(print delta_lr_htrg)
	
	
	(setq delta_lr_soll (* 0.5 (+ dp tSteg))) 
	
	(if (= qsform "U")
  	(progn
  		(setq delta_lr_soll (+ (* 0.5 dp) tSteg))
	  	(if (= (Connect.get CastaData amHtFlansch) 1)
	  		(progn
		  		(if (= (Connect.get CastaData satr-shtr)  1)	(setq delta_lr_soll delta_lr_soll))
		  		(if (= (Connect.get CastaData satr-shtr) -1)	(setq delta_lr_soll (- delta_lr_soll)))
		  	)
		  )
		  (if (= (Connect.get CastaData amHtSteg) 1)
  		(progn
	  		(if (= (Connect.get CastaData satr-vhtr)  1)	(setq delta_lr_soll delta_lr_soll))
	  		(if (= (Connect.get CastaData satr-vhtr) -1)	(setq delta_lr_soll (- delta_lr_soll)))
	  	)
	  )
  	)
  )
	
	(print delta_lr_soll)
  	
  ; Verschiebung des AT in delta_lr-Richtung	
  (if (/= delta_lr_trg 0.0)
  	(progn
	 		(print "Verschiebung des AT in delta_lr-Richtung") 
	 		(print delta_lr_soll)  
			(if (= (Connect.get CastaData vatr-lhtr)  1)
				(progn
					(if (= (Connect.get CastaData satr-shtr)  1)	(setq delta_lr_soll (- delta_lr_soll delta_lr_trg)))
					(if (= (Connect.get CastaData satr-shtr) -1)	(setq delta_lr_soll (+ delta_lr_soll delta_lr_trg)))
					(if (= (Connect.get CastaData satr-vhtr)  1)	(setq delta_lr_soll (- delta_lr_soll delta_lr_trg)))
					(if (= (Connect.get CastaData satr-vhtr) -1)	(setq delta_lr_soll (+ delta_lr_soll delta_lr_trg)))
				)
			)
			(if (= (Connect.get CastaData vatr-lhtr) -1)
				(progn
					(if (= (Connect.get CastaData satr-shtr)  1)	(setq delta_lr_soll (+ delta_lr_soll delta_lr_trg)))
					(if (= (Connect.get CastaData satr-shtr) -1)	(setq delta_lr_soll (- delta_lr_soll delta_lr_trg)))
					(if (= (Connect.get CastaData satr-vhtr)  1)	(setq delta_lr_soll (+ delta_lr_soll delta_lr_trg)))
					(if (= (Connect.get CastaData satr-vhtr) -1)	(setq delta_lr_soll (- delta_lr_soll delta_lr_trg)))
				)
			)
			(print delta_lr_soll)  
  	)
  )
  
  ; Verschiebung des HT in delta_lr-Richtung	
  (if (/= delta_lr_htrg 0.0)
  	(progn
  		(print "Verschiebung des HT in delta_lr-Richtung") 
	 		(print delta_lr_soll)
		 	(if (= (Connect.get CastaData amHtFlansch) 1)
		 		(progn
		 			(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_lr_soll (- delta_lr_soll delta_lr_htrg)))
		 			(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_lr_soll (+ delta_lr_soll delta_lr_htrg)))
		 		)
		 	)
		  (print delta_lr_soll)
  	)
  ) 
  
  
  ; Verschiebung des HT in delta_v-Richtung
  (print "Verschiebung des HT in delta_v-Richtung") 
	(print delta_lr_soll)
	(if (= (Connect.get CastaData amHtSteg) 1)
		(progn
		 	(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_lr_soll (- delta_lr_soll delta_v_htrg)))
		 	(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_lr_soll (+ delta_lr_soll delta_v_htrg)))
		)
	)
	(print delta_lr_soll)
  
  
  
  ;Korrektur bei Rotation des AT
	(if (/= rwnkl_trg 0.0)
		(progn
	(print "--------------- Korrektur ----------------------")
	(print delta_lr_htrg)
	(print rwnkl_trg)
	
		
	(setq tanRW (tan (/ (* PI rwnkl_trg) 180.0)))
	(setq cosRW (cos (/ (* PI rwnkl_trg) 180.0)))
	
	(print tanRW)
	(print cosRW)
	
	(setq help_1 (* 0.5 (+ tSteg dp)))
	(print help_1)
	
	(setq help_2 (/ delta_lr_htrg cosRW))
	(print help_2)
	
	(setq xPos_korr (* delta_lr_htrg tanRW))
	(print xPos_korr)
	
	; delta_lr korregieren
	(if (/= delta_lr_htrg 0.0)
		(progn
			(if (/= delta_lr_trg 0.0)
				(progn
					(setq delta_lr_soll (- (- help_2 help_1)))
					(if (= (Connect.get CastaData amHtUnterflansch) 1)
						(progn
							(if (= (Connect.get CastaData linkesEnde) 1)
								(progn
									(setq delta_lr_soll (+ delta_lr_soll delta_lr_trg))
									(print delta_lr_soll)
								)
							)
							(if (= (Connect.get CastaData rechtesEnde) 1)
								(progn
									(setq delta_lr_soll (- delta_lr_soll delta_lr_trg))
									(print delta_lr_soll)
								)
							)
						)
					)
					(if (= (Connect.get CastaData amHtOberflansch) 1)
						(progn
							(if (= (Connect.get CastaData linkesEnde) 1)
								(progn
									(setq delta_lr_soll (- delta_lr_soll delta_lr_trg))
									(print delta_lr_soll)
								)
							)
							(if (= (Connect.get CastaData rechtesEnde) 1)
								(progn
									(setq delta_lr_soll (+ delta_lr_soll delta_lr_trg))
									(print delta_lr_soll)
								)
							)
						)
					)
				)
				(progn
					(setq delta_lr_soll (- (- help_2 help_1)))
				)
			)
		)
	)
					
				
	;xPos korregieren	
	(if (= (Connect.get CastaData amHtUnterflansch) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(progn
					(setq xPos (+ xPos xPos_korr))
				  (print xPos)
				)
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(progn
					(setq xPos (- xPos xPos_korr))
				  (print xPos)
				)
			)
		)
	)
	
	(if (= (Connect.get CastaData amHtOberflansch) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(progn
					(setq xPos (- xPos xPos_korr))
				  (print xPos)
				)
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(progn
					(setq xPos (+ xPos xPos_korr))
				  (print xPos)
				)
			)
		)
	)
  	
  (if (= (Connect.get CastaData amHtFlansch) 1)
  	(progn
		  ;Anteil Neigung
		  (if (= tanAfl 0) (setq tanAfl 1.0))
		  (if (< tanAfl 0.0000001) (if (> tanAfl -0.0000001) (setq tanAfl 1.0)))

		  (setq anteilNeigung (/ (+ (* h_ht 0.5) abstzumSteg) tanAfl))
			(print anteilNeigung)
			(if (= (Connect.get CastaData vatr-lhtr) 1)
				(setq xPos (+ xPos anteilNeigung))
			)
			(if (= (Connect.get CastaData vatr-lhtr) -1)
				(setq xPos (+ xPos anteilNeigung))
			)
		)
	)
	(if (= (Connect.get CastaData amHtSteg) 1)
  	(progn
		  ;Anteil Neigung
		  (if (= tanAfl 0) (setq tanAfl 1.0))
		  (if (< tanAfl 0.0000001) (if (> tanAfl -0.0000001) (setq tanAfl 1.0)))

		  (setq anteilNeigung (/ (+ (* s_htrg 0.5) abstzumSteg) tanAfl))
			(print anteilNeigung)
			(if (= (Connect.get CastaData vatr-lhtr) 1)
				(setq xPos (+ xPos anteilNeigung))
			)
			(if (= (Connect.get CastaData vatr-lhtr) -1)
				(setq xPos (+ xPos anteilNeigung))
			)
		)
	)
  	
  )
)
 ; Korrektur ROTATION ENDE 	
  (print delta_lr_soll)	
  	
  (setq abTeil_fahne (Traeger.get Htrg abteil bFahnenbl))
	
	
	
	(if (= (Connect.get CastaData amHtUnterflansch) 1)
		(progn
			(if (= (Connect.get CastaData LinkesEnde) 1)
				(progn	
					(Anbauteil.set abTeil_fahne (winkel  rwnkl_trg)
																			(xPos			xPos)
					)
				)
			)
			(if (= (Connect.get CastaData RechtesEnde) 1)
				(progn
					(Anbauteil.set abTeil_fahne (winkel  (- 360.0 rwnkl_trg))
																			(xPos			xPos)
					)
				)
			)	
		)
	)
  (if (= (Connect.get CastaData amHtOberflansch) 1)
		(progn
			(if (= (Connect.get CastaData LinkesEnde) 1)
				(progn	
					(Anbauteil.set abTeil_fahne (winkel  (- rwnkl_trg))
																			(xPos			xPos)
					)
				)
			)
			(if (= (Connect.get CastaData RechtesEnde) 1)
				(progn
					(Anbauteil.set abTeil_fahne (winkel  (- (- 360.0 rwnkl_trg)))
																			(xPos			xPos)
					)
				)
			)	
		)
	)
  
  (setq hp_fahne (* 0.5 hc_trg))
  
  (print hp_fahne)
  
  (if (= (Connect.get CastaData vatr-lhtr) -1)
  	(progn
  		(setq dok_fahne (- (* 0.5 hp_fahne)))
  		;(setq dok_fahne (+ dok_fahne delta_v_trg))
  	)
  )
  (if (= (Connect.get CastaData vatr-lhtr) 1)
  	(progn
  		(setq dok_fahne (- (* 0.5 hp_fahne)))
  		;(setq dok_fahne (- dok_fahne delta_v_trg))
  	)
  )
  
  
  
	; BLECHDATEN:
	; -----------
	(Blech.set fahnenblech 	(hp 				hp_fahne) 
													(dok 				dok_fahne) 
													(delta_lr 	delta_lr_soll)
	)
	
	
	(print "------------------------------------------------------------")
)



(defun setAnbauteilFahne (FAHNE)
	(print ">-----------------------------------------------------------")
	(print "SETZE ANBAUTEIL FAHNE")
	(setq abtl_fahne (Traeger.get Htrg AbTeil FAHNE))
	
	(setq delta_v_at	(Traeger.get Tr_ID delta_v))
	
	(setq delta_v_abtl_fahne 0.0)
	
	
  
  (if (= (Connect.get CastaData vatr-lhtr) -1)
  	(progn
  		
  		(setq delta_v_abtl_fahne (+ delta_v_abtl_fahne delta_v_at))
  	)
  )
  (if (= (Connect.get CastaData vatr-lhtr) 1)
  	(progn
  		
  		(setq delta_v_abtl_fahne (+ delta_v_abtl_fahne delta_v_at))
  	)
  )
	
	(print delta_v_abtl_fahne)
	
	
	(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq winkel_fahne   0.0)	)
	(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq winkel_fahne 180.0)	)
	
	
	(Anbauteil.set abtl_fahne (delta_v 	delta_v_abtl_fahne)
														(winkel		winkel_fahne)
	)
	(print "<-----------------------------------------------------------")
)



; ----------------------------------------------------------------------
; Berechnet die Lochbilddaten
; ----------------------------------------------------------------------
(defun calcAndSetLochbildDaten (Lchb_ID BlechID TrgEnde)
	(Lochbild.set Lchb_ID	(Anz_S    1)
												(Guete   "4.6")
	)
	
	(setq h_trg 			(Traeger.get Tr_ID h)
				rwinkel_at	(Traeger.get Tr_ID r_winkel)
				hc_at				(Traeger.get Tr_ID hc)
				t_at				(Traeger.get Tr_ID t)
				r_at				(Traeger.get Tr_ID t)
				delta_v_at	(Traeger.get Tr_ID delta_v)
	)
	
	(setq s_htrg				(Traeger.get Htrg s)
				delta_lr_htrg	(Traeger.get Htrg delta_lr)
				delta_v_htrg	(Traeger.get Htrg delta_v)
				h_htrg				(Traeger.get Htrg h)
	)
	
	(setq trg_delta_l (TrEnde.get TrgEnde delta_l))
		
		
	; min. Loch- u. Randabstnde
	(calcMinRandLochAbst Lchb_ID)
	
	(if (= (Connect.get CastaData amHTSteg) 1)
		(setq abst_lchb_steg (+ abstZumSteg e_min))
	)
	(if (= (Connect.get CastaData amHTFlansch) 1)
		(setq abst_lchb_steg (+ abstZumSteg e_min))
	)
	
	
	(setq w0 abst_lchb_steg)
	(print abst_lchb_steg)
	(print delta_lr_htrg)
	
(if (= 1 2) (progn	
	
	(if (= (Connect.get CastaData amHtStegLinks) 1)
		(progn
			(if (< delta_lr_htrg abst_lchb_steg)
				(setq w0_rund (runde w0 auf 5))
				(setq w0_rund (runde w0 ab 5))
			)
		)
	)
	(if (= (Connect.get CastaData amHtStegRechts) 1)
		(progn
			(if (< delta_lr_htrg abst_lchb_steg)
				(setq w0_rund (runde w0 ab 5))
				(setq w0_rund (runde w0 auf 5))
			)
		)
	)
	(if (= (Connect.get CastaData amHtUnterflansch) 1)
		(progn
			(if (< delta_v_htrg abst_lchb_steg)
				(setq w0_rund (runde w0 ab 5))
				(setq w0_rund (runde w0 auf 5))
			)
		)
	) 
	(if (= (Connect.get CastaData amHtOberflansch) 1)
		(progn
			(if (< delta_v_htrg abst_lchb_steg)
				(setq w0_rund (runde w0 ab 5))
				(setq w0_rund (runde w0 auf 5))
			)
		)
	)

))	


	(setq w0_rund (runde w0 auf 5))
	(print w0)
	(print w0_rund)
	
	
	(setq hp_blech 	(Blech.get BlechID hp)
				dok_blech	(Blech.get BlechID dok)
	)
	(print hp_blech)
	(print dok_blech)
		
	; Klemmlnge
	(setq dp_blech 	(Blech.get BlechID dp))
	(setq s_trg			(Traeger.get Tr_ID s))
	
	; Schraubenkopf
	(calcDxSKopf s_trg dp_blech)
	
	; Korregiere Fahnenblech
	(Blech.set BlechID 	(bp (+ (* 2.0 e_min_rund) abstZumSteg))
											(hp (* 2.0 e_min_rund))
	) 
	
	(setq h_fahne (Blech.get BlechID hp))
	(print h_fahne)
	
	(setq hp_blech_Diff (- hp_blech h_fahne))
	(print hp_blech_Diff)
	
	(setq abtl_lochbild (Traeger.get Htrg AbTeil Lchb_ID))
	
	(setq delta_v_abtl_alt (Anbauteil.get abtl_lochbild delta_v))
	(print delta_v_abtl_alt)
	
	(setq delta_v_abtl_neu (+ delta_v_abtl_alt (* 0.5 hp_blech_Diff)))
	(print delta_v_abtl_neu)
	
	(Anbauteil.set abtl_lochbild (delta_v delta_v_abtl_neu))
	
	(setq abtl_fahne (Traeger.get Htrg abteil BlechID))
	(setq delta_v_abtl_fahne (Anbauteil.get abtl_fahne delta_v))
	
	(print delta_v_abtl_fahne)
	(print dok_blech)
	
	(if (< dok_blech 0.0)
		(setq dok_blech (- dok_blech))
	)
	(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq e0 (- (* 0.5 h_trg) dok_blech)	))	
	(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq e0 (- (* 0.5 h_trg) dok_blech) ))	
	
	(print e0)
	(Lochbild.set Lchb_ID (e0 		e0)
												;(e1			300)
												(w0 		w0_rund)
												(klemml (+ dp_blech s_trg))
												(dxSKopf dxSKopf)
	) 
	
	(print e_min)
	(print w0)
	
	
)

(defun calcDxSKopf (s_trg dp_blech)
	(print "------------------------------------------------------------")
	(print "BERECHNE DXSKOPF")
	(setq qsform (Traeger.get Tr_ID qsform))
	(setq dxSKopf 0)				; sicherheitshalber initialisieren
	
	(if (= qsform "I")
		(progn
			(setq dxSKopf (+ s_trg (* 0.5 dp_blech)))	
		)
	)
	
	(if (= qsform "C") (setq qsform "U"))
	(if (= qsform "U")
		(progn
			(if (= (Connect.get CastaData amHtFlansch) 1)
				(progn
					(if (= (Connect.get CastaData satr-shtr)  1)	(setq dxSKopf (+ s_trg (* 0.5 dp_blech))))
					(if (= (Connect.get CastaData satr-shtr) -1)	(setq dxSKopf (* 0.5 dp_blech)))
				)
			)
			(if (= (Connect.get CastaData amHtSteg) 1)
				(progn
					(if (= (Connect.get CastaData satr-vhtr)  1)	(setq dxSKopf (+ s_trg (* 0.5 dp_blech))))
					(if (= (Connect.get CastaData satr-vhtr) -1)	(setq dxSKopf (* 0.5 dp_blech)))
				)
			)
		)
	)
	
	(print "------------------------------------------------------------")
)

; ----------------------------------------------------------------------------------------
; ERZEUGT DIE KNAGGE
; ----------------------------------------------------------------------------------------
(defun createKnagge (KNAGGE)
	(print "*clear*")
	(print ">-----------------------------------------------------------")
	(print "ERZEUGE KNAGGE")
	(setq	b_at 		(Traeger.get Tr_ID b)
		h_at		(Traeger.get Tr_ID h)
		delta_v_at	(Traeger.get Tr_ID delta_v)
		delta_lr_at	(Traeger.get Tr_ID delta_lr)
		qsform_at	(Traeger.get Tr_ID qsform)
	)
	
	(setq	delta_lr_ht	(Traeger.get Htrg delta_lr)
		delta_v_ht	(Traeger.get Htrg delta_v)
		h_ht		(Traeger.get Htrg h)
		s_ht		(Traeger.get Htrg s)
		b_ht		(Traeger.get Htrg b)
		hc_ht		(Traeger.get Htrg hc)
	)
	
	(setq	xPos_ht 	(Connect.get CastaData xPos_ht)
		afl_winkel	(Connect.get CastaData afl_vwinkel)
	)
	(print xPos_ht)
	(print afl_winkel)
	
	(setq tanAfl (tan (/ (* PI afl_winkel) 180.0)))
	(print tanAfl)
	
	(setq h_at_rund (runde h_at auf 5))
	(setq hp_knagge (* h_at_rund 0.5))
	(setq dp_knagge 40)
	
	; dok Knagge
	; TODO:
	; ------------------------------------------------------------------
	; Knagge sollte ber die Oberkante des Bleches eingefgt werden - nicht ber den Mittelpunkt
	; --------------------------------------------------------------------------------------------
	
	
	(if (= (Connect.get CastaData vatr-lhtr) 1)
		(progn
			(setq dok_knagge (+ (* 0.5 h_at) (* 0.5 hp_knagge)))
			(print dok_knagge)
			(setq dok_knagge (+ dok_knagge delta_v_at))
		)
	)
	(if (= (Connect.get CastaData vatr-lhtr) -1)
		(progn
			(setq dok_knagge (- (+ (* 0.5 h_at) (* 0.5 hp_knagge))))
			(print dok_knagge)
			(setq dok_knagge (- dok_knagge delta_v_at))
		)
	)
			
	(if (= (Connect.get CastaData amHtFlansch) 1)
		(progn
			; Anteil AT Neigung
			(setq divOK 1)
			(if (= tanAfl 0.0) (setq divOK 0))
			(if (< tanAfl 0.0000001) (if (> tanAfl -0.0000001) (setq divOK 0)))
			
			(if (= divOK 1) 
				(setq anteilNeigung (/ (* s_ht 0.5) tanAfl))
				(setq  anteilNeigung 0.0)
			)
			(print anteilNeigung)


			(if (= (Connect.get CastaData vatr-lhtr) 1)
				(setq dok_knagge (+ dok_knagge anteilNeigung))
			)
			(if (= (Connect.get CastaData vatr-lhtr) -1)
				(setq dok_knagge (+ dok_knagge anteilNeigung))
			)
		)
	)
	(if (= (Connect.get CastaData amHtSteg) 1)
		(progn
			(print "Anschluss am Steg")
			(print afl_winkel)
			(print tanAfl)

			; Anteil AT Neigung
			(setq divOK 1)
			(if (= tanAfl 0.0) (setq divOK 0))
			(if (< tanAfl 0.0000001) (if (> tanAfl -0.0000001) (setq divOK 0)))
			
			(if (= divOK 1) 
				(setq anteilNeigung (/ (* s_ht 0.5) tanAfl))
				(setq  anteilNeigung 0.0)
			)

			(print anteilNeigung)
			(if (= (Connect.get CastaData vatr-lhtr) 1)
				(setq dok_knagge (+ dok_knagge anteilNeigung))
			)
			(if (= (Connect.get CastaData vatr-lhtr) -1)
				(setq dok_knagge (+ dok_knagge anteilNeigung))
			)
		)
	)
	
	
	
	(if (= (Connect.get CastaData amHtFlansch) 1)
		(progn
			; delta_lr Knagge
			; Verschiebung AT
			(if (= (Connect.get CastaData satr-shtr) 1)
				(setq delta_lr_knagge delta_lr_at)
			)
			(if (= (Connect.get CastaData satr-shtr) -1)
				(setq delta_lr_knagge (- delta_lr_at))
			)
			
			; Profilunterscheidung
			(if (= qsform_at "U")
				(progn
					(if (= (Connect.get CastaData satr-shtr)  1)	(setq delta_lr_knagge (+ delta_lr_knagge (* 0.5 b_at))))
					(if (= (Connect.get CastaData satr-shtr) -1)	(setq delta_lr_knagge (- delta_lr_knagge (* 0.5 b_at))))
				)
			)
			
			;Verschiebung HT
			(setq delta_lr_knagge (- delta_lr_knagge delta_lr_ht))
		)
	)
	(if (= (Connect.get CastaData amHtSteg) 1)
		(progn
			; delta_lr Knagge
			; Verschiebung AT
			(if (= (Connect.get CastaData satr-vhtr) 1)
				(setq delta_lr_knagge delta_lr_at)
			)
			(if (= (Connect.get CastaData satr-vhtr) -1)
				(setq delta_lr_knagge (- delta_lr_at))
			)
			
			; Profilunterscheidung
			(if (= qsform_at "U")
				(progn
					(if (= (Connect.get CastaData satr-vhtr)  1)	(setq delta_lr_knagge (+ delta_lr_knagge (* 0.5 b_at))))
					(if (= (Connect.get CastaData satr-vhtr) -1)	(setq delta_lr_knagge (- delta_lr_knagge (* 0.5 b_at))))
				)
			)
			
			;Verschiebung HT
			(setq delta_lr_knagge (- delta_lr_knagge delta_v_ht))
		)
	)

	
	; Knaggenbreite
	(if (>= b_at hc_ht)
		(setq bp_knagge hc_ht)
		(setq bp_knagge b_at)
	)
	
	(if (= (Connect.get CastaData amHtSteg) 1)
		(progn
			(print bflansch)
			(if (/= bflansch 0.0)
				(progn
					(setq bp_knagge bflansch)
					(if (= (Connect.get CastaData satr-vhtr)  1)	(setq delta_lr_knagge (- delta_lr_knagge (* 0.5 (- b_at bflansch)))))
					(if (= (Connect.get CastaData satr-vhtr) -1)	(setq delta_lr_knagge (+ delta_lr_knagge (* 0.5 (- b_at bflansch)))))
				)
			)
			
			(print yakl)
			(if (/= yakl 0.0)
				(progn
					(setq bp_knagge (- bp_knagge yakl))
					(if (= (Connect.get CastaData satr-vhtr)  1)	(setq delta_lr_knagge (+ delta_lr_knagge (* 0.5 yakl))))
					(if (= (Connect.get CastaData satr-vhtr) -1)	(setq delta_lr_knagge (- delta_lr_knagge (* 0.5 yakl))))
				)
			)
		)
	)
	
	; Knaggendaten
	(Blech.set KNAGGE (hp 			hp_knagge)
										(bp 			bp_knagge)
										(dp 			dp_knagge)
										(dok 			dok_knagge)
										(delta_lr delta_lr_knagge)
	)
	
	(if (= (Connect.get CastaData amHtUnterflansch) 1)
		(Traeger.addabtl Htrg KNAGGE xPos_ht 0.0 _lasche_uf_)
	)
	(if (= (Connect.get CastaData amHtOberflansch) 1)
		(Traeger.addabtl Htrg KNAGGE xPos_ht 0.0 _lasche_of_)
	)
	(if (= (Connect.get CastaData amHtStegLinks) 1)
		(Traeger.addabtl Htrg KNAGGE xPos_ht 0.0 _lasche_steg_li_)
	)
	(if (= (Connect.get CastaData amHtStegRechts) 1)
		(Traeger.addabtl Htrg KNAGGE xPos_ht 0.0 _lasche_steg_re_)
	)
	(print "------------------------------------------------------------")
	
)

; ----------------------------------------------------------------------------------------
; Prft, die Position des AT in Bezug auf den HT
; ----------------------------------------------------------------------------------------
(defun checkPosition ()
	(print "------------------------------------------------------------")
	(print "BERPRFE AT POSITION")
	(print "------------------------------------------------------------")
	
	(setq hc_ht 			(Traeger.get Htrg hc)
				b_ht				(Traeger.get Htrg b)
				delta_v_ht	(Traeger.get Htrg delta_v)
				delta_lr_ht	(Traeger.get Htrg delta_lr)
	)
	
	(setq delta_lr_at	(Traeger.get Tr_ID delta_lr)
				s_at				(Traeger.get Tr_ID s)
	)
	
	; Standardmig wird angenommen, dass der AT angeschlossen werden kann.
	(setq isInside 1)
	
	; Wenn der Anschluss am HT-Steg erfolgt, wird geprft, ob sich der AT-Steg im HC-Bereich des HT befindet.
	(if (= (connect.get CastaData amHtSteg) 1)
		(progn
			; obere und untere Ausrundung des HT
			(setq ausrO_ht (- delta_v_ht (* 0.5 hc_ht)))
			(setq ausrU_ht (+ ausrO_ht hc_ht))
			(print ausrO_ht)
			(print ausrU_ht)
			(print delta_lr_at)
				
			(if (= (Connect.get CastaData satr-vhtr) 1)
				(progn
					(if (> delta_lr_at ausrU_ht)
						(progn
							(setq isInside 0)
						)
						(progn
							(if (< delta_lr_at ausrO_ht)
								(setq isInside 0)
								(setq isInside 1)
							)
						)
					)
				)
			)
			(if (= (Connect.get CastaData satr-vhtr) -1)
				(progn
					(if (> delta_lr_at (- ausrO_ht))
						(progn
							(setq isInside 0)
						)
						(progn
							(if (< delta_lr_at (- ausrU_ht))
								(setq isInside 0)
								(setq isInside 1)
							)
						)
					)
				)
			)
			
			(if (= isInside 0)
				(print "AUSSERHALB")
				(print "INNERHALB")
			)
		)
	)
	
	; Wenn der Anschluss am HT-Flansch erfolgt, wird geprft, ob der AT-Steg noch am Flansch 
	; angeschlossen werden kann.
	(if (= (Connect.get CastaData amHtFlansch) 1)
		(progn
			; linke und rechte Seite des HT-Fansches
			(setq flansch_ht_l (- delta_lr_ht (* 0.5 b_ht)))
			(setq flansch_ht_r (+ flansch_ht_l b_ht))
			(print flansch_ht_l)
			(print flansch_ht_r)
			(print delta_lr_at)
			
			(if (= (Connect.get CastaData satr-shtr) 1)
				(progn
					(if (> delta_lr_at flansch_ht_r)
						(progn
							(setq isInside 0)
						)
						(progn
							(if (< delta_lr_at flansch_ht_l)
								(setq isInside 0)
								(setq isInside 1)
							)
						)
					)
				)
			)
			(if (= (Connect.get CastaData satr-shtr) -1)
				(progn
					(if (> delta_lr_at (- flansch_ht_l))
						(progn
							(setq isInside 0)
						)
						(progn
							(if (< delta_lr_at (- flansch_ht_r))
								(setq isInside 0)
								(setq isInside 1)
							)
						)
					)
				)
			)
			
			(if (= isInside 0)
				(print "AUSSERHALB FLANSCH")
				(print "INNERHALB FLANSCH")
			)
		)
	)
)