; $	HT	QT(K)		AF(SK)		P(ZE)
; $	AT	QT(I)		AF(FK)		P(ZE)
; $ 	AE	V(0)		H(90)			R(-)

(defun load-modules ()
	(load "mod-endinit-trg-auf-trg")
)

(defun init-connection ()
(setq WrnText 
"Der Anschluss ist z.Z. in dieser Kombination nicht mglich.\n\n
Bitte rotieren Sie die Trger so, dass die hellen bzw. dunklen Flanschseiten\n
in eine Richtung zeigen und tauschen Sie, falls ntig, die Orientierung eines Trgers.")

	
	(connect.showattributes CastaData)
	(setq LB_DEBUG 0)
	
	;(init-traegerenden)
	;(setConnection)
				
	(if (= 1 1)	(progn
		(if (= (Connect.get CastaData vatr-vhtr) 1)
			(progn
				(init-traegerenden)
				(korrTrgEnde_Lokal)
				(setConnection)
			)
			(progn
;				(alertbox  WrnText "ERR_BeamRoation_Not_Functional")
				(init-traegerenden)
				(korrTrgEnde_Lokal)
				(setConnection)
			)
		)
	))
	
)



(defun setConnection ()
	
	; Abstand zwischen den Trgern berechnen
	; ---------------------------------------------
	(calcLichtenAbst) ; -> lichterAbst
	
	(if (> lichterAbst 2.0)
		(progn
			(setq futterBlech (Blech.create))
			(Connect.storeAnschlObjs CastaData futterBlech)
			(print "FutterBlech-Objekt wurde erzeugt!")
			
			(createFutterBlech futterBlech lichterAbst)
		)
	)
	
	(setq fllochbild (Lochbild.create))
	(Connect.storeAnschlObjs CastaData fllochbild)
	
	(if (= (Connect.get CastaData amHtFlansch) 1) (createFlanschLochbild fllochbild lichterAbst))
	(if (= (Connect.get CastaData amHtSteg) 1)    (createStegLochbild    fllochbild lichterAbst))
	
	; TEST
	; ******************************************************************
;	(Lochbild.set fllochbild (e0 0) (e1 15) (e2 50) (w0 60) (LB_Art 2) (delta_w 60))
;	(Lochbild.set fllochbild (e0 0) (e1 15) (e2 50) (w0 60))
	(setq QSTyp_HT (Traeger.get HTrg qsForm))
	(if (= QSTyp_HT "K") (progn
		(Lochbild.set fllochbild 	(Schr_Richt 	-1))
		(setq DXSKopf (Lochbild.get fllochbild dxSKopf))
		(Lochbild.set fllochbild (dxSKopf (- dxSKopf)))
	))

(if (= LB_DEBUG 1) (progn
	(setq lbdummy (Lochbild.create))
	(Lochbild.copy lbdummy fllochbild)
	
	; Anbauteil dem At hinzufgen
	(if (= (Connect.get CastaData amAtOberflansch) 1)
		(traeger.addabtl Tr_ID lbdummy xPos_at 0.0 _flanschlochbild_of_)	
	)
	(if (= (Connect.get CastaData amAtUnterflansch) 1)
		(traeger.addabtl Tr_ID lbdummy xPos_at 0.0 _flanschlochbild_uf_)
	)
	
	
	(setq AT_ABTeil_dummy (Traeger.get Tr_ID AbTeil lbdummy))
	(Anbauteil.set AT_ABTeil_dummy 	(winkel   winkel_abteil_at)
					(delta_lr		delta_lr_abtl_at)
					(Master    1)
	)
	
	(Connect.storeAnschlObjs CastaData lbdummy)
))
	; ******************************************************************

	(setq AT_ABTeil_Lchb (Traeger.get Tr_ID AbTeil fllochbild))
	(setq HT_ABTeil_Lchb (Traeger.get HTrg  AbTeil fllochbild))
	(Anbauteil.set AT_ABTeil_Lchb  (Master    0))
	(Anbauteil.set HT_ABTeil_Lchb  (Master    1))


)



(defun calcAndSetLochbildDaten (Lchb_ID ABST)
	(print ">-----------------------------------------------------------")
	(print "BERECHNE LOCHBILDDATEN")
	(Lochbild.set Lchb_ID (S_Bez 		"M12")
												(Guete   	"4.6")
												(e       	"0 60 0 0 0 0")
												(w       	"80  0")
	)
	
	(setq t_at 	(Traeger.get Tr_ID t)
				b_at	(Traeger.get Tr_ID b)
				s_at	(Traeger.get Tr_ID s)
				r_at	(Traeger.get Tr_ID r)
	)
	
	(setq t_ht	(Traeger.get Htrg t)
				b_ht	(Traeger.get Htrg b)
				s_ht	(Traeger.get Htrg s)
				r_ht	(Traeger.get Htrg r)
	)
	
	
	; dxSKopf
	(setq dxSKopf (+ t_at ABST))
	
	(setq abzug_at (+ s_at (* 2 r_at)))
	(setq rest_at (- b_at abzug_at))
	
	(setq abzug_ht (+ s_ht (* 2 r_ht)))
	(setq rest_ht (- b_ht abzug_ht))
		
	(setq e1 (+ (* 0.5 rest_at) abzug_at))
	(print e1)
	(setq e1rund (runde e1 auf 5))
	(print e1rund)
	(setq e0 (- (* 0.5 e1)))
	(print e0)
	(setq e0rund (runde e0 auf 5))
	(print e0rund)
	(setq w0 (+ (* 0.5 rest_ht) abzug_ht))
	(print w0)
	(setq w0rund (runde w0 auf 5))
	(print w0rund)
	
	(Lochbild.set Lchb_ID	(e0				e0)
												(e1				e1)
												(w0				w0) 	
												(klemml 	(+ t_ht t_at ABST))
												(dxSKopf  dxSKopf)
	)
	
	(if (= LB_DEBUG 1)
		(Lochbild.set Lchb_ID	(e2 200))
	)
	
	(print "*clear*")
	(Connect.ShowAttributes CastaData)
	
	(if (= 1 1)	(progn
	; ---- an Trgerenden halbe Lochbilder einbauen mit LB_Art 2 - oder -2
	(if (= (Connect.get CastaData amHtOberflansch) 1)
		(progn
			(if (= (Connect.get CastaData amAtOberflansch) 1) (progn
					(if (= (Connect.get CastaData linkesEnde)  1) (Lochbild.set Lchb_ID (Lb_Art  -2)))
					(if (= (Connect.get CastaData rechtesEnde) 1) (Lochbild.set Lchb_ID (Lb_Art   2)))
			))
			(if (= (Connect.get CastaData amAtUnterflansch) 1) (progn
					(if (= (Connect.get CastaData linkesEnde)  1) (Lochbild.set Lchb_ID (Lb_Art   2)))
					(if (= (Connect.get CastaData rechtesEnde) 1) (Lochbild.set Lchb_ID (Lb_Art  -2)))
			))
		)
	)
	(if (= (Connect.get CastaData amHtUnterflansch) 1)
		(progn
			(if (= (Connect.get CastaData amAtOberflansch) 1) (progn
					(if (= (Connect.get CastaData linkesEnde)  1) (Lochbild.set Lchb_ID (Lb_Art   2)))
					(if (= (Connect.get CastaData rechtesEnde) 1) (Lochbild.set Lchb_ID (Lb_Art  -2)))
			))
			(if (= (Connect.get CastaData amAtUnterflansch) 1) (progn
					(if (= (Connect.get CastaData linkesEnde)  1) (Lochbild.set Lchb_ID (Lb_Art -2)))
					(if (= (Connect.get CastaData rechtesEnde) 1) (Lochbild.set Lchb_ID (Lb_Art  2)))
			))
		)
	)
	
		(setq lb_art (Lochbild.get Lchb_ID Lb_Art))
	(print lb_art)
	
	))
	(print "<-----------------------------------------------------------")
)
; -------------------------------------------------------------------------------------------------------------
; -------------------------------------------------------------------------------------------------------------
(defun createStegLochbild (Lchb_ID ABST)

	(print ">-----------------------------------------------------------")
	(print "ERZEUGE LOCHBILD")
	
	(calcAndSetLochbildDaten Lchb_ID ABST)
	
	(setq 	delta_lr_at	(Traeger.get Tr_ID delta_lr)
		delta_v_at	(Traeger.get Tr_ID delta_v)
	)
	
	(setq delta_lr_ht (Traeger.get Htrg delta_lr))
	
	(setq xPos_ht (Connect.get CastaData xPos_ht))
	(setq xPos_at (Connect.get CastaData xPos_at))
	
	(print xPos_ht)
	(print xPos_at)


	; - Steg-Seite des HT - liegendes QR / RR Profil
	(if (= (Connect.get CastaData amHtSteg) 1)
		(traeger.addabtl Htrg Lchb_ID xPos_ht 0.0 _steglochbild_)
	)

	; Flansch oder Steg des AT
	(if (= (Connect.get CastaData amAtOberflansch) 1)
		(traeger.addabtl Tr_ID Lchb_ID xPos_at 0.0 _flanschlochbild_of_)	
	)
	(if (= (Connect.get CastaData amAtUnterflansch) 1)
		(traeger.addabtl Tr_ID Lchb_ID xPos_at 0.0 _flanschlochbild_uf_)
	)
	(if (= (Connect.get CastaData amAtStegLinks) 1)
		(traeger.addabtl Tr_ID Lchb_ID xPos_at 0.0 _steglochbild_)
	)
	(if (= (Connect.get CastaData amAtStegRechts) 1)
		(alertBox "Anschluss ist nicht mglich" "Connection_Not_Possible")	; Msste eigentlich weiter vorne abgefangen werden
	)

	(setq QSTyp_HT (Traeger.get HTrg qsForm))
	(if (= QSTyp_HT "K") (Lochbild.set Lchb_ID (Montage 7)))  ; Bei Kastentrger-HT auf Hollo-Bolt stellen
	
	(setq b_HT   (Traeger.get HTrg b))
	(setq h_HT   (Traeger.get HTrg h))
	(setq dv_HT  (Traeger.get HTrg delta_V))
	(setq dlr_AT (Traeger.get Tr_ID delta_LR))

	(if (= (Connect.get CastaData amhtsteglinks)  1) (Lochbild.set Lchb_ID (dlr_Coupon (* -0.5 b_HT))))
	(if (= (Connect.get CastaData amhtstegrechts) 1) (Lochbild.set Lchb_ID (dlr_Coupon (*  0.5 b_HT))))

	(setq Abtl_Lchb_HT (Traeger.get HTrg AbTeil Lchb_ID))
	(setq Abtl_Lchb_AT (Traeger.get Tr_ID AbTeil Lchb_ID))

	(Anbauteil.set Abtl_Lchb_HT (delta_V (* 0.5 h_HT)))
	
	(if (= (Connect.get CastaData at-von-unten) 1) (progn
		(Anbauteil.set Abtl_Lchb_AT (Winkel 180.0))
	))

	(if (= (Connect.get CastaData satr-lhtr)  1) (progn
		(Anbauteil.set Abtl_Lchb_AT (delta_V dv_HT))
		(Anbauteil.set Abtl_Lchb_HT (delta_LR dlr_AT))
	))
	(if (= (Connect.get CastaData satr-lhtr)  -1) (progn
		(Anbauteil.set Abtl_Lchb_AT (delta_V dv_HT))
		(Anbauteil.set Abtl_Lchb_HT (delta_LR (- dlr_AT)))
	))
	
)
; -------------------------------------------------------------------------------------------------------------
; -------------------------------------------------------------------------------------------------------------
(defun createFlanschLochbild (Lchb_ID ABST)
	(print ">-----------------------------------------------------------")
	(print "ERZEUGE LOCHBILD")
	
	(calcAndSetLochbildDaten Lchb_ID ABST)
	
	(setq 	delta_lr_at	(Traeger.get Tr_ID delta_lr)
		delta_v_at	(Traeger.get Tr_ID delta_v)
	)
	
	(setq delta_lr_ht (Traeger.get Htrg delta_lr))
	
	(setq xPos_ht (Connect.get CastaData xPos_ht))
	(setq xPos_at (Connect.get CastaData xPos_at))
	
	(print xPos_ht)
	(print xPos_at)
	
	
		
	; Anbauteil dem Ht hinzufgen
	(if (= (Connect.get CastaData amHtOberflansch) 1)
		(traeger.addabtl Htrg Lchb_ID xPos_ht 0.0 _flanschlochbild_of_)
	)
	(if (= (Connect.get CastaData amHtUnterflansch) 1)
		(traeger.addabtl Htrg Lchb_ID xPos_ht 0.0 _flanschlochbild_uf_)
	)

	
	; Anbauteil dem At hinzufgen
	(if (= (Connect.get CastaData amAtOberflansch) 1)
		(traeger.addabtl Tr_ID Lchb_ID xPos_at 0.0 _flanschlochbild_of_)	
	)
	(if (= (Connect.get CastaData amAtUnterflansch) 1)
		(traeger.addabtl Tr_ID Lchb_ID xPos_at 0.0 _flanschlochbild_uf_)
	)
	(if (= (Connect.get CastaData amAtStegLinks) 1)
		(traeger.addabtl Tr_ID Lchb_ID xPos_at 0.0 _steglochbild_)
	)
	(if (= (Connect.get CastaData amAtStegRechts) 1)
		(alertBox "Anschluss ist nicht mglich"  "Connection_Not_Possible")
	)
	
	

	; Anbauteil-Winkel AT
	; --------------------------
	; am AT Flansch
	(if (= (Connect.get CastaData amATFlansch) 1)
		(progn
			(if (= (Connect.get CastaData amHtOberflansch)	1)
				(progn
					(if (= (Connect.get CastaData amATOberflansch) 1)
						(progn
							(if (= (Connect.get CastaData satr-lhtr)  1)	(setq winkel_abteil_at 270.0)	)
							(if (= (Connect.get CastaData satr-lhtr) -1)	(setq winkel_abteil_at 270.0)	)
						)
					)
					(if (= (Connect.get CastaData amATUnterflansch) 1)
						(progn
							(if (= (Connect.get CastaData satr-lhtr)  1)	(setq winkel_abteil_at 270.0)	)
							(if (= (Connect.get CastaData satr-lhtr) -1)	(setq winkel_abteil_at 270.0)	);
						)
					)
				)
			)
			(if (= (Connect.get CastaData amHtUnterflansch)	1)
				(progn
					(if (= (Connect.get CastaData amATOberflansch) 1)
						(progn
							(if (= (Connect.get CastaData satr-lhtr)  1)	(setq winkel_abteil_at 270.0)	)
							(if (= (Connect.get CastaData satr-lhtr) -1)	(setq winkel_abteil_at 270.0)	);
						)
					)
					(if (= (Connect.get CastaData amATUnterflansch) 1)
						(progn
							(if (= (Connect.get CastaData satr-lhtr)  1)	(setq winkel_abteil_at 270.0)	)
							(if (= (Connect.get CastaData satr-lhtr) -1)	(setq winkel_abteil_at 270.0)	)
						)
					)
				)
			)
			(if (= (Connect.get CastaData amHtStegRechts)	1) (progn
				(setq winkel_abteil_at 0.0)
			))
			(if (= (Connect.get CastaData amHtStegLinks)	1) (progn
				(setq winkel_abteil_at 0.0)
			))
		)
	)
	; am AT Steg
	(if (= (Connect.get CastaData amATSteg) 1)
		(progn
			(setq winkel_abteil_at 0.0)
		)
	)
	
	; Anbauteil-Winkel HT
	; --------------------------
	; am AT Flansch
	(if (= (Connect.get CastaData amATFlansch) 1)
		(progn
			(if (= (Connect.get CastaData satr-lhtr) -1)	(setq winkel_abteil_ht 180.0)	)
			(if (= (Connect.get CastaData satr-lhtr)  1)	(setq winkel_abteil_ht 0.0)		)
		)
	)
	; am AT Steg
	(if (= (Connect.get CastaData amATSteg) 1)
		(progn
			(if (= (Connect.get CastaData amHtOberflansch) 1)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq winkel_abteil_ht 180.0)	)
					(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq winkel_abteil_ht 0.0)		)
				)
			)
			(if (= (Connect.get CastaData amHtUnterflansch) 1)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq winkel_abteil_ht 180.0)	)
					(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq winkel_abteil_ht 0.0)		)
				)
			)
		)
	)
	
	
	(setq delta_v_abteil_ht 0.0)
	(setq delta_lr_abteil_at 0.0)
	
	; Positionierung Anbauteil HT an AT (nur wenn am AT-Steg)
	; --------------------------
	(if (= (Connect.get CastaData amATSteg) 1)
		(progn
			(setq h_at (Traeger.get Tr_ID h))
			(setq delta_v_abteil_ht (- delta_v_abteil_ht (* 0.5 h_at)))
		)
	)
	
	
	; Anbauteil delta_v HT
	; --------------------------
	(if (= (Connect.get CastaData amATFlansch) 1)
		(progn
			(if (= (Connect.get CastaData vatr-vhtr) -1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta_v_abteil_ht (+ delta_v_abteil_ht delta_lr_at))	)
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta_v_abteil_ht (+ delta_v_abteil_ht delta_lr_at))	)
				)
			)
			(if (= (Connect.get CastaData vatr-vhtr)  1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta_v_abteil_ht (+ delta_v_abteil_ht delta_lr_at))	)
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta_v_abteil_ht (+ delta_v_abteil_ht delta_lr_at))	)
				)
			)
		)
	)
	(if (= (Connect.get CastaData amATSteg) 1)
		(progn
			(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_v_abteil_ht (+ delta_v_abteil_ht delta_v_at))	)
			(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_v_abteil_ht (+ delta_v_abteil_ht delta_v_at))	)
		)
	)
	

	; Anbauteil delta_lr AT
	; --------------------------
	(if (= (Connect.get CastaData amATFlansch) 1)
		(progn
			(if (= (Connect.get CastaData vatr-vhtr)  1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta_lr_abteil_at (+ delta_lr_abteil_at delta_lr_ht))	)
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta_lr_abteil_at (- delta_lr_abteil_at delta_lr_ht))	)
				)
			)
			(if (= (Connect.get CastaData vatr-vhtr) -1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta_lr_abteil_at (- delta_lr_abteil_at delta_lr_ht))	)
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta_lr_abteil_at (+ delta_lr_abteil_at delta_lr_ht)) )
				)
			)
		)
	)
	(if (= (Connect.get CastaData amATSteg) 1)
		(progn
			(if (= (Connect.get CastaData amHtOberflansch) 1)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_lr_abteil_at (+ delta_lr_abteil_at delta_lr_ht))	)
					(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_lr_abteil_at (- delta_lr_abteil_at delta_lr_ht))	)
				)
			)
			(if (= (Connect.get CastaData amHtUnterflansch) 1)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_lr_abteil_at (- delta_lr_abteil_at delta_lr_ht))	)
					(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_lr_abteil_at (+ delta_lr_abteil_at delta_lr_ht))	)
				)
			)
		)
	)

	(print delta_v_abteil_ht)
	(print delta_lr_abteil_at)
	
	(print winkel_abteil_ht)
	(print winkel_abteil_at)
	; HT-Anbauteil Werte setzen
	(setq HT_ABTeil (Traeger.get Htrg AbTeil Lchb_ID))
	
	(Anbauteil.set HT_ABTeil 	(winkel   winkel_abteil_ht)
				 	(Master   1)
				 	(delta_v 	delta_v_abteil_ht)
	)
	
	
	; AT-Anbauteil Werte setzen
	(setq AT_ABTeil (Traeger.get Tr_ID AbTeil Lchb_ID))
	
	(Anbauteil.set AT_ABTeil 	(winkel  		winkel_abteil_at)
														(delta_lr		delta_lr_abteil_at)
				 										(Master     0)
	)
	(if (= (Connect.get CastaData amAtSteg) 1)
		(progn
			(Anbauteil.set AT_ABTeil 	(winkel  	winkel_abteil_at)
																(delta_lr	delta_lr_abteil_at)
				 												(Master   0)
			)
		)
	)

	(if (= (Connect.get CastaData vatr-vhtr) -1)	(Anbauteil.set AT_ABTeil 	(SeitRicht  -1)))
	
	(Anbauteil.set AT_ABTeil 	(SeitRicht  1))

	(if (= (Connect.get CastaData amATFlansch) 1) (progn
		(if (= (Connect.get CastaData vatr-vhtr) -1) (Anbauteil.set AT_ABTeil 	(SeitRicht  -1)))
	))
	
	(setq QSTyp_HT (Traeger.get HTrg qsForm))
	(if (= QSTyp_HT "K") (Lochbild.set Lchb_ID (Montage 7)))  ; Bei Kastentrger-HT auf Hollo-Bolt stellen

)






(defun calcLichtenAbst ()
	(print ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>")
	(print "BERECHNE LICHTEN ABSTAND DER TRGER")
	(setq	delta_v_at 	(Traeger.get Tr_ID delta_v)
		h_at		(Traeger.get Tr_ID h)
		b_at		(Traeger.get Tr_ID b)
		dlr_at		(Traeger.get Tr_ID delta_LR)
	)
	
	(setq	delta_v_ht	(Traeger.get Htrg delta_v)
		h_ht		(Traeger.get Htrg h)
		b_ht		(Traeger.get Htrg b)
		dlr_ht		(Traeger.get Htrg delta_LR)
	)
	
	(setq h_at_halb	(* 0.5 h_at))
	(setq h_ht_halb	(* 0.5 h_ht))

	(setq b_at_halb	(* 0.5 b_at))
	(setq b_ht_halb	(* 0.5 b_ht))

	
	(print delta_v_ht)
	(print h_ht_halb)
	(print delta_v_at)
	(print h_at_halb)
	
	(setq pos_ht 0.0)
	(setq pos_at 0.0)
	
	(if (= (Connect.get CastaData amHtOberflansch) 1)	(setq pos_ht (- delta_v_ht h_ht_halb)))
	(if (= (Connect.get CastaData amHtUnterflansch) 1)	(setq pos_ht (+ delta_v_ht h_ht_halb)))
	
	(if (= (Connect.get CastaData amHtOberflansch) 1)
		(progn
			(if (= (Connect.get CastaData amAtOberflansch) 1)	(setq pos_at	(- (- delta_v_at h_at_halb)))	)
			(if (= (Connect.get CastaData amAtUnterflansch) 1)	(setq pos_at	(+ delta_v_at h_at_halb))	)
		)
	)
	(if (= (Connect.get CastaData amHtUnterflansch) 1)
		(progn
			(if (= (Connect.get CastaData amAtOberflansch) 1)	(setq pos_at	(- delta_v_at h_at_halb))	)
			(if (= (Connect.get CastaData amAtUnterflansch) 1)	(setq pos_at	(- (- delta_v_at) h_at_halb))	)
		)
	)

	(if (= (Connect.get CastaData amHtStegLinks)  1)	(setq pos_ht (- dlr_ht b_ht_halb)))
	(if (= (Connect.get CastaData amHtStegRechts) 1)	(setq pos_ht (+ dlr_ht b_ht_halb)))
	
	(if (= (Connect.get CastaData amHtStegLinks) 1)
		(progn
			(if (= (Connect.get CastaData amAtOberflansch) 1)	(setq pos_at	(- (- delta_v_at h_at_halb)))	)
			(if (= (Connect.get CastaData amAtUnterflansch) 1)	(setq pos_at	(+ delta_v_at h_at_halb))	)
		)
	)
	(if (= (Connect.get CastaData amHtStegRechts) 1)
		(progn
			(if (= (Connect.get CastaData amAtOberflansch) 1)	(setq pos_at	(- delta_v_at h_at_halb))	)
			(if (= (Connect.get CastaData amAtUnterflansch) 1)	(setq pos_at	(- (- delta_v_at) h_at_halb))	)
		)
	)

	
	(print pos_ht)
	(print pos_at)
	
	(setq lichterAbst 0.0)
	
	(if (/= pos_at pos_ht)
		(setq lichterAbst (- pos_at pos_ht))
	)
	
	(print lichterAbst)
	
	(if (< lichterAbst 0.0)
		(setq lichterAbst (- lichterAbst))
	)
	(print lichterAbst)
	(print "<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<")
)




(defun calcFutterBlech (BLECH_ID ABST)
	(print ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>")
	(print "BERECHNE FUTTERBLECHDATEN")
	(setq	b_at		(Traeger.get Tr_ID b))
	
	(setq	b_ht		(Traeger.get Htrg b)
		s_ht		(Traeger.get Htrg s)
		dv_HT		(Traeger.get Htrg delta_V)
	)
	
	; Futterblechdicke
	(setq dp_futter ABST)
	
	; Breite
	(setq bp_futter b_at)
	
	; Hhe	
	(if (= (Connect.get CastaData anschlZwAtEnden) 0)
		(progn
			(setq hp_futter h_ht)
		)
	)

	(setq dOK_Bl 0.0)
	(if (= (Connect.get CastaData amHtSteg) 1) (progn
		(if (= (Connect.get CastaData at-von-unten) 1) (progn
			(setq dOK_Bl (- (- dv_HT) (* 0.5 hp_futter) ))
		))
		(if (= (Connect.get CastaData at-von-oben) 1) (progn
			(setq dOK_Bl (- dv_HT (* 0.5 hp_futter)))
		))
	))	
	
	(Blech.set BLECH_ID 	(hp hp_futter)
				(bp bp_futter)
				(dp dp_futter)
				(dOK dOK_Bl)
	)
	
	
	(print "<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<")
)



(defun createFutterBlech (BLECH_ID ABST)
	(print ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>")
	(print "ERZEUGE FUTTERBLECH")
	(calcFutterBlech BLECH_ID ABST)
	
	(setq delta_lr_ht 	(Traeger.get Htrg delta_lr)
				s_ht					(Traeger.get Htrg s)
	)
	
	(setq xPos_at	(Connect.get CastaData xPos_at))
	
	(setq hp_futter (Blech.get BLECH_ID hp))
	
	; Beim Anschluss mit AT-Enden
	(if (= (Connect.get CastaData anschlZwAtEnden) 0)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq xPos_at (+ xPos_at (* 0.5 hp_futter) (* 0.5 s_ht))))
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq xPos_at (+ xPos_at (* 0.5 hp_futter) (* 0.5 s_ht))))
				)
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq xPos_at (- xPos_at (* 0.5 hp_futter) (* 0.5 s_ht))))
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq xPos_at (- xPos_at (* 0.5 hp_futter) (* 0.5 s_ht))))
				)
			)
		)
	)
	
	; Anteil delta_lr HT
	(if (= (Connect.get CastaData amHtOberflansch) 1)
		(progn
			(if (= (Connect.get CastaData amAtOberflansch) 1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq xPos_at (+ xPos_at delta_lr_ht)))
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq xPos_at (- xPos_at delta_lr_ht)))
				)
			)
			(if (= (Connect.get CastaData amAtUnterflansch) 1)	
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq xPos_at (- xPos_at delta_lr_ht)))
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq xPos_at (+ xPos_at delta_lr_ht)))
				)
			)
		)
	)
	(if (= (Connect.get CastaData amHtUnterflansch) 1)
		(progn
			(if (= (Connect.get CastaData amAtOberflansch) 1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq xPos_at (- xPos_at delta_lr_ht)))
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq xPos_at (+ xPos_at delta_lr_ht)))
				)
			)
			(if (= (Connect.get CastaData amAtUnterflansch) 1)	
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq xPos_at (+ xPos_at delta_lr_ht)))
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq xPos_at (- xPos_at delta_lr_ht)))
				)
			)
		)
	)
	;(if (= (Connect.get CastaData satr-lhtr)  1)	(setq xPos_at (- xPos_at delta_lr_ht)))
	;(if (= (Connect.get CastaData satr-lhtr) -1)	(setq xPos_at (+ xPos_at delta_lr_ht)))
		
		
	(if (= (Connect.get CastaData amATUnterflansch) 1)	(Traeger.addabtl Tr_ID BLECH_ID xPos_at 0.0 _lasche_uf_))
	(if (= (Connect.get CastaData amATOberflansch) 1)	(Traeger.addabtl Tr_ID BLECH_ID xPos_at 0.0 _lasche_of_))
	
	(print "<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<")
)

(defun korrTrgEnde_Lokal ()
	(if (= (Connect.get CastaData anschlzwHtEnden) 0) (progn
		(if (= (Connect.get CastaData anHtRechtesEnde) 1) (setq TrgEnde (Traeger.get HTrg rechts)))
		(if (= (Connect.get CastaData anHtLinkesEnde)  1) (setq TrgEnde (Traeger.get HTrg links)))
		
		(setq	b_AT 		(Traeger.get Tr_ID b)
			dlr_AT		(Traeger.get Tr_ID delta_LR)
		)
		
		(setq dl_Neu (* -0.5 b_AT))
		
		(if (= (Connect.get CastaData satr-lhtr) -1) (progn
			(if (= (Connect.get CastaData anhtrechtesende) 1) (setq dl_Neu (+ dl_Neu dlr_AT)))
			(if (= (Connect.get CastaData anhtlinkesende)  1) (setq dl_Neu (- dl_Neu dlr_AT)))
		))
		(if (= (Connect.get CastaData satr-lhtr)  1) (progn
			(if (= (Connect.get CastaData anhtrechtesende) 1) (setq dl_Neu (- dl_Neu dlr_AT)))
			(if (= (Connect.get CastaData anhtlinkesende)  1) (setq dl_Neu (+ dl_Neu dlr_AT)))
		))
		
		(TrEnde.set TrgEnde (delta_L dl_Neu))
	))

)

