; $	HT	QT(IU)		AF(FS)		P(ZE)
; $	AT	QT(IU)		AF(F)		P(ZE)
; $ 	AE	V(0)		H(75-105)		R(-)

(defun load-modules ()
	(load "mod-endinit-trg-auf-trg")
)

(defun init-connection ()
	
	(print "*clear*")
	(print "Anschluss fr kreuzende Profile")
	(connect.showattributes CastaData)
	(setq LB_DEBUG 0)
	
	(setq CreateAnschluss 1)
	(setq dlr_HT (Traeger.get HTrg  delta_LR))
	(setq dlr_AT (Traeger.get Tr_ID delta_LR))
	(if (/= (Connect.get CastaData vatr-vhtr) 1) (setq CreateAnschluss 0  HelpText "Anschluss funktioniert nur mit Oberflansch auf Unterflansch!"))
;	(if (/= dlr_AT 0) (setq CreateAnschluss 0  HelpText "Anschluss funktioniert nur wenn keine seitliche Verschiebung vorhanden ist!"))
;	(if (/= dlr_HT 0) (setq CreateAnschluss 0  HelpText "Anschluss funktioniert nur wenn keine seitliche Verschiebung vorhanden ist!"))
	
	(setq DoppelLochbild 1)
	(setq TesteLochbild  0)
	
	(if (= CreateAnschluss 1) (progn
		(init-traegerenden)
		(setConnection)
	))
	(if (= CreateAnschluss 0) (progn
	    (if (/= (Connect.get CastaData copymode) 1) (AlertBox HelpText))
	))
	
)

(defun setConnection ()
	
	(calcLichtenAbst) ; -> lichterAbst
	
	(if (> lichterAbst 2.0)
		(progn
			(setq futterBlech (Blech.create))
			(Connect.storeAnschlObjs CastaData futterBlech)
			(print "FutterBlech-Objekt wurde erzeugt!")
			
			(createFutterBlech futterBlech lichterAbst)
		)
	)
	
	(setq fllochbild (Lochbild.create))
	(Connect.storeAnschlObjs CastaData fllochbild)
	(Lochbild.set fllochbild (FormFkt "cb_Lochbild_$lb"))
	
	(createFlanschLochbild fllochbild lichterAbst)
	(BerechneLochbild_dOK fllochbild)

	;; berarbeitung 2016
	(if (= DoppelLochbild 1) (progn
		(setq fllochbild_2 (Lochbild.create))
		(Connect.storeAnschlObjs CastaData fllochbild_2)
		(createFlanschLochbild fllochbild_2 lichterAbst)
		(Lochbild.set fllochbild_2 (FormFkt "cb_Lochbild_2_$lb"))
			
		(setq lbArt_orig (Lochbild.get fllochbild LB_Art))
			
		(Lochbild.set fllochbild_2  (LB_Art  (- lbArt_orig)))
		(BerechneLochbild_dOK fllochbild_2)
	))
	
	
	; ******************************************
	; TEST FR MEHRFACHANSCHLUSS (FLANSCHSEITE)
	; ******************************************
	(setq anzAnschl (Connect.get CastaData anz_weitere_anschl))
	(print anzAnschl)
	  
	(if (/= anzAnschl 0) (progn
	  	(alertBox "An dem Knoten ist bereits ein Anschluss vorhanden.\nFgen Sie ggf. Anbauteile manuell ein oder nderen Sie die Reihenfolge der Anschlsse."   "ERR_OrderOfConnections")
	  	(createSteife)
	  )
	  (progn
	  	(createSteife)
	  	(TraegerEnde_Anpassen)
	))
	
	
	
	; TEST
	; ******************************************************************
	(if (= TesteLochbild 2) (progn
		(setq abtlLchb_AT (Traeger.get Tr_ID ABTeil  fllochbild))
		(setq xPos_AT (Anbauteil.get  abtlLchb_AT xPos)) (AlertBox  xPos_AT)
		(setq dv_Abtl_AT (Anbauteil.get  abtlLchb_AT delta_V)) (AlertBox  dv_Abtl_AT)
		(setq dlr_Abtl_AT (Anbauteil.get  abtlLchb_AT delta_LR)) (AlertBox  dlr_Abtl_AT)

		(setq abtlLchb_HT (Traeger.get HTrg ABTeil  fllochbild))
		(setq xPos_HT (Anbauteil.get  abtlLchb_HT xPos)) (AlertBox  xPos_HT)
		(setq dv_Abtl_HT (Anbauteil.get  abtlLchb_HT delta_V)) (AlertBox  dv_Abtl_HT)
		(setq dlr_Abtl_HT (Anbauteil.get  abtlLchb_HT delta_LR)) (AlertBox  dlr_Abtl_HT)
	))
	
	(print "---------------------") (print TesteLochbild)
	(if (= TesteLochbild 1) (progn
	    (Lochbild.set fllochbild 
			(e0 0) (e1 15) (e2 50) 
			(w0 50)
;			(dOK 50)
;			(LB_Art 2) 
;		;	(delta_w 60)
	    )
	    (BerechneLochbild_dOK fllochbild)
	))

;	(Lochbild.set fllochbild_2 
;			(e0 0) (e1 15) (e2 50)
;	)

	
(if (= LB_DEBUG 1) (progn
	(setq lbdummy (Lochbild.create))
	(Lochbild.copy lbdummy fllochbild)
	
	; Anbauteil dem At hinzufgen
	(if (= (Connect.get CastaData amAtOberflansch) 1)
		(traeger.addabtl Tr_ID lbdummy xPos_at 0.0 _flanschlochbild_of_)	
	)
	(if (= (Connect.get CastaData amAtUnterflansch) 1)
		(traeger.addabtl Tr_ID lbdummy xPos_at 0.0 _flanschlochbild_uf_)
	)
	
	
	(setq AT_ABTeil_dummy (Traeger.get Tr_ID AbTeil lbdummy))
	(Anbauteil.set AT_ABTeil_dummy 	(winkel   winkel_abteil_at)
				(delta_lr		delta_lr_abteil_at)
				(Master    1)
	)
	
	(Connect.storeAnschlObjs CastaData lbdummy)
))
	; ******************************************************************
)

(defun cb_Lochbild_$lb (zp)
;(debug on)
    (if (objExist cb_Objekt) (progn
	    (setq Lchb_ID (Anbauteil.get cb_Objekt objekt lochbild))
	    (if (= zp 0) (progn
	    	(setq w0_alt (Lochbild.get Lchb_ID w0))
	    	(setq e0_alt (Lochbild.get Lchb_ID e0))
	    	(setq e1_alt (Lochbild.get Lchb_ID e1))
	    	(setq SB_alt (Lochbild.get Lchb_ID S_Bez))
	    	(setq Gu_alt (Lochbild.get Lchb_ID Guete))
	    ))
	    (if (= zp 1) (progn
	        (setq LchbAbgleich 0)
	    	(setq w0_neu (Lochbild.get Lchb_ID w0))
	    	(setq e0_neu (Lochbild.get Lchb_ID e0))
	    	(setq e1_neu (Lochbild.get Lchb_ID e1))
	    	(setq SB_neu (Lochbild.get Lchb_ID S_Bez))
	    	(setq Gu_neu (Lochbild.get Lchb_ID Guete))
	    	(if (/= w0_alt w0_neu) (progn
		    (setq LchbAbgleich 1)
	    	    (BerechneLochbild_dOK Lchb_ID)
	    	))
	    	(if (/= e0_alt e0_neu) (setq LchbAbgleich 1))
	    	(if (/= e1_alt e1_neu) (setq LchbAbgleich 1))
	    	(if (/= SB_alt SB_neu) (setq LchbAbgleich 1))
	    	(if (/= Gu_alt Gu_neu) (setq LchbAbgleich 1))
	    	
	    	(if (= LchbAbgleich 1) (progn
	    	    (if (objExist fllochbild_2) (progn
	    	        (Lochbild.set fllochbild_2 (w0 w0_neu) (e0 e0_neu) (e1 e1_neu))
	    	        (Lochbild.set fllochbild_2 (S_Bez SB_neu) (Guete Gu_neu))
	    	    	(BerechneLochbild_dOK fllochbild_2)
	    	    ))
	    	))
	    	
	    ))
    ))
;(debug off)
)

(defun cb_Lochbild_2_$lb (zp)
   (if (objExist cb_Objekt) (progn
	    (setq Lchb_ID (Anbauteil.get cb_Objekt objekt lochbild))
	    (if (= zp 0) (progn
	    	(setq w0_alt (Lochbild.get Lchb_ID w0))
	    	(setq e0_alt (Lochbild.get Lchb_ID e0))
	    	(setq e1_alt (Lochbild.get Lchb_ID e1))
	    ))
	    (if (= zp 1) (progn
	        (setq LchbAbgleich 0)
	    	(setq w0_neu (Lochbild.get Lchb_ID w0))
	    	(setq e0_neu (Lochbild.get Lchb_ID e0))
	    	(setq e1_neu (Lochbild.get Lchb_ID e1))
	    	(if (/= w0_alt w0_neu) (progn
		    (setq LchbAbgleich 1)
	    	    (BerechneLochbild_dOK Lchb_ID)
	    	))
	    	(if (/= e0_alt e0_neu) (setq LchbAbgleich 1))
	    	(if (/= e1_alt e1_neu) (setq LchbAbgleich 1))
	    	
	    	(if (= LchbAbgleich 1) (progn
	    	    (if (objExist fllochbild) (progn
	    	        (Lochbild.set fllochbild (w0 w0_neu) (e0 e0_neu) (e1 e1_neu))
	    	    	(BerechneLochbild_dOK fllochbild)
	    	    ))
	    	))
	    	
	    ))
    ))
)

(defun calcAndSetLochbildDaten (Lchb_ID ABST)
	(print ">-----------------------------------------------------------")
	(print "BERECHNE LOCHBILDDATEN")
	(Lochbild.set Lchb_ID (S_Bez 		"M12")
												(Guete   	"4.6")
												(e       	"0 60 0 0 0 0")
												(w       	"80  0")
	)
	
	(setq	t_at 	(Traeger.get Tr_ID t)
		b_at	(Traeger.get Tr_ID b)
		s_at	(Traeger.get Tr_ID s)
		r_at	(Traeger.get Tr_ID r)
	)
	
	(setq	t_ht	(Traeger.get Htrg t)
		b_ht	(Traeger.get Htrg b)
		s_ht	(Traeger.get Htrg s)
		r_ht	(Traeger.get Htrg r)
	)
	
	
	; dxSKopf
	(setq dxSKopf (+ t_at ABST))
	
	(setq abzug_at (+ s_at (* 2 r_at)))
	(setq rest_at (- b_at abzug_at))
	
	(setq abzug_ht (+ s_ht (* 2 r_ht)))
	(setq rest_ht (- b_ht abzug_ht))
		
	(setq e1 (+ (* 0.5 rest_at) abzug_at))
	(print e1)
	(setq e1rund (runde e1 auf 5))
	(print e1rund)
	(setq e0 (- (* 0.5 e1)))
	(print e0)
	(setq e0rund (runde e0 auf 5))
	(print e0rund)
	(setq w0 (+ (* 0.5 rest_ht) abzug_ht))
	(print w0)
	(setq w0rund (runde w0 auf 5))
	(print w0rund)
	
	(Lochbild.set Lchb_ID	(e0				e0)
				(e1				e1)
				;(e2				100)
				(w0				w0) 	
				(klemml 	(+ t_ht t_at ABST))
				(dxSKopf	  dxSKopf)
	)

	; ---- an Trgerenden halbe Lochbilder einbauen mit LB_Art 2 - oder -2
	(setze_LochbildArt Lchb_ID)	

)
(defun createFlanschLochbild (Lchb_ID ABST)
	(print ">-----------------------------------------------------------")
	(print "ERZEUGE LOCHBILD")
	
	(calcAndSetLochbildDaten Lchb_ID ABST)
	
	(setq 	delta_lr_at	(Traeger.get Tr_ID delta_lr)
		delta_v_at	(Traeger.get Tr_ID delta_v)
	)
	
	(setq	delta_lr_ht	(Traeger.get Htrg delta_lr))
	(setq	delta_lr_ht	(* 1.0 delta_lr_ht))
	
	(setq xPos_ht (Connect.get CastaData xPos_ht))
	(setq xPos_at (Connect.get CastaData xPos_at))
	
	(print xPos_ht)
	(print xPos_at)
	
	
		
	; Anbauteil dem Ht hinzufgen
	(if (= (Connect.get CastaData amHtOberflansch) 1)
		(traeger.addabtl Htrg Lchb_ID xPos_ht 0.0 _flanschlochbild_of_)
	)
	(if (= (Connect.get CastaData amHtUnterflansch) 1)
		(traeger.addabtl Htrg Lchb_ID xPos_ht 0.0 _flanschlochbild_uf_)
	)
	
	
	; Anbauteil dem At hinzufgen
	(if (= (Connect.get CastaData amAtOberflansch) 1)
		(traeger.addabtl Tr_ID Lchb_ID xPos_at 0.0 _flanschlochbild_of_)	
	)
	(if (= (Connect.get CastaData amAtUnterflansch) 1)
		(traeger.addabtl Tr_ID Lchb_ID xPos_at 0.0 _flanschlochbild_uf_)
	)
	(if (= (Connect.get CastaData amAtStegLinks) 1)
		(traeger.addabtl Tr_ID Lchb_ID xPos_at 0.0 _steglochbild_)
	)
	(if (= (Connect.get CastaData amAtStegRechts) 1)
		(alertBox "Anschluss ist nicht mglich"  "Connection_Not_Possible")
	)
	
	
	; neue Berechnung des Lochbild HT-Winkels  Sept 2016
	(setq SWinkel (Connect.get CastaData h-atrgewnkl_steg))
	(setq	winkel_abteil_ht 0.0)
	(if (= (Connect.get CastaData at-von-links) 1) 
	    (setq	winkel_abteil_ht	  0.0)
	)
	(if (= (Connect.get CastaData at-von-rechts) 1) 
	    (setq	winkel_abteil_ht	180.0)
	)
	(print SWinkel)
	(print winkel_abteil_ht)
	(setq cos_Wn_HT (cos (/ (* PI winkel_abteil_ht) 180.0)))
	(setq sin_Wn_HT (sin (/ (* PI winkel_abteil_ht) 180.0)))
	(setq tan_Wn_HT (tan (/ (* PI winkel_abteil_ht) 180.0)))
	
	(setq delta_lr_ht_S 0.0)
	(if (/= delta_lr_ht 0.0) (progn
	    (setq  delta_lr_ht_S (*    sin_Wn_HT delta_lr_ht))
	))

	(setq  gWnkl___0     0.0)
	(setq  gWnkl_180  180.0)

	; Anbauteil-Winkel AT
	; --------------------------
	; am AT Flansch
	(if (= (Connect.get CastaData amATFlansch) 1) (progn
		;; berarbeitung 2016
		(setq gWnkl		(Connect.get CastaData r-atrgewnkl_flansch))
		; (setq gWnkl		(Connect.get CastaData afl_hwinkel))

		(if (= (Connect.get CastaData at-von-rechts)	1) (progn
			(setq gWnkl_180		(- 180.0   gWnkl))
			(setq gWnkl___0		(- 180.0   gWnkl))
		))
		(if (= (Connect.get CastaData at-von-links)	1) (progn
			(setq gWnkl___0		   gWnkl)
			(setq gWnkl_180		   gWnkl)
		))

		; (if (> gWnkl_180 360.0) (setq gWnkl_180 (- gWnkl_180 360.0)))

		(if (= (Connect.get CastaData amHtOberflansch)	1) (progn
			(if (= (Connect.get CastaData amATOberflansch) 1) (progn
				(if (= (Connect.get CastaData satr-lhtr)  1)	(setq winkel_abteil_at 270.0)	)
				(if (= (Connect.get CastaData satr-lhtr) -1)	(setq winkel_abteil_at 270.0)	)
			))
			(if (= (Connect.get CastaData amATUnterflansch) 1) (progn
				(if (= (Connect.get CastaData satr-lhtr)  1)	(setq winkel_abteil_at gWnkl___0))
				(if (= (Connect.get CastaData satr-lhtr) -1)	(setq winkel_abteil_at gWnkl___0));
			))
		))
		(if (= (Connect.get CastaData amHtUnterflansch)	1) (progn
			(if (= (Connect.get CastaData amATOberflansch) 1) (progn
				(if (= (Connect.get CastaData satr-lhtr)  1)	(setq winkel_abteil_at gWnkl___0))
				(if (= (Connect.get CastaData satr-lhtr) -1)	(setq winkel_abteil_at gWnkl___0));
			))
			(if (= (Connect.get CastaData amATUnterflansch) 1) (progn
				(if (= (Connect.get CastaData satr-lhtr)  1)	(setq winkel_abteil_at 270.0)	)
				(if (= (Connect.get CastaData satr-lhtr) -1)	(setq winkel_abteil_at 270.0)	)
			))
		))
	))
	; am AT Steg
	(if (= (Connect.get CastaData amATSteg) 1)
		(progn
			(setq winkel_abteil_at 0.0)
		)
	)
	
	(setq delta_v_abteil_ht  0.0)
	(setq delta_lr_abteil_at 0.0)
	
	; Positionierung Anbauteil HT an AT (nur wenn am AT-Steg)
	; --------------------------
	(if (= (Connect.get CastaData amATSteg) 1)
		(progn
			(setq h_at (Traeger.get Tr_ID h))
			(setq delta_v_abteil_ht (- delta_v_abteil_ht (* 0.5 h_at)))
		)
	)
	
	
	; Anbauteil delta_v HT
	; --------------------------
	(setq Alfa     (- 180.0 winkel_abteil_at))
	(setq Alfa     winkel_abteil_at)
	(setq sinAlfa  (sin (/ (* PI Alfa) 180.0)))
	(if (< sinAlfa 0.001) (if (> sinAlfa -0.001) (setq sinAlfa 1.0)))
	(setq cosAlfa  (cos (/ (* PI Alfa) 180.0)))
	(setq tanAlfa  (tan (/ (* PI Alfa) 180.0)))
;	(if (< sinAlfa 0.001) (if (> sinAlfa -0.001) (setq sinAlfa 1.0)))


	(setq dlr_AT (/ (* 1.0 delta_lr_at) sinAlfa))

	(if (= (Connect.get CastaData amATFlansch) 1) (progn
	    (if (= (Connect.get CastaData vatr-vhtr) -1) (progn
		(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta_v_abteil_ht (+ delta_v_abteil_ht delta_lr_at))	)
		(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta_v_abteil_ht (+ delta_v_abteil_ht delta_lr_at))	)
	    ))
	    (if (= (Connect.get CastaData vatr-vhtr)  1) (progn
		(setq delta_v_abteil_ht (- delta_v_abteil_ht dlr_AT))
	    ))
	))
	(if (= (Connect.get CastaData amATSteg) 1)
		(progn
			(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_v_abteil_ht (+ delta_v_abteil_ht delta_v_at))	)
			(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_v_abteil_ht (+ delta_v_abteil_ht delta_v_at))	)
		)
	)

;	(setq delta_v_abteil_ht dlr_AT)
;	(setq delta_v_abteil_ht -115)

;	(setq delta_v_abteil_ht (+ delta_v_abteil_ht delta_lr_ht_S))
;	(setq delta_v_abteil_ht (- delta_v_abteil_ht))

	; Anbauteil delta_lr AT
	; --------------------------
	(if (= (Connect.get CastaData amATFlansch) 1)
		(progn
			(if (= (Connect.get CastaData vatr-vhtr)  1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta_lr_abteil_at (+ delta_lr_abteil_at delta_lr_ht))	)
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta_lr_abteil_at (- delta_lr_abteil_at delta_lr_ht))	)
				)
			)
			(if (= (Connect.get CastaData vatr-vhtr) -1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta_lr_abteil_at (- delta_lr_abteil_at delta_lr_ht))	)
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta_lr_abteil_at (+ delta_lr_abteil_at delta_lr_ht)) )
				)
			)
		)
	)
	(if (= (Connect.get CastaData amATSteg) 1)
		(progn
			(if (= (Connect.get CastaData amHtOberflansch) 1)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_lr_abteil_at (+ delta_lr_abteil_at delta_lr_ht))	)
					(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_lr_abteil_at (- delta_lr_abteil_at delta_lr_ht))	)
				)
			)
			(if (= (Connect.get CastaData amHtUnterflansch) 1)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_lr_abteil_at (- delta_lr_abteil_at delta_lr_ht))	)
					(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_lr_abteil_at (+ delta_lr_abteil_at delta_lr_ht))	)
				)
			)
		)
	)
	
	
	(setq delta_lr_abteil_at (*     1.0 delta_lr_at cosAlfa))

	(setq  delta_v_abteil_at 0.0)
	(if (/=  tanAlfa 0.0)  (setq delta_v_abteil_at  (/ (* -1.0 delta_lr_abteil_at)  tanAlfa)))
	
	; Wenn Haupttrger seitlich verschoben ist, dann hier noch anpassen
	(if (/= delta_lr_HT 0.0) (progn
	    ; Lochbildverschiebung am Haupttrger ...
	    (if (= (Connect.get CastaData satr-lhtr) -1) (progn
		(setq delta_v_abteil_ht (+ delta_v_abteil_ht (/ delta_lr_HT tanAlfa)))
	    ))
	    (if (= (Connect.get CastaData satr-lhtr)  1) (progn
		(setq delta_v_abteil_ht (- delta_v_abteil_ht (/ delta_lr_HT tanAlfa)))
	    ))

	    ; Lochbildverschiebung am Anschlusstrger ...
	    (if (= (Connect.get CastaData satr-lhtr) -1) (progn
		(setq delta_lr_abteil_at (- delta_lr_abteil_at delta_lr_HT))
		(setq delta_v_abteil_at  (+ delta_v_abteil_at  (/ delta_lr_HT tanAlfa)))
	    ))
	    (if (= (Connect.get CastaData satr-lhtr)  1) (progn
		(setq delta_lr_abteil_at (+ delta_lr_abteil_at delta_lr_HT))
		(setq delta_v_abteil_at  (- delta_v_abteil_at  (/ delta_lr_HT tanAlfa)))
	    ))

	))

;	(setq delta_lr_abteil_at 0.0)
;	(setq delta_v_abteil_at  0.0)


	(print "-------------------------------- +++ --------------------------------")
	(print delta_v_abteil_ht)
	(print delta_lr_abteil_at)
	(print delta_v_abteil_at)
	
	(print winkel_abteil_ht)
	(print winkel_abteil_at)
	; HT-Anbauteil Werte setzen


	(setq HT_ABTeil (Traeger.get Htrg AbTeil Lchb_ID))
	
	(Anbauteil.set HT_ABTeil 	(winkel   winkel_abteil_ht)
					(Master   0)
					(delta_v  delta_v_abteil_ht)
	)
	(print "-------------------------------- --- --------------------------------")
	
	
	; AT-Anbauteil Werte setzen
	(setq AT_ABTeil (Traeger.get Tr_ID AbTeil Lchb_ID))
	
	(Anbauteil.set AT_ABTeil 	(winkel  		winkel_abteil_at)
					(delta_lr		delta_lr_abteil_at)
					(delta_v		delta_v_abteil_at)
				 	(Master     1)
	)
	(if (= (Connect.get CastaData amAtSteg) 1)
		(progn
			(Anbauteil.set AT_ABTeil 	(winkel  	winkel_abteil_at)
							(delta_lr	delta_lr_abteil_at)
				 			(Master   0)
			)
		)
	)

;	(if (= (Connect.get CastaData vatr-vhtr) -1)	(Anbauteil.set AT_ABTeil 	(SeitRicht  -1)))
	
	(Anbauteil.set AT_ABTeil 	(SeitRicht  1))

	(if (= (Connect.get CastaData amATFlansch) 1) (progn
		(if (= (Connect.get CastaData vatr-vhtr) -1) (Anbauteil.set AT_ABTeil 	(SeitRicht  -1)))
	))



)




(defun calcLichtenAbst ()
	(print ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>")
	(print "BERECHNE LICHTEN ABSTAND DER TRGER")
	(setq	delta_v_at 	(Traeger.get Tr_ID delta_v)
		h_at		(Traeger.get Tr_ID h)
	)
	
	(setq	delta_v_ht	(Traeger.get Htrg delta_v)
		h_ht		(Traeger.get Htrg h)
	)
	
	(setq h_at_halb	(* 0.5 h_at))
	(setq h_ht_halb	(* 0.5 h_ht))
	
	
	(print delta_v_ht)
	(print h_ht_halb)
	(print delta_v_at)
	(print h_at_halb)
	
	(setq pos_ht 0.0)
	(setq pos_at 0.0)
	
	(if (= (Connect.get CastaData amHtOberflansch) 1)		(setq pos_ht (- delta_v_ht h_ht_halb)))
	(if (= (Connect.get CastaData amHtUnterflansch) 1)	(setq pos_ht (+ delta_v_ht h_ht_halb)))
	
	(if (= (Connect.get CastaData amHtOberflansch) 1)
		(progn
			(if (= (Connect.get CastaData amAtOberflansch) 1)		(setq pos_at	(- (- delta_v_at h_at_halb)))	)
			(if (= (Connect.get CastaData amAtUnterflansch) 1)	(setq pos_at	(+ delta_v_at h_at_halb))	)
		)
	)
	(if (= (Connect.get CastaData amHtUnterflansch) 1)
		(progn
			(if (= (Connect.get CastaData amAtOberflansch) 1)		(setq pos_at	(- delta_v_at h_at_halb))	)
			(if (= (Connect.get CastaData amAtUnterflansch) 1)	(setq pos_at	(- (- delta_v_at) h_at_halb))	)
		)
	)
	
	
	(print pos_ht)
	(print pos_at)
	
	(setq lichterAbst 0.0)
	
	(if (/= pos_at pos_ht)
		(setq lichterAbst (- pos_at pos_ht))
	)
	
	(print lichterAbst)
	
	(if (< lichterAbst 0.0)
		(setq lichterAbst (- lichterAbst))
	)
	(print lichterAbst)
	(print "<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<")
)




(defun calcFutterBlech (BLECH_ID ABST)
	(print ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>")
	(print "BERECHNE FUTTERBLECHDATEN")
	(setq b_at		(Traeger.get Tr_ID b))
	
	(setq b_ht		(Traeger.get Htrg b)
				s_ht		(Traeger.get Htrg s)
	)
	
	
	
	; Futterblechdicke
	(setq dp_futter ABST)
	
	; Breite
	(setq bp_futter b_at)
	
	; Hhe
	(if (= (Connect.get CastaData anschlZwAtEnden) 0)
		(progn
			(setq hp_futter (- (* 0.5 b_ht) (* 0.5 s_ht)))
		)
		(progn
			(setq hp_futter b_ht)
		)
	)
	
	(Blech.set BLECH_ID (hp hp_futter)
											(bp bp_futter)
											(dp dp_futter)
	)
	
	
	(print "<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<")
)



(defun createFutterBlech (BLECH_ID ABST)
	(print ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>")
	(print "ERZEUGE FUTTERBLECH")
	(calcFutterBlech BLECH_ID ABST)
	
	(setq delta_lr_ht 	(Traeger.get Htrg delta_lr)
				s_ht					(Traeger.get Htrg s)
	)
	
	(setq xPos_at	(Connect.get CastaData xPos_at))
	
	(setq hp_futter (Blech.get BLECH_ID hp))
	
	; Beim Anschluss mit AT-Enden
	(if (= (Connect.get CastaData anschlZwAtEnden) 0)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq xPos_at (+ xPos_at (* 0.5 hp_futter) (* 0.5 s_ht))))
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq xPos_at (+ xPos_at (* 0.5 hp_futter) (* 0.5 s_ht))))
				)
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq xPos_at (- xPos_at (* 0.5 hp_futter) (* 0.5 s_ht))))
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq xPos_at (- xPos_at (* 0.5 hp_futter) (* 0.5 s_ht))))
				)
			)
		)
	)
	
	; Anteil delta_lr HT
	(if (= (Connect.get CastaData amHtOberflansch) 1)
		(progn
			(if (= (Connect.get CastaData amAtOberflansch) 1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq xPos_at (+ xPos_at delta_lr_ht)))
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq xPos_at (- xPos_at delta_lr_ht)))
				)
			)
			(if (= (Connect.get CastaData amAtUnterflansch) 1)	
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq xPos_at (- xPos_at delta_lr_ht)))
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq xPos_at (+ xPos_at delta_lr_ht)))
				)
			)
		)
	)
	(if (= (Connect.get CastaData amHtUnterflansch) 1)
		(progn
			(if (= (Connect.get CastaData amAtOberflansch) 1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq xPos_at (- xPos_at delta_lr_ht)))
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq xPos_at (+ xPos_at delta_lr_ht)))
				)
			)
			(if (= (Connect.get CastaData amAtUnterflansch) 1)	
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq xPos_at (+ xPos_at delta_lr_ht)))
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq xPos_at (- xPos_at delta_lr_ht)))
				)
			)
		)
	)
	;(if (= (Connect.get CastaData satr-lhtr)  1)	(setq xPos_at (- xPos_at delta_lr_ht)))
	;(if (= (Connect.get CastaData satr-lhtr) -1)	(setq xPos_at (+ xPos_at delta_lr_ht)))
		
		
	(if (= (Connect.get CastaData amATUnterflansch) 1)	(Traeger.addabtl Tr_ID BLECH_ID xPos_at 0.0 _lasche_uf_))
	(if (= (Connect.get CastaData amATOberflansch) 1)	(Traeger.addabtl Tr_ID BLECH_ID xPos_at 0.0 _lasche_of_))
	(print "<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<")
)


; ====================================================================== */
(defun createSteife ()
	(print ">-----------------------------------------------------------")
	(print "ERZEUGE STEIFE")
	(setq hProf    (Traeger.get  Tr_Id h)
	      sProf    (Traeger.get  Tr_Id s)
	      dV       (Traeger.get  Tr_Id delta_lr)
	      hStz     (Traeger.get  HTrg  h)
	      VWnkl    (connect.get CastaData hpttrg_vwinkel)
	)
	
	(setq dp sProf)
	(setq dp (runde dp auf 5))
	
	;; ...................................  Orientierung ermitteln
	;(setq UZ_HWinkel   (connect.get CastaData HptTrg_HWinkel)
	;      Stz_RotaWnkl (Traeger.get Tr_ID  R_Winkel)
	;      Stz_RotaWnkl (- 360.0 Stz_RotaWnkl)
	 ;     Stz_RotaWnkl (- Stz_RotaWnkl 90.0)
	;)
	;(if (< Stz_RotaWnkl 0.0) (setq Stz_RotaWnkl (+ Stz_RotaWnkl 360.0)))
  ;(setq diffWinkel (- UZ_HWinkel Stz_RotaWnkl))
  ;(print diffWinkel)
  ;(if (= diffWinkel -270.0) (setq dV (- dV)))
  ;(if (= diffWinkel  270.0) (setq dV (- dV)))
  ;(if (= diffWinkel   90.0) (setq dV (- dV)))
	;; ...................................  Orientierung bercksichtigt


	(setq cosAlfa (cos (/ (* PI VWnkl) 180.0)))
	(if (/= cosAlfa 0.0) (setq dV (/ dV cosAlfa)))

  (setq xPos (connect.get CastaData xPos_HT))
  
  ;(setq xPos_Steife  (+ xPos (* 0.5 (- hProf sProf)) (- dV)))
	(setq xPos_Steife  xPos)
	
	(if (= (Connect.get CastaData satr-lhtr)  1)	(setq xPos_Steife  (+ xPos_Steife dV)))
	(if (= (Connect.get CastaData satr-lhtr) -1)	(setq xPos_Steife  (- xPos_Steife dV)))

	

	


	(setq blSteifeOben (blech.create))
	(Connect.storeAnschlObjs CastaData blSteifeOben)
	(traeger.addabtl Htrg blSteifeOben 0.0 0.0 _vollsteife_beids_) ;1539
	(setq AbtlSteife_1 (traeger.get Htrg ABTeil blSteifeOben))
	(Anbauteil.set  AbtlSteife_1 (xpos xPos_Steife))

	
	;(if (/= VWnkl 0.0) (progn
	;    (print "*** Anbauteil setze Winkel: ") (print VWnkl)
	;    (if (= (connect.get CastaData amHtUnterFlansch) 1) (progn
	;        (print "****** amHtUnterFlansch ") (print VWnkl)
	;        (Anbauteil.set  AbtlSteife_1 (Winkel (- VWnkl)))
	;    ))
	;    (if (= (connect.get CastaData amHtOberFlansch) 1) (progn
	;        (print "****** amHtOberFlansch ") (print VWnkl)
	;        (Anbauteil.set  AbtlSteife_1 (Winkel VWnkl))
	;    ))
	;    (if (= (connect.get CastaData anHtRechtesEnde) 1) (progn
	;        (print "****** anHtRechtesEnde ") (print VWnkl)
  ;              (setq xPosOben  (- xPosOben  xPos_H))
	;	(Anbauteil.set  AbtlSteife_1 (xpos xPosOben))
	;    ))
	;))


	(Traeger.updvollstf Htrg)
	(print "<-----------------------------------------------------------")
)
(defun TraegerEnde_Anpassen ()
	(setq ChangeEnde 0)
	(setq gWnkl___0		(Connect.get CastaData h-atrgewnkl_steg))
	(setq gWnkl_180		(+ gWnkl___0 180.0))
	(if (> gWnkl_180 360.0) (setq gWnkl_180 (- gWnkl_180 360.0)))
	
	(setq 	b_HT 	(Traeger.get HTrg b)
		dlr_HT	(Traeger.get HTrg delta_LR)
	)

	(if (= (Connect.get CastaData linkesEnde)  1) (progn
		(setq ChangeEnde 1)
		(setq TrgEnde (Traeger.get Tr_ID links))
	))
	(if (= (Connect.get CastaData rechtesEnde) 1) (progn
		(setq ChangeEnde 1)
		(setq TrgEnde (Traeger.get Tr_ID rechts))
	))
	
	(if (= ChangeEnde 1) (progn
		(setq EWnkl (TrEnde.get TrgEnde H_Winkel))
		(if (= gWnkl___0 90.0) (setq ChangeEnde 0))
;		(if (/= EWnkl 90.0)    (setq ChangeEnde 0))
	))
	
	(if (= ChangeEnde 1) (progn
		(setq bTrimVal (* -0.5 b_HT))
		
		(if (= (Connect.get CastaData satr-lhtr)  1)	(setq bTrimVal (+ bTrimVal dlr_HT)))
		(if (= (Connect.get CastaData satr-lhtr) -1)	(setq bTrimVal (- bTrimVal dlr_HT)))
		(TrEnde.set TrgEnde (H_Winkel gWnkl___0))
		(TrEnde.set TrgEnde (delta_L 0))
		(trEnde.pTrim TrgEnde bTrimVal)
	))	
	
)
(defun BerechneLochbild_dOK (Lchb_ID)

(debug on)
	(setq abtl_LB_AT (Traeger.get Tr_ID AbTeil Lchb_ID))
	(setq hWnkl (Anbauteil.get abtl_LB_AT Winkel))
	(if (> hWnkl 180.0) (setq hWnkl (- hWnkl 360.0)))
	(setq  wnklDiff (+ 90.0 hWnkl))
	(setq tanW (tan (* PI (/ wnklDiff 180.0))))
	
	(setq w0 (Lochbild.get Lchb_ID w0))
	(setq LB_dOK (* (* 1.0 w0) tanW))
	
	(setq b_AT (Traeger.get Tr_ID b))
	(if (< LB_dOK b_AT) (if (> LB_dOK (- b_AT)) (progn

		(setq hWTest (Anbauteil.get abtl_LB_AT Winkel))
		(setq lbArt  (Lochbild.get Lchb_ID LB_Art))

		(if (= lbArt -2) (setq LB_dOK (- LB_dOK)))

	;	(if (= (Connect.get CastaData at-von-rechts) 1) (progn
	;		(if (= lbArt -2) (setq LB_dOK (- LB_dOK)))
	;	))
	;	(if (= (Connect.get CastaData at-von-links) 1) (progn
	;		(if (= lbArt -2) (setq LB_dOK (- LB_dOK)))
	;	))
		(Lochbild.set  Lchb_ID (dOK LB_dOK))
	
	)))
(debug off)

)


(defun setze_LochbildArt (Lchb_ID)
	
	(if (= (Connect.get CastaData amHtOberflansch) 1) (progn
		(if (= (Connect.get CastaData amAtUnterflansch) 1) (progn
			(if (= (Connect.get CastaData at-von-links)   1) (Lochbild.set Lchb_ID (Lb_Art -2)))
			(if (= (Connect.get CastaData at-von-rechts)  1) (Lochbild.set Lchb_ID (Lb_Art  2)))
		))
	))
	(if (= (Connect.get CastaData amHtUnterflansch) 1) (progn
		(if (= (Connect.get CastaData amAtOberflansch) 1) (progn
			(if (= (Connect.get CastaData at-von-links)   1) (Lochbild.set Lchb_ID (Lb_Art -2)))
			(if (= (Connect.get CastaData at-von-rechts)  1) (Lochbild.set Lchb_ID (Lb_Art  2)))
		))
	))
	
	(setq lb_art (Lochbild.get Lchb_ID Lb_Art))
	(print lb_art)
	(print "<-----------------------------------------------------------")
)
