; $	HT	QT(IU)		AF(FS)		P(ZE)
; $	AT	QT(IU)		AF(F)		P(ZE)
; $ 	AE	V(0)		H(90)		R(-)

(defun load-modules ()
	(load "mod-endinit-trg-auf-trg")
)

(defun init-connection ()
	
	(connect.showattributes CastaData)
	(setq LB_DEBUG 0)
	
	
	(if (= (Connect.get CastaData vatr-vhtr) 1)
		(progn
			(init-traegerenden)
			(setConnection)
		)
		(progn
;			(alertbox "Der Anschluss ist in dieser Konstellation nicht mglich.\nBitte stellen Sie sicher, dass die lokale Vertikalrichtung der Trger identisch ist." "WRN_LocalVertDir")
			(init-traegerenden)
			(setConnection)
		)
	)
	
)


(defun setConnection ()
	
	(calcLichtenAbst) ; -> lichterAbst
	
	(if (> lichterAbst 2.0)
		(progn
			(setq futterBlech (Blech.create))
			(Connect.storeAnschlObjs CastaData futterBlech)
			(print "FutterBlech-Objekt wurde erzeugt!")
			
			(createFutterBlech futterBlech lichterAbst)
		)
	)
	
	(setq fllochbild (Lochbild.create))
	(Connect.storeAnschlObjs CastaData fllochbild)
	
	(createFlanschLochbild fllochbild lichterAbst)
	
	
	; ******************************************
	; TEST FR MEHRFACHANSCHLUSS (FLANSCHSEITE)
	; ******************************************
	(setq anzAnschl (Connect.get CastaData anz_weitere_anschl))
	(print anzAnschl)
	  
	(if (/= anzAnschl 0)
	  (progn
	  	(alertBox "An dem Knoten ist bereits ein Anschluss vorhanden.\nFgen Sie ggf. Anbauteile manuell ein oder nderen Sie die Reihenfolge der Anschlsse."    "ERR_OrderOfConnections")
	  	(createSteife)
	  )
	  (progn
	  	(createSteife)
	  )
	)
	
	
	
	; TEST
	; ******************************************************************
	; (Lochbild.set fllochbild (e0 0) (e1 15) (e2 50) (w0 60) (LB_Art 2) (delta_w 60))
	
(if (= LB_DEBUG 1) (progn
	(setq lbdummy (Lochbild.create))
	(Lochbild.copy lbdummy fllochbild)
	
	; Anbauteil dem At hinzufgen
	(if (= (Connect.get CastaData amAtOberflansch) 1)
		(traeger.addabtl Tr_ID lbdummy xPos_at 0.0 _flanschlochbild_of_)	
	)
	(if (= (Connect.get CastaData amAtUnterflansch) 1)
		(traeger.addabtl Tr_ID lbdummy xPos_at 0.0 _flanschlochbild_uf_)
	)
	
	
	(setq AT_ABTeil_dummy (Traeger.get Tr_ID AbTeil lbdummy))
	(Anbauteil.set AT_ABTeil_dummy 	(winkel   winkel_abteil_at)
																	(delta_lr		delta_lr_abteil_at)
				 													(Master    1)
	)
	
	(Connect.storeAnschlObjs CastaData lbdummy)
))
	; ******************************************************************
)



(defun calcAndSetLochbildDaten (Lchb_ID ABST)
	(print ">-----------------------------------------------------------")
	(print "BERECHNE LOCHBILDDATEN")
	(Lochbild.set Lchb_ID (S_Bez 		"M12")
												(Guete   	"4.6")
												(e       	"0 60 0 0 0 0")
												(w       	"80  0")
	)
	
	(setq t_at 	(Traeger.get Tr_ID t)
				b_at	(Traeger.get Tr_ID b)
				s_at	(Traeger.get Tr_ID s)
				r_at	(Traeger.get Tr_ID r)
	)
	
	(setq t_ht	(Traeger.get Htrg t)
				b_ht	(Traeger.get Htrg b)
				s_ht	(Traeger.get Htrg s)
				r_ht	(Traeger.get Htrg r)
	)
	
	
	; dxSKopf
	(setq dxSKopf (+ t_at ABST))
	
	(setq abzug_at (+ s_at (* 2 r_at)))
	(setq rest_at (- b_at abzug_at))
	
	(setq abzug_ht (+ s_ht (* 2 r_ht)))
	(setq rest_ht (- b_ht abzug_ht))
		
	(setq e1 (+ (* 0.5 rest_at) abzug_at))
	(print e1)
	(setq e1rund (runde e1 auf 5))
	(print e1rund)
	(setq e0 (- (* 0.5 e1)))
	(print e0)
	(setq e0rund (runde e0 auf 5))
	(print e0rund)
	(setq w0 (+ (* 0.5 rest_ht) abzug_ht))
	(print w0)
	(setq w0rund (runde w0 auf 5))
	(print w0rund)
	
	(Lochbild.set Lchb_ID	(e0				e0)
												(e1				e1)
												;(e2				100)
												(w0				w0) 	
												(klemml 	(+ t_ht t_at ABST))
												(dxSKopf  dxSKopf)
	)
	
	; ---- an Trgerenden halbe Lochbilder einbauen mit LB_Art 2 - oder -2
	(if (= (Connect.get CastaData amHtOberflansch) 1)
		(progn
			(if (= (Connect.get CastaData amAtOberflansch) 1) (progn
					(if (= (Connect.get CastaData linkesEnde)  1) (Lochbild.set Lchb_ID (Lb_Art  -2)))
					(if (= (Connect.get CastaData rechtesEnde) 1) (Lochbild.set Lchb_ID (Lb_Art   2)))
			))
			(if (= (Connect.get CastaData amAtUnterflansch) 1) (progn
					(if (= (Connect.get CastaData linkesEnde)  1) (Lochbild.set Lchb_ID (Lb_Art   2)))
					(if (= (Connect.get CastaData rechtesEnde) 1) (Lochbild.set Lchb_ID (Lb_Art  -2)))
			))
		)
	)
	(if (= (Connect.get CastaData amHtUnterflansch) 1)
		(progn
			(if (= (Connect.get CastaData amAtOberflansch) 1) (progn
					(if (= (Connect.get CastaData linkesEnde)  1) (Lochbild.set Lchb_ID (Lb_Art   2)))
					(if (= (Connect.get CastaData rechtesEnde) 1) (Lochbild.set Lchb_ID (Lb_Art  -2)))
			))
			(if (= (Connect.get CastaData amAtUnterflansch) 1) (progn
					(if (= (Connect.get CastaData linkesEnde)  1) (Lochbild.set Lchb_ID (Lb_Art -2)))
					(if (= (Connect.get CastaData rechtesEnde) 1) (Lochbild.set Lchb_ID (Lb_Art  2)))
			))
		)
	)
	
	
	(setq lb_art (Lochbild.get Lchb_ID Lb_Art))
	(print lb_art)
	(print "<-----------------------------------------------------------")
)


(defun createFlanschLochbild (Lchb_ID ABST)
	(print ">-----------------------------------------------------------")
	(print "ERZEUGE LOCHBILD")
	
	(calcAndSetLochbildDaten Lchb_ID ABST)
	
	(setq 	delta_lr_at	(Traeger.get Tr_ID delta_lr)
		delta_v_at	(Traeger.get Tr_ID delta_v)
	)
	
	(setq delta_lr_ht (Traeger.get Htrg delta_lr))
	
	(setq xPos_ht (Connect.get CastaData xPos_ht))
	(setq xPos_at (Connect.get CastaData xPos_at))
	
	(print xPos_ht)
	(print xPos_at)
	
	
		
	; Anbauteil dem Ht hinzufgen
	(if (= (Connect.get CastaData amHtOberflansch) 1)
		(traeger.addabtl Htrg Lchb_ID xPos_ht 0.0 _flanschlochbild_of_)
	)
	(if (= (Connect.get CastaData amHtUnterflansch) 1)
		(traeger.addabtl Htrg Lchb_ID xPos_ht 0.0 _flanschlochbild_uf_)
	)
	
	
	; Anbauteil dem At hinzufgen
	(if (= (Connect.get CastaData amAtOberflansch) 1)
		(traeger.addabtl Tr_ID Lchb_ID xPos_at 0.0 _flanschlochbild_of_)	
	)
	(if (= (Connect.get CastaData amAtUnterflansch) 1)
		(traeger.addabtl Tr_ID Lchb_ID xPos_at 0.0 _flanschlochbild_uf_)
	)
	(if (= (Connect.get CastaData amAtStegLinks) 1)
		(traeger.addabtl Tr_ID Lchb_ID xPos_at 0.0 _steglochbild_)
	)
	(if (= (Connect.get CastaData amAtStegRechts) 1)
		(alertBox "Anschluss ist nicht mglich" "Connection_Not_Possible")
	)
	
	

	; Anbauteil-Winkel AT
	; --------------------------
	; am AT Flansch
	(if (= (Connect.get CastaData amATFlansch) 1)
		(progn
			(if (= (Connect.get CastaData amHtOberflansch)	1)
				(progn
					(if (= (Connect.get CastaData amATOberflansch) 1)
						(progn
							(if (= (Connect.get CastaData satr-lhtr)  1)	(setq winkel_abteil_at 270.0)	)
							(if (= (Connect.get CastaData satr-lhtr) -1)	(setq winkel_abteil_at 270.0)	)
						)
					)
					(if (= (Connect.get CastaData amATUnterflansch) 1)
						(progn
							(if (= (Connect.get CastaData satr-lhtr)  1)	(setq winkel_abteil_at 270.0)	)
							(if (= (Connect.get CastaData satr-lhtr) -1)	(setq winkel_abteil_at 270.0)	);
						)
					)
				)
			)
			(if (= (Connect.get CastaData amHtUnterflansch)	1)
				(progn
					(if (= (Connect.get CastaData amATOberflansch) 1)
						(progn
							(if (= (Connect.get CastaData satr-lhtr)  1)	(setq winkel_abteil_at 270.0)	)
							(if (= (Connect.get CastaData satr-lhtr) -1)	(setq winkel_abteil_at 270.0)	);
						)
					)
					(if (= (Connect.get CastaData amATUnterflansch) 1)
						(progn
							(if (= (Connect.get CastaData satr-lhtr)  1)	(setq winkel_abteil_at 270.0)	)
							(if (= (Connect.get CastaData satr-lhtr) -1)	(setq winkel_abteil_at 270.0)	)
						)
					)
				)
			)
		)
	)
	; am AT Steg
	(if (= (Connect.get CastaData amATSteg) 1)
		(progn
			(setq winkel_abteil_at 0.0)
		)
	)
	
	; Anbauteil-Winkel HT
	; --------------------------
	; am AT Flansch
	(if (= (Connect.get CastaData amATFlansch) 1)
		(progn
			(if (= (Connect.get CastaData satr-lhtr) -1)	(setq winkel_abteil_ht 180.0)	)
			(if (= (Connect.get CastaData satr-lhtr)  1)	(setq winkel_abteil_ht 0.0)		)
		)
	)
	; am AT Steg
	(if (= (Connect.get CastaData amATSteg) 1)
		(progn
			(if (= (Connect.get CastaData amHtOberflansch) 1)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq winkel_abteil_ht 180.0)	)
					(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq winkel_abteil_ht 0.0)		)
				)
			)
			(if (= (Connect.get CastaData amHtUnterflansch) 1)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq winkel_abteil_ht 180.0)	)
					(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq winkel_abteil_ht 0.0)		)
				)
			)
		)
	)
	
	
	(setq delta_v_abteil_ht 0.0)
	(setq delta_lr_abteil_at 0.0)
	
	; Positionierung Anbauteil HT an AT (nur wenn am AT-Steg)
	; --------------------------
	(if (= (Connect.get CastaData amATSteg) 1)
		(progn
			(setq h_at (Traeger.get Tr_ID h))
			(setq delta_v_abteil_ht (- delta_v_abteil_ht (* 0.5 h_at)))
		)
	)
	
	
	; Anbauteil delta_v HT
	; --------------------------
	(if (= (Connect.get CastaData amATFlansch) 1)
		(progn
			(if (= (Connect.get CastaData vatr-vhtr) -1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta_v_abteil_ht (+ delta_v_abteil_ht delta_lr_at))	)
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta_v_abteil_ht (+ delta_v_abteil_ht delta_lr_at))	)
				)
			)
			(if (= (Connect.get CastaData vatr-vhtr)  1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta_v_abteil_ht (+ delta_v_abteil_ht delta_lr_at))	)
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta_v_abteil_ht (+ delta_v_abteil_ht delta_lr_at))	)
				)
			)
		)
	)
	(if (= (Connect.get CastaData amATSteg) 1)
		(progn
			(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_v_abteil_ht (+ delta_v_abteil_ht delta_v_at))	)
			(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_v_abteil_ht (+ delta_v_abteil_ht delta_v_at))	)
		)
	)
	

	; Anbauteil delta_lr AT
	; --------------------------
	(if (= (Connect.get CastaData amATFlansch) 1)
		(progn
			(if (= (Connect.get CastaData vatr-vhtr)  1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta_lr_abteil_at (+ delta_lr_abteil_at delta_lr_ht))	)
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta_lr_abteil_at (- delta_lr_abteil_at delta_lr_ht))	)
				)
			)
			(if (= (Connect.get CastaData vatr-vhtr) -1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta_lr_abteil_at (- delta_lr_abteil_at delta_lr_ht))	)
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta_lr_abteil_at (+ delta_lr_abteil_at delta_lr_ht)) )
				)
			)
		)
	)
	(if (= (Connect.get CastaData amATSteg) 1)
		(progn
			(if (= (Connect.get CastaData amHtOberflansch) 1)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_lr_abteil_at (+ delta_lr_abteil_at delta_lr_ht))	)
					(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_lr_abteil_at (- delta_lr_abteil_at delta_lr_ht))	)
				)
			)
			(if (= (Connect.get CastaData amHtUnterflansch) 1)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_lr_abteil_at (- delta_lr_abteil_at delta_lr_ht))	)
					(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_lr_abteil_at (+ delta_lr_abteil_at delta_lr_ht))	)
				)
			)
		)
	)

	(print delta_v_abteil_ht)
	(print delta_lr_abteil_at)
	
	(print winkel_abteil_ht)
	(print winkel_abteil_at)
	; HT-Anbauteil Werte setzen
	(setq HT_ABTeil (Traeger.get Htrg AbTeil Lchb_ID))
	
	(Anbauteil.set HT_ABTeil 	(winkel   winkel_abteil_ht)
				 										(Master   1)
				 										(delta_v 	delta_v_abteil_ht)
	)
	
	
	; AT-Anbauteil Werte setzen
	(setq AT_ABTeil (Traeger.get Tr_ID AbTeil Lchb_ID))
	
	(Anbauteil.set AT_ABTeil 	(winkel  		winkel_abteil_at)
														(delta_lr		delta_lr_abteil_at)
				 										(Master     0)
	)
	(if (= (Connect.get CastaData amAtSteg) 1)
		(progn
			(Anbauteil.set AT_ABTeil 	(winkel  	winkel_abteil_at)
																(delta_lr	delta_lr_abteil_at)
				 												(Master   0)
			)
		)
	)

	(if (= (Connect.get CastaData vatr-vhtr) -1)	(Anbauteil.set AT_ABTeil 	(SeitRicht  -1)))
	
	(Anbauteil.set AT_ABTeil 	(SeitRicht  1))

	(if (= (Connect.get CastaData amATFlansch) 1) (progn
		(if (= (Connect.get CastaData vatr-vhtr) -1) (Anbauteil.set AT_ABTeil 	(SeitRicht  -1)))
	))

)




(defun calcLichtenAbst ()
	(print ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>")
	(print "BERECHNE LICHTEN ABSTAND DER TRGER")
	(setq delta_v_at 	(Traeger.get Tr_ID delta_v)
				h_at				(Traeger.get Tr_ID h)
	)
	
	(setq delta_v_ht	(Traeger.get Htrg delta_v)
				h_ht				(Traeger.get Htrg h)
	)
	
	(setq h_at_halb	(* 0.5 h_at))
	(setq h_ht_halb	(* 0.5 h_ht))
	
	
	(print delta_v_ht)
	(print h_ht_halb)
	(print delta_v_at)
	(print h_at_halb)
	
	(setq pos_ht 0.0)
	(setq pos_at 0.0)
	
	(if (= (Connect.get CastaData amHtOberflansch) 1)		(setq pos_ht (- delta_v_ht h_ht_halb)))
	(if (= (Connect.get CastaData amHtUnterflansch) 1)	(setq pos_ht (+ delta_v_ht h_ht_halb)))
	
	(if (= (Connect.get CastaData amHtOberflansch) 1)
		(progn
			(if (= (Connect.get CastaData amAtOberflansch) 1)		(setq pos_at	(- (- delta_v_at h_at_halb)))	)
			(if (= (Connect.get CastaData amAtUnterflansch) 1)	(setq pos_at	(+ delta_v_at h_at_halb))	)
		)
	)
	(if (= (Connect.get CastaData amHtUnterflansch) 1)
		(progn
			(if (= (Connect.get CastaData amAtOberflansch) 1)		(setq pos_at	(- delta_v_at h_at_halb))	)
			(if (= (Connect.get CastaData amAtUnterflansch) 1)	(setq pos_at	(- (- delta_v_at) h_at_halb))	)
		)
	)
	
	
	(print pos_ht)
	(print pos_at)
	
	(setq lichterAbst 0.0)
	
	(if (/= pos_at pos_ht)
		(setq lichterAbst (- pos_at pos_ht))
	)
	
	(print lichterAbst)
	
	(if (< lichterAbst 0.0)
		(setq lichterAbst (- lichterAbst))
	)
	(print lichterAbst)
	(print "<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<")
)




(defun calcFutterBlech (BLECH_ID ABST)
	(print ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>")
	(print "BERECHNE FUTTERBLECHDATEN")
	(setq b_at		(Traeger.get Tr_ID b))
	
	(setq b_ht		(Traeger.get Htrg b)
				s_ht		(Traeger.get Htrg s)
	)
	
	
	
	; Futterblechdicke
	(setq dp_futter ABST)
	
	; Breite
	(setq bp_futter b_at)
	
	; Hhe
	(if (= (Connect.get CastaData anschlZwAtEnden) 0)
		(progn
			(setq hp_futter (- (* 0.5 b_ht) (* 0.5 s_ht)))
		)
		(progn
			(setq hp_futter b_ht)
		)
	)
	
	(Blech.set BLECH_ID (hp hp_futter)
											(bp bp_futter)
											(dp dp_futter)
	)
	
	
	(print "<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<")
)



(defun createFutterBlech (BLECH_ID ABST)
	(print ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>")
	(print "ERZEUGE FUTTERBLECH")
	(calcFutterBlech BLECH_ID ABST)
	
	(setq delta_lr_ht 	(Traeger.get Htrg delta_lr)
				s_ht					(Traeger.get Htrg s)
	)
	
	(setq xPos_at	(Connect.get CastaData xPos_at))
	
	(setq hp_futter (Blech.get BLECH_ID hp))
	
	; Beim Anschluss mit AT-Enden
	(if (= (Connect.get CastaData anschlZwAtEnden) 0)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq xPos_at (+ xPos_at (* 0.5 hp_futter) (* 0.5 s_ht))))
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq xPos_at (+ xPos_at (* 0.5 hp_futter) (* 0.5 s_ht))))
				)
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq xPos_at (- xPos_at (* 0.5 hp_futter) (* 0.5 s_ht))))
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq xPos_at (- xPos_at (* 0.5 hp_futter) (* 0.5 s_ht))))
				)
			)
		)
	)
	
	; Anteil delta_lr HT
	(if (= (Connect.get CastaData amHtOberflansch) 1)
		(progn
			(if (= (Connect.get CastaData amAtOberflansch) 1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq xPos_at (+ xPos_at delta_lr_ht)))
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq xPos_at (- xPos_at delta_lr_ht)))
				)
			)
			(if (= (Connect.get CastaData amAtUnterflansch) 1)	
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq xPos_at (- xPos_at delta_lr_ht)))
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq xPos_at (+ xPos_at delta_lr_ht)))
				)
			)
		)
	)
	(if (= (Connect.get CastaData amHtUnterflansch) 1)
		(progn
			(if (= (Connect.get CastaData amAtOberflansch) 1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq xPos_at (- xPos_at delta_lr_ht)))
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq xPos_at (+ xPos_at delta_lr_ht)))
				)
			)
			(if (= (Connect.get CastaData amAtUnterflansch) 1)	
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq xPos_at (+ xPos_at delta_lr_ht)))
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq xPos_at (- xPos_at delta_lr_ht)))
				)
			)
		)
	)
	;(if (= (Connect.get CastaData satr-lhtr)  1)	(setq xPos_at (- xPos_at delta_lr_ht)))
	;(if (= (Connect.get CastaData satr-lhtr) -1)	(setq xPos_at (+ xPos_at delta_lr_ht)))
		
		
	(if (= (Connect.get CastaData amATUnterflansch) 1)	(Traeger.addabtl Tr_ID BLECH_ID xPos_at 0.0 _lasche_uf_))
	(if (= (Connect.get CastaData amATOberflansch) 1)	(Traeger.addabtl Tr_ID BLECH_ID xPos_at 0.0 _lasche_of_))
	(print "<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<")
)


; ====================================================================== */
(defun createSteife ()
	(print ">-----------------------------------------------------------")
	(print "ERZEUGE STEIFE")
	(setq hProf    (Traeger.get  Tr_Id h)
	      sProf    (Traeger.get  Tr_Id s)
	      dV       (Traeger.get  Tr_Id delta_lr)
	      hStz     (Traeger.get  HTrg  h)
	      VWnkl    (connect.get CastaData hpttrg_vwinkel)
	)
	
	(setq dp sProf)
	(setq dp (runde dp auf 5))
	
	;; ...................................  Orientierung ermitteln
	;(setq UZ_HWinkel   (connect.get CastaData HptTrg_HWinkel)
	;      Stz_RotaWnkl (Traeger.get Tr_ID  R_Winkel)
	;      Stz_RotaWnkl (- 360.0 Stz_RotaWnkl)
	 ;     Stz_RotaWnkl (- Stz_RotaWnkl 90.0)
	;)
	;(if (< Stz_RotaWnkl 0.0) (setq Stz_RotaWnkl (+ Stz_RotaWnkl 360.0)))
  ;(setq diffWinkel (- UZ_HWinkel Stz_RotaWnkl))
  ;(print diffWinkel)
  ;(if (= diffWinkel -270.0) (setq dV (- dV)))
  ;(if (= diffWinkel  270.0) (setq dV (- dV)))
  ;(if (= diffWinkel   90.0) (setq dV (- dV)))
	;; ...................................  Orientierung bercksichtigt


	(setq cosAlfa (cos (/ (* PI VWnkl) 180.0)))
	(if (/= cosAlfa 0.0) (setq dV (/ dV cosAlfa)))

  (setq xPos (connect.get CastaData xPos_HT))
  
  ;(setq xPos_Steife  (+ xPos (* 0.5 (- hProf sProf)) (- dV)))
	(setq xPos_Steife  xPos)
	
	(if (= (Connect.get CastaData satr-lhtr)  1)	(setq xPos_Steife  (+ xPos_Steife dV)))
	(if (= (Connect.get CastaData satr-lhtr) -1)	(setq xPos_Steife  (- xPos_Steife dV)))

	

	


	(setq blSteifeOben (blech.create))
	(Connect.storeAnschlObjs CastaData blSteifeOben)
	(traeger.addabtl Htrg blSteifeOben 0.0 0.0 _vollsteife_beids_) ;1539
	(setq AbtlSteife_1 (traeger.get Htrg ABTeil blSteifeOben))
	(Anbauteil.set  AbtlSteife_1 (xpos xPos_Steife))

	
	;(if (/= VWnkl 0.0) (progn
	;    (print "*** Anbauteil setze Winkel: ") (print VWnkl)
	;    (if (= (connect.get CastaData amHtUnterFlansch) 1) (progn
	;        (print "****** amHtUnterFlansch ") (print VWnkl)
	;        (Anbauteil.set  AbtlSteife_1 (Winkel (- VWnkl)))
	;    ))
	;    (if (= (connect.get CastaData amHtOberFlansch) 1) (progn
	;        (print "****** amHtOberFlansch ") (print VWnkl)
	;        (Anbauteil.set  AbtlSteife_1 (Winkel VWnkl))
	;    ))
	;    (if (= (connect.get CastaData anHtRechtesEnde) 1) (progn
	;        (print "****** anHtRechtesEnde ") (print VWnkl)
  ;              (setq xPosOben  (- xPosOben  xPos_H))
	;	(Anbauteil.set  AbtlSteife_1 (xpos xPosOben))
	;    ))
	;))


	(Traeger.updvollstf Htrg)
	(print "<-----------------------------------------------------------")
)
