; $	HT	QT(I)			AF(FS)			P(ZE)
; $	AT	QT(U)			AF(SK)			P(ZE)
; $ 	AE	V(-)			H(-)			R(-)

(defun load-modules ()
	(load "mod-endinit-trg-auf-trg")
)

(defun init-connection ()
; (debug on)	
	(print "*clear*")
;	(connect.showattributes CastaData)
	(setq LB_DEBUG 0)

	(ermittleSeite)

	(if (= (Connect.get CastaData amATFlansch) 1)
		(alertBox "Der Anschluss ist nicht mglich.\n\nBitte rotieren Sie die Trger so, dass die Rckseite des Profils zur Anschlussseite des Haupttrgers passt." "ERR_RotateToBackside")
	)

	(if (= (Connect.get CastaData amATSteg)    0) (print "amATSteg == 0"))
	(if (= (Connect.get CastaData amATSteg)    1) (print "amATSteg == 1"))
	(if (= (Connect.get CastaData amHTFlansch) 1) (print "amHTFlansch == 1"))
	(if (= (Connect.get CastaData amHTSteg)    1) (print "amHTSteg == 1"))

	(if (= (Connect.get CastaData amATSteg) 1)
	    (if (= (Connect.get CastaData amHTFlansch) 1)
		(Connect_IT)
	    )
	)

; (debug off)
;	(if (= (Connect.get CastaData amATSteg) 1)
;		(setConnection)
;	)

;	(print "*clear*")
;	(connect.showattributes CastaData)
)


(defun Connect_IT ()

	(print "beginne mit Anschluss - Connect_IT")
	(init-traegerenden)
	(calcLichtenAbst) ; -> lichterAbst
	(print lichterAbst)
	
	(setq AbstandOK 0)

	(if (>= lichterAbst 0.0)
		(progn
			(setq AbstandOK 1)
			(setq futterBlech (Blech.create))
			(Connect.storeAnschlObjs CastaData futterBlech)
			(print "FutterBlech-Objekt wurde erzeugt!")
			
			(createFlanschKBlech futterBlech lichterAbst)

			(setq fllochbild (Lochbild.create))
			(Connect.storeAnschlObjs CastaData fllochbild)
			
			(createLochbild fllochbild lichterAbst)
		
			(LB_StegAnpassen  fllochbild)
			
			(if (= (Connect.get CastaData anschlzwAtEnden) 0) (TraegerEndeAnpassen))

		)
		(progn
			(AlertBox "Der Abstand ist zu gering, um ein Blech dazwischen zu setzen!"  "GapWidth_Not_Allowed")
		)
	)

	(if (= 1 2) (progn
		(setq dxSKopf_aktuell (Lochbild.get fllochbild dxSKopf))
;		(print dxSKopf_aktuell)
		(setq dlr_Copuon_aktuell (Lochbild.get fllochbild dlr_Coupon))
;		(print dlr_Copuon_aktuell)

		(setq Abtl_HT_LB (Traeger.get HTrg  AbTeil fllochbild))
		(setq sr_aktuell (Anbauteil.get Abtl_HT_LB SeitRicht))
		(print sr_aktuell)
	))
	
	(if (= 1 2) (progn
	    (if (= AbstandOK 1) (progn

		(Lochbild.set fllochbild (LB_Art 2)
					 (w "50 0")
					 (e "0 30 70 0 0 0")
		)

		(setq Abtl_HT_LB (Traeger.get HTrg  AbTeil fllochbild))
		(setq Abtl_AT_LB (Traeger.get Tr_ID AbTeil fllochbild))
		
		(Anbauteil.set Abtl_HT_LB (Master 1))
		(Anbauteil.set Abtl_AT_LB (Master 0))
		
		(setq dlr_HT_Lochb (Anbauteil.get Abtl_HT_LB delta_LR))
		(setq dv__HT_Lochb (Anbauteil.get Abtl_HT_LB delta_V))
		
		(print dlr_HT_Lochb)
		(print dv__HT_Lochb)
	    ))
	
	))

)




(defun calcAndSetLochbildDaten (Lchb_ID ABST)
	(print ">-----------------------------------------------------------")
	(print "BERECHNE LOCHBILDDATEN")
	(Lochbild.set Lchb_ID	(S_Bez 		"M12")
				(Guete   	"4.6")
	)
	
	(setq	t_at 	(Traeger.get Tr_ID t)
		b_at	(Traeger.get Tr_ID b)
		s_at	(Traeger.get Tr_ID s)
		r_at	(Traeger.get Tr_ID r)
		hc_at	(Traeger.get Tr_ID hc)
		h_at	(Traeger.get Tr_ID h)
	)
	
	(setq	t_ht	(Traeger.get Htrg t)
		b_ht	(Traeger.get Htrg b)
		s_ht	(Traeger.get Htrg s)
		r_ht	(Traeger.get Htrg r)
	)
	(setq	dp_Bl	(Blech.get futterBlech dp))
	
	(setq VIER 0)
	
	; vorhandene Anschlusslnge an einer Flanschseite (AT-Ende Anschluss)
	(setq anschl (* 0.5 (- b_ht (+ (* 2 r_ht) s_ht))))
	(print anschl)
	
	; Schraubendurchmesser holen
	(setq dschr (Lochbild.get Lchb_ID sdurchm))
	; Rand- und Lochabstnde
	(setq mine0 (* 2 dschr))
	(setq mine1 (* 4 dschr))
	
	; minimal bentige Anschlusslnge fr zwei Schrauben (M12)
	(setq minAnschl (+ (* 2 mine0) mine1))
	(print minanschl)
	
	(if (= (Connect.get CastaData anschlzwAtEnden) 0) (progn
		(if (<= minAnschl anschl) (setq VIER 1))
	))

	(setq abzug_ht (+ s_ht (* 2 r_ht)))
	(setq rest_ht (- h_ht t_HT t_HT))
	(setq SchrAbstand (- rest_ht (* 4 dschr)))
	(setq SchrAbstand (runde SchrAbstand ab 10))
	(print rest_ht)
	(print SchrAbstand)
				
	(setq w0 SchrAbstand)
	(setq e1 (* 0.5 hc_at))
;	(setq e1rund (runde e1 auf 5))
			
;	(setq e0 (- (* 0.5 h_at) (* 0.5 e1rund)))

	; Berechnen des e-Maes
	(setq rest_ht (- h_AT t_AT t_AT))
	(setq SchrAbstand (- rest_ht (* 4 dschr)))
	(setq SchrAbstand (runde SchrAbstand ab 10))
	(setq e0 (- (/ SchrAbstand 2)))
	(setq e1 SchrAbstand)

	; Klemmlnge berechnen - Apr. 2017
	(setq Klemmlaenge (+ s_at  ABST))
	(if (> dp_Bl ABST) (setq Klemmlaenge (+ s_at dp_Bl)))

	(print e0)
	(print VIER)

			
	(if (= VIER 0) (progn
		(setq w0 (/ w0 2))
				
		(Lochbild.set Lchb_ID	(e0		e0)
					(e1		e1)
					;(e2		200)
					(w0		w0) 	
					(klemml		Klemmlaenge)
		)
	))
	(if (= VIER 1) (progn
		(Lochbild.set Lchb_ID	(e0		e0)
					(e1		e1)
					(w0		w0)
					(w1		0) 	
					(klemml 	Klemmlaenge)
		)
	))
			
	
	(if (= LB_DEBUG 1)
		(progn
			(if (= (Connect.get CastaData amAtSteg) 1)
				(Lochbild.set Lchb_ID	(e2				200))
				(Lochbild.set Lchb_ID	(e1				200))
			)
		)
	)
	
	
	; LOCHBILDART BESTIMMEN
	; ----------------------------------------------
	
	(print SCHRAUBENBILD)
	
	(if (/= SCHRAUBENBILD 0) (progn
	    ; ---- an Trgerenden halbe Lochbilder einbauen mit LB_Art 2 - oder -2
	    ; (if (= (connect.get CastaData amAtSteg) 1) (progn
		(if (= (Connect.get CastaData amHtOberflansch) 1) (progn
			(if (= (Connect.get CastaData linkesEnde) 1)	(Lochbild.set Lchb_ID (Lb_Art  2))	)
			(if (= (Connect.get CastaData rechtesEnde) 1)	(Lochbild.set Lchb_ID (Lb_Art -2))	)
		))
		(if (= (Connect.get CastaData amHtUnterflansch) 1) (progn
			(if (= (Connect.get CastaData linkesEnde) 1)	(Lochbild.set Lchb_ID (Lb_Art -2))	)
			(if (= (Connect.get CastaData rechtesEnde) 1)	(Lochbild.set Lchb_ID (Lb_Art  2))	)
		))

		(setq lb_art (Lochbild.get Lchb_ID Lb_Art))
		(print lb_art)
;	    ))
	))
	(Lochbild.set Lchb_ID (Lb_Art 0))
	(print "<-----------------------------------------------------------")
)



(defun createLochbild (Lchb_ID ABST)
	(print ">-----------------------------------------------------------")
	(print "ERZEUGE LOCHBILD")
	
	(calcAndSetLochbildDaten Lchb_ID ABST)
	
	(setq	delta_lr_at	(Traeger.get Tr_ID delta_lr)
		delta_v_at	(Traeger.get Tr_ID delta_v)
		h_AT		(Traeger.get Tr_ID h)
	)
	
	(setq	delta_lr_ht	(Traeger.get Htrg delta_lr)
		delta_v_HT	(Traeger.get Htrg delta_v)
		h_HTrg		(Traeger.get Htrg h)
	)
	
	(setq xPos_ht		(Connect.get CastaData xPos_ht))
	(setq xPos_at		(Connect.get CastaData xPos_at))
	
	(print xPos_ht)
	(print xPos_at)
		
	; Anbauteil dem Ht hinzufgen
	(if (= (Connect.get CastaData amAtSteg) 0) (progn
		; normaler Fall - Flanschlochbild
		(if (= (Connect.get CastaData amHtOberflansch) 1)
			(traeger.addabtl Htrg Lchb_ID xPos_ht 0.0 _flanschlochbild_of_)
		)
		(if (= (Connect.get CastaData amHtUnterflansch) 1)
			(traeger.addabtl Htrg Lchb_ID xPos_ht 0.0 _flanschlochbild_uf_)
		)
	))
	
	(if (= (Connect.get CastaData amAtSteg) 1) (progn
		; (if (= (Connect.get CastaData amHtOberflansch) 1) (AlertBox "amHtOberflansch"))
		; (if (= (Connect.get CastaData amHtUnterflansch) 1) (AlertBox "amHtUnterflansch"))
		; hier muss ein Steglochbild hinzugefgt werden
		;	(if (= (Connect.get CastaData amHtOberflansch) 1)
		;		(traeger.addabtl Htrg Lchb_ID xPos_ht 0.0 _couponlochbild_rechts_)
		;	)
		;	(if (= (Connect.get CastaData amHtUnterflansch) 1)
		;		(traeger.addabtl Htrg Lchb_ID xPos_ht 0.0 _couponlochbild_links_)
		;	)
		(if (= anHTrgSeite linke_Seite)  (Traeger.addabtl Htrg Lchb_ID xPos_ht 0.0 _couponlochbild_links_))
		(if (= anHTrgSeite rechte_Seite) (Traeger.addabtl Htrg Lchb_ID xPos_ht 0.0 _couponlochbild_rechts_))

	))

	
	
	; ---- Hier muss noch hin, dass am Steg des HT angeschlossen werden kann
	; der Abstand von der Systemachse - ermittelt der sich automatisch? Oder muss
	; der hier explizit berechnet werden in Abhngigkeit von links oder von rechts?
	
	; Anbauteil dem At hinzufgen
;	(traeger.addabtl Tr_ID Lchb_ID xPos_at 0.0 _steglochbild_)
	(traeger.addabtl Tr_ID Lchb_ID xPos_at 0.0 _steglochbild_system_)
	(if (= (Connect.get CastaData amAtStegRechts) 1)
		(alertBox "Anschluss ist nicht mglich" "Connection_Not_Possible")
	)
	
	
	; Verschiebungen und Winkel initialisieren
	(setq winkel_abteil_ht   0.0)					; initialisieren
	(setq winkel_abteil_at   0.0)					; initialisieren

	(setq delta_v_abteil_HT  0.0)
	(setq delta_v_abteil_AT  0.0)
	(setq delta_lr_abteil_HT 0.0)
	(setq delta_lr_abteil_AT 0.0)



	; ---------------------------------------------
	; Winkelberechnung fr HT und AT
	; Neigung des AT zum HT	
	(setq wnkl_LB_Neigung (Connect.get CastaData afl_vwinkel))
	(if (> wnkl_LB_Neigung 90.0) 
		(setq wnkl_LB_Neigung (- 90.0 wnkl_LB_Neigung))	
		(setq wnkl_LB_Neigung (- wnkl_LB_Neigung 90.0))	
	)

	(if (= (Connect.get CastaData at-von-hinten)  1) (setq wnkl_LB_Neigung (- wnkl_LB_Neigung)))
	(if (= (Connect.get CastaData at-von-oben)  1) (progn
		(setq winkel_abteil_ht    0.0)
		(setq winkel_abteil_ht  (- winkel_abteil_ht 90.0))
		(setq winkel_abteil_ht  (- winkel_abteil_ht wnkl_LB_Neigung))
	))
	(if (= (Connect.get CastaData at-von-unten)  1) (progn
		(setq winkel_abteil_ht -180.0)
		(setq winkel_abteil_ht  (+ winkel_abteil_ht 90.0))
		(setq winkel_abteil_ht  (+ winkel_abteil_ht wnkl_LB_Neigung))
	))
	(if (= (Connect.get CastaData at-von-hinten)  1) (setq wnkl_LB_Neigung (- wnkl_LB_Neigung)))

	; AT - hier ist es einfacher, weil das Lochbild einfach um 90 zu drehen ist
	; es soll immer senkrecht nach unten zeigen. Daher muss hier nicht gro gerechnet werden
	(if (= (Connect.get CastaData vatr-lhtr) -1) (setq winkel_abteil_at    (- winkel_abteil_at 90.0)))
	(if (= (Connect.get CastaData vatr-lhtr)  1) (setq winkel_abteil_at    (+ winkel_abteil_at 90.0)))
	(print winkel_abteil_ht)
	
	(setq sinWnk (sin (/ (* PI wnkl_LB_Neigung) 180.0)))
	(setq cosWnk (cos (/ (* PI wnkl_LB_Neigung) 180.0)))
	; wichtiger Fall 
	(if (= (Connect.get CastaData at-von-oben)  1) (setq sinWnk (- sinWnk)))

	; Vertikalverschiebung des AT aufspalten in
	(if (= (Connect.get CastaData vatr-lhtr)  1) (setq delta_v_at    (- delta_v_at)))

	(setq delta_v_abteil_ht  (* 0.5 h_HTrg))
	(if (= (Connect.get CastaData at-von-hinten)  1) (progn
		(setq delta_lr_abteil_ht (- (* cosWnk delta_v_at)))
		(setq delta_v_abteil_ht  (- delta_v_abteil_ht (* sinWnk delta_v_at)))	; hier muss noch die Winkelfunktion greifen
	    )
	    (progn
		(setq delta_lr_abteil_ht (- (* cosWnk delta_v_at)))
		(setq delta_v_abteil_ht  (+ delta_v_abteil_ht (* sinWnk delta_v_at)))	; hier muss noch die Winkelfunktion greifen
	))
	
	; HT - Anbauteil - Dazen einsetzen
	(setq HT_ABTeil (Traeger.get Htrg AbTeil Lchb_ID))
	(Anbauteil.set HT_ABTeil 	(winkel		winkel_abteil_ht)
					(Master		1)
					(delta_v	delta_v_abteil_ht)
					(delta_lr	delta_lr_abteil_ht)
	)


	
	; Vertikalverschiebung des HT aufspalten
	(if (= (Connect.get CastaData at-von-oben)  1) (setq sinWnk (- sinWnk)))
	(if (= (Connect.get CastaData vatr-lhtr)    1) (setq cosWnk (- cosWnk)))

	(if (= (Connect.get CastaData at-von-oben)  1) (progn
		(setq delta_lr_abteil_at    (* cosWnk delta_v_HT))
		(setq delta_v_abteil_at  (- (* sinWnk delta_v_HT)))
	))
	(if (= (Connect.get CastaData at-von-unten) 1) (progn
		(setq delta_lr_abteil_at (- (* cosWnk delta_v_HT)))
		(setq delta_v_abteil_at     (* sinWnk delta_v_HT))
		
		(if (= (Connect.get CastaData at-von-hinten)  1) (setq delta_v_abteil_at  (-  (* sinWnk delta_v_HT))))
	))

	; AT-Anbauteil Werte setzen
	(setq AT_ABTeil (Traeger.get Tr_ID AbTeil Lchb_ID))
	(Anbauteil.set AT_ABTeil 	(winkel  	winkel_abteil_at)
					(delta_lr	delta_lr_abteil_at)
					(delta_v	delta_v_abteil_at)
					(Master   	0)
	)

;	------------------------------------
;	Korrektur - delta_V des HT verschiebt das Lochbild ansonsten nach unten
;	dann ist es im AT nicht mehr mittig - allerdings nur bei scrgem Winkel zueinander.
;	------------- kleiner Test auf Lage-Situation
;	(if (= (Connect.get CastaData vatr-lhtr)  1) (print "vatr.lhtr == 1 - unblicher Fall"))
;	(if (= (Connect.get CastaData at-von-oben) 1) (print "von oben"))
;	(if (= (Connect.get CastaData at-von-unten) 1) (print "von unten"))
;	(if (= (Connect.get CastaData at-von-vorne) 1) (print "von vorne"))
;	(if (= (Connect.get CastaData at-von-hinten) 1) (print "von hinten"))

	(if (= (Connect.get CastaData vatr-lhtr) -1)   (progn
		(if (= (Connect.get CastaData at-von-oben) 1) 
			(if (= (Connect.get CastaData at-von-hinten) 1)	(setq cosWnk (- cosWnk)))
		)
		(if (= (Connect.get CastaData at-von-unten) 1) 
			(if (= (Connect.get CastaData at-von-vorne) 1)	(setq sinWnk (- sinWnk)))
		)
	))
	(if (= (Connect.get CastaData vatr-lhtr)  1)   (progn
		(if (= (Connect.get CastaData at-von-unten) 1) (progn
			(if (= (Connect.get CastaData at-von-vorne) 1)	(setq cosWnk (- cosWnk)))
			(if (= (Connect.get CastaData at-von-vorne) 1)	(setq sinWnk (- sinWnk)))

			(if (= (Connect.get CastaData at-von-hinten) 1)	(setq cosWnk (- cosWnk)))
		))
		(if (= (Connect.get CastaData at-von-oben) 1) (progn
			(if (= (Connect.get CastaData at-von-vorne) 1)	(setq cosWnk (- cosWnk)))
		))
	))

	(setq delta_v_abteil_at (+ delta_v_abteil_at (* sinWnk delta_v_HT)))
	(Anbauteil.set AT_ABTeil 	(delta_v	delta_v_abteil_at))

	(setq dv_Korr (* sinWnk delta_v_HT))
	(setq delta_v_abteil_ht  (- delta_v_abteil_ht  (* sinWnk dv_Korr)))
	(setq delta_lr_abteil_ht (- delta_lr_abteil_ht (* cosWnk dv_Korr)))
	(Anbauteil.set HT_ABTeil 				
				(delta_v	delta_v_abteil_ht)
				(delta_lr	delta_lr_abteil_ht)
	)


	(if (= (Connect.get CastaData vatr-vhtr) -1)	(Anbauteil.set AT_ABTeil 	(SeitRicht  -1)))
	
	; Richtung des Lochbilds festlegen
	(Anbauteil.set AT_ABTeil 	(SeitRicht  1))
	(if (= (Connect.get CastaData amHtUnterflansch) 1) (Anbauteil.set AT_ABTeil 	(SeitRicht  -1)))

)



(defun calcLichtenAbst ()
	(print ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>")
	(print "BERECHNE LICHTEN ABSTAND DER TRGER")
	(setq	delta_v_at 	(Traeger.get Tr_ID delta_v)
		delta_lr_at	(Traeger.get Tr_ID delta_lr)
		h_at		(Traeger.get Tr_ID h)
		b_at		(Traeger.get Tr_ID b)
	)
	
	(setq	delta_v_ht	(Traeger.get Htrg delta_v)
		delta_lr_Ht	(Traeger.get Htrg delta_lr)
		h_ht		(Traeger.get Htrg h)
		b_ht		(Traeger.get Htrg b)
	)
	
	(setq h_at_halb	(* 0.5 h_at))
	(setq h_ht_halb	(* 0.5 h_ht))
	(setq b_ht_halb	(* 0.5 b_ht))

	(setq lichterAbst 0.0)
	
	(if (= (Connect.get CastaData amAtSteg) 1)  (progn
		(if (= (Connect.get CastaData satr-shtr) 1)  (progn
			(setq lichterAbst (- (- (-  b_ht_halb delta_lr_at)) delta_lr_ht))
		))
		(if (= (Connect.get CastaData satr-shtr) -1)  (progn
			(setq lichterAbst (+ (- (-  b_ht_halb delta_lr_at)) delta_lr_ht))
		))
	))

	(if (= (Connect.get CastaData amAtSteg) 0)  (progn
		(if (= (Connect.get CastaData satr-shtr) 1)  (progn
			(setq lichterAbst (- (- (-  b_ht_halb delta_lr_at)) delta_lr_ht))
		))
		(if (= (Connect.get CastaData satr-shtr) -1)  (progn
			(setq lichterAbst (+ (- (-  b_ht_halb delta_lr_at)) delta_lr_ht))
		))

	))

	(print lichterAbst)
	(print "<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<")
)




(defun calcCouponBlech (BLECH_ID ABST)
	(print ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>")
	(print "BERECHNE FUTTERBLECHDATEN")
	(setq	b_at		(Traeger.get Tr_ID b)
		h_at		(Traeger.get Tr_ID h)
		dv_AT		(Traeger.get Tr_ID delta_V)
	)
	
	(setq	b_ht		(Traeger.get Htrg b)
		s_ht		(Traeger.get Htrg s)
		t_HT		(Traeger.get Htrg t)
		dv_HT		(Traeger.get Htrg delta_V)
	)
	
	; Futterblechdicke
	(setq dp_futter ABST)
	
	; Blechabmessung in Richtung Trgerhhe
	(setq bp_Coupon (- h_at 6))
	(setq bpDiff    0)
	
	; Hhe

	(setq hp_Coupon (- h_ht t_HT))
	
	
;	Profilverschiebungen
;	----------------------------------------
	; ---------------------------------------------
	; Winkelberechnung fr HT und AT
	; Neigung des AT zum HT	
	(setq wnkl_Neigung (Connect.get CastaData afl_vwinkel))
	(if (<  wnkl_Neigung 90.0) 
		(setq kl90 1)
		(setq kl90 0)
	)

	(if (< wnkl_Neigung 90.0) 
		(setq wnkl_Neigung (- 90.0 wnkl_Neigung))	
		(setq wnkl_Neigung (- wnkl_Neigung 90.0))	
	)

	(setq sinWnk (sin (/ (* wnkl_Neigung PI) 180.0)))
	(setq cosWnk (cos (/ (* wnkl_Neigung PI) 180.0)))
	(setq tanWnk (tan (/ (* wnkl_Neigung PI) 180.0)))
	(if (> cosWnk 0.1) (setq bpDiff (- (/ h_AT cosWnk) bp_Coupon)))
	
	(print "---------------------------------- *** neu *** Starten ---------")
	(print sinWnk)
	(print cosWnk)
	(print tanWnk)
	(print bpDiff)

	(setq bpDiff (runde bpDiff auf 2))
	(setq bp_Coupon (+ bpDiff bp_Coupon))

	; AT - Delta_V bercksichtigen
	(setq cp_Asym (/ dv_AT cosWnk))
	(if (= (Connect.get CastaData vatr-lhtr ) -1) (setq cp_Asym (- cp_Asym)))

	; Verschiebung lngs aus Vertikalversatz des HT
	(setq dv_Anteil_HT (* tanWnk dv_HT))
	; (if (= (Connect.get CastaData vatr-lhtr ) -1) (setq dv_Anteil_HT (- dv_Anteil_HT)))

	; und in der Gesamtverschiebung bercksichtigen ...	
	; kommt dabei drauf wenn, in welche Richtung der Winkel zeigt.
	(if (= kl90 0) (print "kl90 == 0"))
	(if (= kl90 1) (print "kl90 == 1"))


	(if (= kl90 1) 
		(setq cp_Asym (+ cp_Asym dv_Anteil_HT))
		(setq cp_Asym (+ cp_Asym dv_Anteil_HT))
	)
	
	(if (< dp_futter 5) (setq dp_futter 5))

	(Blech.set BLECH_ID	(hp hp_Coupon)
				(bp bp_Coupon)
				(dp dp_futter)
				(dOK (* 0.5 t_HT))
				(xAsym cp_Asym)
	)
	
	(setq dp_Abst_Diff (- lichterAbst dp_futter))
	(if (< dp_Abst_Diff 0) (progn
		(setq hp_Coupon (- h_ht t_HT t_HT))
		(Blech.set BLECH_ID	
				(hp hp_Coupon)
				(dOK t_HT)
		)
	))

	
	(print "---------------------------------- *** neu *** Enden ---------")
	(print "<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<")
)



(defun	LB_StegAnpassen (Lchb_ID)

	; AT-Anbauteil Werte setzen
	(setq HT_ABTeil (Traeger.get HTrg AbTeil Lchb_ID))
	
	(setq s_AT (Traeger.get Tr_ID s))
	(setq dp (Blech.get futterBlech dp))

	; fr Steganschluss
	(if (= (Connect.get CastaData amATSteg) 1) (progn
		(setq b_HT (Traeger.get HTrg b))
		(setq SeitRicht (Anbauteil.get HT_ABTeil SeitRicht))
		(if (= SeitRicht 0) (setq SeitRicht 1))

		(if (= (Connect.get CastaData amHtOberflansch) 1) (progn
		    (if (= (Connect.get CastaData satr-shtr) 1) (progn
				(Lochbild.set Lchb_ID 	(dlr_coupon	(/ b_HT 2)))
;				(Anbauteil.set HT_ABTeil (SeitRicht (- SeitRicht)))

				; Weil das Lochbild anders herum gezeichnet wird
				(setq s_HT (Traeger.get HTrg s))

				(setq dp_Abst_Diff (- lichterAbst dp))
				(setq dp_Abst_Diff (+ lichterAbst s_AT))
				(Lochbild.set Lchb_ID (dxsKopf dp_Abst_Diff))
				(if (< dp_Abst_Diff 0) (Lochbild.set Lchb_ID (dxsKopf (- dp_Abst_Diff))))
		    ))
		    (if (= (Connect.get CastaData satr-shtr) -1) (progn
				(Lochbild.set Lchb_ID 	(dlr_coupon	(- (/ b_HT 2))))
				(Anbauteil.set HT_ABTeil (SeitRicht (- SeitRicht)))
				; (Lochbild.set Lchb_ID (dxsKopf (+ s_AT dp)))
				; (setq dp_Abst_Diff 0)
				; (Lochbild.set Lchb_ID (dxsKopf dp_Abst_Diff))
				(Lochbild.set Lchb_ID (dxsKopf 0))

		    ))
		))
		(if (= (Connect.get CastaData amHtUnterflansch) 1) (progn
		    (if (= (Connect.get CastaData satr-shtr) 1) (progn
				(Lochbild.set Lchb_ID 	(dlr_coupon	(/ b_HT 2)))
				(Anbauteil.set HT_ABTeil (SeitRicht (- SeitRicht)))
				(Lochbild.set Lchb_ID (dxsKopf 0))
		    ))
		    (if (= (Connect.get CastaData satr-shtr) -1) (progn
				(Lochbild.set Lchb_ID 	(dlr_coupon	(- (/ b_HT 2))))
				(Lochbild.set Lchb_ID (dxsKopf (+ s_AT dp)))
		    ))
		))
		
		(if (= anHTrgSeite linke_Seite) (progn
				; (AlertBox "linke Seite")
				(Lochbild.set Lchb_ID 	(dlr_coupon	(- (/ b_HT 2))))
				(Lochbild.set Lchb_ID (dxsKopf (+ s_AT dp)))
		))
		(if (= anHTrgSeite rechte_Seite) (progn 
				; (AlertBox "rechte Seite")
				(Lochbild.set Lchb_ID 	(dlr_coupon	(/ b_HT 2)))
				(Lochbild.set Lchb_ID (dxsKopf (+ s_AT dp)))
		))

		
	))

;       (Lochbild.set Lchb_ID (dxsKopf 0))

;	xPos korrigieren
	(setq delta_v_HT (Traeger.get HTrg delta_V))
	(setq xPos_AT (Connect.get CastaData xPos_AT))
	(setq xPos_HT (Connect.get CastaData xPos_HT))

	(setq xPos_Bl xPos_HT)

	(if (= (Connect.get CastaData at-von-unten) 1) (setq xPos_Bl (- xPos_Bl delta_v_HT)))
	(if (= (Connect.get CastaData at-von-oben) 1)  (setq xPos_Bl (+ xPos_Bl delta_v_HT)))

	(if (= (Connect.get CastaData anschlZwAtEnden) 0) (progn
	        (setq hp_Bl (Blech.get futterBlech hp))
		(if (= (Connect.get CastaData linkesEnde) 1) (progn
			(setq xPos_Bl (+ xPos_Bl (* 0.5 hp_Bl)))
		))
		(if (= (Connect.get CastaData rechtesEnde) 1) (progn
			(setq xPos_Bl (- xPos_Bl (* 0.5 hp_Bl)))
		))
		
		(Lochbild.set Lchb_ID (w0 (* 0.5 hp_Bl)))
	))

	(setq AT_ABTeil_Lb (Traeger.get Tr_ID AbTeil Lchb_ID))
	(setq xPos_Lb (Anbauteil.get   AT_ABTeil_Lb xPos))
	(setq xPos_Lb xPos_AT)

	(if (= (Connect.get CastaData at-von-unten) 1) (setq xPos_Lb (- xPos_Lb delta_v_HT)))
	(if (= (Connect.get CastaData at-von-oben) 1)  (setq xPos_Lb (+ xPos_Lb delta_v_HT)))
	       
	(setq dlr_coupon (Lochbild.get Lchb_ID 	dlr_coupon))

;	delta_V des HT soll spter in der lokalen Verschiebung bercksichtigt werden
;	(Anbauteil.set AT_ABTeil_Lb (xPos xPos_Lb))
	(Anbauteil.set AT_ABTeil_Lb (delta_SX (- dlr_coupon)))
)



(defun createFlanschKBlech (BLECH_ID ABST)
	(print ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>")
	(print "ERZEUGE FUTTERBLECH")
	(calcCouponBlech BLECH_ID ABST)

	(setq xPos_HT	(Connect.get CastaData xPos_HT))

 (if (= 1 2) (progn	
	(if (= (Connect.get CastaData amHtOberflansch) 1) (progn
	    (if (= (Connect.get CastaData satr-shtr) 1) (setq blSeite _blechcoupon_rechts_))
	    (if (= (Connect.get CastaData satr-shtr) -1) (setq blSeite _blechcoupon_links_))
	))
	(if (= (Connect.get CastaData amHtUnterflansch) 1) (progn
	    (if (= (Connect.get CastaData satr-shtr) 1) (setq blSeite _blechcoupon_rechts_))
	    (if (= (Connect.get CastaData satr-shtr) -1) (setq blSeite _blechcoupon_links_))
	))
       
;   (Traeger.addabtl HTrg  BLECH_ID xPos_HT 0.0 blSeite)
  ))

    (if (= anHTrgSeite linke_Seite)  (Traeger.addabtl HTrg  BLECH_ID xPos_HT 0.0 _blechcoupon_links_))
    (if (= anHTrgSeite rechte_Seite) (Traeger.addabtl HTrg  BLECH_ID xPos_HT 0.0 _blechcoupon_rechts_))
	
	(setq dp (Blech.get BLECH_ID dp))
	(if (> dp ABST) (progn
		(setq abtl_Blch (Traeger.get HTrg ABTeil BLECH_ID))
		(setq dlr_Abtl_Blch (Anbauteil.get abtl_Blch Delta_LR))
		(setq dlr_Abtl_Blch (- dlr_Abtl_Blch (- dp ABST)))
		(Anbauteil.set abtl_Blch (Delta_LR dlr_Abtl_Blch))
	))
	
	
)	


(defun ermittleSeite ()
	(print ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>")
	(print "Seite des Haupttrgers ermitteln")
	(setq linke_Seite  1)
	(setq rechte_Seite 2)
        (setq anHTrgSeite  0)

	(if (= (Connect.get CastaData amHtOberflansch) 1) (progn
	    (if (= (Connect.get CastaData satr-shtr)  1) (setq anHTrgSeite rechte_Seite))
	    (if (= (Connect.get CastaData satr-shtr) -1) (setq anHTrgSeite linke_Seite))
	))
	(if (= (Connect.get CastaData amHtUnterflansch) 1) (progn
	    (if (= (Connect.get CastaData satr-shtr)  1) (setq anHTrgSeite rechte_Seite))
	    (if (= (Connect.get CastaData satr-shtr) -1) (setq anHTrgSeite linke_Seite))
	))
	(print anHTrgSeite)
)	

(defun TraegerEndeAnpassen ()

    (print "------------ Traegerende anpassen")
  
    (setq dv_HT (Traeger.get HTrg  delta_V))
    (setq h_HT  (Traeger.get HTrg  h))
    (setq dv_AT (Traeger.get Tr_ID delta_V))

	(setq wnkl_Neigung (Connect.get CastaData afl_vwinkel))
	(if (<  wnkl_Neigung 90.0) 
		(setq kl90 1)
		(setq kl90 0)
	)

	(if (< wnkl_Neigung 90.0) 
		(setq wnkl_Neigung (- 90.0 wnkl_Neigung))	
		(setq wnkl_Neigung (- wnkl_Neigung 90.0))	
	)
	(setq sinWnk (sin (/ (* wnkl_Neigung PI)  180.0)))
	(setq cosWnk (cos (/ (* wnkl_Neigung PI)  180.0)))

    (if (= (Connect.get CastaData linkesende)  1) (progn
 	(setq TEnde (Traeger.get Tr_ID links))
 	(if (= (Connect.get CastaData amHtUnterflansch) 1) (progn
	    (if (< wnkl_Neigung 5.0) (progn
			(TrEnde.set TEnde (delta_L dv_HT))
			(Lochbild.set fllochbild (LB_Art -2))
	    ))
	    (if (>= wnkl_Neigung 5.0) (progn
			(setq dl_Neu (/ (- dv_HT (* 0.5 h_HT)) cosWnk))
			(TrEnde.set TEnde (delta_L dl_Neu))
	    ))
 	))
 	(if (= (Connect.get CastaData amHtOberflansch) 1) (progn
	    (if (< wnkl_Neigung 5.0) (progn
			(TrEnde.set TEnde (delta_L (- dv_HT)))
			(Lochbild.set fllochbild (LB_Art 2))
	    ))
	    (if (>= wnkl_Neigung 5.0) (progn
			(setq dl_Neu (/ (+ dv_HT (* 0.5 h_HT)) cosWnk))
			(TrEnde.set TEnde (delta_L (- dl_Neu)))
	    ))
 	))
    ))
    (if (= (Connect.get CastaData rechtesende)  1) (progn
 	(setq TEnde (Traeger.get Tr_ID rechts))
 	(if (= (Connect.get CastaData amHtUnterflansch) 1) (progn
	    (if (< wnkl_Neigung 5.0) (progn
			(TrEnde.set TEnde (delta_L dv_HT))
			(Lochbild.set fllochbild (LB_Art 2))
	    ))
	    (if (>= wnkl_Neigung 5.0) (progn
			(setq dl_Neu (/ (- dv_HT (* 0.5 h_HT)) cosWnk))
			(TrEnde.set TEnde (delta_L (- dl_Neu)))
	    ))
 	))
 	(if (= (Connect.get CastaData amHtOberflansch) 1) (progn
	    (if (< wnkl_Neigung 5.0) (progn
			(TrEnde.set TEnde (delta_L (- dv_HT)))
			(Lochbild.set fllochbild (LB_Art -2))
	    ))
	    (if (>= wnkl_Neigung 5.0) (progn
			(setq dl_Neu (/ (+ dv_HT (* 0.5 h_HT)) cosWnk))
			(TrEnde.set TEnde (delta_L (- dl_Neu)))
	    ))
 	))
    ))

	(if (= (Connect.get CastaData vatr-lhtr) 1) (progn
		(setq curr_LB_Art (Lochbild.get fllochbild LB_Art))
		(if (= curr_LB_Art -2) (Lochbild.set fllochbild (LB_Art  2)))
		(if (= curr_LB_Art  2) (Lochbild.set fllochbild (LB_Art -2)))
	))

)