; $	HT	QT(I)			AF(F)			P(ZE)
; $	AT	QT(U)			AF(FS)			P(ZE)
; $ 	AE	V(-)			H(0)			R(-)

;	Achtung - Quelldatei wird auch fr Z-Profile verwendet. Dort wird sie komplett eingebunden.

(defun load-modules ()
	 (load "mod-endinit-trg-auf-trg")
)

(defun init-connection ()
	
	(connect.showattributes CastaData)
	(setq LB_DEBUG 0)
	
	
	(if (= (Connect.get CastaData amATFlansch) 1)
			(setConnection)
;		(if (= (Connect.get CastaData vatr-vhtr) -1) 
;			(alertBox "Der Anschluss ist z.Z. in dieser Kombination nicht mglich.\n\n
;						Bitte rotieren Sie die Trger so, dass die hellen bzw. dunklen Flanschseiten\n
;						in eine Richtung zeigen und tauschen Sie, falls ntig, die Orientierung eines Trgers."
;					    "ERR_BeamRoation_Not_Functional")
;			(setConnection)
;			(setConnection)
;		)
	)
	(if (= (Connect.get CastaData amATSteg) 1)
		(setConnection)
	)
)


(defun setConnection ()

	(init-traegerenden)
	
	(calcLichtenAbst) ; -> lichterAbst
	
	(if (> lichterAbst 2.0)
		(progn
			(setq futterBlech (Blech.create))
			(Connect.storeAnschlObjs CastaData futterBlech)
			(print "FutterBlech-Objekt wurde erzeugt!")
			
			(createFutterBlech futterBlech lichterAbst)
		)
	)
	
	(setq fllochbild (Lochbild.create))
	(Connect.storeAnschlObjs CastaData fllochbild)
	
	(createFlanschLochbild fllochbild lichterAbst)
	
	(applyTo_ZProfile fllochbild)
	

	; TEST
	; ******************************************************************
;	(Lochbild.set fllochbild (e0 0) (e1 15) (e2 50) (w0 60) (LB_Art 2) (delta_w 60))
	
(if (= LB_DEBUG 1) (progn
	(setq lbdummy (Lochbild.create))
	(Lochbild.copy lbdummy fllochbild)
	
	; Anbauteil dem At hinzufgen
	(if (= (Connect.get CastaData amAtOberflansch) 1)
		(traeger.addabtl Tr_ID lbdummy xPos_at 0.0 _flanschlochbild_of_)	
	)
	(if (= (Connect.get CastaData amAtUnterflansch) 1)
		(traeger.addabtl Tr_ID lbdummy xPos_at 0.0 _flanschlochbild_uf_)
	)
	(if (= (Connect.get CastaData amAtStegLinks) 1)
		(traeger.addabtl Tr_ID lbdummy xPos_at 0.0 _steglochbild_)
	)
	
	(setq AT_ABTeil_dummy (Traeger.get Tr_ID AbTeil lbdummy))
	(Anbauteil.set AT_ABTeil_dummy 	(winkel   winkel_abteil_at)
																	(delta_lr		delta_lr_abteil_at)
				 													(Master    1)
	)
	
	(Connect.storeAnschlObjs CastaData lbdummy)
))
	; ******************************************************************
)



(defun calcAndSetLochbildDaten (Lchb_ID ABST)
	(print ">-----------------------------------------------------------")
	(print "BERECHNE LOCHBILDDATEN")
	(Lochbild.set Lchb_ID (S_Bez 		"M12")
												(Guete   	"4.6")
	)
	
	(setq t_at 	(Traeger.get Tr_ID t)
				b_at	(Traeger.get Tr_ID b)
				s_at	(Traeger.get Tr_ID s)
				r_at	(Traeger.get Tr_ID r)
				hc_at	(Traeger.get Tr_ID hc)
				h_at	(Traeger.get Tr_ID h)
	)
	
	(setq t_ht	(Traeger.get Htrg t)
				b_ht	(Traeger.get Htrg b)
				s_ht	(Traeger.get Htrg s)
				r_ht	(Traeger.get Htrg r)
	)
	
	(setq VIER 0)
	
	; vorhandene Anschlusslnge an einer Flanschseite (AT-Ende Anschluss)
	(setq anschl (* 0.5 (- b_ht (+ (* 2 r_ht) s_ht))))
	(print anschl)
	
	; Schraubendurchmesser holen
	(setq dschr (Lochbild.get Lchb_ID sdurchm))
	; Rand- und Lochabstnde
	(setq mine0 (* 2 dschr))
	(setq mine1 (* 4 dschr))
	
	; minimal bentige Anschlusslnge fr zwei Schrauben (M12)
	(setq minAnschl (+ (* 2 mine0) mine1))
	(print minanschl)
	
	(if (= (Connect.get CastaData anschlzwAtEnden) 0)
		(progn
			(if (<= minAnschl anschl)
				(setq VIER 1)
			)
		)
	)
	
	(if (= (Connect.get CastaData amAtFlansch) 1)
		(progn
			; dxSKopf
			(setq dxSKopf (+ t_at ABST))
			
			(setq abzug_ht (+ s_ht (* 2 r_ht)))
			(setq rest_ht (- b_ht abzug_ht))
					
			(setq e0 (+ s_at (* 0.5 b_at)))
			(print e0)
			(setq e0rund (runde e0 auf 5))
			(print e0rund)
			
			(if (= VIER 0)
				(progn
					(setq w0 (+ (* 0.5 rest_ht) abzug_ht))
					(print w0)
					(setq w0rund (runde w0 auf 5))
					(print w0rund)
			
					(Lochbild.set Lchb_ID	(e0				e0)
																(w0				w0) 	
																(klemml 	(+ t_ht t_at ABST))
																(dxSKopf  dxSKopf)
					)
				)
			)
			(if (= VIER 1)
				(progn
					(setq w0 (+ (* 0.25 rest_ht) abzug_ht))
					(print w0)
					(setq w0rund (runde w0 auf 5))
					(print w0rund)
					(setq w1 (+ (* 0.75 rest_ht) abzug_ht))
					(print w1)
					(setq w1rund (runde w1 auf 5))
					(print w1rund)
			
					(Lochbild.set Lchb_ID	(e0				e0)
																(w0				w0)
																(w1				w1) 	
																(klemml 	(+ t_ht t_at ABST))
																(dxSKopf  dxSKopf)
					)
				)
			)
		)
	)
	
	(if (= (Connect.get CastaData amAtSteg) 1)
		(progn
			; dxSKopf
			(setq dxSKopf (+ s_at ABST))
			
			(setq abzug_ht (+ s_ht (* 2 r_ht)))
			(setq rest_ht (- b_ht abzug_ht))
				
			(setq e1 (* 0.5 hc_at))
			(setq e1rund (runde e1 auf 5))
			
			(setq e0 (- (* 0.5 h_at) (* 0.5 e1rund)))
			(print e0)
			;(setq e0rund (runde e0 auf 5))
			;(print e0rund)
			(print VIER)
			
			(if (= VIER 0)
				(progn
					(setq w0 (+ (* 0.5 rest_ht) abzug_ht))
					(print w0)
					(setq w0rund (runde w0 auf 5))
					(print w0rund)
					
					(Lochbild.set Lchb_ID	(e0				e0)
																(e1				e1rund)
																;(e2				200)
																(w0				w0) 	
																(klemml 	(+ t_ht s_at ABST))
																(dxSKopf  dxSKopf)
					)
				)
			)
			(if (= VIER 1)
				(progn
					(setq w0 (+ (* 0.25 rest_ht) abzug_ht))
					(print w0)
					(setq w0rund (runde w0 auf 5))
					(print w0rund)
					(setq w1 (+ (* 0.75 rest_ht) abzug_ht))
					(print w1)
					(setq w1rund (runde w1 auf 5))
					(print w1rund)
					
					(Lochbild.set Lchb_ID	(e0				e0)
																(e1				e1rund)
																(w0				w0)
																(w1				w1) 	
																(klemml 	(+ t_ht s_at ABST))
																(dxSKopf  dxSKopf)
					)
				)
			)
			
			
			
		)
	)
	
	(if (= LB_DEBUG 1)
		(progn
			(if (= (Connect.get CastaData amAtSteg) 1)
				(Lochbild.set Lchb_ID	(e2				200))
				(Lochbild.set Lchb_ID	(e1				200))
			)
		)
	)
	
	
	; LOCHBILDART BESTIMMEN
	; ----------------------------------------------
	
	(print SCHRAUBENBILD)
	
	(if (/= SCHRAUBENBILD 0)
		(progn
			; ---- an Trgerenden halbe Lochbilder einbauen mit LB_Art 2 - oder -2
			(if (= (connect.get CastaData amAtSteg) 1)
				(progn
					(if (= (Connect.get CastaData amHtOberflansch) 1)
						(progn
							(if (= (Connect.get CastaData linkesEnde) 1)	(Lochbild.set Lchb_ID (Lb_Art  2))	)
							(if (= (Connect.get CastaData rechtesEnde) 1)	(Lochbild.set Lchb_ID (Lb_Art -2))	)
						)
					)
					(if (= (Connect.get CastaData amHtUnterflansch) 1)
						(progn
							(if (= (Connect.get CastaData linkesEnde) 1)	(Lochbild.set Lchb_ID (Lb_Art -2))	)
							(if (= (Connect.get CastaData rechtesEnde) 1)	(Lochbild.set Lchb_ID (Lb_Art  2))	)
						)
					)
				)
				;(progn
				;	(if (= (Connect.get CastaData linkesEnde) 1)	(Lochbild.set Lchb_ID (Lb_Art  2))	)
				;	(if (= (Connect.get CastaData rechtesEnde) 1)	(Lochbild.set Lchb_ID (Lb_Art -2))	)
				;)
			)
	
				
				
			
			(if (= (Connect.get CastaData amAtFlansch) 1)
				(progn
					(if (= (Connect.get CastaData amHtOberflansch) 1)
						(progn
							(if (= (Connect.get CastaData amAtOberflansch) 1)
								(progn
									(if (= (Connect.get CastaData linkesEnde) 1)
										(progn
											(if (= (Connect.get CastaData satr-lhtr)  1)	(Lochbild.set Lchb_ID (Lb_Art -2))	)
											(if (= (Connect.get CastaData satr-lhtr) -1)	(Lochbild.set Lchb_ID (Lb_Art -2))	)
										)
									)
									(if (= (Connect.get CastaData rechtesEnde) 1)
										(progn
											(if (= (Connect.get CastaData satr-lhtr)  1)	(Lochbild.set Lchb_ID (Lb_Art  2))	)
											(if (= (Connect.get CastaData satr-lhtr) -1)	(Lochbild.set Lchb_ID (Lb_Art  2))	)
										)
									)
								)
							)
							(if (= (Connect.get CastaData amAtUnterflansch) 1)
								(progn
									(if (= (Connect.get CastaData linkesEnde) 1)
										(progn
											(if (= (Connect.get CastaData satr-lhtr)  1)	(Lochbild.set Lchb_ID (Lb_Art  2))	)
											(if (= (Connect.get CastaData satr-lhtr) -1)	(Lochbild.set Lchb_ID (Lb_Art  2))	);
										)
									)
									(if (= (Connect.get CastaData rechtesEnde) 1)
										(progn
											(if (= (Connect.get CastaData satr-lhtr)  1)	(Lochbild.set Lchb_ID (Lb_Art -2))	)
											(if (= (Connect.get CastaData satr-lhtr) -1)	(Lochbild.set Lchb_ID (Lb_Art -2))	);
										)
									)
								)
							)
						)
					)
					(if (= (Connect.get CastaData amHtUnterflansch) 1)
						(progn
							(if (= (Connect.get CastaData amAtOberflansch) 1)
								(progn
									(if (= (Connect.get CastaData linkesEnde) 1)
										(progn
											(if (= (Connect.get CastaData satr-lhtr)  1)	(Lochbild.set Lchb_ID (Lb_Art  2))	)
											(if (= (Connect.get CastaData satr-lhtr) -1)	(Lochbild.set Lchb_ID (Lb_Art  2))	);
										)
									)
									(if (= (Connect.get CastaData rechtesEnde) 1)
										(progn
											(if (= (Connect.get CastaData satr-lhtr)  1)	(Lochbild.set Lchb_ID (Lb_Art -2))	)
											(if (= (Connect.get CastaData satr-lhtr) -1)	(Lochbild.set Lchb_ID (Lb_Art -2))	);
										)
									)
								)
							)
							(if (= (Connect.get CastaData amAtUnterflansch) 1)
								(progn
									(if (= (Connect.get CastaData linkesEnde) 1)
										(progn
											(if (= (Connect.get CastaData satr-lhtr)  1)	(Lochbild.set Lchb_ID (Lb_Art -2))	)
											(if (= (Connect.get CastaData satr-lhtr) -1)	(Lochbild.set Lchb_ID (Lb_Art -2))	)
										)
									)
									(if (= (Connect.get CastaData rechtesEnde) 1)
										(progn
											(if (= (Connect.get CastaData satr-lhtr)  1)	(Lochbild.set Lchb_ID (Lb_Art  2))	)
											(if (= (Connect.get CastaData satr-lhtr) -1)	(Lochbild.set Lchb_ID (Lb_Art  2))	)
										)
									)
								)
							)
						)
					)
				)
			)
	
			(setq lb_art (Lochbild.get Lchb_ID Lb_Art))
			(print lb_art)
			
		)
	)
	(print "<-----------------------------------------------------------")
)



(defun createFlanschLochbild (Lchb_ID ABST)
	(print ">-----------------------------------------------------------")
	(print "ERZEUGE LOCHBILD")
	
	(calcAndSetLochbildDaten Lchb_ID ABST)
	
	(setq 	delta_lr_at	(Traeger.get Tr_ID delta_lr)
		delta_v_at	(Traeger.get Tr_ID delta_v)
	)
	
	(setq delta_lr_ht (Traeger.get Htrg delta_lr))
	
	(setq xPos_ht (Connect.get CastaData xPos_ht))
	(setq xPos_at (Connect.get CastaData xPos_at))
	
	(print xPos_ht)
	(print xPos_at)
	
	
		
	; Anbauteil dem Ht hinzufgen
	(if (= (Connect.get CastaData amHtOberflansch) 1)
		(traeger.addabtl Htrg Lchb_ID xPos_ht 0.0 _flanschlochbild_of_)
	)
	(if (= (Connect.get CastaData amHtUnterflansch) 1)
		(traeger.addabtl Htrg Lchb_ID xPos_ht 0.0 _flanschlochbild_uf_)
	)
	
	
	; Anbauteil dem At hinzufgen
	(if (= (Connect.get CastaData amAtOberflansch) 1)
		(traeger.addabtl Tr_ID Lchb_ID xPos_at 0.0 _flanschlochbild_of_)	
	)
	(if (= (Connect.get CastaData amAtUnterflansch) 1)
		(traeger.addabtl Tr_ID Lchb_ID xPos_at 0.0 _flanschlochbild_uf_)
	)
	(if (= (Connect.get CastaData amAtStegLinks) 1)
		(traeger.addabtl Tr_ID Lchb_ID xPos_at 0.0 _steglochbild_)
	)
	(if (= (Connect.get CastaData amAtStegRechts) 1)
		(alertBox "Anschluss ist nicht mglich" "Connection_Not_Possible")
	)
	
	

	; Anbauteil-Winkel AT
	; --------------------------
	; am AT Flansch
	(if (= (Connect.get CastaData amATFlansch) 1)
		(progn
			(if (= (Connect.get CastaData amHtOberflansch)	1)
				(progn
					(if (= (Connect.get CastaData amATOberflansch) 1)
						(progn
							(if (= (Connect.get CastaData satr-lhtr)  1)	(setq winkel_abteil_at 270.0)	)
							(if (= (Connect.get CastaData satr-lhtr) -1)	(setq winkel_abteil_at 270.0)	)
						)
					)
					(if (= (Connect.get CastaData amATUnterflansch) 1)
						(progn
							(if (= (Connect.get CastaData satr-lhtr)  1)	(setq winkel_abteil_at 270.0)	)
							(if (= (Connect.get CastaData satr-lhtr) -1)	(setq winkel_abteil_at 270.0)	);
						)
					)
				)
			)
			(if (= (Connect.get CastaData amHtUnterflansch)	1)
				(progn
					(if (= (Connect.get CastaData amATOberflansch) 1)
						(progn
							(if (= (Connect.get CastaData satr-lhtr)  1)	(setq winkel_abteil_at 270.0)	)
							(if (= (Connect.get CastaData satr-lhtr) -1)	(setq winkel_abteil_at 270.0)	);
						)
					)
					(if (= (Connect.get CastaData amATUnterflansch) 1)
						(progn
							(if (= (Connect.get CastaData satr-lhtr)  1)	(setq winkel_abteil_at 270.0)	)
							(if (= (Connect.get CastaData satr-lhtr) -1)	(setq winkel_abteil_at 270.0)	)
						)
					)
				)
			)
		)
	)

	(setq qsForm (Traeger.get Tr_ID QSForm))
  	(if (= qsForm "Z") (setq winkel_abteil_at (- winkel_abteil_at 180.0)))
	; (setq winkel_abteil_at (- winkel_abteil_at 180.0))
	; am AT Steg
	(if (= (Connect.get CastaData amATSteg) 1)
		(progn
			(setq winkel_abteil_at 0.0)
		)
	)
	
	; Anbauteil-Winkel HT
	; --------------------------
	; am AT Flansch
	(if (= (Connect.get CastaData amATFlansch) 1)
		(progn
			(if (= (Connect.get CastaData satr-lhtr) -1)	(setq winkel_abteil_ht 180.0)	)
			(if (= (Connect.get CastaData satr-lhtr)  1)	(setq winkel_abteil_ht 0.0)		)
		)
	)
	; am AT Steg
	(if (= (Connect.get CastaData amATSteg) 1)
		(progn
			(if (= (Connect.get CastaData amHtOberflansch) 1)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq winkel_abteil_ht 180.0)	)
					(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq winkel_abteil_ht 0.0)		)
				)
			)
			(if (= (Connect.get CastaData amHtUnterflansch) 1)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq winkel_abteil_ht 180.0)	)
					(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq winkel_abteil_ht 0.0)		)
				)
			)
		)
	)
	
	
	(setq delta_v_abteil_ht 0.0)
	(setq delta_lr_abteil_at 0.0)
	
	; Positionierung Anbauteil HT an AT (nur wenn am AT-Steg)
	; --------------------------
	(if (= (Connect.get CastaData amATSteg) 1)
		(progn
			(setq h_at (Traeger.get Tr_ID h))
			(setq delta_v_abteil_ht (- delta_v_abteil_ht (* 0.5 h_at)))
		)
	)
	
	
	; Anbauteil delta_v HT
	; --------------------------
	(if (= (Connect.get CastaData amATFlansch) 1)
		(progn
			(if (= (Connect.get CastaData vatr-vhtr) -1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta_v_abteil_ht (+ delta_v_abteil_ht delta_lr_at))	)
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta_v_abteil_ht (+ delta_v_abteil_ht delta_lr_at))	)
				)
			)
			(if (= (Connect.get CastaData vatr-vhtr)  1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta_v_abteil_ht (+ delta_v_abteil_ht delta_lr_at))	)
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta_v_abteil_ht (+ delta_v_abteil_ht delta_lr_at))	)
				)
			)
		)
	)
	(if (= (Connect.get CastaData amATSteg) 1)
		(progn
			(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_v_abteil_ht (+ delta_v_abteil_ht delta_v_at))	)
			(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_v_abteil_ht (+ delta_v_abteil_ht delta_v_at))	)
		)
	)
	

	; Anbauteil delta_lr AT
	; --------------------------
	(if (= (Connect.get CastaData amATFlansch) 1)
		(progn
			(if (= (Connect.get CastaData vatr-vhtr)  1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta_lr_abteil_at (+ delta_lr_abteil_at delta_lr_ht))	)
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta_lr_abteil_at (- delta_lr_abteil_at delta_lr_ht))	)
				)
			)
			(if (= (Connect.get CastaData vatr-vhtr) -1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta_lr_abteil_at (- delta_lr_abteil_at delta_lr_ht))	)
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta_lr_abteil_at (+ delta_lr_abteil_at delta_lr_ht)) )
				)
			)
		)
	)
	(if (= (Connect.get CastaData amATSteg) 1)
		(progn
			(if (= (Connect.get CastaData amHtOberflansch) 1)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_lr_abteil_at (+ delta_lr_abteil_at delta_lr_ht))	)
					(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_lr_abteil_at (- delta_lr_abteil_at delta_lr_ht))	)
				)
			)
			(if (= (Connect.get CastaData amHtUnterflansch) 1)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_lr_abteil_at (- delta_lr_abteil_at delta_lr_ht))	)
					(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_lr_abteil_at (+ delta_lr_abteil_at delta_lr_ht))	)
				)
			)
		)
	)

	(print delta_v_abteil_ht)
	(print delta_lr_abteil_at)
	
	(print winkel_abteil_ht)
	(print winkel_abteil_at)
	; HT-Anbauteil Werte setzen
	(setq HT_ABTeil (Traeger.get Htrg AbTeil Lchb_ID))
	
	(Anbauteil.set HT_ABTeil 	(winkel   winkel_abteil_ht)
				 										(Master   1)
				 										(delta_v 	delta_v_abteil_ht)
	)
	
	
	; AT-Anbauteil Werte setzen
	(setq AT_ABTeil (Traeger.get Tr_ID AbTeil Lchb_ID))
	
	(Anbauteil.set AT_ABTeil 	(winkel  		winkel_abteil_at)
														(delta_lr		delta_lr_abteil_at)
				 										(Master     0)
	)
	(if (= (Connect.get CastaData amAtSteg) 1)
		(progn
			(Anbauteil.set AT_ABTeil 	(winkel  	winkel_abteil_at)
																(delta_lr	delta_lr_abteil_at)
				 												(Master   0)
			)
		)
	)

	(if (= (Connect.get CastaData vatr-vhtr) -1)	(Anbauteil.set AT_ABTeil 	(SeitRicht  -1)))
	
	(Anbauteil.set AT_ABTeil 	(SeitRicht  1))

	(if (= (Connect.get CastaData amATFlansch) 1) (progn
		(if (= (Connect.get CastaData vatr-vhtr) -1) (Anbauteil.set AT_ABTeil 	(SeitRicht  -1)))
	))

)



(defun calcLichtenAbst ()
	(print ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>")
	(print "BERECHNE LICHTEN ABSTAND DER TRGER")
	(setq delta_v_at 	(Traeger.get Tr_ID delta_v)
				delta_lr_at	(Traeger.get Tr_ID delta_lr)
				h_at				(Traeger.get Tr_ID h)
				b_at				(Traeger.get Tr_ID b)
	)
	
	(setq delta_v_ht	(Traeger.get Htrg delta_v)
				h_ht				(Traeger.get Htrg h)
	)
	
	(setq h_at_halb	(* 0.5 h_at))
	(setq h_ht_halb	(* 0.5 h_ht))
	
	(if (= (Connect.get CastaData amAtFlansch) 1)
		(progn
			(setq pos_ht	(- delta_v_ht h_ht_halb))
			(print pos_ht)
			
			;(setq upos_at (+ delta_v_at h_at_halb))

			
			(if (= (Connect.get CastaData amHtOberflansch) 1)
				(progn
					(if (= (Connect.get CastaData amAtOberflansch) 1)	(setq pos_at	(- (- delta_v_at h_at_halb)))	); noch nicht mglich
					(if (= (Connect.get CastaData amAtUnterflansch) 1)	(setq pos_at	(+ delta_v_at h_at_halb))	)
				)
			)
			(if (= (Connect.get CastaData amHtUnterflansch) 1)
				(progn
					(if (= (Connect.get CastaData amAtOberflansch) 1)	(setq pos_at	(+ (- delta_v_at) h_at_halb))	);ok
					(if (= (Connect.get CastaData amAtUnterflansch) 1)	(setq pos_at	(- (- delta_v_at) h_at_halb))	); noch nicht mglich
				)
			)
			(print pos_at)
		)
	)
	
	(if (= (Connect.get CastaData amAtSteg) 1)
		(progn
			(setq pos_ht	(- delta_v_ht h_ht_halb))
			(print pos_ht)
			
			(setq pos_at (- delta_lr_at))
			(print pos_at)
		)
	)
	

	(if (= (Connect.get CastaData amHtUnterflansch) 1) (progn
		(if (= (Connect.get CastaData amAtOberflansch) 1) (setq pos_at (+ pos_at h_AT)))
	))
	
	(setq lichterAbst 0.0)

	(if (/= pos_at pos_ht)
		(if (< pos_at pos_ht)
			(progn
				(setq lichterAbst (- pos_at pos_ht))
			)
			;(progn
			;	(alertBox "Die Trger berschneiden sich!" "WRN_BeamCollision")
			;)
		)
	)
	
	(if (< lichterAbst 0.0)
		(setq lichterAbst (- lichterAbst))
	)
	(print lichterAbst)
	(print "<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<")
)




(defun calcFutterBlech (BLECH_ID ABST)
	(print ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>")
	(print "BERECHNE FUTTERBLECHDATEN")
	(setq b_at		(Traeger.get Tr_ID b)
				h_at		(Traeger.get Tr_ID h)
	)
	
	(setq b_ht		(Traeger.get Htrg b)
				s_ht		(Traeger.get Htrg s)
	)
	
	
	
	; Futterblechdicke
	(setq dp_futter ABST)
	
	; Breite
	(if (= (Connect.get CastaData amATFlansch) 1)	(setq bp_futter b_at))
	(if (= (Connect.get CastaData amATSteg) 1)		(setq bp_futter h_at))
	
	; Hhe
	(if (= (Connect.get CastaData anschlZwAtEnden) 0)
		(progn
			(setq hp_futter (- (* 0.5 b_ht) (* 0.5 s_ht)))
		)
		(progn
			(setq hp_futter b_ht)
		)
	)
	
	(Blech.set BLECH_ID (hp hp_futter)
											(bp bp_futter)
											(dp dp_futter)
	)
	
	
	(print "<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<")
)



(defun createFutterBlech (BLECH_ID ABST)
	(print ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>")
	(print "ERZEUGE FUTTERBLECH")
	(calcFutterBlech BLECH_ID ABST)
	
	(setq delta_lr_ht 	(Traeger.get Htrg delta_lr)
				s_ht					(Traeger.get Htrg s)
	)
	
	(setq xPos_at	(Connect.get CastaData xPos_at))
	
	(setq hp_futter (Blech.get BLECH_ID hp)
				bp_futter	(Blech.get BLECH_ID bp)
	)
	
	; Beim Anschluss mit AT-Enden
	(if (= (Connect.get CastaData anschlZwAtEnden) 0)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq xPos_at (+ xPos_at (* 0.5 hp_futter) (* 0.5 s_ht))))
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq xPos_at (+ xPos_at (* 0.5 hp_futter) (* 0.5 s_ht))))
					(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq xPos_at (+ xPos_at (* 0.5 hp_futter) (* 0.5 s_ht))))
					(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq xPos_at (+ xPos_at (* 0.5 hp_futter) (* 0.5 s_ht))))
				)
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq xPos_at (- xPos_at (* 0.5 hp_futter) (* 0.5 s_ht))))
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq xPos_at (- xPos_at (* 0.5 hp_futter) (* 0.5 s_ht))))
					(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq xPos_at (- xPos_at (* 0.5 hp_futter) (* 0.5 s_ht))))
					(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq xPos_at (- xPos_at (* 0.5 hp_futter) (* 0.5 s_ht))))
				)
			)
		)
	)
	
	; Anteil delta_lr HT
	(if (= (Connect.get CastaData amATFlansch) 1)
		(progn
			(if (= (Connect.get CastaData amHtOberflansch) 1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq xPos_at (- xPos_at delta_lr_ht)))
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq xPos_at (+ xPos_at delta_lr_ht)))
				)
			)
			(if (= (Connect.get CastaData amHtUnterflansch) 1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq xPos_at (+ xPos_at delta_lr_ht)))
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq xPos_at (- xPos_at delta_lr_ht)))
				)
			)
		)
	)
	(if (= (Connect.get CastaData amATSteg) 1)
		(progn
			(if (= (Connect.get CastaData amHtOberflansch) 1)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq xPos_at (- xPos_at delta_lr_ht)))
					(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq xPos_at (+ xPos_at delta_lr_ht)))
				)
			)
			(if (= (Connect.get CastaData amHtUnterflansch) 1)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq xPos_at (+ xPos_at delta_lr_ht)))
					(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq xPos_at (- xPos_at delta_lr_ht)))
				)
			)
		)
	)	
		
	(if (= (Connect.get CastaData amATUnterFlansch) 1)	(Traeger.addabtl Tr_ID BLECH_ID xPos_at 0.0 _lasche_uf_))
	(if (= (Connect.get CastaData amATOberFlansch) 1)		(Traeger.addabtl Tr_ID BLECH_ID xPos_at 0.0 _lasche_of_))
	(if (= (Connect.get CastaData amATSteg) 1)					(Traeger.addabtl Tr_ID BLECH_ID xPos_at 0.0 _lasche_steg_li_))
	
	(if (= (Connect.get CastaData amATFlansch) 1)
		(progn
			
			(setq delta_lr_abtl_futter (- (* 0.5 bp_futter)))
			
			(setq futter_abtl (Traeger.get Tr_ID AbTeil BLECH_ID))
	
			(Anbauteil.set futter_abtl (delta_lr delta_lr_abtl_futter))
		)
	)
	(print "<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<")
)
(defun applyTo_ZProfile (Lchb_ID)

  (setq qsForm (Traeger.get Tr_ID QSForm))
  (if (= qsForm "Z") (progn
	
	  (setq LB_Art		(Lochbild.get Lchb_ID LB_Art)
	  	lb_RWinkel 	(Lochbild.get Lchb_ID rWinkel)
	  )
	  ; (Lochbild.set Lchb_ID (e "0 50 150 0 0 0"))
	  (Lochbild.set Lchb_ID (rWinkel 180.0))
	  
	  (setq Abtl_Lochb_HT (Traeger.get HTrg ABTeil Lchb_ID))
	  (setq  lb_RWinkel_Abtl (Anbauteil.get Abtl_Lochb_HT Winkel))
	  
	  (setq new_lb_RWinkel_Abtl (+ lb_RWinkel_Abtl 180.0))
	  (if (>= new_lb_RWinkel_Abtl 360.0) (setq new_lb_RWinkel_Abtl (- new_lb_RWinkel_Abtl 360.0)))
	  (Anbauteil.set Abtl_Lochb_HT (Winkel new_lb_RWinkel_Abtl))
	  (Lochbild.set Lchb_ID (LB_Art (- LB_Art)))
 
 	  ; neu - Sept. 2015
	  ; (setq Abtl_Lochb_AT (Traeger.get Tr_ID ABTeil Lchb_ID))
	  ; (setq  lb_RWinkel_Abtl (Anbauteil.get Abtl_Lochb_AT Winkel))
	  ; (setq new_lb_RWinkel_Abtl (- lb_RWinkel_Abtl 180.0))
	  ; (Anbauteil.set Abtl_Lochb_AT (Winkel new_lb_RWinkel_Abtl))
 
   ))  
)
