; $	HT	QT(IK)			AF(F)			P(ZE)
; $	AT	QT(UK)			AF(FS)			P(ZE)
; $ 	AE	V(-)			H(0)			R(-)

;	Achtung - Quelldatei wird auch fr Z-Profile verwendet. Dort wird sie komplett eingebunden.
;	Bei nderungen daher auch das andere Makro testen

(defun load-modules ()
	(load "mod-endinit-trg-auf-trg")
	(load "mod_CZ_PfettenanschlussMitFahne")
)

(defun init-connection ()
	
	(connect.showattributes CastaData)
	(setq LB_DEBUG 0)
	
	
	(if (= (Connect.get CastaData amATFlansch) 1)
		(if (= (Connect.get CastaData vatr-vhtr) -1)
			(alertBox "Der Anschluss ist z.Z. in dieser Kombination nicht mglich.\n\nBitte rotieren Sie die Trger so, dass die hellen bzw. dunklen Flanschseiten\nin eine Richtung zeigen und tauschen Sie, falls ntig, die Orientierung eines Trgers."  "ERR_BeamRoation_Not_Functional")
		    (progn
				(setConnection)
				(calcBlechVersatz Fahnenbl)
				(SchrLaengsLage_imHT)
				(insert_Zusatz_Steife Fahnenbl)
		    )
		)
	)
	(if (= (Connect.get CastaData amATSteg) 1) (progn
		(setConnection)
		(calcBlechVersatz Fahnenbl)
	))

	(setq qsForm (Traeger.get Tr_ID QSForm))
  	(if (= qsForm "Z") 
  		(Blech.set Fahnenbl  (FormFkt "cb_Fahnenblech_Z"))
  		(Blech.set Fahnenbl  (FormFkt "cb_Fahnenblech_C"))
  	)
  	(if (= qsForm "K") (progn
		(moveFahneAndStf_forK)
  		(Blech.set Fahnenbl  (FormFkt "cb_Fahnenblech_C"))
	))
   (if (objExist F_Steife)	(Blech.set F_Steife  (FormFkt "cb_SteifenHP")))

)

(defun	SchrLaengsLage_imHT ()
	(setq dlr_Trg (Traeger.get Tr_ID delta_LR))
	(setq AbtlFahnenLb_HT	(Traeger.get Htrg AbTeil lchbAtrgSteg))
	(setq rWinkel (Anbauteil.get AbtlFahnenLb_HT Winkel))

	(setq qsForm (Traeger.get Tr_ID QSForm))
  	(if (= qsForm "K") (progn
		(setq b_AT (Traeger.get Tr_ID b))
		(setq dlr_Trg (- dlr_Trg (* 0.5 b_AT)))
	))

	(if (= (Connect.get CastaData  satr-lhtr) -1) (progn
		(if (< rWinkel -85) (Anbauteil.set AbtlFahnenLb_HT (delta_SX    dlr_Trg)))
		(if (> rWinkel  85) (Anbauteil.set AbtlFahnenLb_HT (delta_SX (- dlr_Trg))))
	))
	(if (= (Connect.get CastaData  satr-lhtr)  1) (progn
		(if (< rWinkel -85) (Anbauteil.set AbtlFahnenLb_HT (delta_SX (- dlr_Trg))))
		(if (> rWinkel  85) (Anbauteil.set AbtlFahnenLb_HT (delta_SX    dlr_Trg)))
	))
)
; ----------------------------------------------------------------------------------------
; Callback fr Fahne am HT
; ----------------------------------------------------------------------------------------
(defun cb_Fahnenblech_C (zp)
	(print "*clear*")
	(print "in Callback-Funktion cb_bFahnenbl")
	(print zp)

;	(if _CopyAction_ (print "CopyAction - Kopieren wird ausgefhrt!"))

	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dpAlt		(Blech.get Fahnenbl dp))
	    (setq dxs_Alt	(Lochbild.get lchbAtrgSteg dxSKopf))
	    (print dxs_Alt)
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq dpNeu (Blech.get Fahnenbl dp))
	    (print dpAlt) (print dpNeu)
	    
	    (if (/= dpAlt dpNeu) (progn
	       ; Anbauteil wird in der folgenden Routine gebraucht
;	       (setq AbtlFahnenLchb	(Traeger.get Htrg AbTeil lchbAtrgSteg))
;	       (calcSchrLaengeUndVersatz lchbAtrgSteg)
	       (calcBlechVersatz Fahnenbl)
	       (aendereFahnenBlechLochbilder dpAlt dpNeu)
		   (if (objExist F_Steife)		   (SteifenVerschiebung  Fahnenbl))
	    ))
	    (SchrLaengsLage_imHT)
	))
)
(defun cb_SteifenHP (zp)
	(if (ObjExist F_Steife) (progn
		(if (= zp 0) (progn
			(setq hp_Alt (Blech.get F_Steife hp))
		))
		(if (= zp 1) (progn
			(setq hp_Neu (Blech.get F_Steife hp))
			
			(if (/= hp_Alt hp_Neu) (SteifenVerschiebung  Fahnenbl))
		))
	
	
	))

)
(defun calcSchrLaengeUndVersatz (Lchb_ID)
     (setq dp		(Blech.get Fahnenbl dp)
           s_AT 	(Traeger.get Tr_ID  s)
           KlemmLng	(+ dp s_AT)
     )
     (Lochbild.set Lchb_ID (Klemml KlemmLng))
     
)
(defun	calcBlechVersatz (Blech_ID)

	(setq	delta_LR_Blech (Blech.get Blech_ID dp))
	(if (= (Connect.get CastaData satr-lhtr)  1) (setq delta_LR_Blech (* -0.5 delta_LR_Blech)))
	(if (= (Connect.get CastaData satr-lhtr) -1) (setq delta_LR_Blech (*  0.5 delta_LR_Blech)))

	(setq dlr_Trg (Traeger.get Tr_ID delta_LR))
	(if (= (Connect.get CastaData satr-lhtr)  1) (setq delta_LR_Blech (+ delta_LR_Blech dlr_Trg)))
	(if (= (Connect.get CastaData satr-lhtr) -1) (setq delta_LR_Blech (- delta_LR_Blech dlr_Trg)))

	(setq qsForm_AT (Traeger.get Tr_ID qsForm))
	(if (= qsForm_AT "K") (progn
		(setq 	b_AT (Traeger.get Tr_ID b)
				t_AT (Traeger.get Tr_ID t)
		)
		(if (= (Connect.get CastaData satr-lhtr)  1) (setq delta_LR_Blech (- delta_LR_Blech (* 0.5 b_AT))))
		(if (= (Connect.get CastaData satr-lhtr) -1) (setq delta_LR_Blech (+ delta_LR_Blech (* 0.5 b_AT))))
	))
	
	(Blech.set Blech_ID (xAsym delta_LR_Blech))

)
(defun calcSchrLaengeUndVersatz (Lchb_ID dpAlt dpNeu)

    (if (= dpAlt 0) (progn
     (setq dp		(Blech.get Fahnenbl dp)
           s_AT 	(Traeger.get Tr_ID  s)
           KlemmLng	(+ dp s_AT)
     )
     (Lochbild.set Lchb_ID (Klemml KlemmLng))
   )
   (progn
     (aendereFahnenBlechLochbilder dpAlt dpNeu)  
   ))
     
)


(defun aendereFahnenBlechLochbilder (dpAlt dpNeu)

  (setq xPos_HT (Connect.get CastaData xPos_HT))
  (setq gesKnoBlTyp 0) ; auf unknown setzen
  (if (= (connect.get CastaData amHtOberFlansch)  1)  (setq gesKnoBlTyp (+ _fahnbllochbild_ _oberflansch_)))
  (if (= (connect.get CastaData amHtUnterFlansch) 1)  (setq gesKnoBlTyp (+ _fahnbllochbild_ _unterflansch_)))


  (setq abtl_FaLb (Traeger.get Htrg firstAbtl Lochbild (- xPos_HT 0.5) (+ xPos_HT 0.5)))
  (while abtl_FaLb
  	(setq sType     (Anbauteil.get abtl_FaLb is_type gesKnoBlTyp))
  	(if (= sType 1) (progn
	    (print "FahnenBlechlochbild gefunden -----------------------------------------------------")
	    (print sType)
	    (setq LchbID (Anbauteil.get abtl_FaLb objekt Lochbild))
	    (setq alteKlemmLnge (Lochbild.get LchbID Klemml)
	    	  alt_dxSKopf   (Lochbild.get LchbID dxSKopf)
	    )
	    (Lochbild.set LchbID (Klemml  (+ alteKlemmLnge (- dpNeu dpAlt)))
	    			 (dxSKopf (+ alt_dxSKopf (- dpNeu dpAlt)))
	    )
	))
  	(setq abtl_FaLb (Traeger.get Htrg nextAbtl Lochbild))
  )

)

; Achtung, diese Funktion darf nicht ausgefhrt werden, wenn bereits ein Anschluss vorliegt.
; Ansonsten wrde man zwei Bleche bereinander erhalten.
(defun  insert_Zusatz_Steife  (Bl_ID)

    (setq SteifeSchonVorhanden 0)
	(sucheSteifenBlech)
	
    (if (= SteifeSchonVorhanden 0) (progn
		(Blech.showAttributes Bl_ID)

		(setq F_Steife (Blech.create))
		(Connect.storeAnschlObjs CastaData F_Steife)
		
		(setq dp (Blech.get Bl_ID dp)) 			(Blech.set F_Steife (dp dp))
		(setq bp (Blech.get Bl_ID bp)) 			(Blech.set F_Steife (bp (- bp 10)))
		(setq hp (- bp  20))							(Blech.set F_Steife (hp  hp))
		(setq xAsym (Blech.get Bl_ID xAsym))
		
		
		(setq Ablt_Fahne (Traeger.get HTrg ABTeil  Bl_ID))
		(setq xPos_Fahne (Anbauteil.get Ablt_Fahne xPos))
		(Traeger.addabtl  HTrg F_Steife  xPos_Fahne 0.0 _knotenblech_of_)

		(SteifenVerschiebung Bl_ID)
		
		; Chamfer einsetzen
		(if (= (Connect.get CastaData satr-lhtr)  -1) (Blech.set  F_Steife (x4 (* 0.8 hp)) (y4 (* 0.8 bp))))
		(if (= (Connect.get CastaData satr-lhtr)   1) (Blech.set  F_Steife (x1 (* 0.8 hp)) (y1 (* 0.8 bp))))
	))
   
)
(defun SteifenVerschiebung (Bl_ID)

	(setq dp_Fahne (Blech.get Bl_ID dp)) 
	(setq bp (Blech.get F_Steife bp)) 
	(setq hp (Blech.get F_Steife hp)) 
	(setq xAsym_Fahne (Blech.get Bl_ID xAsym))

	(setq Ablt_Stf (Traeger.get HTrg ABTeil  F_Steife))

	(setq dv_LaengsAmTrg  0)
	(if (= (Connect.get CastaData satr-lhtr-ex) 1)  (progn
		(setq xAsym_Fahne (- xAsym_Fahne))						; Das noch testen mit der Lage
		(setq dv_LaengsAmTrg  (+ (* 0.5  hp) (* 0.5 dp_Fahne) xAsym_Fahne))
	))
	(if (= (Connect.get CastaData satr-lhtr-ex) -1)  (progn
		(setq dv_LaengsAmTrg  (- (+ (* 0.5  hp) (* 0.5 dp_Fahne) xAsym_Fahne)))
	))
;	(Anbauteil.set  Ablt_Stf (delta_v  dv_LaengsAmTrg))
;	(Anbauteil.set  Ablt_Stf (delta_v  50))
	(Blech.set  F_Steife (dOK  dv_LaengsAmTrg))
	
)

(defun sucheSteifenBlech ()
  (setq xPos_HT (Connect.get CastaData xPos_HT))
  (setq gesKnoBlTyp 0) ; auf unknown setzen
  (setq SteifeSchonVorhanden 0)
  (setq Loop 1)
  ; Flansche gehen vor, weil es auch vorbeilaufende Trger gibt.
  ; Deswegen in dieser Reihenfolge. - Aber hier sollte noch ein Flag eingefhrt werden
  ; vorbeilaufend oder hnlich, damit der Fall eindeutig identifiziert wird.
  (if (= (connect.get CastaData amHtOberFlansch)  1)  (setq gesKnoBlTyp _knotenblech_of_))
  (if (= (connect.get CastaData amHtUnterFlansch) 1)  (setq gesKnoBlTyp _knotenblech_uf_))

  (setq abtl_StfBl (Traeger.get Htrg firstAbtl KnotenBlech (- xPos_HT 0.5) (+ xPos_HT 0.5)))
  (while abtl_StfBl
  	(setq sType     (Anbauteil.get abtl_StfBl is_type gesKnoBlTyp))
  	(if (= sType 1) (progn
	    (print "SteifenBlech gefunden -----------------------------------------------------")
	    (print sType)

;	    (showAbtlDaten abtl_StfBl)	;; nur zu Entwicklungszwecken

;	    (setq afl_wnkl (Connect.get CastaData at_laengswinkel))
		(if (= Loop 1) (progn
			(setq SteifenBlech_Gefunden (Anbauteil.get abtl_StfBl Objekt Blech))
			(setq xPosVorh (Anbauteil.get abtl_StfBl xPos))
		    (setq SteifeSchonVorhanden 1)
			(setq Loop 0)
		))
	))
  	(setq abtl_StfBl (Traeger.get Htrg nextAbtl KnotenBlech))
  )
;  (setq abtl_StfBl_T (Traeger.get Htrg firstAbtl SteifenBlech_Gefunden (- xPos_HT 0.1) (+ xPos_HT 0.1)))
;  (if (existObj SteifenBlech_Gefunden) (progn
;	  (if (existObj abtl_StfBl_T)
;	      (print  "OK - Objekt gefunden und passt");
;		  (setq SteifeSchonVorhanden 1)
;	  )
;  ))
)

(defun moveFahneAndStf_forK ()
	(setq 	b_AT (Traeger.get Tr_ID b)
			t_AT (Traeger.get Tr_ID t)
	)
	(setq s_Versatz (+ t_AT (* 0.5 b_AT)))
	; (Blech.set Fahnenbl (delta_LR s_Versatz))

	(if (= SteifeSchonVorhanden 0) (progn
		(setq curr_dOK (Blech.get F_Steife dOK))
		(setq s_Versatz_Stf (- curr_dOK (* 0.5 b_AT)))
		; (Blech.set  F_Steife (dOK s_Versatz_Stf))
	))

	(Lochbild.set lchbAtrgSteg (dlr_Coupon (* -0.5 b_AT)))
	
)